import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig, HttpRouteIntegration, PayloadFormatVersion, ParameterMapping } from '@aws-cdk/aws-apigatewayv2-alpha';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
/**
 * (experimental) Lambda Proxy integration properties.
 *
 * @experimental
 */
export interface HttpLambdaIntegrationProps {
    /**
     * (experimental) Version of the payload sent to the lambda handler.
     *
     * @default PayloadFormatVersion.VERSION_2_0
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    readonly payloadFormatVersion?: PayloadFormatVersion;
    /**
     * (experimental) Specifies how to transform HTTP requests before sending them to the backend.
     *
     * @default undefined requests are sent to the backend unmodified
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html
     * @experimental
     */
    readonly parameterMapping?: ParameterMapping;
}
/**
 * (experimental) The Lambda Proxy integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpLambdaIntegration extends HttpRouteIntegration {
    private readonly handler;
    private readonly props;
    private readonly _id;
    /**
     * @param id id of the underlying integration construct.
     * @param handler the Lambda handler to integrate with.
     * @param props properties to configure the integration.
     * @experimental
     */
    constructor(id: string, handler: IFunction, props?: HttpLambdaIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
