import * as acm from '@aws-cdk/aws-certificatemanager';
import { CfnVirtualNode } from './appmesh.generated';
import { Construct } from '@aws-cdk/core';
/**
 * A wrapper for the tls config returned by {@link TlsCertificate.bind}.
 *
 * @stability stable
 */
export interface TlsCertificateConfig {
    /**
     * The CFN shape for a TLS certificate.
     *
     * @stability stable
     */
    readonly tlsCertificate: CfnVirtualNode.ListenerTlsCertificateProperty;
}
/**
 * Represents a TLS certificate.
 *
 * @stability stable
 */
export declare abstract class TlsCertificate {
    /**
     * Returns an File TLS Certificate.
     *
     * @stability stable
     */
    static file(certificateChainPath: string, privateKeyPath: string): MutualTlsCertificate;
    /**
     * Returns an ACM TLS Certificate.
     *
     * @stability stable
     */
    static acm(certificate: acm.ICertificate): TlsCertificate;
    /**
     * Returns an SDS TLS Certificate.
     *
     * @stability stable
     */
    static sds(secretName: string): MutualTlsCertificate;
    /**
     * Returns TLS certificate based provider.
     *
     * @stability stable
     */
    abstract bind(_scope: Construct): TlsCertificateConfig;
}
/**
 * Represents a TLS certificate that is supported for mutual TLS authentication.
 *
 * @stability stable
 */
export declare abstract class MutualTlsCertificate extends TlsCertificate {
    /**
     * @stability stable
     */
    protected readonly differentiator = false;
}
