import * as cdk from '@aws-cdk/core';
import { CfnVirtualGateway, CfnVirtualNode } from './appmesh.generated';
import { TlsClientPolicy } from './tls-client-policy';
import { IVirtualService } from './virtual-service';
import { Construct } from '@aws-cdk/core';
/**
 * Represents timeouts for HTTP protocols.
 *
 * @stability stable
 */
export interface HttpTimeout {
    /**
     * Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @stability stable
     */
    readonly idle?: cdk.Duration;
    /**
     * Represents per request timeout.
     *
     * @default - 15 s
     * @stability stable
     */
    readonly perRequest?: cdk.Duration;
}
/**
 * Represents timeouts for GRPC protocols.
 *
 * @stability stable
 */
export interface GrpcTimeout {
    /**
     * Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @stability stable
     */
    readonly idle?: cdk.Duration;
    /**
     * Represents per request timeout.
     *
     * @default - 15 s
     * @stability stable
     */
    readonly perRequest?: cdk.Duration;
}
/**
 * Represents timeouts for TCP protocols.
 *
 * @stability stable
 */
export interface TcpTimeout {
    /**
     * Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @stability stable
     */
    readonly idle?: cdk.Duration;
}
/**
 * (deprecated) Enum of supported AppMesh protocols.
 *
 * @deprecated not for use outside package
 */
export declare enum Protocol {
    /**
     * @deprecated
     */
    HTTP = "http",
    /**
     * @deprecated
     */
    TCP = "tcp",
    /**
     * @deprecated
     */
    HTTP2 = "http2",
    /**
     * @deprecated
     */
    GRPC = "grpc"
}
/**
 * Represents the outlier detection for a listener.
 *
 * @stability stable
 */
export interface OutlierDetection {
    /**
     * The base amount of time for which a host is ejected.
     *
     * @stability stable
     */
    readonly baseEjectionDuration: cdk.Duration;
    /**
     * The time interval between ejection sweep analysis.
     *
     * @stability stable
     */
    readonly interval: cdk.Duration;
    /**
     * Maximum percentage of hosts in load balancing pool for upstream service that can be ejected.
     *
     * Will eject at
     * least one host regardless of the value.
     *
     * @stability stable
     */
    readonly maxEjectionPercent: number;
    /**
     * Number of consecutive 5xx errors required for ejection.
     *
     * @stability stable
     */
    readonly maxServerErrors: number;
}
/**
 * All Properties for Envoy Access logs for mesh endpoints.
 *
 * @stability stable
 */
export interface AccessLogConfig {
    /**
     * VirtualNode CFN configuration for Access Logging.
     *
     * @default - no access logging
     * @stability stable
     */
    readonly virtualNodeAccessLog?: CfnVirtualNode.AccessLogProperty;
    /**
     * VirtualGateway CFN configuration for Access Logging.
     *
     * @default - no access logging
     * @stability stable
     */
    readonly virtualGatewayAccessLog?: CfnVirtualGateway.VirtualGatewayAccessLogProperty;
}
/**
 * Configuration for Envoy Access logs for mesh endpoints.
 *
 * @stability stable
 */
export declare abstract class AccessLog {
    /**
     * Path to a file to write access logs to.
     *
     * @default - no file based access logging
     * @stability stable
     */
    static fromFilePath(filePath: string): AccessLog;
    /**
     * Called when the AccessLog type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity with future properties
     *
     * @stability stable
     */
    abstract bind(scope: Construct): AccessLogConfig;
}
/**
 * Represents the properties needed to define backend defaults.
 *
 * @stability stable
 */
export interface BackendDefaults {
    /**
     * TLS properties for Client policy for backend defaults.
     *
     * @default - none
     * @stability stable
     */
    readonly tlsClientPolicy?: TlsClientPolicy;
}
/**
 * Represents the properties needed to define a Virtual Service backend.
 *
 * @stability stable
 */
export interface VirtualServiceBackendOptions {
    /**
     * TLS properties for  Client policy for the backend.
     *
     * @default - none
     * @stability stable
     */
    readonly tlsClientPolicy?: TlsClientPolicy;
}
/**
 * Properties for a backend.
 *
 * @stability stable
 */
export interface BackendConfig {
    /**
     * Config for a Virtual Service backend.
     *
     * @stability stable
     */
    readonly virtualServiceBackend: CfnVirtualNode.BackendProperty;
}
/**
 * Contains static factory methods to create backends.
 *
 * @stability stable
 */
export declare abstract class Backend {
    /**
     * Construct a Virtual Service backend.
     *
     * @stability stable
     */
    static virtualService(virtualService: IVirtualService, props?: VirtualServiceBackendOptions): Backend;
    /**
     * Return backend config.
     *
     * @stability stable
     */
    abstract bind(_scope: Construct): BackendConfig;
}
/**
 * Connection pool properties for HTTP listeners.
 *
 * @stability stable
 */
export interface HttpConnectionPool {
    /**
     * The maximum connections in the pool.
     *
     * @default - none
     * @stability stable
     */
    readonly maxConnections: number;
    /**
     * The maximum pending requests in the pool.
     *
     * @default - none
     * @stability stable
     */
    readonly maxPendingRequests: number;
}
/**
 * Connection pool properties for TCP listeners.
 *
 * @stability stable
 */
export interface TcpConnectionPool {
    /**
     * The maximum connections in the pool.
     *
     * @default - none
     * @stability stable
     */
    readonly maxConnections: number;
}
/**
 * Connection pool properties for gRPC listeners.
 *
 * @stability stable
 */
export interface GrpcConnectionPool {
    /**
     * The maximum requests in the pool.
     *
     * @default - none
     * @stability stable
     */
    readonly maxRequests: number;
}
/**
 * Connection pool properties for HTTP2 listeners.
 *
 * @stability stable
 */
export interface Http2ConnectionPool {
    /**
     * The maximum requests in the pool.
     *
     * @default - none
     * @stability stable
     */
    readonly maxRequests: number;
}
