import { CfnRoute } from './appmesh.generated';
import { Construct } from '@aws-cdk/core';
/**
 * Configuration for `QueryParameterMatch`.
 *
 * @stability stable
 */
export interface QueryParameterMatchConfig {
    /**
     * Route CFN configuration for route query parameter match.
     *
     * @stability stable
     */
    readonly queryParameterMatch: CfnRoute.QueryParameterProperty;
}
/**
 * Used to generate query parameter matching methods.
 *
 * @stability stable
 */
export declare abstract class QueryParameterMatch {
    /**
     * The value of the query parameter with the given name in the request must match the specified value exactly.
     *
     * @param queryParameterName the name of the query parameter to match against.
     * @param queryParameterValue The exact value to test against.
     * @stability stable
     */
    static valueIs(queryParameterName: string, queryParameterValue: string): QueryParameterMatch;
    /**
     * Returns the query parameter match configuration.
     *
     * @stability stable
     */
    abstract bind(scope: Construct): QueryParameterMatchConfig;
}
