import { TlsCertificate } from './tls-certificate';
import { MutualTlsValidation } from './tls-validation';
/**
 * Enum of supported TLS modes.
 *
 * @stability stable
 */
export declare enum TlsMode {
    /**
     * Only accept encrypted traffic.
     *
     * @stability stable
     */
    STRICT = "STRICT",
    /**
     * Accept encrypted and plaintext traffic.
     *
     * @stability stable
     */
    PERMISSIVE = "PERMISSIVE",
    /**
     * TLS is disabled, only accept plaintext traffic.
     *
     * @stability stable
     */
    DISABLED = "DISABLED"
}
/**
 * Represents TLS properties for listener.
 *
 * @stability stable
 */
export interface ListenerTlsOptions {
    /**
     * Represents TLS certificate.
     *
     * @stability stable
     */
    readonly certificate: TlsCertificate;
    /**
     * The TLS mode.
     *
     * @stability stable
     */
    readonly mode: TlsMode;
    /**
     * Represents a listener's TLS validation context.
     *
     * The client certificate will only be validated if the client provides it, enabling mutual TLS.
     *
     * @default - client TLS certificate is not required
     * @stability stable
     */
    readonly mutualTlsValidation?: MutualTlsValidation;
}
