import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { GatewayRouteSpec } from './gateway-route-spec';
import { IVirtualGateway } from './virtual-gateway';
/**
 * Interface for which all GatewayRoute based classes MUST implement.
 *
 * @stability stable
 */
export interface IGatewayRoute extends cdk.IResource {
    /**
     * The name of the GatewayRoute.
     *
     * @stability stable
     * @attribute true
     */
    readonly gatewayRouteName: string;
    /**
     * The Amazon Resource Name (ARN) for the GatewayRoute.
     *
     * @stability stable
     * @attribute true
     */
    readonly gatewayRouteArn: string;
    /**
     * The VirtualGateway the GatewayRoute belongs to.
     *
     * @stability stable
     */
    readonly virtualGateway: IVirtualGateway;
}
/**
 * Basic configuration properties for a GatewayRoute.
 *
 * @stability stable
 */
export interface GatewayRouteBaseProps {
    /**
     * The name of the GatewayRoute.
     *
     * @default - an automatically generated name
     * @stability stable
     */
    readonly gatewayRouteName?: string;
    /**
     * What protocol the route uses.
     *
     * @stability stable
     */
    readonly routeSpec: GatewayRouteSpec;
}
/**
 * Properties to define a new GatewayRoute.
 *
 * @stability stable
 */
export interface GatewayRouteProps extends GatewayRouteBaseProps {
    /**
     * The VirtualGateway this GatewayRoute is associated with.
     *
     * @stability stable
     */
    readonly virtualGateway: IVirtualGateway;
}
/**
 * GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 * @stability stable
 */
export declare class GatewayRoute extends cdk.Resource implements IGatewayRoute {
    /**
     * Import an existing GatewayRoute given an ARN.
     *
     * @stability stable
     */
    static fromGatewayRouteArn(scope: Construct, id: string, gatewayRouteArn: string): IGatewayRoute;
    /**
     * Import an existing GatewayRoute given attributes.
     *
     * @stability stable
     */
    static fromGatewayRouteAttributes(scope: Construct, id: string, attrs: GatewayRouteAttributes): IGatewayRoute;
    /**
     * The name of the GatewayRoute.
     *
     * @stability stable
     */
    readonly gatewayRouteName: string;
    /**
     * The Amazon Resource Name (ARN) for the GatewayRoute.
     *
     * @stability stable
     */
    readonly gatewayRouteArn: string;
    /**
     * The VirtualGateway this GatewayRoute is a part of.
     *
     * @stability stable
     */
    readonly virtualGateway: IVirtualGateway;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: GatewayRouteProps);
}
/**
 * Interface with properties necessary to import a reusable GatewayRoute.
 *
 * @stability stable
 */
export interface GatewayRouteAttributes {
    /**
     * The name of the GatewayRoute.
     *
     * @stability stable
     */
    readonly gatewayRouteName: string;
    /**
     * The VirtualGateway this GatewayRoute is associated with.
     *
     * @stability stable
     */
    readonly virtualGateway: IVirtualGateway;
}
