# Example: Routing Monaco Grand Prix

This application simulates routing along the iconic Monaco Formula 1 Grand Prix circuit, providing key statistics for the track. As the Monaco GP is held on public streets, this unique route can be driven by anyone in their own car—giving you the chance to see how your driving time compares to the professionals!

The script calculates both the official track length and the practical driving length (based on street routing) and estimates the time it would take to drive the circuit at typical speeds. Are you up for the challenge? Can you beat the lap record?

Run:

```
python examples/routing_monaco_gp/monaco.py
```

Output:

```
=== Monaco Grand Prix Route Stats ===

🏁 Official F1 Track Length:  3,337 meters
🚗 Street Driving Length:     3,364 meters
⏱️ Estimated Driving Time:    13 minutes 6seconds (786 seconds)
🏎️ F1 Lap Record:             1:12.909 (73 seconds)

Can you beat the record? Give it a try and see how close you can get!
```
