# Open-source Distribution System State Estimation (Open-DSSE)

## 

## Load example circuits

In the library, there are distribution networks modeled in OpenDSS as shown in the following table:

**Table 1**. Test circuits inside the library
<table>****
  	<thead>
        <tr>
            <th>type_circuit</th>
            <th>case</th>
            <th>circuit</th>
	</thead>
    <tbody>
        <tr>
            <td rowspan="2">1ph </td>
            <td>1</td>
            <td> 4Node</td>
        </tr>
        <tr>
            <td>2</td>
            <td>15NodeIEEE</td>
        </tr>
        <tr>
            <td rowspan="2">SepPos </td>
            <td>1</td>
            <td> 13NodeIEEE</td>
        </tr>
        <tr>
            <td>2</td>
            <td>37nodeIEEE</td>
        </tr>
    </tbody>
</table>


[4Node]: /docs/4Node.png "Figure 1. 4 Node test circuit" 
![4 node test circuit (#ID) ][4Node] 
**Figure 1.** 4 Node test circuit


The ``Sample_tests()`` class must be initialized and returns a dictionary with the keys: ``DSS_file``, ``MEAS_init``, ``MEAS_file``, ``Save_path``, ``type_circuit``, and ``name_project``, as follows:

```Python
ex = Sample_tests()
circuit = ex.examples(Typ_cir='1ph', case=1)
```
The process is repeated for other circuits to be analyzed.

## Measurement file

The library can use conventional SCADA (Supervisory Control And Data Acquisition) system measurements such as node voltages ($\left| V_{i}\right|$), power flow ($PQ_{ft}$), and branch current magnitude ($\left| I_{ft}\right|$) obtained from HV/MV substation, reclosers or MV circuit breakers. In addition, injection measurements or flow consumption per phase from intelligent meters ($PQ_{i}^{SM}$), virtual or zero injection measurements ($PQ_{i}^{0}$) in passive nodes and having little availability of measures due to the large size of the network, artificial load measurements known as pseudo measurements ($PQ_{i}^{PSD}$) are used. Finally, distribution phasor measurement units (D-PMU or μPMU) can be voltage ($\left| V_{i}\right|\angle \theta $) or current ($\left| I_{ft}\right|\angle \delta  $).

### Modes of Use
The library acquires the electrical parameters and power flow results of the network, which is modeled in the free electrical network simulation software called OpenDSS and has two modes of use. 

In the first mode of study, the measurement information is created in a spreadsheet format generated by the library. The spreadsheet places all possible measurements that may participate in the DSSE and the user must enter the type, error percentage, and the status of the measurement (1: Status activated, 0: Status deactivated). It then considers the activated measurements and with the results of the OpenDSS power flow, adds a random error of normal distribution to them and assigns the corresponding standard deviation. 

**Example:**
A reference to the [4-Node test circuit][4Node]. First, the ``DSSE_algorithms`` class must be activated in this way:

```Python

# Load the 4-Node test circuit
ex = Sample_tests()
circuit = ex.examples(Typ_cir='1ph', case=1)

# Activate the class
Open_DSSE = DSSE_algorithms(
    DSS_file_address=circuit['DSS_file'],
    MEAS_file_address=circuit['MEAS_path'],
    path_save_results=circuit['Save_path'],
    type_circuit=circuit['Typ_cir'],
    name_project=circuit['name_project'])

# Create an empty file to enter the initial measurement data
Open_DSSE.generate_init_MEAS_files()
```

The file ``MEAS_file_format.xlsx``, is composed of four spreadsheets named ``Bus_i``, ``Elem_ft``, ``Bus_i_PMU``, and ``Elem_ft_PMU``.

**Bus_i:** The content of the ``bus_name``, ``num_nodes``, ``ph_1``, ``ph_2``, and ``ph_3`` columns comes from the network modeled in OpenDSS, so their content should not be changed.

| **Column name** |               **Description**               |
|:---------------:|:-------------------------------------------:|
|      DS_Vm      | The percentage error in voltage measurement |
|      STS_Vm     | 1: Enabled, 0: Disabled                     |
|      DS_PQd     | Percentage of injection power error at node |
|   STS_PQd(SM)   | Smart Meter (1: Enabled, 0: Disabled)       |
|    STS_PQd(0)   | Zero injection (1: Enabled, 0: Disabled)    |
|   STS_PQd(Psd)  | Pseudo-measurement (1: Enable, 0: Disabled) |

**Elem_ft:** The content of the ``element_name``, ``num_ph``, ``num_cond``, ``conn``, ``from_bus``, ``to_bus``, ``bus1``, ``bus2``, ``ph_1``, ``ph_2``, and ``ph_3``  columns comes from the network modeled in OpenDSS, so their content should not be changed.

| **Column name** |             **Description**             |
|:---------------:|:---------------------------------------:|
| DS_PQft         | Branch flow power error percentage      |
| STS_PQft        | 1: Enabled, 0: Disabled                 |
| DS_Ift          | Branch current error percentage         |
| STS_Ift         | 1: Enabled, 0: Disabled                 |


In the case of the **Bus_i_PMU** and **Elem_ft_PMU** spreadsheets, the voltage and current phasor meter columns:

| **Column name** 	|                **Description**               	|
|:---------------:	|:--------------------------------------------:	|
| DS_Vm           	| Percentage error of voltage phasor           	|
| STS_Vm          	| 1: Enabled, 0: Disabled                      	|
| DS_Ift          	| Percentage of error of branch current phasor 	|
| STS_Ift         	| 1: Enabled, 0: Disabled                      	|


For the 4-node test circuit:



In the second mode of use, where the location, type, standard deviation, and magnitude information of actual measurements are available, they are entered into the spreadsheet format and the algorithm is executed. 




