# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.4.2
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class OrderModify(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'action': 'str',
        'validity_res': 'ValidityRestriction',
        'validity_date': 'datetime',
        'type': 'OrderType',
        'txt': 'str',
        'ordr_exe_restriction': 'OrderExecutionRestriction',
        'quantity': 'float',
        'display_qty': 'float',
        'price': 'float',
        'cl_ordr_id': 'str',
        'ppd': 'float',
        'expected_net_pos': 'float',
        'expected_min_net_pos': 'float',
        'expected_max_net_pos': 'float',
        'expected_abs_pos': 'float',
        'expected_sell_abs_pos': 'float',
        'expected_buy_abs_pos': 'float'
    }

    attribute_map = {
        'action': 'action',
        'validity_res': 'validityRes',
        'validity_date': 'validityDate',
        'type': 'type',
        'txt': 'txt',
        'ordr_exe_restriction': 'ordrExeRestriction',
        'quantity': 'quantity',
        'display_qty': 'displayQty',
        'price': 'price',
        'cl_ordr_id': 'clOrdrId',
        'ppd': 'ppd',
        'expected_net_pos': 'expectedNetPos',
        'expected_min_net_pos': 'expectedMinNetPos',
        'expected_max_net_pos': 'expectedMaxNetPos',
        'expected_abs_pos': 'expectedAbsPos',
        'expected_sell_abs_pos': 'expectedSellAbsPos',
        'expected_buy_abs_pos': 'expectedBuyAbsPos'
    }

    def __init__(self, action=None, validity_res=None, validity_date=None, type=None, txt=None, ordr_exe_restriction=None, quantity=None, display_qty=None, price=None, cl_ordr_id=None, ppd=None, expected_net_pos=None, expected_min_net_pos=None, expected_max_net_pos=None, expected_abs_pos=None, expected_sell_abs_pos=None, expected_buy_abs_pos=None, local_vars_configuration=None):  # noqa: E501
        """OrderModify - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._action = None
        self._validity_res = None
        self._validity_date = None
        self._type = None
        self._txt = None
        self._ordr_exe_restriction = None
        self._quantity = None
        self._display_qty = None
        self._price = None
        self._cl_ordr_id = None
        self._ppd = None
        self._expected_net_pos = None
        self._expected_min_net_pos = None
        self._expected_max_net_pos = None
        self._expected_abs_pos = None
        self._expected_sell_abs_pos = None
        self._expected_buy_abs_pos = None
        self.discriminator = None

        self.action = action
        if validity_res is not None:
            self.validity_res = validity_res
        if validity_date is not None:
            self.validity_date = validity_date
        if type is not None:
            self.type = type
        if txt is not None:
            self.txt = txt
        if ordr_exe_restriction is not None:
            self.ordr_exe_restriction = ordr_exe_restriction
        if quantity is not None:
            self.quantity = quantity
        if display_qty is not None:
            self.display_qty = display_qty
        if price is not None:
            self.price = price
        if cl_ordr_id is not None:
            self.cl_ordr_id = cl_ordr_id
        if ppd is not None:
            self.ppd = ppd
        if expected_net_pos is not None:
            self.expected_net_pos = expected_net_pos
        if expected_min_net_pos is not None:
            self.expected_min_net_pos = expected_min_net_pos
        if expected_max_net_pos is not None:
            self.expected_max_net_pos = expected_max_net_pos
        if expected_abs_pos is not None:
            self.expected_abs_pos = expected_abs_pos
        if expected_sell_abs_pos is not None:
            self.expected_sell_abs_pos = expected_sell_abs_pos
        if expected_buy_abs_pos is not None:
            self.expected_buy_abs_pos = expected_buy_abs_pos

    @property
    def action(self):
        """Gets the action of this OrderModify.  # noqa: E501

        * ACTI: Activates the order. Ignored if already active. * DEAC: Deactivates (hibernates) the order. Hibernated orders are removed from the order book but are still available for modification or activation in the own orders list. * MODI: Modify the order * DELE: Delete the order  # noqa: E501

        :return: The action of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this OrderModify.

        * ACTI: Activates the order. Ignored if already active. * DEAC: Deactivates (hibernates) the order. Hibernated orders are removed from the order book but are still available for modification or activation in the own orders list. * MODI: Modify the order * DELE: Delete the order  # noqa: E501

        :param action: The action of this OrderModify.  # noqa: E501
        :type action: str
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        allowed_values = ["ACTI", "DEAC", "MODI", "DELE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and action not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def validity_res(self):
        """Gets the validity_res of this OrderModify.  # noqa: E501


        :return: The validity_res of this OrderModify.  # noqa: E501
        :rtype: ValidityRestriction
        """
        return self._validity_res

    @validity_res.setter
    def validity_res(self, validity_res):
        """Sets the validity_res of this OrderModify.


        :param validity_res: The validity_res of this OrderModify.  # noqa: E501
        :type validity_res: ValidityRestriction
        """

        self._validity_res = validity_res

    @property
    def validity_date(self):
        """Gets the validity_date of this OrderModify.  # noqa: E501

        Set this field, if you want to update the validity date of the order. Only mandatory in case of validityRes equals ?GTD?. It is used to define the date until which the order is valid. The remaining part of the order will be removed from the order book after this point in time.  # noqa: E501

        :return: The validity_date of this OrderModify.  # noqa: E501
        :rtype: datetime
        """
        return self._validity_date

    @validity_date.setter
    def validity_date(self, validity_date):
        """Sets the validity_date of this OrderModify.

        Set this field, if you want to update the validity date of the order. Only mandatory in case of validityRes equals ?GTD?. It is used to define the date until which the order is valid. The remaining part of the order will be removed from the order book after this point in time.  # noqa: E501

        :param validity_date: The validity_date of this OrderModify.  # noqa: E501
        :type validity_date: datetime
        """

        self._validity_date = validity_date

    @property
    def type(self):
        """Gets the type of this OrderModify.  # noqa: E501


        :return: The type of this OrderModify.  # noqa: E501
        :rtype: OrderType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OrderModify.


        :param type: The type of this OrderModify.  # noqa: E501
        :type type: OrderType
        """

        self._type = type

    @property
    def txt(self):
        """Gets the txt of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's 'custom text'  # noqa: E501

        :return: The txt of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._txt

    @txt.setter
    def txt(self, txt):
        """Sets the txt of this OrderModify.

        Set this field if you want to update the order's 'custom text'  # noqa: E501

        :param txt: The txt of this OrderModify.  # noqa: E501
        :type txt: str
        """
        if (self.local_vars_configuration.client_side_validation and
                txt is not None and len(txt) > 150):
            raise ValueError("Invalid value for `txt`, length must be less than or equal to `150`")  # noqa: E501

        self._txt = txt

    @property
    def ordr_exe_restriction(self):
        """Gets the ordr_exe_restriction of this OrderModify.  # noqa: E501


        :return: The ordr_exe_restriction of this OrderModify.  # noqa: E501
        :rtype: OrderExecutionRestriction
        """
        return self._ordr_exe_restriction

    @ordr_exe_restriction.setter
    def ordr_exe_restriction(self, ordr_exe_restriction):
        """Sets the ordr_exe_restriction of this OrderModify.


        :param ordr_exe_restriction: The ordr_exe_restriction of this OrderModify.  # noqa: E501
        :type ordr_exe_restriction: OrderExecutionRestriction
        """

        self._ordr_exe_restriction = ordr_exe_restriction

    @property
    def quantity(self):
        """Gets the quantity of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's quantity.  # noqa: E501

        :return: The quantity of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderModify.

        Set this field if you want to update the order's quantity.  # noqa: E501

        :param quantity: The quantity of this OrderModify.  # noqa: E501
        :type quantity: float
        """

        self._quantity = quantity

    @property
    def display_qty(self):
        """Gets the display_qty of this OrderModify.  # noqa: E501

        Set this field if you want to update the display quantity of an Iceberg Order. This field is required only in the case of type=?I?.  # noqa: E501

        :return: The display_qty of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._display_qty

    @display_qty.setter
    def display_qty(self, display_qty):
        """Sets the display_qty of this OrderModify.

        Set this field if you want to update the display quantity of an Iceberg Order. This field is required only in the case of type=?I?.  # noqa: E501

        :param display_qty: The display_qty of this OrderModify.  # noqa: E501
        :type display_qty: float
        """

        self._display_qty = display_qty

    @property
    def price(self):
        """Gets the price of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's description.  # noqa: E501

        :return: The price of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OrderModify.

        Set this field if you want to update the order's description.  # noqa: E501

        :param price: The price of this OrderModify.  # noqa: E501
        :type price: float
        """

        self._price = price

    @property
    def cl_ordr_id(self):
        """Gets the cl_ordr_id of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's client order id.  # noqa: E501

        :return: The cl_ordr_id of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._cl_ordr_id

    @cl_ordr_id.setter
    def cl_ordr_id(self, cl_ordr_id):
        """Sets the cl_ordr_id of this OrderModify.

        Set this field if you want to update the order's client order id.  # noqa: E501

        :param cl_ordr_id: The cl_ordr_id of this OrderModify.  # noqa: E501
        :type cl_ordr_id: str
        """
        if (self.local_vars_configuration.client_side_validation and
                cl_ordr_id is not None and len(cl_ordr_id) > 40):
            raise ValueError("Invalid value for `cl_ordr_id`, length must be less than or equal to `40`")  # noqa: E501

        self._cl_ordr_id = cl_ordr_id

    @property
    def ppd(self):
        """Gets the ppd of this OrderModify.  # noqa: E501

        Set this field if you want to update the Peak price delta for Iceberg orders. * The ppd of buy orders must be smaller or equal than zero. * The ppd of sell orders must be greater or equal than zero. If it is omitted the system will assume a value of ?0,00?.  # noqa: E501

        :return: The ppd of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._ppd

    @ppd.setter
    def ppd(self, ppd):
        """Sets the ppd of this OrderModify.

        Set this field if you want to update the Peak price delta for Iceberg orders. * The ppd of buy orders must be smaller or equal than zero. * The ppd of sell orders must be greater or equal than zero. If it is omitted the system will assume a value of ?0,00?.  # noqa: E501

        :param ppd: The ppd of this OrderModify.  # noqa: E501
        :type ppd: float
        """

        self._ppd = ppd

    @property
    def expected_net_pos(self):
        """Gets the expected_net_pos of this OrderModify.  # noqa: E501

        The expected net_pos (see portfolio information for more details). Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_net_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_net_pos

    @expected_net_pos.setter
    def expected_net_pos(self, expected_net_pos):
        """Sets the expected_net_pos of this OrderModify.

        The expected net_pos (see portfolio information for more details). Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_net_pos: The expected_net_pos of this OrderModify.  # noqa: E501
        :type expected_net_pos: float
        """

        self._expected_net_pos = expected_net_pos

    @property
    def expected_min_net_pos(self):
        """Gets the expected_min_net_pos of this OrderModify.  # noqa: E501

        The expected net_pos (see portfolio information for more details) plus the absolute quantity of all standing SELL-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_min_net_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_min_net_pos

    @expected_min_net_pos.setter
    def expected_min_net_pos(self, expected_min_net_pos):
        """Sets the expected_min_net_pos of this OrderModify.

        The expected net_pos (see portfolio information for more details) plus the absolute quantity of all standing SELL-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_min_net_pos: The expected_min_net_pos of this OrderModify.  # noqa: E501
        :type expected_min_net_pos: float
        """

        self._expected_min_net_pos = expected_min_net_pos

    @property
    def expected_max_net_pos(self):
        """Gets the expected_max_net_pos of this OrderModify.  # noqa: E501

        The expected net_pos (see portfolio information for more details) plus the absolute quantity of all standing BUY-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_max_net_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_max_net_pos

    @expected_max_net_pos.setter
    def expected_max_net_pos(self, expected_max_net_pos):
        """Sets the expected_max_net_pos of this OrderModify.

        The expected net_pos (see portfolio information for more details) plus the absolute quantity of all standing BUY-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_max_net_pos: The expected_max_net_pos of this OrderModify.  # noqa: E501
        :type expected_max_net_pos: float
        """

        self._expected_max_net_pos = expected_max_net_pos

    @property
    def expected_abs_pos(self):
        """Gets the expected_abs_pos of this OrderModify.  # noqa: E501

        The expected abs_pos (see portfolio information for more details). Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_abs_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_abs_pos

    @expected_abs_pos.setter
    def expected_abs_pos(self, expected_abs_pos):
        """Sets the expected_abs_pos of this OrderModify.

        The expected abs_pos (see portfolio information for more details). Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_abs_pos: The expected_abs_pos of this OrderModify.  # noqa: E501
        :type expected_abs_pos: float
        """

        self._expected_abs_pos = expected_abs_pos

    @property
    def expected_sell_abs_pos(self):
        """Gets the expected_sell_abs_pos of this OrderModify.  # noqa: E501

        The expected abs_pos (see portfolio information for more details) plus the absolute quantity of all standing SELL-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_sell_abs_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_sell_abs_pos

    @expected_sell_abs_pos.setter
    def expected_sell_abs_pos(self, expected_sell_abs_pos):
        """Sets the expected_sell_abs_pos of this OrderModify.

        The expected abs_pos (see portfolio information for more details) plus the absolute quantity of all standing SELL-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_sell_abs_pos: The expected_sell_abs_pos of this OrderModify.  # noqa: E501
        :type expected_sell_abs_pos: float
        """

        self._expected_sell_abs_pos = expected_sell_abs_pos

    @property
    def expected_buy_abs_pos(self):
        """Gets the expected_buy_abs_pos of this OrderModify.  # noqa: E501

        The expected abs_pos (see portfolio information for more details) plus the absolute quantity of all standing BUY-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :return: The expected_buy_abs_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_buy_abs_pos

    @expected_buy_abs_pos.setter
    def expected_buy_abs_pos(self, expected_buy_abs_pos):
        """Sets the expected_buy_abs_pos of this OrderModify.

        The expected abs_pos (see portfolio information for more details) plus the absolute quantity of all standing BUY-Orders for the respective contract. Optional safety feature to mitigate race conditions if client and backend data are not in sync. Do not use this field for block products.  # noqa: E501

        :param expected_buy_abs_pos: The expected_buy_abs_pos of this OrderModify.  # noqa: E501
        :type expected_buy_abs_pos: float
        """

        self._expected_buy_abs_pos = expected_buy_abs_pos

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderModify):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrderModify):
            return True

        return self.to_dict() != other.to_dict()
