# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.4.2
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class OrderBookEntry(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'order_id': 'str',
        'delivery_area': 'str',
        'contract_id': 'str',
        'order_entry_time': 'datetime',
        'price': 'float',
        'quantity': 'float',
        'exe_restriction': 'str',
        'type': 'str',
        'own_order': 'bool'
    }

    attribute_map = {
        'order_id': 'order_id',
        'delivery_area': 'delivery_area',
        'contract_id': 'contract_id',
        'order_entry_time': 'order_entry_time',
        'price': 'price',
        'quantity': 'quantity',
        'exe_restriction': 'exeRestriction',
        'type': 'type',
        'own_order': 'own_order'
    }

    def __init__(self, order_id=None, delivery_area=None, contract_id=None, order_entry_time=None, price=None, quantity=None, exe_restriction=None, type=None, own_order=None, local_vars_configuration=None):  # noqa: E501
        """OrderBookEntry - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._order_id = None
        self._delivery_area = None
        self._contract_id = None
        self._order_entry_time = None
        self._price = None
        self._quantity = None
        self._exe_restriction = None
        self._type = None
        self._own_order = None
        self.discriminator = None

        if order_id is not None:
            self.order_id = order_id
        if delivery_area is not None:
            self.delivery_area = delivery_area
        if contract_id is not None:
            self.contract_id = contract_id
        if order_entry_time is not None:
            self.order_entry_time = order_entry_time
        if price is not None:
            self.price = price
        if quantity is not None:
            self.quantity = quantity
        if exe_restriction is not None:
            self.exe_restriction = exe_restriction
        if type is not None:
            self.type = type
        if own_order is not None:
            self.own_order = own_order

    @property
    def order_id(self):
        """Gets the order_id of this OrderBookEntry.  # noqa: E501


        :return: The order_id of this OrderBookEntry.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this OrderBookEntry.


        :param order_id: The order_id of this OrderBookEntry.  # noqa: E501
        :type order_id: str
        """

        self._order_id = order_id

    @property
    def delivery_area(self):
        """Gets the delivery_area of this OrderBookEntry.  # noqa: E501


        :return: The delivery_area of this OrderBookEntry.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this OrderBookEntry.


        :param delivery_area: The delivery_area of this OrderBookEntry.  # noqa: E501
        :type delivery_area: str
        """

        self._delivery_area = delivery_area

    @property
    def contract_id(self):
        """Gets the contract_id of this OrderBookEntry.  # noqa: E501


        :return: The contract_id of this OrderBookEntry.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this OrderBookEntry.


        :param contract_id: The contract_id of this OrderBookEntry.  # noqa: E501
        :type contract_id: str
        """

        self._contract_id = contract_id

    @property
    def order_entry_time(self):
        """Gets the order_entry_time of this OrderBookEntry.  # noqa: E501


        :return: The order_entry_time of this OrderBookEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._order_entry_time

    @order_entry_time.setter
    def order_entry_time(self, order_entry_time):
        """Sets the order_entry_time of this OrderBookEntry.


        :param order_entry_time: The order_entry_time of this OrderBookEntry.  # noqa: E501
        :type order_entry_time: datetime
        """

        self._order_entry_time = order_entry_time

    @property
    def price(self):
        """Gets the price of this OrderBookEntry.  # noqa: E501


        :return: The price of this OrderBookEntry.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OrderBookEntry.


        :param price: The price of this OrderBookEntry.  # noqa: E501
        :type price: float
        """

        self._price = price

    @property
    def quantity(self):
        """Gets the quantity of this OrderBookEntry.  # noqa: E501


        :return: The quantity of this OrderBookEntry.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderBookEntry.


        :param quantity: The quantity of this OrderBookEntry.  # noqa: E501
        :type quantity: float
        """

        self._quantity = quantity

    @property
    def exe_restriction(self):
        """Gets the exe_restriction of this OrderBookEntry.  # noqa: E501


        :return: The exe_restriction of this OrderBookEntry.  # noqa: E501
        :rtype: str
        """
        return self._exe_restriction

    @exe_restriction.setter
    def exe_restriction(self, exe_restriction):
        """Sets the exe_restriction of this OrderBookEntry.


        :param exe_restriction: The exe_restriction of this OrderBookEntry.  # noqa: E501
        :type exe_restriction: str
        """

        self._exe_restriction = exe_restriction

    @property
    def type(self):
        """Gets the type of this OrderBookEntry.  # noqa: E501


        :return: The type of this OrderBookEntry.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OrderBookEntry.


        :param type: The type of this OrderBookEntry.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def own_order(self):
        """Gets the own_order of this OrderBookEntry.  # noqa: E501

        True if the order belongs to the active exchange user. Only present for active orders.  # noqa: E501

        :return: The own_order of this OrderBookEntry.  # noqa: E501
        :rtype: bool
        """
        return self._own_order

    @own_order.setter
    def own_order(self, own_order):
        """Sets the own_order of this OrderBookEntry.

        True if the order belongs to the active exchange user. Only present for active orders.  # noqa: E501

        :param own_order: The own_order of this OrderBookEntry.  # noqa: E501
        :type own_order: bool
        """

        self._own_order = own_order

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderBookEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrderBookEntry):
            return True

        return self.to_dict() != other.to_dict()
