# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.4.2
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class MarketOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'internal_trading': 'str',
        'internal_trading_cross_area': 'bool',
        'internal_trading_cross_area_lead_time': 'int',
        'default_delivery_area_id': 'str',
        'restrict_safe_mode': 'bool'
    }

    attribute_map = {
        'internal_trading': 'internal_trading',
        'internal_trading_cross_area': 'internal_trading_cross_area',
        'internal_trading_cross_area_lead_time': 'internal_trading_cross_area_lead_time',
        'default_delivery_area_id': 'default_delivery_area_id',
        'restrict_safe_mode': 'restrict_safe_mode'
    }

    def __init__(self, internal_trading=None, internal_trading_cross_area=False, internal_trading_cross_area_lead_time=None, default_delivery_area_id=None, restrict_safe_mode=False, local_vars_configuration=None):  # noqa: E501
        """MarketOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._internal_trading = None
        self._internal_trading_cross_area = None
        self._internal_trading_cross_area_lead_time = None
        self._default_delivery_area_id = None
        self._restrict_safe_mode = None
        self.discriminator = None

        if internal_trading is not None:
            self.internal_trading = internal_trading
        if internal_trading_cross_area is not None:
            self.internal_trading_cross_area = internal_trading_cross_area
        if internal_trading_cross_area_lead_time is not None:
            self.internal_trading_cross_area_lead_time = internal_trading_cross_area_lead_time
        if default_delivery_area_id is not None:
            self.default_delivery_area_id = default_delivery_area_id
        if restrict_safe_mode is not None:
            self.restrict_safe_mode = restrict_safe_mode

    @property
    def internal_trading(self):
        """Gets the internal_trading of this MarketOptions.  # noqa: E501


        :return: The internal_trading of this MarketOptions.  # noqa: E501
        :rtype: str
        """
        return self._internal_trading

    @internal_trading.setter
    def internal_trading(self, internal_trading):
        """Sets the internal_trading of this MarketOptions.


        :param internal_trading: The internal_trading of this MarketOptions.  # noqa: E501
        :type internal_trading: str
        """
        allowed_values = ["inactive", "default_yes", "default_no"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and internal_trading not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `internal_trading` ({0}), must be one of {1}"  # noqa: E501
                .format(internal_trading, allowed_values)
            )

        self._internal_trading = internal_trading

    @property
    def internal_trading_cross_area(self):
        """Gets the internal_trading_cross_area of this MarketOptions.  # noqa: E501

        German delivery areas have unlimited cross border capacities before entering `SDAT` mode. If this setting is set to              true, then the German delivery areas will be treated as one area when matching internal trades during the `CONT` trading phase.              **Note**: NordPool does not report a contract's trading phase, so internal cross delivery trading area stays active until the lead time limit is reached.   # noqa: E501

        :return: The internal_trading_cross_area of this MarketOptions.  # noqa: E501
        :rtype: bool
        """
        return self._internal_trading_cross_area

    @internal_trading_cross_area.setter
    def internal_trading_cross_area(self, internal_trading_cross_area):
        """Sets the internal_trading_cross_area of this MarketOptions.

        German delivery areas have unlimited cross border capacities before entering `SDAT` mode. If this setting is set to              true, then the German delivery areas will be treated as one area when matching internal trades during the `CONT` trading phase.              **Note**: NordPool does not report a contract's trading phase, so internal cross delivery trading area stays active until the lead time limit is reached.   # noqa: E501

        :param internal_trading_cross_area: The internal_trading_cross_area of this MarketOptions.  # noqa: E501
        :type internal_trading_cross_area: bool
        """

        self._internal_trading_cross_area = internal_trading_cross_area

    @property
    def internal_trading_cross_area_lead_time(self):
        """Gets the internal_trading_cross_area_lead_time of this MarketOptions.  # noqa: E501

        The time (in minutes) before a contract's delivery start, after which cross area matching gets disabled.              If this option is set to '0', then cross area matching is enabled as long as a contract is in the trading phase `CONT`.              Independent of this setting, cross area matching is only active during the `CONT` trading phase.              **Note**: NordPool does not report a contract's trading phase, so only the lead time determines if internal cross area trading should take place.   # noqa: E501

        :return: The internal_trading_cross_area_lead_time of this MarketOptions.  # noqa: E501
        :rtype: int
        """
        return self._internal_trading_cross_area_lead_time

    @internal_trading_cross_area_lead_time.setter
    def internal_trading_cross_area_lead_time(self, internal_trading_cross_area_lead_time):
        """Sets the internal_trading_cross_area_lead_time of this MarketOptions.

        The time (in minutes) before a contract's delivery start, after which cross area matching gets disabled.              If this option is set to '0', then cross area matching is enabled as long as a contract is in the trading phase `CONT`.              Independent of this setting, cross area matching is only active during the `CONT` trading phase.              **Note**: NordPool does not report a contract's trading phase, so only the lead time determines if internal cross area trading should take place.   # noqa: E501

        :param internal_trading_cross_area_lead_time: The internal_trading_cross_area_lead_time of this MarketOptions.  # noqa: E501
        :type internal_trading_cross_area_lead_time: int
        """
        if (self.local_vars_configuration.client_side_validation and
                internal_trading_cross_area_lead_time is not None and internal_trading_cross_area_lead_time < 0):  # noqa: E501
            raise ValueError("Invalid value for `internal_trading_cross_area_lead_time`, must be a value greater than or equal to `0`")  # noqa: E501

        self._internal_trading_cross_area_lead_time = internal_trading_cross_area_lead_time

    @property
    def default_delivery_area_id(self):
        """Gets the default_delivery_area_id of this MarketOptions.  # noqa: E501

        In multi-area configurations, set this option in case you want a default delivery area  # noqa: E501

        :return: The default_delivery_area_id of this MarketOptions.  # noqa: E501
        :rtype: str
        """
        return self._default_delivery_area_id

    @default_delivery_area_id.setter
    def default_delivery_area_id(self, default_delivery_area_id):
        """Sets the default_delivery_area_id of this MarketOptions.

        In multi-area configurations, set this option in case you want a default delivery area  # noqa: E501

        :param default_delivery_area_id: The default_delivery_area_id of this MarketOptions.  # noqa: E501
        :type default_delivery_area_id: str
        """

        self._default_delivery_area_id = default_delivery_area_id

    @property
    def restrict_safe_mode(self):
        """Gets the restrict_safe_mode of this MarketOptions.  # noqa: E501

        restrict switching market mode to the master API key  # noqa: E501

        :return: The restrict_safe_mode of this MarketOptions.  # noqa: E501
        :rtype: bool
        """
        return self._restrict_safe_mode

    @restrict_safe_mode.setter
    def restrict_safe_mode(self, restrict_safe_mode):
        """Sets the restrict_safe_mode of this MarketOptions.

        restrict switching market mode to the master API key  # noqa: E501

        :param restrict_safe_mode: The restrict_safe_mode of this MarketOptions.  # noqa: E501
        :type restrict_safe_mode: bool
        """

        self._restrict_safe_mode = restrict_safe_mode

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MarketOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MarketOptions):
            return True

        return self.to_dict() != other.to_dict()
