# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.4.2
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class AlgoDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'algo_id': 'str',
        'algo_name': 'str',
        'algo_description': 'str',
        'require_heartbeat_every_seconds': 'int',
        'on_missing_heartbeat': 'OnMissingHeartbeat',
        'image': 'str',
        'instances': 'list[AlgoInstance]'
    }

    attribute_map = {
        'algo_id': 'algo_id',
        'algo_name': 'algo_name',
        'algo_description': 'algo_description',
        'require_heartbeat_every_seconds': 'require_heartbeat_every_seconds',
        'on_missing_heartbeat': 'on_missing_heartbeat',
        'image': 'image',
        'instances': 'instances'
    }

    def __init__(self, algo_id=None, algo_name=None, algo_description=None, require_heartbeat_every_seconds=None, on_missing_heartbeat=None, image=None, instances=None, local_vars_configuration=None):  # noqa: E501
        """AlgoDetails - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._algo_id = None
        self._algo_name = None
        self._algo_description = None
        self._require_heartbeat_every_seconds = None
        self._on_missing_heartbeat = None
        self._image = None
        self._instances = None
        self.discriminator = None

        if algo_id is not None:
            self.algo_id = algo_id
        if algo_name is not None:
            self.algo_name = algo_name
        if algo_description is not None:
            self.algo_description = algo_description
        if require_heartbeat_every_seconds is not None:
            self.require_heartbeat_every_seconds = require_heartbeat_every_seconds
        if on_missing_heartbeat is not None:
            self.on_missing_heartbeat = on_missing_heartbeat
        if image is not None:
            self.image = image
        if instances is not None:
            self.instances = instances

    @property
    def algo_id(self):
        """Gets the algo_id of this AlgoDetails.  # noqa: E501

        The id of the algorithm  # noqa: E501

        :return: The algo_id of this AlgoDetails.  # noqa: E501
        :rtype: str
        """
        return self._algo_id

    @algo_id.setter
    def algo_id(self, algo_id):
        """Sets the algo_id of this AlgoDetails.

        The id of the algorithm  # noqa: E501

        :param algo_id: The algo_id of this AlgoDetails.  # noqa: E501
        :type algo_id: str
        """

        self._algo_id = algo_id

    @property
    def algo_name(self):
        """Gets the algo_name of this AlgoDetails.  # noqa: E501

        The name of the algorithm  # noqa: E501

        :return: The algo_name of this AlgoDetails.  # noqa: E501
        :rtype: str
        """
        return self._algo_name

    @algo_name.setter
    def algo_name(self, algo_name):
        """Sets the algo_name of this AlgoDetails.

        The name of the algorithm  # noqa: E501

        :param algo_name: The algo_name of this AlgoDetails.  # noqa: E501
        :type algo_name: str
        """

        self._algo_name = algo_name

    @property
    def algo_description(self):
        """Gets the algo_description of this AlgoDetails.  # noqa: E501

        The description of the algorithm  # noqa: E501

        :return: The algo_description of this AlgoDetails.  # noqa: E501
        :rtype: str
        """
        return self._algo_description

    @algo_description.setter
    def algo_description(self, algo_description):
        """Sets the algo_description of this AlgoDetails.

        The description of the algorithm  # noqa: E501

        :param algo_description: The algo_description of this AlgoDetails.  # noqa: E501
        :type algo_description: str
        """

        self._algo_description = algo_description

    @property
    def require_heartbeat_every_seconds(self):
        """Gets the require_heartbeat_every_seconds of this AlgoDetails.  # noqa: E501

        Information on how often the heartbeat requires a heartbeat  # noqa: E501

        :return: The require_heartbeat_every_seconds of this AlgoDetails.  # noqa: E501
        :rtype: int
        """
        return self._require_heartbeat_every_seconds

    @require_heartbeat_every_seconds.setter
    def require_heartbeat_every_seconds(self, require_heartbeat_every_seconds):
        """Sets the require_heartbeat_every_seconds of this AlgoDetails.

        Information on how often the heartbeat requires a heartbeat  # noqa: E501

        :param require_heartbeat_every_seconds: The require_heartbeat_every_seconds of this AlgoDetails.  # noqa: E501
        :type require_heartbeat_every_seconds: int
        """

        self._require_heartbeat_every_seconds = require_heartbeat_every_seconds

    @property
    def on_missing_heartbeat(self):
        """Gets the on_missing_heartbeat of this AlgoDetails.  # noqa: E501


        :return: The on_missing_heartbeat of this AlgoDetails.  # noqa: E501
        :rtype: OnMissingHeartbeat
        """
        return self._on_missing_heartbeat

    @on_missing_heartbeat.setter
    def on_missing_heartbeat(self, on_missing_heartbeat):
        """Sets the on_missing_heartbeat of this AlgoDetails.


        :param on_missing_heartbeat: The on_missing_heartbeat of this AlgoDetails.  # noqa: E501
        :type on_missing_heartbeat: OnMissingHeartbeat
        """

        self._on_missing_heartbeat = on_missing_heartbeat

    @property
    def image(self):
        """Gets the image of this AlgoDetails.  # noqa: E501

        The image of the algorithm, this can be any valid docker image name with a tag. The tag can not be \"latest\" to avoid accidental upgrades.  # noqa: E501

        :return: The image of this AlgoDetails.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this AlgoDetails.

        The image of the algorithm, this can be any valid docker image name with a tag. The tag can not be \"latest\" to avoid accidental upgrades.  # noqa: E501

        :param image: The image of this AlgoDetails.  # noqa: E501
        :type image: str
        """

        self._image = image

    @property
    def instances(self):
        """Gets the instances of this AlgoDetails.  # noqa: E501

        Returns the running and recently exited / stale instances  # noqa: E501

        :return: The instances of this AlgoDetails.  # noqa: E501
        :rtype: list[AlgoInstance]
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """Sets the instances of this AlgoDetails.

        Returns the running and recently exited / stale instances  # noqa: E501

        :param instances: The instances of this AlgoDetails.  # noqa: E501
        :type instances: list[AlgoInstance]
        """

        self._instances = instances

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AlgoDetails):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AlgoDetails):
            return True

        return self.to_dict() != other.to_dict()
