# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.4.2
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient
from powerbot_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrdersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_order(self, order, **kwargs):  # noqa: E501
        """Add order  # noqa: E501

        Allows you to place a new buy or sell order at the market. The method will return an order element that will include the order_id if the order has been placed.  This request requires a lot of parameters which are required by the exchange system. In any case, you will need order type (O = regular order), side (BUY/SELL), contract_id, quantity, price, order execution restriction (NON for regular order) and validity restriction (GFS for regular order = good for session) as well as a delivery_area (if not set default by the system) and a portfolio id. Use txt to store up to 150 spaces of individual text in the order. Please consult the documentation on details about the order parameters.  The parameter internal_trading allows you to control if the order should be matched internally if a cross-trade is recognized. Leave blank for system default (either set \"default_yes\" or \"default_no\" in market options). If internal_trading is deactivated in market options with the value \"inactive\", cross-trade recognition is completely turned off.  Orders can also be added without a particular contract_id, in this case you have to specify the delivery_start and delivery_end of the contract the order should be placed for.  The parameters \"expectedNetPos\", \"expectedMaxNetPos\" and \"expectedMinNetPos\" can help you make sure that the server has the same information as you have. This will guarantee you are not acting based upon outdated information. Each contract has a NetPos (net_position) in Megawatt, which represents the current position. By providing a value for the parameter \"expectedNetPos\", the server will check if the net_position at the market is equal to your value. If not, it will decline your request, because you are not acting on latest information (this usually means that your position at the market has changed while you were calculating and sent the new orders). The parameters \"expectedMaxNetPos\" and \"expectedMinNetPos\" work the same, but also take standing orders into account. For further details see documenation.  Note that the expected net position parameters should not be used in combination with block products.  Please be aware that this method is deprecated and the request is always returning only one order, even if multiple orders are effected.  Use POST/orders/list instead.  Please be aware that the header of the return element includes a property namend \"X-Total-Internal-Trades\", which tells you the number of internal trades that were involved in this request, if cross-trades were processed.  Please note that the response of an order placement is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order placement and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_order(order, async_req=True)
        >>> result = thread.get()

        :param order: (required)
        :type order: OrderEntry
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange (if internal trading is not set to inactive in market options). Set it to false if you don't want internal trading. If left blank, default market options will apply.  Note: There is no cross-trade recognition for user defined block orders and for iceberg-orders with a peak-price-delta. 
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation wont be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value. Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect. 
        :type fail_on_limit_violations: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OwnOrder
        """
        kwargs['_return_http_data_only'] = True
        return self.add_order_with_http_info(order, **kwargs)  # noqa: E501

    def add_order_with_http_info(self, order, **kwargs):  # noqa: E501
        """Add order  # noqa: E501

        Allows you to place a new buy or sell order at the market. The method will return an order element that will include the order_id if the order has been placed.  This request requires a lot of parameters which are required by the exchange system. In any case, you will need order type (O = regular order), side (BUY/SELL), contract_id, quantity, price, order execution restriction (NON for regular order) and validity restriction (GFS for regular order = good for session) as well as a delivery_area (if not set default by the system) and a portfolio id. Use txt to store up to 150 spaces of individual text in the order. Please consult the documentation on details about the order parameters.  The parameter internal_trading allows you to control if the order should be matched internally if a cross-trade is recognized. Leave blank for system default (either set \"default_yes\" or \"default_no\" in market options). If internal_trading is deactivated in market options with the value \"inactive\", cross-trade recognition is completely turned off.  Orders can also be added without a particular contract_id, in this case you have to specify the delivery_start and delivery_end of the contract the order should be placed for.  The parameters \"expectedNetPos\", \"expectedMaxNetPos\" and \"expectedMinNetPos\" can help you make sure that the server has the same information as you have. This will guarantee you are not acting based upon outdated information. Each contract has a NetPos (net_position) in Megawatt, which represents the current position. By providing a value for the parameter \"expectedNetPos\", the server will check if the net_position at the market is equal to your value. If not, it will decline your request, because you are not acting on latest information (this usually means that your position at the market has changed while you were calculating and sent the new orders). The parameters \"expectedMaxNetPos\" and \"expectedMinNetPos\" work the same, but also take standing orders into account. For further details see documenation.  Note that the expected net position parameters should not be used in combination with block products.  Please be aware that this method is deprecated and the request is always returning only one order, even if multiple orders are effected.  Use POST/orders/list instead.  Please be aware that the header of the return element includes a property namend \"X-Total-Internal-Trades\", which tells you the number of internal trades that were involved in this request, if cross-trades were processed.  Please note that the response of an order placement is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order placement and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_order_with_http_info(order, async_req=True)
        >>> result = thread.get()

        :param order: (required)
        :type order: OrderEntry
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange (if internal trading is not set to inactive in market options). Set it to false if you don't want internal trading. If left blank, default market options will apply.  Note: There is no cross-trade recognition for user defined block orders and for iceberg-orders with a peak-price-delta. 
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation wont be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value. Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect. 
        :type fail_on_limit_violations: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OwnOrder, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'order',
            'internal_trading',
            'fail_on_limit_violations'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and ('order' not in local_var_params or  # noqa: E501
                                                        local_var_params['order'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order` when calling `add_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'internal_trading' in local_var_params and local_var_params['internal_trading'] is not None:  # noqa: E501
            query_params.append(('internal_trading', local_var_params['internal_trading']))  # noqa: E501
        if 'fail_on_limit_violations' in local_var_params and local_var_params['fail_on_limit_violations'] is not None:  # noqa: E501
            query_params.append(('fail_on_limit_violations', local_var_params['fail_on_limit_violations']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in local_var_params:
            body_params = local_var_params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "OwnOrder",
        }

        return self.api_client.call_api(
            '/orders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_orders(self, order, **kwargs):  # noqa: E501
        """Place multiple orders  # noqa: E501

        Allows you to place a list of orders at once. For each requested order, one response element is generated. In case of success, an order element for each order is returned, otherwise an error message is returned. If the placed orders interact with previously placed own orders, even in other portfolios, it also returns the changes made to these orders. For further details on order elements please see the description of POST /orders.  When sending a list of orders, the list needs to have execution instructions being either \"valid\" (default) or linked. Please be aware that each order needs to be valid, otherwise all orders are declined by the exchange system. Please see documentation for further details.  The header of the return element includes a property named \"X-Total-Internal-Trades\", which tells you the number of internal trades that were involved in this request, if cross-trades were executed as internal trades.  Note that the expected net position parameters should not be used in combination with block products.  Please note that the response of an order placement is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order placement and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_orders(order, async_req=True)
        >>> result = thread.get()

        :param order: (required)
        :type order: list[OrderEntry]
        :param exec_instruction: Defines the execution instruction for the whole list of orders:   * **VALID**: default. All orders must be valid, meaning they must pass the order validation of the exchange system (e.g. the price of the order must be in the price range of the product). If one order does not pass the validation, the full list of submitted orders is rejected.   * **LNKD**: Linked orders - the provided orders are linked together and should be executed all at once. This option can only be used if all orders have the same product and the execution restriction FOK (Fill-or-Kill). In case one of the orders cannot be executed, the whole list is not executed by the exchange.
        :type exec_instruction: str
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange (if internal trading is activated in market options). Set it to false if you don't want internal trading. If left blank, default market options will apply.  Note: There is no cross-trade recognition for user defined block orders and for iceberg-orders with a peak-price-delta. 
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation wont be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value. Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect. 
        :type fail_on_limit_violations: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.add_orders_with_http_info(order, **kwargs)  # noqa: E501

    def add_orders_with_http_info(self, order, **kwargs):  # noqa: E501
        """Place multiple orders  # noqa: E501

        Allows you to place a list of orders at once. For each requested order, one response element is generated. In case of success, an order element for each order is returned, otherwise an error message is returned. If the placed orders interact with previously placed own orders, even in other portfolios, it also returns the changes made to these orders. For further details on order elements please see the description of POST /orders.  When sending a list of orders, the list needs to have execution instructions being either \"valid\" (default) or linked. Please be aware that each order needs to be valid, otherwise all orders are declined by the exchange system. Please see documentation for further details.  The header of the return element includes a property named \"X-Total-Internal-Trades\", which tells you the number of internal trades that were involved in this request, if cross-trades were executed as internal trades.  Note that the expected net position parameters should not be used in combination with block products.  Please note that the response of an order placement is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order placement and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_orders_with_http_info(order, async_req=True)
        >>> result = thread.get()

        :param order: (required)
        :type order: list[OrderEntry]
        :param exec_instruction: Defines the execution instruction for the whole list of orders:   * **VALID**: default. All orders must be valid, meaning they must pass the order validation of the exchange system (e.g. the price of the order must be in the price range of the product). If one order does not pass the validation, the full list of submitted orders is rejected.   * **LNKD**: Linked orders - the provided orders are linked together and should be executed all at once. This option can only be used if all orders have the same product and the execution restriction FOK (Fill-or-Kill). In case one of the orders cannot be executed, the whole list is not executed by the exchange.
        :type exec_instruction: str
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange (if internal trading is activated in market options). Set it to false if you don't want internal trading. If left blank, default market options will apply.  Note: There is no cross-trade recognition for user defined block orders and for iceberg-orders with a peak-price-delta. 
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation wont be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value. Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect. 
        :type fail_on_limit_violations: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'order',
            'exec_instruction',
            'internal_trading',
            'fail_on_limit_violations'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and ('order' not in local_var_params or  # noqa: E501
                                                        local_var_params['order'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order` when calling `add_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'exec_instruction' in local_var_params and local_var_params['exec_instruction'] is not None:  # noqa: E501
            query_params.append(('exec_instruction', local_var_params['exec_instruction']))  # noqa: E501
        if 'internal_trading' in local_var_params and local_var_params['internal_trading'] is not None:  # noqa: E501
            query_params.append(('internal_trading', local_var_params['internal_trading']))  # noqa: E501
        if 'fail_on_limit_violations' in local_var_params and local_var_params['fail_on_limit_violations'] is not None:  # noqa: E501
            query_params.append(('fail_on_limit_violations', local_var_params['fail_on_limit_violations']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in local_var_params:
            body_params = local_var_params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
        }

        return self.api_client.call_api(
            '/orders/list', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_orders(self, **kwargs):  # noqa: E501
        """Delete all orders  # noqa: E501

        Allows you to delete all orders of a portfolio  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_orders(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param delivery_areas:
        :type delivery_areas: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_orders_with_http_info(**kwargs)  # noqa: E501

    def delete_orders_with_http_info(self, **kwargs):  # noqa: E501
        """Delete all orders  # noqa: E501

        Allows you to delete all orders of a portfolio  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_orders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param delivery_areas:
        :type delivery_areas: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'portfolio_id',
            'delivery_areas'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'portfolio_id' in local_var_params and local_var_params['portfolio_id'] is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if 'delivery_areas' in local_var_params and local_var_params['delivery_areas'] is not None:  # noqa: E501
            query_params.append(('delivery_areas', local_var_params['delivery_areas']))  # noqa: E501
            collection_formats['delivery_areas'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
        }

        return self.api_client.call_api(
            '/orders', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_own_orders(self, **kwargs):  # noqa: E501
        """List own orders  # noqa: E501

        Retrieves a list of all your own orders at the exchange for an array of portfolios. Allows you to filter your orders for delivery area and/or contract_id. The return element will provide all the order_ids, the contracts the orders belong to, as well as an action status, which determines the current status of the order (added, partly executed, fully executed, etc).  Please use the action status of orders to determine if you have done trades, as trade reporting from the exchange is sometimes slightly delayed.  The parameter active_only will only list orders, which are active. The filter user_code allows you to filter orders created by a specific exchange user. Please be aware that this method uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_orders(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param contract_id: Show only those orders related to a specific contract
        :type contract_id: list[str]
        :param active_only: Returns only those orders which are active
        :type active_only: bool
        :param delivery_area: The EIC code of the delivery area
        :type delivery_area: str
        :param user_code: the exchange user code
        :type user_code: str
        :param cl_ordr_id:
        :type cl_ordr_id: str
        :param txt:
        :type txt: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_own_orders_with_http_info(**kwargs)  # noqa: E501

    def get_own_orders_with_http_info(self, **kwargs):  # noqa: E501
        """List own orders  # noqa: E501

        Retrieves a list of all your own orders at the exchange for an array of portfolios. Allows you to filter your orders for delivery area and/or contract_id. The return element will provide all the order_ids, the contracts the orders belong to, as well as an action status, which determines the current status of the order (added, partly executed, fully executed, etc).  Please use the action status of orders to determine if you have done trades, as trade reporting from the exchange is sometimes slightly delayed.  The parameter active_only will only list orders, which are active. The filter user_code allows you to filter orders created by a specific exchange user. Please be aware that this method uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_orders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param contract_id: Show only those orders related to a specific contract
        :type contract_id: list[str]
        :param active_only: Returns only those orders which are active
        :type active_only: bool
        :param delivery_area: The EIC code of the delivery area
        :type delivery_area: str
        :param user_code: the exchange user code
        :type user_code: str
        :param cl_ordr_id:
        :type cl_ordr_id: str
        :param txt:
        :type txt: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'portfolio_id',
            'offset',
            'limit',
            'contract_id',
            'active_only',
            'delivery_area',
            'user_code',
            'cl_ordr_id',
            'txt'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_own_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'portfolio_id' in local_var_params and local_var_params['portfolio_id'] is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'contract_id' in local_var_params and local_var_params['contract_id'] is not None:  # noqa: E501
            query_params.append(('contract_id', local_var_params['contract_id']))  # noqa: E501
            collection_formats['contract_id'] = 'csv'  # noqa: E501
        if 'active_only' in local_var_params and local_var_params['active_only'] is not None:  # noqa: E501
            query_params.append(('active_only', local_var_params['active_only']))  # noqa: E501
        if 'delivery_area' in local_var_params and local_var_params['delivery_area'] is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
        if 'user_code' in local_var_params and local_var_params['user_code'] is not None:  # noqa: E501
            query_params.append(('user_code', local_var_params['user_code']))  # noqa: E501
        if 'cl_ordr_id' in local_var_params and local_var_params['cl_ordr_id'] is not None:  # noqa: E501
            query_params.append(('clOrdrId', local_var_params['cl_ordr_id']))  # noqa: E501
        if 'txt' in local_var_params and local_var_params['txt'] is not None:  # noqa: E501
            query_params.append(('txt', local_var_params['txt']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
        }

        return self.api_client.call_api(
            '/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def modify_order(self, order_id, revision_no, **kwargs):  # noqa: E501
        """Modify single order  # noqa: E501

        Allows you to change, activate or deactivate an existing order at the market. In order to change an order, you need to provide the order_id as well as the latest revision of the order (available via GET /orders), in order to prevent changing an order that has been changed (e.g. partly executed) since you last observed it. If the revision number is incorrect, the modification will be declined by the exchange system.  Note that some modifications do not update the order directly (e.g price/quantity changes), depending on the exchange. In this case, a new order is created with the modification and the original order is deleted.  Please note that the response of an order modification is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order modification and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_order(order_id, revision_no, async_req=True)
        >>> result = thread.get()

        :param order_id: the unique order_id of the order which should be modified. **Heads up!** The order_id can change after the modification. (required)
        :type order_id: str
        :param revision_no: The revision of the order which should be modified **Heads up!** If the revision does not match with the order's current revision in the exchange backend the modification will cause an error. (required)
        :type revision_no: int
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange (if internal trading is activated in market options). Set it to false if you don't want internal trading. If left blank, default market options will apply.  Note: There is no cross-trade recognition for user defined block orders and for iceberg-orders with a peak-price-delta.
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation wont be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value. Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect. 
        :type fail_on_limit_violations: bool
        :param modifications:
        :type modifications: OrderModify
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_order_with_http_info(order_id, revision_no, **kwargs)  # noqa: E501

    def modify_order_with_http_info(self, order_id, revision_no, **kwargs):  # noqa: E501
        """Modify single order  # noqa: E501

        Allows you to change, activate or deactivate an existing order at the market. In order to change an order, you need to provide the order_id as well as the latest revision of the order (available via GET /orders), in order to prevent changing an order that has been changed (e.g. partly executed) since you last observed it. If the revision number is incorrect, the modification will be declined by the exchange system.  Note that some modifications do not update the order directly (e.g price/quantity changes), depending on the exchange. In this case, a new order is created with the modification and the original order is deleted.  Please note that the response of an order modification is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order modification and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_order_with_http_info(order_id, revision_no, async_req=True)
        >>> result = thread.get()

        :param order_id: the unique order_id of the order which should be modified. **Heads up!** The order_id can change after the modification. (required)
        :type order_id: str
        :param revision_no: The revision of the order which should be modified **Heads up!** If the revision does not match with the order's current revision in the exchange backend the modification will cause an error. (required)
        :type revision_no: int
        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange (if internal trading is activated in market options). Set it to false if you don't want internal trading. If left blank, default market options will apply.  Note: There is no cross-trade recognition for user defined block orders and for iceberg-orders with a peak-price-delta.
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation wont be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value. Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect. 
        :type fail_on_limit_violations: bool
        :param modifications:
        :type modifications: OrderModify
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'order_id',
            'revision_no',
            'internal_trading',
            'fail_on_limit_violations',
            'modifications'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and ('order_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['order_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_id` when calling `modify_order`")  # noqa: E501
        # verify the required parameter 'revision_no' is set
        if self.api_client.client_side_validation and ('revision_no' not in local_var_params or  # noqa: E501
                                                        local_var_params['revision_no'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `revision_no` when calling `modify_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in local_var_params:
            path_params['order_id'] = local_var_params['order_id']  # noqa: E501
        if 'revision_no' in local_var_params:
            path_params['revision_no'] = local_var_params['revision_no']  # noqa: E501

        query_params = []
        if 'internal_trading' in local_var_params and local_var_params['internal_trading'] is not None:  # noqa: E501
            query_params.append(('internal_trading', local_var_params['internal_trading']))  # noqa: E501
        if 'fail_on_limit_violations' in local_var_params and local_var_params['fail_on_limit_violations'] is not None:  # noqa: E501
            query_params.append(('fail_on_limit_violations', local_var_params['fail_on_limit_violations']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'modifications' in local_var_params:
            body_params = local_var_params['modifications']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
            409: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/order/{order_id}/{revision_no}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def modify_orders(self, **kwargs):  # noqa: E501
        """Modify multiple orders  # noqa: E501

        Allows you to change, activate or deactivate an existing order at the market. In order to change an order, you need to provide the order_id as well as the latest revision of the order (available via GET /orders), in order to prevent changing an order that has been changed (e.g. partly executed) since you last observed it. If the revision number is incorrect, the modification will be declined by the exchange system.  Note that some modifications do not update the order directly (e.g price/quantity changes), depending on the exchange. In this case, a new order with a new id is created with the modification and the original order is deleted.  Please note that the response of an order modification is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order modification and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_orders(async_req=True)
        >>> result = thread.get()

        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange (if internal trading is activated in market options). Set it to false if you don't want internal trading. If left blank, default market options will apply.  Note: There is no cross-trade recognition for user defined block orders and for iceberg-orders with a peak-price-delta. 
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation wont be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value. Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect. 
        :type fail_on_limit_violations: bool
        :param modifications:
        :type modifications: list[OrderModifyItem]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[OwnOrder]
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_orders_with_http_info(**kwargs)  # noqa: E501

    def modify_orders_with_http_info(self, **kwargs):  # noqa: E501
        """Modify multiple orders  # noqa: E501

        Allows you to change, activate or deactivate an existing order at the market. In order to change an order, you need to provide the order_id as well as the latest revision of the order (available via GET /orders), in order to prevent changing an order that has been changed (e.g. partly executed) since you last observed it. If the revision number is incorrect, the modification will be declined by the exchange system.  Note that some modifications do not update the order directly (e.g price/quantity changes), depending on the exchange. In this case, a new order with a new id is created with the modification and the original order is deleted.  Please note that the response of an order modification is not consistent for different exchanges and different product types. Resulting from this, a user should never rely on a particular response of any order modification and always validate actions via other requests (e.g. GET/trades, GET/internal-trades, GET/orders).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_orders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param internal_trading: If set to true, cross-trade recognition will be performed before submitting the orders to the exchange (if internal trading is activated in market options). Set it to false if you don't want internal trading. If left blank, default market options will apply.  Note: There is no cross-trade recognition for user defined block orders and for iceberg-orders with a peak-price-delta. 
        :type internal_trading: bool
        :param fail_on_limit_violations: If set to true, a single limit violation will prevent sending all orders to the exchange. If set to false, orders for contracts which cause a violation wont be sent, orders which do not cause a violation will be sent to the exchange. If not set, true is taken as default value. Please note that this only covers limit violations on limits defined by the system. Violating limits defined at exchange level on one order will not prevent correct orders from being sent to the exchange. In this case, this parameter does not have any effect. 
        :type fail_on_limit_violations: bool
        :param modifications:
        :type modifications: list[OrderModifyItem]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[OwnOrder], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'internal_trading',
            'fail_on_limit_violations',
            'modifications'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'internal_trading' in local_var_params and local_var_params['internal_trading'] is not None:  # noqa: E501
            query_params.append(('internal_trading', local_var_params['internal_trading']))  # noqa: E501
        if 'fail_on_limit_violations' in local_var_params and local_var_params['fail_on_limit_violations'] is not None:  # noqa: E501
            query_params.append(('fail_on_limit_violations', local_var_params['fail_on_limit_violations']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'modifications' in local_var_params:
            body_params = local_var_params['modifications']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[OwnOrder]",
            409: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/orders/list', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_status(self, orders, **kwargs):  # noqa: E501
        """Change status of all orders  # noqa: E501

        Modifies the status of all your orders at the exchange at once. Please be aware that this is an exchange backend request, which would modify the status of all orders at the exchange (including other tenants and portfolios) and can thus only be performed with api keys that have access to all portfolios within the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_status(orders, async_req=True)
        >>> result = thread.get()

        :param orders: (required)
        :type orders: UpdateStatus
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.update_status_with_http_info(orders, **kwargs)  # noqa: E501

    def update_status_with_http_info(self, orders, **kwargs):  # noqa: E501
        """Change status of all orders  # noqa: E501

        Modifies the status of all your orders at the exchange at once. Please be aware that this is an exchange backend request, which would modify the status of all orders at the exchange (including other tenants and portfolios) and can thus only be performed with api keys that have access to all portfolios within the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_status_with_http_info(orders, async_req=True)
        >>> result = thread.get()

        :param orders: (required)
        :type orders: UpdateStatus
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'orders'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'orders' is set
        if self.api_client.client_side_validation and ('orders' not in local_var_params or  # noqa: E501
                                                        local_var_params['orders'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `orders` when calling `update_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'orders' in local_var_params:
            body_params = local_var_params['orders']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/orders/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
