<img src="https://karlch.github.io/vimiv-qt/_images/vimiv_banner_800.png" alt="vimiv banner" width="400"/>

[![Build Status](https://github.com/karlch/vimiv-qt/workflows/CI/badge.svg)](https://github.com/karlch/vimiv-qt/actions)
[![Codecov](https://codecov.io/github/karlch/vimiv-qt/coverage.svg?branch=master)](https://codecov.io/github/karlch/vimiv-qt?branch=master)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)

[website](https://karlch.github.io/vimiv-qt/) |
[docs](https://karlch.github.io/vimiv-qt/documentation/index.html) |
[install](https://karlch.github.io/vimiv-qt/documentation/install.html) |
[screenshots](https://karlch.github.io/vimiv-qt/screenshots.html) |
[changelog](https://karlch.github.io/vimiv-qt/changelog.html) |
[contributing](https://karlch.github.io/vimiv-qt/documentation/contributing.html)

<img src="https://i.postimg.cc/VkcPgcbR/vimiv.gif" alt="vimiv screencast" width="440"/>

---
> :information_source: This Qt port is the future of vimiv. New features will
> only be implemented here and there are already many improvements compared to the
> [deprecated gtk version](https://github.com/karlch/vimiv). The old version is only
> recommended if you require a more stable software. In case there is anything you miss
> here, please [open an issue](https://github.com/karlch/vimiv-qt/issues). Check the
> [roadmap](https://karlch.github.io/vimiv-qt/roadmap.html) for more details.
---

Vimiv is an image viewer with vim-like keybindings. It is written in python3
using the Qt5 toolkit and is free software, licensed under the GPL.

### Features

* Basic image operations and navigation
* [ranger](https://github.com/ranger/ranger)-like library to browse your images
* Thumbnail mode: navigable grid of image previews
* Command mode with tab-completion
* Search with pattern matching
* Simple mark and tag system
* Customization of keybindings, settings and style via configuration files,
  [base-16 support](https://github.com/karlch/base16-vimiv), ...

### Install

To learn how to get vimiv running on various platforms, please check out the
[installation guide](https://karlch.github.io/vimiv-qt/documentation/install.html).

### Documentation

Much more details on vimiv are available on the
[website](https://karlch.github.io/vimiv-qt/). Here are some hints to get you started:
* [The installation guide](https://karlch.github.io/vimiv-qt/documentation/install.html)
   includes instructions on how to get vimiv running on various platforms.
* [Getting started](https://karlch.github.io/vimiv-qt/documentation/getting\_started.html)
  starts with the basic concepts and keybindings to later show some more advanced
  features.
* [Commands](https://karlch.github.io/vimiv-qt/documentation/commands.html)
  gives a complete overview and description of all commands.
* [Keybindings](https://karlch.github.io/vimiv-qt/documentation/configuration/keybindings.html)
  lists the default keybindings and describes how to configure them.
* [Settings](https://karlch.github.io/vimiv-qt/documentation/configuration/settings.html)
  describes the available settings and how to change them.
* [Style](https://karlch.github.io/vimiv-qt/documentation/configuration/style.html)
  explains how to configure the look and colorscheme of vimiv.
* [Plugins](https://karlch.github.io/vimiv-qt/documentation/configuration/plugins.html)
  illustrates vimiv's python plugin system: a great way to extend the functionality
  beyond the defaults and to start delving into the source code.

### Contributing

You want to contribute to vimiv? Great! :tada:

Every little help counts and is appreciated!  Feel free to read the
[contributing guidelines](https://karlch.github.io/vimiv-qt/documentation/contributing.html)
for some useful tips and tricks.

There are many ways to contribute, including:
* [giving feedback and requesting new features](https://karlch.github.io/vimiv-qt/documentation/contributing.html#feedback-and-feature-requests),
* [reporting bugs](https://karlch.github.io/vimiv-qt/documentation/contributing.html#reporting-bugs),
* [writing code](https://karlch.github.io/vimiv-qt/documentation/contributing.html#writing-code)
  and
* [extending the documentation](https://karlch.github.io/vimiv-qt/documentation/contributing.html#writing-documentation).
* spreading the word in an article, blog, reddit post, ...

Need help? Feel free to
[contact me directly](mailto:karlch@protonmail.com)
or, even better,
open an [issue on github](https://github.com/karlch/vimiv-qt/issues/).

### License

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program. If not, see <http://www.gnu.org/licenses/>.
