"""
This module implements a set of command-line utilities for implementing a
data extraction, training, and testing pipeline.  When the
`editquality` python package is installed, the
:mod:`editquality utility <editquality.editquality>` utility should be
available from the commandline.  Run `editquality -h` for more
information.  You can also run `./utility -h` within the project directory to
run the utilities while doing development work.

===============
Editquality CLI
===============
.. automodule:: editquality.editquality

=============
Sub-utilities
=============

autolabel
+++++++++
.. automodule:: editquality.utilities.autolabel

extract_damaging
++++++++++++++++
.. automodule:: editquality.utilities.extract_damaging

fetch_labels
++++++++++++
.. automodule:: editquality.utilities.fetch_labels

generate_make
+++++++++++++
.. automodule:: editquality.utilities.generate_make

get_revisions
+++++++++++++
.. automodule:: editquality.utilities.get_revisions

join_observations
+++++++++++++++++
.. automodule:: editquality.utilities.join_observations

merge_labels
++++++++++++
.. automodule:: editquality.utilities.merge_labels
"""
