import { Code } from './code';
/**
 * (experimental) AWS Glue version determines the versions of Apache Spark and Python that are available to the job.
 *
 * @see https://docs.aws.amazon.com/glue/latest/dg/add-job.html.
 *
 * If you need to use a GlueVersion that doesn't exist as a static member, you
 * can instantiate a `GlueVersion` object, e.g: `GlueVersion.of('1.5')`.
 * @experimental
 */
export declare class GlueVersion {
    /**
     * (experimental) Glue version using Spark 2.2.1 and Python 2.7.
     *
     * @experimental
     */
    static readonly V0_9: GlueVersion;
    /**
     * (experimental) Glue version using Spark 2.4.3, Python 2.7 and Python 3.6.
     *
     * @experimental
     */
    static readonly V1_0: GlueVersion;
    /**
     * (experimental) Glue version using Spark 2.4.3 and Python 3.7.
     *
     * @experimental
     */
    static readonly V2_0: GlueVersion;
    /**
     * (experimental) Glue version using Spark 3.1.1 and Python 3.7.
     *
     * @experimental
     */
    static readonly V3_0: GlueVersion;
    /**
     * (experimental) Custom Glue version.
     *
     * @param version custom version.
     * @experimental
     */
    static of(version: string): GlueVersion;
    /**
     * (experimental) The name of this GlueVersion, as expected by Job resource.
     *
     * @experimental
     */
    readonly name: string;
    private constructor();
}
/**
 * (experimental) Runtime language of the Glue job.
 *
 * @experimental
 */
export declare enum JobLanguage {
    /**
     * (experimental) Scala.
     *
     * @experimental
     */
    SCALA = "scala",
    /**
     * (experimental) Python.
     *
     * @experimental
     */
    PYTHON = "python"
}
/**
 * (experimental) Python version.
 *
 * @experimental
 */
export declare enum PythonVersion {
    /**
     * (experimental) Python 2 (the exact version depends on GlueVersion and JobCommand used).
     *
     * @experimental
     */
    TWO = "2",
    /**
     * (experimental) Python 3 (the exact version depends on GlueVersion and JobCommand used).
     *
     * @experimental
     */
    THREE = "3"
}
/**
 * (experimental) The job type.
 *
 * If you need to use a JobType that doesn't exist as a static member, you
 * can instantiate a `JobType` object, e.g: `JobType.of('other name')`.
 *
 * @experimental
 */
export declare class JobType {
    /**
     * (experimental) Command for running a Glue ETL job.
     *
     * @experimental
     */
    static readonly ETL: JobType;
    /**
     * (experimental) Command for running a Glue streaming job.
     *
     * @experimental
     */
    static readonly STREAMING: JobType;
    /**
     * (experimental) Command for running a Glue python shell job.
     *
     * @experimental
     */
    static readonly PYTHON_SHELL: JobType;
    /**
     * (experimental) Custom type name.
     *
     * @param name type name.
     * @experimental
     */
    static of(name: string): JobType;
    /**
     * (experimental) The name of this JobType, as expected by Job resource.
     *
     * @experimental
     */
    readonly name: string;
    private constructor();
}
interface PythonExecutableProps {
    /**
     * (experimental) The Python version to use.
     *
     * @experimental
     */
    readonly pythonVersion: PythonVersion;
    /**
     * (experimental) Additional Python files that AWS Glue adds to the Python path before executing your script.
     *
     * Only individual files are supported, directories are not supported.
     *
     * @default - no extra python files and argument is not set
     * @see `--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly extraPythonFiles?: Code[];
}
interface SharedJobExecutableProps {
    /**
     * (experimental) Glue version.
     *
     * @see https://docs.aws.amazon.com/glue/latest/dg/release-notes.html
     * @experimental
     */
    readonly glueVersion: GlueVersion;
    /**
     * (experimental) The script that executes a job.
     *
     * @experimental
     */
    readonly script: Code;
    /**
     * (experimental) Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.
     *
     * Only individual files are supported, directories are not supported.
     *
     * @default [] - no extra files are copied to the working directory
     * @see `--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly extraFiles?: Code[];
}
interface SharedSparkJobExecutableProps extends SharedJobExecutableProps {
    /**
     * (experimental) Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script. Only individual files are supported, directories are not supported.
     *
     * @default [] - no extra jars are added to the classpath
     * @see `--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly extraJars?: Code[];
    /**
     * (experimental) Setting this value to true prioritizes the customer's extra JAR files in the classpath.
     *
     * @default false - priority is not given to user-provided jars
     * @see `--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly extraJarsFirst?: boolean;
}
/**
 * (experimental) Props for creating a Scala Spark (ETL or Streaming) job executable.
 *
 * @experimental
 */
export interface ScalaJobExecutableProps extends SharedSparkJobExecutableProps {
    /**
     * (experimental) The fully qualified Scala class name that serves as the entry point for the job.
     *
     * @see `--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly className: string;
}
/**
 * (experimental) Props for creating a Python Spark (ETL or Streaming) job executable.
 *
 * @experimental
 */
export interface PythonSparkJobExecutableProps extends SharedSparkJobExecutableProps, PythonExecutableProps {
}
/**
 * (experimental) Props for creating a Python shell job executable.
 *
 * @experimental
 */
export interface PythonShellExecutableProps extends SharedJobExecutableProps, PythonExecutableProps {
}
/**
 * (experimental) The executable properties related to the Glue job's GlueVersion, JobType and code.
 *
 * @experimental
 */
export declare class JobExecutable {
    /**
     * (experimental) Create Scala executable props for Apache Spark ETL job.
     *
     * @param props Scala Apache Spark Job props.
     * @experimental
     */
    static scalaEtl(props: ScalaJobExecutableProps): JobExecutable;
    /**
     * (experimental) Create Scala executable props for Apache Spark Streaming job.
     *
     * @param props Scala Apache Spark Job props.
     * @experimental
     */
    static scalaStreaming(props: ScalaJobExecutableProps): JobExecutable;
    /**
     * (experimental) Create Python executable props for Apache Spark ETL job.
     *
     * @param props Python Apache Spark Job props.
     * @experimental
     */
    static pythonEtl(props: PythonSparkJobExecutableProps): JobExecutable;
    /**
     * (experimental) Create Python executable props for Apache Spark Streaming job.
     *
     * @param props Python Apache Spark Job props.
     * @experimental
     */
    static pythonStreaming(props: PythonSparkJobExecutableProps): JobExecutable;
    /**
     * (experimental) Create Python executable props for python shell jobs.
     *
     * @param props Python Shell Job props.
     * @experimental
     */
    static pythonShell(props: PythonShellExecutableProps): JobExecutable;
    /**
     * (experimental) Create a custom JobExecutable.
     *
     * @param config custom job executable configuration.
     * @experimental
     */
    static of(config: JobExecutableConfig): JobExecutable;
    private config;
    private constructor();
    /**
     * (experimental) Called during Job initialization to get JobExecutableConfig.
     *
     * @experimental
     */
    bind(): JobExecutableConfig;
}
/**
 * (experimental) Result of binding a `JobExecutable` into a `Job`.
 *
 * @experimental
 */
export interface JobExecutableConfig {
    /**
     * (experimental) Glue version.
     *
     * @see https://docs.aws.amazon.com/glue/latest/dg/release-notes.html
     * @experimental
     */
    readonly glueVersion: GlueVersion;
    /**
     * (experimental) The language of the job (Scala or Python).
     *
     * @see `--job-language` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly language: JobLanguage;
    /**
     * (experimental) Specify the type of the job whether it's an Apache Spark ETL or streaming one or if it's a Python shell job.
     *
     * @experimental
     */
    readonly type: JobType;
    /**
     * (experimental) The Python version to use.
     *
     * @default - no python version specified
     * @experimental
     */
    readonly pythonVersion?: PythonVersion;
    /**
     * (experimental) The script that is executed by a job.
     *
     * @experimental
     */
    readonly script: Code;
    /**
     * (experimental) The Scala class that serves as the entry point for the job.
     *
     * This applies only if your the job langauage is Scala.
     *
     * @default - no scala className specified
     * @see `--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly className?: string;
    /**
     * (experimental) Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script.
     *
     * @default - no extra jars specified.
     * @see `--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly extraJars?: Code[];
    /**
     * (experimental) Additional Python files that AWS Glue adds to the Python path before executing your script.
     *
     * @default - no extra python files specified.
     * @see `--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly extraPythonFiles?: Code[];
    /**
     * (experimental) Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.
     *
     * @default - no extra files specified.
     * @see `--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly extraFiles?: Code[];
    /**
     * (experimental) Setting this value to true prioritizes the customer's extra JAR files in the classpath.
     *
     * @default - extra jars are not prioritized.
     * @see `--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html
     * @experimental
     */
    readonly extraJarsFirst?: boolean;
}
export {};
