"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const resource_arn_suffix_1 = require("../resource-arn-suffix");
const emr_create_cluster_1 = require("./emr-create-cluster");
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
class EmrModifyInstanceGroupByName {
    constructor(props) {
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: resource_arn_suffix_1.getResourceArn('elasticmapreduce', 'modifyInstanceGroupByName', sfn.ServiceIntegrationPattern.FIRE_AND_FORGET),
            policyStatements: [
                new iam.PolicyStatement({
                    actions: [
                        'elasticmapreduce:ModifyInstanceGroups',
                        'elasticmapreduce:ListInstanceGroups',
                    ],
                    resources: [`arn:aws:elasticmapreduce:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:cluster/*`],
                }),
            ],
            parameters: {
                ClusterId: this.props.clusterId,
                InstanceGroupName: this.props.instanceGroupName,
                InstanceGroup: EmrModifyInstanceGroupByName.InstanceGroupModifyConfigPropertyToJson(this.props.instanceGroup),
            },
        };
    }
}
exports.EmrModifyInstanceGroupByName = EmrModifyInstanceGroupByName;
(function (EmrModifyInstanceGroupByName) {
    /**
     * Render the InstanceResizePolicyProperty to JSON
     *
     * @param property
     */
    function InstanceResizePolicyPropertyToJson(property) {
        var _a;
        return {
            InstancesToProtect: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToProtect),
            InstancesToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToTerminate),
            InstanceTerminationTimeout: cdk.numberToCloudFormation((_a = property.instanceTerminationTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
        };
    }
    EmrModifyInstanceGroupByName.InstanceResizePolicyPropertyToJson = InstanceResizePolicyPropertyToJson;
    /**
     * Render the ShrinkPolicyProperty to JSON
     *
     * @param property
     */
    function ShrinkPolicyPropertyToJson(property) {
        var _a;
        return {
            DecommissionTimeout: cdk.numberToCloudFormation((_a = property.decommissionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
            InstanceResizePolicy: (property.instanceResizePolicy === undefined) ?
                property.instanceResizePolicy :
                InstanceResizePolicyPropertyToJson(property.instanceResizePolicy),
        };
    }
    EmrModifyInstanceGroupByName.ShrinkPolicyPropertyToJson = ShrinkPolicyPropertyToJson;
    /**
     * Render the InstanceGroupModifyConfigPropety to JSON
     *
     * @param property
     */
    function InstanceGroupModifyConfigPropertyToJson(property) {
        return {
            Configurations: cdk.listMapper(emr_create_cluster_1.EmrCreateCluster.ConfigurationPropertyToJson)(property.configurations),
            EC2InstanceIdsToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.eC2InstanceIdsToTerminate),
            InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
            ShrinkPolicy: (property.shrinkPolicy === undefined) ?
                property.shrinkPolicy :
                ShrinkPolicyPropertyToJson(property.shrinkPolicy),
        };
    }
    EmrModifyInstanceGroupByName.InstanceGroupModifyConfigPropertyToJson = InstanceGroupModifyConfigPropertyToJson;
})(EmrModifyInstanceGroupByName = exports.EmrModifyInstanceGroupByName || (exports.EmrModifyInstanceGroupByName = {}));
//# sourceMappingURL=data:application/json;base64,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