/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2022 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 9.7.2
 * @date    2022-02-10
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(self,function(){return i={897:function(e,t,i){"use strict";i.d(t,{x:function(){return r}});var c=i(2602),h=i(9791),d=i(7907);function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=function(){function l(t,e){if(!(this instanceof l))throw new TypeError("Cannot call a class as a function");this.dom={};var h=this,i=this.dom,e=(this.anchor=void 0,this.items=t,this.eventListeners={},this.selection=void 0,this.onClose=e?e.close:void 0,this.limitHeight=!!e&&e.limitHeight,document.createElement("div")),n=(e.className="jsoneditor-contextmenu-root",i.root=e,document.createElement("div")),e=(n.className="jsoneditor-contextmenu",i.menu=n,e.appendChild(n),document.createElement("ul")),n=(e.className="jsoneditor-menu",n.appendChild(e),i.list=e,i.items=[],document.createElement("button")),i=(n.type="button",i.focusButton=n,document.createElement("li"));i.style.overflow="hidden",i.style.height="0",i.appendChild(n),e.appendChild(i),function a(l,c,e){e.forEach(function(t){var i,e,n,r,o,s;"separator"===t.type?((o=document.createElement("div")).className="jsoneditor-separator",(e=document.createElement("li")).appendChild(o),l.appendChild(e)):(i={},o=document.createElement("li"),l.appendChild(o),(e=document.createElement("button")).type="button",e.className=t.className,i.button=e,t.title&&(e.title=t.title),t.click&&(e.onclick=function(e){e.preventDefault(),h.hide(),t.click()}),o.appendChild(e),t.submenu?((r=document.createElement("div")).className="jsoneditor-icon",e.appendChild(r),(r=document.createElement("div")).className="jsoneditor-text"+(t.click?"":" jsoneditor-right-margin"),r.appendChild(document.createTextNode(t.text)),e.appendChild(r),(n=t.click?(e.className+=" jsoneditor-default",(r=document.createElement("button")).type="button",(i.buttonExpand=r).className="jsoneditor-expand",(s=document.createElement("div")).className="jsoneditor-expand",r.appendChild(s),o.appendChild(r),t.submenuTitle&&(r.title=t.submenuTitle),r):((s=document.createElement("div")).className="jsoneditor-expand",e.appendChild(s),e)).onclick=function(e){e.preventDefault(),h._onExpandItem(i),n.focus()},i.subItems=r=[],s=document.createElement("ul"),(i.ul=s).className="jsoneditor-menu",s.style.height="0",o.appendChild(s),a(s,r,t.submenu)):((o=document.createElement("div")).className="jsoneditor-icon",e.appendChild(o),(s=document.createElement("div")).className="jsoneditor-text",s.appendChild(document.createTextNode((0,d.Iu)(t.text))),e.appendChild(s)),c.push(i))})}(e,this.dom.items,t),this.maxHeight=0,t.forEach(function(e){e=24*(t.length+(e.submenu?e.submenu.length:0));h.maxHeight=Math.max(h.maxHeight,e)})}var e,t,i;return e=l,(t=[{key:"_getVisibleButtons",value:function(){var t=[],i=this;return this.dom.items.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand),e.subItems&&e===i.expandedItem&&e.subItems.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand)})}),t}},{key:"show",value:function(e,t,i){this.hide();var n=!0,r=e.parentNode,o=e.getBoundingClientRect(),r=r.getBoundingClientRect(),s=t.getBoundingClientRect(),a=this,t=(this.dom.absoluteAnchor=(0,c.w)(e,t,function(){a.hide()}),o.bottom+this.maxHeight<s.bottom||o.top-this.maxHeight>s.top&&(n=!1),i?0:o.top-r.top);n?(i=e.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=t+i+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px"),this.limitHeight&&(r=n?s.bottom-o.bottom-10:o.top-s.top-10,this.dom.list.style.maxHeight=r+"px",this.dom.list.style.overflowY="auto"),this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=(0,h.getSelection)(),this.anchor=e,setTimeout(function(){a.dom.focusButton.focus()},0),l.visibleMenu&&l.visibleMenu.hide(),l.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose()),l.visibleMenu===this&&(l.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(i){var n,r=this,e=i===this.expandedItem,t=this.expandedItem;t&&(t.ul.style.height="0",t.ul.style.padding="",setTimeout(function(){r.expandedItem!==t&&(t.ul.style.display="",h.removeClassName)(t.ul.parentNode,"jsoneditor-selected")},300),this.expandedItem=void 0),e||((n=i.ul).style.display="block",n.clientHeight,setTimeout(function(){if(r.expandedItem===i){for(var e=0,t=0;t<n.childNodes.length;t++)e+=n.childNodes[t].clientHeight;n.style.height=e+"px",n.style.padding="5px 10px"}},0),(0,h.addClassName)(n.parentNode,"jsoneditor-selected"),this.expandedItem=i)}},{key:"_onKeyDown",value:function(e){var t,i,n,r,o=e.target,s=e.which,a=!1;27===s?(this.selection&&(0,h.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),a=!0):9===s?e.shiftKey?0===(i=(t=this._getVisibleButtons()).indexOf(o))&&(t[t.length-1].focus(),a=!0):(i=(t=this._getVisibleButtons()).indexOf(o))===t.length-1&&(t[0].focus(),a=!0):37===s?("jsoneditor-expand"===o.className&&(i=(t=this._getVisibleButtons()).indexOf(o),(n=t[i-1])&&n.focus()),a=!0):38===s?(i=(t=this._getVisibleButtons()).indexOf(o),(n=(n=(n=t[i-1])&&"jsoneditor-expand"===n.className?t[i-2]:n)||t[t.length-1])&&n.focus(),a=!0):39===s?(i=(t=this._getVisibleButtons()).indexOf(o),(r=t[i+1])&&"jsoneditor-expand"===r.className&&r.focus(),a=!0):40===s&&(i=(t=this._getVisibleButtons()).indexOf(o),(r=(r=(r=t[i+1])&&"jsoneditor-expand"===r.className?t[i+2]:r)||t[0])&&(r.focus(),a=!0),a=!0),a&&(e.stopPropagation(),e.preventDefault())}}])&&n(e.prototype,t),i&&n(e,i),Object.defineProperty(e,"prototype",{writable:!1}),l}();r.visibleMenu=void 0},6436:function(e,t,i){"use strict";function r(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}i.d(t,{Q:function(){return n}});var n=function(){function i(e){if(!(this instanceof i))throw new TypeError("Cannot call a class as a function");this.errorTableVisible=e.errorTableVisible,this.onToggleVisibility=e.onToggleVisibility,this.onFocusLine=e.onFocusLine||function(){},this.onChangeHeight=e.onChangeHeight,this.dom={};var e=document.createElement("div"),t=(e.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=e,document.createElement("div")),e=(t.style.display="none",t.className="jsoneditor-additional-errors fadein",t.textContent="Scroll for more ▿",this.dom.additionalErrorsIndication=t,e.appendChild(t),document.createElement("span")),t=(e.className="jsoneditor-validation-error-icon",e.style.display="none",this.dom.validationErrorIcon=e,document.createElement("span"));t.className="jsoneditor-validation-error-count",t.style.display="none",this.dom.validationErrorCount=t,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}var e,t,n;return e=i,(t=[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(e,o){var s,t,a=this,i=(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<e.length?((i=document.createElement("div")).className="jsoneditor-validation-errors",(t=document.createElement("table")).className="jsoneditor-text-errors",i.appendChild(t),s=document.createElement("tbody"),t.appendChild(s),e.forEach(function(t){isNaN(t.line)?!t.dataPath||(i=o.find(function(e){return e.path===t.dataPath}))&&(e=i.line+1):e=t.line;var e,i=document.createElement("tr"),n=(i.className=isNaN(e)?"":"jump-to-line","error"===t.type?i.className+=" parse-error":i.className+=" validation-error",document.createElement("td")),r=document.createElement("button"),r=(r.className="jsoneditor-schema-error",n.appendChild(r),i.appendChild(n),document.createElement("td"));r.style="white-space: nowrap;",r.textContent=isNaN(e)?"":"Ln "+e,i.appendChild(r),"string"==typeof t?((n=document.createElement("td")).colSpan=2,(r=document.createElement("pre")).appendChild(document.createTextNode(t)),n.appendChild(r),i.appendChild(n)):((r=document.createElement("td")).appendChild(document.createTextNode(t.dataPath||"")),i.appendChild(r),n=document.createElement("td"),(r=document.createElement("pre")).appendChild(document.createTextNode(t.message.replace(/<br>/gi,"\n"))),n.appendChild(r),i.appendChild(n)),i.onclick=function(){a.onFocusLine(e)},s.appendChild(i)}),this.dom.validationErrors=i,this.dom.validationErrorsContainer.appendChild(i),this.dom.additionalErrorsIndication.title=e.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){a.dom.additionalErrorsIndication.style.display=0<a.dom.validationErrorsContainer.clientHeight&&0===a.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0,t=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0),this.onChangeHeight(t)):this.onChangeHeight(0),e.filter(function(e){return"error"!==e.type}).length);0<i?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=i,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=i+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),e.some(function(e){return"error"===e.type})?(t=e[0].line,this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(t)?"parse error - check that the json is valid":"parse error on line "+t,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}])&&r(e.prototype,t),n&&r(e,n),Object.defineProperty(e,"prototype",{writable:!1}),i}()},2474:function(e,t,i){"use strict";function r(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}i.d(t,{R:function(){return n}});var n=function(){function t(e){if(!(this instanceof t))throw new TypeError("Cannot call a class as a function");if(this.target=e.target||null,!this.target)throw new Error('FocusTracker constructor called without a "target" to track.');this.onFocus="function"==typeof e.onFocus?e.onFocus:null,this.onBlur="function"==typeof e.onBlur?e.onBlur:null,this._onClick=this._onEvent.bind(this),this._onKeyUp=function(e){9!==e.which&&9!==e.keyCode||this._onEvent(e)}.bind(this),this.focusFlag=!1,this.firstEventFlag=!0,(this.onFocus||this.onBlur)&&(document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp))}var e,i,n;return e=t,(i=[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick),document.removeEventListener("keyup",this._onKeyUp),this._onEvent({target:document.body})}},{key:"_onEvent",value:function(e){e=e.target,e=e===this.target||!(!this.target.contains(e)&&!this.target.contains(document.activeElement));e?this.focusFlag||(this.onFocus&&this.onFocus({type:"focus",target:this.target}),this.focusFlag=!0):(this.focusFlag||this.firstEventFlag)&&(this.onBlur&&this.onBlur({type:"blur",target:this.target}),this.focusFlag=!1,this.firstEventFlag&&(this.firstEventFlag=!1))}}])&&r(e.prototype,i),n&&r(e,n),Object.defineProperty(e,"prototype",{writable:!1}),t}()},3161:function(e,h,r){"use strict";var t=r(8170),i=r(8037),n=r(8038).treeModeMixins,o=r(5956).textModeMixins,d=r(341).previewModeMixins,s=r(9791),u=s.clear,l=s.extend,g=s.getInnerText,p=s.getInternetExplorerVersion,m=s.parse,s=r(2744).tryRequireAjv,f=r(2558).showTransformModal,C=r(6210).showSortModal,a=s();function c(e,t,i){if(!(this instanceof c))throw new Error('JSONEditor constructor called without "new".');var n=p();if(-1!==n&&n<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"!==t.mode&&"code"!==t.mode&&(!t.modes||-1===t.modes.indexOf("text")&&-1===t.modes.indexOf("code"))||console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.')),t&&Object.keys(t).forEach(function(e){-1===c.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})),arguments.length&&this._create(e,t,i)}"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),c.modes={},c.prototype.DEBOUNCE_INTERVAL=150,c.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","onFocus","onBlur","colorPicker","onColorPicker","timestampTag","timestampFormat","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","limitDragging","maxVisibleChilds","onValidationError","modalAnchor","popupAnchor","createQuery","executeQuery","queryDescription"],c.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};e=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(e)},c.prototype.destroy=function(){},c.prototype.set=function(e){this.json=e},c.prototype.get=function(){return this.json},c.prototype.setText=function(e){this.json=m(e)},c.prototype.getText=function(){return JSON.stringify(this.json)},c.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},c.prototype.getName=function(){return this.options&&this.options.name},c.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t=this.container,i=l({},this.options),n=i.mode,r=(i.mode=e,c.modes[e]);if(!r)throw new Error('Unknown mode "'+i.mode+'"');var o="text"===r.data,s=this.getName(),a=this[o?"getText":"get"]();if(this.destroy(),u(this),l(this,r.mixin),this.create(t,i),this.setName(s),this[o?"setText":"set"](a),"function"==typeof r.load)try{r.load.call(this)}catch(e){console.error(e)}if("function"==typeof i.onModeChange&&e!==n)try{i.onModeChange(e,n)}catch(e){console.error(e)}}},c.prototype.getMode=function(){return this.options.mode},c.prototype._onError=function(e){this.options&&"function"==typeof this.options.onError?this.options.onError(e):alert(e.toString())},c.prototype.setSchema=function(e,t){if(e){var i;try{this.options.ajv?i=this.options.ajv:((i=a({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(r(7171)),i.addMetaSchema(r(6273)))}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(i){if(t){for(var n in t)i.removeSchema(n),t[n]&&i.addSchema(t[n],n);this.options.schemaRefs=t}this.validateSchema=i.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},c.prototype.validate=function(){},c.prototype.refresh=function(){},(c.registerMode=function(e){var t;if(Array.isArray(e))for(r=0;r<e.length;r++)c.registerMode(e[r]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var i=e.mode;if(i in c.modes)throw new Error('Mode "'+i+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');for(var n=["setMode","registerMode","modes"],r=0;r<n.length;r++)if((t=n[r])in e.mixin)throw new Error('Reserved property "'+t+'" not allowed in mixin');c.modes[i]=e}})(n),c.registerMode(o),c.registerMode(d),c.ace=t,c.Ajv=a,c.VanillaPicker=i,c.showTransformModal=f,c.showSortModal=C,c.getInnerText=g,e.exports=c.default=c},6617:function(e,t,i){"use strict";i.d(t,{x:function(){return r}});var u=i(897),g=i(7907);function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=function(){function d(e,t,i,n){if(!(this instanceof d))throw new TypeError("Cannot call a class as a function");for(var r={code:{text:(0,g.Iu)("modeCodeText"),title:(0,g.Iu)("modeCodeTitle"),click:function(){n("code")}},form:{text:(0,g.Iu)("modeFormText"),title:(0,g.Iu)("modeFormTitle"),click:function(){n("form")}},text:{text:(0,g.Iu)("modeTextText"),title:(0,g.Iu)("modeTextTitle"),click:function(){n("text")}},tree:{text:(0,g.Iu)("modeTreeText"),title:(0,g.Iu)("modeTreeTitle"),click:function(){n("tree")}},view:{text:(0,g.Iu)("modeViewText"),title:(0,g.Iu)("modeViewTitle"),click:function(){n("view")}},preview:{text:(0,g.Iu)("modePreviewText"),title:(0,g.Iu)("modePreviewTitle"),click:function(){n("preview")}}},h=[],o=0;o<t.length;o++){var s=t[o],a=r[s];if(!a)throw new Error('Unknown mode "'+s+'"');a.className="jsoneditor-type-modes"+(i===s?" jsoneditor-selected":""),h.push(a)}var l=r[i];if(!l)throw new Error('Unknown mode "'+i+'"');var l=l.text,c=document.createElement("button"),l=(c.type="button",c.className="jsoneditor-modes jsoneditor-separator",c.textContent=l+" ▾",c.title=(0,g.Iu)("modeEditorTitle"),c.onclick=function(){new u.x(h).show(c,e)},document.createElement("div"));l.className="jsoneditor-modes",l.style.position="relative",l.appendChild(c),e.appendChild(l),this.dom={container:e,box:c,frame:l}}var e,t,i;return e=d,(t=[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}])&&n(e.prototype,t),i&&n(e,i),Object.defineProperty(e,"prototype",{writable:!1}),d}()},8170:function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(6225),i(4091),i(3330);var r=i(7923);n.config.setModuleUrl("ace/mode/json_worker",r)}catch(e){}e.exports=n},4864:function(){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {\nbackground: #ebebeb;\ncolor: #333\n}\n\n.ace-jsoneditor.ace_editor {\nline-height: 1.3;\nbackground-color: #fff;\n}\n.ace-jsoneditor .ace_print-margin {\nwidth: 1px;\nbackground: #e8e8e8\n}\n.ace-jsoneditor .ace_scroller {\nbackground-color: #FFFFFF\n}\n.ace-jsoneditor .ace_text-layer {\ncolor: gray\n}\n.ace-jsoneditor .ace_variable {\ncolor: #1a1a1a\n}\n.ace-jsoneditor .ace_cursor {\nborder-left: 2px solid #000000\n}\n.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {\nborder-left: 0px;\nborder-bottom: 1px solid #000000\n}\n.ace-jsoneditor .ace_marker-layer .ace_selection {\nbackground: lightgray\n}\n.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {\nbox-shadow: 0 0 3px 0px #FFFFFF;\nborder-radius: 2px\n}\n.ace-jsoneditor .ace_marker-layer .ace_step {\nbackground: rgb(255, 255, 0)\n}\n.ace-jsoneditor .ace_marker-layer .ace_bracket {\nmargin: -1px 0 0 -1px;\nborder: 1px solid #BFBFBF\n}\n.ace-jsoneditor .ace_marker-layer .ace_active-line {\nbackground: #FFFBD1\n}\n.ace-jsoneditor .ace_gutter-active-line {\nbackground-color : #dcdcdc\n}\n.ace-jsoneditor .ace_marker-layer .ace_selected-word {\nborder: 1px solid lightgray\n}\n.ace-jsoneditor .ace_invisible {\ncolor: #BFBFBF\n}\n.ace-jsoneditor .ace_keyword,\n.ace-jsoneditor .ace_meta,\n.ace-jsoneditor .ace_support.ace_constant.ace_property-value {\ncolor: #AF956F\n}\n.ace-jsoneditor .ace_keyword.ace_operator {\ncolor: #484848\n}\n.ace-jsoneditor .ace_keyword.ace_other.ace_unit {\ncolor: #96DC5F\n}\n.ace-jsoneditor .ace_constant.ace_language {\ncolor: darkorange\n}\n.ace-jsoneditor .ace_constant.ace_numeric {\ncolor: red\n}\n.ace-jsoneditor .ace_constant.ace_character.ace_entity {\ncolor: #BF78CC\n}\n.ace-jsoneditor .ace_invalid {\ncolor: #FFFFFF;\nbackground-color: #FF002A;\n}\n.ace-jsoneditor .ace_fold {\nbackground-color: #AF956F;\nborder-color: #000000\n}\n.ace-jsoneditor .ace_storage,\n.ace-jsoneditor .ace_support.ace_class,\n.ace-jsoneditor .ace_support.ace_function,\n.ace-jsoneditor .ace_support.ace_other,\n.ace-jsoneditor .ace_support.ace_type {\ncolor: #C52727\n}\n.ace-jsoneditor .ace_string {\ncolor: green\n}\n.ace-jsoneditor .ace_comment {\ncolor: #BCC8BA\n}\n.ace-jsoneditor .ace_entity.ace_name.ace_tag,\n.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {\ncolor: #606060\n}\n.ace-jsoneditor .ace_markup.ace_underline {\ntext-decoration: underline\n}\n.ace-jsoneditor .ace_indent-guide {\nbackground: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y\n}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})},6589:function(e,t){var i=function(){var e,t={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,r,o,s){var a=o.length-1;switch(r){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=o[a-1];case 13:this.$={};break;case 14:this.$=o[a-1];break;case 15:this.$=[o[a-2],o[a]];break;case 16:this.$={},this.$[o[a][0]]=o[a][1];break;case 17:this.$=o[a-2],o[a-2][o[a][0]]=o[a][1];break;case 18:this.$=[];break;case 19:this.$=o[a-1];break;case 20:this.$=[o[a]];break;case 21:this.$=o[a-2],o[a-2].push(o[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(h){var d=this,e=[0],t=[null],i=[],n=this.table,u="",r=0,g=0,o=0,p=(this.lexer.setInput(h),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={}),this.lexer.yylloc);function m(){var e=d.lexer.lex()||1;return e="number"!=typeof e?d.symbols_[e]||e:e}i.push(p),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var s,f,a,l,C,c,I,v,A,b={};;){if(a=e[e.length-1],void 0===(l=this.defaultActions[a]||(null==s&&(s=m()),n[a]&&n[a][s]))||!l.length||!l[0]){if(!o){for(C in v=[],n[a])this.terminals_[C]&&2<C&&v.push("'"+this.terminals_[C]+"'");var y="",y=this.lexer.showPosition?"Parse error on line "+(r+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+v.join(", ")+", got '"+this.terminals_[s]+"'":"Parse error on line "+(r+1)+": Unexpected "+(1==s?"end of input":"'"+(this.terminals_[s]||s)+"'");this.parseError(y,{text:this.lexer.match,token:this.terminals_[s]||s,line:this.lexer.yylineno,loc:p,expected:v})}if(3==o){if(1==s)throw new Error(y||"Parsing halted.");g=this.lexer.yyleng,u=this.lexer.yytext,r=this.lexer.yylineno,p=this.lexer.yylloc,s=m()}for(;;){if(2..toString()in n[a])break;if(0==a)throw new Error(y||"Parsing halted.");A=1,e.length=e.length-2*A,t.length=t.length-A,i.length=i.length-A,a=e[e.length-1]}f=s,s=2,l=n[a=e[e.length-1]]&&n[a][2],o=3}if(l[0]instanceof Array&&1<l.length)throw new Error("Parse Error: multiple actions possible at state: "+a+", token: "+s);switch(l[0]){case 1:e.push(s),t.push(this.lexer.yytext),i.push(this.lexer.yylloc),e.push(l[1]),s=null,f?(s=f,f=null):(g=this.lexer.yyleng,u=this.lexer.yytext,r=this.lexer.yylineno,p=this.lexer.yylloc,0<o&&o--);break;case 2:if(c=this.productions_[l[1]][1],b.$=t[t.length-c],b._$={first_line:i[i.length-(c||1)].first_line,last_line:i[i.length-1].last_line,first_column:i[i.length-(c||1)].first_column,last_column:i[i.length-1].last_column},void 0!==(I=this.performAction.call(b,u,g,r,this.yy,l[1],t,i)))return I;c&&(e=e.slice(0,-1*c*2),t=t.slice(0,-1*c),i=i.slice(0,-1*c)),e.push(this.productions_[l[1]][0]),t.push(b.$),i.push(b._$),I=n[e[e.length-2]][e[e.length-1]],e.push(I);break;case 3:return!0}}return!0}};e={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(20<e.length?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(20<e.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var e,t,i,n,r=this._currentRules(),o=0;o<r.length&&(!(t=this._input.match(this.rules[r[o]]))||e&&!(t[0].length>e[0].length)||(e=t,i=o,this.options.flex));o++);return e?((n=e[0].match(/\n.*/g))&&(this.yylineno+=n.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:n?n[n.length-1].length-1:this.yylloc.last_column+e[0].length},this.yytext+=e[0],this.match+=e[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(e[0].length),this.matched+=e[0],n=this.performAction.call(this,this.yy,this,r[i],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),n||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)},options:{},performAction:function(e,t,i,n){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}};return t.lexer=e,t}();t.parser=i,t.parse=i.parse.bind(i)},3879:function(e){"use strict";function n(){}var s={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."},h=(n.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},n.mixin=function(e){for(var t=["on","off","emit"],i=0;i<t.length;i++)"function"==typeof e?e.prototype[t[i]]=n.prototype[t[i]]:e[t[i]]=n.prototype[t[i]];return e},{extend:function(e,t){for(var i in t=t||{},e)e.hasOwnProperty(i)&&(t.hasOwnProperty(i)||(t[i]=e[i]));return t},each:function(e,t,i){if("[object Object]"===Object.prototype.toString.call(e))for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.call(i,n,e[n],e);else for(var r=0,o=e.length;r<o;r++)t.call(i,r,e[r],e)},createElement:function(e,t){var i,n,r=document,o=r.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t))for(i in t)i in o?o[i]=t[i]:"html"===i?o.textContent=t[i]:"text"===i?(n=r.createTextNode(t[i]),o.appendChild(n)):o.setAttribute(i,t[i]);return o},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){h.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){h.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:h.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(n,r,o){var s;return function(){var e=this,t=arguments,i=o&&!s;clearTimeout(s),s=setTimeout(function(){s=null,o||n.apply(e,t)},r),i&&n.apply(e,t)}},rect:function(e,t){var i=window,e=e.getBoundingClientRect(),n=t?i.pageXOffset:0,t=t?i.pageYOffset:0;return{bottom:e.bottom+t,height:e.height,left:e.left+n,right:e.right+n,top:e.top+t,width:e.width}},includes:function(e,t){return-1<e.indexOf(t)},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}});function l(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function a(e,t,i){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),h.removeClass(e,"excluded"),i||(e.textContent=e.textContent+"")}function i(){var i,e;this.items.length&&(i=document.createDocumentFragment(),this.config.pagination?(e=this.pages.slice(0,this.pageIndex),h.each(e,function(e,t){h.each(t,function(e,t){a(t,i,this.customOption)},this)},this)):h.each(this.items,function(e,t){a(t,i,this.customOption)},this),i.childElementCount&&(h.removeClass(this.items[this.navIndex],"active"),this.navIndex=i.querySelector(".selectr-option").idx,h.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(i))}function c(e,t){return t=t||e,t=this.customOption?this.config.renderOption(t):e.textContent,(t=h.createElement("li",{class:"selectr-option",html:t,role:"treeitem","aria-selected":!1})).idx=e.idx,this.items.push(t),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(t.disabled=!0,h.addClass(t,"disabled")),t}function r(){var i,e=this.tree,t=e.scrollTop;e.scrollHeight-e.offsetHeight<=t&&this.pageIndex<this.pages.length&&(i=document.createDocumentFragment(),h.each(this.pages[this.pageIndex],function(e,t){a(t,i,this.customOption)},this),e.appendChild(i),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length}))}function t(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&h.removeClass(this.inputContainer,"active"),h.hasClass(this.container,"notice")&&(h.removeClass(this.container,"notice"),h.addClass(this.container,"open"),this.input.focus()),h.each(this.items,function(e,t){h.removeClass(t,"excluded"),this.customOption||(t.textContent=t.textContent+"")},this))}function o(e,t){if(t=t||{},!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if("string"==typeof(this.el=e)&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)}o.prototype.render=function(e){var t;this.rendered||(this.config=h.extend(s,e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=l(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,n.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,l(this.config,"width")&&(h.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":h.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=h.createElement("div",{class:"selectr-container"}),this.config.customClass&&h.addClass(this.container,this.config.customClass),this.mobileDevice?h.addClass(this.container,"selectr-mobile"):h.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?h.addClass(this.el,"selectr-visible"):h.addClass(this.el,"selectr-hidden"),this.selected=h.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1}),this.label=h.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e,i,n,t,r=h.createElement("div",{class:"selectr-options-container"}),o=(this.tree=h.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=h.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple&&(h.addClass(this.label,"selectr-tags"),h.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx")),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=h.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),h.addClass(this.container,"clearable")),this.config.taggable&&(e=h.createElement("li",{class:"input-tag"}),this.input=h.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),e.appendChild(this.input),this.label.appendChild(e),h.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))),this.config.searchable&&(this.input=h.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),this.inputClear=h.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=h.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),r.appendChild(this.inputContainer)),r.appendChild(this.notice),r.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options)),!1),s=0;this.el.children.length&&h.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(o=h.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),h.each(t.children,function(e,t){t.idx=s,o.appendChild(c.call(this,t,o)),s++},this)):(t.idx=s,c.call(this,t),s++)},this),this.config.data&&Array.isArray(this.config.data)&&(i=!(this.data=[]),o=!1,s=0,h.each(this.config.data,function(e,t){l(t,"children")?(i=h.createElement("optgroup",{label:t.text}),o=h.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),h.each(t.children,function(e,t){(n=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=l(t,"disabled"),this.options.push(n),i.appendChild(n),n.idx=s,o.appendChild(c.call(this,n,t)),this.data[s]=t,s++},this)):((n=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=l(t,"disabled"),this.options.push(n),n.idx=s,c.call(this,n,t),this.data[s]=t,s++)},this)),this.setSelected(!0);for(var a=this.navIndex=0;a<this.items.length;a++)if(t=this.items[a],!h.hasClass(t,"disabled")){h.addClass(t,"active"),this.navIndex=a;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(r),this.placeEl=h.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=h.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex),t=this,setTimeout(function(){t.emit("selectr.init")},20))},o.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},o.prototype.getSelectedProperties=function(t){var e=this.getSelected();return[].slice.call(e).map(function(e){return e[t]}).filter(function(e){return null!=e})},o.prototype.bindEvents=function(){var n=this;this.events={},this.events.dismiss=function(e){e=e.target;this.container.contains(e)||!this.opened&&!h.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(e){if(e=e||window.event,this.items.length&&this.opened&&h.includes([13,38,40],e.which)){if(e.preventDefault(),13===e.which)return!(this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var t,i=this.items[this.navIndex];switch(e.which){case 38:(t=0)<this.navIndex&&this.navIndex--;break;case 40:this.navIndex<this.items.length-(t=1)&&this.navIndex++}for(this.navigating=!0;h.hasClass(this.items[this.navIndex],"disabled")||h.hasClass(this.items[this.navIndex],"excluded");)if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}e=h.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:e.top+e.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(e.top+e.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&r.call(this)):0===this.navIndex?this.tree.scrollTop=0:e.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(e.top-this.optsRect.top)),i&&h.removeClass(i,"active"),h.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),(this.config.nativeDropdown||this.mobileDevice)&&(this.container.addEventListener("touchstart",function(e){e.changedTouches[0].target===n.el&&n.toggle()}),(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation(),e.target===n.el&&n.toggle()}),this.el.addEventListener("change",function(e){var t;n.el.multiple?(t=n.getSelectedProperties("idx"),t=function(e,t){for(var i,n=[],r=e.slice(0),o=0;o<t.length;o++)-1<(i=r.indexOf(t[o]))?r.splice(i,1):n.push(t[o]);return[n,r]}(n.selectedIndexes,t),h.each(t[0],function(e,t){n.select(t)},n),h.each(t[1],function(e,t){n.deselect(t)},n)):-1<n.el.selectedIndex&&n.select(n.el.selectedIndex)})),this.config.nativeDropdown&&this.container.addEventListener("keydown",function(e){"Enter"===e.key&&n.selected===document.activeElement&&(n.toggle(),setTimeout(function(){n.el.focus()},200))}),this.selected.addEventListener("click",function(e){n.disabled||n.toggle(),e.preventDefault(),e.stopPropagation()}),this.label.addEventListener("click",function(e){h.hasClass(e.target,"selectr-tag-remove")&&n.deselect(e.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation();e=h.closest(e.target,function(e){return e&&h.hasClass(e,"selectr-option")});e&&(h.hasClass(e,"disabled")||(h.hasClass(e,"selected")?(n.el.multiple||!n.el.multiple&&n.config.allowDeselect)&&n.deselect(e.idx):n.select(e.idx),n.opened&&!n.el.multiple&&n.close()))}),this.tree.addEventListener("mouseover",function(e){h.hasClass(e.target,"selectr-option")&&(h.hasClass(e.target,"disabled")||(h.removeClass(n.items[n.navIndex],"active"),h.addClass(e.target,"active"),n.navIndex=[].slice.call(n.items).indexOf(e.target)))}),this.config.searchable&&(this.input.addEventListener("focus",function(e){n.searching=!0}),this.input.addEventListener("blur",function(e){n.searching=!1}),this.input.addEventListener("keyup",function(e){n.search(),n.config.taggable||(this.value.length?h.addClass(this.parentNode,"active"):h.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(e){n.input.value=null,t.call(n),n.tree.childElementCount||i.call(n)})),this.config.taggable&&this.input.addEventListener("keyup",function(e){var i;n.search(),n.config.taggable&&this.value.length&&(i=this.value.trim(),13!==e.which&&!h.includes(n.tagSeperators,e.key)||(h.each(n.tagSeperators,function(e,t){i=i.replace(t,"")}),n.add({value:i,text:i,selected:!0},!0)?(n.close(),t.call(n)):(this.value="",n.setMessage("That tag is already in use."))))}),this.update=h.debounce(function(){n.opened&&n.config.closeOnScroll&&n.close(),n.width&&(n.container.style.width=n.width),n.invert()},50),this.requiresPagination&&(this.paginateItems=h.debounce(function(){r.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.el.form&&this.el.form.addEventListener("reset",this.events.reset)},o.prototype.setSelected=function(e){var i;this.config.data||this.el.multiple||!this.el.options.length||(0===this.el.selectedIndex&&(this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1)),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),h.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data&&(!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&this.select(0),i=0,h.each(this.config.data,function(e,t){l(t,"children")?h.each(t.children,function(e,t){t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++},this):(t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++)},this))},o.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.textContent=""),h.removeClass(this.el,"selectr-hidden"),this.el.form&&h.off(this.el.form,"reset",this.events.reset),h.off(document,"click",this.events.dismiss),h.off(document,"keydown",this.events.navigate),h.off(window,"resize",this.update),h.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)},o.prototype.change=function(e){var t=this.items[e],i=this.options[e];i.disabled||(i.selected&&h.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},o.prototype.select=function(n){var e=this.items[n],t=[].slice.call(this.el.options),i=this.options[n];if(this.el.multiple){if(h.includes(this.selectedIndexes,n))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(i.value),this.selectedIndexes.push(n),function(e){var l,c=this,i=document.createDocumentFragment(),t=this.options[e.idx],n=this.data?this.data[e.idx]:t,n=this.customSelected?this.config.renderSelection(n):t.textContent,n=h.createElement("li",{class:"selectr-tag",html:n}),r=h.createElement("button",{class:"selectr-tag-remove",type:"button"});n.appendChild(r),n.idx=e.idx,n.tag=t.value,this.tags.push(n),this.config.sortSelected?(r=this.tags.slice(),l=function(e,n){e.replace(/(\d+)|(\D+)/g,function(e,t,i){n.push([t||1/0,i||""])})},r.sort(function(e,t){var i,n,r=[],o=[];for(!0===c.config.sortSelected?(i=e.tag,n=t.tag):"text"===c.config.sortSelected&&(i=e.textContent,n=t.textContent),l(i,r),l(n,o);r.length&&o.length;){var s=r.shift(),a=o.shift(),s=s[0]-a[0]||s[1].localeCompare(a[1]);if(s)return s}return r.length-o.length}),h.each(r,function(e,t){i.appendChild(t)}),this.label.textContent=""):i.appendChild(n),this.config.taggable?this.label.insertBefore(i,this.input.parentNode):this.label.appendChild(i)}.call(this,e)}else{var r=this.data?this.data[n]:i;this.label.textContent=this.customSelected?this.config.renderSelection(r):i.textContent,this.selectedValue=i.value,this.selectedIndex=n,h.each(this.options,function(e,t){var i=this.items[e];e!==n&&(i&&h.removeClass(i,"selected"),t.selected=!1,t.removeAttribute("selected"))},this)}h.includes(t,i)||this.el.add(i),e.setAttribute("aria-selected",!0),h.addClass(e,"selected"),h.addClass(this.container,"has-selected"),i.selected=!0,i.setAttribute("selected",""),this.emit("selectr.change",i),this.emit("selectr.select",i)},o.prototype.deselect=function(e,t){var i=this.items[e],n=this.options[e];if(this.el.multiple){var r=this.selectedIndexes.indexOf(e),r=(this.selectedIndexes.splice(r,1),this.selectedValues.indexOf(n.value));this.selectedValues.splice(r,1),function(i){var n=!1;h.each(this.tags,function(e,t){t.idx===i.idx&&(n=t)},this),n&&(this.label.removeChild(n),this.tags.splice(this.tags.indexOf(n),1))}.call(this,i),this.tags.length||h.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.textContent="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,h.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),h.removeClass(this.items[e],"selected"),n.selected=!1,n.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",n)},o.prototype.setValue=function(i){var n=Array.isArray(i);if(n||(i=i.toString().trim()),!this.el.multiple&&n)return!1;h.each(this.options,function(e,t){(n&&h.includes(i.toString(),t.value)||t.value===i)&&this.change(t.idx)},this)},o.prototype.getValue=function(e,t){var i,n;return this.el.multiple?e?this.selectedIndexes.length&&(n={values:[]},h.each(this.selectedIndexes,function(e,t){t=this.options[t];n.values[e]={value:t.value,text:t.textContent}},this)):n=this.selectedValues.slice():n=e?{value:(i=this.options[this.selectedIndex]).value,text:i.textContent}:this.selectedValue,n=e&&t?JSON.stringify(n):n},o.prototype.add=function(i,n){if(i){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(i))h.each(i,function(e,t){this.add(t,n)},this);else if("[object Object]"===Object.prototype.toString.call(i)){if(n){var r=!1;if(h.each(this.options,function(e,t){t.value.toLowerCase()===i.value.toLowerCase()&&(r=!0)}),r)return!1}var e=h.createElement("option",i);return this.data.push(i),this.options.push(e),e.idx=0<this.options.length?this.options.length-1:0,c.call(this,e),i.selected&&this.select(e.idx),e}return this.setPlaceholder(),this.config.pagination&&this.paginate(),!0}},o.prototype.remove=function(i){var n,r=[];Array.isArray(i)?h.each(i,function(e,t){h.isInt(t)?r.push(this.getOptionByIndex(t)):"string"==typeof i&&r.push(this.getOptionByValue(t))},this):h.isInt(i)?r.push(this.getOptionByIndex(i)):"string"==typeof i&&r.push(this.getOptionByValue(i)),r.length&&(h.each(r,function(e,t){n=t.idx,this.el.remove(t),this.options.splice(n,1);t=this.items[n].parentNode;t&&t.removeChild(this.items[n]),this.items.splice(n,1),h.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate())},o.prototype.removeAll=function(){this.clear(!0),h.each(this.el.options,function(e,t){this.el.remove(t)},this),h.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},o.prototype.search=function(o){var s,e,t;this.navigating||(o=o||this.input.value,s=document.createDocumentFragment(),this.removeMessage(),h.truncate(this.tree),1<o.length?(h.each(this.options,function(e,t){var i,n,r=this.items[t.idx];h.includes(t.textContent.toLowerCase(),o.toLowerCase())&&!t.disabled?(a(r,s,this.customOption),h.removeClass(r,"excluded"),this.customOption||(r.textContent="",i=o,t=t.textContent,(n=(i=new RegExp(i,"i").exec(t))?(n=i.index,i=i.index+i[0].length,{before:t.substring(0,n),match:t.substring(n,i),after:t.substring(i)}):null)&&(r.appendChild(document.createTextNode(n.before)),(t=document.createElement("span")).className="selectr-match",t.appendChild(document.createTextNode(n.match)),r.appendChild(t),r.appendChild(document.createTextNode(n.after))))):h.addClass(r,"excluded")},this),s.childElementCount?(e=this.items[this.navIndex],t=s.firstElementChild,h.removeClass(e,"active"),this.navIndex=t.idx,h.addClass(t,"active")):this.config.taggable||this.setMessage("no results.")):i.call(this),this.tree.appendChild(s))},o.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},o.prototype.open=function(){var e=this;return!!this.options.length&&(this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(h.addClass(this.container,"native-open"),void(this.config.data&&h.each(this.options,function(e,t){this.el.add(t)},this))):(h.addClass(this.container,"open"),i.call(this),this.invert(),this.tree.scrollTop=0,h.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),void(this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))))},o.prototype.close=function(){var e;this.opened&&this.emit("selectr.close"),this.opened=!1,this.mobileDevice||this.config.nativeDropdown?h.removeClass(this.container,"native-open"):(e=h.hasClass(this.container,"notice"),this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(h.removeClass(this.container,"notice"),this.notice.textContent=""),h.removeClass(this.container,"open"),h.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),h.truncate(this.tree),t.call(this))},o.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&h.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),h.removeClass(this.container,"selectr-disabled")},o.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&h.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,h.addClass(this.container,"selectr-disabled")},o.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),h.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},o.prototype.clear=function(e){var t;this.el.multiple?this.selectedIndexes.length&&(t=this.selectedIndexes.slice(),h.each(t,function(e,t){this.deselect(t)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,e),this.emit("selectr.clear")},o.prototype.serialise=function(e){var n=[];return h.each(this.options,function(e,t){var i={value:t.value,text:t.textContent};t.selected&&(i.selected=!0),t.disabled&&(i.disabled=!0),n[e]=i}),e?JSON.stringify(n):n},o.prototype.serialize=function(e){return this.serialise(e)},o.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e="No options available"),this.placeEl.textContent=e},o.prototype.paginate=function(){var i;if(this.items.length)return(i=this).pages=this.items.map(function(e,t){return t%i.config.pagination==0?i.items.slice(t,t+i.config.pagination):null}).filter(function(e){return e}),this.pages},o.prototype.setMessage=function(e,t){t&&this.close(),h.addClass(this.container,"notice"),this.notice.textContent=e},o.prototype.removeMessage=function(){h.removeClass(this.container,"notice"),this.notice.textContent=""},o.prototype.invert=function(){var e=h.rect(this.selected),t=this.tree.parentNode.offsetHeight,i=window.innerHeight;e.top+e.height+t>i?(h.addClass(this.container,"inverted"),this.isInverted=!0):(h.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=h.rect(this.tree)},o.prototype.getOptionByIndex=function(e){return this.options[e]},o.prototype.getOptionByValue=function(e){for(var t=!1,i=0,n=this.options.length;i<n;i++)if(this.options[i].value.trim()===e.toString().trim()){t=this.options[i];break}return t},e.exports=o},4188:function(e,t,i){"use strict";i.d(t,{qD:function(){return n},EX:function(){return r},WF:function(){return o},oW:function(){return s}});var n=document.body,r=10485760,o=2e4,s=2147483648},2602:function(e,t,i){"use strict";i.d(t,{w:function(){return n}});var u=i(9791);function n(i,e,n){var t,c=3<arguments.length&&void 0!==arguments[3]&&arguments[3],r="function"==typeof(s=i).getRootNode?s.getRootNode():window,o={},s=i.getBoundingClientRect(),h=e.getBoundingClientRect(),a=document.createElement("div");function l(){if(a&&a.parentNode){for(var e in a.parentNode.removeChild(a),o)t=e,Object.prototype.hasOwnProperty.call(o,t)&&((t=o[e])&&(0,u.removeEventListener)(r,e,t),delete o[e]);"function"==typeof n&&n(i)}var t}function d(e){(e=e.target)===a||(0,u.isChildOf)(e,a)||l()}return a.className="jsoneditor-anchor",a.style.position="absolute",a.style.left=s.left-h.left+"px",a.style.top=s.top-h.top+"px",a.style.width=s.width-2+"px",a.style.height=s.height-2+"px",a.style.boxSizing="border-box",e.appendChild(a),o.mousedown=(0,u.addEventListener)(r,"mousedown",d),o.mousewheel=(0,u.addEventListener)(r,"mousewheel",d),c&&(t=null,a.onmouseover=function(){clearTimeout(t),t=null},a.onmouseout=function(){t=t||setTimeout(l,200)}),a.destroy=l,a}},7923:function(e){
e.exports="data:application/javascript;base64,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"
},7907:function(h,e,t){"use strict";t.d(e,{m0:function(){return r},cC:function(){return l},Iu:function(){return c}});t(4987);var o={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+I)",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+I)",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default",containsInvalidProperties:"Contains invalid properties",containsInvalidItems:"Contains invalid items"},es:{array:"Matriz",auto:"Auto",appendText:"Agregar",appendTitle:"Agregue un nuevo campo con el tipo 'auto' después de este campo (Ctrl + Shift + Ins)",appendSubmenuTitle:"Seleccione el tipo de campo que se agregará",appendTitleAuto:"Agregue un nuevo campo con el tipo 'auto' (Ctrl + Shift + Ins)",ascending:"Ascendente",ascendingTitle:"Ordene los elementos secundarios de este ${type} en orden ascendente",actionsMenu:"Haga clic para abrir el menú de acciones (Ctrl + M)",cannotParseFieldError:"No se puede parsear el campo en JSON",cannotParseValueError:"No se puede parsear el valor en JSON",collapseAll:"Contraer todos los campos",compactTitle:"Compactar datos JSON, eliminar todos los espacios en blanco (Ctrl + Shift + I)",descending:"Descendente",descendingTitle:"Ordene los hijos de este ${type} en orden descendente",drag:"Arrastre para mover este campo (Alt + Mayús + Flechas)",duplicateKey:"llave duplicada",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos seleccionados (Ctrl + D)",duplicateField:"Duplicar este campo (Ctrl + D)",duplicateFieldError:"Nombre de campo duplicado",empty:"vacio",expandAll:"Expandir todos los campos",expandTitle:"Haga clic para expandir/contraer este campo (Ctrl + E). \n  Ctrl+Clic para expandir/contraer incluyendo todos los niños.",formatTitle:"Formatee los datos JSON, con la sangría y los avances de línea adecuados (Ctrl + I)",insert:"Insertar",insertTitle:"Inserte un nuevo campo con el tipo 'auto' antes de este campo (Ctrl + Ins)",insertSub:"Seleccione el tipo de campo a insertar",object:"Objeto",ok:"Ok",redo:"Rehacer (Ctrl+Mayús+Z)",removeText:"Eliminar",removeTitle:"Eliminar campos seleccionados (Ctrl+Supr)",removeField:"Eliminar este campo (Ctrl+Supr)",repairTitle:"Reparar JSON: corrija comillas y caracteres de escape, elimine comentarios y notación JSONP, convierta objetos JavaScript en JSON.",searchTitle:"Campos de búsqueda y valores",searchNextResultTitle:"Siguiente resultado (Entrar)",searchPreviousResultTitle:"Resultado anterior (Shift + Enter)",selectNode:"Seleccione un nodo...",showAll:"mostrar todo",showMore:"mostrar más",showMoreStatus:"mostrando ${visibleChilds} de ${totalChilds} elementos.",sort:"Ordenar",sortTitle:"Ordene los hijos de este ${type}",sortTitleShort:"Ordenar contenidos",sortFieldLabel:"Campo:",sortDirectionLabel:"Dirección:",sortFieldTitle:"Seleccione el campo anidado por el cual ordenar la matriz u objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar el campo seleccionado en orden ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar por el campo seleccionado, en orden descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar o transformar los hijos de este ${type}",transformTitleShort:"Filtrar, ordenar o transformar contenidos",extract:"Extraer",extractTitle:"Extrae este ${type}",transformQueryTitle:"Ingrese una consulta JMESPath",transformWizardLabel:"Wizard",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Seleccione un campo",transformQueryLabel:"Consulta",transformPreviewLabel:"Vista Previa",type:"Tipo",typeTitle:"Cambiar el tipo de campo",openUrl:"Ctrl+Click o Ctrl+Enter para abrir la URL en una nueva ventana",undo:"Deshacer la última acción (Ctrl+Z)",validationCannotMove:"No se puede mover un campo a un hijo de sí mismo.",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Tipo de campo "objeto".  Un objeto contiene un conjunto desordenado de pares clave/valor.',arrayType:'Tipo de campo "matriz".  Una matriz contiene una colección ordenada de valores.',stringType:'Tipo de campo "cadena".  El tipo de campo no se determina a partir del valor,  pero siempre se devuelve como una cadena.',modeEditorTitle:"Cambiar modo de editor",modeCodeText:"Codigo",modeCodeTitle:"Cambiar al resaltador de código",modeFormText:"Formulario",modeFormTitle:"Cambiar al editor de formularios",modeTextText:"Texto",modeTextTitle:"Cambiar al editor de texto sin formato",modeTreeText:"Arbol",modeTreeTitle:"Cambiar al editor de árbol",modeViewText:"Vista",modeViewTitle:"Cambiar a la vista de árbol",modePreviewText:"Vista Previa",modePreviewTitle:"Cambiar al modo de vista previa",examples:"Ejemplos",default:"Predeterminado",containsInvalidProperties:"Contiene propiedades no validas",containsInvalidItems:"Contiene items no validos"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",collapseAll:"缩进所有字段",compactTitle:"压缩JSON数据，删除所有空格 (Ctrl+Shift+I)",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",empty:"清空",expandAll:"展开所有字段",expandTitle:"点击 展开/收缩 该字段(Ctrl+E). \nCtrl+Click 展开/收缩 包含所有子节点.",formatTitle:"使用适当的缩进和换行符格式化JSON数据 (Ctrl+I)",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",repairTitle:"修复JSON：修复引号和转义符，删除注释和JSONP表示法，将JavaScript对象转换为JSON。",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省",containsInvalidProperties:"包含无效的属性",containsInvalidItems:"包含无效项目"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espaços em branco (Ctrl+Shift+I)",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+I)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova comentários e notação JSONP, transforme objetos JavaScript em JSON.",selectNode:"Selecione um nódulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direção:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conteúdos",transformQueryTitle:"Insira uma expressão JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Expressão",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia",containsInvalidProperties:"Contém propriedades inválidas",containsInvalidItems:"Contém itens inválidos"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:"Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \nAlt alanlarda dahil tüm alanları açmak için Ctrl+Click ",insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan",containsInvalidProperties:"Geçersiz özellikler içeriyor",containsInvalidItems:"Geçersiz öğeler içeriyor"},ja:{array:"配列",auto:"オート",appendText:"追加",appendTitle:'次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',appendSubmenuTitle:"追加するフィールドの型を選択してください",appendTitleAuto:'"オート"のフィールドを追加 (Ctrl+Shift+Ins)',ascending:"昇順",ascendingTitle:"${type}の子要素を昇順に並べ替え",actionsMenu:"クリックしてアクションメニューを開く (Ctrl+M)",collapseAll:"すべてを折りたたむ",descending:"降順",descendingTitle:"${type}の子要素を降順に並べ替え",drag:"ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)",duplicateKey:"複製キー",duplicateText:"複製",duplicateTitle:"選択中のフィールドを複製 (Ctrl+D)",duplicateField:"選択中のフィールドを複製 (Ctrl+D)",duplicateFieldError:"フィールド名が重複しています",cannotParseFieldError:"JSONのフィールドを解析できません",cannotParseValueError:"JSONの値を解析できません",empty:"空",expandAll:"すべてを展開",expandTitle:"クリックしてフィールドを展開/折りたたむ (Ctrl+E). \nCtrl+Click ですべての子要素を展開/折りたたむ",insert:"挿入",insertTitle:"選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)",insertSub:"挿入するフィールドの型を選択",object:"オブジェクト",ok:"実行",redo:"やり直す (Ctrl+Shift+Z)",removeText:"削除",removeTitle:"選択中のフィールドを削除 (Ctrl+Del)",removeField:"選択中のフィールドを削除 (Ctrl+Del)",selectNode:"ノードを選択...",showAll:"すべてを表示",showMore:"もっと見る",showMoreStatus:"${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。",sort:"並べ替え",sortTitle:"${type}の子要素を並べ替え",sortTitleShort:"並べ替え",sortFieldLabel:"フィールド:",sortDirectionLabel:"順序:",sortFieldTitle:"配列またはオブジェクトを並び替えるためのフィールドを選択",sortAscending:"昇順",sortAscendingTitle:"選択中のフィールドを昇順に並び替え",sortDescending:"降順",sortDescendingTitle:"選択中のフィールドを降順に並び替え",string:"文字列",transform:"変換",transformTitle:"${type}の子要素をフィルター・並び替え・変換する",transformTitleShort:"内容をフィルター・並び替え・変換する",extract:"抽出",extractTitle:"${type}を抽出",transformQueryTitle:"JMESPathクエリを入力",transformWizardLabel:"ウィザード",transformWizardFilter:"フィルター",transformWizardSortBy:"並び替え",transformWizardSelectFields:"フィールドを選択",transformQueryLabel:"クエリ",transformPreviewLabel:"プレビュー",type:"型",typeTitle:"選択中のフィールドの型を変更",openUrl:"Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く",undo:"元に戻す (Ctrl+Z)",validationCannotMove:"子要素に移動できません ",autoType:"オート： フィールドの型は値から自動的に決定されます。 (文字列・数値・ブール・null)",objectType:"オブジェクト： オブジェクトは順序が決まっていないキーと値のペア組み合わせです。",arrayType:"配列： 配列は順序が決まっている値の集合体です。",stringType:"文字列： フィールド型は値から決定されませんが、常に文字列として返されます。",modeCodeText:"コードモード",modeCodeTitle:"ハイライトモードに切り替え",modeFormText:"フォームモード",modeFormTitle:"フォームモードに切り替え",modeTextText:"テキストモード",modeTextTitle:"テキストモードに切り替え",modeTreeText:"ツリーモード",modeTreeTitle:"ツリーモードに切り替え",modeViewText:"ビューモード",modeViewTitle:"ビューモードに切り替え",modePreviewText:"プレビュー",modePreviewTitle:"プレビューに切り替え",examples:"例",default:"デフォルト",containsInvalidProperties:"無効なプロパティが含まれています",containsInvalidItems:"無効なアイテムが含まれています"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' après ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"Sélectionner le type du champ à ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"Déplacer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la clé",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs sélectionnés (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible à parser en JSON",cannotParseValueError:"Valeur impossible à parser en JSON",empty:"vide",expandAll:"Étendre",expandTitle:"Étendre/regrouper ce champ (Ctrl+E). \nCtrl+Click pour étendre/regrouper avec tous les champs.",insert:"Insérer",insertTitle:"Insérer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"Sélectionner le type de champ à insérer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs sélectionnés (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"Résultat suivant (Enter)",searchPreviousResultTitle:"Résultat précédent (Shift + Enter)",selectNode:"Sélectionner un nœud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} éléments affichés de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"Sélectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs sélectionnés par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs sélectionnés par ordre descendant",string:"Chaîne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requête JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"Sélectionner les champs",transformQueryLabel:"Requête",transformPreviewLabel:"Prévisualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fenêtre",undo:"Annuler la dernière action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement déterminé en fonction de la valeur et peut être de type "chaîne", "nombre", "booléen" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonné de paires clé/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonnée de valeurs.',stringType:'Champ de type "chaîne". Ce type de champ n\'est pas déterminé en fonction de la valeur, mais retourne systématiquement une chaîne de caractères.',modeEditorTitle:"Changer mode d'édition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer éditeur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer éditeur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Prévisualisation",modePreviewTitle:"Activer mode prévisualiser",examples:"Exemples",default:"Défaut",containsInvalidProperties:"Contient des propriétés non valides",containsInvalidItems:"Contient des éléments invalides"},de:{array:"Auflistung",auto:"Auto",appendText:"anhängen",appendTitle:"Fügen Sie nach diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Umschalt+Ein)",appendSubmenuTitle:"Wählen Sie den Typ des neuen Feldes",appendTitleAuto:"Ein neues Feld vom Typ 'auto' hinzufügen (Strg+Umschalt+Ein)",ascending:"Aufsteigend",ascendingTitle:"Sortieren Sie die Elemente dieses ${type} in aufsteigender Reihenfolge",actionsMenu:"Klicken Sie zum Öffnen des Aktionsmenüs (Strg+M)",cannotParseFieldError:"Feld kann nicht in JSON geparst werden",cannotParseValueError:"Wert kann nicht in JSON geparst werden",collapseAll:"Alle Felder zuklappen",compactTitle:"JSON-Daten verdichten, alle Leerzeichen entfernen (Strg+Umschalt+\\)",descending:"Absteigend",descendingTitle:"Sortieren Sie die Elemente dieses ${type} in absteigender Reihenfolge",drag:"Ziehen, um dieses Feld zu verschieben (Alt+Umschalt+Pfeile)",duplicateKey:"Doppelter Schlüssel",duplicateText:"Duplikat",duplicateTitle:"Ausgewählte Felder duplizieren (Strg+D)",duplicateField:"Dieses Feld duplizieren (Strg+D)",duplicateFieldError:"Doppelter Feldname",empty:"leer",expandAll:"Alle Felder anzeigen",expandTitle:"Klicken Sie, um dieses Feld zu erweitern/zu kollabieren (Strg+E). \nStrg+Klicken Sie, um dieses Feld einschließlich aller Elemente zu erweitern/zu kollabieren.",formatTitle:"JSON-Daten mit korrekter Einrückung und Zeilenvorschüben formatieren (Strg+\\)",insert:"einfügen",insertTitle:"Fügen Sie vor diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Einfg)",insertSub:"Wählen Sie den Typ des neuen Feldes",object:"Objekt",ok:"Ok",redo:"Wiederholen (Strg+Umschalt+Z)",removeText:"entfernen",removeTitle:"Ausgewählte Felder entfernen (Strg+Entf)",removeField:"Dieses Feld entfernen (Strg+Entf)",repairTitle:"JSON reparieren: Anführungszeichen und Escape-Zeichen korrigieren, Kommentare und JSONP-Notation entfernen, JavaScript-Objekte in JSON umwandeln.",searchTitle:"Suchfelder und Werte",searchNextResultTitle:"Nächstes Ergebnis (Enter)",searchPreviousResultTitle:"Vorheriges Ergebnis (Umschalt + Eingabe)",selectNode:"Wählen Sie einen Knoten aus...",showAll:"alle anzeigen",showMore:"mehr anzeigen",showMoreStatus:"Anzeige von ${visibleChilds} von ${totalChilds}-Elementen.",sort:"Sortieren",sortTitle:"Sortieren Sie die Elemente dieses ${type}",sortTitleShort:"Inhalt sortieren",sortFieldLabel:"Feld:",sortDirectionLabel:"Richtung:",sortFieldTitle:"Wählen Sie das verschachtelte Feld, nach dem das Array oder Objekt sortiert werden soll.",sortAscending:"Aufsteigend",sortAscendingTitle:"Sortieren Sie das ausgewählte Feld in aufsteigender Reihenfolge",sortDescending:"Absteigend",sortDescendingTitle:"Sortieren Sie das ausgewählte Feld in absteigender Reihenfolge",string:"Zeichenfolge",transform:"Verwandeln",transformTitle:"Die Elemente dieses ${type} filtern, sortieren oder transformieren",transformTitleShort:"Inhalte filtern, sortieren oder transformieren",extract:"Auszug",extractTitle:"Extrahieren Sie diesen ${type}",transformQueryTitle:"Eine JMESPath-Abfrage eingeben",transformWizardLabel:"Zauberer",transformWizardFilter:"Filter",transformWizardSortBy:"Sortieren nach",transformWizardSelectFields:"Felder auswählen",transformQueryLabel:"Anfrage",transformPreviewLabel:"Vorschau",type:"Geben Sie  ein.",typeTitle:"Ändern Sie den Typ dieses Feldes",openUrl:"Strg+Klicken oder Strg+Eingabe, um die URL in einem neuen Fenster zu öffnen",undo:"Letzte Aktion rückgängig machen (Strg+Z)",validationCannotMove:"Kann ein Feld nicht in ein Kind seiner selbst verschieben",autoType:'Feldtyp "auto". Der Feldtyp wird automatisch aus dem Wert bestimmt und kann ein String, eine Zahl, boolesch oder null sein.',objectType:'Feldtyp "Objekt". Ein Objekt enthält eine ungeordnete Menge von Schlüssel/Wert-Paaren.',arrayType:'Feldtyp "Array". Ein Array enthält eine geordnete Sammlung von Werten.',stringType:'Feldtyp "Zeichenfolge". Der Feldtyp wird nicht aus dem Wert bestimmt, sondern immer als Zeichenfolge zurückgegeben.',modeEditorTitle:"Editor-Modus umschalten",modeCodeText:"Code",modeCodeTitle:"Umschalten auf Code-Highlighter",modeFormText:"Formular",modeFormTitle:"Zum Formular-Editor wechseln",modeTextText:"Text",modeTextTitle:"Zum Editor für einfachen Text wechseln",modeTreeText:"Baum",modeTreeTitle:"Zum Baum-Editor wechseln",modeViewText:"Siehe",modeViewTitle:"Zur Baumansicht wechseln",modePreviewText:"Vorschau",modePreviewTitle:"In den Vorschau-Modus wechseln",examples:"Beispiele",default:"Standardmäßig",containsInvalidProperties:"Enthält ungültige Eigenschaften",containsInvalidItems:"Enthält ungültige Elemente"},ru:{array:"Массив",auto:"Авто",appendText:"Добавить",appendTitle:"Добавить новое поле с типом 'авто' после этого поля (Ctrl+Shift+Ins)",appendSubmenuTitle:"Выбрать тип поля для добавления",appendTitleAuto:"Добавить новое поле с типом 'авто' (Ctrl+Shift+Ins)",ascending:"По возрастанию",ascendingTitle:"Сортировать ${type} по возрастанию",actionsMenu:"Нажмите для открытия меню действий (Ctrl+M)",cannotParseFieldError:"Невозможно преобразовать поле в JSON",cannotParseValueError:"Невозможно преобразовать значение в JSON",collapseAll:"Свернуть все",compactTitle:"Минификация JSON (Ctrl+Shift+I)",descending:"По убыванию",descendingTitle:"Сортировать ${type} по убыванию",drag:"Потяните для перемещения этого поля (Alt+Shift+Arrows)",duplicateKey:"повторяющийся ключ",duplicateText:"Дублировать",duplicateTitle:"Дублирование полей (Ctrl+D)",duplicateField:"Дублировать поле (Ctrl+D)",duplicateFieldError:"Дублирование названия поля",empty:"пустой",expandAll:"Развернуть все",expandTitle:"Нажмите для раскрытия/скрытия поля (Ctrl+E)\nили Ctrl+Click для раскрытия/скрытия всех потомков.",formatTitle:"Форматирование JSON (Ctrl+I)",insert:"Вставить",insertTitle:"Вставить новое поле с типом 'авто' перед этим полем (Ctrl+Ins)",insertSub:"Выбрать тип поля для вставки",object:"Объект",ok:"ОК",redo:"Повторить (Ctrl+Shift+Z)",removeText:"Удалить",removeTitle:"Удалить выбранные поля (Ctrl+Del)",removeField:"Удалить поле (Ctrl+Del)",repairTitle:"Восстановите JSON: исправьте кавычки и escape-символы, удалите комментарии и нотацию JSONP, модифицируйте объекты JavaScript в JSON.",searchTitle:"Поиск",searchNextResultTitle:"Следующий результат (Enter)",searchPreviousResultTitle:"Предыдущий результат (Shift + Enter)",selectNode:"Выбор узла...",showAll:"показать все",showMore:"больше",showMoreStatus:"${visibleChilds} из ${totalChilds}",sort:"Сортировка",sortTitle:"Сортировка потомков типа ${type}",sortTitleShort:"Сортировка содержимого",sortFieldLabel:"Поле:",sortDirectionLabel:"Направление:",sortFieldTitle:"Выберите поле для сортировки массива или объекта",sortAscending:"По возрастанию",sortAscendingTitle:"Сортировка выбранного поря по возрастанию",sortDescending:"По убыванию",sortDescendingTitle:"Сортировка выбранного поря по убыванию",string:"Строка",transform:"Модификация",transformTitle:"Фильтрация, сортировка или модификация данных типа ${type}",transformTitleShort:"Фильтрация, сортировка или модификация данных",extract:"Извлечение",extractTitle:"Извлечь тип ${type}",transformQueryTitle:"Введите JMESpath запрос",transformWizardLabel:"Мастер",transformWizardFilter:"Фильтр",transformWizardSortBy:"Сортировка",transformWizardSelectFields:"Поля",transformQueryLabel:"Запрос",transformPreviewLabel:"Просмотр",type:"Тип",typeTitle:"Изменить тип этого поля",openUrl:"Ctrl+Click или Ctrl+Enter для открытия url в новом окне",undo:"Отменить (Ctrl+Z)",validationCannotMove:"Поле не может быть перемещено в потомка",autoType:"Тип поля автоматически определяется по значению и может быть строкой, числом, логическим значением или null.",objectType:"Объект содержит неупорядоченный набор пар ключ/значение.",arrayType:"Массив содержит упорядоченный набор значений.",stringType:"Тип поля не определяется из значения, но всегда возвращается как строка.",modeEditorTitle:"Переключение режима редактора",modeCodeText:"Код",modeCodeTitle:"Переключить в режим редактора кода",modeFormText:"Форма",modeFormTitle:"Переключить в режим формы",modeTextText:"Текст",modeTextTitle:"Переключить в режим редактора текста",modeTreeText:"Дерево",modeTreeTitle:"Переключить в режим редактора дерева",modeViewText:"Просмотр дерева",modeViewTitle:"Переключить в режим просмотра дерева",modePreviewText:"Просмотр",modePreviewTitle:"Переключить в режим просмотра",examples:"Примеры",default:"По умолчанию",containsInvalidProperties:"Содержит недопустимые свойства",containsInvalidItems:"Содержит недопустимые элементы"},ko:{array:"배열",auto:"자동",appendText:"추가",appendTitle:'선택한 요소 아래에 "자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',appendSubmenuTitle:"추가할 요소의 유형을 선택해주세요.",appendTitleAuto:'"자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',ascending:"오름차순",ascendingTitle:"선택한 ${type}의 하위 요소를 오름차순 정렬합니다.",actionsMenu:"메뉴 열기 (Ctrl + M)",cannotParseFieldError:"JSON의 요소를 해석할 수 없습니다.",cannotParseValueError:"JSON의 값을 해석할 수 없습니다.",collapseAll:"모두 접기",compactTitle:"모든 공백을 제거하여 JSON 데이터를 작게 만듭니다. (Ctrl + Shift + I)",descending:"내림차순",descendingTitle:"선택한 ${type}의 하위 요소를 내림차순으로 정렬",drag:"드래그하여 요소를 이동합니다. (Alt + Shift + Arrows)",duplicateKey:"복제키",duplicateText:"복제",duplicateTitle:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateField:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateFieldError:"요소 이름이 중복되었습니다.",empty:"비어있음",expandAll:"모두 열기",expandTitle:"클릭하여 요소를 열거나 닫습니다. (Ctrl + E) \nCtrl + Click으로 모든 하위 요소를 열거나 닫습니다.",formatTitle:"적절한 들여쓰기 및 줄바꿈으로 JSON 데이터를 정형화합니다. (Ctrl + I)",insert:"삽입",insertTitle:"선택한 요소 위에 새요소를 삽입합니다. (Ctrl + Ins)",insertSub:"삽입할 요소의 유형을 선택해주세요.",object:"객체",ok:"확인",redo:"다시 실행 (Ctrl + Shift + Z)",removeText:"삭제",removeTitle:"선택한 요소를 삭제합니다. (Ctrl + Del)",removeField:"선택한 요소를 삭제합니다. (Ctrl + Del)",repairTitle:"JSON 교정: JSON 내의 주석과 JSONP 표기법을 지우고 따옴표와 이스케이프 문자를 수정합니다.",searchTitle:"요소 또는 값 찾기",searchNextResultTitle:"다음으로 찾기 (Enter)",searchPreviousResultTitle:"이전으로 찾기 (Shift + Enter)",selectNode:"요소를 선택해주세요...",showAll:"모두보기",showMore:"더보기",showMoreStatus:"${totalChilds} 개의 항목 중 ${visibleChilds} 개를 표시합니다.",sort:"정렬",sortTitle:"선택한 ${type}의 하위 요소를 정렬합니다.",sortTitleShort:"정렬",sortFieldLabel:"요소:",sortDirectionLabel:"순서:",sortFieldTitle:"배열이나 객체를 정렬하는 요소를 선택해주세요.",sortAscending:"오름차순",sortAscendingTitle:"선택한 요소를 오름차순으로 정렬합니다.",sortDescending:"내림차순",sortDescendingTitle:"선택한 요소를 내림차순으로 정렬합니다.",string:"문자",transform:"변환",transformTitle:"선택한 ${type}의 하위 요소를 필터하거나 정렬 또는 변환합니다.",transformTitleShort:"내용을 필터하거나 정렬 또는 변환합니다.",extract:"추출",extractTitle:"선택한 ${type}의 값을 최상위에 위치시킵니다.",transformQueryTitle:"JMESPath 쿼리를 입력해주세요.",transformWizardLabel:"마법사",transformWizardFilter:"필터",transformWizardSortBy:"정렬",transformWizardSelectFields:"요소를 선택해주세요.",transformQueryLabel:"쿼리",transformPreviewLabel:"미리보기",type:"유형",typeTitle:"선택한 요소의 유형을 변경합니다.",openUrl:"Ctrl + Click 또는 Ctrl + Enter로 새 창에서 URL 열기",undo:"실행 취소 (Ctrl + Z)",validationCannotMove:"하위 요소로 이동할 수 없습니다.",autoType:"자동: 요소의 형식이 값의 유형으로 결정됩니다. 문자, 숫자, 부울, 또는 null만 허용됩니다.",objectType:"객체: 순서대로 나열되지 않은 이름/값 쌍으로 이루어진 집합입니다.",arrayType:"배열: 순서대로 나열된 값의 집합입니다.",stringType:"문자: 요소의 유형이 값에서 결정되지 않지만 항상 문자로 반환됩니다.",modeEditorTitle:"편집기 유형 변경",modeCodeText:"코드",modeCodeTitle:"형식 교정을 도와주는 기능이 포함된 문자 편집기",modeFormText:"입력 양식",modeFormTitle:"정해진 요소에 값을 입력하는 편집기",modeTextText:"문자",modeTextTitle:"단순 문자 편집기",modeTreeText:"트리",modeTreeTitle:"트리 구조로 표시되는 편집기",modeViewText:"보기",modeViewTitle:"읽기전용 트리 구조로 JSON을 표시",modePreviewText:"미리보기",modePreviewTitle:"읽기전용 문자로 JSON을 표시",examples:"예제",default:"기본값",containsInvalidProperties:"잘못된 속성이 포함되어 있습니다.",containsInvalidItems:"잘못된 항목이 포함되어 있습니다"}},i=Object.keys(o),s="en",n="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0,a=i.find(function(e){return e===n})||s;function r(t){var e;t&&((e=i.find(function(e){return e===t}))?a=e:console.error("Language not found"))}function l(e){if(e)for(var t in e)!function(t){i.find(function(e){return e===t})||i.push(t),o[t]=Object.assign({},o[s],o[t],e[t])}(t)}function c(e,t,i){var n=o[i=i||a][e]||o[s][e]||e;if(t)for(var r in t)n=n.replace("${"+r+"}",t[r]);return n}},6056:function(e,t,i){"use strict";i.d(t,{r:function(){return r},J:function(){return o}});var t=i(5156),n=i.n(t),s=i(9791);function r(e,t){var i,n=t.sort,r=t.filter,t=t.projection,o="";return r?(i="@"!==r.field?["0"].concat((0,s.parsePath)("."+r.field)):["0"],i="string"==typeof(0,s.get)(e,i)?r.value:(0,s.parseString)(r.value),o+="[? "+r.field+" "+r.relation+" `"+JSON.stringify(i)+"`]"):o+=Array.isArray(e)?"[*]":"@",n&&("desc"===n.direction?o+=" | reverse(sort_by(@, &"+n.field+"))":o+=" | sort_by(@, &"+n.field+")"),t&&("]"!==o[o.length-1]&&(o+=" | [*]"),1===t.fields.length?o+="."+t.fields[0]:1<t.fields.length&&(o+=".{"+t.fields.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")),o}function o(e,t){return n().search(e,t)}},4987:function(){function e(e){void 0!==e&&("remove"in e||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){void 0!==this.parentNode&&this.parentNode.removeChild(this)}}))}"undefined"!=typeof Element&&(void 0!==window.Element&&e(window.Element.prototype),void 0!==window.CharacterData&&e(window.CharacterData.prototype),void 0!==window.DocumentType&&e(window.DocumentType.prototype)),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(e){for(var t=0;t<this.length;t++){var i=this[t];if(e.call(this,i,t,this))return t}return-1},configurable:!0,writable:!0}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(e){e=this.findIndex(e);return this[e]},configurable:!0,writable:!0}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},341:function(h,e,t){"use strict";t.r(e),t.d(e,{previewModeMixins:function(){return m}});var e=t(3860),i=t.n(e),s=t(4188),n=t(6436),r=t(2474);function o(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var d=function(){function n(e,t,i){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");this.onChange=e,this.calculateItemSize=t||function(){return 1},this.limit=i,this.items=[],this.index=-1}var e,t,i;return e=n,(t=[{key:"add",value:function(e){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(e),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var t=this.calculateItemSize,i=0;return this.items.forEach(function(e){i+=t(e)}),i}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}])&&o(e.prototype,t),i&&o(e,i),Object.defineProperty(e,"prototype",{writable:!1}),n}(),a=t(7907),l=t(6056),u=t(6617),g=t(6210),p=t(2558),e=t(5956),c=t(9791),t=e.textModeMixins[0].mixin,e={create:function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},i=(void 0===t.statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,t.createQuery=t.createQuery||l.r,t.executeQuery=t.executeQuery||l.J,"number"==typeof(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2,(0,a.cC)(this.options.languages),(0,a.m0)(this.options.language),this.mode="preview",this),e=(this.container=e,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=(0,c.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(e){e.preventDefault()},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null});this.frameFocusTracker=new r.R(e),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.textContent="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar&&((0,c.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(e=document.createElement("button")).type="button",e.className="jsoneditor-format",e.title=(0,a.Iu)("formatTitle"),this.menu.appendChild(e),e.onclick=function(){i.executeWithBusyMessage(function(){try{i.format()}catch(e){i._onError(e)}},"formatting...")},(e=document.createElement("button")).type="button",e.className="jsoneditor-compact",e.title=(0,a.Iu)("compactTitle"),this.menu.appendChild(e),e.onclick=function(){i.executeWithBusyMessage(function(){try{i.compact()}catch(e){i._onError(e)}},"compacting...")},this.options.enableSort&&((e=document.createElement("button")).type="button",e.className="jsoneditor-sort",e.title=(0,a.Iu)("sortTitleShort"),e.onclick=function(){i._showSortModal()},this.menu.appendChild(e)),this.options.enableTransform&&((e=document.createElement("button")).type="button",e.title=(0,a.Iu)("transformTitleShort"),e.className="jsoneditor-transform",e.onclick=function(){i._showTransformModal()},this.dom.transform=e,this.menu.appendChild(e)),(e=document.createElement("button")).type="button",e.className="jsoneditor-repair",e.title=(0,a.Iu)("repairTitle"),this.menu.appendChild(e),!(e.onclick=function(){void 0===i.json&&i.executeWithBusyMessage(function(){try{i.repair()}catch(e){i._onError(e)}},"repairing...")})!==this.options.history&&(this.history=new d(function(){i.dom.undo.disabled=!i.history.canUndo(),i.dom.redo.disabled=!i.history.canRedo()},function(e){return 2*e.text.length},s.oW),(e=document.createElement("button")).type="button",e.className="jsoneditor-undo jsoneditor-separator",e.title=(0,a.Iu)("undo"),e.onclick=function(){var e=i.history.undo();e&&i._applyHistory(e)},this.menu.appendChild(e),this.dom.undo=e,(e=document.createElement("button")).type="button",e.className="jsoneditor-redo",e.title=(0,a.Iu)("redo"),e.onclick=function(){var e=i.history.redo();e&&i._applyHistory(e)},this.menu.appendChild(e),this.dom.redo=e,this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new u.x(this.menu,this.options.modes,this.options.mode,function(e){try{i.setMode(e),i.modeSwitcher.focus()}catch(e){i._onError(e)}}))),this.errorTable=new n.Q({errorTableVisible:!0,onToggleVisibility:function(){i.validate()},onFocusLine:null,onChangeHeight:function(e){e=e+(i.dom.statusBar?i.dom.statusBar.clientHeight:0)+1;i.content.style.marginBottom=-e+"px",i.content.style.paddingBottom=e+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),t.statusBar&&((0,c.addClassName)(this.content,"has-status-bar"),e=document.createElement("div"),(this.dom.statusBar=e).className="jsoneditor-statusbar",this.frame.appendChild(e),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",e.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",e.appendChild(this.dom.arrayInfo),e.appendChild(this.errorTable.getErrorCounter()),e.appendChild(this.errorTable.getWarningIcon()),e.appendChild(this.errorTable.getErrorIcon())),this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var e=this.getText();this.dom.previewText.nodeValue=(0,c.limitCharacters)(e,s.WF),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+(0,c.formatSize)(e.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},m=(e._showSortModal=function(){var o=this;this.executeWithBusyMessage(function(){var e=o.options.modalAnchor||s.qD,r=o.get();o._renderPreview(),(0,g.showSortModal)(e,r,function(n){o.executeWithBusyMessage(function(){var e,t,i;e=r,t=n,Array.isArray(e)&&(i=(0,c.sort)(e,t.path,t.direction),o.sortedBy=t,o._setAndFireOnChange(i)),(0,c.isObject)(e)&&(i=(0,c.sortObjectKeys)(e,t.direction),o.sortedBy=t,o._setAndFireOnChange(i))},"sorting...")},o.sortedBy)},"parsing...")},e._showTransformModal=function(){var o=this;this.executeWithBusyMessage(function(){var e=o.options,t=e.createQuery,i=e.executeQuery,n=e.modalAnchor,e=e.queryDescription,r=o.get();o._renderPreview(),(0,p.showTransformModal)({container:n||s.qD,json:r,queryDescription:e,createQuery:t,executeQuery:i,onTransform:function(t){o.executeWithBusyMessage(function(){var e=i(r,t);o._setAndFireOnChange(e)},"transforming...")}})},"parsing...")},e.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history&&(this.history.clear(),this.history=null),this.frameFocusTracker.destroy()},e.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setTextAndFireOnChange(t,e)},e.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setTextAndFireOnChange(t,e)},e.repair=function(){var e=this.getText();try{var t=i()(e);this._setTextAndFireOnChange(t)}catch(e){}},e.focus=function(){this.dom.transform.focus()},e.set=function(e){this.history&&this.history.clear(),this._set(e)},e.update=function(e){this._set(e)},e._set=function(e){this.text=void 0,this.json=e,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},e._setAndFireOnChange=function(e){this._set(e),this._onChange()},e.get=function(){var e;return void 0===this.json&&(e=this.getText(),this.json=(0,c.parse)(e)),this.json},e.getText=function(){return void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode&&(this.text=(0,c.escapeUnicodeChars)(this.text))),this.text},e.setText=function(e){this.history&&this.history.clear(),this._setText(e)},e.updateText=function(e){this.getText()!==e&&this._setText(e)},e._setText=function(e,t){var i;!0===this.options.escapeUnicode?this.text=(0,c.escapeUnicodeChars)(e):this.text=e,this.json=t,this._renderPreview(),void 0===this.json?(i=this).executeWithBusyMessage(function(){try{i.json=i.get(),i._renderPreview(),i._pushHistory()}catch(e){}},"parsing..."):this._pushHistory(),this._debouncedValidate()},e._setTextAndFireOnChange=function(e,t){this._setText(e,t),this._onChange()},e._applyHistory=function(e){this.json=e.json,this.text=e.text,this._renderPreview(),this._debouncedValidate()},e._pushHistory=function(){var e;this.history&&(e={text:this.text,json:this.json},this.history.add(e))},e.executeWithBusyMessage=function(e,t){var i;this.getText().length>s.EX?((0,c.addClassName)((i=this).frame,"busy"),i.dom.busyContent.innerText=t,setTimeout(function(){e(),(0,c.removeClassName)(i.frame,"busy"),i.dom.busyContent.innerText=""},100)):e()},e.validate=t.validate,e._renderErrors=t._renderErrors,[{mode:"preview",mixin:e,data:"json"}])},6210:function(e,t,i){"use strict";i.r(t),i.d(t,{showSortModal:function(){return s}});var t=i(483),n=i.n(t),r=i(7907),o=i(9791);function s(e,t,s,i){var a=Array.isArray(t)?(0,o.getChildPaths)(t):[""],l=i&&i.path&&(0,o.contains)(a,i.path)?i.path:a[0],c=i&&i.direction||"asc",t='<div class="pico-modal-contents"><div class="pico-modal-header">'+(0,r.Iu)("sort")+"</div><form><table><tbody><tr>  <td>"+(0,r.Iu)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+(0,r.Iu)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+(0,r.Iu)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+(0,r.Iu)("sortAscending")+'" title="'+(0,r.Iu)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+(0,r.Iu)("sortDescending")+'" title="'+(0,r.Iu)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,r.Iu)("ok")+'" /></td></tr></tbody></table></form></div>';n()({parent:e,content:t,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){var e=t.modalElem().querySelector("form"),i=t.modalElem().querySelector("#ok"),n=t.modalElem().querySelector("#field"),r=t.modalElem().querySelector("#direction");function o(e){r.value=e,r.className="jsoneditor-button-group jsoneditor-button-group-value-"+r.value}a.forEach(function(e){var t,i=document.createElement("option");i.text=""===(t=e)?"@":"."===t[0]?t.slice(1):t,i.value=e,n.appendChild(i)}),n.value=l||a[0],o(c||"asc"),r.onclick=function(e){o(e.target.getAttribute("data-value"))},i.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),s({path:n.value,direction:r.value})},e&&(e.onsubmit=i.onclick)}).afterClose(function(e){e.destroy()}).show()}},2558:function(i,e,t){"use strict";t.r(e),t.d(e,{showTransformModal:function(){return s}});var e=t(483),n=t.n(e),e=t(3879),x=t.n(e),r=t(7907);function A(e){return(A="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function k(e,h,d,u){if("boolean"==typeof e||e instanceof Boolean||null===e||"number"==typeof e||e instanceof Number||"string"==typeof e||e instanceof String||e instanceof Date)return JSON.stringify(e);if(Array.isArray(e)){for(var t=e,i=h,n=d,g=u,p=i?n+i:void 0,r=i?"[\n":"[",o=0;o<t.length;o++){var m=t[o];if(i&&(r+=p),r+=void 0!==m&&"function"!=typeof m?k(m,i,p,g):"null",o<t.length-1&&(r+=i?",\n":","),r.length>g)return r+"..."}return r+=i?"\n"+n+"]":"]"}if(e&&"object"===A(e)){var s,a=e,l=h,n=d,f=u,C=l?n+l:void 0,I=!0,c=l?"{\n":"{";if("function"==typeof a.toJSON)return k(a.toJSON(),l,n,f);for(s in a)if(function(e,t){return Object.prototype.hasOwnProperty.call(e,t)}(a,s)){var v=a[s];if(I?I=!1:c+=l?",\n":",",(c=(c+=l?C+'"'+s+'": ':'"'+s+'":')+k(v,l,C,f)).length>f)return c+"..."}return c+=l?"\n"+n+"}":"}"}}function E(e,t){for(var i="";0<t--;)i+=e;return i}var R=t(9791),T=t(4188),o='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.';function s(e){var t=e.container,A=e.json,i=e.queryDescription,i=void 0===i?o:i,b=e.createQuery,y=e.executeQuery,w=e.onTransform,S=A,e='<label class="pico-modal-contents"><div class="pico-modal-header">'+(0,r.Iu)("transform")+"</div><p>"+i+'</p><div class="jsoneditor-jmespath-label">'+(0,r.Iu)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+(0,r.Iu)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+(0,r.Iu)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+(0,r.Iu)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+(0,r.Iu)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+(0,r.Iu)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+(0,r.Iu)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,r.Iu)("ok")+'" autofocus /></div></div>';n()({parent:t,content:e,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(n){var e=n.modalElem(),t=e.querySelector("#wizard"),o=e.querySelector("#ok"),r=e.querySelector("#filterField"),s=e.querySelector("#filterRelation"),d=e.querySelector("#filterValue"),a=e.querySelector("#sortField"),u=e.querySelector("#sortOrder"),l=e.querySelector("#selectFields"),c=e.querySelector("#query"),h=e.querySelector("#preview");Array.isArray(S)||(t.style.fontStyle="italic",t.textContent="(wizard not available for objects, only for arrays)");(0,R.getChildPaths)(A).forEach(function(e){var e=C(e),t=document.createElement("option"),t=(t.text=e,t.value=e,r.appendChild(t),document.createElement("option"));t.text=e,t.value=e,a.appendChild(t)});var t=(0,R.getChildPaths)(A,!0).filter(function(e){return""!==e}),t=(0<t.length?t.forEach(function(e){var e=C(e),t=document.createElement("option");t.text=e,t.value=e,l.appendChild(t)}):(t=e.querySelector("#selectFieldsPart"))&&(t.style.display="none"),new(x())(r,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."})),g=new(x())(s,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),p=new(x())(a,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),m=new(x())(u,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),f=new(x())(l,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function C(e){return""===e?"@":"."===e[0]?e.slice(1):e}t.on("selectr.change",i),g.on("selectr.change",i),d.oninput=i,p.on("selectr.change",i),m.on("selectr.change",i),f.on("selectr.change",i),e.querySelector(".pico-modal-contents").onclick=function(e){"A"!==e.target.nodeName&&e.preventDefault()};var I=(0,R.debounce)(function(){try{var e=y(S,c.value);h.className="jsoneditor-transform-preview",h.value=(t=e,i=2,n=T.WF,"number"==typeof i?10<i?r=E(" ",10):1<=i&&(r=E(" ",i)):"string"==typeof i&&""!==i&&(r=i),(i=k(t,r,"",n)).length>n?(t=i,("number"==typeof(r=n)?t.slice(0,r):t)+"..."):i),o.disabled=!1}catch(e){h.className="jsoneditor-transform-preview jsoneditor-error",h.value=e.toString(),o.disabled=!0}var t,i,n,r},300);function v(t,e){try{c.value=b(t,e),o.disabled=!1,I()}catch(e){t='Error: an error happened when executing "createQuery": '+(e.message||e.toString());c.value="",o.disabled=!0,h.className="jsoneditor-transform-preview jsoneditor-error",h.value=t}}function i(){var e={};if(r.value&&s.value&&d.value&&(e.filter={field:r.value,relation:s.value,value:d.value}),a.value&&u.value&&(e.sort={field:a.value,direction:u.value}),l.value){for(var t,i=[],n=0;n<l.options.length;n++)l.options[n].selected&&(t=l.options[n].value,i.push(t));e.projection={fields:i}}v(A,e)}c.oninput=I,o.onclick=function(e){e.preventDefault(),e.stopPropagation(),n.close(),w(c.value)},v(A,{}),setTimeout(function(){c.select(),c.focus(),c.selectionStart=3,c.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}},5956:function(r,e,t){"use strict";t.r(e),t.d(e,{textModeMixins:function(){return s}});var e=t(3860),i=t.n(e),e=t(8170),g=t.n(e),a=t(4188),p=t(6436),m=t(2474),l=t(7907),c=t(6056),f=t(6617),o=t(6210),C=t(2558),I=t(9125),h=t(9791);function d(e){return(d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var e={},u="ace/theme/jsoneditor";function n(){try{this.format()}catch(e){}}e.create=function(e){var t,i,n,r=this,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},s=(void 0===o.statusBar&&(o.statusBar=!0),o.mainMenuBar=!1!==o.mainMenuBar,o.enableSort=!1!==o.enableSort,o.enableTransform=!1!==o.enableTransform,o.createQuery=o.createQuery||c.r,o.executeQuery=o.executeQuery||c.J,"number"==typeof(this.options=o).indentation?this.indentation=Number(o.indentation):this.indentation=2,(0,l.cC)(this.options.languages),(0,l.m0)(this.options.language),o.ace||g()),a=(this.mode="code"===o.mode?"code":"text","code"===this.mode&&void 0===s&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=o.theme||u,this.theme===u&&s&&(0,I.O)(),o.onTextSelectionChange&&this.onTextSelectionChange(o.onTextSelectionChange),this),e=(this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this.lastSchemaErrors=void 0,this._debouncedValidate=(0,h.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){a._onKeyDown(e)},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),e=(this.frameFocusTracker=new m.R(e),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar&&((0,h.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(e=document.createElement("button")).type="button",e.className="jsoneditor-format",e.title=(0,l.Iu)("formatTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.format(),a._onChange()}catch(e){a._onError(e)}},(e=document.createElement("button")).type="button",e.className="jsoneditor-compact",e.title=(0,l.Iu)("compactTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.compact(),a._onChange()}catch(e){a._onError(e)}},this.options.enableSort&&((e=document.createElement("button")).type="button",e.className="jsoneditor-sort",e.title=(0,l.Iu)("sortTitleShort"),e.onclick=function(){a._showSortModal()},this.menu.appendChild(e)),this.options.enableTransform&&((e=document.createElement("button")).type="button",e.title=(0,l.Iu)("transformTitleShort"),e.className="jsoneditor-transform",e.onclick=function(){a._showTransformModal()},this.menu.appendChild(e)),(e=document.createElement("button")).type="button",e.className="jsoneditor-repair",e.title=(0,l.Iu)("repairTitle"),this.menu.appendChild(e),e.onclick=function(){try{a.repair(),a._onChange()}catch(e){a._onError(e)}},"code"===this.mode&&((e=document.createElement("button")).type="button",e.className="jsoneditor-undo jsoneditor-separator",e.title=(0,l.Iu)("undo"),e.onclick=function(){r.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(e),this.dom.undo=e,(e=document.createElement("button")).type="button",e.className="jsoneditor-redo",e.title=(0,l.Iu)("redo"),e.onclick=function(){r.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(e),this.dom.redo=e),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new f.x(this.menu,this.options.modes,this.options.mode,function(e){try{a.setMode(e),a.modeSwitcher.focus()}catch(e){a._onError(e)}})),"code"===this.mode&&((t=document.createElement("a")).appendChild(document.createTextNode("powered by ace")),t.href="https://ace.c9.io/",t.target="_blank",t.className="jsoneditor-poweredBy",t.onclick=function(){window.open(t.href,t.target,"noreferrer")},this.menu.appendChild(t))),this.options.onEditable&&d("function"===this.options.onEditable)&&!this.options.onEditable({}));this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"===this.mode?(this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom),n=(s=s.edit(this.editorDom)).getSession(),s.$blockScrolling=1/0,s.setTheme(this.theme),s.setOptions({readOnly:e}),s.setShowPrintMargin(!1),s.setFontSize("14px"),n.setMode("ace/mode/json"),n.setTabSize(this.indentation),n.setUseSoftTabs(!0),n.setUseWrapMode(!0),i=n.setAnnotations,n.setAnnotations=function(e){i.call(this,e&&e.length?e:a.annotations)},s.commands.bindKey("Ctrl-L",null),s.commands.bindKey("Command-L",null),s.commands.bindKey("Ctrl-\\",null),s.commands.bindKey("Command-\\",null),s.commands.bindKey("Ctrl-Shift-\\",null),s.commands.bindKey("Command-Shift-\\",null),(this.aceEditor=s).on("change",this._onChange.bind(this)),s.on("changeSelection",this._onSelect.bind(this))):((n=document.createElement("textarea")).className="jsoneditor-text",n.spellcheck=!1,this.content.appendChild(n),this.textarea=n,this.textarea.readOnly=e,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this
):this.textarea.onchange=this._onChange.bind(this),n.onselect=this._onSelect.bind(this),n.onmousedown=this._onMouseDown.bind(this),n.onblur=this._onBlur.bind(this)),this._updateHistoryButtons(),this.errorTable=new p.Q({errorTableVisible:"text"===this.mode,onToggleVisibility:function(){a._validateAndCatch()},onFocusLine:function(e){a.isFocused=!0,isNaN(e)||a.setTextSelection({row:e,column:1},{row:e,column:1e3})},onChangeHeight:function(e){e=e+(a.dom.statusBar?a.dom.statusBar.clientHeight:0)+1;a.content.style.marginBottom=-e+"px",a.content.style.paddingBottom=e+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),o.statusBar&&((0,h.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},s=document.createElement("div"),(this.dom.statusBar=s).className="jsoneditor-statusbar",this.frame.appendChild(s),(e=document.createElement("span")).className="jsoneditor-curserinfo-label",e.innerText="Ln:",(n=document.createElement("span")).className="jsoneditor-curserinfo-val",n.innerText="1",s.appendChild(e),s.appendChild(n),(o=document.createElement("span")).className="jsoneditor-curserinfo-label",o.innerText="Col:",(e=document.createElement("span")).className="jsoneditor-curserinfo-val",e.innerText="1",s.appendChild(o),s.appendChild(e),this.curserInfoElements.colVal=e,this.curserInfoElements.lnVal=n,(o=document.createElement("span")).className="jsoneditor-curserinfo-label",o.innerText="characters selected",o.style.display="none",(e=document.createElement("span")).className="jsoneditor-curserinfo-count",e.innerText="0",e.style.display="none",this.curserInfoElements.countLabel=o,this.curserInfoElements.countVal=e,s.appendChild(e),s.appendChild(o),s.appendChild(this.errorTable.getErrorCounter()),s.appendChild(this.errorTable.getWarningIcon()),s.appendChild(this.errorTable.getErrorIcon())),this.setSchema(this.options.schema,this.options.schemaRefs)},e._onChange=function(){var e=this;if(!this.onChangeDisabled){if(setTimeout(function(){e._updateHistoryButtons&&e._updateHistoryButtons()}),this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},e._updateHistoryButtons=function(){var e;this.aceEditor&&this.dom.undo&&this.dom.redo&&((e=this.aceEditor.getSession().getUndoManager())&&e.hasUndo&&e.hasRedo&&(this.dom.undo.disabled=!e.hasUndo(),this.dom.redo.disabled=!e.hasRedo()))},e._showSortModal=function(){try{var i=this,e=this.options.modalAnchor||a.qD,n=this.get();(0,o.showSortModal)(e,n,function(e){var t;Array.isArray(n)&&(t=(0,h.sort)(n,e.path,e.direction),i.sortedBy=e,i.update(t)),(0,h.isObject)(n)&&(t=(0,h.sortObjectKeys)(n,e.direction),i.sortedBy=e,i.update(t))},i.sortedBy)}catch(e){this._onError(e)}},e._showTransformModal=function(){var t=this;try{var e=this.options,i=e.modalAnchor,n=e.createQuery,r=e.executeQuery,o=e.queryDescription,s=this.get();(0,C.showTransformModal)({container:i||a.qD,json:s,queryDescription:o,createQuery:n,executeQuery:r,onTransform:function(e){e=r(s,e);t.update(e)}})}catch(e){this._onError(e)}},e._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},e._onKeyDown=function(e){var t=!1;73===(e.which||e.keyCode)&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},e._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},e._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},e._updateCursorInfo=function(){var e,t,i,n,r,o=this;function s(){o.curserInfoElements.countVal.innerText!==r&&(o.curserInfoElements.countVal.innerText=r,o.curserInfoElements.countVal.style.display=r?"inline":"none",o.curserInfoElements.countLabel.style.display=r?"inline":"none"),o.curserInfoElements.lnVal.innerText=i,o.curserInfoElements.colVal.innerText=n}this.textarea?setTimeout(function(){var e=(0,h.getInputSelection)(o.textarea);e.startIndex!==e.endIndex&&(r=e.endIndex-e.startIndex),n=r&&o.cursorInfo&&o.cursorInfo.line===e.end.row&&o.cursorInfo.column===e.end.column?(i=e.start.row,e.start.column):(i=e.end.row,e.end.column),o.cursorInfo={line:i,column:n,count:r},o.options.statusBar&&s()},0):this.aceEditor&&this.curserInfoElements&&(e=this.aceEditor.getCursorPosition(),t=this.aceEditor.getSelectedText(),i=e.row+1,n=e.column+1,r=t.length,o.cursorInfo={line:i,column:n,count:r},this.options.statusBar&&s())},e._emitSelectionChange=function(){var e;this._selectionChangedHandler&&(e=this.getTextSelection(),this._selectionChangedHandler(e.start,e.end,e.text))},e._refreshAnnotations=function(){var e,t=this.aceEditor&&this.aceEditor.getSession();t&&(e=t.getAnnotations().filter(function(e){return"error"===e.type}),t.setAnnotations(e))},e.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null,this.frameFocusTracker.destroy()},e.compact=function(){var e=this.get(),e=JSON.stringify(e);this.updateText(e)},e.format=function(){var e=this.get(),e=JSON.stringify(e,null,this.indentation);this.updateText(e)},e.repair=function(){var e=this.getText();try{var t=i()(e);this.updateText(t)}catch(e){}},e.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},e.resize=function(){this.aceEditor&&this.aceEditor.resize(!1)},e.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},e.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},e.get=function(){var e=this.getText();return(0,h.parse)(e)},e.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},e._setText=function(e,t){var i,n=this,e=!0===this.options.escapeUnicode?(0,h.escapeUnicodeChars)(e):e;this.textarea&&(this.textarea.value=e),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(e,-1),this.onChangeDisabled=!1,t&&(i=this,setTimeout(function(){i.aceEditor&&i.aceEditor.session.getUndoManager().reset()})),setTimeout(function(){n._updateHistoryButtons&&n._updateHistoryButtons()})),this._debouncedValidate()},e.setText=function(e){this._setText(e,!0)},e.updateText=function(e){this.getText()!==e&&this._setText(e,!1)},e.validate=function(){var t,i=this,n=[],r=[];try{var o=this.get(),s=(this.validateSchema&&(this.validateSchema(o)||(n=this.validateSchema.errors.map(function(e){return e.type="validation",(0,h.improveSchemaError)(e)}))),this.validationSequence=(this.validationSequence||0)+1,this),a=this.validationSequence;return function(e,t){if(!t)return Promise.resolve([]);try{var i=t(e);return((0,h.isPromise)(i)?i:Promise.resolve(i)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=(0,h.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:(0,h.stringifyPath)(e.path),message:e.message,type:"customValidation"}}):[]})}catch(e){return Promise.reject(e)}}(o,this.options.onValidate).then(function(e){return a===s.validationSequence&&(e=n.concat(r).concat(e),s._renderErrors(e),"function"==typeof i.options.onValidationError&&(0,h.isValidationErrorChanged)(e,i.lastSchemaErrors)&&i.options.onValidationError.call(i,e),i.lastSchemaErrors=e),i.lastSchemaErrors})}catch(e){return this.getText()&&((o=/\w*line\s*(\d+)\w*/g.exec(e.message))&&(t=+o[1]),r=[{type:"error",message:e.message.replace(/\n/g,"<br>"),line:t}]),this._renderErrors(r),"function"==typeof this.options.onValidationError&&(0,h.isValidationErrorChanged)(r,this.lastSchemaErrors)&&this.options.onValidationError.call(this,r),this.lastSchemaErrors=r,Promise.resolve(this.lastSchemaErrors)}},e._validateAndCatch=function(){this.validate().catch(function(e){console.error("Error running validation:",e)})},e._renderErrors=function(n){var e=this.getText(),t=[],e=(n.reduce(function(e,t){return"string"==typeof t.dataPath&&-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},t),(0,h.getPositionForPath)(e,t));this.aceEditor&&(this.annotations=e.map(function(t){var e=n.filter(function(e){return e.dataPath===t.path}),i=e.map(function(e){return e.message}).join("\n");return i?{row:t.line,column:t.column,text:"Schema validation error"+(1!==e.length?"s":"")+": \n"+i,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(n,e),this.aceEditor&&this.aceEditor.resize(!1)},e.getTextSelection=function(){var e,t,i,n={};return this.textarea?(i=(0,h.getInputSelection)(this.textarea),this.cursorInfo&&this.cursorInfo.line===i.end.row&&this.cursorInfo.column===i.end.column?(n.start=i.end,n.end=i.start):n=i,{start:n.start,end:n.end,text:this.textarea.value.substring(i.startIndex,i.endIndex)}):this.aceEditor?(i=this.aceEditor.getSelection(),e=this.aceEditor.getSelectedText(),t=i.getRange(),(i=i.getSelectionLead()).row===t.end.row&&i.column===t.end.column?n=t:(n.start=t.end,n.end=t.start),{start:{row:n.start.row+1,column:n.start.column+1},end:{row:n.end.row+1,column:n.end.column+1},text:e}):void 0},e.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=(0,h.debounce)(e,this.DEBOUNCE_INTERVAL))},e.setTextSelection=function(e,t){var i,n,r;e&&t&&(this.textarea?(i=(0,h.getIndexForPosition)(this.textarea,e.row,e.column),r=(0,h.getIndexForPosition)(this.textarea,t.row,t.column),-1<i&&-1<r&&(this.textarea.setSelectionRange?(this.textarea.focus(),this.textarea.setSelectionRange(i,r)):this.textarea.createTextRange&&((n=this.textarea.createTextRange()).collapse(!0),n.moveEnd("character",r),n.moveStart("character",i),n.select()),r=(this.textarea.value.match(/\n/g)||[]).length+1,i=this.textarea.scrollHeight/r,n=e.row*i,this.textarea.scrollTop=n>this.textarea.clientHeight?n-this.textarea.clientHeight/2:0)):this.aceEditor&&(r={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}},this.aceEditor.selection.setRange(r),this.aceEditor.scrollToLine(e.row-1,!0)))};var s=[{mode:"text",mixin:e,data:"text",load:n},{mode:"code",mixin:e,data:"text",load:n}]},8038:function(n,r,e){"use strict";e.r(r),e.d(r,{treeModeMixins:function(){return V}});var w={start:function(e,t,i){return 0===t.indexOf(e)},contain:function(e,t,i){return-1<t.indexOf(e)}};var s=e(897),l=e(2474);function o(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var S=function(){function e(){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");this.locked=!1}var t,i,n;return t=e,(i=[{key:"highlight",value:function(e){this.locked||(this.node!==e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){var e;this.locked||(e=this).node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}])&&o(t.prototype,i),n&&o(t,n),Object.defineProperty(t,"prototype",{writable:!1}),e}(),a=e(7907),c=e(6056),d=e(6617),r=e(233),u=e.n(r),g=e(2602),E=e(9791);var p=e(6210),m=e(2558),f=e(4188);function _(e){return function(e){if(Array.isArray(e))return I(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||C(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function $(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var i=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=i){var n,r,o=[],s=!0,a=!1;try{for(i=i.call(e);!(s=(n=i.next()).done)&&(o.push(n.value),!t||o.length!==t);s=!0);}catch(e){a=!0,r=e}finally{try{s||null==i.return||i.return()}finally{if(a)throw r}}return o}}(e,t)||C(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function L(e,t){var i,n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!n){if(Array.isArray(e)||(n=C(e))||t&&e&&"number"==typeof e.length)return n&&(e=n),i=0,{s:t=function(){},n:function(){return i>=e.length?{done:!0}:{done:!1,value:e[i++]}},e:function(e){throw e},f:t};throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var r,o=!0,s=!1;return{s:function(){n=n.call(e)},n:function(){var e=n.next();return o=e.done,e},e:function(e){s=!0,r=e},f:function(){try{o||null==n.return||n.return()}finally{if(s)throw r}}}}function C(e,t){if(e){if("string"==typeof e)return I(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);return"Map"===(i="Object"===i&&e.constructor?e.constructor.name:i)||"Set"===i?Array.from(e):"Arguments"===i||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)?I(e,t):void 0}}function I(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}function x(e){return(x="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function v(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var k=function(){function k(e,t){if(!(this instanceof k))throw new TypeError("Cannot call a class as a function");this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=(0,E.debounce)(this._onChangeValue.bind(this),k.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=(0,E.debounce)(this._onChangeField.bind(this),k.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}var e,t,i;return e=k,(t=[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:A}},{key:"_updateEditability",value:function(){var e,t;this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,"tree"!==this.editor.options.mode&&"form"!==this.editor.options.mode||"function"!=typeof this.editor.options.onEditable||(e=this.getValue.bind(this),"boolean"==typeof(t=this.editor.options.onEditable({field:this.field,get value(){return e()},path:this.getPath()}))?(this.editable.field=t,this.editable.value=t):"object"===x(t)&&null!==t?("boolean"==typeof t.field&&(this.editable.field=t.field),"boolean"==typeof t.value&&(this.editable.value=t.value)):(console.error("Invalid return value for function onEditable.","Actual value:",t,".","Either a boolean or object { field: boolean, value: boolean } expected."),this.editable.field=!1,this.editable.value=!1)))}},{key:"getPath",value:function(){for(var e=this,t=[];e;){var i=e.getName();void 0!==i&&t.unshift(i),e=e.parent}return t}},{key:"getInternalPath",value:function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t}},{key:"getName",value:function(){return this.parent?"array"!==this.parent.type?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(e){if(e){if(0===e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}}},{key:"findNodeByInternalPath",value:function(e){if(e){for(var t=this,i=0;i<e.length&&t;i++)var n=e[i],t=t.childs[n];return t}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(e){for(var i=(0,E.parsePath)(e),n=this;n&&0<i.length;)!function(){var t=i.shift();if("number"==typeof t){if("array"!==n.type)throw new Error("Cannot get child node at index "+t+": node is no array");n=n.childs[t]}else{if("object"!==n.type)throw new Error("Cannot get child node "+t+": node is no object");n=n.childs.filter(function(e){return e.field===t})[0]}}();return n}},{key:"findParents",value:function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e}},{key:"setError",value:function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var i=this,n=this.fieldError||this.valueError||this.error,e=this.dom.tdError;if(n&&this.dom&&this.dom.tr){(0,E.addClassName)(this.dom.tr,"jsoneditor-validation-error"),e||(e=document.createElement("td"),this.dom.tdError=e,this.dom.tdValue.parentNode.appendChild(e));var r=document.createElement("button"),t=(r.type="button",r.className="jsoneditor-button jsoneditor-schema-error",function(){i.dom.popupAnchor&&i.dom.popupAnchor.destroy()}),o=function(){delete i.dom.popupAnchor},s=function(e){var t=i.editor.frame,e=(i.dom.popupAnchor=(0,g.w)(r,i.editor.getPopupAnchor(),o,e),r.getBoundingClientRect()),t=120<t.getBoundingClientRect().width-e.x?"jsoneditor-above":"jsoneditor-left",e=document.createElement("div");e.className="jsoneditor-popover "+t,e.appendChild(document.createTextNode(n.message)),i.dom.popupAnchor.appendChild(e)},a=(r.onmouseover=function(){i.dom.popupAnchor||s(!0)},r.onfocus=function(){t(),s(!1)},r.onblur=function(){t()},this.errorChild);for(a&&(r.onclick=function(){a.findParents().forEach(function(e){e.expand(!1)}),a.scrollTo(function(){a.focus()})});e.firstChild;)e.removeChild(e.firstChild);e.appendChild(r)}else this.dom.tr&&(0,E.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),e&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){var e;return this.parent?-1!==(e=this.parent.childs.indexOf(this))?e:null:-1}},{key:"setParent",value:function(e){this.parent=e}},{key:"setField",value:function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t}},{key:"getField",value:function(){return void 0===this.field&&this._getDomField(),this.field}},{key:"setValue",value:function(e,t){var i,n,r,o,s,a,l=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),i=0;i<e.length;i++)void 0===(s=e[i])||s instanceof Function||(i<this.childs.length?((r=this.childs[i]).fieldEditable=!1,r.index=i,r.setValue(s)):(r=new k(this.editor,{value:s}),o=i<this.getMaxVisibleChilds(),this.appendChild(r,o,!1)));for(n=this.childs.length;n>=e.length;n--)this.removeChild(this.childs[n],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),n=this.childs.length-1;0<=n;n--)h(e,this.childs[n].field)||this.removeChild(this.childs[n],!1);for(var c in i=0,e)h(e,c)&&(void 0===(s=e[c])||s instanceof Function||((a=this.findChildByProperty(c))?(a.setField(c,!0),a.setValue(s)):(a=new k(this.editor,{field:c,value:s}),c=i<this.getMaxVisibleChilds(),this.appendChild(a,c,!1))),i++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(l)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(e){var t,i,n,r,o,s=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),r=0;r<e.childs.length;r++)void 0===(t=e.childs[r])||t instanceof Function||(r<this.childs.length?((i=this.childs[r]).fieldEditable=!1,i.index=r,i.setInternalValue(t)):(i=new k(this.editor,{internalValue:t}),n=r<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(o=this.childs.length;o>=e.childs.length;o--)this.removeChild(this.childs[o],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),r=0;r<e.childs.length;r++)void 0===(t=e.childs[r])||t instanceof Function||(r<this.childs.length?(delete(i=this.childs[r]).index,i.setField(t.field,!0),i.setInternalValue(t.value)):(i=new k(this.editor,{field:t.field,internalValue:t.value}),n=r<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(o=this.childs.length;o>=e.childs.length;o--)this.removeChild(this.childs[o],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(s)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){var e;this.dom&&this.dom.tr&&this.dom.tr.parentNode?(e=this._detachFromDom(),this.clearDom(),this._attachToDom(e)):this.clearDom()}},{key:"getValue",value:function(){var t,i;return"array"===this.type?(t=[],this.childs.forEach(function(e){t.push(e.getValue())}),t):"object"===this.type?(i={},this.childs.forEach(function(e){i[e.getField()]=e.getValue()}),i):(void 0===this.value&&this._getDomValue(),this.value)}},{key:"getInternalValue",value:function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e}},{key:"clone",value:function(){var t,i;return(t=new k(this.editor)).type=this.type,t.field=this.field,t.fieldInnerText=this.fieldInnerText,t.fieldEditable=this.fieldEditable,t.previousField=this.previousField,t.value=this.value,t.valueInnerText=this.valueInnerText,t.previousValue=this.previousValue,t.expanded=this.expanded,t.visibleChilds=this.visibleChilds,this.childs?(i=[],this.childs.forEach(function(e){e=e.clone();e.setParent(t),i.push(e)}),t.childs=i):t.childs=void 0,t}},{key:"expand",value:function(t){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==t&&this.childs.forEach(function(e){e.expand(t)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(t){this.childs&&(this.hideChilds(),!1!==t&&this.childs.forEach(function(e){e.collapse(t)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},{key:"showChilds",value:function(){var e=this.childs;if(e&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){for(var i=this.getAppendDom(),n=(i.parentNode||((r=e.nextSibling)?t.insertBefore(i,r):t.appendChild(i)),Math.min(this.childs.length,this.visibleChilds)),r=this._getNextTr(),o=0;o<n;o++){var s=this.childs[o];s.getDom().parentNode||t.insertBefore(s.getDom(),r),s.showChilds()}e=this.getShowMoreDom();r=this._getNextTr(),e.parentNode||t.insertBefore(e,r),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(e){var t=this.dom.tr,i=t?t.parentNode:void 0;i&&i.removeChild(t),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(e)}},{key:"hideChilds",value:function(e){var t;this.childs&&this.expanded&&((t=this.getAppendDom()).parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()}),(t=this.getShowMoreDom()).parentNode&&t.parentNode.removeChild(t),e&&!e.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds()))}},{key:"_updateCssClassName",value:function(){var e,t;this.dom.field&&this.editor&&this.editor.options&&"function"==typeof this.editor.options.onClassName&&this.dom.tree&&((0,E.removeAllClassNames)(this.dom.tree),e=this.getValue.bind(this),t=this.editor.options.onClassName({path:this.getPath(),field:this.field,get value(){return e()}})||"",(0,E.addClassName)(this.dom.tree,"jsoneditor-values "+t))}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var e=0;e<this.childs.length;e++)this.childs[e].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent}},{key:"appendChild",value:function(e,t,i){var n,r;this._hasChilds()&&(e.setParent(this),e.fieldEditable="object"===this.type,"array"===this.type&&(e.index=this.childs.length),"object"===this.type&&void 0===e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t&&(t=e.getDom(),r=(n=this._getNextTr())?n.parentNode:void 0,n&&r&&r.insertBefore(t,n),e.showChilds(),this.visibleChilds++),!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})))}},{key:"moveBefore",value:function(e,t,i){var n,r,o;this._hasChilds()&&((n=this.dom.tr?this.dom.tr.parentNode:void 0)&&((r=document.createElement("tr")).style.height=n.clientHeight+"px",n.appendChild(r)),e.parent&&e.parent.removeChild(e),t instanceof T||!t?this.childs.length+1>this.visibleChilds?(o=this.childs[this.visibleChilds-1],this.insertBefore(e,o,i)):this.appendChild(e,!0,i):this.insertBefore(e,t,i),n&&r&&n.removeChild(r))}},{key:"insertBefore",value:function(e,t,i){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&void 0===e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"===this.type,this.childs.push(e);else{var n=this.childs.indexOf(t);if(-1===n)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"===this.type,this.childs.splice(n,0,e)}var r;this.expanded&&(n=e.getDom(),r=(t=t.getDom())?t.parentNode:void 0,t&&r&&r.insertBefore(n,t),e.showChilds(),this.showChilds()),!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}}},{key:"insertAfter",value:function(e,t){this._hasChilds()&&(t=this.childs.indexOf(t),(t=this.childs[t+1])?this.insertBefore(e,t):this.appendChild(e))}},{key:"search",value:function(t,i){Array.isArray(i)||(i=[]);var e=t?t.toLowerCase():void 0;return delete this.searchField,delete this.searchValue,void 0!==this.field&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.field).toLowerCase().indexOf(e)&&(this.searchField=!0,i.push({node:this,elem:"field"})),this._updateDomField()),this._hasChilds()?this.childs&&this.childs.forEach(function(e){e.search(t,i)}):void 0!==this.value&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.value).toLowerCase().indexOf(e)&&(this.searchValue=!0,i.push({node:this,elem:"value"})),this._updateDomValue()),i}},{key:"scrollTo",value:function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)}},{key:"expandPathToNode",value:function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=this.getMaxVisibleChilds();e.parent.expand(!1),e=e.parent}}},{key:"focus",value:function(e){if(k.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":(t.drag||t.menu).focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),(0,E.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),(0,E.selectContentEditable)(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),(0,E.selectContentEditable)(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),(0,E.selectContentEditable)(t.value)):(this._hasChilds()?t.expand:t.menu).focus();break;default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),(0,E.selectContentEditable)(t.value)):t.field&&this.fieldEditable?(t.field.focus(),(0,E.selectContentEditable)(t.field)):(this._hasChilds()?t.expand:t.menu).focus()}}}},{key:"containsNode",value:function(e){if(this===e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1}},{key:"removeChild",value:function(e,t){if(this.childs){var i=this.childs.indexOf(e);if(-1!==i)return i<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue,(e=this.childs.splice(i,1)[0]).parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),e}}},{key:"_remove",value:function(e){this.removeChild(e)}},{key:"changeType",value:function(e){var t,i=this.type;i!==e&&("string"!==e&&"auto"!==e||"string"!==i&&"auto"!==i?(t=this._detachFromDom(),this.clearDom(),"object"===(this.type=e)?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,void 0===e.field&&(e.field="")}),"string"!==i&&"auto"!==i||(this.expanded=!0)):"array"===e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!==i&&"auto"!==i||(this.expanded=!0)):this.expanded=!1,this._attachToDom(t)):this.type=e,"auto"!==e&&"string"!==e||(this.value="string"===e?String(this.value):(0,E.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0}))}},{key:"deepEqual",value:function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!==x(e)||!e)return!1;var i=Object.keys(e);if(this.childs.length!==i.length)return!1;for(t=0;t<i.length;t++){var n=this.childs[t];if(n.field!==i[t]||!n.deepEqual(e[n.field]))return!1}}else if(this.value!==e)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&"array"!==this.type&&"object"!==this.type&&(this.valueInnerText=(0,E.getInnerText)(this.dom.value),""===this.valueInnerText&&""!==this.dom.value.innerHTML&&(this.dom.value.textContent="")),void 0!==this.valueInnerText)try{var e,t;(t="string"===this.type?this._unescapeHTML(this.valueInnerText):(e=this._unescapeHTML(this.valueInnerText),(0,E.parseString)(e)))!==this.value&&(this.value=t,this._debouncedOnChangeValue())}catch(e){this._setValueError((0,a.Iu)("cannotParseValueError"))}}},{key:"_setValueError",value:function(e){this.valueError={message:e},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(e){this.fieldError={message:e},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var e,t=this.editor.getDomSelection(),i=(t.range&&(i=(0,E.textDiff)(String(this.value),String(this.previousValue)),t.range.startOffset=i.start,t.range.endOffset=i.end),this.editor.getDomSelection());i.range&&(e=(0,E.textDiff)(String(this.previousValue),String(this.value)),i.range.startOffset=e.start,i.range.endOffset=e.end),this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:t,newSelection:i}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var e=this.editor.getDomSelection(),t=this.previousField||"",i=(e.range&&(i=(0,E.textDiff)(this.field,t),e.range.startOffset=i.start,e.range.endOffset=i.end),this.editor.getDomSelection());i.range&&(t=(0,E.textDiff)(t,this.field),i.range.startOffset=t.start,i.range.endOffset=t.end),this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:i}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],i=this.value,n="auto"===this.type?(0,E.getType)(i):this.type,r="string"===n&&(0,E.isUrl)(i);if(t.push("jsoneditor-"+n),r&&t.push("jsoneditor-url"),""===String(this.value)&&"array"!==this.type&&"object"!==this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"===n||"object"===n?(t=this.childs?this.childs.length:0,e.title=this.type+" containing "+t+" items"):r&&this.editable.value?e.title=(0,a.Iu)("openUrl"):e.title="","boolean"===n&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id;t=document.createElement("option");t.value="",t.textContent="--",this.dom.select.appendChild(t);for(var o=0;o<this.enum.length;o++){var s=document.createElement("option");s.value=this.enum[o],s.textContent=this.enum[o],this.dom.select.appendChild(s)}this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}this.dom.select.value=-1!==this.enum.indexOf(this.value)?this.value:"",!this.schema||h(this.schema,"oneOf")||h(this.schema,"anyOf")||h(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);if(this.editor.options.colorPicker&&"string"==typeof i&&(0,E.isValidColor)(i)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),(0,E.addClassName)(this.dom.value,"jsoneditor-color-value"),(this.editable.value?(0,E.removeClassName):(0,E.addClassName))(this.dom.color,"jsoneditor-color-readonly"),this.dom.color.style.backgroundColor=i):this._deleteDomColor(),this._showTimestampTag()){this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date));r=null;if(r="function"==typeof this.editor.options.timestampFormat?this.editor.options.timestampFormat({field:this.field,value:this.value,path:this.getPath()}):r){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(r))}else this.dom.date.textContent=new Date(i).toISOString();this.dom.date.title=new Date(i).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);(0,E.stripFormatting)(e),this._updateDomDefault()}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,(0,E.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var e,t=this.dom.field;t&&((e=(0,E.makeFieldTooltip)(this.schema,this.editor.options.language))&&(t.title=e),(""===String(this.field)&&this.parent&&"array"!==this.parent.type?(0,E.addClassName):(0,E.removeClassName))(t,"jsoneditor-empty"),(this.searchFieldActive?(0,E.addClassName):(0,E.removeClassName))(t,"jsoneditor-highlight-active"),(this.searchField?(0,E.addClassName):(0,E.removeClassName))(t,"jsoneditor-highlight"),(0,E.stripFormatting)(t))}},{key:"_getDomField",value:function(e){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=(0,E.getInnerText)(this.dom.field),""===this.fieldInnerText&&""!==this.dom.field.innerHTML&&(this.dom.field.textContent="")),void 0!==this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText),i=this.parent.getFieldNames(this);-1!==i.indexOf(t)?e?(t=(0,E.findUniqueName)(t,i))!==this.field&&(this.field=t,this._debouncedOnChangeField()):this._setFieldError((0,a.Iu)("duplicateFieldError")):t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(e){this._setFieldError((0,a.Iu)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){var e;!this.schema||void 0===this.schema.default||this._hasChilds()||(e=this.dom.select||this.dom.value)&&(this.value===this.schema.default?(e.title=(0,a.Iu)("default"),(0,E.addClassName)(e,"jsoneditor-is-default"),(0,E.removeClassName)(e,"jsoneditor-is-not-default")):(e.removeAttribute("title"),(0,E.removeClassName)(e,"jsoneditor-is-default"),(0,E.addClassName)(e,"jsoneditor-is-not-default")))}},{key:"_showTimestampTag",value:function(){if("number"!=typeof this.value)return!1;var e,t=this.editor.options.timestampTag;return"function"==typeof t?"boolean"==typeof(e=t({field:this.field,value:this.value,path:this.getPath()}))?e:(0,E.isTimestamp)(this.field,this.value):!0===t&&(0,E.isTimestamp)(this.field,this.value)}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var e,t=this.dom;if(t.tr)return t.tr;this._updateEditability(),t.tr=document.createElement("tr"),"tree"===(t.tr.node=this).editor.options.mode&&(i=document.createElement("td"),this.editable.field&&this.parent&&((e=document.createElement("button")).type="button",(t.drag=e).className="jsoneditor-button jsoneditor-dragarea",e.title=(0,a.Iu)("drag"),i.appendChild(e)),t.tr.appendChild(i),e=document.createElement("td"),(i=document.createElement("button")).type="button",(t.menu=i).className="jsoneditor-button jsoneditor-contextmenu-button",i.title=(0,a.Iu)("actionsMenu"),e.appendChild(t.menu),t.tr.appendChild(e));var i=document.createElement("td");return t.tr.appendChild(i),t.tree=this._createDomTree(),i.appendChild(t.tree),this.updateDom({updateIndexes:!0}),t.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(e){for(var t=this.parent;t;){if(t===e)return!0;t=t.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(t){this.dom.tr&&((t?(0,E.addClassName):(0,E.removeClassName))(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(t),this.childs&&this.childs.forEach(function(e){e.setHighlight(t)}))}},{key:"setSelected",value:function(t,e){this.selected=t,this.dom.tr&&((t?(0,E.addClassName):(0,E.removeClassName))(this.dom.tr,"jsoneditor-selected"),(e?(0,E.addClassName):(0,E.removeClassName))(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(t),this.showMore&&this.showMore.setSelected(t),this.childs&&this.childs.forEach(function(e){e.setSelected(t)}))}},{key:"updateValue",value:function(e){this.value=e,this.previousValue=e,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(e){this.field=e,this.previousField=e,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(t){var e,i=this.dom.tree,i=(i&&(i.style.marginLeft=24*this.getLevel()+"px"),this.dom.field),i=(i&&(this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="jsoneditor-field"):(i.contentEditable=!1,i.className="jsoneditor-readonly"),e=void 0!==this.index?this.index:void 0!==this.field?this.field:(e=this.editor.options.schema?k._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0)&&e.title?e.title:this._hasChilds()?this.type:"",e=this._escapeHTML(e),document.activeElement!==i&&e!==this._unescapeHTML((0,E.getInnerText)(i))&&(i.innerHTML=e),this._updateSchema()),this.dom.value),i=(i&&("array"===this.type||"object"===this.type?this.updateNodeName():(e=this._escapeHTML(this.value),document.activeElement!==i&&e!==this._unescapeHTML((0,E.getInnerText)(i))&&(i.innerHTML=e))),this.dom.tr);i&&("array"===this.type||"object"===this.type?((0,E.addClassName)(i,"jsoneditor-expandable"),this.expanded?((0,E.addClassName)(i,"jsoneditor-expanded"),(0,E.removeClassName)(i,"jsoneditor-collapsed")):((0,E.addClassName)(i,"jsoneditor-collapsed"),(0,E.removeClassName)(i,"jsoneditor-expanded"))):((0,E.removeClassName)(i,"jsoneditor-expandable"),(0,E.removeClassName)(i,"jsoneditor-expanded"),(0,E.removeClassName)(i,"jsoneditor-collapsed"))),this._updateDomField(),this._updateDomValue(),t&&!0===t.updateIndexes&&this._updateDomIndexes(),t&&!0===t.recurse&&this.childs&&this.childs.forEach(function(e){e.updateDom(t)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom(),this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?k._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=k._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var e=this.dom.value,t=this.childs;e&&t&&("array"===this.type?t.forEach(function(e,t){e.index=t;e=e.dom.field;e&&(e.textContent=t)}):"object"===this.type&&t.forEach(function(e){void 0!==e.index&&(delete e.index,void 0===e.field&&(e.field=""))}))}},{key:"_createDomValue",value:function(){var e;return"array"===this.type?(e=document.createElement("div")).textContent="[...]":"object"===this.type?(e=document.createElement("div")).textContent="{...}":(!this.editable.value&&(0,E.isUrl)(this.value)?(e=document.createElement("a")).href=this.value:((e=document.createElement("div")).contentEditable=this.editable.value,e.spellcheck=!1),e.innerHTML=this._escapeHTML(this.value)),e}},{key:"_createDomExpandButton",value:function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=(0,a.Iu)("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e}},{key:"_createDomTree",value:function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody"),n=(t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i),document.createElement("tr")),i=(i.appendChild(n),document.createElement("td")),i=(i.className="jsoneditor-tree",n.appendChild(i),e.expand=this._createDomExpandButton(),i.appendChild(e.expand),e.tdExpand=i,document.createElement("td")),i=(i.className="jsoneditor-tree",n.appendChild(i),e.field=this._createDomField(),i.appendChild(e.field),e.tdField=i,document.createElement("td")),i=(i.className="jsoneditor-tree",n.appendChild(i),"object"!==this.type&&"array"!==this.type&&(i.appendChild(document.createTextNode(":")),i.className="jsoneditor-separator"),e.tdSeparator=i,document.createElement("td"));return i.className="jsoneditor-tree",n.appendChild(i),e.value=this._createDomValue(),i.appendChild(e.value),e.tdValue=i,t}},{key:"onEvent",value:function(e){var t,i=e.type,n=e.target||e.srcElement,r=this.dom,o=this,s=this._hasChilds(),a=(n!==r.drag&&n!==r.menu||("mouseover"===i?this.editor.highlighter.highlight(this):"mouseout"===i&&this.editor.highlighter.unhighlight()),"click"===i&&n===r.menu&&((t=o.editor.highlighter).highlight(o),t.lock(),(0,E.addClassName)(r.menu,"jsoneditor-selected"),this.showContextMenu(r.menu,function(){(0,E.removeClassName)(r.menu,"jsoneditor-selected"),t.unlock(),t.unhighlight()})),"click"===i&&n===r.expand&&s&&(c=e.ctrlKey,this._onExpand(c)),"click"!==i||e.target!==o.dom.tdColor&&e.target!==o.dom.color||!this.editable.value||this._showColorPicker(),"change"===i&&n===r.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault()),"change"===i&&n===r.select&&(this.dom.value.innerHTML=this._escapeHTML(r.select.value),this._getDomValue(),this._updateDomValue()),r.value);if(n===a)switch(i){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var h=this._escapeHTML(this.value);h!==this._unescapeHTML((0,E.getInnerText)(a))&&(a.innerHTML=h);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&(0,E.isUrl)(this.value)&&(e.preventDefault(),window.open(this.value,"_blank","noreferrer"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){o._getDomValue(),o._updateDomValue()},1)}var l=r.field;if(n===l)switch(i){case"blur":this._getDomField(!0),this._updateDomField();var d=this._escapeHTML(this.field);d!==this._unescapeHTML((0,E.getInnerText)(l))&&(l.innerHTML=d);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){o._getDomField(),o._updateDomField()},1)}var c=r.tree;c&&n===c.parentNode&&"click"===i&&!e.hasMoved&&((void 0!==e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<(0,E.getAbsoluteLeft)(r.tdSeparator))||s?l&&((0,E.setEndOfContentEditable)(l),l.focus()):a&&!this.enum&&((0,E.setEndOfContentEditable)(a),a.focus())),(n!==r.tdExpand||s)&&n!==r.tdField&&n!==r.tdSeparator||"click"!==i||e.hasMoved||l&&((0,E.setEndOfContentEditable)(l),l.focus()),"keydown"===i&&this.onKeyDown(e),"function"==typeof this.editor.options.onEvent&&this._onEvent(e)}},{key:"_onEvent",value:function(e){var t=e.target,i=t===this.dom.field,t=t===this.dom.value||t===this.dom.checkbox||t===this.dom.select;(i||t)&&(i={field:this.getField(),path:this.getPath()},t&&!this._hasChilds()&&(i.value=this.getValue()),this.editor.options.onEvent(i,e))}},{key:"onKeyDown",value:function(h){var t,d,u,e,g,p,m,f,C,I,i,v,A,n,b,y=h.which||h.keyCode,r=h.target||h.srcElement,w=h.ctrlKey,o=h.shiftKey,S=h.altKey,s=!1,x="tree"===this.editor.options.mode,a=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],l=a[0],c=a[a.length-1];13===y?r===this.dom.value?this.editable.value&&!h.ctrlKey||(0,E.isUrl)(this.value)&&(window.open(this.value,"_blank","noreferrer"),s=!0):r===this.dom.expand&&this._hasChilds()&&(n=h.ctrlKey,this._onExpand(n),r.focus(),s=!0):68===y?w&&x&&(k.onDuplicate(a),s=!0):69===y?w&&(this._onExpand(o),r.focus(),s=!0):77===y&&x?w&&(this.showContextMenu(r),s=!0):46===y&&x?w&&(k.onRemove(a),s=!0):45===y&&x?w&&!o?(this._onInsertBefore(),s=!0):w&&o&&(this._onInsertAfter(),s=!0):35===y?S&&((n=this._lastNode())&&n.focus(k.focusElement||this._getElementName(r)),s=!0):36===y?S&&((n=this._firstNode())&&n.focus(k.focusElement||this._getElementName(r)),s=!0):37===y?S&&!o?((n=this._previousElement(r))&&this.focus(this._getElementName(n)),s=!0):S&&o&&x&&(A=c.expanded?(n=c.getAppendDom())?n.nextSibling:void 0:c.getDom().nextSibling)&&(i=k.getNodeFromTarget(A),n=A.nextSibling,v=k.getNodeFromTarget(n),i&&i instanceof T&&1!==c.parent.childs.length&&v&&v.parent&&(d=this.editor.getDomSelection(),u=(e=l.parent).childs[c.getIndex()+1]||e.append,g=l.getIndex(),p=v.getIndex(),m=e.getInternalPath(),f=v.parent.getInternalPath(),a.forEach(function(e){v.parent.moveBefore(e,v)}),this.focus(k.focusElement||this._getElementName(r)),this.editor._onAction("moveNodes",{count:a.length,fieldNames:a.map(R),oldParentPath:e.getInternalPath(),newParentPath:l.parent.getInternalPath(),oldIndex:u.getIndex(),newIndex:l.getIndex(),oldIndexRedo:g,newIndexRedo:p,oldParentPathRedo:m,newParentPathRedo:f,oldSelection:d,newSelection:this.editor.getDomSelection()}))):38===y?S&&!o?((t=this._previousNode())&&(this.editor.deselect(!0),t.focus(k.focusElement||this._getElementName(r))),s=!0):!S&&w&&o&&x?((t=this._previousNode())&&((I=this.editor.multiselection).start=I.start||this,I.end=t,C=this.editor._findTopLevelNodes(I.start,I.end),this.editor.select(C),t.focus("field")),s=!0):S&&o&&x&&((t=l._previousNode())&&t.parent&&(d=this.editor.getDomSelection(),u=(e=l.parent).childs[c.getIndex()+1]||e.append,g=l.getIndex(),p=t.getIndex(),m=e.getInternalPath(),f=t.parent.getInternalPath(),a.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(k.focusElement||this._getElementName(r)),this.editor._onAction("moveNodes",{count:a.length,fieldNames:a.map(R),oldParentPath:e.getInternalPath(),newParentPath:l.parent.getInternalPath(),oldIndex:u.getIndex(),newIndex:l.getIndex(),oldIndexRedo:g,newIndexRedo:p,oldParentPathRedo:m,newParentPathRedo:f,oldSelection:d,newSelection:this.editor.getDomSelection()})),s=!0):39===y?S&&!o?((A=this._nextElement(r))&&this.focus(this._getElementName(A)),s=!0):S&&o&&x&&((n=l.getDom().previousSibling)&&(t=k.getNodeFromTarget(n))&&t.parent&&!t.isVisible()&&(d=this.editor.getDomSelection(),u=(e=l.parent).childs[c.getIndex()+1]||e.append,g=l.getIndex(),p=t.getIndex(),m=e.getInternalPath(),f=t.parent.getInternalPath(),a.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(k.focusElement||this._getElementName(r)),this.editor._onAction("moveNodes",{count:a.length,fieldNames:a.map(R),oldParentPath:e.getInternalPath(),newParentPath:l.parent.getInternalPath(),oldIndex:u.getIndex(),newIndex:l.getIndex(),oldIndexRedo:g,newIndexRedo:p,oldParentPathRedo:m,newParentPathRedo:f,oldSelection:d,newSelection:this.editor.getDomSelection()}))):40===y&&(S&&!o?((i=this._nextNode())&&(this.editor.deselect(!0),i.focus(k.focusElement||this._getElementName(r))),s=!0):!S&&w&&o&&x?((i=this._nextNode())&&((I=this.editor.multiselection).start=I.start||this,I.end=i,C=this.editor._findTopLevelNodes(I.start,I.end),this.editor.select(C),i.focus("field")),s=!0):S&&o&&x&&((b=(i=(i=(i=c.expanded?c.append?c.append._nextNode():void 0:c._nextNode())&&!i.isVisible()?i.parent.showMore:i)&&i instanceof T?c:i)&&(i._nextNode()||i.parent.append))&&b.parent&&(d=this.editor.getDomSelection(),u=(e=l.parent).childs[c.getIndex()+1]||e.append,g=l.getIndex(),p=b.getIndex(),m=e.getInternalPath(),f=b.parent.getInternalPath(),a.forEach(function(e){b.parent.moveBefore(e,b)}),this.focus(k.focusElement||this._getElementName(r)),this.editor._onAction("moveNodes",{count:a.length,fieldNames:a.map(R),oldParentPath:e.getInternalPath(),newParentPath:l.parent.getInternalPath(),oldParentPathRedo:m,newParentPathRedo:f,oldIndexRedo:g,newIndexRedo:p,oldIndex:u.getIndex(),newIndex:l.getIndex(),oldSelection:d,newSelection:this.editor.getDomSelection()})),s=!0)),s&&(h.preventDefault(),h.stopPropagation())}},{key:"_onExpand",value:function(e){var t,i,n;e&&(n=(i=(t=this.dom.tr.parentNode).parentNode).scrollTop,i.removeChild(t)),this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)}},{key:"_showColorPicker",value:function(){var t,e;"function"==typeof this.editor.options.onColorPicker&&this.dom.color&&((t=this)._deleteDomColor(),t.updateDom(),e=(0,g.w)(this.dom.color,this.editor.getPopupAnchor()),this.editor.options.onColorPicker(e,this.value,function(e){"string"==typeof e&&e!==t.value&&(t._deleteDomColor(),t.value=e,t.updateDom(),t._debouncedOnChangeValue())}))}},{key:"getFieldNames",value:function(t){return"object"===this.type?this.childs.filter(function(e){return e!==t}).map(function(e){return e.field}):[]}},{key:"_onInsertBefore",value:function(e,t,i){var n=this.editor.getDomSelection(),e=new k(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i}),t=(e.expand(!0),this.getInternalPath()),i=(this.parent.insertBefore(e,this),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertBeforeNodes",{nodes:[e],paths:[e.getInternalPath()],beforePath:t,parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:i})}},{key:"_onInsertAfter",value:function(e,t,i){var n=this.editor.getDomSelection(),e=new k(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i}),t=(e.expand(!0),this.parent.insertAfter(e,this),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertAfterNodes",{nodes:[e],paths:[e.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:t})}},{key:"_onAppend",value:function(e,t,i){var n=this.editor.getDomSelection(),e=new k(this.editor,{field:void 0!==e?e:"",value:void 0!==t?t:"",type:i}),t=(e.expand(!0),this.parent.appendChild(e),this.editor.highlighter.unhighlight(),e.focus("field"),this.editor.getDomSelection());this.editor._onAction("appendNodes",{nodes:[e],paths:[e.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:t})}},{key:"_onChangeType",value:function(e){var t,i,n=this.type;e!==n&&(t=this.editor.getDomSelection(),this.changeType(e),i=this.editor.getDomSelection(),this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:n,newType:e,oldSelection:t,newSelection:i}))}},{key:"sort",value:function(i,e){var t,n,r=!(2<arguments.length&&void 0!==arguments[2])||arguments[2];"string"==typeof i&&(i=(0,E.parsePath)(i)),this._hasChilds()&&(this.hideChilds(),t=this.childs,this.childs=this.childs.concat(),n="desc"===e?-1:1,"object"===this.type?this.childs.sort(function(e,t){return n*u()(e.field,t.field)}):this.childs.sort(function(e,t){e=e.getNestedChild(i),t=t.getNestedChild(i);if(!e)return n;if(!t)return-n;e=e.value,t=t.value;return"string"!=typeof e&&"string"!=typeof t?t<e?n:e<t?-n:0:n*u()(e,t)}),this._updateDomIndexes(),this.showChilds(),!0===r&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:t,newChilds:this.childs}))}},{key:"update",value:function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var e=this.dom.tr?this.dom.tr.parentNode:void 0,t=this.expanded?this.getAppendDom():this.getDom(),t=t&&t.parentNode?t.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:e,nextTr:t}}},{key:"_attachToDom",value:function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),i=this.getValue(),n=this.editor.options.executeQuery(i,e),r=(this.setValue(n),this.getInternalValue());this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:r}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var e=this.editor.node.getInternalValue(),t=(this.editor._setRoot(this),this.editor.node.getInternalValue());this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:e,newValue:t})}catch(e){this.editor._onError(e)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(e){for(var t=0,i=this;i&&t<e.length;)i=i.findChildByProperty(e[t]),t++;return i}},{key:"findChildByProperty",value:function(t){if("object"===this.type)return this.childs.find(function(e){return e.field===t})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new T(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new y(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append}},{key:"_previousNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.previousSibling,e=k.getNodeFromTarget(i),i&&e&&e instanceof T&&!e.isVisible(););return e}},{key:"_nextNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.nextSibling,e=k.getNodeFromTarget(i),i&&e&&e instanceof T&&!e.isVisible(););return e}},{key:"_firstNode",value:function(){var e=null,t=this.getDom();return t&&t.parentNode&&(t=t.parentNode.firstChild,e=k.getNodeFromTarget(t)),e}},{key:"_lastNode",value:function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t.parentNode.lastChild,e=k.getNodeFromTarget(i);i&&e&&!e.isVisible();)i=i.previousSibling,e=k.getNodeFromTarget(i);return e}},{key:"_previousElement",value:function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}}},{key:"_nextElement",value:function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}}},{key:"_getElementName",value:function(t){var i=this;return Object.keys(this.dom).find(function(e){return i.dom[e]===t})}},{key:"_hasChilds",value:function(){return"array"===this.type||"object"===this.type}},{key:"addTemplates",value:function(t,i){var n=this,e=n.editor.options.templates;null!=e&&(e.length&&t.push({type:"separator"}),e.forEach(function(e){t.push({text:e.text,className:e.className||"jsoneditor-type-object",title:e.title,click:(i?function(e,t){n._onAppend(e,t)}:function(e,t){n._onInsertBefore(e,t)}).bind(this,e.field,e.value)})}))}},{key:"showContextMenu",value:function(e,t){var i,n=this,r=[];r.push({text:"Copy path",title:"Copy path to clipboard",className:"jsoneditor-duplicate",click:function(){var e=n.getPath().map(function(e){return"string"==typeof e?'["'.concat(e,'"]'):"[".concat(e,"]")}).join("");navigator.clipboard.writeText(e).then(function(){alert("Copied path.")})}}),r.push({text:"Copy value",title:"Copy value to clipboard",className:"jsoneditor-duplicate",click:function(){navigator.clipboard.writeText(JSON.stringify(n.getValue())).then(function(){alert("Copied value.")})}}),this.editable.value&&r.push({text:(0,a.Iu)("type"),title:(0,a.Iu)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:(0,a.Iu)("auto"),className:"jsoneditor-type-auto"+("auto"===this.type?" jsoneditor-selected":""),title:(0,a.Iu)("autoType"),click:function(){n._onChangeType("auto")}},{text:(0,a.Iu)("array"),className:"jsoneditor-type-array"+("array"===this.type?" jsoneditor-selected":""),title:(0,a.Iu)("arrayType"),click:function(){n._onChangeType("array")}},{text:(0,a.Iu)("object"),className:"jsoneditor-type-object"+("object"===this.type?" jsoneditor-selected":""),title:(0,a.Iu)("objectType"),click:function(){n._onChangeType("object")}},{text:(0,a.Iu)("string"),className:"jsoneditor-type-string"+("string"===this.type?" jsoneditor-selected":""),title:(0,a.Iu)("stringType"),click:function(){n._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&r.push({text:(0,a.Iu)("sort"),title:(0,a.Iu)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){n.showSortModal()}}),this.editor.options.enableTransform&&r.push({text:(0,a.Iu)("transform"),title:(0,a.Iu)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){n.showTransformModal()}}),this.parent&&r.push({text:(0,a.Iu)("extract"),title:(0,a.Iu)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){n.extract()}})),this.parent&&this.parent._hasChilds()&&(r.length&&r.push({type:"separator"}),i=n.parent.childs,n===i[i.length-1]&&(i=[{text:(0,a.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,a.Iu)("autoType"),click:function(){n._onAppend("","","auto")}},{text:(0,a.Iu)("array"),className:"jsoneditor-type-array",title:(0,a.Iu)("arrayType"),click:function(){n._onAppend("",[])}},{text:(0,a.Iu)("object"),className:"jsoneditor-type-object",title:(0,a.Iu)("objectType"),click:function(){n._onAppend("",{})}},{text:(0,a.Iu)("string"),className:"jsoneditor-type-string",title:(0,a.Iu)("stringType"),click:function(){n._onAppend("","","string")}}],n.addTemplates(i,!0),r.push({text:(0,a.Iu)("appendText"),title:(0,a.Iu)("appendTitle"),submenuTitle:(0,a.Iu)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){n._onAppend("","","auto")},submenu:i})),i=[{text:(0,a.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,a.Iu)("autoType"),click:function(){n._onInsertBefore("","","auto")}},{text:(0,a.Iu)("array"),className:"jsoneditor-type-array",title:(0,a.Iu)("arrayType"),click:function(){n._onInsertBefore("",[])}},{text:(0,a.Iu)("object"),className:"jsoneditor-type-object",title:(0,a.Iu)("objectType"),click:function(){n._onInsertBefore("",{})}},{text:(0,a.Iu)("string"),className:"jsoneditor-type-string",title:(0,a.Iu)("stringType"),click:function(){n._onInsertBefore("","","string")}}],n.addTemplates(i,!1),r.push({text:(0,a.Iu)("insert"),title:(0,a.Iu)("insertTitle"),submenuTitle:(0,a.Iu)("insertSub"),className:"jsoneditor-insert",click:function(){n._onInsertBefore("","","auto")},submenu:i}),this.editable.field&&(r.push({text:(0,a.Iu)("duplicateText"),title:(0,a.Iu)("duplicateField"),className:"jsoneditor-duplicate",click:function(){k.onDuplicate(n)}}),r.push({text:(0,a.Iu)("removeText"),title:(0,a.Iu)("removeField"),className:"jsoneditor-remove",click:function(){k.onRemove(n)}}))),this.editor.options.onCreateMenu&&(i=n.getPath(),r=this.editor.options.onCreateMenu(r,{type:"single",path:i,paths:[i]})),new s.x(r,{close:t}).show(e,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var i=this,e=this.editor.options.modalAnchor||f.qD,t=this.getValue();(0,p.showSortModal)(e,t,function(e){var t=e.path,t=(0,E.parsePath)(t);i.sortedBy=e,i.sort(t,e.direction)},i.sortedBy)}},{key:"showTransformModal",value:function(){var t=this,e=this.editor.options,i=e.modalAnchor,n=e.createQuery,r=e.executeQuery,e=e.queryDescription,o=this.getValue();(0,m.showTransformModal)({container:i||f.qD,json:o,queryDescription:e,createQuery:n,executeQuery:r,onTransform:function(e){t.transform(e)}})}},{key:"_getType",value:function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof(0,E.parseString)(e)?"string":"auto"}},{key:"_escapeHTML",value:function(e){return"string"!=typeof e?String(e):(e=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),e=(e=JSON.stringify(e)).substring(1,e.length-1),
!0===this.editor.options.escapeUnicode?(0,E.escapeUnicodeChars)(e):e)}},{key:"_unescapeHTML",value:function(e){e='"'+this._escapeJSON(e)+'"';return(0,E.parse)(e).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"===n?t+="\\n":"\\"===n?(t+=n,i++,""!==(n=e.charAt(i))&&-1!=='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'===n?'\\"':n,i++}return t}},{key:"updateNodeName",value:function(){var e=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{var t=this.getValue.bind(this),i=this.editor.options.onNodeName({path:this.getPath(),size:e,type:this.type,get value(){return t()}})}catch(e){console.error("Error in onNodeName callback: ",e)}this.dom.value.textContent="object"===this.type?"{"+(i||e)+"}":"["+(i||e)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(var e in this.childs)this.childs[e].recursivelyUpdateNodeName()}}])&&v(e.prototype,t),i&&v(e,i),Object.defineProperty(e,"prototype",{writable:!1}),k}(),A=(k.prototype.DEBOUNCE_INTERVAL=150,k.prototype.MAX_SEARCH_RESULTS=999,100);function b(e){return e.getInternalPath()}function R(e){return e.getField()}function h(e,t){return Object.prototype.hasOwnProperty.call(e,t)}k.focusElement=void 0,k.select=function(e){setTimeout(function(){(0,E.selectContentEditable)(e)},0)},k.onDragStart=function(t,e){if(!Array.isArray(t))return k.onDragStart([t],e);var i,n,r,o,s;0!==t.length&&(i=t[0],n=t[t.length-1],r=i.parent,s=k.getNodeFromTarget(e.target),o=i.editor,s=(0,E.getAbsoluteTop)(s.dom.tr)-(0,E.getAbsoluteTop)(i.dom.tr),o.mousemove||(o.mousemove=(0,E.addEventListener)(e.view,"mousemove",function(e){k.onDrag(t,e)})),o.mouseup||(o.mouseup=(0,E.addEventListener)(e.view,"mouseup",function(e){k.onDragEnd(t,e)})),o.highlighter.lock(),o.drag={oldCursor:document.body.style.cursor,oldSelection:o.getDomSelection(),oldPaths:t.map(b),oldParent:r,oldNextNode:r.childs[n.getIndex()+1]||r.append,oldParentPathRedo:r.getInternalPath(),oldIndexRedo:i.getIndex(),mouseX:e.pageX,offsetY:s,level:i.getLevel()},document.body.style.cursor="move",e.preventDefault())},k.onDrag=function(e,h){if(!Array.isArray(e))return k.onDrag([e],h);if(0!==e.length){var t,i,d,u,g,n=e[0].editor,r=h.pageY-n.drag.offsetY,p=h.pageX,m=!1,f=e[0],o=f.dom.tr,C=(0,E.getAbsoluteTop)(o),s=o.offsetHeight;if(r<C){for(l=o;l=l.previousSibling,c=k.getNodeFromTarget(l),d=l?(0,E.getAbsoluteTop)(l):0,l&&r<d;);(c=c&&!c.parent?void 0:c)||(l=(o=o.parentNode.firstChild)?o.nextSibling:void 0,(c=k.getNodeFromTarget(l))===f&&(c=void 0)),!(c=c&&c.isVisible()&&(d=(l=c.dom.tr)?(0,E.getAbsoluteTop)(l):0)+s<r?void 0:c)||!1!==n.options.limitDragging&&c.parent!==e[0].parent||(e.forEach(function(e){c.parent.moveBefore(e,c)}),m=!0)}else{var a=e[e.length-1];if(s=(o=a.expanded&&a.append?a.append.getDom():a.dom.tr)?o.nextSibling:void 0){for(u=(0,E.getAbsoluteTop)(s),t=s;i=k.getNodeFromTarget(t),t&&(g=t.nextSibling?(0,E.getAbsoluteTop)(t.nextSibling):0,g=t?g-u:0,i&&i.parent.childs.length===e.length&&i.parent.childs[e.length-1]===a&&(C+=27),t=t.nextSibling),t&&C+g<r;);if(i&&i.parent){for(var s=p-n.drag.mouseX,s=Math.round(s/24/2),I=n.drag.level+s,v=i.getLevel(),l=i.dom.tr&&i.dom.tr.previousSibling;v<I&&l;){var c=k.getNodeFromTarget(l),A=e.some(function(e){return e===c||c.isDescendantOf(e)});if(!A){if(!(c instanceof T))break;A=c.parent.childs;if(A.length===e.length&&A[e.length-1]===a)break;v=(i=k.getNodeFromTarget(l)).getLevel()}l=l.previousSibling}(i=i instanceof T&&!i.isVisible()&&i.parent.showMore.isVisible()?i._nextNode():i)&&(!1===n.options.limitDragging||i.parent===e[0].parent)&&i.dom.tr&&i.dom.tr!==o.nextSibling&&(e.forEach(function(e){i.parent.moveBefore(e,i)}),m=!0)}}}m&&(n.drag.mouseX=p,n.drag.level=f.getLevel()),n.startAutoScroll(r),h.preventDefault()}},k.onDragEnd=function(e,t){if(!Array.isArray(e))return k.onDrag([e],t);var i,n,r,o,s,a,l,c,h;0!==e.length&&(a=e[0],i=a.editor,a&&a.dom.menu&&a.dom.menu.focus(),n=i.drag.oldParent.getInternalPath(),r=a.parent.getInternalPath(),o=i.drag.oldParent===a.parent,s=i.drag.oldNextNode.getIndex(),a=a.getIndex(),l=i.drag.oldParentPathRedo,c=i.drag.oldIndexRedo,h=o&&c<a?a+e.length:a,o&&c===a||i._onAction("moveNodes",{count:e.length,fieldNames:e.map(R),oldParentPath:n,newParentPath:r,oldIndex:s,newIndex:a,oldIndexRedo:c,newIndexRedo:h,oldParentPathRedo:l,newParentPathRedo:null,oldSelection:i.drag.oldSelection,newSelection:i.getDomSelection()}),document.body.style.cursor=i.drag.oldCursor,i.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&i.highlighter.unhighlight()}),delete i.drag,i.mousemove&&((0,E.removeEventListener)(t.view,"mousemove",i.mousemove),delete i.mousemove),i.mouseup&&((0,E.removeEventListener)(t.view,"mouseup",i.mouseup),delete i.mouseup),i.stopAutoScroll(),t.preventDefault())},k._findEnum=function(e){if(e.enum)return e.enum;e=e.oneOf||e.anyOf||e.allOf;if(e){e=e.filter(function(e){return e.enum});if(0<e.length)return e[0].enum}return null},k._findSchema=function(e,t,c){for(var i=3<arguments.length&&void 0!==arguments[3]?arguments[3]:e,n=c.slice(1,c.length),r=c[0],h=[i],d=0,u=[i.oneOf,i.anyOf,i.allOf];d<u.length;d++){var g=u[d];Array.isArray(g)&&(h=h.concat(g))}var p,o=L(h);try{for(o.s();!(p=o.n()).done;){if("$ref"in(i=p.value)&&"string"==typeof i.$ref){var m,s=i.$ref;if(s in t)i=t[s];else{if(!s.startsWith("#/")){if(1!==(null===(m=s.match(/#\//g))||void 0===m?void 0:m.length))throw Error("Unable to resolve reference ".concat(s));var f,C,a,I=$(s.split("#/"),2),v=I[0],A=I[1];if(v in t)return f=t[v],C={$ref:"#/".concat(A)},(a=[]).push(r),0<n.length&&a.push.apply(a,_(n)),k._findSchema(f,t,a,C);throw Error("Unable to resolve reference ".concat(s))}var b,y=s.substring(2).split("/"),i=e,l=L(y);try{for(l.s();!(b=l.n()).done;){var w=b.value;if(!(w in i))throw Error("Unable to resovle reference ".concat(s));i=i[w]}}catch(e){l.e(e)}finally{l.f()}}}if(void 0===r)return i;if("string"!=typeof r){if("number"==typeof r&&"object"===x(i.items)&&null!==i.items)return i=i.items,k._findSchema(e,t,n,i)}else{if("object"===x(i.properties)&&null!==i.properties&&r in i.properties)return i=i.properties[r],k._findSchema(e,t,n,i);if("object"===x(i.patternProperties)&&null!==i.patternProperties)for(var S in i.patternProperties)if(r.match(S))return i=i.patternProperties[S],k._findSchema(e,t,n,i);if("object"===x(i.additionalProperties))return i=i.additionalProperties,k._findSchema(e,t,n,i)}}}catch(e){o.e(e)}finally{o.f()}return null},k.onRemove=function(e){if(!Array.isArray(e))return k.onRemove([e]);var t,i,n,r,o,s;e&&0<e.length&&(t=(n=e[0]).parent,i=n.editor,n=n.getIndex(),i.highlighter.unhighlight(),r=i.getDomSelection(),k.blurNodes(e),o=i.getDomSelection(),s=e.map(b),e.forEach(function(e){e.parent._remove(e)}),i._onAction("removeNodes",{nodes:e,paths:s,parentPath:t.getInternalPath(),index:n,oldSelection:r,newSelection:o}))},k.onDuplicate=function(e){if(!Array.isArray(e))return k.onDuplicate([e]);var t,n,i,r,o,s,a;e&&0<e.length&&(t=e[e.length-1],n=t.parent,(i=t.editor).deselect(i.multiselection.nodes),r=i.getDomSelection(),o=t,s=e.map(function(e){var t,i=e.clone();return"object"===e.parent.type&&(t=e.parent.getFieldNames(),i.field=(0,E.findUniqueName)(e.field,t)),n.insertAfter(i,o),o=i}),1===e.length?"object"===s[0].parent.type?(s[0].dom.field.innerHTML=e[0]._escapeHTML(e[0].field),s[0].focus("field")):s[0].focus():i.select(s),a=i.getDomSelection(),i._onAction("duplicateNodes",{paths:e.map(b),clonePaths:s.map(b),afterPath:t.getInternalPath(),parentPath:n.getInternalPath(),oldSelection:r,newSelection:a}))},k.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},k.targetIsColorPicker=function(e){var t=k.getNodeFromTarget(e);if(t)for(var i=e&&e.parentNode;i;){if(i===t.dom.color)return!0;i=i.parentNode}return!1},k.blurNodes=function(e){var t,i;Array.isArray(e)?(t=(i=e[0]).parent,i=i.getIndex(),(t.childs[i+e.length]?t.childs[i+e.length]:t.childs[i-1]||t).focus()):k.blurNodes([e])};(t.prototype=new k).getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr"),i=(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode&&(e.tdDrag=document.createElement("td"),n=document.createElement("td"),e.tdMenu=n,(i=document.createElement("button")).type="button",i.className="jsoneditor-button jsoneditor-contextmenu-button",i.title="Click to open the actions menu (Ctrl+M)",e.menu=i,n.appendChild(e.menu)),document.createElement("td")),n=document.createElement("div");return n.appendChild(document.createTextNode("("+(0,a.Iu)("empty")+")")),n.className="jsoneditor-readonly",i.appendChild(n),e.td=i,e.text=n,this.updateDom(),t},t.prototype.getPath=function(){return null},t.prototype.getIndex=function(){return null},t.prototype.updateDom=function(e){var t=this.dom,i=t.td,n=(i&&(i.style.paddingLeft=24*this.getLevel()+26+"px"),t.text),n=(n&&(n.firstChild.nodeValue="("+(0,a.Iu)("empty")+" "+this.parent.type+")"),t.tr);this.isVisible()?t.tr.firstChild||(t.tdDrag&&n.appendChild(t.tdDrag),t.tdMenu&&n.appendChild(t.tdMenu),n.appendChild(i)):t.tr.firstChild&&(t.tdDrag&&n.removeChild(t.tdDrag),t.tdMenu&&n.removeChild(t.tdMenu),n.removeChild(i))},t.prototype.isVisible=function(){return 0===this.parent.childs.length},t.prototype.showContextMenu=function(e,t){var i,n=this,r=[{text:(0,a.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,a.Iu)("autoType"),click:function(){n._onAppend("","","auto")}},{text:(0,a.Iu)("array"),className:"jsoneditor-type-array",title:(0,a.Iu)("arrayType"),click:function(){n._onAppend("",[])}},{text:(0,a.Iu)("object"),className:"jsoneditor-type-object",title:(0,a.Iu)("objectType"),click:function(){n._onAppend("",{})}},{text:(0,a.Iu)("string"),className:"jsoneditor-type-string",title:(0,a.Iu)("stringType"),click:function(){n._onAppend("","","string")}}],r=(n.addTemplates(r,!0),[{text:(0,a.Iu)("appendText"),title:(0,a.Iu)("appendTitleAuto"),submenuTitle:(0,a.Iu)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){n._onAppend("","","auto")},submenu:r}]);this.editor.options.onCreateMenu&&(i=n.parent.getPath(),r=this.editor.options.onCreateMenu(r,{type:"append",path:i,paths:[i]})),new s.x(r,{close:t}).show(e,this.editor.getPopupAnchor())},t.prototype.onEvent=function(e){var t,i=e.type,n=e.target||e.srcElement,r=this.dom;n===r.menu&&("mouseover"===i?this.editor.highlighter.highlight(this.parent):"mouseout"===i&&this.editor.highlighter.unhighlight()),"click"===i&&n===r.menu&&((t=this.editor.highlighter).highlight(this.parent),t.lock(),(0,E.addClassName)(r.menu,"jsoneditor-selected"),this.showContextMenu(r.menu,function(){(0,E.removeClassName)(r.menu,"jsoneditor-selected"),t.unlock(),t.unhighlight()})),"keydown"===i&&this.onKeyDown(e)};var T=t;function t(e){this.editor=e,this.dom={}}(i.prototype=new k).getDom=function(){return this.dom.tr||(this._updateEditability(),this.dom.tr||(i=(t=this).parent,(r=document.createElement("a")).appendChild(document.createTextNode((0,a.Iu)("showMore"))),r.href="#",r.onclick=function(e){return i.visibleChilds=Math.floor(i.visibleChilds/i.getMaxVisibleChilds()+1)*i.getMaxVisibleChilds(),t.updateDom(),i.showChilds(),e.preventDefault(),!1},(o=document.createElement("a")).appendChild(document.createTextNode((0,a.Iu)("showAll"))),o.href="#",o.onclick=function(e){return i.visibleChilds=1/0,t.updateDom(),i.showChilds(),e.preventDefault(),!1},e=document.createElement("div"),n=document.createTextNode(this._getShowMoreText()),e.className="jsoneditor-show-more",e.appendChild(n),e.appendChild(r),e.appendChild(document.createTextNode(". ")),e.appendChild(o),e.appendChild(document.createTextNode(". ")),(r=document.createElement("td")).appendChild(e),o=document.createElement("tr"),"tree"===this.editor.options.mode&&(o.appendChild(document.createElement("td")),o.appendChild(document.createElement("td"))),o.appendChild(r),o.className="jsoneditor-show-more",this.dom.tr=o,this.dom.moreContents=e,this.dom.moreText=n),this.updateDom(),this.dom.tr);var t,i,e,n,r,o},i.prototype.updateDom=function(e){var t;this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(t=this.parent._getNextTr())&&t.parentNode.insertBefore(this.dom.tr,t),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},i.prototype._getShowMoreText=function(){return(0,a.Iu)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},i.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},i.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)};var y=i;function i(e,t){this.editor=e,this.parent=t,this.dom={}}function B(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var W=function(){function e(t){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");function o(e){return t.node.findNodeByInternalPath(e)}this.editor=t,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){o(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){o(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){o(e.path).updateValue(e.oldValue)},redo:function(e){o(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){o(e.path).changeType(e.oldType)},redo:function(e){o(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath);e.nodes.forEach(function(e){t.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath),i=o(e.beforePath);e.nodes.forEach(function(e){t.insertBefore(e,i)})}},insertAfterNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath),i=o(e.afterPath);e.nodes.forEach(function(e){t.insertAfter(e,i),i=e})}},removeNodes:{undo:function(e){var t=o(e.parentPath),i=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,i)})},redo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})}},duplicateNodes:{undo:function(e){var t=o(e.parentPath);e.clonePaths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var n=o(e.parentPath),r=o(e.afterPath);e.paths.map(o).forEach(function(e){var t,i=e.clone();"object"===n.type&&(t=n.getFieldNames(),i.field=(0,E.findUniqueName)(e.field,t)),n.insertAfter(i,r),r=i})}},moveNodes:{undo:function(i){var n=o(i.oldParentPath),e=o(i.newParentPath),r=n.childs[i.oldIndex]||n.append;e.childs.slice(i.newIndex,i.newIndex+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,r)}),null===i.newParentPathRedo&&(i.newParentPathRedo=e.getInternalPath())},redo:function(i){var e=o(i.oldParentPathRedo),n=o(i.newParentPathRedo),r=n.childs[i.newIndexRedo]||n.append;e.childs.slice(i.oldIndexRedo,i.oldIndexRedo+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,r)})}},sort:{undo:function(e){var t=o(e.path);t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=o(e.path);t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){o(e.path).setInternalValue(e.oldValue)},redo:function(e){o(e.path).setInternalValue(e.newValue)}}}}var t,i,n;return t=e,(i=[{key:"onChange",value:function(){}},{key:"add",value:function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}])&&B(t.prototype,i),n&&B(t,n),Object.defineProperty(t,"prototype",{writable:!1}),e}();function N(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var G=function(){function r(e,t){if(!(this instanceof r))throw new TypeError("Cannot call a class as a function");var i=this,e=(this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=t,document.createElement("div")),t=((this.dom.wrapper=e).className="jsoneditor-search",t.appendChild(e),document.createElement("div")),t=((this.dom.results=t).className="jsoneditor-results",e.appendChild(t),document.createElement("div")),e=((this.dom.input=t).className="jsoneditor-frame",t.title=(0,a.Iu)("searchTitle"),e.appendChild(t),document.createElement("button")),n=(e.type="button",e.className="jsoneditor-refresh",t.appendChild(e),document.createElement("input")),e=(n.type="text",(this.dom.search=n).oninput=function(e){i._onDelayedSearch(e)},n.onchange=function(e){i._onSearch()},n.onkeydown=function(e){i._onKeyDown(e)},n.onkeyup=function(e){i._onKeyUp(e)},e.onclick=function(e){n.select()},t.appendChild(n),document.createElement("button")),e=(e.type="button",e.title=(0,a.Iu)("searchNextResultTitle"),e.className="jsoneditor-next",e.onclick=function(){i.next()},t.appendChild(e),document.createElement("button"));e.type="button",e.title=(0,a.Iu)("searchPreviousResultTitle"),e.className="jsoneditor-previous",e.onclick=function(){i.previous()},t.appendChild(e)}var e,t,i;return e=r,(t=[{key:"next",value:function(e){var t;this.results&&((t=null!==this.resultIndex?this.resultIndex+1:0)>this.results.length-1&&(t=0),this._setActiveResult(t,e))}},{key:"previous",value:function(e){var t,i;this.results&&(t=this.results.length-1,i=null!==this.resultIndex?this.resultIndex-1:t,this._setActiveResult(i=i<0?t:i,e))}},{key:"_setActiveResult",value:function(e,t){var i;if(this.activeResult&&(i=this.activeResult.node,"field"===this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()),!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,r=this.results[this.resultIndex].elem;"field"===r?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(r)})}},{key:"_clearDelay",value:function(){void 0!==this.timeout&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)}},{key:"_onSearch",value:function(e){this._clearDelay();var t=this.dom.search.value,t=0<t.length?t:void 0;if(t!==this.lastText||e){this.lastText=t,this.results=this.editor.search(t);var e=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,i=0;if(this.activeResult)for(var n=0;n<this.results.length;n++)if(this.results[n].node===this.activeResult.node){i=n;break}this._setActiveResult(i,!1),void 0!==t?(t=this.results.length,this.dom.results.textContent=0===t?"no results":1===t?"1 result":e<t?e+"+ results":t+" results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(e){var t=e.which;27===t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13===t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())}},{key:"_onKeyUp",value:function(e){var t=e.keyCode;27!==t&&13!==t&&this._onDelayedSearch(e)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return""===this.dom.search.value}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}])&&N(e.prototype,t),i&&N(e,i),Object.defineProperty(e,"prototype",{writable:!1}),r}();function P(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var F=function(){function i(e,t){if(!(this instanceof i))throw new TypeError("Cannot call a class as a function");e&&(this.root=t,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,e.appendChild(this.path),this.reset())}var e,t,n;return e=i,(t=[{key:"reset",value:function(){this.path.textContent=(0,a.Iu)("selectNode")}},{key:"setPath",value:function(r){var o=this;this.path.textContent="",r&&r.length&&r.forEach(function(i,n){var e,t=document.createElement("span");t.className="jsoneditor-treepath-element",t.innerText=i.name,t.onclick=function(e){this.selectionCallback&&this.selectionCallback(e)}.bind(o,i),o.path.appendChild(t),i.children.length&&((e=document.createElement("span")).className="jsoneditor-treepath-seperator",e.textContent="►",e.onclick=function(){o.contentMenuClicked=!0;var t=[];i.children.forEach(function(e){t.push({text:e.name,className:"jsoneditor-type-modes"+(r[n+1]+1&&r[n+1].name===e.name?" jsoneditor-selected":""),click:function(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}.bind(o,i,e.name)})}),new s.x(t,{limitHeight:!0}).show(e,o.root,!0)},o.path.appendChild(e)),n===r.length-1&&(t=(e||t).getBoundingClientRect().right,o.path.offsetWidth<t&&(o.path.scrollLeft=t),o.path.scrollLeft&&((t=document.createElement("span")).className="jsoneditor-treepath-show-all-btn",t.title="show all path",t.textContent="...",t.onclick=function(e){(o.contentMenuClicked=!1,E.addClassName)(o.path,"show-all"),o.path.style.width=o.path.parentNode.getBoundingClientRect().width-10+"px",o.path.onblur=function(){if(o.contentMenuClicked)return o.contentMenuClicked=!1,void o.path.focus();(0,E.removeClassName)(o.path,"show-all"),o.path.onblur=void 0,o.path.style.width="",o.setPath(e)}}.bind(o,r),o.path.insertBefore(t,o.path.firstChild)))})}},{key:"onSectionSelected",value:function(e){"function"==typeof e&&(this.selectionCallback=e)}},{key:"onContextMenuItemSelected",value:function(e){"function"==typeof e&&(this.contextMenuCallback=e)}}])&&P(e.prototype,t),n&&P(e,n),Object.defineProperty(e,"prototype",{writable:!1}),i}(),r=e(8037),H=e.n(r),e={},V=(e.create=function(e,i){if(!e)throw new Error("No container element provided.");function g(e){var t,i;document.createRange?((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t)):document.selection&&((t=document.body.createTextRange()).moveToElementText(e),t.collapse(!1),t.select())}function p(e){return void 0===t&&((t=document.createElement("span")).style.visibility="hidden",t.style.position="fixed",t.style.outline="0",t.style.margin="0",t.style.padding="0",t.style.border="0",t.style.left="0",t.style.whiteSpace="pre",t.style.fontSize=I,t.style.fontFamily=v,t.style.fontWeight="normal",document.body.appendChild(t)),t.textContent=e,t.getBoundingClientRect().right}function m(){this.style.backgroundColor="#ddd"}function f(){this.style.backgroundColor=""}function C(){A.hide(),A.onmouseselection(this.__hint,A.rs)}var s,t,o,I,v,r,a,l,c,h,n,A,d,u,b,y;this.container=e,this.dom={},this.highlighter=new S,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.lastSchemaErrors=void 0,this.node=null,this.focusTarget=null,this._setOptions(i),i.autocomplete&&(this.autocomplete=((s=(s=i.autocomplete)||{}).filter=s.filter||"start",s.trigger=s.trigger||"keydown",s.confirmKeys=s.confirmKeys||[39,35,9],s.caseSensitive=s.caseSensitive||!1,v=I="",(r=document.createElement("div")).style.position="relative",r.style.outline="0",r.style.border="0",r.style.margin="0",r.style.padding="0",(a=document.createElement("div")).className="autocomplete dropdown",a.style.position="absolute",a.style.visibility="hidden",l=a,c=[],n=-1,u=A={rs:d={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:h=0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:r,show:function(e,t,i){var n=this;this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""===I&&(I=window.getComputedStyle(e).getPropertyValue("font-size")),""===v&&(v=window.getComputedStyle(e).getPropertyValue("font-family")),a.style.marginLeft="0",a.style.marginTop=e.getBoundingClientRect().height+"px",this.options=i.map(String),this.element!==e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){n.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",b),this.element.addEventListener("keydown",b,!1),this.element.removeEventListener("blur",y),this.element.addEventListener("blur",y,!1)),r.appendChild(this.elementHint),r.appendChild(a),e.parentElement.appendChild(r),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,u.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(e){var e=(e=e.innerText).replace("\n",""),t=this.options.length,i=e.substring(this.startFrom);o=e.substring(0,this.startFrom);for(var n=0;n<t;n++){var r=this.options[n];if(!s.caseSensitive&&0===r.toLowerCase().indexOf(i.toLowerCase())||s.caseSensitive&&0===r.indexOf(i)){this.elementHint.innerText=o+i+r.substring(i.length),this.elementHint.realInnerText=o+r;break}}a.style.left=p(o)+"px",u.refresh(i,this.options),this.elementHint.style.width=p(this.elementHint.innerText)+10+"px","hidden"===a.style.visibility||(this.elementHint.style.width=p(this.elementHint.innerText)+a.clientWidth+"px")}},hide:function(){l.style.visibility="hidden"},refresh:function(n,e){l.style.visibility="hidden",h=0,l.textContent="";var t=window.innerHeight||document.documentElement.clientHeight,i=l.parentNode.getBoundingClientRect(),r=i.top-6,t=t-i.bottom-6,o=(c=[],"function"==typeof s.filter?s.filter:w[s.filter]),i=o?e.filter(function(e){return o(s.caseSensitive?n:n.toLowerCase(),s.caseSensitive?e:e.toLowerCase(),s)}):[];0!==(c=i.map(function(e){var t=document.createElement("div"),i=(t.className="item",t.onmouseover=m,t.onmouseout=f,t.onmousedown=C,t.__hint=e,t.textContent="",t.appendChild(document.createTextNode(e.substring(0,n.length))),document.createElement("b"));return i.appendChild(document.createTextNode(e.substring(n.length))),t.appendChild(i),l.appendChild(t),t})).length&&(1===c.length&&(n.toLowerCase()===c[0].__hint.toLowerCase()&&!s.caseSensitive||n===c[0].__hint&&s.caseSensitive)||c.length<2||(A.highlight(0),3*t<r?(l.style.maxHeight=r+"px",l.style.top="",l.style.bottom="100%"):(l.style.top="100%",l.style.bottom="",l.style.maxHeight=t+"px"),l.style.visibility="visible"))},highlight:function(e){-1!==n&&c[n]&&(c[n].className="item"),c[e].className="item hover",n=e},move:function(e){return"hidden"===l.style.visibility?"":(h+e===-1||h+e===c.length||(h+=e,A.highlight(h)),c[h].__hint)},onmouseselection:function(){}},b=function(e){var t=(e=e||window.event).keyCode;if(null!=this.elementHint&&33!==t&&34!==t){if(27===t)return d.hideDropDown(),d.element.focus(),e.preventDefault(),void e.stopPropagation();var i,n,r=(r=this.element.innerText).replace("\n","");if(0<=s.confirmKeys.indexOf(t))return 9===t&&0===this.elementHint.innerText.length&&d.onTab(),void(0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,d.hideDropDown(),g(this.element),9===t&&(d.element.focus(),e.preventDefault(),e.stopPropagation())));if(13!==t){if(40===t)return i=r.substring(this.startFrom),""===(n=u.move(1))&&d.onArrowDown(),this.elementHint.innerText=o+i+n.substring(i.length),this.elementHint.realInnerText=o+n,e.preventDefault(),void e.stopPropagation();38===t&&(i=r.substring(this.startFrom),""===(n=u.move(-1))&&d.onArrowUp(),this.elementHint.innerText=o+i+n.substring(i.length),this.elementHint.realInnerText=o+n,e.preventDefault(),e.stopPropagation())}else if(0===this.elementHint.innerText.length)d.onEnter();else{t="hidden"===a.style.visibility;if(u.hide(),t)return d.hideDropDown(),d.element.focus(),void d.onEnter();this.element.innerText=this.elementHint.realInnerText,d.hideDropDown(),g(this.element),e.preventDefault(),e.stopPropagation()}}}.bind(d),y=function(e){d.hideDropDown()},u.onmouseselection=function(e,t){t.element.innerText=t.elementHint.innerText=o+e,t.hideDropDown(),window.setTimeout(function(){t.element.focus(),g(t.element)},1)},d)),this.options.history&&"view"!==this.options.mode&&(this.history=new W(this)),this._createFrame(),this._createTable()},e.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.frameFocusTracker.destroy()},e._setOptions=function(t){var i=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,i){var n;H()?(n=e.getBoundingClientRect().top,n=(0,E.getWindow)(e).innerHeight-n<300&&300<n,new(H())({parent:e,color:t,popup:n?"top":"bottom",onDone:function(e){e=1===e.rgba[3]?e.hex.substr(0,7):e.hex;i(e)}}).show()):console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,timestampFormat:null,createQuery:c.r,executeQuery:c.J,onEvent:null,enableSort:!0,enableTransform:!0},t&&(Object.keys(t).forEach(function(e){i.options[e]=t[e]}),null==t.limitDragging&&null!=t.schema&&(this.options.limitDragging=!0)),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=(0,E.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),t.onSelectionChange&&this.onSelectionChange(t.onSelectionChange),(0,a.cC)(this.options.languages),(0,a.m0)(this.options.language)},e.set=function(e){e instanceof Function||void 0===e?this.clear():(this.content.removeChild(this.table),e={field:this.options.name,value:e},e=new k(this,e),this._setRoot(e),this._validateAndCatch(),this.node.expand(!1),this.content.appendChild(this.table)),this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},e.update=function(e){var t,i;this.node.deepEqual(e)||(t=this.getSelection(),this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this._validateAndCatch(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end?(e=this.node.findNodeByPath(t.start.path),i=this.node.findNodeByPath(t.end.path),e&&i?this.setSelection(t.start,t.end):this.setSelection({},{})):this.setSelection({},{}))},e.get=function(){if(this.node)return this.node.getValue()},e.getText=function(){return JSON.stringify(this.get())},e.setText=function(t){try{this.set((0,E.parse)(t))}catch(e){t=(0,E.tryJsonRepair)(t);this.set((0,E.parse)(t))}},e.updateText=function(t){try{this.update((0,E.parse)(t))}catch(e){t=(0,E.tryJsonRepair)(t);this.update((0,E.parse)(t))}},e.setName=function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},e.getName=function(){return this.options.name},e.focus=function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},e.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},e._setRoot=function(e){this.clear(),(this.node=e).setParent(null),e.setField(this.getName(),!1),delete e.index,this.tbody.appendChild(e.getDom())},e.search=function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},e.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},e.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},e._onAction=function(e,t){this.history&&this.history.add(e,t),this._onChange()},e._onChange=function(){if(!this.onChangeDisabled){var e;if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath&&((e=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0)?this._updateTreePath(e.getNodePath()):this.treePath.reset()),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(e){console.error("Error in onNodeName callback: ",e)}}},e.validate=function(){var t=this,i=this.node;if(i){var e=i.getValue(),n=[];this.validateSchema&&(this.validateSchema(e)||(n=this.validateSchema.errors.map(function(e){return(0,E.improveSchemaError)(e)}).map(function(e){return{node:i.findNode(e.dataPath),error:e,type:"validation"}}).filter(function(e){return null!=e.node})));try{this.validationSequence++;var r=this,o=this.validationSequence;return this._validateCustom(e).then(function(e){return o===r.validationSequence&&(e=[].concat(n,e||[]),r._renderValidationErrors(e),"function"==typeof t.options.onValidationError&&(0,E.isValidationErrorChanged)(e,t.lastSchemaErrors)&&t.options.onValidationError.call(t,e),t.lastSchemaErrors=e),t.lastSchemaErrors})}catch(e){return Promise.reject(e)}}},e._validateAndCatch=function(){this.validate().catch(function(e){console.error("Error running validation:",e)})},e._renderValidationErrors=function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?(0,a.Iu)("containsInvalidProperties"):(0,a.Iu)("containsInvalidItems")}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},e._validateCustom=function(e){try{var i,t;if(this.options.onValidate)return i=this.node,t=this.options.onValidate(e),((0,E.isPromise)(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=(0,E.isValidValidationError)(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var t;try{t=e&&e.path?i.findNodeByPath(e.path):null}catch(e){}return t||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:t,error:e,type:"customValidation"}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}catch(e){return Promise.reject(e)}return Promise.resolve(null)},e.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},e.startAutoScroll=function(e){var t=this,i=this.scrollableContent,n=(0,E.getAbsoluteTop)(i),r=i.clientHeight,o=n+r;e<n+24&&0<i.scrollTop?this.autoScrollStep=(n+24-e)/3:o-24<e&&r+i.scrollTop<i.scrollHeight?this.autoScrollStep=(o-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},e.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},e.setDomSelection=function(e){var t,i,n;e&&("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths?(t=this,i=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)}),this.select(i)):(n=(i=e.path?this.node.findNodeByInternalPath(e.path):null)&&e.domName?i.dom[e.domName]:null,e.range&&n?(e=Object.assign({},e.range,{container:n}),(0,E.setSelectionOffset)(e)):i&&i.focus()))},e.getDomSelection=function(){var t=k.getNodeFromTarget(this.focusTarget),i=this.focusTarget,e=t?Object.keys(t.dom).find(function(e){return t.dom[e]===i}):null,n=(0,E.getSelectionOffset)();return(n=(n=n&&"DIV"!==n.container.nodeName?null:n)&&n.container!==i?null:n)&&delete n.container,{path:t?t.getInternalPath():null,domName:e,range:n,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},e.scrollTo=function(e,i){var n,t,r,o,s=this.scrollableContent;s?((n=this).animateTimeout&&(clearTimeout(n.animateTimeout),delete n.animateTimeout),n.animateCallback&&(n.animateCallback(!1),delete n.animateCallback),t=s.clientHeight,r=s.scrollHeight-t,o=Math.min(Math.max(e-t/4,0),r),function e(){var t=s.scrollTop,t=o-t;3<Math.abs(t)?(s.scrollTop+=t/3,n.animateCallback=i,n.animateTimeout=setTimeout(e,50)):(i&&i(!0),s.scrollTop=o,delete n.animateTimeout,delete n.animateCallback)}()):i&&i(!1)},e._createFrame=function(){this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer";var t=this;function i(e){t._onEvent&&t._onEvent(e)}var e,n,r,o={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new l.R(o),this.frame.onclick=function(e){var t=e.target;i(e),"BUTTON"===t.nodeName&&e.preventDefault()},this.frame.oninput=i,this.frame.onchange=i,this.frame.onkeydown=i,this.frame.onkeyup=i,this.frame.oncut=i,this.frame.onpaste=i,this.frame.onmousedown=i,this.frame.onmouseup=i,this.frame.onmouseover=i,this.frame.onmouseout=i,(0,E.addEventListener)(this.frame,"focus",i,!0),(0,E.addEventListener)(this.frame,"blur",i,!0),this.frame.onfocusin=i,this.frame.onfocusout=i,this.options.mainMenuBar&&((0,E.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(o=document.createElement("button")).type="button",o.className="jsoneditor-expand-all",o.title=(0,a.Iu)("expandAll"),o.onclick=function(){t.expandAll()},this.menu.appendChild(o),(o=document.createElement("button")).type="button",o.title=(0,a.Iu)("collapseAll"),o.className="jsoneditor-collapse-all",o.onclick=function(){t.collapseAll()},this.menu.appendChild(o),this.options.enableSort&&((o=document.createElement("button")).type="button",o.className="jsoneditor-sort",o.title=(0,a.Iu)("sortTitleShort"),o.onclick=function(){t.node.showSortModal()},this.menu.appendChild(o)),this.options.enableTransform&&((o=document.createElement("button")).type="button",o.title=(0,a.Iu)("transformTitleShort"),o.className="jsoneditor-transform",o.onclick=function(){t.node.showTransformModal()},this.menu.appendChild(o)),this.history&&((e=document.createElement("button")).type="button",e.className="jsoneditor-undo jsoneditor-separator",e.title=(0,a.Iu)("undo"),e.onclick=function(){t._onUndo()},this.menu.appendChild(e),this.dom.undo=e,(n=document.createElement("button")).type="button",n.className="jsoneditor-redo",n.title=(0,a.Iu)("redo"),n.onclick=function(){t._onRedo()},this.menu.appendChild(n),this.dom.redo=n,this.history.onChange=function(){e.disabled=!t.history.canUndo(),n.disabled=!t.history.canRedo()},this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&((r=this).modeSwitcher=new d.x(this.menu,this.options.modes,this.options.mode,function(e){try{r.setMode(e),r.modeSwitcher.focus()}catch(e){r._onError(e)}})),this.options.search&&(this.searchBox=new G(this,this.menu))),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new F(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},e._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},e._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},e._onEvent=function(e){if(!k.targetIsColorPicker(e.target)){var t,i=k.getNodeFromTarget(e.target);if("keydown"===e.type&&this._onKeyDown(e),i&&"focus"===e.type&&(this.focusTarget=e.target,this.options.autocomplete&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(e.target)),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e),i&&this.options&&this.options.navigationBar&&i&&("keydown"===e.type||"mousedown"===e.type)&&(t=this,setTimeout(function(){t._updateTreePath(i.getNodePath())})),i&&i.selected){if("click"===e.type){if(e.target===i.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&k.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&(0,E.hasParentNode)(e.target,this.content)&&(this.deselect(),i&&e.target===i.dom.drag?k.onDragStart(i,e):i&&(e.target===i.dom.field||e.target===i.dom.value||e.target===i.dom.select)||this._onMultiSelectStart(e));i&&i.onEvent(e)}},e._updateTreePath=function(e){var i;function n(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.field||e.type}e&&e.length?((0,E.removeClassName)(this.navBar,"nav-bar-empty"),i=[],e.forEach(function(e){var t={name:n(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){t.children.push({name:n(e),node:e})}),i.push(t)}),this.treePath.setPath(i)):(0,E.addClassName)(this.navBar,"nav-bar-empty")},e._onTreePathSectionSelected=function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},e._onTreePathMenuItemSelected=function(e,t){e&&e.children.length&&((e=e.children.find(function(e){return e.name===t}))&&e.node&&(this._updateTreePath(e.node.getNodePath()),e.node.expandTo(),e.node.focus()))},e._startDragDistance=function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},e._updateDragDistance=function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},e._onMultiSelectStart=function(e){var t,i=k.getNodeFromTarget(e.target);"tree"===this.options.mode&&void 0===this.options.onEditable&&(this.multiselection={start:i||null,end:null,nodes:[]},this._startDragDistance(e),(t=this).mousemove||(this.mousemove=(0,E.addEventListener)(e.view,"mousemove",function(e){t._onMultiSelect(e)})),this.mouseup||(this.mouseup=(0,E.addEventListener)(e.view,"mouseup",function(e){t._onMultiSelectEnd(e)})),e.preventDefault())},e._onMultiSelect=function(e){var t;e.preventDefault(),this._updateDragDistance(e),e.hasMoved&&((e=k.getNodeFromTarget(e.target))&&(null==this.multiselection.start&&(this.multiselection.start=e),this.multiselection.end=e),this.deselect(),e=this.multiselection.start,t=this.multiselection.end||this.multiselection.start,e&&t&&(this.multiselection.nodes=this._findTopLevelNodes(e,t),this.multiselection.nodes&&this.multiselection.nodes.length&&(e=this.multiselection.nodes[0],this.multiselection.start===e||this.multiselection.start.isDescendantOf(e)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes)))},e._onMultiSelectEnd=function(e){var t=this.multiselection.nodes[0];t&&t.dom.menu&&t.dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&((0,E.removeEventListener)(e.view,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&((0,E.removeEventListener)(e.view,"mouseup",this.mouseup),delete this.mouseup)},e.deselect=function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},e.select=function(e){if(!Array.isArray(e))return this.select([e]);var t;e&&(this.deselect(),this.multiselection.nodes=e.slice(0),t=e[0],e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler&&(e=this.getSelection(),this._selectionChangedHandler(e.start,e.end)))},e._findTopLevelNodes=function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),r=0;r<i.length&&i[r]===n[r];)r++;var o,e=i[r-1],t=i[r],s=n[r];return t&&s||(e.parent?e=(s=t=e).parent:(t=e.childs[0],s=e.childs[e.childs.length-1])),e&&t&&s?(t=e.childs.indexOf(t),s=e.childs.indexOf(s),o=Math.min(t,s),t=Math.max(t,s),e.childs.slice(o,t+1)):[]},e._showAutoComplete=function(t){var i,n=k.getNodeFromTarget(t),r="";0<=t.className.indexOf("jsoneditor-value")&&(r="value"),""!==(r=0<=t.className.indexOf("jsoneditor-field")?"field":r)&&(i=this,setTimeout(function(){var e;!n||!("focus"===i.options.autocomplete.trigger||0<t.innerText.length)||null===(e=i.options.autocomplete.getOptions(t.innerText,n.getPath(),r,n.editor))?i.autocomplete.hideDropDown():"function"==typeof e.then?e.then(function(e){null===e?i.autocomplete.hideDropDown():e.options?i.autocomplete.show(t,e.startFrom,e.options):i.autocomplete.show(t,0,e)}).catch(function(e){console.error(e)}):e.options?i.autocomplete.show(t,e.startFrom,e.options):i.autocomplete.show(t,0,e)},50))},e._onKeyDown=function(e){var t,i=e.which||e.keyCode,n=e.altKey,r=e.ctrlKey,o=e.metaKey,s=e.shiftKey,a=!1,l=this.focusTarget;9===i&&(t=this,setTimeout(function(){t.focusTarget!==l&&(0,E.selectContentEditable)(t.focusTarget)},0)),this.searchBox&&(r&&70===i?(this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),a=!0):(114===i||r&&71===i)&&(s?this.searchBox.previous(!0):this.searchBox.next(!0),a=!0)),this.history&&(r&&!s&&90===i?(this._onUndo(),a=!0):r&&s&&90===i&&(this._onRedo(),a=!0)),this.options.autocomplete&&!a&&(r||n||o||1!==e.key.length&&8!==i&&46!==i||(a=!1,this._showAutoComplete(e.target))),a&&(e.preventDefault(),e.stopPropagation())},e._createTable=function(){var e;this.options.navigationBar&&(0,E.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&((e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e)),(e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e),e=document.createElement("col"),this.colgroupContent.appendChild(e),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},e.showContextMenu=function(e,t){var i,n=[],r=this.multiselection.nodes.slice();n.push({text:(0,a.Iu)("duplicateText"),title:(0,a.Iu)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){k.onDuplicate(r)}}),n.push({text:(0,a.Iu)("remove"),title:(0,a.Iu)("removeTitle"),className:"jsoneditor-remove",click:function(){k.onRemove(r)}}),this.options.onCreateMenu&&(i=r.map(function(e){return e.getPath()}),n=this.options.onCreateMenu(n,{type:"multiple",path:i[0],paths:i})),new s.x(n,{close:t}).show(e,this.getPopupAnchor())},e.getPopupAnchor=function(){return this.options.popupAnchor||this.frame},e.getSelection=function(){var e,t,i={start:null,end:null};return this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length&&(e=this.multiselection.nodes[0],t=this.multiselection.nodes[this.multiselection.nodes.length-1],"down"===this.multiselection.direction?(i.start=e.serialize(),i.end=t.serialize()):(i.start=t.serialize(),i.end=e.serialize())),i},e.onSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=(0,E.debounce)(e,this.DEBOUNCE_INTERVAL))},e.setSelection=function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(e));e=this._getNodeInstancesByRange(e,t);e.forEach(function(e){e.expandTo()}),this.select(e)},e._getNodeInstancesByRange=function(e,t){e&&e.path&&(i=this.node.findNodeByPath(e.path),t&&t.path&&(n=this.node.findNodeByPath(t.path)));var i,n,r=[];if(i instanceof k)if(n instanceof k&&n!==i)if(i.parent===n.parent){t=i.getIndex()<n.getIndex()?(e=i,n):(e=n,i);var o=e;for(r.push(o);o=o.nextSibling(),r.push(o),o&&o!==t;);}else r=this._findTopLevelNodes(i,n);else r.push(i);return r},e.getNodesByRange=function(e,t){var e=this._getNodeInstancesByRange(e,t),i=[];return e.forEach(function(e){i.push(e.serialize())}),i},[{mode:"tree",mixin:e,data:"json"},{mode:"view",mixin:e,data:"json"},{mode:"form",mixin:e,data:"json"}])},2744:function(e,t,i){t.tryRequireAjv=function(){try{return i(8903)}catch(e){}}},9125:function(e,t,i){t.O=function(){try{i(4864)}catch(e){console.error(e)}}},9791:function(h,e,t){"use strict";t.r(e),t.d(e,{parse:function(){return C},tryJsonRepair:function(){return I},escapeUnicodeChars:function(){return v},validate:function(){return A},extend:function(){return b},clear:function(){return y},getType:function(){return w},isUrl:function(){return x},isArray:function(){return k},getWindow:function(){return E},getAbsoluteLeft:function(){return R},getAbsoluteTop:function(){return T},addClassName:function(){return _},removeAllClassNames:function(){return $},removeClassName:function(){return L},stripFormatting:function(){return B},setEndOfContentEditable:function(){return W},selectContentEditable:function(){return N},getSelection:function(){return G},setSelection:function(){return P},getSelectionOffset:function(){return F},setSelectionOffset:function(){return H},getInnerText:function(){return c},removeReturnsAndSurroundingWhitespace:function(){return V},hasParentNode:function(){return Z},getInternetExplorerVersion:function(){return M},isFirefox:function(){return o},addEventListener:function(){return O},removeEventListener:function(){return D},isChildOf:function(){return K},parsePath:function(){return s},stringifyPath:function(){return j},improveSchemaError:function(){return z},isPromise:function(){return X},isValidValidationError:function(){return J},insideRect:function(){return Y},debounce:function(){return U},textDiff:function(){return Q},getInputSelection:function(){return q},getIndexForPosition:function(){return ee},getPositionForPath:function(){return te},compileJSONPointer:function(){return ie},getColorCSS:function(){return ne},isValidColor:function(){return re},makeFieldTooltip:function(){return oe},get:function(){return a},findUniqueName:function(){return se},getChildPaths:function(){return ae},sort:function(){return le},sortObjectKeys:function(){return ce},parseString:function(){return he},isTimestamp:function(){return de},formatSize:function(){return ue},limitCharacters:function(){return ge},isObject:function(){return l},contains:function(){return pe},isValidationErrorChanged:function(){return me}});t(4987);var e=t(233),d=t.n(e),e=t(3860),u=t.n(e),i=t(6589),g=t(7026),p=t(7907);function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var m=1e4,f=9466848e5;function C(t){try{return JSON.parse(t)}catch(e){throw A(t),e}}function I(t){try{return u()(t)}catch(e){return t}}function v(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})}function A(e){(void 0!==i?i:JSON).parse(e)}function b(e,t){for(var i in t)fe(t,i)&&(e[i]=t[i]);return e}function y(e){for(var t in e)fe(e,t)&&delete e[t];return e}function w(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp?"regexp":k(e)?"array":"object"}var S=/^https?:\/\/\S+$/;function x(e){return("string"==typeof e||e instanceof String)&&S.test(e)}function k(e){return"[object Array]"===Object.prototype.toString.call(e)}function E(e){return e.ownerDocument.defaultView}function R(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function T(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function _(e,t){var i=e.className.split(" ");-1===i.indexOf(t)&&(i.push(t),e.className=i.join(" "))}function $(e){e.className=""}function L(e,t){var i=e.className.split(" "),t=i.indexOf(t);-1!==t&&(i.splice(t,1),e.className=i.join(" "))}function B(e){for(var t=e.childNodes,i=0,n=t.length;i<n;i++){var r=t[i],o=(r.style&&r.removeAttribute("style"),r.attributes);if(o)for(var s=o.length-1;0<=s;s--){var a=o[s];!0===a.specified&&r.removeAttribute(a.name)}B(r)}}function W(e){var t;document.createRange&&((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(e=window.getSelection()).removeAllRanges(),e.addRange(t))}function N(e){var t;e&&"DIV"===e.nodeName&&window.getSelection&&document.createRange&&((t=document.createRange()).selectNodeContents(e),(e=window.getSelection()).removeAllRanges(),e.addRange(t))}function G(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null}function P(e){var t;e&&window.getSelection&&((t=window.getSelection()).removeAllRanges(),t.addRange(e))}function F(){var e=G();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer===e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null}function H(e){var t;document.createRange&&window.getSelection&&window.getSelection()&&(t=document.createRange(),e.container.firstChild||e.container.appendChild(document.createTextNode("")),t.setStart(e.container.firstChild,e.startOffset),t.setEnd(e.container.firstChild,e.endOffset),P(t))}function c(e,t){var i;if(void 0===t&&(t={_text:"",flush:function(){var e=this._text;return this._text="",e},set:function(e){this._text=e}}),e.nodeValue)return""!==(i=V(e.nodeValue))?t.flush()+i:"";if(e.hasChildNodes()){for(var n=e.childNodes,r="",o=0,s=n.length;o<s;o++){var a,l=n[o];"DIV"===l.nodeName||"P"===l.nodeName?((a=(a=n[o-1])?a.nodeName:void 0)&&"DIV"!==a&&"P"!==a&&"BR"!==a&&(""!==r&&(r+="\n"),t.flush()),r+=c(l,t),t.set("\n")):"BR"===l.nodeName?(r+=t.flush(),t.set("\n")):r+=c(l,t)}return r}return""}function V(e){return e.replace(/(\b|^)\s*(\b|$)/g,function(e){return/\n/.exec(e)?"":e})}function Z(e,t){for(var i=e?e.parentNode:void 0;i;){if(i===t)return!0;i=i.parentNode}return!1}function M(){var e;return-1===n&&(e=-1,"undefined"!=typeof navigator&&"Microsoft Internet Explorer"===navigator.appName&&(null!=/MSIE ([0-9]+[.0-9]+)/.exec(navigator.userAgent)&&(e=parseFloat(RegExp.$1))),n=e),n}var n=-1;function o(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")}function O(e,t,i,n){return e.addEventListener?(void 0===n&&(n=!1),"mousewheel"===t&&o()&&(t="DOMMouseScroll"),e.addEventListener(t,i,n),i):e.attachEvent?(e.attachEvent("on"+t,n=function(){return i.call(e,window.event)}),n):void 0}function D(e,t,i,n){e.removeEventListener?(void 0===n&&(n=!1),"mousewheel"===t&&o()&&(t="DOMMouseScroll"),e.removeEventListener(t,i,n)):e.detachEvent&&e.detachEvent("on"+t,i)}function K(e,t){for(var i=e.parentNode;i;){if(i===t)return!0;i=i.parentNode}return!1}function s(i){var e=[],n=0;function t(e){for(var t="";void 0!==i[n]&&i[n]!==e;)t+=i[n],n++;if(i[n]!==e)throw new Error("Invalid JSON path: unexpected end, character "+e+" expected");return t}for(;void 0!==i[n];)if("."===i[n])n++,e.push(function(){for(var e="";void 0!==i[n]&&/[\w$]/.test(i[n]);)e+=i[n],n++;if(""===e)throw new Error("Invalid JSON path: property name expected at index "+n);return e}());else{if("["!==i[n])throw new Error('Invalid JSON path: unexpected character "'+i[n]+'" at index '+n);if("'"===i[++n]||'"'===i[n]){var r=i[n];if(n++,e.push(t(r)),i[n]!==r)throw new Error("Invalid JSON path: closing quote ' expected at index "+n);n++}else{r=t("]").trim();if(0===r.length)throw new Error("Invalid JSON path: array value expected at index "+n);r="*"===r?r:JSON.parse(r),e.push(r)}if("]"!==i[n])throw new Error("Invalid JSON path: closing bracket ] expected at index "+n);n++}return e}function j(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"string"==typeof e&&e.match(/^[A-Za-z0-9_$]+$/)?"."+e:'["'+e+'"]'}).join("")}function z(e){var t,i;return"enum"!==e.keyword||!Array.isArray(e.schema)||(i=e.schema)&&(5<(i=i.map(function(e){return JSON.stringify(e)})).length&&(t=["("+(i.length-5)+" more...)"],(i=i.slice(0,5)).push(t)),e.message="should be equal to one of: "+i.join(", ")),"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e}function X(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch}function J(e){return"object"===r(e)&&Array.isArray(e.path)&&"string"==typeof e.message}function Y(e,t,i){i=void 0!==i?i:0;return t.left-i>=e.left&&t.right+i<=e.right&&t.top-i>=e.top&&t.bottom+i<=e.bottom}function U(n,r,o){var s;return function(){var e=this,t=arguments,i=o&&!s;clearTimeout(s),s=setTimeout(function(){s=null,o||n.apply(e,t)},r),i&&n.apply(e,t)}}function Q(e,t){for(var i=t.length,n=0,r=e.length,o=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(o-1)===e.charAt(r-1)&&n<o&&0<r;)o--,r--;return{start:n,end:o}}function q(t){var e,i,n,r,o=0,s=0;return"number"==typeof t.selectionStart&&"number"==typeof t.selectionEnd?(o=t.selectionStart,s=t.selectionEnd):(r=document.selection.createRange())&&r.parentElement()===t&&(n=t.value.length,e=t.value.replace(/\r\n/g,"\n"),(i=t.createTextRange()).moveToBookmark(r.getBookmark()),(r=t.createTextRange()).collapse(!1),-1<i.compareEndPoints("StartToEnd",r)?o=s=n:(o=-i.moveStart("character",-n),o+=e.slice(0,o).split("\n").length-1,-1<i.compareEndPoints("EndToEnd",r)?s=n:(s=-i.moveEnd("character",-n),s+=e.slice(0,s).split("\n").length-1))),{startIndex:o,endIndex:s,start:a(o),end:a(s)};function a(e){e=t.value.substring(0,e);return{row:(e.match(/\n/g)||[]).length+1,column:e.length-e.lastIndexOf("\n")}}}function ee(e,t,i){var e=e.value||"";return 0<t&&0<i?(e=e.split("\n",t),t=Math.min(e.length,t),i=Math.min(e[t-1].length,i-1),i=1===t?i:i+1,e.slice(0,t-1).join("\n").length+i):-1}function te(e,t){var i,n=[];if(!t||!t.length)return n;try{i=g.parse(e)}catch(e){return n}return t.forEach(function(e){var t=ie(s(e)),t=i.pointers[t];t&&n.push({path:e,line:t.key?t.key.line:t.value?t.value.line:0,column:t.key?t.key.column:t.value?t.value.column:0})}),n}function ie(e){return e.map(function(e){return"/"+String(e).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function ne(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null}function re(e){return!!ne(e)}function oe(i,e){if(!i)return"";var n="";return i.title&&(n+=i.title),i.description&&(0<n.length&&(n+="\n"),n+=i.description),i.default&&(0<n.length&&(n+="\n\n"),n=(n+=(0,p.Iu)("default",void 0,e)+"\n")+JSON.stringify(i.default,null,2)),Array.isArray(i.examples)&&0<i.examples.length&&(0<n.length&&(n+="\n\n"),n+=(0,p.Iu)("examples",void 0,e)+"\n",i.examples.forEach(function(e,t){n+=JSON.stringify(e,null,2),t!==i.examples.length-1&&(n+="\n")})),n}function a(e,t){for(var i=e,n=0;n<t.length&&null!=i;n++)i=i[t[n]];return i}function se(e,t){for(var i=e.replace(/ \(copy( \d+)?\)$/,""),n=i,r=1;-1!==t.indexOf(n);){n=i+" ("+("copy"+(1<r?" "+r:""))+")";r++}return n}function ae(e,t){var i={};if(Array.isArray(e))for(var n=Math.min(e.length,m),r=0;r<n;r++)!function t(i,n,r,o){(Array.isArray(i)||l(i))&&!o||(n[r||""]=!0),l(i)&&Object.keys(i).forEach(function(e){t(i[e],n,r+"."+e,o)})}(e[r],i,"",t);else i[""]=!0;return Object.keys(i).sort()}function le(e,t,i){var n=t&&"."!==t?s(t):[],r="desc"===i?-1:1,t=e.slice();return t.sort(function(e,t){e=a(e,n),t=a(t,n);return r*(t<e?1:e<t?-1:0)}),t}function ce(t,e){var i="desc"===e?-1:1,e=Object.keys(t).sort(function(e,t){return i*d()(e,t)}),n={};return e.forEach(function(e){n[e]=t[e]}),n}function he(e){if(""===e)return"";var t=e.toLowerCase();if(
"null"===t)return null;if("true"===t)return!0;if("false"===t)return!1;var t=Number(e),i=parseFloat(e);return isNaN(t)||isNaN(i)?e:t}function de(e,t){return"number"==typeof t&&f<t&&isFinite(t)&&Math.floor(t)===t&&!isNaN(new Date(t).valueOf())}function ue(e){if(e<900)return e.toFixed()+" B";e/=1e3;if(e<900)return e.toFixed(1)+" KB";e/=1e3;if(e<900)return e.toFixed(1)+" MB";e/=1e3;return e<900?e.toFixed(1)+" GB":(e/1e3).toFixed(1)+" TB"}function ge(e,t){return e.length<=t?e:e.slice(0,t)+"..."}function l(e){return"object"===r(e)&&null!==e&&!Array.isArray(e)}function pe(e,t){return-1!==e.indexOf(t)}function me(i,e){if(!e&&!i)return!1;if(e&&!i||!e&&i)return!0;if(e.length!==i.length)return!0;for(var t=0;t<i.length;++t){var n=function(t){if(!("error"===i[t].type?e.find(function(e){return e.line===i[t].line}):e.find(function(e){return e.dataPath===i[t].dataPath&&e.schemaPath===i[t].schemaPath})))return{v:!0}}(t);if("object"===r(n))return n.v}return!1}function fe(e,t){return Object.prototype.hasOwnProperty.call(e,t)}},8037:function(e,t,i){var n;if(window.Picker)n=window.Picker;else try{n=i(4049)}catch(e){}e.exports=n},6225:function(i,a,C){function l(e,i){var t,n;return i=s(e,i),(e=r.modules[i])||("function"==typeof(e=r.payloads[i])&&(t={id:i,uri:"",exports:n={},packaged:!0},n=e(function(e,t){return o(i,e,t)},n,t)||t.exports,r.modules[i]=n,delete r.payloads[i]),e=r.modules[i]=n||e),e}var e,t,n,r,o,c,s;i=C.nmd(i),(n=function(){return this}())||"undefined"==typeof window||(n=window),(r=function(e,t,i){"string"==typeof e?(2==arguments.length&&(i=t),r.modules[e]||(r.payloads[e]=i,r.modules[e]=null)):r.original?r.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace())}).modules={},r.payloads={},o=function(e,t,i){if("string"==typeof t){var n=l(e,t);if(null!=n)return i&&i(),n}else if("[object Array]"===Object.prototype.toString.call(t)){for(var r=[],o=0,s=t.length;o<s;++o){var a=l(e,t[o]);if(null==a&&c.original)return;r.push(a)}return i&&i.apply(null,r)||!0}},c=function(e,t){var i=o("",e,t);return null==i&&c.original?c.original.apply(this,arguments):i},s=function(e,t){var i;if(-1!==t.indexOf("!"))return i=t.split("!"),s(e,i[0])+"!"+s(e,i[1]);if("."==t.charAt(0))for(t=e.split("/").slice(0,-1).join("/")+"/"+t;-1!==t.indexOf(".")&&n!=t;){var n=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return t},t=n,(e="ace")&&(n[e]||(n[e]={}),t=n[e]),t.define&&t.define.packaged||(r.original=t.define,t.define=r,t.define.packaged=!0),t.require&&t.require.packaged||(c.original=t.require,t.require=c,t.require.packaged=!0),ace.define("ace/lib/fixoldbrowsers",["require","exports","module"],function(e,t,i){"use strict";"undefined"==typeof Element||Element.prototype.remove||Object.defineProperty(Element.prototype,"remove",{enumerable:!1,writable:!0,configurable:!0,value:function(){this.parentNode&&this.parentNode.removeChild(this)}})}),ace.define("ace/lib/useragent",["require","exports","module"],function(e,t,i){"use strict";t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS};var n="object"==typeof navigator?navigator:{},r=(/mac|win|linux/i.exec(n.platform)||["other"])[0].toLowerCase(),o=n.userAgent||"",n=n.appName||"";t.isWin="win"==r,t.isMac="mac"==r,t.isLinux="linux"==r,t.isIE="Microsoft Internet Explorer"==n||0<=n.indexOf("MSAppHost")?parseFloat((o.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((o.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=o.match(/ Gecko\/\d+/),t.isOpera="object"==typeof opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(o.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(o.split(" Chrome/")[1])||void 0,t.isEdge=parseFloat(o.split(" Edge/")[1])||void 0,t.isAIR=0<=o.indexOf("AdobeAIR"),t.isAndroid=0<=o.indexOf("Android"),t.isChromeOS=0<=o.indexOf(" CrOS "),t.isIOS=/iPad|iPhone|iPod/.test(o)&&!window.MSStream,t.isIOS&&(t.isMac=!0),t.isMobile=t.isIOS||t.isAndroid}),ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],function(e,o,t){"use strict";var s,i,e=e("./useragent"),a=(o.buildDom=function e(t,i,n){if("string"==typeof t&&t)return c=document.createTextNode(t),i&&i.appendChild(c),c;if(!Array.isArray(t))return t&&t.appendChild&&i&&i.appendChild(t),t;if("string"!=typeof t[0]||!t[0]){for(var r=[],o=0;o<t.length;o++){var s=e(t[o],i,n);s&&r.push(s)}return r}for(var a=document.createElement(t[0]),l=t[1],c=1,o=c=l&&"object"==typeof l&&!Array.isArray(l)?2:c;o<t.length;o++)e(t[o],a,n);return 2==c&&Object.keys(l).forEach(function(e){var t=l[e];"class"===e?a.className=Array.isArray(t)?t.join(" "):t:"function"==typeof t||"value"==e||"$"==e[0]?a[e]=t:"ref"===e?n&&(n[t]=a):"style"===e?"string"==typeof t&&(a.style.cssText=t):null!=t&&a.setAttribute(e,t)}),i&&i.appendChild(a),a},o.getDocumentHead=function(e){return(e=e||document).head||e.getElementsByTagName("head")[0]||e.documentElement},o.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||"http://www.w3.org/1999/xhtml",e):document.createElement(e)},o.removeChildren=function(e){e.innerHTML=""},o.createTextNode=function(e,t){return(t?t.ownerDocument:document).createTextNode(e)},o.createFragment=function(e){return(e?e.ownerDocument:document).createDocumentFragment()},o.hasCssClass=function(e,t){return-1!==(e.className+"").split(/\s+/g).indexOf(t)},o.addCssClass=function(e,t){o.hasCssClass(e,t)||(e.className+=" "+t)},o.removeCssClass=function(e,t){for(var i=e.className.split(/\s+/g);;){var n=i.indexOf(t);if(-1==n)break;i.splice(n,1)}e.className=i.join(" ")},o.toggleCssClass=function(e,t){for(var i=e.className.split(/\s+/g),n=!0;;){var r=i.indexOf(t);if(-1==r)break;n=!1,i.splice(r,1)}return n&&i.push(t),e.className=i.join(" "),n},o.setCssClass=function(e,t,i){i?o.addCssClass(e,t):o.removeCssClass(e,t)},o.hasCssString=function(e,t){var i,n=0;if(i=(t=t||document).querySelectorAll("style"))for(;n<i.length;)if(i[n++].id===e)return!0},[]);function l(){var e=a;a=null,e&&e.forEach(function(e){n(e[0],e[1])})}function n(e,t,i){if("undefined"!=typeof document){if(a)if(i)l();else if(!1===i)return a.push([e,t]);if(!s){var n=i,i=(n=!(i&&i.getRootNode&&(n=i.getRootNode())&&n!=i)?document:n).ownerDocument||n;if(t&&o.hasCssString(t,n))return null;t&&(e+="\n/*# sourceURL=ace/css/"+t+" */");var r=o.createElement("style");r.appendChild(i.createTextNode(e)),t&&(r.id=t),(n=n==i?o.getDocumentHead(i):n).insertBefore(r,n.firstChild)}}}o.useStrictCSP=function(e){0==(s=e)?l():a=a||[]},o.importCssString=n,o.importCssStylsheet=function(e,t){o.buildDom(["link",{rel:"stylesheet",href:e}],o.getDocumentHead(t))},o.scrollbarWidth=function(e){var t=o.createElement("ace_inner"),i=(t.style.width="100%",t.style.minWidth="0px",t.style.height="200px",t.style.display="block",o.createElement("ace_outer")),n=i.style,e=(n.position="absolute",n.left="-10000px",n.overflow="hidden",n.width="200px",n.minWidth="0px",n.height="150px",n.display="block",i.appendChild(t),e.documentElement),r=(e.appendChild(i),t.offsetWidth),n=(n.overflow="scroll",t.offsetWidth);return r==n&&(n=i.clientWidth),e.removeChild(i),r-n},o.computedStyle=function(e,t){return window.getComputedStyle(e,"")||{}},o.setStyle=function(e,t,i){e[t]!==i&&(e[t]=i)},o.HAS_CSS_ANIMATION=!1,o.HAS_CSS_TRANSFORMS=!1,o.HI_DPI=!e.isWin||"undefined"!=typeof window&&1.5<=window.devicePixelRatio,e.isChromeOS&&(o.HI_DPI=!1),"undefined"!=typeof document&&(i=document.createElement("div"),o.HI_DPI&&void 0!==i.style.transform&&(o.HAS_CSS_TRANSFORMS=!0),e.isEdge||void 0===i.style.animationName||(o.HAS_CSS_ANIMATION=!0),i=null),o.HAS_CSS_TRANSFORMS?o.translate=function(e,t,i){e.style.transform="translate("+Math.round(t)+"px, "+Math.round(i)+"px)"}:o.translate=function(e,t,i){e.style.top=Math.round(i)+"px",e.style.left=Math.round(t)+"px"}}),ace.define("ace/lib/oop",["require","exports","module"],function(e,i,t){"use strict";i.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},i.mixin=function(e,t){for(var i in t)e[i]=t[i];return e},i.implement=function(e,t){i.mixin(e,t)}}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],function(e,t,i){"use strict";var o=e("./oop"),n=function(){var e,t,i={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8,control:1},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(t in i.FUNCTION_KEYS)e=i.FUNCTION_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);for(t in i.PRINTABLE_KEYS)e=i.PRINTABLE_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);o.mixin(i,i.MODIFIER_KEYS),o.mixin(i,i.PRINTABLE_KEYS),o.mixin(i,i.FUNCTION_KEYS),i.enter=i.return,i.escape=i.esc,i.del=i.delete,i[173]="-";for(var n=["cmd","ctrl","alt","shift"],r=Math.pow(2,n.length);r--;)i.KEY_MODS[r]=n.filter(function(e){return r&i.KEY_MODS[e]}).join("-")+"-";return i.KEY_MODS[0]="",i.KEY_MODS[-1]="input-",i}();o.mixin(t,n),t.keyCodeToString=function(e){var t=n[e];return(t="string"!=typeof t?String.fromCharCode(e):t).toLowerCase()}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,d,i){"use strict";var t,o=e("./keys"),u=e("./useragent"),s=null,a=0;function r(){if(null==t){t=!1;try{document.createComment("").addEventListener("test",function(){},{get passive(){t={passive:!1}}})}catch(e){}}return t}function c(e,t,i){this.elem=e,this.type=t,this.callback=i}c.prototype.destroy=function(){l(this.elem,this.type,this.callback),this.elem=this.type=this.callback=void 0};function h(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)}var p,g=d.addListener=function(e,t,i,n){e.addEventListener(t,i,r()),n&&n.$toDestroy.push(new c(e,t,i))},l=d.removeListener=function(e,t,i){e.removeEventListener(t,i,r())};d.stopEvent=function(e){return d.stopPropagation(e),d.preventDefault(e),!1},d.stopPropagation=function(e){e.stopPropagation&&e.stopPropagation()},d.preventDefault=function(e){e.preventDefault&&e.preventDefault()},d.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||u.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.button},d.capture=function(e,t,i){var n=e&&e.ownerDocument||document;function r(e){t&&t(e),i&&i(e),l(n,"mousemove",t),l(n,"mouseup",r),l(n,"dragstart",r)}return g(n,"mousemove",t),g(n,"mouseup",r),g(n,"dragstart",r),r},d.addMouseWheelListener=function(e,t,i){"onmousewheel"in e?g(e,"mousewheel",function(e){void 0!==e.wheelDeltaX?(e.wheelX=-e.wheelDeltaX/8,e.wheelY=-e.wheelDeltaY/8):(e.wheelX=0,e.wheelY=-e.wheelDelta/8),t(e)},i):"onwheel"in e?g(e,"wheel",function(e){switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=.35*e.deltaX||0,e.wheelY=.35*e.deltaY||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=5*(e.deltaX||0),e.wheelY=5*(e.deltaY||0)}t(e)},i):g(e,"DOMMouseScroll",function(e){e.axis&&e.axis==e.HORIZONTAL_AXIS?(e.wheelX=5*(e.detail||0),e.wheelY=0):(e.wheelX=0,e.wheelY=5*(e.detail||0)),t(e)},i)},d.addMultiMouseDownListener=function(e,i,n,r,t){var o,s,a,l=0,c={2:"dblclick",3:"tripleclick",4:"quadclick"};function h(e){var t;if(0!==d.getButton(e)?l=0:1<e.detail&&!(4<++l)||(l=1),u.isIE&&(t=5<Math.abs(e.clientX-o)||5<Math.abs(e.clientY-s),a&&!t||(l=1),a&&clearTimeout(a),a=setTimeout(function(){a=null},i[l-1]||600),1==l&&(o=e.clientX,s=e.clientY)),e._clicks=l,n[r]("mousedown",e),4<l)l=0;else if(1<l)return n[r](c[l],e)}(e=!Array.isArray(e)?[e]:e).forEach(function(e){g(e,"mousedown",h,t)})};function m(e,t,i){var n=h(t);if(!u.isMac&&s){if(t.getModifierState&&(t.getModifierState("OS")||t.getModifierState("Win"))&&(n|=8),s.altGr){if(3==(3&n))return;s.altGr=0}18!==i&&17!==i||(r="location"in t?t.location:t.keyLocation,17===i&&1===r?1==s[i]&&(a=t.timeStamp):18===i&&3===n&&2===r&&t.timeStamp-a<50&&(s.altGr=!0))}if(i in o.MODIFIER_KEYS&&(i=-1),!n&&13===i){var r="location"in t?t.location:t.keyLocation;if(3===r&&(e(t,n,-i),t.defaultPrevented))return}if(u.isChromeOS&&8&n){if(e(t,n,i),t.defaultPrevented)return;n&=-9}return!!(n||i in o.FUNCTION_KEYS||i in o.PRINTABLE_KEYS)&&e(t,n,i)}function f(){s=Object.create(null)}d.getModifierString=function(e){return o.KEY_MODS[h(e)]},d.addCommandKeyListener=function(e,i,t){var n,r;u.isOldGecko||u.isOpera&&!("KeyboardEvent"in window)?(n=null,g(e,"keydown",function(e){n=e.keyCode},t),g(e,"keypress",function(e){return m(i,e,n)},t)):(r=null,g(e,"keydown",function(e){s[e.keyCode]=(s[e.keyCode]||0)+1;var t=m(i,e,e.keyCode);return r=e.defaultPrevented,t},t),g(e,"keypress",function(e){r&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(d.stopEvent(e),r=null)},t),g(e,"keyup",function(e){s[e.keyCode]=null},t),s||(f(),g(window,"focus",f)))},"object"==typeof window&&window.postMessage&&!u.isOldIE&&(p=1,d.nextTick=function(t,i){i=i||window;function n(e){e.data==r&&(d.stopPropagation(e),l(i,"message",n),t())}var r="zero-timeout-message-"+p++;g(i,"message",n),i.postMessage(r,"*")}),d.$idleBlocked=!1,d.onIdle=function(t,e){return setTimeout(function e(){d.$idleBlocked?setTimeout(e,100):t()},e)},d.$idleBlockId=null,d.blockIdle=function(e){d.$idleBlockId&&clearTimeout(d.$idleBlockId),d.$idleBlocked=!0,d.$idleBlockId=setTimeout(function(){d.$idleBlocked=!1},e||100)},d.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),d.nextFrame?d.nextFrame=d.nextFrame.bind(window):d.nextFrame=function(e){setTimeout(e,17)}}),ace.define("ace/range",["require","exports","module"],function(e,t,i){"use strict";function o(e,t,i,n){this.start={row:e,column:t},this.end={row:i,column:n}}!function(){this.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(e,t){return 0==this.compare(e,t)},this.compareRange=function(e){var t=e.end,e=e.start,t=this.compare(t.row,t.column);return 1==t?1==(t=this.compare(e.row,e.column))?2:0==t?1:0:-1==t?-2:-1==(t=this.compare(e.row,e.column))?-1:1==t?42:0},this.comparePoint=function(e){return this.compare(e.row,e.column)},this.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},this.intersects=function(e){e=this.compareRange(e);return-1==e||0==e||1==e},this.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},this.isStart=function(e,t){return this.start.row==e&&this.start.column==t},this.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},this.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},this.inside=function(e,t){return 0==this.compare(e,t)&&(!this.isEnd(e,t)&&!this.isStart(e,t))},this.insideStart=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)},this.insideEnd=function(e,t){return 0==this.compare(e,t)&&!this.isStart(e,t)},this.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row!==e||t<=this.end.column?0:1:t<this.start.column?-1:t>this.end.column?1:0},this.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},this.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.clipRows=function(e,t){var i,n;return this.end.row>t?i={row:t+1,column:0}:this.end.row<e&&(i={row:e,column:0}),this.start.row>t?n={row:t+1,column:0}:this.start.row<e&&(n={row:e,column:0}),o.fromPoints(n||this.start,i||this.end)},this.extend=function(e,t){var i,n,r=this.compare(e,t);return 0==r?this:(-1==r?i={row:e,column:t}:n={row:e,column:t},o.fromPoints(i||this.start,n||this.end))},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return o.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new o(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new o(this.start.row,0,this.end.row,0)},this.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),e=e.documentToScreenPosition(this.end);return new o(t.row,t.column,e.row,e.column)},this.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t}}.call(o.prototype),o.fromPoints=function(e,t){return new o(e.row,e.column,t.row,t.column)},o.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},o.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=o}),ace.define("ace/lib/lang",["require","exports","module"],function(e,t,i){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var i="";0<t;)1&t&&(i+=e),(t>>=1)&&(e+=e);return i};var n=/^\s\s*/,r=/\s\s*$/;t.stringTrimLeft=function(e){return e.replace(n,"")},t.stringTrimRight=function(e){return e.replace(r,"")},t.copyObject=function(e){var t,i={};for(t in e)i[t]=e[t];return i},t.copyArray=function(e){for(var t=[],i=0,n=e.length;i<n;i++)e[i]&&"object"==typeof e[i]?t[i]=this.copyObject(e[i]):t[i]=e[i];return t},t.deepCopy=function e(t){if("object"!=typeof t||!t)return t;if(Array.isArray(t)){for(var i=[],n=0;n<t.length;n++)i[n]=e(t[n]);return i}if("[object Object]"!==Object.prototype.toString.call(t))return t;for(n in i={},t)i[n]=e(t[n]);return i},t.arrayToMap=function(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=1;return t},t.createMap=function(e){var t,i=Object.create(null);for(t in e)i[t]=e[t];return i},t.arrayRemove=function(e,t){for(var i=0;i<=e.length;i++)t===e[i]&&e.splice(i,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return(""+e).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var i=[];return e.replace(t,function(e){i.push({offset:arguments[arguments.length-2],length:e.length})}),i},t.deferredCall=function(e){function t(){n=null,e()}function i(e){return i.cancel(),n=setTimeout(t,e||0),i}var n=null;return(i.schedule=i).call=function(){return this.cancel(),e(),i},i.cancel=function(){return clearTimeout(n),n=null,i},i.isPending=function(){return n},i},t.delayedCall=function(e,t){function i(){r=null,e()}function n(e){null==r&&(r=setTimeout(i,e||t))}var r=null;return n.delay=function(e){r&&clearTimeout(r),r=setTimeout(i,e||t)},(n.schedule=n).call=function(){this.cancel(),e()},n.cancel=function(){r&&clearTimeout(r),r=null},n.isPending=function(){return r},n}}),ace.define("ace/clipboard",["require","exports","module"],function(e,t,i){"use strict";var n;i.exports={lineMode:!1,pasteCancelled:function(){return!!(n&&n>Date.now()-50)||(n=!1)},cancel:function(){n=Date.now()}}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/clipboard","ace/lib/keys"],function(e,t,i){"use strict";var F=e("../lib/event"),H=e("../lib/useragent"),V=e("../lib/dom"),Z=e("../lib/lang"),j=e("../clipboard"),z=H.isChrome<18,X=H.isIE,J=63<H.isChrome,M=e("../lib/keys"),O=M.KEY_MODS,D=H.isIOS,Y=D?/\s/:/\n/,K=H.isMobile;t.TextInput=function(e,d){var u=V.createElement("textarea"),o=(u.className="ace_text-input",u.setAttribute("wrap","off"),u.setAttribute("autocorrect","off"),u.setAttribute("autocapitalize","off"),u.setAttribute("spellcheck",!1),u.style.opacity="0",e.insertBefore(u,e.firstChild),!1),C=!1,s=!1,I=!1,a="",v=(K||(u.style.fontSize="1px"),!1),t=!1,g="",p=0,m=0,A=0;try{var l=document.activeElement===u}catch(e){}F.addListener(u,"blur",function(e){t||(d.onBlur(e),l=!1)},d),F.addListener(u,"focus",function(e){if(!t){if(l=!0,H.isEdge)try{if(!document.hasFocus())return}catch(e){}d.onFocus(e),H.isEdge?setTimeout(f):f()}},d),this.$focusScroll=!1,this.focus=function(){if(a||J||"browser"==this.$focusScroll)return u.focus({preventScroll:!0});var e=u.style.top;u.style.position="fixed",u.style.top="0px";try{var t=0!=u.getBoundingClientRect().top}catch(e){return}var i=[];if(t)for(var n=u.parentElement;n&&1==n.nodeType;)i.push(n),n.setAttribute("ace_nocontext",!0),n=!n.parentElement&&n.getRootNode?n.getRootNode().host:n.parentElement;u.focus({preventScroll:!0}),t&&i.forEach(function(e){e.removeAttribute("ace_nocontext")}),setTimeout(function(){u.style.position="","0px"==u.style.top&&(u.style.top=e)},0)},this.blur=function(){u.blur()},this.isFocused=function(){return l},d.on("beforeEndOperation",function(){var e=d.curOp,t=e&&e.command&&e.command.name;"insertstring"!=t&&(t=t&&(e.docChanged||e.selectionChanged),s&&t&&(g=u.value="",E()),f())});function i(e){x(e,!0)}function n(e){x(e,!1)}function r(e){var t=S(e);j.pasteCancelled()||("string"==typeof t?(t&&d.onPaste(t,e),H.isIE&&setTimeout(f),F.preventDefault(e)):(u.value="",C=!0))}var f=D?function(e){var t;!l||o&&!e||I||((t="\n ab"+(e=e||"")+"cde fg\n")!=u.value&&(u.value=g=t),t=4+(e.length||(d.selection.isEmpty()?0:1)),4==p&&m==t||u.setSelectionRange(4,t),p=4,m=t)}:function(){if(!s&&!I&&(l||b)){s=!0;var e,t,i=0,n=0,r="",o=(d.session&&(o=(e=d.selection).getRange(),e=e.cursor.row,i=o.start.column,n=o.end.column,r=d.session.getLine(e),o.start.row!=e?(t=d.session.getLine(e-1),i=o.start.row<e-1?0:i,n+=t.length+1,r=t+"\n"+r):o.end.row!=e?(t=d.session.getLine(e+1),n=o.end.row>e+1?t.length:n,n+=r.length+1,r=r+"\n"+t):K&&0<e&&(r="\n"+r,n+=1,i+=1),400<r.length&&(i<400&&n<400?r=r.slice(0,400):(r="\n",i==n?i=n=0:(i=0,n=1)))),r+"\n\n");if(o!=g&&(u.value=g=o,p=m=o.length),b&&(p=u.selectionStart,m=u.selectionEnd),m!=n||p!=i||u.selectionEnd!=m)try{u.setSelectionRange(i,n),p=i,m=n}catch(e){}s=!1}},c=(this.resetSelection=f,l&&d.onFocus(),function(e){return 0===e.selectionStart&&e.selectionEnd>=g.length&&e.value===g&&g&&e.selectionEnd!==m}),h=null,b=(this.setInputHandler=function(e){h=e},!(this.getInputHandler=function(){return h})),y=function(e,h){if(b=b&&!1,C)return f(),e&&d.onPaste(e),C=!1,"";for(var t=u.selectionStart,i=u.selectionEnd,n=p,r=g.length-m,o=e,s=e.length-t,a=e.length-i,l=0;0<n&&g[l]==e[l];)l++,n--;for(o=o.slice(l),l=1;0<r&&g.length-l>p-1&&g[g.length-l]==e[e.length-l];)l++,r--;s-=l-1,a-=l-1;var c=o.length-l+1;if(c<0&&(n=-c,c=0),o=o.slice(0,c),!(h||o||s||n||r||a))return"";c=!(I=!0);return H.isAndroid&&". "==o&&(o="  ",c=!0),o&&!n&&!r&&!s&&!a||v?d.onTextInput(o):d.onTextInput(o,{extendLeft:n,extendRight:r,restoreStart:s,restoreEnd:a}),I=!1,g=e,p=t,m=i,A=a,c?"\n":o},w=function(e){if(s)return k();if(e&&e.inputType){if("historyUndo"==e.inputType)return d.execCommand("undo");if("historyRedo"==e.inputType)return d.execCommand("redo")}var e=u.value,t=y(e,!0);(500<e.length||Y.test(t)||K&&p<1&&p==m)&&f()},S=function(e,t,i){var n=e.clipboardData||window.clipboardData;if(n&&!z){var r=X||i?"Text":"text/plain";try{return t?!1!==n.setData(r,t):n.getData(r)}catch(e){if(!i)return S(e,t,!0)}}},x=function(e,t){var i=d.getCopyText();if(!i)return F.preventDefault(e);S(e,i)?(D&&(f(i),o=i,setTimeout(function(){o=!1},10)),t?d.onCut():d.onCopy(),F.preventDefault(e)):(o=!0,u.value=i,u.select(),setTimeout(function(){o=!1,f(),t?d.onCut():d.onCopy()}))},k=(F.addCommandKeyListener(u,d.onCommandKey.bind(d),d),F.addListener(u,"select",function(e){s||(o?o=!1:c(u)?(d.selectAll(),f()):K&&u.selectionStart!=p&&f())},d),F.addListener(u,"input",w,d),F.addListener(u,"cut",i,d),F.addListener(u,"copy",n,d),F.addListener(u,"paste",r,d),"oncut"in u&&"oncopy"in u&&"onpaste"in u||F.addListener(e,"keydown",function(e){if((!H.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:n(e);break;case 86:r(e);break;case 88:i(e)}},d),function(){var e;if(s&&d.onCompositionUpdate&&!d.$readOnly)return v?R():void(s.useTextareaForIME?d.onCompositionUpdate(u.value):(e=u.value,y(e),s.markerRange&&(s.context&&(s.markerRange.start.column=s.selectionStart=s.context.compositionStartOffset),s.markerRange.end.column=s.markerRange.start.column+m-s.selectionStart+A)))}),E=function(e){d.onCompositionEnd&&!d.$readOnly&&(s=!1,d.onCompositionEnd(),d.off("mousedown",R),e&&w())};function R(){t=!0,u.blur(),u.focus(),t=!1}var T,_=Z.delayedCall(k,50).schedule.bind(null,null);function $(){clearTimeout(T),T=setTimeout(function(){a&&(u.style.cssText=a,a=""),d.renderer.$isMousePressed=!1,d.renderer.$keepTextAreaAtCursor&&d.renderer.$moveTextAreaToCursor()},0)}F.addListener(u,"compositionstart",function(e){s||!d.onCompositionStart||d.$readOnly||(s={},v||(e.data&&(s.useTextareaForIME=!1),setTimeout(k,0),d._signal("compositionStart"),d.on("mousedown",R),(e=d.getSelectionRange()).end.row=e.start.row,e.end.column=e.start.column,s.markerRange=e,s.selectionStart=p,d.onCompositionStart(s),s.useTextareaForIME?(g=u.value="",m=p=0):(u.msGetInputContext&&(s.context=u.msGetInputContext()),u.getInputContext&&(s.context=u.getInputContext()))))},d),F.addListener(u,"compositionupdate",k,d),F.addListener(u,"keyup",function(e){27==e.keyCode&&u.value.length<u.selectionStart&&(s||(g=u.value),p=m=-1,f()),_()},d),F.addListener(u,"keydown",_,d),F.addListener(u,"compositionend",E,d),this.getElement=function(){return u},this.setCommandMode=function(e){v=e,u.readOnly=!1},this.setReadOnly=function(e){v||(u.readOnly=e)},this.setCopyWithEmptySelection=function(e){},this.onContextMenu=function(e){b=!0,f(),d._emit("nativecontextmenu",{target:d,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,t){a=a||u.style.cssText,u.style.cssText=(t?"z-index:100000;":"")+(H.isIE?"opacity:0.1;":"")+"text-indent: -"+(p+m)*d.renderer.characterWidth*.5+"px;";function i(e){V.translate(u,e.clientX-o-2,Math.min(e.clientY-r-2,s))}var t=d.container.getBoundingClientRect(),n=V.computedStyle(d.container),r=t.top+(parseInt(n.borderTopWidth)||0),o=t.left+(parseInt(t.borderLeftWidth)||0),s=t.bottom-r-u.clientHeight-2;i(e),"mousedown"==e.type&&(d.renderer.$isMousePressed=!0,clearTimeout(T),H.isWin&&F.capture(d.container,i,$))},this.onContextMenuClose=$;function L(e){d.textInput.onContextMenu(e),$()}if(F.addListener(u,"mouseup",L,d),F.addListener(u,"mousedown",function(e){e.preventDefault(),$()},d),F.addListener(d.renderer.scroller,"contextmenu",L,d),F.addListener(u,"contextmenu",L,d),D){var B=d,W=u;function N(e){var t,i,n,r;document.activeElement===W&&(P||s||B.$mouseHandler.isMousePressed||o||(t=W.selectionStart,i=W.selectionEnd,n=null,(r=0)==t?n=M.up:1==t?n=M.home:m<i&&"\n"==g[i]?n=M.end:t<p&&" "==g[t-1]?(n=M.left,r=O.option):t<p||t==p&&m!=p&&t==i?n=M.left:m<i&&2<g.slice(0,i).split("\n").length?n=M.down:m<i&&" "==g[i-1]?(n=M.right,r=O.option):(m<i||i==m&&m!=p&&t==i)&&(n=M.right),t!==i&&(r|=O.shift),n&&(!B.onCommandKey({},r,n)&&B.commands&&(n=M.keyCodeToString(n),(r=B.commands.findKeyCommand(r,n))&&B.execCommand(r)),p=t,m=i,f(""))))}var G=null,P=!1;W.addEventListener("keydown",function(e){G&&clearTimeout(G),P=!0},!0),W.addEventListener("keyup",function(e){G=setTimeout(function(){P=!1},100)},!0),document.addEventListener("selectionchange",N),B.on("destroy",function(){document.removeEventListener("selectionchange",N)})}},t.$setUserAgentForTests=function(e,t){K=e,D=t}}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],function(e,t,i){"use strict";var o=e("../lib/useragent");function n(t){t.$clickSelection=null;var e=t.editor;e.setDefaultHandler("mousedown",this.onMouseDown.bind(t)),e.setDefaultHandler("dblclick",this.onDoubleClick.bind(t)),e.setDefaultHandler("tripleclick",this.onTripleClick.bind(t)),e.setDefaultHandler("quadclick",this.onQuadClick.bind(t)),e.setDefaultHandler("mousewheel",this.onMouseWheel.bind(t));["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(e){t[e]=this[e]},this),t.selectByLines=this.extendSelectionBy.bind(t,"getLineRange"),t.selectByWords=this.extendSelectionBy.bind(t,"getWordRange")}function s(e,t){return(e.start.row==e.end.row?2*t.column-e.start.column-e.end.column:e.start.row!=e.end.row-1||e.start.column||e.end.column?2*t.row-e.start.row-e.end.row:t.column-4)<0?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}!function(){this.onMouseDown=function(e){var t=e.inSelection(),i=e.getDocumentPosition(),n=(this.mousedownEvent=e,this.editor),r=e.getButton();return 0!==r?(!n.getSelectionRange().isEmpty()&&1!=r||n.selection.moveToPosition(i),void(2==r&&(n.textInput.onContextMenu(e.domEvent),o.isMozilla||e.preventDefault()))):(this.mousedownEvent.time=Date.now(),!t||n.isFocused()||(n.focus(),!this.$focusTimeout||this.$clickSelection||n.inMultiSelectMode)?(this.captureMouse(e),this.startSelect(i,1<e.domEvent._clicks),e.preventDefault()):(this.setState("focusWait"),void this.captureMouse(e)))},this.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var i=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?i.selection.selectToPosition(e):t||i.selection.moveToPosition(e),t||this.select(),i.renderer.scroller.setCapture&&i.renderer.scroller.setCapture(),i.setStyle("ace_selecting"),this.setState("select"))},this.select=function(){var e,t=this.editor,i=t.renderer.screenToTextCoordinates(this.x,this.y);this.$clickSelection&&(e=-1==(e=this.$clickSelection.comparePoint(i))?this.$clickSelection.end:1==e?this.$clickSelection.start:(i=(e=s(this.$clickSelection,i)).cursor,e.anchor),t.selection.setSelectionAnchor(e.row,e.column)),t.selection.selectToPosition(i),t.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(e){var t,i,n,r=this.editor,o=r.renderer.screenToTextCoordinates(this.x,this.y),e=r.selection[e](o.row,o.column);this.$clickSelection&&(i=this.$clickSelection.comparePoint(e.start),t=this.$clickSelection.comparePoint(e.end),-1==i&&t<=0?(n=this.$clickSelection.end,e.end.row==o.row&&e.end.column==o.column||(o=e.start)):1==t&&0<=i?(n=this.$clickSelection.start,e.start.row==o.row&&e.start.column==o.column||(o=e.end)):n=-1==i&&1==t?(o=e.end,e.start):(o=(i=s(this.$clickSelection,o)).cursor,i.anchor),r.selection.setSelectionAnchor(n.row,n.column)),r.selection.selectToPosition(o),r.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){n=this.mousedownEvent.x,e=this.mousedownEvent.y,i=this.x,t=this.y;var e,t,i=Math.sqrt(Math.pow(i-n,2)+Math.pow(t-e,2)),n=Date.now();(0<i||n-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(e){var e=e.getDocumentPosition(),t=this.editor,i=t.session.getBracketRange(e);i?(i.isEmpty()&&(i.start.column--,i.end.column++),this.setState("select")):(i=t.selection.getWordRange(e.row,e.column),this.setState("selectByWords")),this.$clickSelection=i,this.select()},this.onTripleClick=function(e){var e=e.getDocumentPosition(),t=this.editor,i=(this.setState("selectByLines"),t.getSelectionRange());i.isMultiLine()&&i.contains(e.row,e.column)?(this.$clickSelection=t.selection.getLineRange(i.start.row),this.$clickSelection.end=t.selection.getLineRange(i.end.row).end):this.$clickSelection=t.selection.getLineRange(e.row),this.select()},this.onQuadClick=function(e){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(e){var t,i,n,r,o,s,a;if(!e.getAccelKey())return e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0),t=this.editor,this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0}),i=this.$lastScroll,n=e.domEvent.timeStamp,s=n-i.t,r=s?e.wheelX/s:i.vx,o=s?e.wheelY/s:i.vy,s<550&&(r=(r+i.vx)/2,o=(o+i.vy)/2),s=Math.abs(r/o),a=!1,1<=s&&t.renderer.isScrollableBy(e.wheelX*e.speed,0)&&(a=!0),(a=s<=1&&t.renderer.isScrollableBy(0,e.wheelY*e.speed)?!0:a)?i.allowed=n:n-i.allowed<550&&(Math.abs(r)<=1.5*Math.abs(i.vx)&&Math.abs(o)<=1.5*Math.abs(i.vy)?(a=!0,i.allowed=n):i.allowed=0),i.t=n,i.vx=r,i.vy=o,a?(t.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0}}.call(n.prototype),t.DefaultHandlers=n}),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],function(e,t,i){"use strict";e("./lib/oop");var n=e("./lib/dom");function r(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}!function(){this.$init=function(){return this.$element=n.createElement("div"),this.$element.className="ace_tooltip",this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(e){this.getElement().textContent=e},this.setHtml=function(e){this.getElement().innerHTML=e},this.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},this.setClassName=function(e){n.addCssClass(this.getElement(),e)},this.show=function(e,t,i){null!=e&&this.setText(e),null!=t&&null!=i&&this.setPosition(t,i),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth},this.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}.call(r.prototype),t.Tooltip=r}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],function(e,t,i){"use strict";var d=e("../lib/dom"),n=e("../lib/oop"),u=e("../lib/event"),s=e("../tooltip").Tooltip;function g(e){s.call(this,e)}n.inherits(g,s),function(){this.setPosition=function(e,t){var i=window.innerWidth||document.documentElement.clientWidth,n=window.innerHeight||document.documentElement.clientHeight,r=this.getWidth(),o=this.getHeight();i<(e+=15)+r&&(e-=e+r-i),n<(t+=15)+o&&(t-=20+o),s.prototype.setPosition.call(this,e,t)}}.call(g.prototype),t.GutterHandler=function(n){var i,r,o,s=n.editor,a=s.renderer.$gutterLayer,l=new g(s.container);function c(){i=i&&clearTimeout(i),o&&(l.hide(),o=null,s._signal("hideGutterTooltip",l),s.off("mousewheel",c))}function h(e){l.setPosition(e.x,e.y)}n.editor.setDefaultHandler("guttermousedown",function(e){if(s.isFocused()&&0==e.getButton()&&"foldWidgets"!=a.getRegion(e)){var t=e.getDocumentPosition().row,i=s.session.selection;if(e.getShiftKey())i.selectTo(t,0);else{if(2==e.domEvent.detail)return s.selectAll(),e.preventDefault();n.$clickSelection=s.selection.getLineRange(t)}return n.setState("selectByLines"),n.captureMouse(e),e.preventDefault()}}),n.editor.setDefaultHandler("guttermousemove",function(e){var t=e.domEvent.target||e.domEvent.srcElement;if(d.hasCssClass(t,"ace_fold-widget"))return c();o&&n.$tooltipFollowsMouse&&h(e),r=e,i=i||setTimeout(function(){i=null,(r&&!n.isMousePressed?function(){var e=r.getDocumentPosition().row,t=a.$annotations[e];if(!t)return c();if(e==s.session.getLength()){var e=s.renderer.pixelToScreenCoordinates(0,r.y).row,i=r.$pos;if(e>s.session.documentToScreenRow(i.row,i.column))return c()}o!=t&&(o=t.text.join("<br/>"),l.setHtml(o),l.show(),s._signal("showGutterTooltip",l),s.on("mousewheel",c),n.$tooltipFollowsMouse?h(r):(e=r.domEvent.target.getBoundingClientRect(),(i=l.getElement().style).left=e.right+"px",i.top=e.bottom+"px"))}:c)()},50)}),u.addListener(s.renderer.$gutter,"mouseout",function(e){r=null,o&&!i&&(i=setTimeout(function(){i=null,c()},50))},s),s.on("changeSession",c)}}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("../lib/event"),r=e("../lib/useragent"),e=t.MouseEvent=function(e,t){this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};!function(){this.stopPropagation=function(){n.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){n.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY),this.$pos)},this.inSelection=function(){if(null!==this.$inSelection)return this.$inSelection;var e,t=this.editor.getSelectionRange();return t.isEmpty()?this.$inSelection=!1:(e=this.getDocumentPosition(),this.$inSelection=t.contains(e.row,e.column)),this.$inSelection},this.getButton=function(){return n.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=r.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}.call(e.prototype)}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var w=e("../lib/dom"),S=e("../lib/event"),x=e("../lib/useragent");function n(t){var i,c,h,e,n,d,r,s,p,u,m,g=t.editor,a=w.createElement("div"),o=(a.style.cssText="top:-100px;position:absolute;z-index:2147483647;opacity:0.5",a.textContent=" ",["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(e){t[e]=this[e]},this),g.on("mousedown",this.onMouseDown.bind(t)),g.container),l=0;function f(){var e,t,i,n,r,o,s,a,l=d;d=g.renderer.screenToTextCoordinates(c,h),i=d,t=l,n=Date.now(),e=!t||i.row!=t.row,t=!t||i.column!=t.column,!u||e||t?(g.moveCursorToPosition(i),u=n,m={x:c,y:h}):5<k(m.x,m.y,c,h)?u=null:200<=n-u&&(g.renderer.scrollCursorIntoView(),u=null),e=d,t=l,i=Date.now(),n=g.renderer.layerConfig.lineHeight,l=g.renderer.layerConfig.characterWidth,r=g.renderer.scroller.getBoundingClientRect(),r={x:{left:c-r.left,right:r.right-c},y:{top:h-r.top,bottom:r.bottom-h}},o=Math.min(r.x.left,r.x.right),s=Math.min(r.y.top,r.y.bottom),a={row:e.row,column:e.column},o/l<=2&&(a.column+=r.x.left<r.x.right?-3:2),s/n<=1&&(a.row+=r.y.top<r.y.bottom?-1:1),o=e.row!=a.row,l=e.column!=a.column,s=!t||e.row!=t.row,o||l&&!s?p?200<=i-p&&g.renderer.scrollCursorIntoView(a):p=i:p=null}function C(){n=g.selection.toOrientedRange(),i=g.session.addMarker(n,"ace_selection",g.getSelectionStyle()),g.clearSelection(),g.isFocused()&&g.renderer.$cursorLayer.setBlinking(!1),clearInterval(e),f(),e=setInterval(f,20),l=0,S.addListener(document,"mousemove",A)}function I(){clearInterval(e),g.session.removeMarker(i),i=null,g.selection.fromOrientedRange(n),g.isFocused()&&!s&&g.$resetCursorStyle(),l=0,u=p=d=n=null,S.removeListener(document,"mousemove",A)}this.onDragStart=function(e){var t;if(this.cancelDrag||!o.draggable)return t=this,setTimeout(function(){t.startSelect(),t.captureMouse(e)},0),e.preventDefault();n=g.getSelectionRange();var i=e.dataTransfer;i.effectAllowed=g.getReadOnly()?"copy":"copyMove",g.container.appendChild(a),i.setDragImage&&i.setDragImage(a,0,0),setTimeout(function(){g.container.removeChild(a)}),i.clearData(),i.setData("Text",g.session.getTextRange()),s=!0,this.setState("drag")},this.onDragEnd=function(e){o.draggable=!1,s=!1,this.setState(null),g.getReadOnly()||(e=e.dataTransfer.dropEffect,r||"move"!=e||g.session.remove(g.getSelectionRange()),g.$resetCursorStyle()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){if(!g.getReadOnly()&&b(e.dataTransfer))return c=e.clientX,h=e.clientY,i||C(),l++,e.dataTransfer.dropEffect=r=y(e),S.preventDefault(e)},this.onDragOver=function(e){if(!g.getReadOnly()&&b(e.dataTransfer))return c=e.clientX,h=e.clientY,i||(C(),l++),null!==v&&(v=null),e.dataTransfer.dropEffect=r=y(e),S.preventDefault(e)},this.onDragLeave=function(e){if(--l<=0&&i)return I(),r=null,S.preventDefault(e)},this.onDrop=function(e){if(d){var t=e.dataTransfer;if(s)switch(r){case"move":n=n.contains(d.row,d.column)?{start:d,end:d}:g.moveText(n,d);break;case"copy":n=g.moveText(n,d,!0)}else{t=t.getData("Text");n={start:d,end:g.session.insert(d,t)},g.focus(),r=null}return I(),S.preventDefault(e)}},S.addListener(o,"dragstart",this.onDragStart.bind(t),g),S.addListener(o,"dragend",this.onDragEnd.bind(t),g),S.addListener(o,"dragenter",this.onDragEnter.bind(t),g),S.addListener(o,"dragover",this.onDragOver.bind(t),g),S.addListener(o,"dragleave",this.onDragLeave.bind(t),g),S.addListener(o,"drop",this.onDrop.bind(t),g);var v=null;function A(){null==v&&(v=setTimeout(function(){null!=v&&i&&I()},20))}function b(e){e=e.types;return!e||Array.prototype.some.call(e,function(e){return"text/plain"==e||"Text"==e})}function y(e){var t=["copy","copymove","all","uninitialized"],i=x.isMac?e.altKey:e.ctrlKey,n="uninitialized";try{n=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var r="none";return i&&0<=t.indexOf(n)?r="copy":0<=["move","copymove","linkmove","all","uninitialized"].indexOf(n)?r="move":0<=t.indexOf(n)&&(r="copy"),r}}function k(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}!function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(e){this.editor.$resetCursorStyle(),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor,t=(e.container.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging"),x.isWin?"default":"move");e.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(e){var t=this.editor.container;x.isIE&&"dragReady"==this.state&&3<k(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&t.dragDrop(),"dragWait"===this.state&&0<k(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(e){var t,i,n;this.$dragEnabled&&(this.mousedownEvent=e,t=this.editor,i=e.inSelection(),n=e.getButton(),1===(e.domEvent.detail||1)&&0===n&&i&&(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey())||(this.mousedownEvent.time=Date.now(),"unselectable"in(n=e.domEvent.target||e.domEvent.srcElement)&&(n.unselectable="on"),t.getDragDelay()?(x.isWebKit&&(this.cancelDrag=!0,t.container.draggable=!0),this.setState("dragWait")):this.startDrag(),this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0)))}}.call(n.prototype),t.DragdropHandler=n}),ace.define("ace/mouse/touch_handler",["require","exports","module","ace/mouse/mouse_event","ace/lib/event","ace/lib/dom"],function(e,t,i){"use strict";var S=e("./mouse_event").MouseEvent,n=e("../lib/event"),a=e("../lib/dom");t.addTouchListeners=function(e,h){var C,I,v,A,d,t,u,b,o,g="scroll",p=0,y=0,m=0,f=0;function r(){function t(e){var t,i=e.target.getAttribute("action");if("more"==i||!r)return r=!r,e=h.getCopyText(),t=h.session.getUndoManager().hasUndo(),void o.replaceChild(a.buildDom(r?["span",!e&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],e&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],e&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],n&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],t&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPallete"},"Pallete"]]:["span"]),o.firstChild);"paste"==i?n.readText().then(function(e){h.execCommand(i,e)}):i&&("cut"!=i&&"copy"!=i||(n?n.writeText(h.getCopyText()):document.execCommand("copy")),h.execCommand(i)),o.firstChild.style.display="none",r=!1,"openCommandPallete"!=i&&h.focus()}var n=window.navigator&&window.navigator.clipboard,r=!1;o=a.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function(e){g="menu",e.stopPropagation(),e.preventDefault(),h.textInput.focus()},ontouchend:function(e){e.stopPropagation(),e.preventDefault(),t(e)},onclick:t},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],h.container)}function i(){o||r();var e=h.selection.cursor,e=h.renderer.textToScreenCoordinates(e.row,e.column),t=h.renderer.textToScreenCoordinates(0,0).pageX,i=h.renderer.scrollLeft,n=h.container.getBoundingClientRect();o.style.top=e.pageY-n.top-3+"px",e.pageX-n.left<n.width-70?(o.style.left="",o.style.right="10px"):(o.style.right="",o.style.left=t+i-n.left+"px"),o.style.display="",o.firstChild.style.display="none",h.on("input",s)}function s(e){o&&(o.style.display="none"),h.off("input",s)}function w(){d=null,clearTimeout(d);var e=h.selection.getRange(),t=e.contains(u.row,u.column);!e.isEmpty()&&t||(h.selection.moveToPosition(u),h.selection.selectWord()),g="wait",i()}n.addListener(e,"contextmenu",function(e){b&&h.textInput.getElement().focus()},h),n.addListener(e,"touchstart",function(e){var t=e.touches;if(d||1<t.length)return clearTimeout(d),d=null,v=-1,void(g="zoom");b=h.$mouseHandler.isMousePressed=!0;var i=h.renderer.layerConfig.lineHeight,n=h.renderer.layerConfig.lineHeight,r=e.timeStamp,o=(A=r,t[0]),s=o.clientX,o=o.clientY,s=(Math.abs(C-s)+Math.abs(I-o)>i&&(v=-1),C=e.clientX=s,I=e.clientY=o,m=f=0,new S(e,h));if(u=s.getDocumentPosition(),r-v<500&&1==t.length&&!p)y++,e.preventDefault(),e.button=0,d=null,clearTimeout(d),h.selection.moveToPosition(u),(o=2<=y?h.selection.getLineRange(u.row):h.session.getBracketRange(u))&&!o.isEmpty()?h.selection.setRange(o):h.selection.selectWord(),g="wait";else{y=0;var s=h.selection.cursor,t=h.selection.isEmpty()?s:h.selection.anchor,o=h.renderer.$cursorLayer.getPixelPosition(s,!0),s=h.renderer.$cursorLayer.getPixelPosition(t,!0),t=h.renderer.scroller.getBoundingClientRect(),a=h.renderer.layerConfig.offset,l=h.renderer.scrollLeft,c=function(e,t){return(e/=n)*e+(t=t/i-.75)*t};if(e.clientX<t.left)return void(g="zoom");o=c(e.clientX-t.left-o.left+l,e.clientY-t.top-o.top+a),c=c(e.clientX-t.left-s.left+l,e.clientY-t.top-s.top+a);o<3.5&&c<3.5&&(g=c<o?"cursor":"anchor"),g=c<3.5?"anchor":o<3.5?"cursor":"scroll",d=setTimeout(w,450)}v=r},h),n.addListener(e,"touchend",function(e){b=h.$mouseHandler.isMousePressed=!1,t&&clearInterval(t),"zoom"==g?(g="",p=0):d?(h.selection.moveToPosition(u),p=0,i()):"scroll"==g?(p+=60,t=setInterval(function(){p--<=0&&(clearInterval(t),t=null),Math.abs(m)<.01&&(m=0),Math.abs(f)<.01&&(f=0),p<20&&(m*=.9),p<20&&(f*=.9);var e=h.session.getScrollTop();h.renderer.scrollBy(10*m,10*f),e==h.session.getScrollTop()&&(p=0)},10),s()):i(),clearTimeout(d),d=null},h),n.addListener(e,"touchmove",function(e){d&&(clearTimeout(d),d=null);var t=e.touches;if(!(1<t.length||"zoom"==g)){var t=t[0],i=C-t.clientX,n=I-t.clientY;if("wait"==g){if(!(4<i*i+n*n))return e.preventDefault();g="cursor"}C=t.clientX,I=t.clientY,e.clientX=t.clientX,e.clientY=t.clientY;var t=e.timeStamp,r=t-A;A=t,"scroll"==g?((t=new S(e,h)).speed=1,t.wheelX=i,t.wheelY=n,10*Math.abs(i)<Math.abs(n)&&(i=0),10*Math.abs(n)<Math.abs(i)&&(n=0),0!=r&&(m=i/r,f=n/r),h._emit("mousewheel",t),t.propagationStopped||(m=f=0)):(i=new S(e,h).getDocumentPosition(),"cursor"==g?h.selection.moveCursorToPosition(i):"anchor"==g&&h.selection.setSelectionAnchor(i.row,i.column),h.renderer.scrollCursorIntoView(i),e.preventDefault())}},h)}}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var r=e("./dom");t.get=function(e,t){var i=new XMLHttpRequest;i.open("GET",e,!0),i.onreadystatechange=function(){4===i.readyState&&t(i.responseText)},i.send(null)},t.loadScript=function(e,i){var t=r.getDocumentHead(),n=document.createElement("script");n.src=e,t.appendChild(n),n.onload=n.onreadystatechange=function(e,t){!t&&n.readyState&&"loaded"!=n.readyState&&"complete"!=n.readyState||(n=n.onload=n.onreadystatechange=null,t||i())}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(e,t,i){"use strict";function o(){this.propagationStopped=!0}function s(){this.defaultPrevented=!0}var n={};n._emit=n._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var i=this._eventRegistry[e]||[],n=this._defaultHandlers[e];if(i.length||n){(t="object"!=typeof t||!t?{}:t).type||(t.type=e),t.stopPropagation||(t.stopPropagation=o),t.preventDefault||(t.preventDefault=s);for(var i=i.slice(),r=0;r<i.length&&(i[r](t,this),!t.propagationStopped);r++);return n&&!t.defaultPrevented?n(t,this):void 0}},n._signal=function(e,t){if(i=(this._eventRegistry||{})[e])for(var i=i.slice(),n=0;n<i.length;n++)i[n](t,this)},n.once=function(t,i){var n=this;if(this.on(t,function e(){n.off(t,e),i.apply(null,arguments)}),!i)return new Promise(function(e){i=e})},n.setDefaultHandler=function(e,t){var i,n,r=this._defaultHandlers;(r=r||(this._defaultHandlers={_disabled_:{}}))[e]&&(n=r[e],(i=r._disabled_[e])||(r._disabled_[e]=i=[]),i.push(n),-1!=(n=i.indexOf(t))&&i.splice(n,1)),r[e]=t},n.removeDefaultHandler=function(e,t){var i,n=this._defaultHandlers;n&&(i=n._disabled_[e],n[e]==t?i&&this.setDefaultHandler(e,i.pop()):!i||-1!=(n=i.indexOf(t))&&i.splice(n,1))},n.on=n.addEventListener=function(e,t,i){this._eventRegistry=this._eventRegistry||{};var n=this._eventRegistry[e];return-1==(n=n||(this._eventRegistry[e]=[])).indexOf(t)&&n[i?"unshift":"push"](t),t},n.off=n.removeListener=n.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};e=this._eventRegistry[e];!e||-1!==(t=e.indexOf(t))&&e.splice(t,1)},n.removeAllListeners=function(e){e||(this._eventRegistry=this._defaultHandlers=void 0),this._eventRegistry&&(this._eventRegistry[e]=void 0),this._defaultHandlers&&(this._defaultHandlers[e]=void 0)},t.EventEmitter=n}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){var r=e("./oop"),n=e("./event_emitter").EventEmitter,o={setOptions:function(t){Object.keys(t).forEach(function(e){this.setOption(e,t[e])},this)},getOptions:function(e){var t,i={};return e?Array.isArray(e)||(i=e,e=Object.keys(i)):(t=this.$options,e=Object.keys(t).filter(function(e){return!t[e].hidden})),e.forEach(function(e){i[e]=this.getOption(e)},this),i},setOption:function(e,t){var i;if(this["$"+e]!==t)return i=this.$options[e],i?i.forwardTo?this[i.forwardTo]&&this[i.forwardTo].setOption(e,t):(i.handlesSet||(this["$"+e]=t),void(i&&i.set&&i.set.call(this,t))):s('misspelled option "'+e+'"')},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:s('misspelled option "'+e+'"')}};function s(e){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}function a(e,t){var i=new Error(e);i.data=t,"object"==typeof console&&console.error&&console.error(i),setTimeout(function(){throw i})}function l(){this.$defaultOptions={}}!function(){r.implement(this,n),this.defineOptions=function(i,e,n){return i.$options||(this.$defaultOptions[e]=i.$options={}),Object.keys(n).forEach(function(e){var t=n[e];(t="string"==typeof t?{forwardTo:t}:t).name||(t.name=e),"initialValue"in(i.$options[t.name]=t)&&(i["$"+t.name]=t.initialValue)}),r.implement(i,o),this},this.resetOptions=function(i){Object.keys(i.$options).forEach(function(e){var t=i.$options[e];"value"in t&&i.setOption(e,t.value)})},this.setDefaultValue=function(e,t,i){if(!e){for(e in this.$defaultOptions)if(this.$defaultOptions[e][t])break;if(!this.$defaultOptions[e][t])return!1}var n=this.$defaultOptions[e]||(this.$defaultOptions[e]={});n[t]&&(n.forwardTo?this.setDefaultValue(n.forwardTo,t,i):n[t].value=i)},this.setDefaultValues=function(t,i){Object.keys(i).forEach(function(e){this.setDefaultValue(t,e,i[e])},this)},this.warn=s,this.reportError=a}.call(l.prototype),t.AppConfig=l}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/dom","ace/lib/app_config"],function(u,g,p){var e=u("./lib/lang"),o=(u("./lib/oop"),u("./lib/net")),i=u("./lib/dom"),n=u("./lib/app_config").AppConfig,m=(p.exports=g=new n,function(){return this||"undefined"!=typeof window&&window}()),f={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1,useStrictCSP:null},s=(g.get=function(e){if(!f.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return f[e]},g.set=function(e,t){if(f.hasOwnProperty(e))f[e]=t;else if(0==this.setDefaultValue("",e,t))throw new Error("Unknown config key: "+e);"useStrictCSP"==e&&i.useStrictCSP(t)},g.all=function(){return e.copyObject(f)},g.$modes={},g.moduleUrl=function(e,t){if(f.$moduleUrls[e])return f.$moduleUrls[e];var e=e.split("/"),i="snippets"==(t=t||e[e.length-2]||"")?"/":"-",n=e[e.length-1],r=("worker"==t&&"-"==i&&(r=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g"),n=n.replace(r,"")),(!n||n==t)&&1<e.length&&(n=e[e.length-2]),f[t+"Path"]);return null==r?r=f.basePath:"/"==i&&(t=i=""),r&&"/"!=r.slice(-1)&&(r+="/"),r+t+i+n+this.get("suffix")},g.setModuleUrl=function(e,t){return f.$moduleUrls[e]=t},g.$loading={},g.loadModule=function(i,e){var t,n;Array.isArray(i)&&(n=i[0],i=i[1]);try{t=u(i)}catch(e){}if(t&&!g.$loading[i])return e&&e(t);if(g.$loading[i]||(g.$loading[i]=[]),g.$loading[i].push(e),!(1<g.$loading[i].length)){function r(){u([i],function(t){g._emit("load.module",{name:i,module:t});var e=g.$loading[i];g.$loading[i]=null,e.forEach(function(e){e&&e(t)})})}if(!g.get("packaged"))return r();o.loadScript(g.moduleUrl(i,n),r),s()}},function(){f.basePath||f.workerPath||f.modePath||f.themePath||Object.keys(f.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),s=function(){})});function t(e){if(m&&m.document){f.packaged=e||u.packaged||p.packaged||m.define&&C.amdD.packaged;for(var t,i={},n="",e=document.currentScript||document._currentScript,r=(e&&e.ownerDocument||document).getElementsByTagName("script"),o=0;o<r.length;o++){var s=r[o],a=s.src||s.getAttribute("src");if(a){for(var h=s.attributes,l=0,d=h.length;l<d;l++){var c=h[l];0===c.name.indexOf("data-ace-")&&(i[c.name.replace(/^data-ace-/,"").replace(/-(.)/g,function(e,t){return t.toUpperCase()})]=c.value)}s=a.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);s&&(n=s[1])}}for(t in n&&(i.base=i.base||n,i.packaged=!0),i.basePath=i.base,i.workerPath=i.workerPath||i.base,i.modePath=i.modePath||i.base,i.themePath=i.themePath||i.base,delete i.base,i)void 0!==i[t]&&g.set(t,i[t])}}t(!0),g.init=t,g.version="1.4.14"}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/mouse/touch_handler","ace/config"],function(e,t,n){"use strict";function i(n){function e(e){document.hasFocus&&document.hasFocus()&&(n.isFocused()||document.activeElement!=(n.textInput&&n.textInput.getElement()))||window.focus(),n.focus()}var r=this,t=(this.editor=n,new o(this),new s(this),new a(this),n.renderer.getMouseEventTarget()),i=(h.addListener(t,"click",this.onMouseEvent.bind(this,"click"),n),h.addListener(t,"mousemove",this.onMouseMove.bind(this,"mousemove"),n),h.addMultiMouseDownListener([t,n.renderer.scrollBarV&&n.renderer.scrollBarV.inner,n.renderer.scrollBarH&&n.renderer.scrollBarH.inner,n.textInput&&n.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent",n),h.addMouseWheelListener(n.container,this.onMouseWheel.bind(this,"mousewheel"),n),l(n.container,n),n.renderer.$gutter);h.addListener(i,"mousedown",this.onMouseEvent.bind(this,"guttermousedown"),n),h.addListener(i,"click",this.onMouseEvent.bind(this,"gutterclick"),n),h.addListener(i,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick"),n),h.addListener(i,"mousemove",this.onMouseEvent.bind(this,"guttermousemove"),n),h.addListener(t,"mousedown",e,n),h.addListener(i,"mousedown",e,n),d.isIE&&n.renderer.scrollBarV&&(h.addListener(n.renderer.scrollBarV.element,"mousedown",e,n),h.addListener(n.renderer.scrollBarH.element,"mousedown",e,n)),n.on("mousemove",function(e){var t,i;r.state||r.$dragDelay||!r.$dragEnabled||(e=n.renderer.screenToTextCoordinates(e.x,e.y),t=n.session.selection.getRange(),i=n.renderer,!t.isEmpty()&&t.insideStart(e.row,e.column)?i.setCursorStyle("default"):i.setCursorStyle(""))},n)}var h=e("../lib/event"),d=e("../lib/useragent"),o=e("./default_handlers").DefaultHandlers,s=e("./default_gutter_handler").GutterHandler,u=e("./mouse_event").MouseEvent,a=e("./dragdrop_handler").DragdropHandler,l=e("./touch_handler").addTouchListeners,e=e("../config");!function(){this.onMouseEvent=function(e,t){this.editor.session&&this.editor._emit(e,new u(t,this.editor))},this.onMouseMove=function(e,t){var i=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;i&&i.length&&this.editor._emit(e,new u(t,this.editor))},this.onMouseWheel=function(e,t){var i=new u(t,this.editor);i.speed=2*this.$scrollSpeed,i.wheelX=t.wheelX,i.wheelY=t.wheelY,this.editor._emit(e,i)},this.setState=function(e){this.state=e},this.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;function i(e){if(e){if(d.isWebKit&&!e.which&&a.releaseMouse)return a.releaseMouse();a.x=e.clientX,a.y=e.clientY,t&&t(e),a.mouseEvent=new u(e,a.editor),a.$mouseMoved=!0}}function n(e){o.off("beforeEndOperation",l),clearInterval(c),o.session&&r(),a[a.state+"End"]&&a[a.state+"End"](e),a.state="",a.isMousePressed=s.$isMousePressed=!1,s.$keepTextAreaAtCursor&&s.$moveTextAreaToCursor(),a.$onCaptureMouseMove=a.releaseMouse=null,e&&a.onMouseEvent("mouseup",e),o.endOperation()}function r(){a[a.state]&&a[a.state](),a.$mouseMoved=!1}var o=this.editor,s=this.editor.renderer,a=(s.$isMousePressed=!0,this);if(d.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout(function(){n(e)});var l=function(e){a.releaseMouse&&o.curOp.command.name&&o.curOp.selectionChanged&&(a[a.state+"End"]&&a[a.state+"End"](),a.state="",a.releaseMouse())},c=(o.on("beforeEndOperation",l),o.startOperation({command:{name:"mouse"}}),a.$onCaptureMouseMove=i,a.releaseMouse=h.capture(this.editor.container,i,n),setInterval(r,20))},this.releaseMouse=null,this.cancelContextMenu=function(){var t=function(e){e&&e.domEvent&&"contextmenu"!=e.domEvent.type||(this.editor.off("nativecontextmenu",t),e&&e.domEvent&&h.stopEvent(e.domEvent))}.bind(this);setTimeout(t,10),this.editor.on("nativecontextmenu",t)},this.destroy=function(){this.releaseMouse&&this.releaseMouse()}}.call(i.prototype),e.defineOptions(i.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:d.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=i}),ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var n=e("../lib/dom");t.FoldHandler=function(r){r.on("click",function(e){var t=e.getDocumentPosition(),i=r.session,t=i.getFoldAt(t.row,t.column,1),t=(t&&(e.getAccelKey()?i.removeFold(t):i.expandFold(t),e.stop()),e.domEvent&&e.domEvent.target);t&&n.hasCssClass(t,"ace_inline_button")&&n.hasCssClass(t,"ace_toggle_wrap")&&(i.setOption("wrap",!i.getUseWrapMode()),r.renderer.scrollCursorIntoView())}),r.on("gutterclick",function(e){var t,i;"foldWidgets"==r.renderer.$gutterLayer.getRegion(e)&&(t=e.getDocumentPosition().row,(i=r.session).foldWidgets&&i.foldWidgets[t]&&r.session.onFoldWidgetClick(t,e),r.isFocused()||r.focus(),e.stop())}),r.on("gutterdblclick",function(e){var t,i,n;"foldWidgets"==r.renderer.$gutterLayer.getRegion(e)&&(n=e.getDocumentPosition().row,(i=(i=(t=r.session).getParentFoldRangeData(n,!0)).range||i.firstRange)&&(n=i.start.row,(n=t.getFoldAt(n,t.getLine(n).length,1))?t.removeFold(n):(t.addFold("...",i),r.renderer.scrollCursorIntoView({row:i.start.row,column:0}))),e.stop())})}}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(e,t,i){"use strict";function n(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)}var r=e("../lib/keys"),l=e("../lib/event");!function(){this.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},this.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},this.addKeyboardHandler=function(e,t){var i;e&&("function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e),-1!=(i=this.$handlers.indexOf(e))&&this.$handlers.splice(i,1),null==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==i&&e.attach&&e.attach(this.$editor))},this.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1!=t&&(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var t=this.$data,i=t.editor;return this.$handlers.map(function(e){return e.getStatusText&&e.getStatusText(i,t)||""}).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(e,t,i,n){for(var r,o=!1,s=this.$editor.commands,a=this.$handlers.length;a--&&!((r=this.$handlers[a].handleKeyboard(this.$data,e,t,i,n))&&r.command&&((o="null"==r.command||s.exec(r.command,this.$editor,r.args,n))&&n&&-1!=e&&1!=r.passEvent&&1!=r.command.passEvent&&l.stopEvent(n),o)););return o||-1!=e||(r={command:"insertstring"},o=s.exec("insertstring",this.$editor,t)),o&&this.$editor._signal&&this.$editor._signal("keyboardActivity",r),o},this.onCommandKey=function(e,t,i){var n=r.keyCodeToString(i);return this.$callKeyboardHandlers(t,n,i,e)},this.onTextInput=function(e){return this.$callKeyboardHandlers(-1,e)}}.call(n.prototype),t.KeyBinding=n}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(e,l,t){"use strict";var w=0,S=0,p=!1,x=!1,k=!1,E=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],R=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],m=0,f=1,C=2,T=3,I=4,v=5,_=6,$=7,A=8,L=9,B=10,b=11,W=12,N=13,G=14,P=15,F=16,H=17,y=18,n=[y,y,y,y,y,y,y,y,y,_,v,_,A,v,y,y,y,y,y,y,y,y,y,y,y,y,y,y,v,v,v,_,A,I,I,b,b,b,I,I,I,I,I,B,L,B,L,L,C,C,C,C,C,C,C,
C,C,C,L,I,I,I,I,I,I,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,I,I,I,I,I,I,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,m,I,I,I,I,y,y,y,y,y,y,v,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,L,I,b,b,b,b,I,I,I,I,m,I,I,y,I,I,b,b,C,C,I,m,I,I,I,C,m,I,I,I,I,I],r=[A,A,A,A,A,A,A,A,A,A,A,y,y,y,m,f,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,A,v,N,G,P,F,H,L,b,b,b,b,b,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,L,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,I,A];function c(h,e,t,i){var d,n,r,u=w?R:E,o=0,s=-1,a=null,l=null,g=[];if(!i)for(a=0,i=[];a<t;a++)i[a]=V(h[a]);for(S=w,k=x=p=!1,l=0;l<t;l++){if(r=o,g[l]=d=function(e,t,i,n){var r,o,s,a=t[n];switch(a){case m:case f:p=!1;case I:case T:return a;case C:return p?T:C;case $:return p=!0,f;case A:return I;case L:return n<1||n+1>=t.length||(r=i[n-1])!=C&&r!=T||(l=t[n+1])!=C&&l!=T?I:(l=p?T:l)==r?l:I;case B:return(r=0<n?i[n-1]:v)==C&&n+1<t.length&&t[n+1]==C?C:I;case b:if(0<n&&i[n-1]==C)return C;if(p)return I;for(s=n+1,o=t.length;s<o&&t[s]==b;)s++;return s<o&&t[s]==C?C:I;case W:for(o=t.length,s=n+1;s<o&&t[s]==W;)s++;if(s<o){var l=e[n],l=1425<=l&&l<=2303||64286==l;if(r=t[s],l&&(r==f||r==$))return f}return n<1||(r=t[n-1])==v?I:i[n-1];case v:return x=!(p=!1),w;case _:return k=!0,I;case N:case G:case F:case H:case P:p=!1;case y:return I}}(h,i,g,l),r=240&(o=u[r][d]),o&=15,e[l]=n=u[o][5],0<r)if(16==r){for(a=s;a<l;a++)e[a]=1;s=-1}else s=-1;if(u[o][6])-1==s&&(s=l);else if(-1<s){for(a=s;a<l;a++)e[a]=n;s=-1}i[l]==v&&(e[l]=0),S|=n}if(k)for(a=0;a<t;a++)if(i[a]==_){e[a]=w;for(var c=a-1;0<=c&&i[c]==A;c--)e[c]=w}}function h(e,t,i){if(!(S<e))if(1!=e||1!=w||x)for(var n,r,o,s,a=i.length,l=0;l<a;){if(t[l]>=e){for(n=l+1;n<a&&t[n]>=e;)n++;for(r=l,o=n-1;r<o;r++,o--)s=i[r],i[r]=i[o],i[o]=s;l=n}l++}else i.reverse()}function V(e){var t=e.charCodeAt(0),i=t>>8;return 0==i?191<t?m:n[t]:5==i?/[\u0591-\u05f4]/.test(e)?f:m:6==i?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(e)?W:/[\u0660-\u0669\u066b-\u066c]/.test(e)?T:1642==t?b:/[\u06f0-\u06f9]/.test(e)?C:$:32==i&&t<=8287?r[255&t]:254==i&&65136<=t?$:I}l.L=m,l.R=f,l.EN=C,l.ON_R=3,l.AN=4,l.R_H=5,l.B=6,l.RLE=7,l.DOT="·",l.doBidiReorder=function(e,t,i){if(e.length<2)return{};var n=e.split(""),r=new Array(n.length),o=new Array(n.length),s=[];w=i?1:0,c(n,s,n.length,t);for(var a=0;a<r.length;r[a]=a,a++);h(2,s,r),h(1,s,r);for(a=0;a<r.length-1;a++)t[a]===T?s[a]=l.AN:s[a]===f&&(t[a]>$&&t[a]<N||t[a]===I||t[a]===y)?s[a]=l.ON_R:0<a&&"ل"===n[a-1]&&/\u0622|\u0623|\u0625|\u0627/.test(n[a])&&(s[a-1]=s[a]=l.R_H,a++);n[n.length-1]===l.DOT&&(s[n.length-1]=l.B),"‫"===n[0]&&(s[0]=l.RLE);for(a=0;a<r.length;a++)o[a]=s[r[a]];return{logicalFromVisual:r,bidiLevels:o}},l.hasBidiCharacters=function(e,t){for(var i=!1,n=0;n<e.length;n++)t[n]=V(e.charAt(n)),i||t[n]!=f&&t[n]!=$&&t[n]!=T||(i=!0);return i},l.getVisualFromLogicalIdx=function(e,t){for(var i=0;i<t.logicalFromVisual.length;i++)if(t.logicalFromVisual[i]==e)return i;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],function(e,t,i){"use strict";function n(e){this.session=e,this.bidiMap={},this.currentRow=null,this.bidiUtil=a,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.$isRtl=!1,this.line="",this.wrapIndent=0,this.EOF="¶",this.RLE="‫",this.contentWidth=0,this.fontMetrics=null,this.rtlLineOffset=0,this.wrapOffset=0,this.isMoveLeftOperation=!1,this.seenBidi=r.test(e.getValue())}var a=e("./lib/bidiutil"),s=e("./lib/lang"),r=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;!function(){this.isBidiRow=function(e,t,i){return!!this.seenBidi&&(e!==this.currentRow&&(this.currentRow=e,this.updateRowLine(t,i),this.updateBidiMap()),this.bidiMap.bidiLevels)},this.onChange=function(e){this.seenBidi?this.currentRow=null:"insert"==e.action&&r.test(e.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)},this.getDocumentRow=function(){var e=0,t=this.session.$screenRowCache;return!t.length||0<=(t=this.session.$getRowCacheIndex(t,this.currentRow))&&(e=this.session.$docRowCache[t]),e},this.getSplitIndex=function(){var e=0,t=this.session.$screenRowCache;if(t.length)for(var i,n=this.session.$getRowCacheIndex(t,this.currentRow);0<this.currentRow-e&&(i=this.session.$getRowCacheIndex(t,this.currentRow-e-1))===n;)n=i,e++;else e=this.currentRow;return e},this.updateRowLine=function(e,t){var i,n=(e=void 0===e?this.getDocumentRow():e)===this.session.getLength()-1?this.EOF:this.EOL,r=(this.wrapIndent=0,this.line=this.session.getLine(e),this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE,this.session.$useWrapMode?((e=this.session.$wrapData[e])&&(0<(t=void 0===t?this.getSplitIndex():t)&&e.length?(this.wrapIndent=e.indent,this.wrapOffset=this.wrapIndent*this.charWidths[a.L],this.line=t<e.length?this.line.substring(e[t-1],e[t]):this.line.substring(e[e.length-1])):this.line=this.line.substring(0,e[t])),t==e.length&&(this.line+=this.showInvisibles?n:a.DOT)):this.line+=this.showInvisibles?n:a.DOT,this.session),o=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(e,t){return"\t"===e||r.isFullWidth(e.charCodeAt(0))?(i="\t"===e?r.getScreenTabSize(t+o):2,o+=i-1,s.stringRepeat(a.DOT,i)):e}),this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==a.DOT?this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)},this.updateBidiMap=function(){var e=[];a.hasBidiCharacters(this.line,e)||this.isRtlDir?this.bidiMap=a.doBidiReorder(this.line,e,this.isRtlDir):this.bidiMap={}},this.markAsDirty=function(){this.currentRow=null},this.updateCharacterWidths=function(e){var t;this.characterWidth!==e.$characterSize.width&&(this.fontMetrics=e,t=this.characterWidth=e.$characterSize.width,e=e.$measureCharWidth("ה"),this.charWidths[a.L]=this.charWidths[a.EN]=this.charWidths[a.ON_R]=t,this.charWidths[a.R]=this.charWidths[a.AN]=e,this.charWidths[a.R_H]=.45*e,this.charWidths[a.B]=this.charWidths[a.RLE]=0,this.currentRow=null)},this.setShowInvisibles=function(e){this.showInvisibles=e,this.currentRow=null},this.setEolChar=function(e){this.EOL=e},this.setContentWidth=function(e){this.contentWidth=e},this.isRtlLine=function(e){return!!this.$isRtl||(null!=e?this.session.getLine(e).charAt(0)==this.RLE:this.isRtlDir)},this.setRtlDirection=function(e,t){for(var i=e.getCursorPosition(),n=e.selection.getSelectionAnchor().row;n<=i.row;n++)t||e.session.getLine(n).charAt(0)!==e.session.$bidiHandler.RLE?t&&e.session.getLine(n).charAt(0)!==e.session.$bidiHandler.RLE&&e.session.doc.insert({column:0,row:n},e.session.$bidiHandler.RLE):e.session.doc.removeInLine(n,0,1)},this.getPosLeft=function(e){e-=this.wrapIndent;var t=this.line.charAt(0)===this.RLE?1:0,i=t<e?this.session.getOverwrite()?e:e-1:t,n=a.getVisualFromLogicalIdx(i,this.bidiMap),r=this.bidiMap.bidiLevels,o=0;!this.session.getOverwrite()&&e<=t&&r[n]%2!=0&&n++;for(var s=0;s<n;s++)o+=this.charWidths[r[s]];return!this.session.getOverwrite()&&t<e&&r[n]%2==0&&(o+=this.charWidths[r[n]]),this.wrapIndent&&(o+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset),this.isRtlDir&&(o+=this.rtlLineOffset),o},this.getSelections=function(e,h){var d,u=this.bidiMap,t=u.bidiLevels,i=[],n=0,g=Math.min(e,h)-this.wrapIndent,p=Math.max(e,h)-this.wrapIndent,r=!1,o=!1,s=0;this.wrapIndent&&(n+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var a,l=0;l<t.length;l++)a=u.logicalFromVisual[l],d=t[l],(r=g<=a&&a<p)&&!o?s=n:!r&&o&&i.push({left:s,width:n-s}),n+=this.charWidths[d],o=r;if(r&&l===t.length&&i.push({left:s,width:n-s}),this.isRtlDir)for(var c=0;c<i.length;c++)i[c].left+=this.rtlLineOffset;return i},this.offsetToCol=function(e){this.isRtlDir&&(e-=this.rtlLineOffset);var t=0,e=Math.max(e,0),i=0,n=0,r=this.bidiMap.bidiLevels,o=this.charWidths[r[n]];for(this.wrapIndent&&(e-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);i+o/2<e;){if(i+=o,n===r.length-1){o=0;break}o=this.charWidths[r[++n]]}return 0===(t=0<n&&r[n-1]%2!=0&&r[n]%2==0?(e<i&&n--,this.bidiMap.logicalFromVisual[n]):0<n&&r[n-1]%2==0&&r[n]%2!=0?1+(i<e?this.bidiMap.logicalFromVisual[n]:this.bidiMap.logicalFromVisual[n-1]):this.isRtlDir&&n===r.length-1&&0===o&&r[n-1]%2==0||!this.isRtlDir&&0===n&&r[n]%2!=0?1+this.bidiMap.logicalFromVisual[n]:(0<n&&r[n-1]%2!=0&&0!==o&&n--,this.bidiMap.logicalFromVisual[n]))&&this.isRtlDir&&t++,t+this.wrapIndent}}.call(n.prototype),t.BidiHandler=n}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(e,t,i){"use strict";function n(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.cursor=this.lead=this.doc.createAnchor(0,0),this.anchor=this.doc.createAnchor(0,0),this.$silent=!1;var t=this;this.cursor.on("change",function(e){t.$cursorChanged=!0,t.$silent||t._emit("changeCursor"),t.$isEmpty||t.$silent||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)}),this.anchor.on("change",function(){t.$anchorChanged=!0,t.$isEmpty||t.$silent||t._emit("changeSelection")})}var r=e("./lib/oop"),o=e("./lib/lang"),s=e("./lib/event_emitter").EventEmitter,a=e("./range").Range;!function(){r.implement(this,s),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(e,t){this.$isEmpty=!1,this.anchor.setPosition(e,t)},this.getAnchor=this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},this.getRange=function(){var e=this.anchor,t=this.lead;return this.$isEmpty?a.fromPoints(t,t):this.isBackwards()?a.fromPoints(t,e):a.fromPoints(e,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)},this.setRange=this.setSelectionRange=function(e,t){var i=t?e.end:e.start,t=t?e.start:e.end;this.$setSelection(i.row,i.column,t.row,t.column)},this.$setSelection=function(e,t,i,n){var r,o;this.$silent||(r=this.$isEmpty,o=this.inMultiSelectMode,this.$silent=!0,this.$cursorChanged=this.$anchorChanged=!1,this.anchor.setPosition(e,t),this.cursor.setPosition(i,n),this.$isEmpty=!a.comparePoints(this.anchor,this.cursor),this.$silent=!1,this.$cursorChanged&&this._emit("changeCursor"),(this.$cursorChanged||this.$anchorChanged||r!=this.$isEmpty||o)&&this._emit("changeSelection"))},this.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},this.selectTo=function(e,t){this.$moveSelection(function(){this.moveCursorTo(e,t)})},this.selectToPosition=function(e){this.$moveSelection(function(){this.moveCursorToPosition(e)})},this.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},this.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(e,t){var i;return void 0===t&&(e=(i=e||this.lead).row,t=i.column),this.session.getWordRange(e,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var e=this.getCursor(),e=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(e)},this.getLineRange=function(e,t){var e="number"==typeof e?e:this.lead.row,i=this.session.getFoldLine(e),i=i?(e=i.start.row,i.end.row):e;return!0===t?new a(e,0,i,this.session.getLine(i).length):new a(e,0,i+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(e,t,i){var n=e.column,r=e.column+t;return i<0&&(n=e.column-t,r=e.column),this.session.isTabStop(e)&&this.doc.getLine(e.row).slice(n,r).split(" ").length-1==t},this.moveCursorLeft=function(){var e,t=this.lead.getPosition();(e=this.session.getFoldAt(t.row,t.column,-1))?this.moveCursorTo(e.start.row,e.start.column):0===t.column?0<t.row&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length):(e=this.session.getTabSize(),this.wouldMoveIntoSoftTab(t,e,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-e):this.moveCursorBy(0,-1))},this.moveCursorRight=function(){var e,t=this.lead.getPosition();(e=this.session.getFoldAt(t.row,t.column,1))?this.moveCursorTo(e.end.row,e.end.column):this.lead.column==this.doc.getLine(this.lead.row).length?this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0):(e=this.session.getTabSize(),t=this.lead,this.wouldMoveIntoSoftTab(t,e,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,e):this.moveCursorBy(0,1))},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,i=this.session.documentToScreenRow(e,t),i=this.session.screenToDocumentPosition(i,0),e=this.session.getDisplayLine(e,null,i.row,i.column).match(/^\s*/);e[0].length==t||this.session.$useEmacsStyleLineStart||(i.column+=e[0].length),this.moveCursorToPosition(i)},this.moveCursorLineEnd=function(){var e,t=this.lead,t=this.session.getDocumentLastRowColumnPosition(t.row,t.column);this.lead.column==t.column&&(e=this.session.getLine(t.row),t.column!=e.length||0<(e=e.search(/\s+$/))&&(t.column=e)),this.moveCursorTo(t.row,t.column)},this.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t),r=(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.getFoldAt(e,t,1));if(r)this.moveCursorTo(r.end.row,r.end.column);else{if(this.session.nonTokenRe.exec(n)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,n=i.substring(t)),t>=i.length)return this.moveCursorTo(e,i.length),this.moveCursorRight(),void(e<this.doc.getLength()-1&&this.moveCursorWordRight());this.session.tokenRe.exec(n)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(e,t)}},this.moveCursorLongWordLeft=function(){var e=this.lead.row,t=this.lead.column;if(i=this.session.getFoldAt(e,t,-1))this.moveCursorTo(i.start.row,i.start.column);else{var i=this.session.getFoldStringAt(e,t,-1),i=(null==i&&(i=this.doc.getLine(e).substring(0,t)),o.stringReverse(i));if(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(i)&&(t-=this.session.nonTokenRe.lastIndex,i=i.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),t<=0)return this.moveCursorTo(e,0),this.moveCursorLeft(),void(0<e&&this.moveCursorWordLeft());this.session.tokenRe.exec(i)&&(t-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(e,t)}},this.$shortWordEndIndex=function(e){var t,i=0,n=/\s/,r=this.session.tokenRe;if(r.lastIndex=0,this.session.tokenRe.exec(e))i=this.session.tokenRe.lastIndex;else{for(;(t=e[i])&&n.test(t);)i++;if(i<1)for(r.lastIndex=0;(t=e[i])&&!r.test(t);)if(r.lastIndex=0,i++,n.test(t)){if(2<i){i--;break}for(;(t=e[i])&&n.test(t);)i++;if(2<i)break}}return r.lastIndex=0,i},this.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t),r=this.session.getFoldAt(e,t,1);if(r)return this.moveCursorTo(r.end.row,r.end.column);if(t==i.length){for(var o=this.doc.getLength();n=this.doc.getLine(++e),e<o&&/^\s*$/.test(n););/^\s+/.test(n)||(n=""),t=0}r=this.$shortWordEndIndex(n);this.moveCursorTo(e,t+r)},this.moveCursorShortWordLeft=function(){var e=this.lead.row,t=this.lead.column;if(n=this.session.getFoldAt(e,t,-1))return this.moveCursorTo(n.start.row,n.start.column);var i=this.session.getLine(e).substring(0,t);if(0===t){for(;i=this.doc.getLine(--e),0<e&&/^\s*$/.test(i););t=i.length,/\s+$/.test(i)||(i="")}var n=o.stringReverse(i),n=this.$shortWordEndIndex(n);return this.moveCursorTo(e,t-n)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(e,t){var i,n=this.session.documentToScreenPosition(this.lead.row,this.lead.column),r=(0===t&&(0!==e&&(this.session.$bidiHandler.isBidiRow(n.row,this.lead.row)?(i=this.session.$bidiHandler.getPosLeft(n.column),n.column=Math.round(i/this.session.$bidiHandler.charWidths[0])):i=n.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?n.column=this.$desiredColumn:this.$desiredColumn=n.column),0!=e&&this.session.lineWidgets&&this.session.lineWidgets[this.lead.row]&&(r=this.session.lineWidgets[this.lead.row],e<0?e-=r.rowsAbove||0:0<e&&(e+=r.rowCount-(r.rowsAbove||0))),this.session.screenToDocumentPosition(n.row+e,n.column,i));0!==e&&0===t&&r.row===this.lead.row&&(r.column,this.lead.column),this.moveCursorTo(r.row,r.column+t,0===t)},this.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},this.moveCursorTo=function(e,t,i){var n=this.session.getFoldAt(e,t,1),n=(n&&(e=n.start.row,t=n.start.column),this.$keepDesiredColumnOnChange=!0,this.session.getLine(e));/[\uDC00-\uDFFF]/.test(n.charAt(t))&&n.charAt(t-1)&&(this.lead.row==e&&this.lead.column==t+1?t-=1:t+=1),this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,i||(this.$desiredColumn=null)},this.moveCursorToScreen=function(e,t,i){e=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(e.row,e.column,i)},this.detach=function(){this.lead.detach(),this.anchor.detach()},this.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},this.getRangeOfMovements=function(e){var t=this.getCursor();try{e(this);var i=this.getCursor();return a.fromPoints(t,i)}catch(e){return a.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){var e;return this.rangeCount?e=this.ranges.map(function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t}):(e=this.getRange()).isBackwards=this.isBackwards(),e},this.fromJSON=function(e){if(null==e.start){if(this.rangeList&&1<e.length){this.toSingleRange(e[0]);for(var t=e.length;t--;){var i=a.fromPoints(e[t].start,e[t].end);e[t].isBackwards&&(i.cursor=i.start),this.addRange(i,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},this.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0}}.call(n.prototype),t.Selection=n}),ace.define("ace/tokenizer",["require","exports","module","ace/config"],function(e,t,i){"use strict";function n(h){for(var e in this.states=h,this.regExps={},this.matchMappings={},this.states){for(var t=this.states[e],i=[],n=0,r=this.matchMappings[e]={defaultToken:"text"},o="g",d=[],s=0;s<t.length;s++){var a,l,c=t[s];c.defaultToken&&(r.defaultToken=c.defaultToken),c.caseInsensitive&&(o="gi"),null!=c.regex&&(c.regex instanceof RegExp&&(c.regex=c.regex.toString().slice(1,-1)),a=c.regex,l=new RegExp("(?:("+a+")|(.))").exec("a").length-2,Array.isArray(c.token)?1==c.token.length||1==l?c.token=c.token[0]:l-1!=c.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:c,groupCount:l-1}),c.token=c.token[0]):(c.tokenArray=c.token,c.token=null,c.onMatch=this.$arrayTokens):"function"!=typeof c.token||c.onMatch||(c.onMatch=1<l?this.$applyToken:c.token),1<l&&(a=/\\\d/.test(c.regex)?c.regex.replace(/\\([0-9]+)/g,function(e,t){return"\\"+(parseInt(t,10)+n+1)}):(l=1,this.removeCapturingGroups(c.regex)),c.splitRegex||"string"==typeof c.token||d.push(c)),r[n]=s,n+=l,i.push(a),c.onMatch||(c.onMatch=null))}i.length||(r[0]=0,i.push("$")),d.forEach(function(e){e.splitRegex=this.createSplitterRegexp(e.regex,o)},this),this.regExps[e]=new RegExp("("+i.join(")|(")+")|($)",o)}}var r=e("./config"),I=2e3;!function(){this.$setMaxTokenCount=function(e){I=0|e},this.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),i=this.token.apply(this,t);if("string"==typeof i)return[{type:i,value:e}];for(var n=[],r=0,o=i.length;r<o;r++)t[r]&&(n[n.length]={type:i[r],value:t[r]});return n},this.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var i=[],n=this.tokenArray,r=0,o=n.length;r<o;r++)t[r+1]&&(i[i.length]={type:n[r],value:t[r+1]});return i},this.removeCapturingGroups=function(e){return e.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!<]|(\()/g,function(e,t){return t?"(?:":e})},this.createSplitterRegexp=function(e,t){var s,a,l;return-1!=e.indexOf("(?=")&&(s=0,a=!1,l={},e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(e,t,i,n,r,o){return a?a="]"!=r:r?a=!0:n?(s==l.stack&&(l.end=o+1,l.stack=-1),s--):i&&(s++,1!=i.length&&(l.stack=s,l.start=o)),e}),null!=l.end&&/^\)*$/.test(e.substr(l.end))&&(e=e.substring(0,l.start)+e.substr(l.end))),"$"!=(e="^"!=e.charAt(0)?"^"+e:e).charAt(e.length-1)&&(e+="$"),new RegExp(e,(t||"").replace("g",""))},this.getLineTokens=function(e,t){t&&"string"!=typeof t?"#tmp"===(t=(i=t.slice(0))[0])&&(i.shift(),t=i.shift()):i=[];for(var i,h,n=t||"start",d=(d=this.states[n])||this.states[n="start"],u=this.matchMappings[n],g=this.regExps[n],r=[],o=g.lastIndex=0,p=0,s={type:null,value:""};h=g.exec(e);){var m,a=u.defaultToken,l=null,f=h[0],C=g.lastIndex;C-f.length>o&&(m=e.substring(o,C-f.length),s.type==a?s.value+=m:(s.type&&r.push(s),s={type:a,value:m}));for(var c=0;c<h.length-2;c++)if(void 0!==h[c+1]){a=(l=d[u[c]]).onMatch?l.onMatch(f,n,i,e):l.token,l.next&&(n="string"==typeof l.next?l.next:l.next(n,i),(d=this.states[n])||(this.reportError("state doesn't exist",n),d=this.states[n="start"]),u=this.matchMappings[n],(g=this.regExps[n]).lastIndex=o=C),l.consumeLineEnd&&(o=C);break}if(f)if("string"==typeof a)l&&!1===l.merge||s.type!==a?(s.type&&r.push(s),s={type:a,value:f}):s.value+=f;else if(a){s.type&&r.push(s);for(s={type:null,value:""},c=0;c<a.length;c++)r.push(a[c])}if(o==e.length)break;if(o=C,p++>I){for(p>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});o<e.length;)s.type&&r.push(s),s={value:e.substring(o,o+=500),type:"overflow"};n="start",i=[];break}}return s.type&&r.push(s),1<i.length&&i[0]!==n&&i.unshift("#tmp",n),{tokens:r,state:i.length?i:n}},this.reportError=r.reportError}.call(n.prototype),t.Tokenizer=n}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}}var l=e("../lib/lang");!function(){this.addRules=function(e,t){if(t)for(var i in e){for(var n=e[i],r=0;r<n.length;r++){var o=n[r];(o.next||o.onMatch)&&("string"==typeof o.next&&0!==o.next.indexOf(t)&&(o.next=t+o.next),o.nextState&&0!==o.nextState.indexOf(t)&&(o.nextState=t+o.nextState))}this.$rules[t+i]=n}else for(var i in e)this.$rules[i]=e[i]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,i,n,r){e="function"==typeof e?(new e).getRules():e;if(n)for(var o=0;o<n.length;o++)n[o]=t+n[o];else for(var s in n=[],e)n.push(t+s);if(this.addRules(e,t),i)for(var a=Array.prototype[r?"push":"unshift"],o=0;o<n.length;o++)a.apply(this.$rules[n[o]],l.deepCopy(i));this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};function d(e,t){return"start"==e&&!t.length||t.unshift(this.nextState,e),this.nextState}function u(e,t){return t.shift(),t.shift()||"start"}this.normalizeRules=function(){var c=0,h=this.$rules;Object.keys(h).forEach(function e(t){var i=h[t];i.processed=!0;for(var n=0;n<i.length;n++){var r=i[n],o=null,s=(Array.isArray(r)&&(o=r,r={}),!r.regex&&r.start&&(r.regex=r.start,r.next||(r.next=[]),r.next.push({defaultToken:r.token},{token:r.token+".end",regex:r.end||r.start,next:"pop"}),r.token=r.token+".start",r.push=!0),r.next||r.push);if(s&&Array.isArray(s)?((l=r.stateName)||("string"!=typeof(l=r.token)&&(l=l[0]||""),h[l]&&(l+=c++)),h[l]=s,e(r.next=l)):"pop"==s&&(r.next=u),r.push&&(r.nextState=r.next||r.push,r.next=d,delete r.push),r.rules)for(var a in r.rules)h[a]?h[a].push&&h[a].push.apply(h[a],r.rules[a]):h[a]=r.rules[a];var l="string"==typeof r?r:r.include;(o=l?Array.isArray(l)?l.map(function(e){return h[e]}):h[l]:o)&&(s=[n,1].concat(o),r.noEscape&&(s=s.filter(function(e){return!e.next})),i.splice.apply(i,s),n--),r.keywordMap&&(r.token=this.createKeywordMapper(r.keywordMap,r.defaultToken||"text",r.caseInsensitive),delete r.defaultToken)}},this)},this.createKeywordMapper=function(r,t,o,s){var a=Object.create(null);return this.$keywordList=[],Object.keys(r).forEach(function(e){for(var t=r[e].split(s||"|"),i=t.length;i--;){var n=t[i];this.$keywordList.push(n),o&&(n=n.toLowerCase()),a[n]=e}},this),r=null,o?function(e){return a[e.toLowerCase()]||t}:function(e){return a[e]||t}},this.getKeywords=function(){return this.$keywords}}.call(n.prototype),t.TextHighlightRules=n}),ace.define("ace/mode/behaviour",["require","exports","module"],function(e,t,i){"use strict";function n(){this.$behaviours={}}!function(){this.add=function(e,t,i){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=i},this.addBehaviours=function(e){for(var t in e)for(var i in e[t])this.add(t,i,e[t][i])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){e=("function"==typeof e?new e:e).getBehaviours(t),this.addBehaviours(e)},this.getBehaviours=function(e){if(e){for(var t={},i=0;i<e.length;i++)this.$behaviours[e[i]]&&(t[e[i]]=this.$behaviours[e[i]]);return t}return this.$behaviours}}.call(n.prototype),t.Behaviour=n}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(e,t,i){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t),e=e.getTokenAt(t,i),this.$tokenIndex=e?e.index:-1}var r=e("./range").Range;!function(){this.stepBackward=function(){for(--this.$tokenIndex;this.$tokenIndex<0;){if(--this.$row,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){var e;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e=e||this.$session.getLength(),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,i=e[t].start;if(void 0!==i)return i;for(i=0;0<t;)i+=e[--t].value.length;return i},this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},this.getCurrentTokenRange=function(){var e=this.$rowTokens[this.$tokenIndex],t=this.getCurrentTokenColumn();return new r(this.$row,t,this.$row,t+e.value.length)}}.call(n.prototype),t.TokenIterator=n}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,t,n){"use strict";function u(e){var t=-1;if(e.multiSelect&&(t=e.selection.index,i.rangeCount!=e.multiSelect.rangeCount&&(i={rangeCount:e.multiSelect.rangeCount})),i[t])return m=i[t];m=i[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}}function g(e,t,i,n){var r=e.end.row-e.start.row;return{text:i+t+n,selection:[0,e.start.column+1,r,e.end.column+(r?0:1)]}}function p(d){this.add("braces","insertion",function(c,h,e,t,i){var n=e.getCursorPosition(),r=t.doc.getLine(n.row);if("{"==i)return u(e),s=e.getSelectionRange(),""!==(a=t.doc.getTextRange(s))&&"{"!==a&&e.getWrapBehavioursEnabled()?g(s,a,"{","}"):p.isSaneInsertion(e,t)?/[\]\}\)]/.test(r[n.column])||e.inMultiSelectMode||d&&d.braces?(p.recordAutoInsert(e,t,"}"),{text:"{}",selection:[1,1]}):(p.recordMaybeInsert(e,t,"{"),{text:"{",selection:[1,1]}):void 0;if("}"==i){u(e);var o=r.substring(n.column,n.column+1);if("}"==o)if(null!==t.$findOpeningBracket("}",{column:n.column+1,row:n.row})&&p.isAutoInsertedClosing(n,r,i))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if("\n"==i||"\r\n"==i){u(e);var s="";if(p.isMaybeInsertedClosing(n,r)&&(s=C.stringRepeat("}",m.maybeInsertedBrackets),p.clearMaybeInsertedClosing()),"}"===(o=r.substring(n.column,n.column+1))){var a=t.findMatchingBracket({row:n.row,column:n.column+1},"}");if(!a)return null;var l=this.$getIndent(t.getLine(a.row))}else{if(!s)return void p.clearMaybeInsertedClosing();l=this.$getIndent(r)}i=l+t.getTabString();return{text:"\n"+i+"\n"+l+s,selection:[1,i.length,1,i.length]}}p.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"{"==o){if(u(i),"}"==n.doc.getLine(r.start.row).substring(r.end.column,r.end.column+1))return r.end.column++,r;m.maybeInsertedBrackets--}}),this.add("parens","insertion",function(e,t,i,n,r){if("("==r)return u(i),o=i.getSelectionRange(),""!==(s=n.doc.getTextRange(o))&&i.getWrapBehavioursEnabled()?g(o,s,"(",")"):p.isSaneInsertion(i,n)?(p.recordAutoInsert(i,n,")"),{text:"()",selection:[1,1]}):void 0;if(")"==r){u(i);var o=i.getCursorPosition(),s=n.doc.getLine(o.row),i=s.substring(o.column,o.column+1);if(")"==i)if(null!==n.$findOpeningBracket(")",{column:o.column+1,row:o.row})&&p.isAutoInsertedClosing(o,s,r))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("parens","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"("==o&&(u(i),")"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r}),this.add("brackets","insertion",function(e,t,i,n,r){if("["==r)return u(i),o=i.getSelectionRange(),""!==(s=n.doc.getTextRange(o))&&i.getWrapBehavioursEnabled()?g(o,s,"[","]"):p.isSaneInsertion(i,n)?(p.recordAutoInsert(i,n,"]"),{text:"[]",selection:[1,1]}):void 0;if("]"==r){u(i);var o=i.getCursorPosition(),s=n.doc.getLine(o.row),i=s.substring(o.column,o.column+1);if("]"==i)if(null!==n.$findOpeningBracket("]",{column:o.column+1,row:o.row})&&p.isAutoInsertedClosing(o,s,r))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("brackets","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"["==o&&(u(i),"]"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r}),this.add("string_dquotes","insertion",function(h,d,e,t,i){var n=t.$mode.$quotes||f;if(1==i.length&&n[i]&&(!this.lineCommentStart||-1==this.lineCommentStart.indexOf(i))){u(e);var r=e.getSelectionRange(),o=t.doc.getTextRange(r);if(!(""===o||1==o.length&&n[o])&&e.getWrapBehavioursEnabled())return g(r,o,i,i);if(!o){var n=e.getCursorPosition(),r=t.doc.getLine(n.row),o=r.substring(n.column-1,n.column),e=r.substring(n.column,n.column+1),s=t.getTokenAt(n.row,n.column),a=t.getTokenAt(n.row,n.column+1);if("\\"==o&&s&&/escape/.test(s.type))return null;var l,s=s&&/string|escape/.test(s.type),c=!a||/string|escape/.test(a.type);if(e==i)(l=s!==c)&&/string\.end/.test(a.type)&&(l=!1);else{if(s&&!c)return null;if(s&&c)return null;a=t.$mode.tokenRe,s=(a.lastIndex=0,a.test(o)),c=(a.lastIndex=0,a.test(o));if(s||c)return null;if(e&&!/[\s;,.})\]\\]/.test(e))return null;t=r[n.column-2];if(o==i&&(t==i||a.test(t)))return null;l=!0}return{text:l?i+i:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(e,t,i,n,r){var o=n.$mode.$quotes||f,s=n.doc.getTextRange(r);if(!r.isMultiLine()&&o.hasOwnProperty(s)&&(u(i),n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)==s))return r.end.column++,r})}var m,s=e("../../lib/oop"),a=e("../behaviour").Behaviour,r=e("../../token_iterator").TokenIterator,C=e("../../lib/lang"),o=["text","paren.rparen","rparen","paren","punctuation.operator"],l=["text","paren.rparen","rparen","paren","punctuation.operator","comment"],i={},f={'"':'"',"'":"'"};p.isSaneInsertion=function(e,t){var i=e.getCursorPosition(),n=new r(t,i.row,i.column);if(!this.$matchTokenType(n.getCurrentToken()||"text",o)){if(/[)}\]]/.test(e.session.getLine(i.row)[i.column]))return!0;e=new r(t,i.row,i.column+1);if(!this.$matchTokenType(e.getCurrentToken()||"text",o))return!1}return n.stepForward(),n.getCurrentTokenRow()!==i.row||this.$matchTokenType(n.getCurrentToken()||"text",l)},p.$matchTokenType=function(e,t){return-1<t.indexOf(e.type||e)},p.recordAutoInsert=function(e,t,i){e=e.getCursorPosition(),t=t.doc.getLine(e.row);this.isAutoInsertedClosing(e,t,m.autoInsertedLineEnd[0])||(m.autoInsertedBrackets=0),m.autoInsertedRow=e.row,m.autoInsertedLineEnd=i+t.substr(e.column),m.autoInsertedBrackets++},p.recordMaybeInsert=function(e,t,i){e=e.getCursorPosition(),t=t.doc.getLine(e.row);this.isMaybeInsertedClosing(e,t)||(m.maybeInsertedBrackets=0),m.maybeInsertedRow=e.row,m.maybeInsertedLineStart=t.substr(0,e.column)+i,m.maybeInsertedLineEnd=t.substr(e.column),m.maybeInsertedBrackets++},p.isAutoInsertedClosing=function(e,t,i){return 0<m.autoInsertedBrackets&&e.row===m.autoInsertedRow&&i===m.autoInsertedLineEnd[0]&&t.substr(e.column)===m.autoInsertedLineEnd},p.isMaybeInsertedClosing=function(e,t){return 0<m.maybeInsertedBrackets&&e.row===m.maybeInsertedRow&&t.substr(e.column)===m.maybeInsertedLineEnd&&t.substr(0,e.column)==m.maybeInsertedLineStart},p.popAutoInsertedClosing=function(){m.autoInsertedLineEnd=m.autoInsertedLineEnd.substr(1),m.autoInsertedBrackets--},p.clearMaybeInsertedClosing=function(){m&&(m.maybeInsertedBrackets=0,m.maybeInsertedRow=-1)},s.inherits(p,a),t.CstyleBehaviour=p}),ace.define("ace/unicode",["require","exports","module"],function(e,t,i){"use strict";for(var n=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2],r=0,o=[],s=0;s<n.length;s+=2)o.push(r+=n[s]),n[s+1]&&o.push(45,r+=n[s+1]);t.wordChars=String.fromCharCode.apply(null,o)}),ace.define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(e,t,a){"use strict";function i(){this.HighlightRules=r}var s=e("../config"),n=e("../tokenizer").Tokenizer,r=e("./text_highlight_rules").TextHighlightRules,l=e("./behaviour/cstyle").CstyleBehaviour,o=e("../unicode"),b=e("../lib/lang"),m=e("../token_iterator").TokenIterator,f=e("../range").Range;!function(){this.$defaultBehaviour=new l,this.tokenRe=new RegExp("^["+o.wordChars+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+o.wordChars+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new n(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(t,r,d,u){var o=r.doc,i=!0,n=!0,s=1/0,a=r.getTabSize(),e=!1;if(this.lineCommentStart){l=Array.isArray(this.lineCommentStart)?(c=this.lineCommentStart.map(b.escapeRegExp).join("|"),this.lineCommentStart[0]):(c=b.escapeRegExp(this.lineCommentStart),this.lineCommentStart),c=new RegExp("^(\\s*)(?:"+c+") ?"),e=r.getUseSoftTabs();var g=function(e,t){var i,n,r=e.match(c);r&&(i=r[1].length,n=r[0].length,C(e,i,n)||" "!=r[0][n-1]||n--,o.removeInLine(t,i,n))},p=l+" ",m=function(e,t){i&&!/\S/.test(e)||(C(e,s,s)?o.insertInLine({row:t,column:s},p):o.insertInLine({row:t,column:s},l))},f=function(e,t){return c.test(e)},C=function(e,t,i){for(var n=0;t--&&" "==e.charAt(t);)n++;if(n%a!=0)return!1;for(n=0;" "==e.charAt(i++);)n++;return 2<a?n%a!=a-1:n%a==0}}else{if(!this.blockComment)return!1;var l=this.blockComment.start,I=this.blockComment.end,c=new RegExp("^(\\s*)(?:"+b.escapeRegExp(l)+")"),v=new RegExp("(?:"+b.escapeRegExp(I)+")\\s*$"),m=function(e,t){f(e,t)||i&&!/\S/.test(e)||(o.insertInLine({row:t,column:e.length},I),o.insertInLine({row:t,column:s},l))},g=function(e,t){var i;(i=e.match(v))&&o.removeInLine(t,e.length-i[0].length,e.length),(i=e.match(c))&&o.removeInLine(t,i[1].length,i[0].length)},f=function(e,t){if(c.test(e))return!0;for(var i=r.getTokens(t),n=0;n<i.length;n++)if("comment"===i[n].type)return!0}}function A(e){for(var t=d;t<=u;t++)e(o.getLine(t),t)}var h=1/0;A(function(e,t){var i=e.search(/\S/);-1!==i?(i<s&&(s=i),n&&!f(e,t)&&(n=!1)):h>e.length&&(h=e.length)}),s==1/0&&(s=h,n=i=!1),e&&s%a!=0&&(s=Math.floor(s/a)*a),A(n?g:m)},this.toggleBlockComment=function(h,e,d,t){var i=this.blockComment;if(i){!i.start&&i[0]&&(i=i[0]);var n,r,o=(c=new m(e,t.row,t.column)).getCurrentToken(),s=(e.selection,e.selection.toOrientedRange());if(o&&/comment/.test(o.type)){for(;o&&/comment/.test(o.type);){if(-1!=(g=o.value.indexOf(i.start))){var a=c.getCurrentTokenRow(),l=c.getCurrentTokenColumn()+g,u=new f(a,l,a,l+i.start.length);break}o=c.stepBackward()}for(var c,g,o=(c=new m(e,t.row,t.column)).getCurrentToken();o&&/comment/.test(o.type);){if(-1!=(g=o.value.indexOf(i.end))){var a=c.getCurrentTokenRow(),l=c.getCurrentTokenColumn()+g,p=new f(a,l,a,l+i.end.length);break}o=c.stepForward()}p&&e.remove(p),u&&(e.remove(u),n=u.start.row,r=-i.start.length)}else r=i.start.length,n=d.start.row,e.insert(d.end,i.end),e.insert(d.start,i.start);s.start.row==n&&(s.start.column+=r),s.end.row==n&&(s.end.column+=r),e.selection.fromOrientedRange(s)}},this.getNextLineIndent=function(e,t,i){return this.$getIndent(t)},this.checkOutdent=function(e,t,i){return!1},this.autoOutdent=function(e,t,i){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(e){return null},this.createModeDelegates=function(e){for(var n in this.$embeds=[],this.$modes={},e){var t,i,r;e[n]&&(i=(t=e[n]).prototype.$id,(r=s.$modes[i])||(s.$modes[i]=r=new t),s.$modes[n]||(s.$modes[n]=r),this.$embeds.push(n),this.$modes[n]=r)}for(var o=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"],n=0;n<o.length;n++)!function(e){var t=o[n],i=e[t];e[o[n]]=function(){return this.$delegator(t,arguments,i)}}(this)},this.$delegator=function(e,t,i){var n=t[0]||"start";if("string"!=typeof n){if(Array.isArray(n[2])){var r=n[2][n[2].length-1];if(s=this.$modes[r])return s[e].apply(s,[n[1]].concat([].slice.call(t,1)))}n=n[0]||"start"}for(var o=0;o<this.$embeds.length;o++)if(this.$modes[this.$embeds[o]]){var s,a=n.split(this.$embeds[o]);if(!a[0]&&a[1])return t[0]=a[1],(s=this.$modes[this.$embeds[o]])[e].apply(s,t)}r=i.apply(this,t);return i?r:void 0},this.transformAction=function(e,t,i,n,r){if(this.$behaviour){var o,s=this.$behaviour.getBehaviours();for(o in s)if(s[o][t]){var a=s[o][t].apply(this,arguments);if(a)return a}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,i=[];for(s in t)for(var n=t[s],r=0,o=n.length;r<o;r++)if("string"==typeof n[r].token)/keyword|support|storage/.test(n[r].token)&&i.push(n[r].regex);else if("object"==typeof n[r].token)for(var s,a=0,l=n[r].token.length;a<l;a++)/keyword|support|storage/.test(n[r].token[a])&&(s=n[r].regex.match(/\(.+?\)/g)[a],i.push(s.substr(1,s.length-2)));this.completionKeywords=i}return e?i.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(e,t,i,n){return(this.$keywordList||this.$createKeywordList()).map(function(e){return{name:e,value:e,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}.call(i.prototype),t.Mode=i}),ace.define("ace/apply_delta",["require","exports","module"],function(e,t,i){"use strict";t.applyDelta=function(e,t,i){var n=t.start.row,r=t.start.column,o=e[n]||"";switch(t.action){case"insert":1===t.lines.length?e[n]=o.substring(0,r)+t.lines[0]+o.substring(r):(s=[n,1].concat(t.lines),e.splice.apply(e,s),e[n]=o.substring(0,r)+e[n],e[n+t.lines.length-1]+=o.substring(r));break;case"remove":var s=t.end.column,a=t.end.row;n===a?e[n]=o.substring(0,r)+o.substring(s):e.splice(n,a-n+1,o.substring(0,r)+e[a].substring(s))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,e=t.Anchor=function(e,t,i){this.$onChange=this.onChange.bind(this),this.attach(e),void 0===i?this.setPosition(t.row,t.column):this.setPosition(t,i)};!function(){function a(e,t,i){i=i?e.column<=t.column:e.column<t.column;return e.row<t.row||e.row==t.row&&i}n.implement(this,r),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(e){e.start.row==e.end.row&&e.start.row!=this.row||e.start.row>this.row||(e=function(e,t,i){var n="insert"==e.action,r=(n?1:-1)*(e.end.row-e.start.row),o=(n?1:-1)*(e.end.column-e.start.column),s=e.start,n=n?s:e.end;if(a(t,s,i))return{row:t.row,column:t.column};if(a(n,t,!i))return{row:t.row+r,column:t.column+(t.row==n.row?o:0)};return{row:s.row,column:s.column}}(e,{row:this.row,column:this.column},this.$insertRight),this.setPosition(e.row,e.column,!0))},this.setPosition=function(e,t,i){i=i?{row:e,column:t}:this.$clipPositionToDocument(e,t);this.row==i.row&&this.column==i.column||(e={row:this.row,column:this.column},this.row=i.row,this.column=i.column,this._signal("change",{old:e,value:i}))},this.detach=function(){this.document.off("change",this.$onChange)},this.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(e,t){var i={};return e>=this.document.getLength()?(i.row=Math.max(0,this.document.getLength()-1),i.column=this.document.getLine(i.row).length):e<0?(i.row=0,i.column=0):(i.row=e,i.column=Math.min(this.document.getLine(i.row).length,Math.max(0,t))),t<0&&(i.column=0),i}}.call(e.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(e,t,i){"use strict";function n(e){this.$lines=[""],0===e.length?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)}var r=e("./lib/oop"),o=e("./apply_delta").applyDelta,s=e("./lib/event_emitter").EventEmitter,a=e("./range").Range,l=e("./anchor").Anchor;!function(){r.implement(this,s),this.setValue=function(e){var t=this.getLength()-1;this.remove(new a(0,0,t,this.getLine(t).length)),this.insert({row:0,column:0},e)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(e,t){return new l(this,e,t)},0==="aaa".split(/a/).length?this.$split=function(e){return e.replace(/\r\n|\r/g,"\n").split("\n")}:this.$split=function(e){return e.split(/\r\n|\r|\n/)},this.$detectNewLine=function(e){e=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=e?e[1]:"\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},this.getLine=function(e){return this.$lines[e]||""},this.getLines=function(e,t){return this.$lines.slice(e,t+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},this.getLinesForRange=function(e){var t,i;return e.start.row===e.end.row?t=[this.getLine(e.start.row).substring(e.start.column,e.end.column)]:((t=this.getLines(e.start.row,e.end.row))[0]=(t[0]||"").substring(e.start.column),i=t.length-1,e.end.row-e.start.row==i&&(t[i]=t[i].substring(0,e.end.column))),t},this.insertLines=function(e,t){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,t)},this.removeLines=function(e,t){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,t)},this.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},this.insert=function(e,t){return this.getLength()<=1&&this.$detectNewLine(t),this.insertMergedLines(e,this.$split(t))},this.insertInLine=function(e,t){var i=this.clippedPos(e.row,e.column),e=this.pos(e.row,e.column+t.length);return this.applyDelta({start:i,end:e,action:"insert",lines:[t]},!0),this.clonePos(e)},this.clippedPos=function(e,t){var i=this.getLength(),i=(void 0===e?e=i:e<0?e=0:i<=e&&(e=i-1,t=void 0),this.getLine(e));return null==t&&(t=i.length),{row:e,column:t=Math.min(Math.max(t,0),i.length)}},this.clonePos=function(e){return{row:e.row,column:e.column}},this.pos=function(e,t){return{row:e,column:t}},this.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},this.insertFullLines=function(e,t){var i=0,i=(e=Math.min(Math.max(e,0),this.getLength()))<this.getLength()?(t=t.concat([""]),0):(t=[""].concat(t),this.$lines[--e].length);this.insertMergedLines({row:e,column:i},t)},this.insertMergedLines=function(e,t){var e=this.clippedPos(e.row,e.column),i={row:e.row+t.length-1,column:(1==t.length?e.column:0)+t[t.length-1].length};return this.applyDelta({start:e,end:i,action:"insert",lines:t}),this.clonePos(i)},this.remove=function(e){var t=this.clippedPos(e.start.row,e.start.column),e=this.clippedPos(e.end.row,e.end.column);return this.applyDelta({start:t,end:e,action:"remove",lines:this.getLinesForRange({start:t,end:e})}),this.clonePos(t)},this.removeInLine=function(e,t,i){t=this.clippedPos(e,t),e=this.clippedPos(e,i);return this.applyDelta({start:t,end:e,action:"remove",lines:this.getLinesForRange({start:t,end:e})},!0),this.clonePos(t)},this.removeFullLines=function(e,t){e=Math.min(Math.max(0,e),this.getLength()-1);var i=(t=Math.min(Math.max(0,t),this.getLength()-1))==this.getLength()-1&&0<e,n=t<this.getLength()-1,r=i?e-1:e,i=i?this.getLine(r).length:0,o=n?t+1:t,n=n?0:this.getLine(o).length,r=new a(r,i,o,n),i=this.$lines.slice(e,t+1);return this.applyDelta({start:r.start,end:r.end,action:"remove",lines:this.getLinesForRange(r)}),i},this.removeNewLine=function(e){e<this.getLength()-1&&0<=e&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},this.replace=function(e,t){return e instanceof a||(e=a.fromPoints(e.start,e.end)),0===t.length&&e.isEmpty()?e.start:t==this.getTextRange(e)?e.end:(this.remove(e),t?this.insert(e.start,t):e.start)},this.applyDeltas=function(e){for(var t=0;t<e.length;t++)this.applyDelta(e[t])},this.revertDeltas=function(e){for(var t=e.length-1;0<=t;t--)this.revertDelta(e[t])},this.applyDelta=function(e,t){var i="insert"==e.action;(i?e.lines.length<=1&&!e.lines[0]:!a.comparePoints(e.start,e.end))||(i&&2e4<e.lines.length?this.$splitAndapplyLargeDelta(e,2e4):(o(this.$lines,e,t),this._signal("change",e)))},this.$safeApplyDelta=function(e){var t=this.$lines.length;("remove"==e.action&&e.start.row<t&&e.end.row<t||"insert"==e.action&&e.start.row<=t)&&this.applyDelta(e)},this.$splitAndapplyLargeDelta=function(e,t){for(var i=e.lines,n=i.length-t+1,r=e.start.row,o=e.start.column,s=0,a=0;s<n;s=a){a+=t-1;var l=i.slice(s,a);l.push(""),this.applyDelta({start:this.pos(r+s,o),end:this.pos(r+a,o=0),action:e.action,lines:l},!0)}e.lines=i.slice(s),e.start.row=r+s,e.start.column=o,this.applyDelta(e,!0)},this.revertDelta=function(e){this.$safeApplyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:"insert"==e.action?"remove":"insert",lines:e.lines.slice()})},this.indexToPosition=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=t||0,o=i.length;r<o;r++)if((e-=i[r].length+n)<0)return{row:r,column:e+i[r].length+n};return{row:o-1,column:e+i[o-1].length+n}},this.positionToIndex=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=0,o=Math.min(e.row,i.length),s=t||0;s<o;++s)r+=i[s].length+n;return r+e.column}}.call(n.prototype),t.Document=n}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var a=this;this.$worker=function(){if(a.running){for(var e=new Date,t=a.currentLine,i=-1,n=a.doc,r=t;a.lines[t];)t++;var o=n.getLength(),s=0;for(a.running=!1;t<o;){for(a.$tokenizeRow(t),i=t;t++,a.lines[t];);if(++s%5==0&&20<new Date-e){a.running=setTimeout(a.$worker,20);break}}a.currentLine=t,r<=(i=-1==i?t:i)&&a.fireUpdateEvent(r,i)}}}var r=e("./lib/oop"),o=e("./lib/event_emitter").EventEmitter;!function(){r.implement(this,o),this.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(e,t){this._signal("update",{data:{first:e,last:t}})},this.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(e){var t=e.start.row,i=e.end.row-t;0==i?this.lines[t]=null:"remove"==e.action?(this.lines.splice(t,1+i,null),this.states.splice(t,1+i,null)):((e=Array(1+i)).unshift(t,1),this.lines.splice.apply(this.lines,e),this.states.splice.apply(this.states,e)),this.currentLine=Math.min(t,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},this.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},this.$tokenizeRow=function(e){var t=this.doc.getLine(e),i=this.states[e-1],t=this.tokenizer.getLineTokens(t,i,e);return this.states[e]+""!=t.state+""?(this.states[e]=t.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=t.tokens}}.call(n.prototype),t.BackgroundTokenizer=n}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(e,t,i){this.setRegexp(e),this.clazz=t,this.type=i||"text"}var c=e("./lib/lang"),h=(e("./lib/oop"),e("./range").Range);!function(){this.MAX_RANGES=500,this.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},this.update=function(e,t,i,n){if(this.regExp)for(var r=n.firstRow,o=n.lastRow,s=r;s<=o;s++){var a=this.cache[s];null==a&&(a=(a=(a=c.getMatchOffsets(i.getLine(s),this.regExp)).length>this.MAX_RANGES?a.slice(0,this.MAX_RANGES):a).map(function(e){return new h(s,e.offset,s,e.offset+e.length)}),this.cache[s]=a.length?a:"");for(var l=a.length;l--;)t.drawSingleLineMarker(e,a[l].toScreenRange(i),this.clazz,n)}}}.call(n.prototype),t.SearchHighlight=n}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("../range").Range;function r(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];e=t[t.length-1];this.range=new n(t[0].start.row,t[0].start.column,e.end.row,e.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(e){e.setFoldLine(this)},this)}!function(){this.shiftRow=function(t){this.start.row+=t,this.end.row+=t,this.folds.forEach(function(e){e.start.row+=t,e.end.row+=t})},this.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort(function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)}),0<this.range.compareEnd(e.start.row,e.start.column)?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},this.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},this.walk=function(e,t,i){var n,r,o=0,s=this.folds,a=!0;null==t&&(t=this.end.row,i=this.end.column);for(var l=0;l<s.length;l++){if(-1==(r=(n=s[l]).range.compareStart(t,i)))return void e(null,t,i,o,a);if(!e(null,n.start.row,n.start.column,o,a)&&e(n.placeholder,n.start.row,n.start.column,o)||0===r)return;a=!n.sameRow,o=n.end.column}e(null,t,i,o,a)},this.getNextFoldTo=function(e,t){for(var i,n,r=0;r<this.folds.length;r++){if(-1==(n=(i=this.folds[r]).range.compareEnd(e,t)))return{fold:i,kind:"after"};if(0===n)return{fold:i,kind:"inside"}}return null},this.addRemoveChars=function(e,t,i){var n,r=this.getNextFoldTo(e,t);if(r)if(n=r.fold,"inside"==r.kind&&n.start.column!=t&&n.start.row!=e)window.console&&window.console.log(e,t,n);else if(n.start.row==e){var o,s=(o=this.folds).indexOf(n);for(0===s&&(this.start.column+=i);s<o.length;s++){if((n=o[s]).start.column+=i,!n.sameRow)return;n.end.column+=i}this.end.column+=i}},this.split=function(e,t){e=this.getNextFoldTo(e,t);if(!e||"inside"==e.kind)return null;var t=e.fold,e=this.folds,i=this.foldData,t=e.indexOf(t),n=e[t-1],n=(this.end.row=n.end.row,this.end.column=n.end.column,new r(i,e=e.splice(t,e.length-t)));return i.splice(i.indexOf(this)+1,0,n),n},this.merge=function(e){for(var t=e.folds,i=0;i<t.length;i++)this.addFold(t[i]);var n=this.foldData;n.splice(n.indexOf(e),1)},this.toString=function(){var t=[this.range.toString()+": ["];return this.folds.forEach(function(e){t.push("  "+e.toString())}),t.push("]"),t.join("\n")},this.idxToPosition=function(e){for(var t=0,i=0;i<this.folds.length;i++){var n=this.folds[i];if((e-=n.start.column-t)<0)return{row:n.start.row,column:n.start.column+e};if((e-=n.placeholder.length)<0)return n.start;t=n.end.column}return{row:this.end.row,column:this.end.column+e}}}.call(r.prototype),t.FoldLine=r}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){this.ranges=[],this.$bias=1}var a=e("./range").Range.comparePoints;!function(){this.comparePoints=a,this.pointIndex=function(e,t,i){for(var n=this.ranges,r=i||0;r<n.length;r++){var o=n[r],s=a(e,o.end);if(!(0<s))return o=a(e,o.start),0===s?t&&0!==o?-r-2:r:0<o||0===o&&!t?r:-r-1}return-r-1},this.add=function(e){var t=!e.isEmpty(),i=this.pointIndex(e.start,t),t=this.pointIndex(e.end,t,i=i<0?-i-1:i);return t<0?t=-t-1:t++,this.ranges.splice(i,t-i,e)},this.addList=function(e){for(var t=[],i=e.length;i--;)t.push.apply(t,this.add(e[i]));return t},this.substractPoint=function(e){e=this.pointIndex(e);if(0<=e)return this.ranges.splice(e,1)},this.merge=function(){for(var e=[],t=this.ranges,i=(t=t.sort(function(e,t){return a(e.start,t.start)}))[0],n=1;n<t.length;n++){var r=i,i=t[n],o=a(r.end,i.start);o<0||(0!=o||r.isEmpty()||i.isEmpty())&&(a(r.end,i.end)<0&&(r.end.row=i.end.row,r.end.column=i.end.column),t.splice(n,1),e.push(i),i=r,n--)}return this.ranges=t,e},this.contains=function(e,t){return 0<=this.pointIndex({row:e,column:t})},this.containsPoint=function(e){return 0<=this.pointIndex(e)},this.rangeAtPoint=function(e){e=this.pointIndex(e);if(0<=e)return this.ranges[e]},this.clipRows=function(e,t){var i=this.ranges;if(i[0].start.row>t||i[i.length-1].start.row<e)return[];for(var e=this.pointIndex({row:e,column:0}),n=this.pointIndex({row:t,column:0},e=e<0?-e-1:e),r=(n<0&&(n=-n-1),[]),o=e;o<n;o++)r.push(i[o]);return r},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(h){for(var e=h.start,t=h.end,i=e.row,n=t.row,r=this.ranges,o=0,s=r.length;o<s&&!((c=r[o]).end.row>=i);o++);if("insert"==h.action)for(var a=n-i,l=-e.column+t.column;o<s;o++){if((c=r[o]).start.row>i)break;c.start.row==i&&c.start.column>=e.column&&(c.start.column==e.column&&this.$bias<=0||(c.start.column+=l,c.start.row+=a)),c.end.row==i&&c.end.column>=e.column&&(c.end.column==e.column&&this.$bias<0||(c.end.column==e.column&&0<l&&o<s-1&&c.end.column>c.start.column&&c.end.column==r[o+1].start.column&&(c.end.column-=l),c.end.column+=l,c.end.row+=a))}else for(var c,a=i-n,l=e.column-t.column;o<s;o++){if((c=r[o]).start.row>n)break;c.end.row<n&&(i<c.end.row||i==c.end.row&&e.column<c.end.column)?(c.end.row=i,c.end.column=e.column):c.end.row==n?c.end.column<=t.column?(a||c.end.column>e.column)&&(c.end.column=e.column,c.end.row=e.row):(c.end.column+=l,c.end.row+=a):c.end.row>n&&(c.end.row+=a),c.start.row<n&&(i<c.start.row||i==c.start.row&&e.column<c.start.column)?(c.start.row=i,c.start.column=e.column):c.start.row==n?c.start.column<=t.column?(a||c.start.column>e.column)&&(c.start.column=e.column,c.start.row=e.row):(c.start.column+=l,c.start.row+=a):c.start.row>n&&(c.start.row+=a)}if(0!=a&&o<s)for(;o<s;o++)(c=r[o]).start.row+=a,c.end.row+=a}}.call(n.prototype),t.RangeList=n}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list","ace/lib/oop"],function(e,t,i){"use strict";var n=e("../range_list").RangeList,e=e("../lib/oop"),r=t.Fold=function(e,t){this.foldLine=null,this.placeholder=t,this.range=e,this.start=e.start,this.end=e.end,this.sameRow=e.start.row==e.end.row,this.subFolds=this.ranges=[]};function d(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function o(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}e.inherits(r,n),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(t){this.foldLine=t,this.subFolds.forEach(function(e){e.setFoldLine(t)})},this.clone=function(){var e=this.range.clone(),t=new r(e,this.placeholder);return this.subFolds.forEach(function(e){t.subFolds.push(e.clone())}),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(e){if(!this.range.isEqual(e)){o=e,s=this.start,d(o.start,s),d(o.end,s);for(var t=e.start.row,i=e.start.column,n=0,r=-1;n<this.subFolds.length&&1==(r=this.subFolds[n].range.compare(t,i));n++);var o=this.subFolds[n],s=0;if(0==r){if(o.range.containsRange(e))return o.addSubFold(e);s=1}for(var t=e.range.end.row,i=e.range.end.column,a=n,r=-1;a<this.subFolds.length&&1==(r=this.subFolds[a].range.compare(t,i));a++);0==r&&a++;for(var l=this.subFolds.splice(n,a-n,e),h=0==r?l.length-1:l.length,c=s;c<h;c++)e.addSubFold(l[c]);return e.setFoldLine(this.foldLine),e}},this.restoreRange=function(e){return e=e,t=this.start,o(e.start,t),void o(e.end,t);var t}}.call(r.prototype)}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],function(e,t,i){"use strict";var c=e("../range").Range,u=e("./fold_line").FoldLine,g=e("./fold").Fold,h=e("../token_iterator").TokenIterator;t.Folding=function(){this.getFoldAt=function(e,t,i){var n=this.getFoldLine(e);if(!n)return null;for(var r=n.folds,o=0;o<r.length;o++){var s=r[o].range;if(s.contains(e,t)&&(1!=i||!s.isEnd(e,t)||s.isEmpty())&&(-1!=i||!s.isStart(e,t)||s.isEmpty()))return r[o]}},this.getFoldsInRange=function(e){var t=e.start,i=e.end,n=this.$foldData,r=[];t.column+=1,--i.column;for(var o=0;o<n.length;o++)if(2!=(l=n[o].range.compareRange(e))){if(-2==l)break;for(var s=n[o].folds,a=0;a<s.length;a++){var l,c=s[a];if(-2==(l=c.range.compareRange(e)))break;if(2!=l){if(42==l)break;r.push(c)}}}return--t.column,i.column+=1,r
},this.getFoldsInRangeList=function(e){var t;return Array.isArray(e)?(t=[],e.forEach(function(e){t=t.concat(this.getFoldsInRange(e))},this)):t=this.getFoldsInRange(e),t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,i=0;i<t.length;i++)for(var n=0;n<t[i].folds.length;n++)e.push(t[i].folds[n]);return e},this.getFoldStringAt=function(e,t,i,n){if(!(n=n||this.getFoldLine(e)))return null;for(var r,o={end:{column:0}},s=0;s<n.folds.length;s++){var a,l=(a=n.folds[s]).range.compareEnd(e,t);if(-1==l){r=this.getLine(a.start.row).substring(o.end.column,a.start.column);break}if(0===l)return null;o=a}return r=r||this.getLine(a.start.row).substring(o.end.column),-1==i?r.substring(0,t-o.end.column):1==i?r.substring(t-o.end.column):r},this.getFoldLine=function(e,t){var i=this.$foldData,n=0;for(-1==(n=t?i.indexOf(t):n)&&(n=0);n<i.length;n++){var r=i[n];if(r.start.row<=e&&r.end.row>=e)return r;if(r.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var i=this.$foldData,n=0;for(-1==(n=t?i.indexOf(t):n)&&(n=0);n<i.length;n++){var r=i[n];if(r.end.row>=e)return r}return null},this.getFoldedRowCount=function(e,t){for(var i=this.$foldData,n=t-e+1,r=0;r<i.length;r++){var o=i[r],s=o.end.row,o=o.start.row;if(t<=s){o<t&&(e<=o?n-=t-o:n=0);break}e<=s&&(n-=e<=o?s-o:s-e+1)}return n},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort(function(e,t){return e.start.row-t.start.row}),e},this.addFold=function(e,t){var i,n=this.$foldData,r=!1,h=(e instanceof g?i=e:(i=new g(t,e)).collapseChildren=t.collapseChildren,this.$clipRangeToDocument(i.range),i.start.row),e=i.start.column,o=i.end.row,t=i.end.column,s=this.getFoldAt(h,e,1),a=this.getFoldAt(o,t,-1);if(s&&a==s)return s.addSubFold(i);s&&!s.range.isStart(h,e)&&this.removeFold(s),a&&!a.range.isEnd(o,t)&&this.removeFold(a);e=this.getFoldsInRange(i.range);0<e.length&&(this.removeFolds(e),i.collapseChildren||e.forEach(function(e){i.addSubFold(e)}));for(var l=0;l<n.length;l++){var c=n[l];if(o==c.start.row){c.addFold(i),r=!0;break}if(h==c.end.row){if(c.addFold(i),r=!0,!i.sameRow){var d=n[l+1];if(d&&d.start.row==o){c.merge(d);break}}break}if(o<=c.start.row)break}return r||(c=this.$addFoldLine(new u(this.$foldData,i))),this.$useWrapMode?this.$updateWrapData(c.start.row,c.start.row):this.$updateRowLengthCache(c.start.row,c.start.row),this.$modified=!0,this._signal("changeFold",{data:i,action:"add"}),i},this.addFolds=function(e){e.forEach(function(e){this.addFold(e)},this)},this.removeFold=function(e){var t=e.foldLine,i=t.start.row,n=t.end.row,r=this.$foldData,o=t.folds;1==o.length?r.splice(r.indexOf(t),1):t.range.isEnd(e.end.row,e.end.column)?(o.pop(),t.end.row=o[o.length-1].end.row,t.end.column=o[o.length-1].end.column):t.range.isStart(e.start.row,e.start.column)?(o.shift(),t.start.row=o[0].start.row,t.start.column=o[0].start.column):e.sameRow?o.splice(o.indexOf(e),1):((o=(r=t.split(e.start.row,e.start.column)).folds).shift(),r.start.row=o[0].start.row,r.start.column=o[0].start.column),this.$updating||(this.$useWrapMode?this.$updateWrapData(i,n):this.$updateRowLengthCache(i,n)),this.$modified=!0,this._signal("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],i=0;i<e.length;i++)t.push(e[i]);t.forEach(function(e){this.removeFold(e)},this),this.$modified=!0},this.expandFold=function(t){this.removeFold(t),t.subFolds.forEach(function(e){t.restoreRange(e),this.addFold(e)},this),0<t.collapseChildren&&this.foldAll(t.start.row+1,t.end.row,t.collapseChildren-1),t.subFolds=[]},this.expandFolds=function(e){e.forEach(function(e){this.expandFold(e)},this)},this.unfold=function(e,t){var i;if(null==e)i=new c(0,0,this.getLength(),0),null==t&&(t=!0);else if("number"==typeof e)i=new c(e,0,e,this.getLine(e).length);else if("row"in e)i=c.fromPoints(e,e);else{if(Array.isArray(e))return n=[],e.forEach(function(e){n=n.concat(this.unfold(e))},this),n;i=e}for(var n,e=n=this.getFoldsInRangeList(i);1==n.length&&c.comparePoints(n[0].start,i.start)<0&&0<c.comparePoints(n[0].end,i.end);)this.expandFolds(n),n=this.getFoldsInRangeList(i);if(0!=t?this.removeFolds(n):this.expandFolds(n),e.length)return e},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){t=this.getFoldLine(e,t);return t?t.end.row:e},this.getRowFoldStart=function(e,t){t=this.getFoldLine(e,t);return t?t.start.row:e},this.getFoldDisplayLine=function(e,t,i,r,o){null==r&&(r=e.start.row),null==o&&(o=0),null==t&&(t=e.end.row),null==i&&(i=this.getLine(t).length);var s=this.doc,a="";return e.walk(function(e,t,i,n){if(!(t<r)){if(t==r){if(i<o)return;n=Math.max(o,n)}a+=null!=e?e:s.getLine(t).substring(n,i)}},t,i),a},this.getDisplayLine=function(e,t,i,n){var r=this.getFoldLine(e);return r?this.getFoldDisplayLine(r,e,t,i,n):(r=this.doc.getLine(e)).substring(n||0,t||r.length)},this.$cloneFoldData=function(){var t=[];return t=this.$foldData.map(function(e){e=e.folds.map(function(e){return e.clone()});return new u(t,e)})},this.toggleFold=function(e){var t=this.selection.getRange();if(t.isEmpty()){var i,n=t.start;if(i=this.getFoldAt(n.row,n.column))return void this.expandFold(i);(r=this.findMatchingBracket(n))?1==t.comparePoint(r)?t.end=r:(t.start=r,t.start.column++,t.end.column--):(r=this.findMatchingBracket({row:n.row,column:n.column+1}))?(1==t.comparePoint(r)?t.end=r:t.start=r,t.start.column++):t=this.getCommentFoldRange(n.row,n.column)||t}else{var r=this.getFoldsInRange(t);if(e&&r.length)return void this.expandFolds(r);1==r.length&&(i=r[0])}if((i=i||this.getFoldAt(t.start.row,t.start.column))&&i.range.toString()==t.toString())this.expandFold(i);else{n="...";if(!t.isMultiLine()){if((n=this.getTextRange(t)).length<4)return;n=n.trim().substring(0,2)+".."}this.addFold(n,t)}},this.getCommentFoldRange=function(e,t,i){var n=new h(this,e,t),r=n.getCurrentToken(),o=r&&r.type;if(r&&/^comment|string/.test(o)){"comment"==(o=o.match(/comment|string/)[0])&&(o+="|doc-start");var s=new RegExp(o),o=new c;if(1!=i){for(;(r=n.stepBackward())&&s.test(r.type););n.stepForward()}if(o.start.row=n.getCurrentTokenRow(),o.start.column=n.getCurrentTokenColumn()+2,n=new h(this,e,t),-1!=i){var a=-1;do{if(r=n.stepForward(),-1==a){var l=this.getState(n.$row);s.test(l)||(a=n.$row)}else if(n.$row>a)break}while(r&&s.test(r.type));r=n.stepBackward()}else r=n.getCurrentToken();return o.end.row=n.getCurrentTokenRow(),o.end.column=n.getCurrentTokenColumn()+r.value.length-2,o}},this.foldAll=function(e,t,i,n){null==i&&(i=1e5);var r=this.foldWidgets;if(r){t=t||this.getLength();for(var o,s=e=e||0;s<t;s++)null==r[s]&&(r[s]=this.getFoldWidget(s)),"start"==r[s]&&(n&&!n(s)||(o=this.getFoldWidgetRange(s))&&o.isMultiLine()&&o.end.row<=t&&o.start.row>=e&&(s=o.end.row,o.collapseChildren=i,this.addFold("...",o)))}},this.foldToLevel=function(e){for(this.foldAll();0<e--;)this.unfold(null,!1)},this.foldAllComments=function(){var r=this;this.foldAll(null,null,null,function(e){for(var t=r.getTokens(e),i=0;i<t.length;i++){var n=t[i];if("text"!=n.type||!/^\s+$/.test(n.value))return!!/comment/.test(n.type)}})},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");this.$foldStyle!=e&&("manual"==(this.$foldStyle=e)&&this.unfold(),e=this.$foldMode,this.$setFolding(null),this.$setFolding(e))},this.$setFolding=function(e){this.$foldMode!=e&&(this.$foldMode=e,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),e&&"manual"!=this.$foldStyle?(this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(e,t){var i=this.foldWidgets;if(!i||t&&i[e])return{};for(var n=e-1;0<=n;){var r=i[n];if("start"==(r=null==r?i[n]=this.getFoldWidget(n):r)){var o=this.getFoldWidgetRange(n),s=s||o;if(o&&o.end.row>=e)break}n--}return{range:-1!==n&&o,firstRange:s}},this.onFoldWidgetClick=function(e,t){var i={children:(t=t.domEvent).shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey};this.$toggleFoldWidget(e,i)||(e=t.target||t.srcElement)&&/ace_fold-widget/.test(e.className)&&(e.className+=" ace_invalid")},this.$toggleFoldWidget=function(e,t){if(this.getFoldWidget){var i=this.getFoldWidget(e),n=this.getLine(e),i="end"===i?-1:1,n=this.getFoldAt(e,-1==i?0:n.length,i);if(n)return t.children||t.all?this.removeFold(n):this.expandFold(n),n;var r,o,i=this.getFoldWidgetRange(e,!0);return i&&!i.isMultiLine()&&(n=this.getFoldAt(i.start.row,i.start.column,1))&&i.isEqual(n.range)?(this.removeFold(n),n):(t.siblings?((n=this.getParentFoldRangeData(e)).range&&(r=n.range.start.row+1,o=n.range.end.row),this.foldAll(r,o,t.all?1e4:0)):t.children?(o=i?i.end.row:this.getLength(),this.foldAll(e+1,o,t.all?1e4:0)):i&&(t.all&&(i.collapseChildren=1e4),this.addFold("...",i)),i)}},this.toggleFoldWidget=function(e){var t,i=this.selection.getCursor().row;i=this.getRowFoldStart(i),this.$toggleFoldWidget(i,{})||(t=(t=this.getParentFoldRangeData(i,!0)).range||t.firstRange)&&(i=t.start.row,(i=this.getFoldAt(i,this.getLine(i).length,1))?this.removeFold(i):this.addFold("...",t))},this.updateFoldWidgets=function(e){var t=e.start.row,i=e.end.row-t;0==i?this.foldWidgets[t]=null:"remove"==e.action?this.foldWidgets.splice(t,1+i,null):((e=Array(1+i)).unshift(t,1),this.foldWidgets.splice.apply(this.foldWidgets,e))},this.tokenizerUpdateFoldWidgets=function(e){e=e.data;e.first!=e.last&&this.foldWidgets.length>e.first&&this.foldWidgets.splice(e.first,this.foldWidgets.length)}}}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(e,t,i){"use strict";var d=e("../token_iterator").TokenIterator,a=e("../range").Range;t.BracketMatch=function(){this.findMatchingBracket=function(e,t){if(0==e.column)return null;t=t||this.getLine(e.row).charAt(e.column-1);if(""==t)return null;t=t.match(/([\(\[\{])|([\)\]\}])/);return t?t[1]?this.$findClosingBracket(t[1],e):this.$findOpeningBracket(t[2],e):null},this.getBracketRange=function(e){var t,i,n=this.getLine(e.row),r=!0,o=n.charAt(e.column-1),s=o&&o.match(/([\(\[\{])|([\)\]\}])/);if(s||(o=n.charAt(e.column),e={row:e.row,column:e.column+1},s=o&&o.match(/([\(\[\{])|([\)\]\}])/),r=!1),!s)return null;if(s[1]){if(!(i=this.$findClosingBracket(s[1],e)))return null;t=a.fromPoints(e,i),r||(t.end.column++,t.start.column--),t.cursor=t.end}else{if(!(i=this.$findOpeningBracket(s[2],e)))return null;t=a.fromPoints(i,e),r||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.getMatchingBracketRanges=function(e){var t=this.getLine(e.row),i=t.charAt(e.column-1),n=i&&i.match(/([\(\[\{])|([\)\]\}])/);if(n||(i=t.charAt(e.column),e={row:e.row,column:e.column+1},n=i&&i.match(/([\(\[\{])|([\)\]\}])/)),!n)return null;t=new a(e.row,e.column-1,e.row,e.column),i=n[1]?this.$findClosingBracket(n[1],e):this.$findOpeningBracket(n[2],e);return i?[t,new a(i.row,i.column,i.row,i.column+1)]:[t]},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"},this.$findOpeningBracket=function(e,t,i){var n=this.$brackets[e],r=1,o=new d(this,t.row,t.column),s=o.getCurrentToken();if(s=s||o.stepForward()){i=i||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+");for(var a=t.column-o.getCurrentTokenColumn()-2,l=s.value;;){for(;0<=a;){var c=l.charAt(a);if(c==n){if(0==--r)return{row:o.getCurrentTokenRow(),column:a+o.getCurrentTokenColumn()}}else c==e&&(r+=1);--a}for(;(s=o.stepBackward())&&!i.test(s.type););if(null==s)break;a=(l=s.value).length-1}return null}},this.$findClosingBracket=function(e,t,i){var n=this.$brackets[e],r=1,o=new d(this,t.row,t.column),s=o.getCurrentToken();if(s=s||o.stepForward()){i=i||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+");for(var a=t.column-o.getCurrentTokenColumn();;){for(var l=s.value,h=l.length;a<h;){var c=l.charAt(a);if(c==n){if(0==--r)return{row:o.getCurrentTokenRow(),column:a+o.getCurrentTokenColumn()}}else c==e&&(r+=1);a+=1}for(;(s=o.stepForward())&&!i.test(s.type););if(null==s)break;a=0}return null}}}}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],function(e,t,h){"use strict";function i(e,t){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++i.$uid,this.$foldData.toString=function(){return this.join("\n")},this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new u(e)),this.setDocument(e),this.selection=new a(this),this.$bidiHandler=new o(this),s.resetOptions(this),this.setMode(t),s._signal("session",this)}var n=e("./lib/oop"),r=e("./lib/lang"),o=e("./bidihandler").BidiHandler,s=e("./config"),l=e("./lib/event_emitter").EventEmitter,a=e("./selection").Selection,d=e("./mode/text").Mode,c=e("./range").Range,u=e("./document").Document,g=e("./background_tokenizer").BackgroundTokenizer,f=e("./search_highlight").SearchHighlight;i.$uid=0,function(){n.implement(this,l),this.setDocument=function(e){this.doc&&this.doc.off("change",this.$onChange),(this.doc=e).on("change",this.$onChange),this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(e){if(!e)return this.$docRowCache=[],void(this.$screenRowCache=[]);var t=this.$docRowCache.length,e=this.$getRowCacheIndex(this.$docRowCache,e)+1;e<t&&(this.$docRowCache.splice(e,t),this.$screenRowCache.splice(e,t))},this.$getRowCacheIndex=function(e,t){for(var i=0,n=e.length-1;i<=n;){var r=i+n>>1,o=e[r];if(o<t)i=1+r;else{if(!(t<o))return r;n=r-1}}return i-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.bgTokenizer&&this.bgTokenizer.start(0)},this.onChangeFold=function(e){e=e.data;this.$resetRowCache(e.start.row)},this.onChange=function(e){this.$modified=!0,this.$bidiHandler.onChange(e),this.$resetRowCache(e.start.row);var t=this.$updateInternalDataOnChange(e);!this.$fromUndo&&this.$undoManager&&(t&&t.length&&(this.$undoManager.add({action:"removeFolds",folds:t},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(e,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule()),this.bgTokenizer&&this.bgTokenizer.$updateOnChange(e),this._signal("change",e)},this.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(e){return this.bgTokenizer.getState(e)},this.getTokens=function(e){return this.bgTokenizer.getTokens(e)},this.getTokenAt=function(e,t){var i=this.bgTokenizer.getTokens(e),n=0;if(null==t)var r=i.length-1,n=this.getLine(e).length;else for(r=0;r<i.length&&!(t<=(n+=i[r].value.length));r++);return(e=i[r])?(e.index=r,e.start=n-e.value.length,e):null},this.setUndoManager=function(e){var t;this.$undoManager=e,this.$informUndoManager&&this.$informUndoManager.cancel(),e?(e.addSession(t=this),this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.mergeUndoDeltas=!1},this.$informUndoManager=r.delayedCall(this.$syncInformUndoManager)):this.$syncInformUndoManager=function(){}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?r.stringRepeat(" ",this.getTabSize()):"\t"},this.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(e){this.setOption("tabSize",e)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize==0},this.setNavigateWithinSoftTabs=function(e){this.setOption("navigateWithinSoftTabs",e)},this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},this.$overwrite=!1,this.setOverwrite=function(e){this.setOption("overwrite",e)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(e,t){(t=void 0===t?"ace_breakpoint":t)?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.addMarker=function(e,t,i,n){var r=this.$markerId++,e={range:e,type:i||"line",renderer:"function"==typeof i?i:null,clazz:t,inFront:!!n,id:r};return n?(this.$frontMarkers[r]=e,this._signal("changeFrontMarker")):(this.$backMarkers[r]=e,this._signal("changeBackMarker")),r},this.addDynamicMarker=function(e,t){var i;if(e.update)return i=this.$markerId++,e.id=i,e.inFront=!!t,t?(this.$frontMarkers[i]=e,this._signal("changeFrontMarker")):(this.$backMarkers[i]=e,this._signal("changeBackMarker")),e},this.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];t&&(delete(t.inFront?this.$frontMarkers:this.$backMarkers)[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))},this.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},this.highlight=function(e){var t;this.$searchHighlight||(t=new f(null,"ace_selected-word","text"),this.$searchHighlight=this.addDynamicMarker(t)),this.$searchHighlight.setRegexp(e)},this.highlightLines=function(e,t,i,n){"number"!=typeof t&&(i=t,t=e),i=i||"ace_step";e=new c(e,0,t,1/0);return e.id=this.addMarker(e,i,"fullLine",n),e},this.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(e){e=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=e?e[1]:"\n"},this.getWordRange=function(e,t){var i,n=this.getLine(e),r=!1,o=(i=(r=(r=0<t?!!n.charAt(t-1).match(this.tokenRe):r)||!!n.charAt(t).match(this.tokenRe))?this.tokenRe:/^\s+$/.test(n.slice(t-1,t+1))?/\s/:this.nonTokenRe,t);if(0<o){for(;0<=--o&&n.charAt(o).match(i););o++}for(var s=t;s<n.length&&n.charAt(s).match(i);)s++;return new c(e,o,e,s)},this.getAWordRange=function(e,t){for(var i=this.getWordRange(e,t),n=this.getLine(i.end.row);n.charAt(i.end.column).match(/[ \t]/);)i.end.column+=1;return i},this.setNewLineMode=function(e){this.doc.setNewLineMode(e)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(e){this.setOption("useWorker",e)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},this.$modes=s.$modes,this.$mode=null,this.$modeId=null,this.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var i=e,n=i.path}else n=e||"ace/mode/text";if(this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new d),this.$modes[n]&&!i)return this.$onChangeMode(this.$modes[n]),void(t&&t());this.$modeId=n,s.loadModule(["mode",n],function(e){if(this.$modeId!==n)return t&&t();this.$modes[n]&&!i?this.$onChangeMode(this.$modes[n]):e&&e.Mode&&(e=new e.Mode(i),i||((this.$modes[n]=e).$id=n),this.$onChangeMode(e)),t&&t()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0)},this.$onChangeMode=function(e,t){var i,n,r,o;t||(this.$modeId=e.$id),this.$mode!==e&&(i=this.$mode,this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker(),void 0!==(n=e.getTokenizer()).on&&(r=this.onReloadTokenizer.bind(this),n.on("update",r)),this.bgTokenizer?this.bgTokenizer.setTokenizer(n):(this.bgTokenizer=new g(n),(o=this).bgTokenizer.on("update",function(e){o._signal("tokenizerUpdate",e)})),this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode",{oldMode:i,mode:e})))},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){s.warn("Could not load worker",e),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var t=0;return this.lineWidgets.forEach(function(e){e&&e.screenWidth>t&&(t=e.screenWidth)}),this.lineWidgetWidth=t},this.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),i=this.$rowLengthCache,n=0,r=0,o=this.$foldData[r],s=o?o.start.row:1/0,a=t.length,l=0;l<a;l++){if(s<l){if(a<=(l=o.end.row+1))break;s=(o=this.$foldData[r++])?o.start.row:1/0}null==i[l]&&(i[l]=this.$getStringScreenWidth(t[l])[0]),i[l]>n&&(n=i[l])}this.screenWidth=n}},this.getLine=function(e){return this.doc.getLine(e)},this.getLines=function(e,t){return this.doc.getLines(e,t)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},this.insert=function(e,t){return this.doc.insert(e,t)},this.remove=function(e){return this.doc.remove(e)},this.removeFullLines=function(e,t){return this.doc.removeFullLines(e,t)},this.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=e.length-1;-1!=i;i--){var n=e[i];"insert"==n.action||"remove"==n.action?this.doc.revertDelta(n):n.folds&&this.addFolds(n.folds)}!t&&this.$undoSelect&&(e.selectionBefore?this.selection.fromJSON(e.selectionBefore):this.selection.setRange(this.$getUndoSelection(e,!0))),this.$fromUndo=!1}},this.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=0;i<e.length;i++){var n=e[i];"insert"!=n.action&&"remove"!=n.action||this.doc.$safeApplyDelta(n)}!t&&this.$undoSelect&&(e.selectionAfter?this.selection.fromJSON(e.selectionAfter):this.selection.setRange(this.$getUndoSelection(e,!1))),this.$fromUndo=!1}},this.setUndoSelect=function(e){this.$undoSelect=e},this.$getUndoSelection=function(e,t){function i(e){return t?"insert"!==e.action:"insert"===e.action}for(var n,r,o=0;o<e.length;o++){var s=e[o];s.start&&(n?i(s)?(r=s.start,-1==n.compare(r.row,r.column)&&n.setStart(r),r=s.end,1==n.compare(r.row,r.column)&&n.setEnd(r)):(r=s.start,-1==n.compare(r.row,r.column)&&(n=c.fromPoints(s.start,s.start))):n=i(s)?c.fromPoints(s.start,s.end):c.fromPoints(s.start,s.start))}return n},this.replace=function(e,t){return this.doc.replace(e,t)},this.moveText=function(e,t,i){var n,r,o,s=this.getTextRange(e),a=this.getFoldsInRange(e),t=c.fromPoints(t,t);return i||(this.remove(e),r=e.start.row-e.end.row,(o=r?-e.end.column:e.start.column-e.end.column)&&(t.start.row==e.end.row&&t.start.column>e.end.column&&(t.start.column+=o),t.end.row==e.end.row&&t.end.column>e.end.column&&(t.end.column+=o)),r&&t.start.row>=e.end.row&&(t.start.row+=r,t.end.row+=r)),t.end=this.insert(t.start,s),a.length&&(n=e.start,i=t.start,r=i.row-n.row,o=i.column-n.column,this.addFolds(a.map(function(e){return(e=e.clone()).start.row==n.row&&(e.start.column+=o),e.end.row==n.row&&(e.end.column+=o),e.start.row+=r,e.end.row+=r,e}))),t},this.indentRows=function(e,t,i){i=i.replace(/\t/g,this.getTabString());for(var n=e;n<=t;n++)this.doc.insertInLine({row:n,column:0},i)},this.outdentRows=function(e){for(var t=e.collapseRows(),i=new c(0,0,0,0),n=this.getTabSize(),r=t.start.row;r<=t.end.row;++r){var o=this.getLine(r);i.start.row=r,i.end.row=r;for(var s=0;s<n&&" "==o.charAt(s);++s);s<n&&"\t"==o.charAt(s)?(i.start.column=s,i.end.column=s+1):(i.start.column=0,i.end.column=s),this.remove(i)}},this.$moveLines=function(e,t,i){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),i<0){if((r=this.getRowFoldStart(e+i))<0)return 0;var n=r-e}else if(0<i){if((r=this.getRowFoldEnd(t+i))>this.doc.getLength()-1)return 0;n=r-t}else{e=this.$clipRowToDocument(e);n=(t=this.$clipRowToDocument(t))-e+1}var r=new c(e,0,t,Number.MAX_VALUE),r=this.getFoldsInRange(r).map(function(e){return(e=e.clone()).start.row+=n,e.end.row+=n,e}),i=0==i?this.doc.getLines(e,t):this.doc.removeFullLines(e,t);return this.doc.insertFullLines(e+n,i),r.length&&this.addFolds(r),n},this.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},this.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},this.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},this.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},this.$clipColumnToRow=function(e,t){return t<0?0:Math.min(this.doc.getLine(e).length,t)},this.$clipPositionToDocument=function(e,t){var i;return t=Math.max(0,t),t=e<0?e=0:(i=this.doc.getLength())<=e?this.doc.getLine(e=i-1).length:Math.min(this.doc.getLine(e).length,t),{row:e,column:t}},this.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(e){e!=this.$useWrapMode&&(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e&&(e=this.getLength(),this.$wrapData=Array(e),this.$updateWrapData(0,e-1)),this._signal("changeWrapMode"))},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(e,t){this.$wrapLimitRange.min===e&&this.$wrapLimitRange.max===t||(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},this.adjustWrapLimit=function(e,t){var i=this.$wrapLimitRange,t=(i.max<0&&(i={min:t,max:t}),this.$constrainWrapLimit(e,i.min,i.max));return t!=this.$wrapLimit&&1<t&&(this.$wrapLimit=t,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},this.$constrainWrapLimit=function(e,t,i){return t&&(e=Math.max(t,e)),e=i?Math.min(i,e):e},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(e){var h=this.$useWrapMode,d=e.action,t=e.start,i=e.end,n=t.row,r=i.row,o=r-n,u=null;if(this.$updating=!0,0!=o)if("remove"===d){this[h?"$wrapData":"$rowLengthCache"].splice(n,o);var s=this.$foldData,u=this.getFoldsInRange(e);this.removeFolds(u);var a=0;for((c=this.getFoldLine(i.row))&&(c.addRemoveChars(i.row,i.column,t.column-i.column),c.shiftRow(-o),(l=this.getFoldLine(n))&&l!==c&&(l.merge(c),c=l),a=s.indexOf(c)+1);a<s.length;a++)(c=s[a]).start.row>=i.row&&c.shiftRow(-o);r=n}else{var l=Array(o),g=(l.unshift(n,0),h?this.$wrapData:this.$rowLengthCache),s=(g.splice.apply(g,l),this.$foldData),a=0;for((c=this.getFoldLine(n))&&(0==(g=c.range.compareInside(t.row,t.column))?(c=c.split(t.row,t.column))&&(c.shiftRow(o),c.addRemoveChars(r,0,i.column-t.column)):-1==g&&(c.addRemoveChars(n,0,i.column-t.column),c.shiftRow(o)),a=s.indexOf(c)+1);a<s.length;a++)(c=s[a]).start.row>=n&&c.shiftRow(o)}else{var c,o=Math.abs(e.start.column-e.end.column);"remove"===d&&(u=this.getFoldsInRange(e),this.removeFolds(u),o=-o),(c=this.getFoldLine(n))&&c.addRemoveChars(n,t.column,o)}return h&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,h?this.$updateWrapData(n,r):this.$updateRowLengthCache(n,r),u},this.$updateRowLengthCache=function(e,t,i){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},this.$updateWrapData=function(e,t){var s,i,a=this.doc.getAllLines(),n=this.getTabSize(),r=this.$wrapData,o=this.$wrapLimit,l=e;for(t=Math.min(t,a.length-1);l<=t;)(i=this.getFoldLine(l,i))?(s=[],i.walk(function(e,t,i,n){var r;if(null!=e){(r=this.$getDisplayTokens(e,s.length))[0]=p;for(var o=1;o<r.length;o++)r[o]=m}else r=this.$getDisplayTokens(a[t].substring(n,i),s.length);s=s.concat(r)}.bind(this),i.end.row,a[i.end.row].length+1),r[i.start.row]=this.$computeWrapSplits(s,o,n),l=i.end.row+1):(s=this.$getDisplayTokens(a[l]),r[l]=this.$computeWrapSplits(s,o,n),l++)};var p=3,m=4;function a(e){return!(e<4352)&&(4352<=e&&e<=4447||4515<=e&&e<=4519||4602<=e&&e<=4607||9001<=e&&e<=9002||11904<=e&&e<=11929||11931<=e&&e<=12019||12032<=e&&e<=12245||12272<=e&&e<=12283||12288<=e&&e<=12350||12353<=e&&e<=12438||12441<=e&&e<=12543||12549<=e&&e<=12589||12593<=e&&e<=12686||12688<=e&&e<=12730||12736<=e&&e<=12771||12784<=e&&e<=12830||12832<=e&&e<=12871||12880<=e&&e<=13054||13056<=e&&e<=19903||19968<=e&&e<=42124||42128<=e&&e<=42182||43360<=e&&e<=43388||44032<=e&&e<=55203||55216<=e&&e<=55238||55243<=e&&e<=55291||63744<=e&&e<=64255||65040<=e&&e<=65049||65072<=e&&e<=65106||65108<=e&&e<=65126||65128<=e&&e<=65131||65281<=e&&e<=65376||65504<=e&&e<=65510)}this.$computeWrapSplits=function(r,e,o){if(0==r.length)return[];var s=[],h=r.length,a=0,d=0,u=this.$wrapAsCode,l=this.$indentedSoftWrap,g=e<=Math.max(2*o,8)||!1===l?0:Math.floor(e/2);function t(e){for(var t=e-a,i=a;i<e;i++){var n=r[i];12!==n&&2!==n||--t}s.length||(c=function(){var e=0;if(0===g)return e;if(l)for(var t=0;t<r.length;t++){var i=r[t];if(10==i)e+=1;else if(11==i)e+=o;else if(12!=i)break}return u&&!1!==l&&(e+=o),Math.min(e,g)}(),s.indent=c),d+=t,s.push(d),a=e}for(var c=0;e-c<h-a;){var i=a+e-c;if(10<=r[i-1]&&10<=r[i])t(i);else if(r[i]!=p&&r[i]!=m){for(var n=Math.max(i-(e-(e>>2)),a-1);n<i&&r[i]<p;)i--;if(u){for(;n<i&&r[i]<p;)i--;for(;n<i&&9==r[i];)i--}else for(;n<i&&r[i]<10;)i--;n<i?t(++i):(2==r[i=a+e]&&i--,t(i-c))}else{for(;i!=a-1&&r[i]!=p;i--);if(a<i)t(i);else{for(i=a+e;i<r.length&&r[i]==m;i++);if(i==r.length)break;t(i)}}}return s},this.$getDisplayTokens=function(e,t){var i,n=[];t=t||0;for(var r=0;r<e.length;r++){var o=e.charCodeAt(r);if(9==o){i=this.getScreenTabSize(n.length+t),n.push(11);for(var s=1;s<i;s++)n.push(12)}else 32==o?n.push(10):39<o&&o<48||57<o&&o<64?n.push(9):4352<=o&&a(o)?n.push(1,2):n.push(1)}return n},this.$getStringScreenWidth=function(e,t,i){if(0==t)return[0,0];var n,r;for(null==t&&(t=1/0),i=i||0,r=0;r<e.length&&(9==(n=e.charCodeAt(r))?i+=this.getScreenTabSize(i):4352<=n&&a(n)?i+=2:i+=1,!(t<i));r++);return[i,r]},this.lineWidgets=null,this.getRowLength=function(e){var t=1;return this.lineWidgets&&(t+=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0),this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+t:t},this.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},this.getRowWrapIndent=function(e){var t;return this.$useWrapMode?(e=this.screenToDocumentPosition(e,Number.MAX_VALUE),(t=this.$wrapData[e.row]).length&&t[0]<e.column?t.indent:0):0},this.getScreenLastRowColumn=function(e){e=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(e.row,e.column)},this.getDocumentLastRowColumn=function(e,t){e=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(e)},this.getDocumentLastRowColumnPosition=function(e,t){e=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(e,Number.MAX_VALUE/10)},this.getRowSplitData=function(e){if(this.$useWrapMode)return this.$wrapData[e]},this.getScreenTabSize=function(e){return this.$tabSize-(e%this.$tabSize|0)},this.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},this.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},this.screenToDocumentPosition=function(e,h,d){if(e<0)return{row:0,column:0};for(var t,u,g,i=0,n=0,r=0,p=0,o=this.$screenRowCache,s=this.$getRowCacheIndex(o,e),a=o.length,l=(g=a&&0<=s?(r=o[s],i=this.$docRowCache[s],e>o[a-1]):!a,this.getLength()-1),c=this.getNextFoldLine(i),m=c?c.start.row:1/0;r<=e&&!(e<r+(p=this.getRowLength(i))||l<=i);)r+=p,m<++i&&(i=c.end.row+1,m=(c=this.getNextFoldLine(i,c))?c.start.row:1/0),g&&(this.$docRowCache.push(i),this.$screenRowCache.push(r));if(c&&c.start.row<=i)t=this.getFoldDisplayLine(c),i=c.start.row;else{if(r+p<=e||l<i)return{row:l,column:this.getLine(l).length};t=this.getLine(i),c=null}s=0,o=Math.floor(e-r);return!this.$useWrapMode||(a=this.$wrapData[i])&&(u=a[o],0<o&&a.length&&(s=a.indent,n=a[o-1]||a[a.length-1],t=t.substring(n))),void 0!==d&&this.$bidiHandler.isBidiRow(r+o,i,o)&&(h=this.$bidiHandler.offsetToCol(d)),n+=this.$getStringScreenWidth(t,h-s)[1],this.$useWrapMode&&u<=n&&(n=u-1),c?c.idxToPosition(n):{row:i,column:n}},this.documentToScreenPosition=function(e,t){var h=void 0===t?this.$clipPositionToDocument(e.row,e.column):this.$clipPositionToDocument(e,t),i=(e=h.row,t=h.column,0),h=null;(o=this.getFoldAt(e,t,1))&&(e=o.start.row,t=o.start.column);for(var n,d,r=0,o=this.$docRowCache,s=this.$getRowCacheIndex(o,e),u=o.length,a=(d=u&&0<=s?(r=o[s],i=this.$screenRowCache[s],e>o[u-1]):!u,this.getNextFoldLine(r)),g=a?a.start.row:1/0;r<e;){if(g<=r){if(e<(n=a.end.row+1))break;g=(a=this.getNextFoldLine(n,a))?a.start.row:1/0}else n=r+1;i+=this.getRowLength(r),r=n,d&&(this.$docRowCache.push(r),this.$screenRowCache.push(i))}var l="",h=a&&g<=r?(l=this.getFoldDisplayLine(a,e,t),a.start.row):(l=this.getLine(e).substring(0,t),e),s=0;if(this.$useWrapMode){var c=this.$wrapData[h];if(c){for(var p=0;l.length>=c[p];)i++,p++;l=l.substring(c[p-1]||0,l.length),s=0<p?c.indent:0}}return this.lineWidgets&&this.lineWidgets[r]&&this.lineWidgets[r].rowsAbove&&(i+=this.lineWidgets[r].rowsAbove),{row:i,column:s+this.$getStringScreenWidth(l)[0]}},this.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},this.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},this.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var i=this.$wrapData.length,n=0,r=0,o=(t=this.$foldData[r++])?t.start.row:1/0;n<i;){var s=this.$wrapData[n];e+=s?s.length+1:1,o<++n&&(n=t.end.row+1,o=(t=this.$foldData[r++])?t.start.row:1/0)}else for(var e=this.getLength(),a=this.$foldData,r=0;r<a.length;r++)e-=(t=a[r]).end.row-t.start.row;return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},this.$setFontMetrics=function(o){this.$enableVarChar&&(this.$getStringScreenWidth=function(e,t,i){if(0===t)return[0,0];var n,r;for(t=t||1/0,i=i||0,r=0;r<e.length&&!(t<(i+="\t"===(n=e.charAt(r))?this.getScreenTabSize(i):o.getCharacterWidth(n)));r++);return[i,r]})},this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null),this.$stopWorker(),this.removeAllListeners(),this.doc&&this.doc.off("change",this.$onChange),this.selection.detach()},this.isFullWidth=a}.call(i.prototype),e("./edit_session/folding").Folding.call(i.prototype),e("./edit_session/bracket_match").BracketMatch.call(i.prototype),s.defineOptions(i.prototype,"session",{wrap:{set:function(e){e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e&&((this.$wrap=e)?(this.setWrapLimitRange(e="number"==typeof e?e:null,e),this.setUseWrapMode(!0)):this.setUseWrapMode(!1))},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){(e="auto"==e?"text"!=this.$mode.type:"text"!=e)!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0)))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){0<(e=parseInt(e))&&this.$tabSize!==e&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},foldStyle:{set:function(e){this.setFoldStyle(e)},handlesSet:!0},overwrite:{set:function(e){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId},handlesSet:!0}}),t.EditSession=i}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(){this.$options={}}var I=e("./lib/lang"),r=e("./lib/oop"),v=e("./range").Range;!function(){this.set=function(e){return r.mixin(this.$options,e),this},this.getOptions=function(){return I.copyObject(this.$options)},this.setOptions=function(e){this.$options=e},this.find=function(e){var r=this.$options,e=this.$matchIterator(e,r);if(!e)return!1;var o=null;return e.forEach(function(e,t,i,n){return o=new v(e,t,i,n),!(t==n&&r.start&&r.start.start&&0!=r.skipCurrent&&o.isEqual(r.start))||(o=null,!1)}),o},this.findAll=function(h){var e=this.$options;if(!e.needle)return[];this.$assembleRegExp(e);var t=e.range,i=t?h.getLines(t.start.row,t.end.row):h.doc.getAllLines(),n=[],r=e.re;if(e.$isMultiLine){var o,s=r.length,d=i.length-s;e:for(var a=r.offset||0;a<=d;a++){for(var l=0;l<s;l++)if(-1==i[a+l].search(r[l]))continue e;var u=i[a],g=i[a+s-1],u=u.length-u.match(r[0])[0].length,g=g.match(r[s-1])[0].length;o&&o.end.row===a&&o.end.column>u||(n.push(o=new v(a,u,a+s-1,g)),2<s&&(a=a+s-2))}}else for(var c=0;c<i.length;c++)for(var p=I.getMatchOffsets(i[c],r),l=0;l<p.length;l++){var m=p[l];n.push(new v(c,m.offset,c,m.offset+m.length))}if(t){for(var f=t.start.column,C=t.start.column,c=0,l=n.length-1;c<l&&n[c].start.column<f&&n[c].start.row==t.start.row;)c++;for(;c<l&&n[l].end.column>C&&n[l].end.row==t.end.row;)l--;for(n=n.slice(c,l+1),c=0,l=n.length;c<l;c++)n[c].start.row+=t.start.row,n[c].end.row+=t.start.row}return n},this.replace=function(e,t){var i=this.$options,n=this.$assembleRegExp(i);if(i.$isMultiLine)return t;if(n){var r=n.exec(e);if(!r||r[0].length!=e.length)return null;if(t=e.replace(n,t),i.preserveCase){t=t.split("");for(var o=Math.min(e.length,e.length);o--;){var s=e[o];s&&s.toLowerCase()!=s?t[o]=t[o].toUpperCase():t[o]=t[o].toLowerCase()}t=t.join("")}return t}},this.$assembleRegExp=function(e,t){if(e.needle instanceof RegExp)return e.re=e.needle;var i,n=e.needle;if(!e.needle)return e.re=!1;function r(e){return/\w/.test(e)||i.regExp?"\\b":""}e.regExp||(n=I.escapeRegExp(n)),e.wholeWord&&(i=e,n=r((o=n)[0])+o+r(o[o.length-1]));var o=e.caseSensitive?"gm":"gmi";if(e.$isMultiLine=!t&&/[\n\r]/.test(n),e.$isMultiLine)return e.re=this.$assembleMultilineRegExp(n,o);try{var s=new RegExp(n,o)}catch(e){s=!1}return e.re=s},this.$assembleMultilineRegExp=function(e,t){for(var i=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),n=[],r=0;r<i.length;r++)try{n.push(new RegExp(i[r],t))}catch(e){return!1}return n},this.$matchIterator=function(h,i){var d=this.$assembleRegExp(i);if(!d)return!1;var a,n,l=1==i.backwards,t=0!=i.skipCurrent,e=i.range,r=i.start,o=((r=r||(e?e[l?"end":"start"]:h.selection.getRange())).start&&(r=r[t!=l?"end":"start"]),e?e.start.row:0),s=e?e.end.row:h.getLength()-1;return n=i.$isMultiLine?(a=d.length,function(e,t,i){var n=l?e-a+1:e;if(!(n<0||n+a>h.getLength())){var r=h.getLine(n),e=r.search(d[0]);if(!(!l&&e<t||-1===e)){for(var o=1;o<a;o++)if(-1==(r=h.getLine(n+o)).search(d[o]))return;var s=r.match(d[a-1])[0].length;if(!(l&&t<s))return!!i(n,e,n+a-1,s)||void 0}}}):l?function(e,t,i){var n,r=h.getLine(e),o=[];for(d.lastIndex=0;n=d.exec(r);){var s=n[0].length,a=n.index;if(!s){if(a>=r.length)break;d.lastIndex=a+=1}if(n.index+s>t)break;o.push(n.index,s)}for(var l=o.length-1;0<=l;l-=2){var c=o[l-1];if(i(e,c,e,c+(s=o[l])))return!0}}:function(e,t,i){var n=h.getLine(e);for(d.lastIndex=t;r=d.exec(n);){var r,o=r[0].length;if(i(e,r=r.index,e,r+o))return!0;if(!o&&(d.lastIndex=r+=1,r>=n.length))return!1}},{forEach:l?function(e){var t=r.row;if(!n(t,r.column,e)){for(t--;o<=t;t--)if(n(t,Number.MAX_VALUE,e))return;if(0!=i.wrap)for(t=s,o=r.row;o<=t;t--)if(n(t,Number.MAX_VALUE,e))return}}:function(e){var t=r.row;if(!n(t,r.column,e)){for(t+=1;t<=s;t++)if(n(t,0,e))return;if(0!=i.wrap)for(t=o,s=r.row;t<=s;t++)if(n(t,0,e))return}}}}}.call(n.prototype),t.Search=n}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t,i){"use strict";var a=e("../lib/keys"),n=e("../lib/useragent"),l=a.KEY_MODS;function r(e,t){this.platform=t||(n.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=!0}function o(e,t){r.call(this,e,t),this.$singleCommand=!1}o.prototype=r.prototype,function(){function s(e){return"object"==typeof e&&e.bindKey&&e.bindKey.position||(e.isDefault?-100:0)}this.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),(this.commands[e.name]=e).bindKey&&this._buildKeyHash(e)},this.removeCommand=function(e,t){var i,n=e&&("string"==typeof e?e:e.name),r=(e=this.commands[n],t||delete this.commands[n],this.commandKeyBinding);for(i in r){var o,s=r[i];s==e?delete r[i]:!Array.isArray(s)||-1!=(o=s.indexOf(e))&&(s.splice(o,1),1==s.length&&(r[i]=s[0]))}},this.bindKey=function(e,n,r){if("object"==typeof e&&e&&(null==r&&(r=e.position),e=e[this.platform]),e)return"function"==typeof n?this.addCommand({exec:n,bindKey:e,name:n.name||e}):void e.split("|").forEach(function(e){var t="",i=(-1!=e.indexOf(" ")&&(e=(i=e.split(/\s+/)).pop(),i.forEach(function(e){e=this.parseKeys(e),e=l[e.hashId]+e.key;t+=(t?" ":"")+e,this._addCommandToBinding(t,"chainKeys")},this),t+=" "),this.parseKeys(e)),e=l[i.hashId]+i.key;this._addCommandToBinding(t+e,n,r)},this)},this._addCommandToBinding=function(e,t,i){var n=this.commandKeyBinding;if(t)if(!n[e]||this.$singleCommand)n[e]=t;else{Array.isArray(n[e])?-1!=(o=n[e].indexOf(t))&&n[e].splice(o,1):n[e]=[n[e]],"number"!=typeof i&&(i=s(t));for(var r=n[e],o=0;o<r.length;o++)if(i<s(r[o]))break;r.splice(o,0,t)}else delete n[e]},this.addCommands=function(i){i&&Object.keys(i).forEach(function(e){var t=i[e];if(t){if("string"==typeof t)return this.bindKey(t,e);"object"==typeof(t="function"==typeof t?{exec:t}:t)&&(t.name||(t.name=e),this.addCommand(t))}},this)},this.removeCommands=function(t){Object.keys(t).forEach(function(e){this.removeCommand(t[e])},this)},this.bindKeys=function(t){Object.keys(t).forEach(function(e){this.bindKey(e,t[e])},this)},this._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},this.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(e){return e}),i=t.pop(),n=a[i];if(a.FUNCTION_KEYS[n])i=a.FUNCTION_KEYS[n].toLowerCase();else{if(!t.length)return{key:i,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:i.toUpperCase(),hashId:-1}}for(var r=0,o=t.length;o--;){var s=a.KEY_MODS[t[o]];if(null==s)return"undefined"!=typeof console&&console.error("invalid modifier "+t[o]+" in "+e),!1;r|=s}return{key:i,hashId:r}},this.findKeyCommand=function(e,t){e=l[e]+t;return this.commandKeyBinding[e]},this.handleKeyboard=function(e,t,i,n){var r,o;if(!(n<0))return r=l[t]+i,o=this.commandKeyBinding[r],e.$keyChain&&(e.$keyChain+=" "+r,o=this.commandKeyBinding[e.$keyChain]||o),!o||"chainKeys"!=o&&"chainKeys"!=o[o.length-1]?(e.$keyChain&&(t&&4!=t||1!=i.length?(-1==t||0<n)&&(e.$keyChain=""):e.$keyChain=e.$keyChain.slice(0,-r.length-1)),{command:o}):(e.$keyChain=e.$keyChain||r,{command:"null"})},this.getStatusText=function(e,t){return t.$keyChain||""}}.call(r.prototype),t.HashHandler=r,t.MultiHashHandler=o}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e,t){o.call(this,t,e),this.byName=this.commands,this.setDefaultHandler("exec",function(e){return e.command.exec(e.editor,e.args||{})})}var r=e("../lib/oop"),o=e("../keyboard/hash_handler").MultiHashHandler,s=e("../lib/event_emitter").EventEmitter;r.inherits(n,o),function(){r.implement(this,s),this.exec=function(e,t,i){if(Array.isArray(e)){for(var n=e.length;n--;)if(this.exec(e[n],t,i))return!0;return!1}if(!(e="string"==typeof e?this.commands[e]:e))return!1;if(t&&t.$readOnly&&!e.readOnly)return!1;if(0!=this.$checkCommandState&&e.isAvailable&&!e.isAvailable(t))return!1;var r={editor:t,command:e,args:i};return r.returnValue=this._emit("exec",r),this._signal("afterExec",r),!1!==r.returnValue},this.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.off("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},this.replay=function(t){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(t);try{this.$inReplay=!0,this.macro.forEach(function(e){"string"==typeof e?this.exec(e,t):this.exec(e[0],t,e[1])},this)}finally{this.$inReplay=!1}}},this.trimMacro=function(e){return e.map(function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e=!e[1]?e[0]:e})}}.call(n.prototype),t.CommandManager=n}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(e,t,i){"use strict";var l=e("../lib/lang"),n=e("../config"),c=e("../range").Range;function r(e,t){return{win:e,mac:t}}t.commands=[{name:"showSettingsMenu",description:"Show settings menu",bindKey:r("Ctrl-,","Command-,"),exec:function(t){n.loadModule("ace/ext/settings_menu",function(e){e.init(t),t.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",description:"Go to next error",bindKey:r("Alt-E","F4"),exec:function(t){n.loadModule("./ext/error_marker",function(e){e.showErrorMarker(t,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",description:"Go to previous error",bindKey:r("Alt-Shift-E","Shift-F4"),exec:function(t){n.loadModule("./ext/error_marker",function(e){e.showErrorMarker(t,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:r("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:r(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:r("Ctrl-L","Command-L"),exec:function(e,t){"number"!=typeof t||isNaN(t)||e.gotoLine(t),e.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:r("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:r("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",description:"Toggle fold widget",bindKey:r("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",description:"Toggle parent fold widget",bindKey:r("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:r(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldAllComments",description:"Fold all comments",bindKey:r(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAllComments()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:r("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:r("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:r("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:r("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:r("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:r("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:r("Ctrl-F","Command-F"),exec:function(t){n.loadModule("ace/ext/searchbox",function(e){e.Search(t)})},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:r("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:r("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:r("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:r("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:r("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:r("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:r("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:r("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:r("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",bindKey:r("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:r("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:r("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:r("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:r("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",bindKey:r("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:r("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:r("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:r("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:r("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",bindKey:r("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:r(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:r("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:r(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:r("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:r("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:r("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:r("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:r("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:r("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:r("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:r(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(e){},readOnly:!0},{name:"cut",description:"Cut",exec:function(e){var t=e.$copyWithEmptySelection&&e.selection.isEmpty()?e.selection.getLineRange():e.selection.getRange();e._emit("cut",t),t.isEmpty()||e.session.remove(t),e.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(e,t){e.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:r("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:r("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:r("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:r("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:r("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:r("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:r("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:r("Ctrl-H","Command-Option-F"),exec:function(t){n.loadModule("ace/ext/searchbox",function(e){e.Search(t,!0)})}},{name:"undo",description:"Undo",bindKey:r("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",description:"Redo",bindKey:r("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:r("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:r("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:r("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:r("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:r("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:r("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:r("Shift-Delete",null),exec:function(e){if(!e.selection.isEmpty())return!1;e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:r("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:r("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:r("Ctrl-Shift-Backspace",null),exec:function(e){var t=e.selection.getRange();t.start.column=0,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:r("Ctrl-Shift-Delete",null),exec:function(e){var t=e.selection.getRange();t.end.column=Number.MAX_VALUE,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:r("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:r("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:r("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:r("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:r("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:r("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(e,t){e.insert(l.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:r(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{
name:"transposeletters",description:"Transpose letters",bindKey:r("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:r("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:r("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"autoindent",description:"Auto Indent",bindKey:r(null,null),exec:function(e){e.autoIndent()},multiSelectAction:"forEachLine",scrollIntoView:"animate"},{name:"expandtoline",description:"Expand to line",bindKey:r("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",description:"Join lines",bindKey:r(null,null),exec:function(e){for(var t=e.selection.isBackwards(),i=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),n=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),t=e.session.doc.getLine(i.row).length,r=e.session.doc.getTextRange(e.selection.getRange()).replace(/\n\s*/," ").length,o=e.session.doc.getLine(i.row),s=i.row+1;s<=n.row+1;s++){var a=l.stringTrimLeft(l.stringTrimRight(e.session.doc.getLine(s)));o+=a=0!==a.length?" "+a:a}n.row+1<e.session.doc.getLength()-1&&(o+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new c(i.row,0,n.row+2,0),o),0<r?(e.selection.moveCursorTo(i.row,i.column),e.selection.selectTo(i.row,i.column+r)):(t=e.session.doc.getLine(i.row).length>t?t+1:t,e.selection.moveCursorTo(i.row,t))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",description:"Invert selection",bindKey:r(null,null),exec:function(e){var t=e.session.doc.getLength()-1,i=e.session.doc.getLine(t).length,n=e.selection.rangeList.ranges,r=[];n.length<1&&(n=[e.selection.getRange()]);for(var o=0;o<n.length;o++)o==n.length-1&&(n[o].end.row===t&&n[o].end.column===i||r.push(new c(n[o].end.row,n[o].end.column,t,i))),0===o?0===n[o].start.row&&0===n[o].start.column||r.push(new c(0,0,n[o].start.row,n[o].start.column)):r.push(new c(n[o-1].end.row,n[o-1].end.column,n[o].start.row,n[o].start.column));e.exitMultiSelectMode(),e.clearSelection();for(o=0;o<r.length;o++)e.selection.addRange(r[o],!1)},readOnly:!0,scrollIntoView:"none"},{name:"addLineAfter",description:"Add new line after the current line",exec:function(e){e.selection.clearSelection(),e.navigateLineEnd(),e.insert("\n")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"addLineBefore",description:"Add new line before the current line",exec:function(e){e.selection.clearSelection();var t=e.getCursorPosition();e.selection.moveTo(t.row-1,Number.MAX_VALUE),e.insert("\n"),0===t.row&&e.navigateUp()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"openCommandPallete",description:"Open command pallete",bindKey:r("F1","F1"),exec:function(e){e.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:r(null,null),exec:function(e){e.prompt({$type:"modes"})},readOnly:!0}];for(var o=1;o<9;o++)t.commands.push({name:"foldToLevel"+o,description:"Fold To Level "+o,level:o,exec:function(e){e.session.foldToLevel(this.level)},scrollIntoView:"center",readOnly:!0})}),ace.define("ace/editor",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator","ace/clipboard"],function(e,n,l){"use strict";e("./lib/fixoldbrowsers");function r(e,t,i){this.$toDestroy=[];var n=e.getContainerElement();this.container=n,this.renderer=e,this.id="editor"+ ++r.$uid,this.commands=new A(c.isMac?"mac":"win",b),"object"==typeof document&&(this.textInput=new h(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new d(this),new u(this)),this.keyBinding=new g(this),this.$search=(new I).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=m.delayedCall(function(){this._signal("input",{}),this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",function(e,t){t._$emitInputEvent.schedule(31)}),this.setSession(t||i&&i.session||new p("")),s.resetOptions(this),i&&this.setOptions(i),s._signal("editor",this)}var o=e("./lib/oop"),i=e("./lib/dom"),m=e("./lib/lang"),c=e("./lib/useragent"),h=e("./keyboard/textinput").TextInput,d=e("./mouse/mouse_handler").MouseHandler,u=e("./mouse/fold_handler").FoldHandler,g=e("./keyboard/keybinding").KeyBinding,p=e("./edit_session").EditSession,I=e("./search").Search,f=e("./range").Range,v=e("./lib/event_emitter").EventEmitter,A=e("./commands/command_manager").CommandManager,b=e("./commands/default_commands").commands,s=e("./config"),C=e("./token_iterator").TokenIterator,a=e("./clipboard"),t=(r.$uid=0,function(){o.implement(this,v),this.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=m.delayedCall(this.endOperation.bind(this,!0)),this.on("change",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp=this.session.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop},this.curOp.selectionBefore=this.selection.toJSON()},this.endOperation=function(e){if(this.curOp&&this.session){if(e&&!1===e.returnValue||!this.session)return this.curOp=null;if((1!=e||!this.curOp.command||"mouse"!=this.curOp.command.name)&&(this._signal("beforeEndOperation"),this.curOp)){var e=this.curOp.command,t=e&&e.scrollIntoView;if(t){switch(t){case"center-animate":t="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var i=this.selection.getRange(),n=this.renderer.layerConfig;(i.start.row>=n.lastRow||i.end.row<=n.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==t&&this.renderer.animateScrolling(this.curOp.scrollTop)}e=this.selection.toJSON();this.curOp.selectionAfter=e,this.$lastSel=this.selection.toJSON(),this.session.getUndoManager().addSelection(e),this.prevOp=this.curOp,this.curOp=null}}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(e){var t,i,n,r;this.$mergeUndoDeltas&&(t=this.prevOp,i=this.$mergeableCommands,n=t.command&&e.command.name==t.command.name,"insertstring"==e.command.name?(r=e.args,void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),n=n&&this.mergeNextCommand&&(!/\s/.test(r)||/\s/.test(t.args)),this.mergeNextCommand=!0):n=n&&-1!==i.indexOf(e.command.name),(n="always"!=this.$mergeUndoDeltas&&2e3<Date.now()-this.sequenceStartTime?!1:n)?this.session.mergeUndoDeltas=!0:-1!==i.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now()))},this.setKeyboardHandler=function(t,i){var n;t&&"string"==typeof t&&"ace"!=t?(this.$keybindingId=t,n=this,s.loadModule(["keybinding",t],function(e){n.$keybindingId==t&&n.keyBinding.setKeyboardHandler(e&&e.handler),i&&i()})):(this.$keybindingId=null,this.keyBinding.setKeyboardHandler(t),i&&i())},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(e){var t,i;this.session!=e&&(this.curOp&&this.endOperation(),this.curOp={},(t=this.session)&&(this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange),(i=this.session.getSelection()).off("changeCursor",this.$onCursorChange),i.off("changeSelection",this.$onSelectionChange)),(this.session=e)?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.on("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),this.curOp=null,t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this}),e&&e.bgTokenizer&&e.bgTokenizer.scheduleStart())},this.getSession=function(){return this.session},this.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(e){this.renderer.onResize(e)},this.setTheme=function(e,t){this.renderer.setTheme(e,t)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(e){this.renderer.setStyle(e)},this.unsetStyle=function(e){this.renderer.unsetStyle(e)},this.getFontSize=function(){return this.getOption("fontSize")||i.computedStyle(this.container).fontSize},this.setFontSize=function(e){this.setOption("fontSize",e)},this.$highlightBrackets=function(){var n;this.$highlightPending||((n=this).$highlightPending=!0,setTimeout(function(){n.$highlightPending=!1;var e,t,i=n.session;i&&i.bgTokenizer&&(i.$bracketHighlight&&(i.$bracketHighlight.markerIds.forEach(function(e){i.removeMarker(e)}),i.$bracketHighlight=null),(e=!(e=i.getMatchingBracketRanges(n.getCursorPosition()))&&i.$mode.getMatching?i.$mode.getMatching(n.session):e)&&(t="ace_bracket",Array.isArray(e)?1==e.length&&(t="ace_error_bracket"):e=[e],2==e.length&&(0==f.comparePoints(e[0].end,e[1].start)?e=[f.fromPoints(e[0].start,e[1].end)]:0==f.comparePoints(e[0].start,e[1].end)&&(e=[f.fromPoints(e[1].start,e[0].end)])),i.$bracketHighlight={ranges:e,markerIds:e.map(function(e){return i.addMarker(e,t,"text")})}))},50))},this.$highlightTags=function(){var u;this.$highlightTagPending||((u=this).$highlightTagPending=!0,setTimeout(function(){u.$highlightTagPending=!1;var e=u.session;if(e&&e.bgTokenizer){var t=u.getCursorPosition(),i=new C(u.session,t.row,t.column),n=i.getCurrentToken();if(!n||!/\b(?:tag-open|tag-name)/.test(n.type))return e.removeMarker(e.$tagHighlight),void(e.$tagHighlight=null);if(-1===n.type.indexOf("tag-open")||(n=i.stepForward())){var r=n.value,o=n.value,s=0,a=i.stepBackward();if("<"===a.value)for(;a=n,(n=i.stepForward())&&(-1!==n.type.indexOf("tag-name")?r===(o=n.value)&&("<"===a.value?s++:"</"===a.value&&s--):r===o&&"/>"===n.value&&s--),n&&0<=s;);else{do{if(n=a,a=i.stepBackward(),n)if(-1!==n.type.indexOf("tag-name"))r===n.value&&("<"===a.value?s++:"</"===a.value&&s--);else if("/>"===n.value){for(var h=0,l=a;l;){if(-1!==l.type.indexOf("tag-name")&&l.value===r){s--;break}if("<"===l.value)break;l=i.stepBackward(),h++}for(var d=0;d<h;d++)i.stepForward()}}while(a&&s<=0);i.stepForward()}if(!n)return e.removeMarker(e.$tagHighlight),void(e.$tagHighlight=null);var t=i.getCurrentTokenRow(),c=i.getCurrentTokenColumn(),t=new f(t,c,t,c+n.value.length),c=e.$backMarkers[e.$tagHighlight];e.$tagHighlight&&null!=c&&0!==t.compareRange(c.range)&&(e.removeMarker(e.$tagHighlight),e.$tagHighlight=null),e.$tagHighlight||(e.$tagHighlight=e.addMarker(t,"ace_bracket","text"))}}},50))},this.focus=function(){var e=this;setTimeout(function(){e.isFocused()||e.textInput.focus()}),this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},this.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},this.$cursorChange=function(){this.renderer.updateCursor(),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine()},this.onDocumentChange=function(e){var t=this.session.$useWrapMode,i=e.start.row==e.end.row?e.end.row:1/0;this.renderer.updateLines(e.start.row,i,t),this._signal("change",e),this.$cursorChange()},this.onTokenizerUpdate=function(e){e=e.data;this.renderer.updateLines(e.first,e.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var e,t,i=this.getSession();this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(e=!1),!this.renderer.$maxLines||1!==this.session.getLength()||1<this.renderer.$minLines||(e=!1)),i.$highlightLineMarker&&!e?(i.removeMarker(i.$highlightLineMarker.id),i.$highlightLineMarker=null):!i.$highlightLineMarker&&e?((t=new f(e.row,e.column,e.row,1/0)).id=i.addMarker(t,"ace_active-line","screenLine"),i.$highlightLineMarker=t):e&&(i.$highlightLineMarker.start.row=e.row,i.$highlightLineMarker.end.row=e.row,i.$highlightLineMarker.start.column=e.column,i._signal("changeBackMarker"))},this.onSelectionChange=function(e){var t,i,n=this.session,n=(n.$selectionMarker&&n.removeMarker(n.$selectionMarker),n.$selectionMarker=null,this.selection.isEmpty()?this.$updateHighlightActiveLine():(t=this.selection.getRange(),i=this.getSelectionStyle(),n.$selectionMarker=n.addMarker(t,"ace_selection",i)),this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp());this.session.highlight(n),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var i=t.start.column,n=t.end.column,e=e.getLine(t.start.row),t=e.substring(i,n);if(!(5e3<t.length)&&/[\w\d]/.test(t)){t=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:t}),e=e.substring(i-1,n+1);if(t.test(e))return t}}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var e=this.getSelectedText(),t=this.session.doc.getNewLineCharacter(),i=!1;if(!e&&this.$copyWithEmptySelection)for(var i=!0,n=this.selection.getAllRanges(),r=0;r<n.length;r++){var o=n[r];r&&n[r-1].start.row==o.start.row||(e+=this.session.getLine(o.start.row)+t)}var s={text:e};return this._signal("copy",s),a.lineMode=!!i&&s.text,s.text},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(e,t){this.commands.exec("paste",this,{text:e,event:t})},this.$handlePaste=function(e){this._signal("paste",e="string"==typeof e?{text:e}:e);var t=e.text,e=t===a.lineMode,i=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)e?i.insert({row:this.selection.lead.row,column:0},t):this.insert(t);else if(e)this.selection.rangeList.ranges.forEach(function(e){i.insert({row:e.start.row,column:0},t)});else{var n=t.split(/\r\n|\r|\n/),r=this.selection.rangeList.ranges,e=!(2!=n.length||n[0]&&n[1]);if(n.length!=r.length||e)return this.commands.exec("insertstring",this,t);for(var o=r.length;o--;){var s=r[o];s.isEmpty()||i.remove(s),i.insert(s.start,n[o])}}},this.execCommand=function(e,t){return this.commands.exec(e,this,t)},this.insert=function(e,t){var i,n=this.session,r=n.getMode(),o=this.getCursorPosition(),s=(!this.getBehavioursEnabled()||t||(i=r.transformAction(n.getState(o.row),"insertion",this,n,e))&&(e!==i.text&&(this.inVirtualSelectionMode||(this.session.mergeUndoDeltas=!1,this.mergeNextCommand=!1)),e=i.text),"\t"==e&&(e=this.session.getTabString()),this.selection.isEmpty()?this.session.getOverwrite()&&-1==e.indexOf("\n")&&((s=new f.fromPoints(o,o)).end.column+=e.length,this.session.remove(s)):(s=this.getSelectionRange(),o=this.session.remove(s),this.clearSelection()),"\n"!=e&&"\r\n"!=e||(a=n.getLine(o.row),o.column>a.search(/\S|$/)&&(t=a.substr(o.column).search(/\S|$/),n.doc.removeInLine(o.row,o.column,o.column+t))),this.clearSelection(),o.column),t=n.getState(o.row),a=n.getLine(o.row),l=r.checkOutdent(t,a,e);n.insert(o,e),i&&i.selection&&(2==i.selection.length?this.selection.setSelectionRange(new f(o.row,s+i.selection[0],o.row,s+i.selection[1])):this.selection.setSelectionRange(new f(o.row+i.selection[0],i.selection[1],o.row+i.selection[2],i.selection[3]))),this.$enableAutoIndent&&(n.getDocument().isNewLine(e)&&(s=r.getNextLineIndent(t,a.slice(0,o.column),n.getTabString()),n.insert({row:o.row+1,column:0},s)),l&&r.autoOutdent(t,n,o.row))},this.autoIndent=function(){for(var e,t,i,n,r,o=this.session,s=o.getMode(),a=(i=this.selection.isEmpty()?(t=0,o.doc.getLength()-1):(t=(e=this.getSelectionRange()).start.row,e.end.row),""),l="",h=o.getTabString(),c=t;c<=i;c++)0<c&&(a=o.getState(c-1),n=o.getLine(c-1),l=s.getNextLineIndent(a,n,h)),n=o.getLine(c),l!==(r=s.$getIndent(n))&&(0<r.length&&(r=new f(c,0,c,r.length),o.remove(r)),0<l.length&&o.insert({row:c,column:0},l)),s.autoOutdent(a,o,c)},this.onTextInput=function(e,t){if(!t)return this.keyBinding.onTextInput(e);this.startOperation({command:{name:"insertstring"}});e=this.applyComposition.bind(this,e,t);this.selection.rangeCount?this.forEachSelection(e):e(),this.endOperation()},this.applyComposition=function(e,t){var i;(t.extendLeft||t.extendRight)&&((i=this.selection.getRange()).start.column-=t.extendLeft,i.end.column+=t.extendRight,i.start.column<0&&(i.start.row--,i.start.column+=this.session.getLine(i.start.row).length+1),this.selection.setRange(i),e||i.isEmpty()||this.remove()),!e&&this.selection.isEmpty()||this.insert(e,!0),(t.restoreStart||t.restoreEnd)&&((i=this.selection.getRange()).start.column-=t.restoreStart,i.end.column-=t.restoreEnd,this.selection.setRange(i))},this.onCommandKey=function(e,t,i){return this.keyBinding.onCommandKey(e,t,i)},this.setOverwrite=function(e){this.session.setOverwrite(e)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(e){this.setOption("dragDelay",e)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(e){this.setOption("readOnly",e)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t,i,n,e=this.getSelectionRange();this.getBehavioursEnabled()&&(i=(t=this.session).getState(e.start.row),i=t.getMode().transformAction(i,"deletion",this,t,e),0!==e.end.column||"\n"==(n=t.getTextRange(e))[n.length-1]&&(n=t.getLine(e.end.row),/^\s+$/.test(n)&&(e.end.column=n.length)),i&&(e=i)),this.session.remove(e),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.selection.isEmpty()&&this.selection.selectLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},this.transposeLetters=function(){var e,t,i,n;!this.selection.isEmpty()||0!==(t=(e=this.getCursorPosition()).column)&&(n=t<(n=this.session.getLine(e.row)).length?(i=n.charAt(t)+n.charAt(t-1),new f(e.row,t-1,e.row,t+1)):(i=n.charAt(t-1)+n.charAt(t-2),new f(e.row,t-2,e.row,t)),this.session.replace(n,i),this.session.selection.moveToPosition(n.end))},this.toLowerCase=function(){var e=this.getSelectionRange(),t=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),i=this.session.getTextRange(t);this.session.replace(t,i.toLowerCase()),this.selection.setSelectionRange(e)},this.toUpperCase=function(){var e=this.getSelectionRange(),t=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),i=this.session.getTextRange(t);this.session.replace(t,i.toUpperCase()),this.selection.setSelectionRange(e)},this.indent=function(){var e=this.session,t=this.getSelectionRange();if(t.start.row<t.end.row)return r=this.$getSelectedRows(),void e.indentRows(r.first,r.last,"\t");if(t.start.column<t.end.column){var i=e.getTextRange(t);if(!/^\s+$/.test(i))return r=this.$getSelectedRows(),void e.indentRows(r.first,r.last,"\t")}var n=e.getLine(t.start.row),i=t.start,r=e.getTabSize(),e=e.documentToScreenColumn(i.row,i.column);if(this.session.getUseSoftTabs())var o=r-e%r,s=m.stringRepeat(" ",o);else{for(o=e%r;" "==n[t.start.column-1]&&o;)t.start.column--,o--;this.selection.setSelectionRange(t),s="\t"}return this.insert(s)},this.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"\t")},this.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},this.sortLines=function(){for(var e=this.$getSelectedRows(),t=this.session,i=[],n=e.first;n<=e.last;n++)i.push(t.getLine(n));i.sort(function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0});for(var r=new f(0,0,0,0),n=e.first;n<=e.last;n++){var o=t.getLine(n);r.start.row=n,r.end.row=n,r.end.column=o.length,t.replace(r,i[n-e.first])}},this.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},this.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),i=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,i,e)},this.getNumberAt=function(e,t){for(var i=/[\-]?[0-9]+(?:\.[0-9]+)?/g,n=(i.lastIndex=0,this.session.getLine(e));i.lastIndex<t;){var r=i.exec(n);if(r.index<=t&&r.index+r[0].length>=t)return{value:r[0],start:r.index,end:r.index+r[0].length}}return null},this.modifyNumber=function(e){var t,i,n,r=this.selection.getCursor().row,o=this.selection.getCursor().column,s=new f(r,o-1,r,o),s=this.session.getTextRange(s);!isNaN(parseFloat(s))&&isFinite(s)?(s=this.getNumberAt(r,o))&&(n=0<=s.value.indexOf(".")?s.start+s.value.indexOf(".")+1:s.end,t=s.start+s.value.length-n,i=parseFloat(s.value),i*=Math.pow(10,t),n!==s.end&&o<n?e*=Math.pow(10,s.end-o-1):e*=Math.pow(10,s.end-o),n=(i=(i+=e)/Math.pow(10,t)).toFixed(t),e=new f(r,s.start,r,s.end),this.session.replace(e,n),this.moveCursorTo(r,Math.max(s.start+1,o+n.length-s.value.length))):this.toggleWord()},this.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]],this.toggleWord=function(){for(var i,h=this.selection.getCursor().row,d=this.selection.getCursor().column,n=(this.selection.selectWord(),this.getSelectedText()),r=this.selection.getWordRange().start.column,u=n.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),o=d-r-1,s=(o<0&&(o=0),0),a=this,g=(n.match(/[A-Za-z0-9_]+/)&&u.forEach(function(e,t){i=s+e.length,s<=o&&o<=i&&(n=e,a.selection.clearSelection(),a.moveCursorTo(h,s+r),a.selection.selectTo(h,i+r)),s=i}),this.$toggleWordPairs),e=0;e<g.length;e++)for(var l=g[e],t=0;t<=1;t++){var p=+!t,c=n.match(new RegExp("^\\s?_?("+m.escapeRegExp(l[t])+")\\s?$","i"));c&&n.match(new RegExp("([_]|^|\\s)("+m.escapeRegExp(c[1])+")($|\\s)","g"))&&(c=n.replace(new RegExp(m.escapeRegExp(l[t]),"i"),function(e){var t=l[p];return e.toUpperCase()==e?t=t.toUpperCase():e.charAt(0).toUpperCase()==e.charAt(0)&&(t=t.substr(0,0)+l[p].charAt(0).toUpperCase()+t.substr(1)),t}),this.insert(c))}},this.removeLines=function(){var e=this.$getSelectedRows();this.session.removeFullLines(e.first,e.last),this.clearSelection()},this.duplicateSelection=function(){var e,t=this.selection,i=this.session,n=t.getRange(),r=t.isBackwards();n.isEmpty()?(e=n.start.row,i.duplicateLines(e,e)):(e=r?n.start:n.end,i=i.insert(e,i.getTextRange(n),!1),n.start=e,n.end=i,t.setSelectionRange(n,r))},this.moveLinesDown=function(){this.$moveLines(1,!1)},this.moveLinesUp=function(){this.$moveLines(-1,!1)},this.moveText=function(e,t,i){return this.session.moveText(e,t,i)},this.copyLinesUp=function(){this.$moveLines(-1,!0)},this.copyLinesDown=function(){this.$moveLines(1,!0)},this.$moveLines=function(e,t){var i=this.selection;if(!i.inMultiSelectMode||this.inVirtualSelectionMode){var n=i.toOrientedRange(),r=this.$getSelectedRows(n),h=this.session.$moveLines(r.first,r.last,t?0:e);n.moveBy(h=t&&-1==e?0:h,0),i.fromOrientedRange(n)}else{for(var o=i.rangeList.ranges,s=(i.rangeList.detach(this.session),this.inVirtualSelectionMode=!0,0),d=0,u=o.length,a=0;a<u;a++){for(var l=a,g=(o[a].moveBy(s,0),(r=this.$getSelectedRows(o[a])).first),c=r.last;++a<u;){d&&o[a].moveBy(d,0);var p=this.$getSelectedRows(o[a]);if(t&&p.first!=c)break;if(!t&&p.first>c+1)break;c=p.last}for(a--,s=this.session.$moveLines(g,c,t?0:e),t&&-1==e&&(l=a+1);l<=a;)o[l].moveBy(s,0),l++;d+=s=!t?0:s}i.fromOrientedRange(i.ranges[0]),i.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},this.$getSelectedRows=function(e){return e=(e||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},this.onCompositionStart=function(e){this.renderer.showComposition(e)},this.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},this.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(e,t){var i=this.renderer,n=this.renderer.layerConfig,r=e*Math.floor(n.height/n.lineHeight),e=(!0===t?this.selection.$moveSelection(function(){this.moveCursorBy(r,0)}):!1===t&&(this.selection.moveCursorBy(r,0),this.selection.clearSelection()),i.scrollTop);i.scrollBy(0,r*n.lineHeight),null!=t&&i.scrollCursorIntoView(null,.5),i.animateScrolling(e)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(e){this.renderer.scrollToRow(e)},this.scrollToLine=function(e,t,i,n){this.renderer.scrollToLine(e,t,i,n)},this.centerSelection=function(){var e=this.getSelectionRange(),e={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(e,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.selection.selectAll()},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},this.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},this.jumpToMatching=function(h,d){var e=this.getCursorPosition(),t=new C(this.session,e.row,e.column),i=t.getCurrentToken(),n=i||t.stepForward();if(n){var u,r,o,s=!1,a={},l=e.column-n.start,g={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(n.value.match(/[{}()\[\]]/g)){for(;l<n.value.length&&!s;l++)if(g[n.value[l]])switch(r=g[n.value[l]]+"."+n.type.replace("rparen","lparen"),isNaN(a[r])&&(a[r]=0),n.value[l]){case"(":case"[":case"{":a[r]++;break;case")":case"]":case"}":a[r]--,-1===a[r]&&(u="bracket",s=!0)}}else-1!==n.type.indexOf("tag-name")&&(isNaN(a[n.value])&&(a[n.value]=0),"<"===i.value?a[n.value]++:"</"===i.value&&a[n.value]--,-1===a[n.value]&&(u="tag",s=!0))}while(s||(i=n,n=t.stepForward(),l=0),n&&!s);if(u){if("bracket"===u)(c=this.session.getBracketRange(e))||(o=(c=new f(t.getCurrentTokenRow(),t.getCurrentTokenColumn()+l-1,t.getCurrentTokenRow(),t.getCurrentTokenColumn()+l-1)).start,(d||o.row===e.row&&Math.abs(o.column-e.column)<2)&&(c=this.session.getBracketRange(o)));else if("tag"===u){if(!n||-1===n.type.indexOf("tag-name"))return;var c,p=n.value;if(0===(c=new f(t.getCurrentTokenRow(),t.getCurrentTokenColumn()-2,t.getCurrentTokenRow(),t.getCurrentTokenColumn()-2)).compare(e.row,e.column))for(s=!1;n=i,(i=t.stepBackward())&&(-1!==i.type.indexOf("tag-close")&&c.setEnd(t.getCurrentTokenRow(),t.getCurrentTokenColumn()+1),n.value===p&&-1!==n.type.indexOf("tag-name")&&("<"===i.value?a[p]++:"</"===i.value&&a[p]--,0===a[p]&&(s=!0))),i&&!s;);n&&n.type.indexOf("tag-name")&&(o=c.start).row==e.row&&Math.abs(o.column-e.column)<2&&(o=c.end)}(o=c&&c.cursor||o)&&(h?c&&d?this.selection.setRange(c):c&&c.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(o.row,o.column):this.selection.moveTo(o.row,o.column))}}},this.gotoLine=function(e,t,i){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,i)},this.navigateTo=function(e,t){this.selection.moveTo(e,t)},this.navigateUp=function(e){var t;if(this.selection.isMultiLine()&&!this.selection.isBackwards())return t=this.selection.anchor.getPosition(),this.moveCursorToPosition(t);this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},this.navigateDown=function(e){var t;if(this.selection.isMultiLine()&&this.selection.isBackwards())return t=this.selection.anchor.getPosition(),this.moveCursorToPosition(t);this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},this.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(e,t){t&&this.$search.set(t);var t=this.$search.find(this.session),i=0;return t&&(this.$tryReplace(t,e)&&(i=1),this.selection.setSelectionRange(t),this.renderer.scrollSelectionIntoView(t.start,t.end)),i},this.replaceAll=function(e,t){t&&this.$search.set(t);var i=this.$search.findAll(this.session),n=0;if(!i.length)return n;t=this.getSelectionRange();this.selection.moveTo(0,0);for(var r=i.length-1;0<=r;--r)this.$tryReplace(i[r],e)&&n++;return this.selection.setSelectionRange(t),n},this.$tryReplace=function(e,t){var i=this.session.getTextRange(e);return null!==(t=this.$search.replace(i,t))?(e.end=this.session.replace(e,t),e):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(e,t,i){t=t||{},"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&o.mixin(t,e);var n=this.selection.getRange(),e=(null==t.needle&&((e=this.session.getTextRange(n)||this.$search.$options.needle)||(n=this.session.getWordRange(n.start.row,n.start.column),e=this.session.getTextRange(n)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:n}),this.$search.find(this.session));return t.preventScroll?e:e?(this.revealRange(e,i),e):(t.backwards?n.start=n.end:n.end=n.start,void this.selection.setRange(n))},this.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},this.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},this.revealRange=function(e,t){this.session.unfold(e),this.selection.setSelectionRange(e);var i=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),!1!==t&&this.renderer.animateScrolling(i)},this.undo=function(){this.session.getUndoManager().undo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.session.getUndoManager().redo(this.session),this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.$toDestroy&&(this.$toDestroy.forEach(function(e){e.destroy()}),this.$toDestroy=null),this.$mouseHandler&&this.$mouseHandler.destroy(),this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy(),this._$emitInputEvent&&this._$emitInputEvent.cancel(),this.removeAllListeners()},this.setAutoScrollEditorIntoView=function(e){var n,r,o,s,t,i,a;e&&(o=!1,(r=this).$scrollAnchor||(this.$scrollAnchor=document.createElement("div")),(s=this.$scrollAnchor).style.cssText="position:absolute",this.container.insertBefore(s,this.container.firstChild),t=this.on("changeSelection",function(){o=!0}),i=this.renderer.on("beforeRender",function(){o&&(n=r.renderer.container.getBoundingClientRect())}),a=this.renderer.on("afterRender",function(){var e,t,i;o&&n&&(r.isFocused()||r.searchBox&&r.searchBox.isFocused())&&(e=(t=r.renderer).$cursorLayer.$pixelPos,t=t.layerConfig,i=e.top-t.offset,null!=(o=0<=e.top&&i+n.top<0||!(e.top<t.height&&e.top+n.top+t.lineHeight>window.innerHeight)&&null)&&(s.style.top=i+"px",s.style.left=e.left+"px",s.style.height=t.lineHeight+"px",s.scrollIntoView(o)),o=n=null)}),this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",t),this.renderer.off("afterRender",a),this.renderer.off("beforeRender",i))})},this.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,i.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))},this.prompt=function(t,i,n){var r=this;s.loadModule("./ext/prompt",function(e){e.prompt(r,t,i,n)})}}.call(r.prototype),s.defineOptions(r.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(e){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(e){this.textInput.setReadOnly(e),this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(e){this.textInput.setCopyWithEmptySelection(e)},initialValue:!1},cursorStyle:{set:function(e){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},enableAutoIndent:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},keyboardHandler:{set:function(e){this.setKeyboardHandler(e)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(e){this.session.setValue(e)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(e){this.setSession(e)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(e){this.renderer.$gutterLayer.setShowLineNumbers(e),this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER),e&&this.$relativeLineNumbers?t.attach(this):t.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(e){this.$showLineNumbers&&e?t.attach(this):t.detach(this)}},placeholder:{set:function(e){this.$updatePlaceholder||(this.$updatePlaceholder=function(){var e=this.session&&(this.renderer.$composition||this.getValue());e&&this.renderer.placeholderNode?(this.renderer.off("afterRender",this.$updatePlaceholder),i.removeCssClass(this.container,"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null):e||this.renderer.placeholderNode?!e&&this.renderer.placeholderNode&&(this.renderer.placeholderNode.textContent=this.$placeholder||""):(this.renderer.on("afterRender",this.$updatePlaceholder),i.addCssClass(this.container,"ace_hasPlaceholder"),(e=i.createElement("div")).className="ace_placeholder",e.textContent=this.$placeholder||"",this.renderer.placeholderNode=e,this.renderer.content.appendChild(this.renderer.placeholderNode))}.bind(this),this.on("input",this.$updatePlaceholder)),this.$updatePlaceholder()}},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"}),{getText:function(e,t){return(Math.abs(e.selection.lead.row-t)||t+1+(t<9?"·":""))+""},getWidth:function(e,t,i){return Math.max(t.toString().length,(i.lastRow+1).toString().length,2)*i.characterWidth},update:function(e,t){t.renderer.$loop.schedule(t.renderer.CHANGE_GUTTER)},attach:function(e){e.renderer.$gutterLayer.$renderer=this,e.on("changeSelection",this.update),this.update(null,e)},detach:function(e){e.renderer.$gutterLayer.$renderer==this&&(e.renderer.$gutterLayer.$renderer=null),e.off("changeSelection",this.update),this.update(null,e)}});n.Editor=r}),ace.define("ace/undomanager",["require","exports","module","ace/range"],function(t,r,s){"use strict";function e(){this.$maxRev=0,this.$fromUndo=!1,this.reset()}!function(){this.addSession=function(e){this.$session=e},this.add=function(e,t,i){this.$fromUndo||e!=this.$lastDelta&&(this.$keepRedoStack||(this.$redoStack.length=0),!1!==t&&this.lastDeltas||(this.lastDeltas=[],this.$undoStack.push(this.lastDeltas),e.id=this.$rev=++this.$maxRev),"remove"!=e.action&&"insert"!=e.action||(this.$lastDelta=e),this.lastDeltas.push(e))},this.addSelection=function(e,t){this.selections.push({value:e,rev:t||this.$rev})},this.startNewGroup=function(){return this.lastDeltas=null,this.$rev},this.markIgnored=function(e,t){null==t&&(t=this.$rev+1);for(var i=this.$undoStack,n=i.length;n--;){var r=i[n][0];if(r.id<=e)break;r.id<t&&(r.ignore=!0)}this.lastDeltas=null},this.getSelection=function(e,t){for(var i=this.selections,n=i.length;n--;){var r=i[n];if(r.rev<e)return r=t?i[n+1]:r}},this.getRevision=function(){return this.$rev},this.getDeltas=function(e,t){null==t&&(t=this.$rev+1);for(var i=this.$undoStack,n=null,r=0,o=i.length;o--;){var s=i[o][0];if(s.id<t&&!n&&(n=o+1),s.id<=e){r=o+1;break}}return i.slice(r,n)},this.getChangedRanges=function(e,t){null==t&&this.$rev},this.getChangedLines=function(e,t){null==t&&this.$rev},this.undo=function(e,t){this.lastDeltas=null;var i,n=this.$undoStack;if(function(e,t){for(var i=t;i--;){var n=e[i];if(n&&!n[0].ignore){for(;i<t-1;){var r=function(e,t){for(var i=e.length;i--;)for(var n=0;n<t.length;n++)if(!o(e[i],t[n])){for(;i<e.length;){for(;n--;)o(t[n],e[i]);n=t.length,i++}return[e,t]}return e.selectionBefore=t.selectionBefore=e.selectionAfter=t.selectionAfter=null,[t,e]}(e[i],e[i+1]);e[i]=r[0],e[i+1]=r[1],i++}return!0}}}(n,n.length))return e=e||this.$session,this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0,n=n.pop(),i=null,n&&(i=e.undoChanges(n,t),this.$redoStack.push(n),this.$syncRev()),this.$fromUndo=!1,i},this.redo=function(e,h){if(this.lastDeltas=null,e=e||this.$session,this.$fromUndo=!0,this.$redoStackBaseRev!=this.$rev){for(var t=this.getDeltas(this.$redoStackBaseRev,this.$rev+1),d=this.$redoStack,u=t,i=0;i<u.length;i++)for(var g=u[i],n=0;n<g.length;n++){r=void 0;o=void 0;s=void 0;a=void 0;l=void 0;c=void 0;var r=d;var o=g[n];o=function(e){return{start:C(e.start),end:C(e.end),action:e.action,lines:e.lines.slice()}}(o);for(var s=r.length;s--;){for(var a=r[s],l=0;l<a.length;l++){var c=function(e,t){var i,n,r="insert"==e.action,o="insert"==t.action;if(r&&o)f(e.start,t.start)<0?I(t,e,1):I(e,t,1);else if(r&&!o)0<=f(e.start,t.end)?I(e,t,-1):(f(e.start,t.start)<=0||I(e,m.fromPoints(t.start,e.start),-1),I(t,e,1));else if(!r&&o)0<=f(t.start,e.end)?I(t,e,-1):(f(t.start,e.start)<=0||I(t,m.fromPoints(e.start,t.start),-1),I(e,t,1));else if(!r&&!o)if(0<=f(t.start,e.end))I(t,e,-1);else{if(!(f(t.end,e.start)<=0))return f(e.start,t.start)<0&&(e=A(i=e,t.start)),0<f(e.end,t.end)&&(n=A(e,t.end)),v(t.end,e.start,e.end,-1),n&&!i&&(e.lines=n.lines,e.start=n.start,e.end=n.end,n=e),[t,i,n].filter(Boolean);I(e,t,-1)}return[t,e]}(a[l],o);o=c[0],2!=c.length&&(c[2]?(a.splice(l+1,1,c[1],c[2]),l++):c[1]||(a.splice(l,1),l--))}a.length||r.splice(s,1)}}this.$redoStackBaseRev=this.$rev,this.$redoStack.forEach(function(e){e[0].id=++this.$maxRev},this)}var t=this.$redoStack.pop(),p=null;return t&&(p=e.redoChanges(t,h),this.$undoStack.push(t),this.$syncRev()),this.$fromUndo=!1,p},this.$syncRev=function(){var e=this.$undoStack,e=e[e.length-1],e=e&&e[0].id||0;this.$redoStackBaseRev=e,this.$rev=e},this.reset=function(){this.lastDeltas=null,this.$lastDelta=null,this.$undoStack=[],this.$redoStack=[],this.$rev=0,this.mark=0,this.$redoStackBaseRev=this.$rev,this.selections=[]},this.canUndo=function(){return 0<this.$undoStack.length},this.canRedo=function(){return 0<this.$redoStack.length},this.bookmark=function(e){null==e&&(e=this.$rev),this.mark=e},this.isAtBookmark=function(){return this.$rev===this.mark},this.toJSON=function(){},this.fromJSON=function(){},this.hasUndo=this.canUndo,this.hasRedo=this.canRedo,this.isClean=this.isAtBookmark,this.markClean=this.bookmark,this.$prettyPrint=function(e){return e?i(e):i(this.$undoStack)+"\n---\n"+i(this.$redoStack)}}.call(e.prototype);var m=t("./range").Range,f=m.comparePoints;m.comparePoints;function C(e){return{row:e.row,column:e.column}}function i(e){if(e=e||this,Array.isArray(e))return e.map(i).join("\n");var t="";return e.action?(t="insert"==e.action?"+":"-",t+="["+e.lines+"]"):e.value&&(t=Array.isArray(e.value)?e.value.map(n).join("\n"):n(e.value)),e.start&&(t+=n(e)),(e.id||e.rev)&&(t+="\t("+(e.id||e.rev)+")"),t}function n(e){return e.start.row+":"+e.start.column+"=>"+e.end.row+":"+e.end.column}function o(e,t){var i="insert"==e.action,n="insert"==t.action;if(i&&n)if(0<=f(t.start,e.end))I(t,e,-1);else{if(!(f(t.start,e.start)<=0))return;I(e,t,1)}else if(i&&!n)if(0<=f(t.start,e.end))I(t,e,-1);else{if(!(f(t.end,e.start)<=0))return;I(e,t,-1)}else if(!i&&n)if(0<=f(t.start,e.start))I(t,e,1);else{if(!(f(t.start,e.start)<=0))return;I(e,t,1)}else if(!i&&!n)if(0<=f(t.start,e.start))I(t,e,1);else{if(!(f(t.end,e.start)<=0))return;I(e,t,-1)}return 1}function I(e,t,i){v(e.start,t.start,t.end,i),v(e.end,t.start,t.end,i)}function v(e,t,i,n){e.row==(1==n?t:i).row&&(e.column+=n*(i.column-t.column)),e.row+=n*(i.row-t.row)}function A(e,t){var i=e.lines,n=e.end,r=(e.end=C(t),e.end.row-e.start.row),o=i.splice(r,i.length),r=r?t.column:t.column-e.start.column;return i.push(o[0].substring(0,r)),o[0]=o[0].substr(r),{start:C(t),end:n,lines:o,action:e.action}}r.UndoManager=e}),ace.define("ace/layer/lines",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";function n(e,t){this.element=e,this.canvasHeight=t||5e5,this.element.style.height=2*this.canvasHeight+"px",this.cells=[],this.cellCache=[],this.$offsetCoefficient=0}var s=e("../lib/dom");!function(){this.moveContainer=function(e){s.translate(this.element,0,-(e.firstRowScreen*e.lineHeight%this.canvasHeight)-e.offset*this.$offsetCoefficient)},this.pageChanged=function(e,t){return Math.floor(e.firstRowScreen*e.lineHeight/this.canvasHeight)!==Math.floor(t.firstRowScreen*t.lineHeight/this.canvasHeight)},this.computeLineTop=function(e,t,i){var n=t.firstRowScreen*t.lineHeight,n=Math.floor(n/this.canvasHeight);return i.documentToScreenRow(e,0)*t.lineHeight-n*this.canvasHeight},this.computeLineHeight=function(e,t,i){return t.lineHeight*i.getRowLineCount(e)},this.getLength=function(){return this.cells.length},this.get=function(e){return this.cells[e]},this.shift=function(){this.$cacheCell(this.cells.shift())},this.pop=function(){this.$cacheCell(this.cells.pop())},this.push=function(e){if(Array.isArray(e)){this.cells.push.apply(this.cells,e);for(var t=s.createFragment(this.element),i=0;i<e.length;i++)t.appendChild(e[i].element);this.element.appendChild(t)}else this.cells.push(e),this.element.appendChild(e.element)},this.unshift=function(e){if(Array.isArray(e)){this.cells.unshift.apply(this.cells,e);for(var t=s.createFragment(this.element),i=0;i<e.length;i++)t.appendChild(e[i].element);this.element.firstChild?this.element.insertBefore(t,this.element.firstChild):this.element.appendChild(t)}else this.cells.unshift(e),this.element.insertAdjacentElement("afterbegin",e.element)},this.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null},this.$cacheCell=function(e){e&&(e.element.remove(),this.cellCache.push(e))},this.createCell=function(e,t,i,n){var r,o=this.cellCache.pop();return o||(r=s.createElement("div"),n&&n(r),this.element.appendChild(r),o={element:r,text:"",row:e}),o.row=e,o}}.call(n.prototype),t.Lines=n}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/layer/lines"],function(e,t,a){"use strict";function i(e){this.element=f.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$lines=new s(this.element),this.$lines.$offsetCoefficient=1}var f=e("../lib/dom"),n=e("../lib/oop"),o=e("../lib/lang"),r=e("../lib/event_emitter").EventEmitter,s=e("./lines").Lines;function c(e){var t=document.createTextNode(""),t=(e.appendChild(t),f.createElement("span"));return e.appendChild(t),e}!function(){n.implement(this,r),this.setSession=function(e){this.session&&this.session.off("change",this.$updateAnnotations),(this.session=e)&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},this.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var i=e[t],n=i.row,r=(r=this.$annotations[n])||(this.$annotations[n]={text:[]}),n=(n=i.text)?o.escapeHTML(n):i.html||"",n=(-1===r.text.indexOf(n)&&r.text.push(n),i.type);"error"==n?r.className=" ace_error":"warning"==n&&" ace_error"!=r.className?r.className=" ace_warning":"info"!=n||r.className||(r.className=" ace_info")}},this.$updateAnnotations=function(e){var t,i;this.$annotations.length&&(t=e.start.row,0==(i=e.end.row-t)||("remove"==e.action?this.$annotations.splice(t,1+i,null):((e=new Array(1+i)).unshift(t,1),this.$annotations.splice.apply(this.$annotations,e))))},this.update=function(e){this.config=e;for(var t=this.session,i=e.firstRow,n=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1),r=(this.oldLastRow=n,this.config=e,this.$lines.moveContainer(e),this.$updateCursorRow(),t.getNextFoldLine(i)),o=r?r.start.row:1/0,s=null,a=-1,l=i;;){if(o<l&&(l=r.end.row+1,o=(r=t.getNextFoldLine(l,r))?r.start.row:1/0),n<l){for(;this.$lines.getLength()>a+1;)this.$lines.pop();break}(s=this.$lines.get(++a))?s.row=l:(s=this.$lines.createCell(l,e,this.session,c),this.$lines.push(s)),this.$renderCell(s,e,r,l),l++}this._signal("afterRender"),this.$updateGutterWidth(e)},this.$updateGutterWidth=function(e){var t=this.session,i=t.gutterRenderer||this.$renderer,n=t.$firstLineNumber,r=this.$lines.last()?this.$lines.last().text:"",n=((this.$fixedWidth||t.$useWrapMode)&&(r=t.getLength()+n-1),i?i.getWidth(t,r,e):r.toString().length*e.characterWidth),i=this.$padding||this.$computePadding();(n+=i.left+i.right)===this.gutterWidth||isNaN(n)||(this.gutterWidth=n,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",n))},this.$updateCursorRow=function(){var e;this.$highlightGutterLine&&(e=this.session.selection.getCursor(),this.$cursorRow!==e.row&&(this.$cursorRow=e.row))},this.updateLineHighlight=function(){if(this.$highlightGutterLine){var e=this.session.selection.cursor.row;if(this.$cursorRow=e,!this.$cursorCell||this.$cursorCell.row!=e){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));var t=this.$lines.cells;this.$cursorCell=null;for(var i=0;i<t.length;i++){var n=t[i];if(n.row>=this.$cursorRow){if(n.row>this.$cursorRow){var r=this.session.getFoldLine(this.$cursorRow);if(!(0<i&&r&&r.start.row==t[i-1].row))break;n=t[i-1]}n.element.className="ace_gutter-active-line "+n.element.className,this.$cursorCell=n;break}}}}},this.scrollLines=function(e){var t=this.config;if(this.config=e,this.$updateCursorRow(),this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var i=Math.min(e.lastRow+e.gutterOffset,this.session.getLength()-1),n=this.oldLastRow;if(this.oldLastRow=i,!t||n<e.firstRow)return this.update(e);if(i<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<r;r--)this.$lines.shift();if(i<n)for(r=this.session.getFoldedRowCount(i+1,n);0<r;r--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLines(e,e.firstRow,t.firstRow-1)),n<i&&this.$lines.push(this.$renderLines(e,n+1,i)),this.updateLineHighlight(),this._signal("afterRender"),this.$updateGutterWidth(e)},this.$renderLines=function(e,t,i){for(var n=[],r=t,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;s<r&&(r=o.end.row+1,s=(o=this.session.getNextFoldLine(r,o))?o.start.row:1/0),!(i<r);){var a=this.$lines.createCell(r,e,this.session,c);this.$renderCell(a,e,o,r),n.push(a),r++}return n},this.$renderCell=function(e,h,t,i){var n,r=e.element,o=this.session,d=r.childNodes[0],s=r.childNodes[1],u=o.$firstLineNumber,a=o.$breakpoints,l=o.$decorations,g=o.gutterRenderer||this.$renderer,p=this.$showFoldWidgets&&o.foldWidgets,m=t?t.start.row:Number.MAX_VALUE,c="ace_gutter-cell ",l=(this.$highlightGutterLine&&(i==this.$cursorRow||t&&i<this.$cursorRow&&m<=i&&this.$cursorRow<=t.end.row)&&(c+="ace_gutter-active-line ",this.$cursorCell!=e&&(this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=e)),a[i]&&(c+=a[i]),l[i]&&(c+=l[i]),this.$annotations[i]&&(c+=this.$annotations[i].className),r.className!=c&&(r.className=c),!p||null==(n=p[i])&&(n=p[i]=o.getFoldWidget(i)),n?(c="ace_fold-widget ace_"+n,"start"==n&&i==m&&i<t.end.row?c+=" ace_closed":c+=" ace_open",s.className!=c&&(s.className=c),a=h.lineHeight+"px",f.setStyle(s.style,"height",a),f.setStyle(s.style,"display","inline-block")):s&&f.setStyle(s.style,"display","none"),(g?g.getText(o,i):i+u).toString());return l!==d.data&&(d.data=l),f.setStyle(e.element.style,"height",this.$lines.computeLineHeight(i,h,o)+"px"),f.setStyle(e.element.style,"top",this.$lines.computeLineTop(i,h,o)+"px"),e.text=l,e},this.$fixedWidth=!1,this.$highlightGutterLine=!0,this.$renderer="",this.setHighlightGutterLine=function(e){this.$highlightGutterLine=e},this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return 0},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?f.addCssClass(this.element,"ace_folding-enabled"):f.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var e=f.computedStyle(this.element.firstChild);return this.$padding={},this.$padding.left=(parseInt(e.borderLeftWidth)||0)+(parseInt(e.paddingLeft)||0)+1,this.$padding.right=(parseInt(e.borderRightWidth)||0)+(parseInt(e.paddingRight)||0),this.$padding},this.getRegion=function(e){var t=this.$padding||this.$computePadding(),i=this.element.getBoundingClientRect();return e.x<t.left+i.left?"markers":this.$showFoldWidgets&&e.x>i.right-t.right?"foldWidgets":void 0}}.call(i.prototype),t.Gutter=i}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)}var g=e("../range").Range,r=e("../lib/dom");!function(){this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setMarkers=function(e){this.markers=e},this.elt=function(e,t){var i=-1!=this.i&&this.element.childNodes[this.i];i?this.i++:(i=document.createElement("div"),this.element.appendChild(i),this.i=-1),i.style.cssText=t,i.className=e},this.update=function(e){if(e){var t,i;for(i in this.config=e,this.i=0,this.markers){var n,r,o,s=this.markers[i];s.range?(o=s.range.clipRows(e.firstRow,e.lastRow)).isEmpty()||(o=o.toScreenRange(this.session),s.renderer?(n=this.$getTop(o.start.row,e),r=this.$padding+o.start.column*e.characterWidth,s.renderer(t,o,r,n,e)):"fullLine"==s.type?this.drawFullLineMarker(t,o,s.clazz,e):"screenLine"==s.type?this.drawScreenLineMarker(t,o,s.clazz,e):o.isMultiLine()?"text"==s.type?this.drawTextMarker(t,o,s.clazz,e):this.drawMultiLineMarker(t,o,s.clazz,e):this.drawSingleLineMarker(t,o,s.clazz+" ace_start ace_br15",e)):s.update(t,this,this.session,e)}if(-1!=this.i)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}},this.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},this.drawTextMarker=function(e,t,h,d,u){for(var i,n=this.session,r=t.start.row,o=t.end.row,s=r,a=0,l=n.getScreenLastRowColumn(s),c=new g(s,t.start.column,s,a);s<=o;s++)c.start.row=c.end.row=s,c.start.column=s==r?t.start.column:n.getRowWrapIndent(s),i=a,a=c.end.column=l,l=s+1<o?n.getScreenLastRowColumn(s+1):s==o?0:t.end.column,this.drawSingleLineMarker(e,c,h+(s==r?" ace_start":"")+" ace_br"+((s==r||s==r+1&&t.start.column?1:0)|(i<a?2:0)|(l<a?4:0)|(s==o?8:0)),d,s==o?0:1,u)},this.drawMultiLineMarker=function(e,t,i,n,r){var o,s=this.$padding,a=n.lineHeight,l=this.$getTop(t.start.row,n),c=s+t.start.column*n.characterWidth;r=r||"",this.session.$bidiHandler.isBidiRow(t.start.row)?((o=t.clone()).end.row=o.start.row,o.end.column=this.session.getLine(o.start.row).length,this.drawBidiSingleLineMarker(e,o,i+" ace_br1 ace_start",n,null,r)):this.elt(i+" ace_br1 ace_start","height:"+a+"px;right:0;top:"+l+"px;left:"+c+"px;"+(r||"")),this.session.$bidiHandler.isBidiRow(t.end.row)?((o=t.clone()).start.row=o.end.row,o.start.column=0,this.drawBidiSingleLineMarker(e,o,i+" ace_br12",n,null,r)):(l=this.$getTop(t.end.row,n),c=t.end.column*n.characterWidth,this.elt(i+" ace_br12","height:"+a+"px;width:"+c+"px;top:"+l+"px;left:"+s+"px;"+(r||""))),(a=(t.end.row-t.start.row-1)*n.lineHeight)<=0||(l=this.$getTop(t.start.row+1,n),e=(t.start.column?1:0)|(t.end.column?0:8),this.elt(i+(e?" ace_br"+e:""),"height:"+a+"px;right:0;top:"+l+"px;left:"+s+"px;"+(r||"")))},this.drawSingleLineMarker=function(e,t,i,n,r,o){if(this.session.$bidiHandler.isBidiRow(t.start.row))return this.drawBidiSingleLineMarker(e,t,i,n,r,o);var e=n.lineHeight,r=(t.end.column+(r||0)-t.start.column)*n.characterWidth,s=this.$getTop(t.start.row,n),t=this.$padding+t.start.column*n.characterWidth;this.elt(i,"height:"+e+"px;width:"+r+"px;top:"+s+"px;left:"+t+"px;"+(o||""))},this.drawBidiSingleLineMarker=function(e,t,i,n,r,o){var s=n.lineHeight,a=this.$getTop(t.start.row,n),l=this.$padding;this.session.$bidiHandler.getSelections(t.start.column,t.end.column).forEach(function(e){this.elt(i,"height:"+s+"px;width:"+e.width+(r||0)+"px;top:"+a+"px;left:"+(l+e.left
)+"px;"+(o||""))},this)},this.drawFullLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;t.start.row!=t.end.row&&(s+=this.$getTop(t.end.row,n)-o),this.elt(i,"height:"+s+"px;top:"+o+"px;left:0;right:0;"+(r||""))},this.drawScreenLineMarker=function(e,t,i,n,r){t=this.$getTop(t.start.row,n),n=n.lineHeight;this.elt(i,"height:"+n+"px;top:"+t+"px;left:0;right:0;"+(r||""))}}.call(n.prototype),t.Marker=n}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/layer/lines","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e){this.dom=c,this.element=this.dom.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this),this.$lines=new o(this.element)}var r=e("../lib/oop"),c=e("../lib/dom"),C=e("../lib/lang"),o=e("./lines").Lines,s=e("../lib/event_emitter").EventEmitter;!function(){r.implement(this,s),this.EOF_CHAR="¶",this.EOL_CHAR_LF="¬",this.EOL_CHAR_CRLF="¤",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="—",this.SPACE_CHAR="·",this.$padding=0,this.MAX_LINE_LENGTH=1e4,this.$updateEolChar=function(){var e=this.session.doc,e="\n"==e.getNewLineCharacter()&&"windows"!=e.getNewLineMode()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=e)return this.EOL_CHAR=e,!0},this.setPadding=function(e){this.$padding=e,this.element.style.margin="0 "+e+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(e){(this.session=e)&&this.$computeTabString()},this.showInvisibles=!1,this.showSpaces=!1,this.showTabs=!1,this.showEOL=!1,this.setShowInvisibles=function(e){return this.showInvisibles!=e&&("string"==typeof(this.showInvisibles=e)?(this.showSpaces=/tab/i.test(e),this.showTabs=/space/i.test(e),this.showEOL=/eol/i.test(e)):this.showSpaces=this.showTabs=this.showEOL=e,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){for(var e,t,i,n,r,o,s=this.session.getTabSize(),a=(this.tabSize=s,this.$tabStrings=[0]),l=1;l<s+1;l++)this.showTabs?((o=this.dom.createElement("span")).className="ace_invisible ace_invisible_tab",o.textContent=C.stringRepeat(this.TAB_CHAR,l),a.push(o)):a.push(this.dom.createTextNode(C.stringRepeat(" ",l),this.element));this.displayIndentGuides&&(this.$indentGuideRe=/\s\S| \t|\t |\s$/,e="ace_indent-guide",t=this.showSpaces?" ace_invisible ace_invisible_space":"",i=this.showSpaces?C.stringRepeat(this.SPACE_CHAR,this.tabSize):C.stringRepeat(" ",this.tabSize),n=this.showTabs?" ace_invisible ace_invisible_tab":"",r=this.showTabs?C.stringRepeat(this.TAB_CHAR,this.tabSize):i,(o=this.dom.createElement("span")).className=e+t,o.textContent=i,this.$tabStrings[" "]=o,(o=this.dom.createElement("span")).className=e+n,o.textContent=r,this.$tabStrings["\t"]=o)},this.updateLines=function(e,h,d){if(this.config.lastRow!=e.lastRow||this.config.firstRow!=e.firstRow)return this.update(e);this.config=e;for(var t=Math.max(h,e.firstRow),u=Math.min(d,e.lastRow),g=this.element.childNodes,i=0,n=e.firstRow;n<t;n++){if(r=this.session.getFoldLine(n)){if(r.containsRow(t)){t=r.start.row;break}n=r.end.row}i++}for(var r,o=!1,n=t,s=(r=this.session.getNextFoldLine(n))?r.start.row:1/0;s<n&&(n=r.end.row+1,s=(r=this.session.getNextFoldLine(n,r))?r.start.row:1/0),!(u<n);){var a,l=g[i++];l&&(this.dom.removeChildren(l),this.$renderLine(l,n,n==s&&r),o&&(l.style.top=this.$lines.computeLineTop(n,e,this.session)+"px"),a=e.lineHeight*this.session.getRowLength(n)+"px",l.style.height!=a&&(o=!0,l.style.height=a)),n++}if(o)for(;i<this.$lines.cells.length;){var c=this.$lines.cells[i++];c.element.style.top=this.$lines.computeLineTop(c.row,e,this.session)+"px"}},this.scrollLines=function(e){var t=this.config;if(this.config=e,this.$lines.pageChanged(t,e))return this.update(e);this.$lines.moveContainer(e);var i=e.lastRow,n=t?t.lastRow:-1;if(!t||n<e.firstRow)return this.update(e);if(i<t.firstRow)return this.update(e);if(!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<r;r--)this.$lines.shift();if(t.lastRow>e.lastRow)for(r=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);0<r;r--)this.$lines.pop();e.firstRow<t.firstRow&&this.$lines.unshift(this.$renderLinesFragment(e,e.firstRow,t.firstRow-1)),e.lastRow>t.lastRow&&this.$lines.push(this.$renderLinesFragment(e,t.lastRow+1,e.lastRow))},this.$renderLinesFragment=function(e,t,i){for(var n=[],r=t,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;s<r&&(r=o.end.row+1,s=(o=this.session.getNextFoldLine(r,o))?o.start.row:1/0),!(i<r);){var a=this.$lines.createCell(r,e,this.session),l=a.element;this.dom.removeChildren(l),c.setStyle(l.style,"height",this.$lines.computeLineHeight(r,e,this.session)+"px"),c.setStyle(l.style,"top",this.$lines.computeLineTop(r,e,this.session)+"px"),this.$renderLine(l,r,r==s&&o),this.$useLineGroups()?l.className="ace_line_group":l.className="ace_line",n.push(a),r++}return n},this.update=function(e){this.$lines.moveContainer(e);for(var t=(this.config=e).firstRow,i=e.lastRow,n=this.$lines;n.getLength();)n.pop();n.push(this.$renderLinesFragment(e,t,i))},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(h,e,t,i){for(var n,d,r=this,u=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,o=this.dom.createFragment(this.element),s=0;n=u.exec(i);){var a,l,g=n[1],c=n[2],p=n[3],m=n[4],f=n[5];!r.showSpaces&&c||(a=s!=n.index?i.slice(s,n.index):"",s=n.index+n[0].length,a&&o.appendChild(this.dom.createTextNode(a,this.element)),g?(a=r.session.getScreenTabSize(e+n.index),o.appendChild(r.$tabStrings[a].cloneNode(!0)),e+=a-1):c?r.showSpaces?((l=this.dom.createElement("span")).className="ace_invisible ace_invisible_space",l.textContent=C.stringRepeat(r.SPACE_CHAR,c.length),o.appendChild(l)):o.appendChild(this.com.createTextNode(c,this.element)):p?((l=this.dom.createElement("span")).className="ace_invisible ace_invisible_space ace_invalid",l.textContent=C.stringRepeat(r.SPACE_CHAR,p.length),o.appendChild(l)):m?(e+=1,(l=this.dom.createElement("span")).style.width=2*r.config.characterWidth+"px",l.className=r.showSpaces?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",l.textContent=r.showSpaces?r.SPACE_CHAR:m,o.appendChild(l)):f&&(e+=1,(l=this.dom.createElement("span")).style.width=2*r.config.characterWidth+"px",l.className="ace_cjk",l.textContent=f,o.appendChild(l)))}return o.appendChild(this.dom.createTextNode(s?i.slice(s):i,this.element)),this.$textToken[t.type]?h.appendChild(o):(d="ace_"+t.type.replace(/\./g," ace_"),l=this.dom.createElement("span"),"fold"==t.type&&(l.style.width=t.value.length*this.config.characterWidth+"px"),l.className=d,l.appendChild(o),h.appendChild(l)),e+i.length},this.renderIndentGuide=function(e,t,i){var n=t.search(this.$indentGuideRe);if(n<=0||i<=n)return t;if(" "==t[0]){for(var r=(n-=n%this.tabSize)/this.tabSize,o=0;o<r;o++)e.appendChild(this.$tabStrings[" "].cloneNode(!0));return t.substr(n)}if("\t"!=t[0])return t;for(o=0;o<n;o++)e.appendChild(this.$tabStrings["\t"].cloneNode(!0));return t.substr(n)},this.$createLineElement=function(e){var t=this.dom.createElement("div");return t.className="ace_line",t.style.height=this.config.lineHeight+"px",t},this.$renderWrappedLine=function(e,t,i){var n=0,h=0,r=i[0],o=0,s=this.$createLineElement();e.appendChild(s);for(var a=0;a<t.length;a++){var l=t[a],c=l.value;if(0==a&&this.displayIndentGuides){if(n=c.length,!(c=this.renderIndentGuide(s,c,r)))continue;n-=c.length}if(n+c.length<r)o=this.$renderToken(s,o,l,c),n+=c.length;else{for(;n+c.length>=r;)o=this.$renderToken(s,o,l,c.substring(0,r-n)),c=c.substring(r-n),n=r,s=this.$createLineElement(),e.appendChild(s),s.appendChild(this.dom.createTextNode(C.stringRepeat(" ",i.indent),this.element)),o=0,r=i[++h]||Number.MAX_VALUE;0!=c.length&&(n+=c.length,o=this.$renderToken(s,o,l,c))}}i[i.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(s,o,null,"",!0)},this.$renderSimpleLine=function(e,t){var i=0,n=t[0],r=n.value;(r=this.displayIndentGuides?this.renderIndentGuide(e,r):r)&&(i=this.$renderToken(e,i,n,r));for(var o=1;o<t.length;o++){if(i+(r=(n=t[o]).value).length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(e,i,n,r);i=this.$renderToken(e,i,n,r)}},this.$renderOverflowMessage=function(e,t,i,n,r){i&&this.$renderToken(e,t,i,n.slice(0,this.MAX_LINE_LENGTH-t));i=this.dom.createElement("span");i.className="ace_inline_button ace_keyword ace_toggle_wrap",i.textContent=r?"<hide>":"<click to see more...>",e.appendChild(i)},this.$renderLine=function(e,t,i){var n,r,o=e;(n=(i=!i&&0!=i?this.session.getFoldLine(t):i)?this.$getFoldLineTokens(t,i):this.session.getTokens(t)).length?(r=this.session.getRowSplitData(t))&&r.length?(this.$renderWrappedLine(e,n,r),o=e.lastChild):(o=e,this.$useLineGroups()&&(o=this.$createLineElement(),e.appendChild(o)),this.$renderSimpleLine(o,n)):this.$useLineGroups()&&(o=this.$createLineElement(),e.appendChild(o)),this.showEOL&&o&&(i&&(t=i.end.row),(r=this.dom.createElement("span")).className="ace_invisible ace_invisible_eol",r.textContent=t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,o.appendChild(r))},this.$getFoldLineTokens=function(e,t){var d=this.session,u=[];var g=d.getTokens(e);return t.walk(function(e,t,i,n,h){if(null!=e)u.push({type:"fold",value:e});else if((g=h?d.getTokens(t):g).length){for(var r,o=g,s=n,a=i,l=0,c=0;c+o[l].value.length<s;)if(c+=o[l].value.length,++l==o.length)return void!void 0;for(c!=s&&((r=o[l].value.substring(s-c)).length>a-s&&(r=r.substring(0,a-s)),u.push({type:o[l].type,value:r}),c=s+r.length,l+=1);c<a&&l<o.length;)(r=o[l].value).length+c>a?u.push({type:o[l].type,value:r.substring(0,a-c)}):u.push(o[l]),c+=r.length,l+=1}else;},t.end.row,this.session.getLine(t.end.row).length),u},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){}}.call(n.prototype),t.Text=n}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.element=c.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),c.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateOpacity.bind(this)}var c=e("../lib/dom");!function(){this.$updateOpacity=function(e){for(var t=this.cursors,i=t.length;i--;)c.setStyle(t[i].style,"opacity",e?"":"0")},this.$startCssAnimation=function(){for(var e=this.cursors,t=e.length;t--;)e[t].style.animationDuration=this.blinkInterval+"ms";this.$isAnimating=!0,setTimeout(function(){this.$isAnimating&&c.addCssClass(this.element,"ace_animate-blinking")}.bind(this))},this.$stopCssAnimation=function(){this.$isAnimating=!1,c.removeCssClass(this.element,"ace_animate-blinking")},this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},this.setBlinkInterval=function(e){e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},this.setSmoothBlinking=function(e){e!=this.smoothBlinking&&(this.smoothBlinking=e,c.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.restartTimer())},this.addCursor=function(){var e=c.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},this.removeCursor=function(){var e;if(1<this.cursors.length)return(e=this.cursors.pop()).parentNode.removeChild(e),e},this.hideCursor=function(){this.isVisible=!1,c.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,c.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var e,t=this.$updateCursors;clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.$stopCssAnimation(),this.smoothBlinking&&(this.$isSmoothBlinking=!1,c.removeCssClass(this.element,"ace_smooth-blinking")),t(!0),this.isBlinking&&this.blinkInterval&&this.isVisible?(this.smoothBlinking&&(this.$isSmoothBlinking=!0,setTimeout(function(){this.$isSmoothBlinking&&c.addCssClass(this.element,"ace_smooth-blinking")}.bind(this))),c.HAS_CSS_ANIMATION?this.$startCssAnimation():(e=function(){this.timeoutId=setTimeout(function(){t(!1)},.6*this.blinkInterval)}.bind(this),this.intervalId=setInterval(function(){t(!0),e()},this.blinkInterval),e())):this.$stopCssAnimation()},this.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e=e||this.session.selection.getCursor();var i=this.session.documentToScreenPosition(e);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(i.row,e.row)?this.session.$bidiHandler.getPosLeft(i.column):i.column*this.config.characterWidth),top:(i.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight}},this.isCursorInView=function(e,t){return 0<=e.top&&e.top<t.maxHeight},this.update=function(e){this.config=e;for(var t=this.session.$selectionMarkers,i=0,n=0,i=0,r=(t=void 0===t||0===t.length?[{cursor:null}]:t).length;i<r;i++){var o,s,a=this.getPixelPosition(t[i].cursor,!0);(a.top>e.height+e.offset||a.top<0)&&1<i||(s=(o=this.cursors[n++]||this.addCursor()).style,this.drawCursor?this.drawCursor(o,a,e,t[i],this.session):this.isCursorInView(a,e)?(c.setStyle(s,"display","block"),c.translate(o,a.left,a.top),c.setStyle(s,"width",Math.round(e.characterWidth)+"px"),c.setStyle(s,"height",e.lineHeight+"px")):c.setStyle(s,"display","none"))}for(;this.cursors.length>n;)this.removeCursor();var l=this.session.getOverwrite();this.$setOverwrite(l),this.$pixelPos=a,this.restartTimer()},this.drawCursor=null,this.$setOverwrite=function(e){e!=this.overwrite&&((this.overwrite=e)?c.addCssClass(this.element,"ace_overwrite-cursors"):c.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}.call(n.prototype),t.Cursor=n}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,t,c){"use strict";function i(e){this.element=s.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=s.createElement("div"),this.inner.className="ace_scrollbar-inner",this.inner.textContent=" ",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,a.addListener(this.element,"scroll",this.onScroll.bind(this)),a.addListener(this.element,"mousedown",a.preventDefault)}function n(e,t){i.call(this,e),this.scrollTop=0,this.scrollHeight=0,t.$scrollbarWidth=this.width=s.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px",this.$minWidth=0}function r(e,t){i.call(this,e),this.scrollLeft=0,this.height=t.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"}var o=e("./lib/oop"),s=e("./lib/dom"),a=e("./lib/event"),l=e("./lib/event_emitter").EventEmitter;!function(){o.implement(this,l),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1}}.call(i.prototype),o.inherits(n,i),function(){this.classSuffix="-v",this.onScroll=function(){var e;this.skipEvent||(this.scrollTop=this.element.scrollTop,1!=this.coeff&&(e=this.element.clientHeight/this.scrollHeight,this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)),this._emit("scroll",{data:this.scrollTop})),this.skipEvent=!1},this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=this.setScrollHeight=function(e){32768<(this.scrollHeight=e)?(this.coeff=32768/e,e=32768):1!=this.coeff&&(this.coeff=1),this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)}}.call(n.prototype);o.inherits(r,i),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(r.prototype),t.ScrollBar=n,t.ScrollBarV=n,t.ScrollBarH=r,t.VScrollBar=n,t.HScrollBar=r}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(e,t,i){"use strict";function n(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.$recursionLimit=2,this.window=t||window;var i=this;this._flush=function(e){i.pending=!1;var t=i.changes;t&&(r.blockIdle(100),i.changes=0,i.onRender(t)),i.changes?i.$recursionLimit--<0||i.schedule():i.$recursionLimit=2}}var r=e("./lib/event");!function(){this.schedule=function(e){this.changes=this.changes|e,this.changes&&!this.pending&&(r.nextFrame(this._flush),this.pending=!0)},this.clear=function(e){var t=this.changes;return this.changes=0,t}}.call(n.prototype),t.RenderLoop=n}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/lib/useragent","ace/lib/event_emitter"],function(e,t,c){var i=e("../lib/oop"),n=e("../lib/dom"),r=e("../lib/lang"),o=e("../lib/event"),s=e("../lib/useragent"),a=e("../lib/event_emitter").EventEmitter,l="function"==typeof ResizeObserver,e=t.FontMetrics=function(e){this.el=n.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=n.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=n.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),this.$measureNode.textContent=r.stringRepeat("X",256),this.$characterSize={width:0,height:0},l?this.$addObserver():this.checkForSizeChanges()};!function(){i.implement(this,a),this.$characterSize={width:0,height:0},this.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="0px",e.visibility="hidden",e.position="absolute",e.whiteSpace="pre",s.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},this.checkForSizeChanges=function(e){var t;!(e=void 0===e?this.$measureSizes():e)||this.$characterSize.width===e.width&&this.$characterSize.height===e.height||(this.$measureNode.style.fontWeight="bold",t=this.$measureSizes(),this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e}))},this.$addObserver=function(){var t=this;this.$observer=new window.ResizeObserver(function(e){t.checkForSizeChanges()}),this.$observer.observe(this.$measureNode)},this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer||this.$observer)return this.$pollSizeChangesTimer;var t=this;return this.$pollSizeChangesTimer=o.onIdle(function e(){t.checkForSizeChanges(),o.onIdle(e,500)},500)},this.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},this.$measureSizes=function(e){e={height:(e||this.$measureNode).clientHeight,width:(e||this.$measureNode).clientWidth/256};return 0===e.width||0===e.height?null:e},this.$measureCharWidth=function(e){return this.$main.textContent=r.stringRepeat(e,256),this.$main.getBoundingClientRect().width/256},this.getCharacterWidth=function(e){var t=this.charSizes[e];return t=void 0===t?this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width:t},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$observer&&this.$observer.disconnect(),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)},this.$getZoom=function e(t){return t&&t.parentElement?(window.getComputedStyle(t).zoom||1)*e(t.parentElement):1},this.$initTransformMeasureNodes=function(){function e(e,t){return["div",{style:"position: absolute;top:"+e+"px;left:"+t+"px;"}]}this.els=n.buildDom([e(0,0),e(200,0),e(0,200),e(200,200)],this.el)},this.transformCoordinates=function(e,t){function h(e,t,i){var n=e[1]*t[0]-e[0]*t[1];return[(-t[1]*i[0]+t[0]*i[1])/n,(+e[1]*i[0]-e[0]*i[1])/n]}function i(e,t){return[e[0]-t[0],e[1]-t[1]]}function n(e,t){return[e[0]+t[0],e[1]+t[1]]}function r(e,t){return[e*t[0],e*t[1]]}function d(e){e=e.getBoundingClientRect();return[e.left,e.top]}e=e&&r(1/this.$getZoom(this.el),e),this.els||this.$initTransformMeasureNodes();var o=d(this.els[0]),s=d(this.els[1]),a=d(this.els[2]),l=d(this.els[3]),l=h(i(l,s),i(l,a),i(n(s,a),n(l,o))),s=r(1+l[0],i(s,o)),a=r(1+l[1],i(a,o));if(t)return c=l[0]*t[0]/200+l[1]*t[1]/200+1,t=n(r(t[0],s),r(t[1],a)),n(r(1/c/200,t),o);var c=i(e,o),t=h(i(s,r(l[0],c)),i(a,r(l[1],c)),c);return r(200,t)}}.call(e.prototype)}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter","ace/lib/useragent"],function(e,t,h){"use strict";function i(e,t){var i=this,e=(this.container=e||a.createElement("div"),a.addCssClass(this.container,"ace_editor"),a.HI_DPI&&a.addCssClass(this.container,"ace_hidpi"),this.setTheme(t),null==o.get("useStrictCSP")&&o.set("useStrictCSP",!1),this.$gutter=a.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=a.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=a.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new r(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new s(this.content),this.$textLayer=new d(this.content));this.canvas=e.element,this.$markerFront=new s(this.content),this.$cursorLayer=new u(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new p(this.container,this),this.scrollBarH=new g(this.container,this),this.scrollBarV.on("scroll",function(e){i.$scrollAnimation||i.session.setScrollTop(e.data-i.scrollMargin.top)}),this.scrollBarH.on("scroll",function(e){i.$scrollAnimation||i.session.setScrollLeft(e.data-i.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new f(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.on("changeCharacterSize",function(e){i.updateCharacterSize(),i.onResize(!0,i.gutterWidth,i.$size.width,i.$size.height),i._signal("changeCharacterSize",e)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$keepTextAreaAtCursor=!c.isIOS,this.$loop=new m(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),o.resetOptions(this),o._signal("renderer",this)}var n=e("./lib/oop"),a=e("./lib/dom"),o=e("./config"),r=e("./layer/gutter").Gutter,s=e("./layer/marker").Marker,d=e("./layer/text").Text,u=e("./layer/cursor").Cursor,g=e("./scrollbar").HScrollBar,p=e("./scrollbar").VScrollBar,m=e("./renderloop").RenderLoop,f=e("./layer/font_metrics").FontMetrics,C=e("./lib/event_emitter").EventEmitter,l='.ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_editor {position: relative;overflow: hidden;padding: 0;font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;box-sizing: border-box;min-width: 100%;contain: style size layout;font-variant-ligatures: no-common-ligatures;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: \'\';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;contain: style size layout;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {position: absolute;top: 0;left: 0;right: 0;padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");}.ace_scrollbar {contain: strict;position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;contain: strict;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: transparent;color: inherit;z-index: 1000;opacity: 1;}.ace_composition_placeholder { color: transparent }.ace_composition_marker { border-bottom: 1px solid;position: absolute;border-radius: 0;margin-top: 1px;}[ace_nocontext=true] {transform: none!important;filter: none!important;clip-path: none!important;mask : none!important;contain: none!important;perspective: none!important;mix-blend-mode: initial!important;z-index: auto;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;height: 1000000px;contain: style size layout;}.ace_text-layer {font: inherit !important;position: absolute;height: 1000000px;width: 1000000px;contain: style size layout;}.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {contain: style size layout;position: absolute;top: 0;left: 0;right: 0;}.ace_hidpi .ace_text-layer,.ace_hidpi .ace_gutter-layer,.ace_hidpi .ace_content,.ace_hidpi .ace_gutter {contain: strict;will-change: transform;}.ace_hidpi .ace_text-layer > .ace_line, .ace_hidpi .ace_text-layer > .ace_line_group {contain: strict;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {opacity: 0;}.ace_smooth-blinking .ace_cursor {transition: opacity 0.18s;}.ace_animate-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: step-end;animation-name: blink-ace-animate;animation-iteration-count: infinite;}.ace_animate-blinking.ace_smooth-blinking .ace_cursor {animation-duration: 1000ms;animation-timing-function: ease-in-out;animation-name: blink-ace-animate-smooth;}@keyframes blink-ace-animate {from, to { opacity: 1; }60% { opacity: 0; }}@keyframes blink-ace-animate-smooth {from, to { opacity: 1; }45% { opacity: 1; }60% { opacity: 0; }85% { opacity: 0; }}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_error_bracket {position: absolute;border-bottom: 1px solid #DE5555;border-radius: 0;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;box-sizing: border-box;}.ace_line .ace_fold {box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");}.ace_tooltip {background-color: #FFF;background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");}.ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");}.ace_dark .ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_inline_button {border: 1px solid lightgray;display: inline-block;margin: -1px 8px;padding: 0 5px;pointer-events: auto;cursor: pointer;}.ace_inline_button:hover {border-color: gray;background: rgba(200,200,200,0.2);display: inline-block;pointer-events: auto;}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_mobile-menu {position: absolute;line-height: 1.5;border-radius: 4px;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;background: white;box-shadow: 1px 3px 2px grey;border: 1px solid #dcdcdc;color: black;}.ace_dark > .ace_mobile-menu {background: #333;color: #ccc;box-shadow: 1px 3px 2px grey;border: 1px solid #444;}.ace_mobile-button {padding: 2px;cursor: pointer;overflow: hidden;}.ace_mobile-button:hover {background-color: #eee;opacity:1;}.ace_mobile-button:active {background-color: #ddd;}.ace_placeholder {font-family: arial;transform: scale(0.9);transform-origin: left;white-space: pre;opacity: 0.7;margin: 0 10px;}',c=e("./lib/useragent"),I=c.isIE;a.importCssString(l,"ace_editor.css",!1);!function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,n.implement(this,C),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin(),a.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")},this.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),(this.session=e)&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(e,t,i){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!i)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(e,t,i,n){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=e?1:0;var r=this.container,r=(n=n||(r.clientHeight||r.scrollHeight),i=i||(r.clientWidth||r.scrollWidth),this.$updateCachedSize(e,t,i,n));if(!this.$size.scrollerHeight||!i&&!n)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(r|this.$changes,!0):this.$loop.schedule(r|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null}},this.$updateCachedSize=function(e,t,i,n){n-=this.$extraHeight||0;var r=0,o=this.$size,s={width:o.width,height:o.height,scrollerHeight:o.scrollerHeight,scrollerWidth:o.scrollerWidth};return n&&(e||o.height!=n)&&(o.height=n,r|=this.CHANGE_SIZE,o.scrollerHeight=o.height,this.$horizScroll&&(o.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",r|=this.CHANGE_SCROLL),i&&(e||o.width!=i)&&(r|=this.CHANGE_SIZE,o.width=i,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,a.setStyle(this.scrollBarH.element.style,"left",t+"px"),a.setStyle(this.scroller.style,"left",t+this.margin.left+"px"),o.scrollerWidth=Math.max(0,i-t-this.scrollBarV.getWidth()-this.margin.h),a.setStyle(this.$gutter.style,"left",this.margin.left+"px"),t=this.scrollBarV.getWidth()+"px",a.setStyle(this.scrollBarH.element.style,"right",t),a.setStyle(this.scroller.style,"right",t),a.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(r|=this.CHANGE_FULL)),o.$dirty=!i||!n,r&&this._signal("resize",s),r},this.onGutterResize=function(e){e=this.$showGutter?e:0;e!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,e,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()||this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()},this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,e=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(e,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(e){this.setOption("showInvisibles",e),this.session.$bidiHandler.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},this.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(e){return this.setOption("showGutter",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updatePrintMargin=function(){var e;(this.$showPrintMargin||this.$printMarginEl)&&(this.$printMarginEl||((e=a.createElement("div")).className="ace_layer ace_print-margin-layer",this.$printMarginEl=a.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)),(e=this.$printMarginEl.style).left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px",e.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&-1==this.session.$wrap&&this.adjustWrapLimit())},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.scroller},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){var e,t,i,n,r,o,s;this.$isMousePressed||(e=this.textarea.style,o=this.$composition,this.$keepTextAreaAtCursor||o?(i=this.$cursorLayer.$pixelPos)&&(o&&o.markerRange&&(i=this.$cursorLayer.getPixelPosition(o.markerRange.start,!0)),s=this.layerConfig,t=i.top,i=i.left,t-=s.offset,n=o&&o.useTextareaForIME?this.lineHeight:I?0:1,t<0||t>s.height-n?a.translate(this.textarea,0,0):(s=1,r=this.$size.height-n,o?o.useTextareaForIME?(o=this.textarea.value,s=this.characterWidth*this.session.$getStringScreenWidth(o)[0]):t+=this.lineHeight+2:t+=this.lineHeight,(i-=this.scrollLeft)>this.$size.scrollerWidth-s&&(i=this.$size.scrollerWidth-s),i+=this.gutterWidth+this.margin.left,a.setStyle(e,"height",n+"px"),a.setStyle(e,"width",s+"px"),a.translate(this.textarea,Math.min(i,this.$size.scrollerWidth-s),Math.min(t,r)))):a.translate(this.textarea,-100,0))},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},this.getLastFullyVisibleRow=function(){var e=this.layerConfig,t=e.lastRow;return this.session.documentToScreenRow(t,0)*e.lineHeight-this.session.getScrollTop()>e.height-e.lineHeight?t-1:t},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(e,t,i,n){var r=this.scrollMargin;r.top=0|e,r.bottom=0|t,r.right=0|n,r.left=0|i,r.v=r.top+r.bottom,r.h=r.left+r.right,r.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-r.top),this.updateFull()},this.setMargin=function(e,t,i,n){var r=this.margin;r.top=0|e,r.bottom=0|t,r.right=0|n,r.left=0|i,r.v=r.top+r.bottom,r.h=r.left+r.right,this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e)},this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},this.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(e||t)){if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender",e),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var i,n,t=this.layerConfig;return((e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL)&&(e|=this.$computeLayerConfig()|this.$loop.clear(),t.firstRow==this.layerConfig.firstRow||t.firstRowScreen!=this.layerConfig.firstRowScreen||0<(i=this.scrollTop+(t.firstRow-this.layerConfig.firstRow)*this.lineHeight)&&(this.scrollTop=i,e=(e|=this.CHANGE_SCROLL)|(this.$computeLayerConfig()|this.$loop.clear())),t=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),a.translate(this.content,-this.scrollLeft,-t.offset),i=t.width+2*this.$padding+"px",n=t.minHeight+"px",a.setStyle(this.content.style,"width",i),a.setStyle(this.content.style,"height",n)),e&this.CHANGE_H_SCROLL&&(a.translate(this.content,-this.scrollLeft,-t.offset),this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),e&this.CHANGE_FULL)?(this.$changedLines=null,this.$textLayer.update(t),this.$showGutter&&this.$gutterLayer.update(t),this.$markerBack.update(t),this.$markerFront.update(t),this.$cursorLayer.update(t),this.$moveTextAreaToCursor(),void this._signal("afterRender",e)):(e&this.CHANGE_SCROLL?(this.$changedLines=null,e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(t):this.$textLayer.scrollLines(t),this.$showGutter&&(e&this.CHANGE_GUTTER||e&this.CHANGE_LINES?this.$gutterLayer.update(t):this.$gutterLayer.scrollLines(t)),this.$markerBack.update(t),this.$markerFront.update(t),this.$cursorLayer.update(t),this.$moveTextAreaToCursor()):(e&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(t),this.$showGutter&&this.$gutterLayer.update(t)):e&this.CHANGE_LINES?(this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(t):e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER?this.$showGutter&&this.$gutterLayer.update(t):e&this.CHANGE_CURSOR&&this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(t),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(t),this.$moveTextAreaToCursor()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(t),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(t)),void this._signal("afterRender",e))}this.$changes|=e},this.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,i=Math.min(t,Math.max((this.$minLines||1)*this.lineHeight,e))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(i+=this.scrollBarH.getHeight());t=!((i=this.$maxPixelHeight&&i>this.$maxPixelHeight?this.$maxPixelHeight:i)<=2*this.lineHeight)&&t<e;i==this.desiredHeight&&this.$size.height==this.desiredHeight&&t==this.$vScroll||(t!=this.$vScroll&&(this.$vScroll=t,this.scrollBarV.setVisible(t)),e=this.container.clientWidth,this.container.style.height=i+"px",this.$updateCachedSize(!0,this.$gutterWidth,e,i),this.desiredHeight=i,this._signal("autosize"))},this.$computeLayerConfig=function(){var h,e=this.session,t=this.$size,i=t.height<=2*this.lineHeight,n=this.session.getScreenLength()*this.lineHeight,r=this.$getLongestLine(),o=!i&&(this.$hScrollBarAlwaysVisible||t.scrollerWidth-r-2*this.$padding<0),d=this.$horizScroll!==o,o=(d&&(this.$horizScroll=o,this.scrollBarH.setVisible(o)),this.$vScroll),u=(this.$maxLines&&1<this.lineHeight&&this.$autosize(),t.scrollerHeight+this.lineHeight),s=!this.$maxLines&&this.$scrollPastEnd?(t.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0,a=(n+=s,this.scrollMargin),i=(this.session.setScrollTop(Math.max(-a.top,Math.min(this.scrollTop,n-t.scrollerHeight+a.bottom))),this.session.setScrollLeft(Math.max(-a.left,Math.min(this.scrollLeft,r+2*this.$padding-t.scrollerWidth+a.right))),!i&&(this.$vScrollBarAlwaysVisible||t.scrollerHeight-n+s<0||this.scrollTop>a.top)),s=o!==i,a=(s&&(this.$vScroll=i,this.scrollBarV.setVisible(i)),this.scrollTop%this.lineHeight),o=Math.ceil(u/this.lineHeight)-1,o=(i=Math.max(0,Math.round((this.scrollTop-a)/this.lineHeight)))+o,l=this.lineHeight,i=e.screenToDocumentRow(i,0),c=e.getFoldLine(i),e=(c&&(i=c.start.row),c=e.documentToScreenRow(i,0),h=e.getRowLength(i)*l,o=Math.min(e.screenToDocumentRow(o,0),e.getLength()-1),u=t.scrollerHeight+e.getRowLength(o)*l+h,a=this.scrollTop-c*l,0);return this.layerConfig.width==r&&!d||(e=this.CHANGE_H_SCROLL),(d||s)&&(e|=this.$updateCachedSize(!0,this.gutterWidth,t.width,t.height),this._signal("scrollbarVisibilityChanged"),s&&(r=this.$getLongestLine())),this.layerConfig={width:r,padding:this.$padding,firstRow:i,firstRowScreen:c,lastRow:o,lineHeight:l,characterWidth:this.characterWidth,minHeight:u,maxHeight:n,offset:a,gutterOffset:l?Math.max(0,Math.ceil((a+t.height-t.scrollerHeight)/l)):0,height:this.$size.scrollerHeight},this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(r-this.$padding),e},this.$updateLines=function(){if(this.$changedLines){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow,i=(this.$changedLines=null,this.layerConfig);if(!(e>i.lastRow+1||t<i.firstRow))return t===1/0?(this.$showGutter&&this.$gutterLayer.update(i),void this.$textLayer.update(i)):(this.$textLayer.updateLines(i,e,t),!0)}},this.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),this.$textLayer&&e>this.$textLayer.MAX_LINE_LENGTH&&(e=this.$textLayer.MAX_LINE_LENGTH+30),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},this.updateBreakpoints=function(e){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(e,t,i){this.scrollCursorIntoView(e,i),this.scrollCursorIntoView(t,i)},this.scrollCursorIntoView=function(e,t,i){var n,r,o;0!==this.$size.scrollerHeight&&(n=(e=this.$cursorLayer.getPixelPosition(e)).left,e=e.top,o=i&&i.top||0,i=i&&i.bottom||0,e<(r=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop)+o?(t&&r+o>e+this.lineHeight&&(e-=t*this.$size.scrollerHeight),0===e&&(e=-this.scrollMargin.top),this.session.setScrollTop(e)):r+this.$size.scrollerHeight-i<e+this.lineHeight&&(t&&r+this.$size.scrollerHeight-i<e-this.lineHeight&&(e+=t*this.$size.scrollerHeight),this.session.setScrollTop(e+this.lineHeight+i-this.$size.scrollerHeight)),n<(o=this.scrollLeft)?(n<this.$padding+2*this.layerConfig.characterWidth&&(n=-this.scrollMargin.left),this.session.setScrollLeft(n)):o+this.$size.scrollerWidth<n+this.characterWidth?this.session.setScrollLeft(Math.round(n+this.characterWidth-this.$size.scrollerWidth)):o<=this.$padding&&n-o<this.characterWidth&&this.session.setScrollLeft(0))},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},this.alignCursor=function(e,t){var e=this.$cursorLayer.getPixelPosition(e="number"==typeof e?{row:e,column:0}:e),i=this.$size.scrollerHeight-this.lineHeight,e=e.top-i*(t||0);return this.session.setScrollTop(e),e},this.STEPS=8,this.$calcSteps=function(e,t){for(var i,n,r=0,o=this.STEPS,s=[],r=0;r<o;++r)s.push((i=r/this.STEPS,(t-(n=e))*(Math.pow(i-1,3)+1)+n));return s},this.scrollToLine=function(e,t,i,n){e=this.$cursorLayer.getPixelPosition({row:e,column:0}).top,t&&(e-=this.$size.scrollerHeight/2),t=this.scrollTop;this.session.setScrollTop(e),!1!==i&&this.animateScrolling(t,n)},this.animateScrolling=function(e,t){var i=this.scrollTop;if(this.$animatedScroll){var n=this;if(e!=i){if(this.$scrollAnimation){var r=this.$scrollAnimation.steps;if(r.length&&(e=r[0])==i)return}var o=n.$calcSteps(e,i);this.$scrollAnimation={from:e,to:i,steps:o},clearInterval(this.$timer),n.session.setScrollTop(o.shift()),n.session.$scrollTop=i,this.$timer=setInterval(function(){return n.session?void(o.length?(n.session.setScrollTop(o.shift()),n.session.$scrollTop=i):null!=i?(n.session.$scrollTop=-1,n.session.setScrollTop(i),i=null):(n.$timer=clearInterval(n.$timer),n.$scrollAnimation=null,t&&t())):clearInterval(n.$timer)},10)}}},this.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},this.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(e)},this.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},this.isScrollableBy=function(e,t){return t<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||(0<t&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||(e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||(0<e&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0)))},this.pixelToScreenCoordinates=function(e,t){this.$hasCssTransforms?(n={top:0,left:0},e=(i=this.$fontMetrics.transformCoordinates([e,t]))[1]-this.gutterWidth-this.margin.left,t=i[0]):n=this.scroller.getBoundingClientRect();var i=e+this.scrollLeft-n.left-this.$padding,e=i/this.characterWidth,t=Math.floor((t+this.scrollTop-n.top)/this.lineHeight),n=this.$blockCursor?Math.floor(e):Math.round(e);return{row:t,column:n,side:0<e-n?1:-1,offsetX:i}},this.screenToTextCoordinates=function(e,t){this.$hasCssTransforms?(i={top:0,left:0},e=(n=this.$fontMetrics.transformCoordinates([e,t]))[1]-this.gutterWidth-this.margin.left,t=n[0]):i=this.scroller.getBoundingClientRect();var i,n=e+this.scrollLeft-i.left-this.$padding,e=n/this.characterWidth,e=this.$blockCursor?Math.floor(e):Math.round(e),t=Math.floor((t+this.scrollTop-i.top)/this.lineHeight);return this.session.screenToDocumentPosition(t,Math.max(e,0),n)},this.textToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),t=this.session.documentToScreenPosition(e,t),e=this.$padding+(this.session.$bidiHandler.isBidiRow(t.row,e)?this.session.$bidiHandler.getPosLeft(t.column):Math.round(t.column*this.characterWidth)),t=t.row*this.lineHeight;return{pageX:i.left+e-this.scrollLeft,pageY:i.top+t-this.scrollTop}},this.visualizeFocus=function(){a.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){a.removeCssClass(this.container,"ace_focus")},this.showComposition=function(e){(this.$composition=e).cssText||(e.cssText=this.textarea.style.cssText),null==e.useTextareaForIME&&(e.useTextareaForIME=this.$useTextareaForIME),this.$useTextareaForIME?(a.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):e.markerId=this.session.addMarker(e.markerRange,"ace_composition_marker","text")},this.setCompositionText=function(e){var t=this.session.selection.cursor;this.addToken(e,"composition_placeholder",t.row,t.column),this.$moveTextAreaToCursor()},this.hideComposition=function(){var e;this.$composition&&(this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId),a.removeCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=this.$composition.cssText,e=this.session.selection.cursor,this.removeExtraToken(e.row,e.column),this.$composition=null,this.$cursorLayer.element.style.display="")},this.addToken=function(e,h,t,i){var n=this.session,r=(n.bgTokenizer.lines[t]=null,{type:h,value:e}),o=n.getTokens(t);if(null==i)o.push(r);else for(var s=0,a=0;a<o.length;a++){var l=o[a];if(i<=(s+=l.value.length)){var c=l.value.length-(s-i),d=l.value.slice(0,c),c=l.value.slice(c);o.splice(a,1,{type:l.type,value:d},r,{type:l.type,value:c});break}}this.updateLines(t,t)},this.removeExtraToken=function(e,t){this.updateLines(e,e)},this.setTheme=function(i,n){var e,r=this;function t(e){if(r.$themeId!=i)return n&&n();if(!e||!e.cssClass)throw new Error("couldn't load module "+i+" or it didn't call define");e.$id&&(r.$themeId=e.$id),a.importCssString(e.cssText,e.cssClass,r.container),r.theme&&a.removeCssClass(r.container,r.theme.cssClass);var t="padding"in e?e.padding:"padding"in(r.theme||{})?4:r.$padding;r.$padding&&t!=r.$padding&&r.setPadding(t),r.$theme=e.cssClass,r.theme=e,a.addCssClass(r.container,e.cssClass),a.setCssClass(r.container,"ace_dark",e.isDark),r.$size&&(r.$size.width=0,r.$updateSizeAsync()),r._dispatchEvent("themeLoaded",{theme:e}),n&&n()}this.$themeId=i,r._dispatchEvent("themeChange",{theme:i}),i&&"string"!=typeof i?t(i):(e=i||this.$options.theme.initialValue,o.loadModule(["theme",e],t))},this.getTheme=function(){return this.$themeId},this.setStyle=function(e,t){a.setCssClass(this.container,e,!1!==t)},this.unsetStyle=function(e){a.removeCssClass(this.container,e)},this.setCursorStyle=function(e){a.setStyle(this.scroller.style,"cursor",e)},this.setMouseCursor=function(e){a.setStyle(this.scroller.style,"cursor",e)},this.attachToShadowRoot=function(){a.importCssString(l,"ace_editor.css",this.container)},this.destroy=function(){this.freeze(),this.$fontMetrics.destroy(),this.$cursorLayer.destroy(),this.removeAllListeners(),this.container.textContent=""}}.call(i.prototype),o.defineOptions(i.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{
set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(e){a.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(e){this.$gutterLayer.setHighlightGutterLine(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(e){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(e){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(e){this.updateFull()}},minLines:{set:function(e){this.$minLines<562949953421311||(this.$minLines=0),this.updateFull()}},maxPixelHeight:{set:function(e){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(e){this.$scrollPastEnd!=(e=+e||0)&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!c.isMobile&&!c.isIE}}),t.VirtualRenderer=i}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(a,e,t){"use strict";var i=a("../lib/oop"),n=a("../lib/net"),c=a("../lib/event_emitter").EventEmitter,h=a("../config");function l(e){return"undefined"==typeof Worker?{postMessage:function(){},terminate:function(){}}:h.get("loadWorkerFromBlob")?(t=function(t){t="importScripts('"+n.qualifyURL(t)+"');";try{return new Blob([t],{type:"application/javascript"})}catch(e){var i=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return i.append(t),i.getBlob("application/javascript")}}(e),t=(window.URL||window.webkitURL).createObjectURL(t),new Worker(t)):new Worker(e);var t}function d(e){e.postMessage||(e=this.$createWorkerFromOldConfig.apply(this,arguments)),this.$worker=e,this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage}(function(){i.implement(this,c),this.$createWorkerFromOldConfig=function(e,t,i,n,r){var o,s;return a.nameToUrl&&!a.toUrl&&(a.toUrl=a.nameToUrl),h.get("packaged")||!a.toUrl?n=n||h.moduleUrl(t,"worker"):(o=this.$normalizePath,n=n||o(a.toUrl("ace/worker/worker.js",null,"_")),s={},e.forEach(function(e){s[e]=o(a.toUrl(e,null,"_").replace(/(\.js)?(\?.*)?$/,""))})),this.$worker=l(n),r&&this.send("importScripts",r),this.$worker.postMessage({init:!0,tlns:s,module:t,classname:i}),this.$worker},this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var i=this.callbacks[t.id];i&&(i(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return n.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,i){var n;i&&(n=this.callbackId++,this.callbacks[n]=i,t.push(n)),this.send(e,t)},this.emit=function(e,t){try{t.data&&t.data.err&&(t.data.err={message:t.data.err.message,stack:t.data.err.stack,code:t.data.err.code}),this.$worker.postMessage({event:e,data:{data:t.data}})}catch(e){console.error(e.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener)},this.changeListener=function(e){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),"insert"==e.action?this.deltaQueue.push(e.start,e.lines):this.deltaQueue.push(e.start,e.end)},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,50<e.length&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))}}).call(d.prototype);e.UIWorkerClient=function(e,t,i){var n=null,r=!1,o=Object.create(c),s=[],a=new d({messageBuffer:s,terminate:function(){},postMessage:function(e){s.push(e),n&&(r?setTimeout(l):l())}}),l=(a.setEmitSync=function(e){r=e},function(){var e=s.shift();e.command?n[e.command].apply(n,e.args):e.event&&o._signal(e.event,e.data)});return o.postMessage=function(e){a.onMessage({data:e})},o.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},o.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},h.loadModule(["worker",t],function(e){for(n=new e[i](o);s.length;)l()}),a},e.WorkerClient=d,e.createWorker=l}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(e,t,i){"use strict";function n(e,t,i,n,r,o){var s=this,t=(this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=r,this.othersClass=o,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate),this.$others=n,this.$onCursorChange=function(){setTimeout(function(){s.onCursorChange()})},this.$pos=i,e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1});this.$undoStackDepth=t.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)}var l=e("./range").Range,r=e("./lib/event_emitter").EventEmitter,o=e("./lib/oop");!function(){o.implement(this,r),this.setup=function(){var t=this,i=this.doc,e=this.session,n=(this.selectionBefore=e.selection.toJSON(),e.selection.inMultiSelectMode&&e.selection.toSingleRange(),this.pos=i.createAnchor(this.$pos.row,this.$pos.column),this.pos);n.$insertRight=!0,n.detach(),n.markerId=e.addMarker(new l(n.row,n.column,n.row,n.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(e){e=i.createAnchor(e.row,e.column);e.$insertRight=!0,e.detach(),t.others.push(e)}),e.setUndoSelect(!1)},this.showOtherMarkers=function(){var t,i;this.othersActive||(t=this.session,(i=this).othersActive=!0,this.others.forEach(function(e){e.markerId=t.addMarker(new l(e.row,e.column,e.row,e.column+i.length),i.othersClass,null,!1)}))},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},this.onUpdate=function(e){if(this.$updating)return this.updateAnchors(e);var t=e;if(t.start.row===t.end.row&&t.start.row===this.pos.row){this.$updating=!0;var i="insert"===e.action?t.end.column-t.start.column:t.start.column-t.end.column,n=t.start.column>=this.pos.column&&t.start.column<=this.pos.column+this.length+1,r=t.start.column-this.pos.column;if(this.updateAnchors(e),n&&(this.length+=i),n&&!this.session.$fromUndo)if("insert"===e.action)for(var o=this.others.length-1;0<=o;o--){var s={row:(a=this.others[o]).row,column:a.column+r};this.doc.insertMergedLines(s,e.lines)}else if("remove"===e.action)for(o=this.others.length-1;0<=o;o--){var a,s={row:(a=this.others[o]).row,column:a.column+r};this.doc.remove(new l(s.row,s.column,s.row,s.column-i))}this.$updating=!1,this.updateMarkers()}},this.updateAnchors=function(e){this.pos.onChange(e);for(var t=this.others.length;t--;)this.others[t].onChange(e);this.updateMarkers()},this.updateMarkers=function(){if(!this.$updating){var i=this,n=this.session,e=function(e,t){n.removeMarker(e.markerId),e.markerId=n.addMarker(new l(e.row,e.column,e.row,e.column+i.length),t,null,!1)};e(this.pos,this.mainClass);for(var t=this.others.length;t--;)e(this.others[t],this.othersClass)}},this.onCursorChange=function(e){var t;!this.$updating&&this.session&&((t=this.session.selection.getCursor()).row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e)))},this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.off("change",this.$onUpdate),this.session.selection.off("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(-1!==this.$undoStackDepth){for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,i=0;i<t;i++)e.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}.call(n.prototype),t.PlaceHolder=n}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){var x=e("../lib/event"),k=e("../lib/useragent");function E(e,t){return e.row==t.row&&e.column==t.column}t.onMouseDown=function(e){var t=e.domEvent,i=t.altKey,n=t.shiftKey,h=t.ctrlKey,r=e.getAccelKey(),d=e.getButton();if(h&&k.isMac&&(d=t.button),e.editor.inMultiSelectMode&&2==d)e.editor.textInput.onContextMenu(e.domEvent);else if(h||i||r){if(0===d){var o,s,u,g,a,p,m,f,l=e.editor,c=l.selection,C=l.inMultiSelectMode,I=e.getDocumentPosition(),v=c.getCursor(),v=e.inSelection()||c.isEmpty()&&E(I,v),A=e.x,b=e.y,y=l.session,w=l.renderer.pixelToScreenCoordinates(A,b),S=w;if(l.$mouseHandler.$enableJumpToDef)h&&i||r&&i?o=n?"block":"add":i&&l.$blockSelectEnabled&&(o="block");else if(r&&!i){if(o="add",!C&&n)return}else i&&l.$blockSelectEnabled&&(o="block");if(o&&k.isMac&&t.ctrlKey&&l.$mouseHandler.cancelContextMenu(),"add"==o)!C&&v||(C||(s=c.toOrientedRange(),l.addSelectionMarker(s)),u=c.rangeList.rangeAtPoint(I),l.inVirtualSelectionMode=!0,n&&(u=null,s=c.ranges[0]||s,l.removeSelectionMarker(s)),l.once("mouseup",function(){var e=c.toOrientedRange();u&&e.isEmpty()&&E(u.cursor,e.cursor)?c.substractPoint(e.cursor):(n?c.substractPoint(s.cursor):s&&(l.removeSelectionMarker(s),c.addRange(s)),c.addRange(e)),l.inVirtualSelectionMode=!1}));else if("block"==o)return e.stop(),l.inVirtualSelectionMode=!0,a=[],p=function(){var e=l.renderer.pixelToScreenCoordinates(A,b),t=y.screenToDocumentPosition(e.row,e.column,e.offsetX);E(S,e)&&E(t,c.lead)||(S=e,l.selection.moveToPosition(t),l.renderer.scrollCursorIntoView(),l.removeSelectionMarkers(a),a=c.rectangularRangeBlock(S,w),l.$mouseHandler.$clickSelection&&1==a.length&&a[0].isEmpty()&&(a[0]=l.$mouseHandler.$clickSelection.clone()),a.forEach(l.addSelectionMarker,l),l.updateSelectionMarkers())},C&&!r?c.toSingleRange():!C&&r&&(g=c.toOrientedRange(),l.addSelectionMarker(g)),n?w=y.documentToScreenPosition(c.lead):c.moveToPosition(I),S={row:-1,column:-1},m=p,x.capture(l.container,function(e){A=e.clientX,b=e.clientY},function(e){p(),clearInterval(f),l.removeSelectionMarkers(a),a.length||(a=[c.toOrientedRange()]),g&&(l.removeSelectionMarker(g),c.toSingleRange(g));for(var t=0;t<a.length;t++)c.addRange(a[t]);l.inVirtualSelectionMode=!1,l.$mouseHandler.$clickSelection=null}),f=setInterval(function(){m()},20),e.preventDefault()}}else 0===d&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode()}}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(e,t,i){t.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",description:"Add cursor below",exec:function(e){e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"toggleSplitSelectionIntoLines",description:"Split into lines",exec:function(e){1<e.multiSelect.rangeCount?e.multiSelect.joinSelections():e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"splitSelectionIntoLines",description:"Split into lines",exec:function(e){e.multiSelect.splitIntoLines()},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],t.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];e=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new e(t.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(e,r,i){var n=e("./range_list").RangeList,A=e("./range").Range,u=e("./selection").Selection,o=e("./mouse/multi_select_handler").onMouseDown,s=e("./lib/event"),g=e("./lib/lang"),a=e("./commands/multi_select_commands");r.commands=a.defaultCommands.concat(a.multiSelectCommands);var l=new(e("./search").Search);var t=e("./edit_session").EditSession,t=(!function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}.call(t.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var i=this.toOrientedRange();if(this.rangeList.add(i),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(i),this.$onAddRange(i)}e.cursor||(e.cursor=e.end);i=this.rangeList.add(e);return this.$onAddRange(e),i.length&&this.$onRemoveRange(i),1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){e=this.rangeList.substractPoint(e);if(e)return this.$onRemoveRange(e),e[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length&&this.$onRemoveRange(e)},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){var t;this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode&&(t=this.rangeList.ranges.pop(),e.push(t),this.rangeCount=0);for(var i=e.length;i--;){var n=this.ranges.indexOf(e[i]);this.ranges.splice(n,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new n,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){for(var e=this.ranges.length?this.ranges:[this.getRange()],t=[],i=0;i<e.length;i++){var n=e[i],r=n.start.row,o=n.end.row;if(r===o)t.push(n.clone());else{for(t.push(new A(r,n.start.column,r,this.session.getLine(r).length));++r<o;)t.push(this.getLineRange(r,!0));t.push(new A(o,0,o,n.end.column))}0!=i||this.isBackwards()||(t=t.reverse())}this.toSingleRange();for(i=t.length;i--;)this.addRange(t[i])},this.joinSelections=function(){var e=this.rangeList.ranges,t=e[e.length-1],e=A.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(e,t.cursor==t.start)},this.toggleBlockSelection=function(){var e,t;1<this.rangeCount?(t=(e=this.rangeList.ranges)[e.length-1],e=A.fromPoints(e[0].start,t.end),this.toSingleRange(),this.setSelectionRange(e,t.cursor==t.start)):(e=this.session.documentToScreenPosition(this.cursor),t=this.session.documentToScreenPosition(this.anchor),this.rectangularRangeBlock(e,t).forEach(this.addRange,this))},this.rectangularRangeBlock=function(e,t,h){var i,n,d,u,r,g,p,o=[],m=e.column<t.column,f=(u=m?(i=e.column,n=t.column,d=e.offsetX,t.offsetX):(i=t.column,n=e.column,d=t.offsetX,e.offsetX),e.row<t.row);g=f?(r=e.row,t.row):(r=t.row,e.row),i<0&&(i=0),(r=r<0?0:r)==g&&(h=!0);for(var C,I,s=r;s<=g;s++){var a=A.fromPoints(this.session.screenToDocumentPosition(s,i,d),this.session.screenToDocumentPosition(s,n,u));if(a.isEmpty()){if(p&&(C=a.end,I=p,C.row==I.row&&C.column==I.column))break;p=a.end}a.cursor=m?a.start:a.end,o.push(a)}if(f&&o.reverse(),!h){for(var l=o.length-1;o[l].isEmpty()&&0<l;)l--;if(0<l)for(var v=0;o[v].isEmpty();)v++;for(var c=l;v<=c;c--)o[c].isEmpty()&&o.splice(c,1)}return o}}.call(u.prototype),e("./editor").Editor);function c(e){var t,i;function n(e){i&&(t.renderer.setMouseCursor(""),i=!1)}e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=r.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",o),e.commands.addCommands(a.defaultCommands),(t=e).textInput&&(e=t.textInput.getElement(),i=!1,s.addListener(e,"keydown",function(e){e=18==e.keyCode&&!(e.ctrlKey||e.shiftKey||e.metaKey);t.$blockSelectEnabled&&e?i||(t.renderer.setMouseCursor("crosshair"),i=!0):i&&n()},t),s.addListener(e,"keyup",n,t),s.addListener(e,"blur",n,t)))}!function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){e.marker&&(this.session.removeMarker(e.marker),-1!=(e=this.session.$selectionMarkers.indexOf(e))&&this.session.$selectionMarkers.splice(e,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length)},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,i=e.length;i--;){var n=e[i];n.marker&&(this.session.removeMarker(n.marker),-1!=(n=t.indexOf(n))&&t.splice(n,1))}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(a.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(a.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t,i=e.command,n=e.editor;if(n.multiSelect)return i.multiSelectAction?t="forEach"==i.multiSelectAction?n.forEachSelection(i,e.args):"forEachLine"==i.multiSelectAction?n.forEachSelection(i,e.args,!0):"single"==i.multiSelectAction?(n.exitMultiSelectMode(),i.exec(n,e.args||{})):i.multiSelectAction(n,e.args||{}):(t=i.exec(n,e.args||{}),n.multiSelect.addRange(n.multiSelect.toOrientedRange()),n.multiSelect.mergeOverlappingRanges()),t},this.forEachSelection=function(e,t,i){if(!this.inVirtualSelectionMode){var n,r=i&&i.keepOrder,h=1==i||i&&i.$byLines,o=this.session,i=this.selection,s=i.rangeList,a=(r?i:s).ranges;if(!a.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var r=i._eventRegistry,l=(i._eventRegistry={},new u(o));this.inVirtualSelectionMode=!0;for(var c=a.length;c--;){if(h)for(;0<c&&a[c].start.row==a[c-1].end.row;)c--;l.fromOrientedRange(a[c]),l.index=c,this.selection=o.selection=l;var d=e.exec?e.exec(this,t||{}):e(this,t||{});n||void 0===d||(n=d),l.toOrientedRange(a[c])}l.detach(),this.selection=o.selection=i,this.inVirtualSelectionMode=!1,i._eventRegistry=r,i.mergeOverlappingRanges(),i.ranges[0]&&i.fromOrientedRange(i.ranges[0]);s=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),s&&s.from==s.to&&this.renderer.animateScrolling(s.from),n}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,i=[],n=0;n<t.length;n++)i.push(this.session.getTextRange(t[n]));var r=this.session.getDocument().getNewLineCharacter();(e=i.join(r)).length==(i.length-1)*r.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){var i;this.inMultiSelectMode&&!this.inVirtualSelectionMode&&(i=this.multiSelect.ranges[0],this.multiSelect.isEmpty()&&t==this.multiSelect.anchor||((i=t==this.multiSelect.anchor?i.cursor==i.start?i.end:i.start:i.cursor).row!=t.row||this.session.$clipPositionToDocument(i.row,i.column).column!=t.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()))},this.findAll=function(e,t,i){(t=t||{}).needle=e||t.needle,null==t.needle&&(n=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange(),t.needle=this.session.getTextRange(n)),this.$search.set(t);var n,r=this.$search.findAll(this.session);if(!r.length)return 0;var o=this.multiSelect;i||o.toSingleRange(r[0]);for(var s=r.length;s--;)o.addRange(r[s],!0);return n&&o.rangeList.rangeAtPoint(n.start)&&o.addRange(n,!0),r.length},this.selectMoreLines=function(e,t){var i,n,r,o=this.selection.toOrientedRange(),s=o.cursor==o.end,a=this.session.documentToScreenPosition(o.cursor),l=(this.selection.$desiredColumn&&(a.column=this.selection.$desiredColumn),this.session.screenToDocumentPosition(a.row+e,a.column));e=o.isEmpty()?l:(i=this.session.documentToScreenPosition(s?o.end:o.start),this.session.screenToDocumentPosition(i.row+e,i.column)),s?(n=A.fromPoints(l,e)).cursor=n.start:(n=A.fromPoints(e,l)).cursor=n.end,n.desiredColumn=a.column,this.selection.inMultiSelectMode?t&&(r=o.cursor):this.selection.addRange(o),this.selection.addRange(n),r&&this.selection.substractPoint(r)},this.transposeSelections=function(e){for(var t=this.session,i=t.multiSelect,n=i.ranges,r=n.length;r--;)(s=n[r]).isEmpty()&&(a=t.getWordRange(s.start.row,s.start.column),s.start.row=a.start.row,s.start.column=a.start.column,s.end.row=a.end.row,s.end.column=a.end.column);i.mergeOverlappingRanges();for(var o=[],r=n.length;r--;){var s=n[r];o.unshift(t.getTextRange(s))}e<0?o.unshift(o.pop()):o.push(o.shift());for(r=n.length;r--;){var a=(s=n[r]).clone();t.replace(s,o[r]),s.start.row=a.start.row,s.start.column=a.start.column}i.fromOrientedRange(i.ranges[0])},this.selectMore=function(e,t,i){var n,r=this.session,o=r.multiSelect.toOrientedRange();o.isEmpty()&&((o=r.getWordRange(o.start.row,o.start.column)).cursor=-1==e?o.start:o.end,this.multiSelect.addRange(o),i)||(i=r.getTextRange(o),r=r,i=i,n=e,l.$options.wrap=!0,l.$options.needle=i,l.$options.backwards=-1==n,(i=l.find(r))&&(i.cursor=-1==e?i.start:i.end,this.session.unfold(i),this.multiSelect.addRange(i),this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(o.cursor))},this.alignCursors=function(){var r=this.session,t=r.multiSelect,e=t.ranges,h=-1,i=e.filter(function(e){return e.cursor.row==h||void(h=e.cursor.row)});if(e.length&&i.length!=e.length-1){i.forEach(function(e){t.substractPoint(e.cursor)});var o=0,s=1/0,d=e.map(function(e){var e=e.cursor,t=r.getLine(e.row).substr(e.column).search(/\S/g);return e.column>o&&(o=e.column),(t=-1==t?0:t)<s&&(s=t),t});e.forEach(function(e,t){var i=e.cursor,n=o-i.column,t=d[t]-s;t<n?r.insert(i,g.stringRepeat(" ",n-t)):r.remove(new A(i.row,i.column,i.row,i.column-n+t)),e.start.column=e.end.column=o,e.start.row=e.end.row=i.row,e.cursor=e.end}),t.fromOrientedRange(e[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var i=this.selection.getRange(),n=i.start.row,a=i.end.row,e=n==a;if(e){for(var l,u=this.session.getLength();l=this.session.getLine(a),/[=:]/.test(l)&&++a<u;);for(;l=this.session.getLine(n),/[=:]/.test(l)&&0<--n;);n<0&&(n=0),u<=a&&(a=u-1)}var c=this.session.removeFullLines(n,a),c=this.$reAlignText(c,e);this.session.insert({row:n,column:0},c.join("\n")+"\n"),e||(i.start.column=0,i.end.column=c[c.length-1].length),this.selection.setRange(i)}},this.$reAlignText=function(e,t){var i,n,r,o=!0,s=!0;return e.map(function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?(null==i?(i=t[1].length,n=t[2].length,r=t[3].length):(i+n+r!=t[1].length+t[2].length+t[3].length&&(s=!1),i!=t[1].length&&(o=!1),i>t[1].length&&(i=t[1].length),n<t[2].length&&(n=t[2].length),r>t[3].length&&(r=t[3].length)),t):[e]}).map(t?l:o?s?function(e){return e[2]?a(i+n-e[2].length)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}:l:function(e){return e[2]?a(i)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]});function a(e){return g.stringRepeat(" ",e)}function l(e){return e[2]?a(i)+e[2]+a(n-e[2].length+r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}}}.call(t.prototype),r.onSessionChange=function(e){var t=e.session,e=(t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect,e.oldSession);e&&(e.multiSelect.off("addRange",this.$onAddRange),e.multiSelect.off("removeRange",this.$onRemoveRange),e.multiSelect.off("multiSelect",this.$onMultiSelect),e.multiSelect.off("singleSelect",this.$onSingleSelect),e.multiSelect.lead.off("change",this.$checkMultiselectChange),e.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},r.MultiSelect=c,e("./config").defineOptions(t.prototype,"editor",{enableMultiselect:{set:function(e){c(this),e?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",o)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",o))},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(e,t,i){"use strict";var h=e("../../range").Range,e=t.FoldMode=function(){};!function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,i){e=e.getLine(i);return this.foldingStartMarker.test(e)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(e)?"end":""},this.getFoldWidgetRange=function(e,t,i){return null},this.indentationBlock=function(e,t,i){var n=/\S/,r=e.getLine(t),o=r.search(n);if(-1!=o){for(var s,i=i||r.length,a=e.getLength(),r=t,l=t;++t<a;){var c=e.getLine(t).search(n);if(-1!=c){if(c<=o){c=e.getTokenAt(t,0);if(!c||"string"!==c.type)break}l=t}}return r<l?(s=e.getLine(l).length,new h(r,i,l,s)):void 0}},this.openingBracketBlock=function(e,t,i,n,r){i={row:i,column:n+1},n=e.$findClosingBracket(t,i,r);if(n)return t=e.foldWidgets[n.row],"start"==(t=null==t?e.getFoldWidget(n.row):t)&&n.row>i.row&&(n.row--,n.column=e.getLine(n.row).length),h.fromPoints(i,n)},this.closingBracketBlock=function(e,t,i,n,r){i={row:i,column:n},n=e.$findOpeningBracket(t,i);if(n)return n.column++,i.column--,h.fromPoints(n,i)}}.call(e.prototype)}),ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}',t.$id="ace/theme/textmate",e("../lib/dom").importCssString(t.cssText,t.cssClass,!1)}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var r=e("./lib/dom");function n(e){this.session=e,(this.session.widgetManager=this).session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}!function(){this.getRowLength=function(e){var t=this.lineWidgets&&this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.$getWidgetScreenLength=function(){var t=0;return this.lineWidgets.forEach(function(e){e&&e.rowCount&&!e.hidden&&(t+=e.rowCount)}),t},this.$onChangeEditor=function(e){this.attach(e.editor)},this.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),(this.editor=e)&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(e){var t=this.editor;t&&(this.editor=null,t.widgetManager=null,t.renderer.off("beforeRender",this.measureWidgets),t.renderer.off("afterRender",this.renderWidgets),(t=this.session.lineWidgets)&&t.forEach(function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))}))},this.updateOnFold=function(e,t){var i=t.lineWidgets;if(i&&e.action){for(var t=e.data,n=t.start.row,r=t.end.row,o="add"==e.action,s=n+1;s<r;s++)i[s]&&(i[s].hidden=o);i[r]&&(o?i[n]?i[r].hidden=o:i[n]=i[r]:(i[n]==i[r]&&(i[n]=void 0),i[r].hidden=o))}},this.updateOnChange=function(e){var t,i,n,r=this.session.lineWidgets;r&&(t=e.start.row,0==(i=e.end.row-t)||("remove"==e.action?(n=r.splice(t+1,i),!r[t]&&n[n.length-1]&&(r[t]=n.pop()),n.forEach(function(e){e&&this.removeLineWidget(e)},this)):(n=new Array(i),r[t]&&null!=r[t].column&&e.start.column>r[t].column&&t++,n.unshift(t,0),r.splice.apply(r,n)),this.$updateRows()))},this.$updateRows=function(){var i,e=this.session.lineWidgets;e&&(i=!0,e.forEach(function(e,t){if(e)for(i=!1,e.row=t;e.$oldWidget;)e.$oldWidget.row=t,e=e.$oldWidget}),i&&(this.session.lineWidgets=null))},this.$registerLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var t=this.session.lineWidgets[e.row];return t&&(e.$oldWidget=t).el&&t.el.parentNode&&(t.el.parentNode.removeChild(t.el),t._inDocument=!1),this.session.lineWidgets[e.row]=e},this.addLineWidget=function(e){if(this.$registerLineWidget(e),e.session=this.session,!this.editor)return e;var t,i=this.editor.renderer,n=(e.html&&!e.el&&(e.el=r.createElement("div"),e.el.innerHTML=e.html),e.el&&(r.addCssClass(e.el,"ace_lineWidgetContainer"),e.el.style.position="absolute",e.el.style.zIndex=5,i.container.appendChild(e.el),e._inDocument=!0,e.coverGutter||(e.el.style.zIndex=3),null==e.pixelHeight&&(e.pixelHeight=e.el.offsetHeight)),null==e.rowCount&&(e.rowCount=e.pixelHeight/i.layerConfig.lineHeight),this.session.getFoldAt(e.row,0));return(e.$fold=n)&&(t=this.session.lineWidgets,e.row!=n.end.row||t[n.start.row]?e.hidden=!0:t[n.start.row]=e),this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,i),this.onWidgetChanged(e),e},this.removeLineWidget=function(e){if(e._inDocument=!1,e.session=null,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(e){}if(this.session.lineWidgets){var t=this.session.lineWidgets[e.row];if(t==e)this.session.lineWidgets[e.row]=e.$oldWidget,e.$oldWidget&&this.onWidgetChanged(e.$oldWidget);else for(;t;){if(t.$oldWidget==e){t.$oldWidget=e.$oldWidget;break}t=t.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},this.getWidgetsAtRow=function(e){for(var t=this.session.lineWidgets,i=t&&t[e],n=[];i;)n.push(i),i=i.$oldWidget;return n},this.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(e,t){var i=this.session._changedWidgets,n=t.layerConfig;if(i&&i.length){for(var r=1/0,o=0;o<i.length;o++){var s=i[o];if(s&&s.el&&s.session==this.session){if(!s._inDocument){if(this.session.lineWidgets[s.row]!=s)continue;s._inDocument=!0,t.container.appendChild(s.el)}s.h=s.el.offsetHeight,s.fixedWidth||(s.w=s.el.offsetWidth,s.screenWidth=Math.ceil(s.w/n.characterWidth));var a=s.h/n.lineHeight;s.coverLine&&(a-=this.session.getRowLineCount(s.row))<0&&(a=0),s.rowCount!=a&&(s.rowCount=a,s.row<r&&(r=s.row))}}r!=1/0&&(this.session._emit("changeFold",{data:{start:{row:r}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(e,t){var i=t.layerConfig,n=this.session.lineWidgets;if(n){for(var r=Math.min(this.firstRow,i.firstRow),o=Math.max(this.lastRow,i.lastRow,n.length);0<r&&!n[r];)r--;this.firstRow=i.firstRow,this.lastRow=i.lastRow,t.$cursorLayer.config=i;for(var s=r;s<=o;s++){var a,l=n[s];l&&l.el&&(l.hidden?l.el.style.top=-100-(l.pixelHeight||0)+"px":(l._inDocument||(l._inDocument=!0,t.container.appendChild(l.el)),a=t.$cursorLayer.getPixelPosition({row:s,column:0},!0).top,l.coverLine||(a+=i.lineHeight*this.session.getRowLineCount(l.row)),l.el.style.top=a-i.offset+"px",a=l.coverGutter?0:t.gutterWidth,l.fixedWidth||(a-=t.scrollLeft),l.el.style.left=a+"px",l.fullWidth&&l.screenWidth&&(l.el.style.minWidth=i.width+2*i.padding+"px"),l.fixedWidth?l.el.style.right=t.scrollBar.getWidth()+"px":l.el.style.right=""))}}}}.call(n.prototype),t.LineWidgets=n}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],function(e,t,i){"use strict";var c=e("../line_widgets").LineWidgets,h=e("../lib/dom"),a=e("../range").Range;function d(e,t,i){var n=e.getAnnotations().sort(a.comparePoints);if(n.length){var r=function(e,t,i){for(var n=0,r=e.length-1;n<=r;){var o=n+r>>1,s=i(t,e[o]);if(0<s)n=1+o;else{if(!(s<0))return o;r=o-1}}return-(n+1)}(n,{row:t,column:-1},a.comparePoints),o=((r=r<0?-r-1:r)>=n.length?r=0<i?0:n.length-1:0===r&&i<0&&(r=n.length-1),n[r]);if(o&&i){if(o.row===t){for(;(o=n[r+=i])&&o.row===t;);if(!o)return n.slice()}var s=[];for(t=o.row;s[i<0?"unshift":"push"](o),(o=n[r+=i])&&o.row==t;);return s.length&&s}}}t.showErrorMarker=function(e,t){var i,n=e.session,r=(n.widgetManager||(n.widgetManager=new c(n),n.widgetManager.attach(e)),e.getCursorPosition()),o=r.row,s=n.widgetManager.getWidgetsAtRow(o).filter(function(e){return"errorMarker"==e.type})[0],o=(s?s.destroy():o-=t,d(n,o,t));if(o){t=o[0];r.column=(t.pos&&"number"!=typeof t.column?t.pos.sc:t.column)||0,r.row=t.row,i=e.renderer.$gutterLayer.$annotations[r.row]}else{if(s)return;i={text:["Looks good!"],className:"ace_ok"}}e.session.unfold(r.row),e.selection.moveToPosition(r);function a(e,t,i){if(0===t&&("esc"===i||"return"===i))return l.destroy(),{command:"null"}}var l={row:r.row,fixedWidth:!0,coverGutter:!0,el:h.createElement("div"),type:"errorMarker"},o=l.el.appendChild(h.createElement("div")),t=l.el.appendChild(h.createElement("div")),s=(t.className="error_widget_arrow "+i.className,e.renderer.$cursorLayer.getPixelPosition(r).left);t.style.left=s+e.renderer.gutterWidth-5+"px",l.el.className="error_widget_wrapper",o.className="error_widget "+i.className,o.innerHTML=i.text.join("<br>"),o.appendChild(h.createElement("div"));l.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(a),n.widgetManager.removeLineWidget(l),e.off("changeSelection",l.destroy),e.off("changeSession",l.destroy),e.off("mouseup",l.destroy),e.off("change",l.destroy))},e.keyBinding.addKeyboardHandler(a),e.on("changeSelection",l.destroy),e.on("changeSession",l.destroy),e.on("mouseup",l.destroy),e.on("change",l.destroy),e.session.widgetManager.addLineWidget(l),l.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:l.el.offsetHeight})},h.importCssString("    .error_widget_wrapper {        background: inherit;        color: inherit;        border:none    }    .error_widget {        border-top: solid 2px;        border-bottom: solid 2px;        margin: 5px 0;        padding: 10px 40px;        white-space: pre-wrap;    }    .error_widget.ace_error, .error_widget_arrow.ace_error{        border-color: #ff5a5a    }    .error_widget.ace_warning, .error_widget_arrow.ace_warning{        border-color: #F1D817    }    .error_widget.ace_info, .error_widget_arrow.ace_info{        border-color: #5a5a5a    }    .error_widget.ace_ok, .error_widget_arrow.ace_ok{        border-color: #5aaa5a    }    .error_widget_arrow {        position: absolute;        border: solid 5px;        border-top-color: transparent!important;        border-right-color: transparent!important;        border-left-color: transparent!important;        top: -5px;    }","error_marker.css",!1)}),ace.define("ace/ace",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/dom","ace/lib/event","ace/range","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config"],function(e,o,r){"use strict";e("./lib/fixoldbrowsers");var s=e("./lib/dom"),a=e("./lib/event"),t=e("./range").Range,l=e("./editor").Editor,i=e("./edit_session").EditSession,n=e("./undomanager").UndoManager,c=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),o.config=e("./config"),o.require=e,o.define=C.amdD,o.edit=function(e,t){if("string"==typeof e){var i=e;if(!(e=document.getElementById(i)))throw new Error("ace.edit can't find div #"+i)}if(e&&e.env&&e.env.editor instanceof l)return e.env.editor;var n,i="",i=(e&&/input|textarea/i.test(e.tagName)?(i=(n=e).value,e=s.createElement("pre"),n.parentNode.replaceChild(e,n)):e&&(i=e.textContent,e.innerHTML=""),o.createEditSession(i)),e=new l(new c(e),i,t),r={document:i,editor:e,onResize:e.resize.bind(e,null)};return n&&(r.textarea=n),a.addListener(window,"resize",r.onResize),e.on("destroy",function(){a.removeListener(window,"resize",r.onResize),r.editor.container.env=null}),e.container.env=e.env=r,e},o.createEditSession=function(e,t){e=new i(e,t);return e.setUndoManager(new n),e},o.Range=t,o.Editor=l,o.EditSession=i,o.UndoManager=n,o.VirtualRenderer=c,o.version=o.config.version}),ace.require(["ace/ace"],function(e){for(var t in e&&(e.config.init(!0),e.define=ace.define),window.ace||(window.ace=e),e)e.hasOwnProperty(t)&&(window.ace[t]=e[t]);window.ace.default=window.ace,i&&(i.exports=window.ace)})},3330:function(t,e,i){t=i.nmd(t),ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,c){"use strict";function i(e,t,i){var n=r.createElement("div");r.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:"Search for",spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"​"],["span",{action:"findNext",class:"ace_searchbtn next"},"​"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},"All"]],["div",{class:"ace_replace_form"},["input",{class:"ace_search_field",placeholder:"Replace with",spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},"Replace"],["span",{action:"replaceAll",class:"ace_searchbtn"},"All"]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:"Toggle Replace mode",style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:"RegExp Search"},".*"],["span",{action:"toggleCaseSensitive",class:"ace_button",title:"CaseSensitive Search"},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:"Whole Word Search"},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:"Search In Selection"},"S"]]],n),this.element=n.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e),r.importCssString(a,"ace_searchbox",e.container)}var r=e("../lib/dom"),o=e("../lib/lang"),s=e("../lib/event"),a='.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;min-height: 1.8em;box-sizing: content-box;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}',n=e("../keyboard/hash_handler").HashHandler,l=e("../lib/keys");r.importCssString(a,"ace_searchbox",!1);!function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element,n=(this.$initElements(e),this);s.addListener(e,"mousedown",function(e){setTimeout(function(){n.activeInput.focus()},0),s.stopPropagation(e)}),s.addListener(e,"click",function(e){var t=(e.target||e.srcElement).getAttribute("action");t&&n[t]?n[t]():n.$searchBarKb.commands[t]&&n.$searchBarKb.commands[t].exec(n),s.stopPropagation(e)}),s.addCommandKeyListener(e,function(e,t,i){i=l.keyCodeToString(i),t=n.$searchBarKb.findKeyCommand(t,i);t&&t.exec&&(t.exec(n),s.stopEvent(e))}),this.$onChange=o.delayedCall(function(){n.find(!1,!1)}),s.addListener(this.searchInput,"input",function(){n.$onChange.schedule(20)}),s.addListener(this.searchInput,"focus",function(){n.activeInput=n.searchInput,n.searchInput.value&&n.highlight()}),s.addListener(this.replaceInput,"focus",function(){n.activeInput=n.replaceInput,n.searchInput.value&&n.highlight()})},this.$closeSearchBarKb=new n([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new n,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.editor.getReadOnly()||(e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus())},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){(this.searchRange=e)?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){r.setCssClass(this.replaceOption,"checked",this.searchRange),r.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",r.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),r.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),r.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var t=this.editor.getReadOnly();this.replaceOption.style.display=t?"none":"",this.replaceBox.style.display=this.replaceOption.checked&&!t?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,i){e=!this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:i,range:this.searchRange})&&this.searchInput.value;r.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,i=0,n=0;if(t){var r,o,s=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),a=e.session.doc.positionToIndex(e.selection.anchor);for(this.searchRange&&(a-=e.session.doc.positionToIndex(this.searchRange.start)),t.lastIndex=0;(o=t.exec(s))&&((r=o.index)<=a&&n++,!(999<++i))&&(o[0]||(t.lastIndex=r+=1,!(r>=s.length))););}this.searchCounter.textContent=n+" of "+(999<i?"999+":i)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;r.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}.call(i.prototype),t.SearchBox=i,t.Search=function(e,t){(e.searchBox||new i(e)).show(e.session.getTextRange(),t)}}),ace.require(["ace/ext/searchbox"],function(e){t&&(t.exports=e)})},4091:function(t,e,i){t=i.nmd(t),ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var r=e("../lib/oop"),e=e("./text_highlight_rules").TextHighlightRules;r.inherits(n,e),t.JsonHighlightRules=n}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){}var r=e("../range").Range;!function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var i=e.getLine(t).match(/^(\s*\})/);if(!i)return 0;var i=i[1].length,n=e.findMatchingBracket({row:t,column:i});if(!n||n.row==t)return 0;n=this.$getIndent(e.getLine(n.row));e.replace(new r(t,0,t,i-1),n)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}.call(n.prototype),t.MatchingBraceOutdent=n}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,i){"use strict";var n=e("../../lib/oop"),h=e("../../range").Range,e=e("./fold_mode").FoldMode,t=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};n.inherits(t,e),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);if(this.singleLineBlockCommentRe.test(n)&&!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return"";e=this._getFoldWidgetBase(e,t,i);return!e&&this.startRegionRe.test(n)?"start":e},this.getFoldWidgetRange=function(e,t,i,n){var r=e.getLine(i);if(this.startRegionRe.test(r))return this.getCommentRegionBlock(e,r,i);var o=r.match(this.foldingStartMarker);if(o){var s=o.index;if(o[1])return this.openingBracketBlock(e,o[1],i,s);var a=e.getCommentFoldRange(i,s+o[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}return"markbegin"!==t&&(o=r.match(this.foldingStopMarker))?(s=o.index+o[0].length,o[1]?this.closingBracketBlock(e,o[1],i,s):e.getCommentFoldRange(i,s,-1)):void 0},this.getSectionRange=function(e,t){for(var i=(a=e.getLine(t)).search(/\S/),n=t,r=a.length,o=t+=1,s=e.getLength();++t<s;){var a,l=(a=e.getLine(t)).search(/\S/);if(-1!==l){if(l<i)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=n)break;if(c.isMultiLine())t=c.end.row;else if(i==l)break}o=t}}return new h(n,r,o,e.getLine(o).length)},this.getCommentRegionBlock=function(e,t,i){for(var n=t.search(/\s*$/),r=e.getLength(),o=i,s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++i<r;){t=e.getLine(i);var l=s.exec(t);if(l&&(l[1]?a--:a++,!a))break}if(o<i)return new h(o,n,i,t.length)}}.call(t.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,h){"use strict";function i(){this.HighlightRules=o,this.$outdent=new s,this.$behaviour=new a,this.foldingRules=new l}var n=e("../lib/oop"),r=e("./text").Mode,o=e("./json_highlight_rules").JsonHighlightRules,s=e("./matching_brace_outdent").MatchingBraceOutdent,a=e("./behaviour/cstyle").CstyleBehaviour,l=e("./folding/cstyle").FoldMode,c=e("../worker/worker_client").WorkerClient;n.inherits(i,r),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);return"start"==e&&t.match(/^.*[\{\(\[]\s*$/)&&(n+=i),n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(t){var e=new c(["ace"],"ace/mode/json_worker","JsonWorker");return e.attachToDocument(t.getDocument()),e.on("annotate",function(e){t.setAnnotations(e.data)}),e.on("terminate",function(){t.clearAnnotations()}),e},this.$id="ace/mode/json"}.call(i.prototype),t.Mode=i}),ace.require(["ace/mode/json"],function(e){t&&(t.exports=e)})},8903:function(e,t,g){"use strict";var s=g(5689),l=g(3969),I=g(5255),c=g(4293),v=g(3508),A=g(3368),b=g(742),p=g(9394),y=g(3724),e=((e.exports=f).prototype.validate=function(e,t){var i;if("string"==typeof e){if(!(i=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else{e=this._addSchema(e);i=e.validate||this._compile(e)}e=i(t);!0!==i.$async&&(this.errors=i.errors);return e},f.prototype.compile=function(e,t){e=this._addSchema(e,void 0,t);return e.validate||this._compile(e)},f.prototype.addSchema=function(e,t,i,n){if(Array.isArray(e)){for(var r=0;r<e.length;r++)this.addSchema(e[r],void 0,i,n);return this}var o=this._getId(e);if(void 0!==o&&"string"!=typeof o)throw new Error("schema id must be string");return h(this,t=l.normalizeId(t||o)),this._schemas[t]=this._addSchema(e,i,n,!0),this},f.prototype.addMetaSchema=function(e,t,i){return this.addSchema(e,t,i,!0),this},f.prototype.validateSchema=function(e,t){var i=e.$schema;if(void 0!==i&&"string"!=typeof i)throw new Error("$schema must be a string");if(!(i=i||this._opts.defaultMeta||function(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(m)?m:void 0,e._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);i=this.validate(i,e);if(!i&&t){e="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(e);this.logger.error(e)}return i},f.prototype.getSchema=function(e){var t=n(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return function(e,t){var i=l.schema.call(e,{schema:{}},t);{var n,r,o;if(i)return n=i.schema,r=i.root,i=i.baseId,o=s.call(e,n,r,void 0,i),e._fragments[t]=new c({ref:t,fragment:!0,schema:n,root:r,baseId:i,validate:o}),o}}(this,e)}},f.prototype.removeSchema=function(e){if(e instanceof RegExp)return i(this,this._schemas,e),i(this,this._refs,e),this;switch(typeof e){case"undefined":return i(this,this._schemas),i(this,this._refs),this._cache.clear(),this;case"string":var t=n(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":t=this._opts.serialize,t=t?t(e):e,t=(this._cache.del(t),this._getId(e));t&&(t=l.normalizeId(t),delete this._schemas[t],delete this._refs[t])}return this},f.prototype.addFormat=function(e,t){"string"==typeof t&&(t=new RegExp(t));return this._formats[e]=t,this},f.prototype.errorsText=function(e,t){if(!(e=e||this.errors))return"No errors";for(var i=void 0===(t=t||{}).separator?", ":t.separator,n=void 0===t.dataVar?"data":t.dataVar,r="",o=0;o<e.length;o++){var s=e[o];s&&(r+=n+s.dataPath+" "+s.message+i)}return r.slice(0,-i.length)},f.prototype._addSchema=function(e,t,i,n){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var r=this._opts.serialize,r=r?r(e):e,o=this._cache.get(r);if(o
)return o;n=n||!1!==this._opts.addUsedSchema;o=l.normalizeId(this._getId(e));o&&n&&h(this,o);var s,t=!1!==this._opts.validateSchema&&!t;t&&!(s=o&&o==l.normalizeId(e.$schema))&&this.validateSchema(e,!0);var a=l.ids.call(this,e),a=new c({id:o,schema:e,localRefs:a,cacheKey:r,meta:i});"#"!=o[0]&&n&&(this._refs[o]=a);this._cache.put(r,a),t&&s&&this.validateSchema(e,!0);return a},f.prototype._compile=function(i,e){if(i.compiling)return(i.validate=r).schema=i.schema,r.errors=null,r.root=e||r,!0===i.schema.$async&&(r.$async=!0),r;var t,n;i.compiling=!0,i.meta&&(t=this._opts,this._opts=this._metaOpts);try{n=s.call(this,i.schema,e,i.localRefs)}catch(e){throw delete i.validate,e}finally{i.compiling=!1,i.meta&&(this._opts=t)}return i.validate=n,i.refs=n.refs,i.refVal=n.refVal,i.root=n.root,n;function r(){var e=i.validate,t=e.apply(this,arguments);return r.errors=e.errors,t}},f.prototype.compileAsync=g(9677),g(7931)),e=(f.prototype.addKeyword=e.add,f.prototype.getKeyword=e.get,f.prototype.removeKeyword=e.remove,f.prototype.validateKeyword=e.validate,g(5359)),m=(f.ValidationError=e.Validation,f.MissingRefError=e.MissingRef,f.$dataMetaSchema=p,"http://json-schema.org/draft-07/schema"),w=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],S=["/properties"];function f(e){if(!(this instanceof f))return new f(e);e=this._opts=y.copy(e)||{};var t=this,i=t._opts.logger;if(!1===i)t.logger={log:C,warn:C,error:C};else{if(!("object"==typeof(i=void 0===i?console:i)&&i.log&&i.warn&&i.error))throw new Error("logger must implement log, warn and error methods");t.logger=i}if(this._schemas={},this._refs={},this._fragments={},this._formats=A(e.format),this._cache=e.cache||new I,this._loadingSchemas={},this._compilations=[],this.RULES=b(),this._getId=function(e){switch(e.schemaId){case"auto":return E;case"id":return x;default:return k}}(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=v),this._metaOpts=function(e){for(var t=y.copy(e._opts),i=0;i<w.length;i++)delete t[w[i]];return t}(this),e.formats){var n,r=this;for(n in r._opts.formats){var h=r._opts.formats[n];r.addFormat(n,h)}}if(e.keywords){var o,s=this;for(o in s._opts.keywords){var d=s._opts.keywords[o];s.addKeyword(o,d)}}var a,t=this,l=(t._opts.$data&&(a=g(894),t.addMetaSchema(a,a.$id,!0)),!1!==t._opts.meta&&(a=g(6680),t._opts.$data&&(a=p(a,S)),t.addMetaSchema(a,m,!0),t._refs["http://json-schema.org/schema"]=m),"object"==typeof e.meta&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),this),c=l._opts.schemas;if(c)if(Array.isArray(c))l.addSchema(c);else for(var u in c)l.addSchema(c[u],u)}function n(e,t){return t=l.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function i(e,t,i){for(var n in t){var r=t[n];r.meta||i&&!i.test(n)||(e._cache.del(r.cacheKey),delete t[n])}}function x(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function k(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function E(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function h(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function C(){}},5255:function(e){"use strict";e=e.exports=function(){this._cache={}};e.prototype.put=function(e,t){this._cache[e]=t},e.prototype.get=function(e){return this._cache[e]},e.prototype.del=function(e){delete this._cache[e]},e.prototype.clear=function(){this._cache={}}},9677:function(e,t,i){"use strict";var n=i(5359).MissingRef;function r(t,s,i){var a=this;if("function"!=typeof this._opts.loadSchema)throw new Error("options.loadSchema should be a function");"function"==typeof s&&(i=s,s=void 0);var e=l(t).then(function(){var e=a._addSchema(t,void 0,s);return e.validate||function r(o){try{return a._compile(o)}catch(e){if(e instanceof n)return t(e);throw e}function t(e){var t=e.missingSchema;if(n(t))throw new Error("Schema "+t+" is loaded but "+e.missingRef+" cannot be resolved");e=a._loadingSchemas[t];return e||(e=a._loadingSchemas[t]=a._opts.loadSchema(t)).then(i,i),e.then(function(e){if(!n(t))return l(e).then(function(){n(t)||a.addSchema(e,t,void 0,s)})}).then(function(){return r(o)});function i(){delete a._loadingSchemas[t]}function n(e){return a._refs[e]||a._schemas[e]}}}(e)});return i&&e.then(function(e){i(null,e)},i),e;function l(e){e=e.$schema;return e&&!a.getSchema(e)?r.call(a,{$ref:e},!0):Promise.resolve()}}e.exports=r},5359:function(e,t,i){"use strict";var n=i(3969);function r(e,t,i){this.message=i||r.message(e,t),this.missingRef=n.url(e,t),this.missingSchema=n.normalizeId(n.fullPath(this.missingRef))}function o(e){return e.prototype=Object.create(Error.prototype),e.prototype.constructor=e}e.exports={Validation:o(function(e){this.message="validation failed",this.errors=e,this.ajv=this.validation=!0}),MissingRef:o(r)},r.message=function(e,t){return"can't resolve reference "+t+" from id "+e}},3368:function(h,d,e){"use strict";var u=e(3724),g=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,p=[0,31,28,31,30,31,30,31,31,30,31,30,31],m=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i,e=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,f=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,t=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,i=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,n=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,r=/^(?:\/(?:[^~/]|~0|~1)*)*$/,o=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,s=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function a(e){return u.copy(a[e="full"==e?"full":"fast"])}function l(e){e=e.match(g);if(!e)return!1;var t=+e[1],i=+e[2],e=+e[3];return 1<=i&&i<=12&&1<=e&&e<=(2!=i||((e=t)%4!=0||e%100==0&&e%400!=0)?p[i]:29)}function c(e,t){e=e.match(m);if(!e)return!1;var i=e[1],n=e[2],r=e[3],e=e[5];return(i<=23&&n<=59&&r<=59||23==i&&59==n&&60==r)&&(!t||e)}(h.exports=a).fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,uri:/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":t,url:i,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:e,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:A,uuid:n,"json-pointer":r,"json-pointer-uri-fragment":o,"relative-json-pointer":s},a.full={date:l,time:c,"date-time":function(e){e=e.split(C);return 2==e.length&&l(e[0])&&c(e[1],!0)},uri:function(e){return I.test(e)&&f.test(e)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":t,url:i,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:e,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:A,uuid:n,"json-pointer":r,"json-pointer-uri-fragment":o,"relative-json-pointer":s};var C=/t|\s/i;var I=/\/|:/;var v=/[^\\]\\Z/;function A(e){if(v.test(e))return!1;try{return new RegExp(e),!0}catch(e){return!1}}},5689:function(e,i,t){"use strict";var E=t(3969),R=t(3724),T=t(5359),_=t(3508),$=t(1869),N=R.ucs2length,G=t(2303),P=T.Validation;function L(e,s,a,n){var l=this,c=this._opts,h=[void 0],d={},g=[],r={},u=[],o={},p=[],m=(s=s||{schema:e,refVal:h,refs:d},function(e,t,i){var n=B.call(this,e,t,i);return 0<=n?{index:n,compiling:!0}:(n=this._compilations.length,this._compilations[n]={schema:e,root:t,baseId:i},{index:n,compiling:!1})}.call(this,e,s,n)),f=this._compilations[m.index];if(m.compiling)return f.callValidate=v;var C=this._formats,I=this.RULES;try{var t=A(e,s,a,n),i=(f.validate=t,f.callValidate);return i&&(i.schema=t.schema,i.errors=null,i.refs=t.refs,i.refVal=t.refVal,i.root=t.root,i.$async=t.$async,c.sourceCode&&(i.source=t.source)),t}finally{!function(e,t,i){e=B.call(this,e,t,i);0<=e&&this._compilations.splice(e,1)}.call(this,e,s,n)}function v(){var e=f.validate,t=e.apply(this,arguments);return v.errors=e.errors,t}function A(e,t,i,n){var r=!t||t.schema==e;if(t.schema!=s.schema)return L.call(l,e,t,i,n);i=!0===e.$async,n=$({isTop:!0,schema:e,isRoot:r,baseId:n,root:t,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:T.MissingRef,RULES:I,validate:$,util:R,resolve:E,resolveRef:b,usePattern:S,useDefault:x,useCustomRule:k,opts:c,formats:C,logger:l.logger,self:l}),n=W(h,V)+W(g,F)+W(u,H)+W(p,Z)+n;c.processCode&&(n=c.processCode(n,e));try{var o=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",n)(l,I,C,s,h,u,p,G,N,P);h[0]=o}catch(e){throw l.logger.error("Error compiling schema, function code:",n),e}return o.schema=e,o.errors=null,o.refs=d,o.refVal=h,o.root=r?o:t,i&&(o.$async=!0),!0===c.sourceCode&&(o.source={code:n,patterns:g,defaults:u}),o}function b(e,t,i){t=E.url(e,t);var n=d[t];if(void 0!==n)return w(r=h[n],o="refVal["+n+"]");if(!i&&s.refs){n=s.refs[t];if(void 0!==n)return w(r=s.refVal[n],o=y(t,r))}var r,o=y(t),i=E.call(l,A,s,t);if(void 0!==i||(n=a&&a[t])&&(i=E.inlineRef(n,c.inlineRefs)?n:L.call(l,n,s,a,e)),void 0!==i)return r=i,n=d[n=t],h[n]=r,w(i,o);delete d[t]}function y(e,t){var i=h.length;return h[i]=t,"refVal"+(d[e]=i)}function w(e,t){return"object"==typeof e||"boolean"==typeof e?{code:t,schema:e,inline:!0}:{code:t,$async:e&&!!e.$async}}function S(e){var t=r[e];return void 0===t&&(t=r[e]=g.length,g[t]=e),"pattern"+t}function x(e){switch(typeof e){case"boolean":case"number":return""+e;case"string":return R.toQuotedString(e);case"object":if(null===e)return"null";var t=_(e),i=o[t];return void 0===i&&(i=o[t]=u.length,u[i]=e),"default"+i}}function k(e,t,i,n){if(!1!==l._opts.validateSchema){var r=e.definition.dependencies;if(r&&!r.every(function(e){return Object.prototype.hasOwnProperty.call(i,e)}))throw new Error("parent schema must have all required keywords: "+r.join(","));r=e.definition.validateSchema;if(r)if(!r(t)){r="keyword schema is invalid: "+l.errorsText(r.errors);if("log"!=l._opts.validateSchema)throw new Error(r);l.logger.error(r)}}var o,r=e.definition.compile,s=e.definition.inline,a=e.definition.macro;if(r)o=r.call(l,t,i,n);else if(a)o=a.call(l,t,i,n),!1!==c.validateSchema&&l.validateSchema(o,!0);else if(s)o=s.call(l,n,e.keyword,t,i);else if(!(o=e.definition.validate))return;if(void 0===o)throw new Error('custom keyword "'+e.keyword+'"failed to compile');r=p.length;return{code:"customRule"+r,validate:p[r]=o}}}function B(e,t,i){for(var n=0;n<this._compilations.length;n++){var r=this._compilations[n];if(r.schema==e&&r.root==t&&r.baseId==i)return n}return-1}function F(e,t){return"var pattern"+e+" = new RegExp("+R.toQuotedString(t[e])+");"}function H(e){return"var default"+e+" = defaults["+e+"];"}function V(e,t){return void 0===t[e]?"":"var refVal"+e+" = refVal["+e+"];"}function Z(e){return"var customRule"+e+" = customRules["+e+"];"}function W(e,t){if(!e.length)return"";for(var i="",n=0;n<e.length;n++)i+=t(n,e);return i}e.exports=L},3969:function(t,i,e){"use strict";var g=e(7533),f=e(2303),p=e(3724),a=e(4293),n=e(500);function l(e,t,i){var n=this._refs[i];if("string"==typeof n){if(!this._refs[n])return l.call(this,e,t,n);n=this._refs[n]}if((n=n||this._schemas[i])instanceof a)return h(n.schema,this._opts.inlineRefs)?n.schema:n.validate||this._compile(n);var r,o,s,n=c.call(this,t,i);return n&&(r=n.schema,t=n.root,s=n.baseId),r instanceof a?o=r.validate||e.call(this,r.schema,t,void 0,s):void 0!==r&&(o=h(r,this._opts.inlineRefs)?r:e.call(this,r,t,void 0,s)),o}function c(e,t){var i=g.parse(t),n=v(i),r=s(this._getId(e.schema));if(0===Object.keys(e.schema).length||n!==r){var n=m(n),o=this._refs[n];if("string"==typeof o)return function(e,t,i){t=c.call(this,e,t);{var n,r;if(t)return n=t.schema,r=t.baseId,e=t.root,(t=this._getId(n))&&(r=d(r,t)),C.call(this,i,r,n,e)}}.call(this,e,o,i);if(o instanceof a)o.validate||this._compile(o),e=o;else{if(!((o=this._schemas[n])instanceof a))return;if(o.validate||this._compile(o),n==m(t))return{schema:o,root:e,baseId:r};e=o}if(!e.schema)return;r=s(this._getId(e.schema))}return C.call(this,i,r,e.schema,e)}(t.exports=l).normalizeId=m,l.fullPath=s,l.url=d,l.ids=function(e){var t=m(this._getId(e)),c={"":t},h={"":s(t,!1)},d={},u=this;return n(e,{allKeys:!0},function(e,t,i,n,r,o,s){if(""!==t){var a=u._getId(e),l=c[n],n=h[n]+"/"+r;if(void 0!==s&&(n+="/"+("number"==typeof s?s:p.escapeFragment(s))),"string"==typeof a){a=l=m(l?g.resolve(l,a):a),r=u._refs[a];if((r="string"==typeof r?u._refs[r]:r)&&r.schema){if(!f(e,r.schema))throw new Error('id "'+a+'" resolves to more than one schema')}else if(a!=m(n))if("#"==a[0]){if(d[a]&&!f(e,d[a]))throw new Error('id "'+a+'" resolves to more than one schema');d[a]=e}else u._refs[a]=n}c[t]=l,h[t]=n}}),d},l.inlineRef=h,l.schema=c;var u=p.toHash(["properties","patternProperties","enum","dependencies","definitions"]);function C(e,t,i,n){if(e.fragment=e.fragment||"","/"==e.fragment.slice(0,1)){for(var r=e.fragment.split("/"),o=1;o<r.length;o++){var s=r[o];if(s){if(void 0===(i=i[s=p.unescapeFragment(s)]))break;u[s]||((s=this._getId(i))&&(t=d(t,s)),i.$ref&&(s=d(t,i.$ref),(s=c.call(this,n,s))&&(i=s.schema,n=s.root,t=s.baseId)))}}return void 0!==i&&i!==n.schema?{schema:i,root:n,baseId:t}:void 0}}var I=p.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]);function h(e,t){return!1!==t&&(void 0===t||!0===t?function e(t){var i;if(Array.isArray(t)){for(var n=0;n<t.length;n++)if("object"==typeof(i=t[n])&&!e(i))return!1}else for(var r in t){if("$ref"==r)return!1;if("object"==typeof(i=t[r])&&!e(i))return!1}return!0}(e):t?function e(t){var i,n=0;if(Array.isArray(t)){for(var r=0;r<t.length;r++)if("object"==typeof(i=t[r])&&(n+=e(i)),n==1/0)return 1/0}else for(var o in t){if("$ref"==o)return 1/0;if(I[o])n++;else if("object"==typeof(i=t[o])&&(n+=e(i)+1),n==1/0)return 1/0}return n}(e)<=t:void 0)}function s(e,t){return!1!==t&&(e=m(e)),v(g.parse(e))}function v(e){return g.serialize(e).split("#")[0]+"#"}var r=/#\/?$/;function m(e){return e?e.replace(r,""):""}function d(e,t){return t=m(t),g.resolve(e,t)}},742:function(e,t,i){"use strict";var o=i(9646),s=i(3724).toHash;e.exports=function(){var n=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],r=["type","$comment"];return n.all=s(r),n.types=s(["number","integer","string","array","object","boolean","null"]),n.forEach(function(e){e.rules=e.rules.map(function(e){var t,i;return"object"==typeof e&&(i=e[t=Object.keys(e)[0]],e=t,i.forEach(function(e){r.push(e),n.all[e]=!0})),r.push(e),n.all[e]={keyword:e,code:o[e],implements:i}}),n.all.$comment={keyword:"$comment",code:o.$comment},e.type&&(n.types[e.type]=e)}),n.keywords=s(r.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),n.custom={},n}},4293:function(e,t,i){"use strict";var n=i(3724);e.exports=function(e){n.copy(e,this)}},6887:function(e){"use strict";e.exports=function(e){for(var t,i=0,n=e.length,r=0;r<n;)i++,55296<=(t=e.charCodeAt(r++))&&t<=56319&&r<n&&56320==(64512&(t=e.charCodeAt(r)))&&r++;return i}},3724:function(i,c,e){"use strict";function o(e,t,i,n){var r=n?" !== ":" === ",o=n?" || ":" && ",s=n?"!":"",a=n?"":"!";switch(e){case"null":return t+r+"null";case"array":return s+"Array.isArray("+t+")";case"object":return"("+s+t+o+"typeof "+t+r+'"object"'+o+a+"Array.isArray("+t+"))";case"integer":return"(typeof "+t+r+'"number"'+o+a+"("+t+" % 1)"+o+t+r+t+(i?o+s+"isFinite("+t+")":"")+")";case"number":return"(typeof "+t+r+'"'+e+'"'+(i?o+s+"isFinite("+t+")":"")+")";default:return"typeof "+t+r+'"'+e+'"'}}i.exports={copy:function(e,t){for(var i in t=t||{},e)t[i]=e[i];return t},checkDataType:o,checkDataTypes:function(e,t,i){{if(1===e.length)return o(e[0],t,i,!0);var n,r="",e=a(e);for(n in e.array&&e.object&&(r=e.null?"(":"(!"+t+" || ",r+="typeof "+t+' !== "object")',delete e.null,delete e.array,delete e.object),e.number&&delete e.integer,e)r+=(r?" && ":"")+o(n,t,i,!0);return r}},coerceToTypes:function(e,t){{if(!Array.isArray(t))return s[t]?[t]:"array"===e&&"array"===t?["array"]:void 0;for(var i=[],n=0;n<t.length;n++){var r=t[n];(s[r]||"array"===e&&"array"===r)&&(i[i.length]=r)}if(i.length)return i}},toHash:a,getProperty:h,escapeQuotes:t,equal:e(2303),ucs2length:e(6887),varOccurences:function(e,t){t+="[^0-9]";e=e.match(new RegExp(t,"g"));return e?e.length:0},varReplace:function(e,t,i){return t+="([^0-9])",i=i.replace(/\$/g,"$$$$"),e.replace(new RegExp(t,"g"),i+"$1")},schemaHasRules:function(e,t){if("boolean"==typeof e)return!e;for(var i in e)if(t[i])return!0},schemaHasRulesExcept:function(e,t,i){if("boolean"==typeof e)return!e&&"not"!=i;for(var n in e)if(n!=i&&t[n])return!0},schemaUnknownRules:function(e,t){if("boolean"!=typeof e)for(var i in e)if(!t[i])return i},toQuotedString:n,getPathExpr:function(e,t,i,n){return r(e,i?"'/' + "+t+(n?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):n?"'[' + "+t+" + ']'":"'[\\'' + "+t+" + '\\']'")},getPath:function(e,t,i){i=n(i?"/"+l(t):h(t));return r(e,i)},getData:function(e,t,i){var n,r,o;if(""===e)return"rootData";if("/"==e[0]){if(!p.test(e))throw new Error("Invalid JSON-pointer: "+e);n=e,r="rootData"}else{if(!(o=e.match(m)))throw new Error("Invalid JSON-pointer: "+e);if(e=+o[1],"#"==(n=o[2])){if(t<=e)throw new Error("Cannot access property/index "+e+" levels up, current level is "+t);return i[t-e]}if(t<e)throw new Error("Cannot access data "+e+" levels up, current level is "+t);if(r="data"+(t-e||""),!n)return r}for(var s=r,a=n.split("/"),l=0;l<a.length;l++){var c=a[l];c&&(r+=h(d(c)),s+=" && "+r)}return s},unescapeFragment:function(e){return d(decodeURIComponent(e))},unescapeJsonPointer:d,escapeFragment:function(e){return encodeURIComponent(l(e))},escapeJsonPointer:l};var s=a(["string","number","integer","boolean","null"]);function a(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=!0;return t}var u=/^[a-z$_][a-z$_0-9]*$/i,g=/'|\\/g;function h(e){return"number"==typeof e?"["+e+"]":u.test(e)?"."+e:"['"+t(e)+"']"}function t(e){return e.replace(g,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}function n(e){return"'"+t(e)+"'"}var p=/^\/(?:[^~]|~0|~1)*$/,m=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function r(e,t){return'""'==e?t:(e+" + "+t).replace(/([^\\])' \+ '/g,"$1")}function l(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}function d(e){return e.replace(/~1/g,"/").replace(/~0/g,"~")}},9394:function(e){"use strict";var l=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];e.exports=function(e,t){for(var i=0;i<t.length;i++){e=JSON.parse(JSON.stringify(e));for(var n=t[i].split("/"),r=e,o=1;o<n.length;o++)r=r[n[o]];for(o=0;o<l.length;o++){var s=l[o],a=r[s];a&&(r[s]={anyOf:[a,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]})}}return e}},5868:function(e,t,i){"use strict";i=i(6680);e.exports={$id:"https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:i.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:i.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},1796:function(e){"use strict";e.exports=function(e,h,d){var u,g,p,m,f,t=" ",i=e.level,n=e.dataLevel,r=e.schema[h],C=e.schemaPath+e.util.getProperty(h),I=e.errSchemaPath+"/"+h,v=!e.opts.allErrors,o="data"+(n||""),s=e.opts.$data&&r&&r.$data,a=s?(t+=" var schema"+i+" = "+e.util.getData(r.$data,n,e.dataPathArr)+"; ","schema"+i):r,A="maximum"==h,b=A?"exclusiveMaximum":"exclusiveMinimum",l=e.schema[b],y=e.opts.$data&&l&&l.$data,w=A?"<":">",c=A?">":"<",S=void 0;if(!s&&"number"!=typeof r&&void 0!==r)throw new Error(h+" must be number");if(!y&&void 0!==l&&"number"!=typeof l&&"boolean"!=typeof l)throw new Error(b+" must be number or boolean");y?(n=e.util.getData(l.$data,n,e.dataPathArr),p="exclIsNumber"+i,m="' + "+(f="op"+i)+" + '",S=b,(x=x||[]).push(t=t+(" var schemaExcl"+i+" = "+n+"; ")+(" var "+(u="exclusive"+i)+"; var "+(g="exclType"+i)+" = typeof "+(n="schemaExcl"+i)+"; if ("+g+" != 'boolean' && "+g+" != 'undefined' && "+g+" != 'number') { ")),t="",!1!==e.createErrors?(t+=" { keyword: '"+(S||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(I)+" , params: {} ",!1!==e.opts.messages&&(t+=" , message: '"+b+" should be boolean' "),e.opts.verbose&&(t+=" , schema: validate.schema"+C+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+o+" "),t+=" } "):t+=" {} ",k=t,t=x.pop(),!e.compositeRule&&v?e.async?t+=" throw new ValidationError(["+k+"]); ":t+=" validate.errors = ["+k+"]; return false; ":t+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } else if ( ",s&&(t+=" ("+a+" !== undefined && typeof "+a+" != 'number') || "),t+=" "+g+" == 'number' ? ( ("+u+" = "+a+" === undefined || "+n+" "+w+"= "+a+") ? "+o+" "+c+"= "+n+" : "+o+" "+c+" "+a+" ) : ( ("+u+" = "+n+" === true) ? "+o+" "+c+"= "+a+" : "+o+" "+c+" "+a+" ) || "+o+" !== "+o+") { var op"+i+" = "+u+" ? '"+w+"' : '"+w+"='; ",void 0===r&&(I=e.errSchemaPath+"/"+(S=b),a=n,s=y)):(m=w,(p="number"==typeof l)&&s?(f="'"+m+"'",t+=" if ( ",s&&(t+=" ("+a+" !== undefined && typeof "+a+" != 'number') || "),t+=" ( "+a+" === undefined || "+l+" "+w+"= "+a+" ? "+o+" "+c+"= "+l+" : "+o+" "+c+" "+a+" ) || "+o+" !== "+o+") { "):(p&&void 0===r?(u=!0,I=e.errSchemaPath+"/"+(S=b),a=l,c+="="):(p&&(a=Math[A?"min":"max"](l,r)),l===(!p||a)?(u=!0,I=e.errSchemaPath+"/"+(S=b),c+="="):(u=!1,m+="=")),f="'"+m+"'",t+=" if ( ",s&&(t+=" ("+a+" !== undefined && typeof "+a+" != 'number') || "),t+=" "+o+" "+c+" "+a+" || "+o+" !== "+o+") { ")),S=S||h;(x=x||[]).push(t),t="",!1!==e.createErrors?(t+=" { keyword: '"+(S||"_limit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(I)+" , params: { comparison: "+f+", limit: "+a+", exclusive: "+u+" } ",!1!==e.opts.messages&&(t=t+" , message: 'should be "+m+" "+(s?"' + "+a:a+"'")),e.opts.verbose&&(t=(t+=" , schema:  ")+(s?"validate.schema"+C:""+r)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+o+" "),t+=" } "):t+=" {} ";var x,k=t;return t=x.pop(),!e.compositeRule&&v?e.async?t+=" throw new ValidationError(["+k+"]); ":t+=" validate.errors = ["+k+"]; return false; ":t+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } ",v&&(t+=" else { "),t}},2407:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],d=e.schemaPath+e.util.getProperty(t),u=e.errSchemaPath+"/"+t,s=!e.opts.allErrors,a="data"+(r||""),l=e.opts.$data&&o&&o.$data,r=l?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;if(!l&&"number"!=typeof o)throw new Error(t+" must be number");i+="if ( ",l&&(i+=" ("+r+" !== undefined && typeof "+r+" != 'number') || ");var n=t,c=[],n=(c.push(i+=" "+a+".length "+("maxItems"==t?">":"<")+" "+r+") { "),i="",!1!==e.createErrors?(i+=" { keyword: '"+(n||"_limitItems")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(u)+" , params: { limit: "+r+" } ",!1!==e.opts.messages&&(i=(i=(i+=" , message: 'should NOT have ")+("maxItems"==t?"more":"fewer")+" than ")+(l?"' + "+r+" + '":""+o)+" items' "),e.opts.verbose&&(i=(i+=" , schema:  ")+(l?"validate.schema"+d:""+o)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),i+=" } "):i+=" {} ",i),i=c.pop();return!e.compositeRule&&s?e.async?i+=" throw new ValidationError(["+n+"]); ":i+=" validate.errors = ["+n+"]; return false; ":i+=" var err = "+n+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",s&&(i+=" else { "),i}},1250:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],d=e.schemaPath+e.util.getProperty(t),u=e.errSchemaPath+"/"+t,s=!e.opts.allErrors,a="data"+(r||""),l=e.opts.$data&&o&&o.$data,r=l?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;if(!l&&"number"!=typeof o)throw new Error(t+" must be number");i+="if ( ",l&&(i+=" ("+r+" !== undefined && typeof "+r+" != 'number') || "),!1===e.opts.unicode?i+=" "+a+".length ":i+=" ucs2length("+a+") ";var n=t,c=[],n=(c.push(i+=" "+("maxLength"==t?">":"<")+" "+r+") { "),i="",!1!==e.createErrors?(i+=" { keyword: '"+(n||"_limitLength")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(u)+" , params: { limit: "+r+" } ",!1!==e.opts.messages&&(i=(i=(i+=" , message: 'should NOT be ")+("maxLength"==t?"longer":"shorter")+" than ")+(l?"' + "+r+" + '":""+o)+" characters' "),e.opts.verbose&&(i=(i+=" , schema:  ")+(l?"validate.schema"+d:""+o)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),i+=" } "):i+=" {} ",i),i=c.pop();return!e.compositeRule&&s?e.async?i+=" throw new ValidationError(["+n+"]); ":i+=" validate.errors = ["+n+"]; return false; ":i+=" var err = "+n+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",s&&(i+=" else { "),i}},2596:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],d=e.schemaPath+e.util.getProperty(t),u=e.errSchemaPath+"/"+t,s=!e.opts.allErrors,a="data"+(r||""),l=e.opts.$data&&o&&o.$data,r=l?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;if(!l&&"number"!=typeof o)throw new Error(t+" must be number");i+="if ( ",l&&(i+=" ("+r+" !== undefined && typeof "+r+" != 'number') || ");var n=t,c=[],n=(c.push(i+=" Object.keys("+a+").length "+("maxProperties"==t?">":"<")+" "+r+") { "),i="",!1!==e.createErrors?(i+=" { keyword: '"+(n||"_limitProperties")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(u)+" , params: { limit: "+r+" } ",!1!==e.opts.messages&&(i=(i=(i+=" , message: 'should NOT have ")+("maxProperties"==t?"more":"fewer")+" than ")+(l?"' + "+r+" + '":""+o)+" properties' "),e.opts.verbose&&(i=(i+=" , schema:  ")+(l?"validate.schema"+d:""+o)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),i+=" } "):i+=" {} ",i),i=c.pop();return!e.compositeRule&&s?e.async?i+=" throw new ValidationError(["+n+"]); ":i+=" validate.errors = ["+n+"]; return false; ":i+=" var err = "+n+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",s&&(i+=" else { "),i}},9486:function(e){"use strict";e.exports=function(e,t,h){var i=" ",d=e.schema[t],u=e.schemaPath+e.util.getProperty(t),g=e.errSchemaPath+"/"+t,n=!e.opts.allErrors,r=e.util.copy(e),o="",p=(r.level++,"valid"+r.level),m=r.baseId,s=!0,a=d;if(a)for(var l,c=-1,f=a.length-1;c<f;)l=a[c+=1],(e.opts.strictKeywords?"object"==typeof l&&0<Object.keys(l).length||!1===l:e.util.schemaHasRules(l,e.RULES.all))&&(s=!1,r.schema=l,r.schemaPath=u+"["+c+"]",r.errSchemaPath=g+"/"+c,i+="  "+e.validate(r)+" ",r.baseId=m,n&&(i+=" if ("+p+") { ",o+="}"));return n&&(i+=s?" if (true) { ":" "+o.slice(0,-1)+" "),i}},5347:function(e){"use strict";e.exports=function(t,e,h){var i=" ",n=t.level,r=t.dataLevel,o=t.schema[e],d=t.schemaPath+t.util.getProperty(e),u=t.errSchemaPath+"/"+e,e=!t.opts.allErrors,r="data"+(r||""),s="valid"+n,n="errs__"+n,a=t.util.copy(t),g="",p=(a.level++,"valid"+a.level);if(o.every(function(e){return t.opts.strictKeywords?"object"==typeof e&&0<Object.keys(e).length||!1===e:t.util.schemaHasRules(e,t.RULES.all)})){var m=a.baseId,f=(i+=" var "+n+" = errors; var "+s+" = false;  ",t.compositeRule),l=(t.compositeRule=a.compositeRule=!0,o);if(l)for(var C,c=-1,I=l.length-1;c<I;)C=l[c+=1],a.schema=C,a.schemaPath=d+"["+c+"]",a.errSchemaPath=u+"/"+c,i+="  "+t.validate(a)+" ",a.baseId=m,i+=" "+s+" = "+s+" || "+p+"; if (!"+s+") { ",g+="}";t.compositeRule=a.compositeRule=f,i+=" "+g+" if (!"+s+") {   var err =   ",!1!==t.createErrors?(i+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+t.errorPath+" , schemaPath: "+t.util.toQuotedString(u)+" , params: {} ",!1!==t.opts.messages&&(i+=" , message: 'should match some schema in anyOf' "),t.opts.verbose&&(i+=" , schema: validate.schema"+d+" , parentSchema: validate.schema"+t.schemaPath+" , data: "+r+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!t.compositeRule&&e&&(t.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+=" } else {  errors = "+n+"; if (vErrors !== null) { if ("+n+") vErrors.length = "+n+"; else vErrors = null; } ",t.opts.allErrors&&(i+=" } ")}else e&&(i+=" if (true) { ");return i}},923:function(e){"use strict";e.exports=function(e,t,i){var n=" ",r=e.schema[t],t=e.errSchemaPath+"/"+t,r=(e.opts.allErrors,e.util.toQuotedString(r));return!0===e.opts.$comment?n+=" console.log("+r+");":"function"==typeof e.opts.$comment&&(n+=" self._opts.$comment("+r+", "+e.util.toQuotedString(t)+", validate.root.schema);"),n}},2617:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,a=!e.opts.allErrors,l="data"+(r||""),c="valid"+n,d=e.opts.$data&&o&&o.$data,o=(d&&(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; "),d||(i+=" var schema"+n+" = validate.schema"+s+";"),[]),r=(o.push(i+="var "+c+" = equal("+l+", schema"+n+"); if (!"+c+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'const' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { allowedValue: schema"+n+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be equal to constant' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+l+" "),i+=" } "):i+=" {} ",i),i=o.pop();return!e.compositeRule&&a?e.async?i+=" throw new ValidationError(["+r+"]); ":i+=" validate.errors = ["+r+"]; return false; ":i+=" var err = "+r+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" }",a&&(i+=" else { "),i}},2119:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],d=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,u=!e.opts.allErrors,r="data"+(r||""),g="valid"+n,s="errs__"+n,a=e.util.copy(e),p=(a.level++,"valid"+a.level),n="i"+n,l=a.dataLevel=e.dataLevel+1,m="data"+l,c=e.baseId,f=e.opts.strictKeywords?"object"==typeof o&&0<Object.keys(o).length||!1===o:e.util.schemaHasRules(o,e.RULES.all),n=(i+="var "+s+" = errors;var "+g+";",f?(g=e.compositeRule,e.compositeRule=a.compositeRule=!0,a.schema=o,a.schemaPath=d,a.errSchemaPath=t,i+=" var "+p+" = false; for (var "+n+" = 0; "+n+" < "+r+".length; "+n+"++) { ",a.errorPath=e.util.getPathExpr(e.errorPath,n,e.opts.jsonPointers,!0),o=r+"["+n+"]",a.dataPathArr[l]=n,l=e.validate(a),a.baseId=c,e.util.varOccurences(l,m)<2?i+=" "+e.util.varReplace(l,m,o)+" ":i+=" var "+m+" = "+o+"; "+l+" ",i+=" if ("+p+") break; }  ",e.compositeRule=a.compositeRule=g,i+="  if (!"+p+") {"):i+=" if ("+r+".length == 0) {",[]),c=(n.push(i),i="",!1!==e.createErrors?(i+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: {} ",!1!==e.opts.messages&&(i+=" , message: 'should contain a valid item' "),e.opts.verbose&&(i+=" , schema: validate.schema"+d+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+r+" "),i+=" } "):i+=" {} ",i),i=n.pop();return!e.compositeRule&&u?e.async?i+=" throw new ValidationError(["+c+"]); ":i+=" validate.errors = ["+c+"]; return false; ":i+=" var err = "+c+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else { ",f&&(i+="  errors = "+s+"; if (vErrors !== null) { if ("+s+") vErrors.length = "+s+"; else vErrors = null; } "),e.opts.allErrors&&(i+=" } "),i}},1793:function(e){"use strict";e.exports=function(e,t,h){var d,u,g,i=" ",n=e.level,p=e.dataLevel,r=e.schema[t],m=e.schemaPath+e.util.getProperty(t),f=e.errSchemaPath+"/"+t,C=!e.opts.allErrors,I="data"+(p||""),o="valid"+n,v="errs__"+n,s=e.opts.$data&&r&&r.$data,A=s?(i+=" var schema"+n+" = "+e.util.getData(r.$data,p,e.dataPathArr)+"; ","schema"+n):r,a="definition"+n,l=this.definition,b="";if(s&&l.$data){var y="keywordValidate"+n,w=l.validateSchema;i+=" var "+a+" = RULES.custom['"+t+"'].definition; var "+y+" = "+a+".validate;"}else{if(!(E=e.useCustomRule(this,r,e.schema,e)))return;A="validate.schema"+m,y=E.code,d=l.compile,u=l.inline,g=l.macro}var S,x,k,E,R,t=y+".errors",r="i"+n,c="ruleErr"+n,T=l.async;if(T&&!e.async)throw new Error("async keyword in sync schema");return u||g||(i+=t+" = null;"),i+="var "+v+" = errors;var "+o+";",s&&l.$data&&(b+="}",i+=" if ("+A+" === undefined) { "+o+" = true; } else { ",w&&(b+="}",i+=" "+o+" = "+a+".validateSchema("+A+"); if ("+o+") { ")),u?l.statements?i+=" "+E.validate+" ":i+=" "+o+" = "+E.validate+"; ":g?(b="",(s=e.util.copy(e)).level++,S="valid"+s.level,s.schema=E.validate,s.schemaPath="",w=e.compositeRule,e.compositeRule=s.compositeRule=!0,a=e.validate(s).replace(/validate\.schema/g,y),e.compositeRule=s.compositeRule=w,i+=" "+a):((R=R||[]).push(i),i="",i+="  "+y+".call( ",e.opts.passContext?i+="this":i+="self",d||!1===l.schema?i+=" , "+I+" ":i+=" , "+A+" , "+I+" , validate.schema"+e.schemaPath+" ",i+=" , (dataPath || '')",'""'!=e.errorPath&&(i+=" + "+e.errorPath),E=i+=" , "+(x=p?"data"+(p-1||""):"parentData")+" , "+(k=p?e.dataPathArr[p]:"parentDataProperty")+" , rootData )  ",i=R.pop(),!1===l.errors?(i+=" "+o+" = ",T&&(i+="await "),i+=E+"; "):i+=T?" var "+(t="customErrors"+n)+" = null; try { "+o+" = await "+E+"; } catch (e) { "+o+" = false; if (e instanceof ValidationError) "+t+" = e.errors; else throw e; } ":" "+t+" = null; "+o+" = "+E+"; "),l.modifying&&(i+=" if ("+x+") "+I+" = "+x+"["+k+"];"),i+=""+b,l.valid?C&&(i+=" if (true) { "):(i+=" if ( ",void 0===l.valid?i=i+" !"+(g?""+S:o):i+=" "+!l.valid+" ",s=this.keyword,(R=R||[]).push(i+=") { "),(R=R||[]).push(i=""),i="",!1!==e.createErrors?(i+=" { keyword: '"+(s||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(f)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(i+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(i+=" , schema: validate.schema"+m+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+I+" "),i+=" } "):i+=" {} ",w=i,i=R.pop(),!e.compositeRule&&C?e.async?i+=" throw new ValidationError(["+w+"]); ":i+=" validate.errors = ["+w+"]; return false; ":i+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a=i,i=R.pop(),u?l.errors?"full"!=l.errors&&(i+="  for (var "+r+"="+v+"; "+r+"<errors; "+r+"++) { var "+c+" = vErrors["+r+"]; if ("+c+".dataPath === undefined) "+c+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+c+".schemaPath === undefined) { "+c+'.schemaPath = "'+f+'"; } ',e.opts.verbose&&(i+=" "+c+".schema = "+A+"; "+c+".data = "+I+"; "),i+=" } "):!1===l.errors?i+=" "+a+" ":(i+=" if ("+v+" == errors) { "+a+" } else {  for (var "+r+"="+v+"; "+r+"<errors; "+r+"++) { var "+c+" = vErrors["+r+"]; if ("+c+".dataPath === undefined) "+c+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+c+".schemaPath === undefined) { "+c+'.schemaPath = "'+f+'"; } ',e.opts.verbose&&(i+=" "+c+".schema = "+A+"; "+c+".data = "+I+"; "),i+=" } } "):g?(i+="   var err =   ",!1!==e.createErrors?(i+=" { keyword: '"+(s||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(f)+" , params: { keyword: '"+this.keyword+"' } ",!1!==e.opts.messages&&(i+=" , message: 'should pass \""+this.keyword+"\" keyword validation' "),e.opts.verbose&&(i+=" , schema: validate.schema"+m+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+I+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&C&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; ")):!1===l.errors?i+=" "+a+" ":(i+=" if (Array.isArray("+t+")) { if (vErrors === null) vErrors = "+t+"; else vErrors = vErrors.concat("+t+"); errors = vErrors.length;  for (var "+r+"="+v+"; "+r+"<errors; "+r+"++) { var "+c+" = vErrors["+r+"]; if ("+c+".dataPath === undefined) "+c+".dataPath = (dataPath || '') + "+e.errorPath+";  "+c+'.schemaPath = "'+f+'";  ',e.opts.verbose&&(i+=" "+c+".schema = "+A+"; "+c+".data = "+I+"; "),i+=" } } else { "+a+" } "),i+=" } ",C&&(i+=" else { ")),i}},9115:function(e){"use strict";e.exports=function(e,t,h){var i,n=" ",d=e.level,u=e.dataLevel,g=e.schema[t],p=e.schemaPath+e.util.getProperty(t),m=e.errSchemaPath+"/"+t,f=!e.opts.allErrors,r="data"+(u||""),t="errs__"+d,o=e.util.copy(e),C="",I=(o.level++,"valid"+o.level),v={},A={},b=e.opts.ownProperties;for(l in g)"__proto__"!=l&&(c=g[l],(i=Array.isArray(c)?A:v)[l]=c);var y=e.errorPath;for(l in n=n+("var "+t+" = errors;")+("var missing"+d+";"),A)if((i=A[l]).length){if(n+=" if ( "+r+e.util.getProperty(l)+" !== undefined ",b&&(n+=" && Object.prototype.hasOwnProperty.call("+r+", '"+e.util.escapeQuotes(l)+"') "),f){n+=" && ( ";var w=i;if(w)for(var S=-1,x=w.length-1;S<x;)a=w[S+=1],S&&(n+=" || "),n+=" ( ( "+(L=r+($=e.util.getProperty(a)))+" === undefined ",b&&(n+=" || ! Object.prototype.hasOwnProperty.call("+r+", '"+e.util.escapeQuotes(a)+"') "),n+=") && (missing"+d+" = "+e.util.toQuotedString(e.opts.jsonPointers?a:$)+") ) ";n+=")) {  ";var s="missing"+d,k="' + "+s+" + '",E=(e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(y,s,!0):y+" + "+s),E||[]),s=(E.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(m)+" , params: { property: '"+e.util.escapeQuotes(l)+"', missingProperty: '"+k+"', depsCount: "+i.length+", deps: '"+e.util.escapeQuotes(1==i.length?i[0]:i.join(", "))+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should have ",1==i.length?n+="property "+e.util.escapeQuotes(i[0]):n+="properties "+e.util.escapeQuotes(i.join(", ")),n+=" when property "+e.util.escapeQuotes(l)+" is present' "),e.opts.verbose&&(n+=" , schema: validate.schema"+p+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+r+" "),n+=" } "):n+=" {} ",n),n=E.pop();!e.compositeRule&&f?e.async?n+=" throw new ValidationError(["+s+"]); ":n+=" validate.errors = ["+s+"]; return false; ":n+=" var err = "+s+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{n+=" ) { ";var R=i;if(R)for(var a,T=-1,_=R.length-1;T<_;){a=R[T+=1];var $=e.util.getProperty(a),k=e.util.escapeQuotes(a),L=r+$;e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(y,a,e.opts.jsonPointers)),n+=" if ( "+L+" === undefined ",b&&(n+=" || ! Object.prototype.hasOwnProperty.call("+r+", '"+e.util.escapeQuotes(a)+"') "),n+=") {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(m)+" , params: { property: '"+e.util.escapeQuotes(l)+"', missingProperty: '"+k+"', depsCount: "+i.length+", deps: '"+e.util.escapeQuotes(1==i.length?i[0]:i.join(", "))+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should have ",1==i.length?n+="property "+e.util.escapeQuotes(i[0]):n+="properties "+e.util.escapeQuotes(i.join(", ")),n+=" when property "+e.util.escapeQuotes(l)+" is present' "),e.opts.verbose&&(n+=" , schema: validate.schema"+p+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+r+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}n+=" }   ",f&&(C+="}",n+=" else { ")}e.errorPath=y;var l,B=o.baseId;for(l in v){var c=v[l];(e.opts.strictKeywords?"object"==typeof c&&0<Object.keys(c).length||!1===c:e.util.schemaHasRules(c,e.RULES.all))&&(n+=" "+I+" = true; if ( "+r+e.util.getProperty(l)+" !== undefined ",b&&(n+=" && Object.prototype.hasOwnProperty.call("+r+", '"+e.util.escapeQuotes(l)+"') "),n+=") { ",o.schema=c,o.schemaPath=p+e.util.getProperty(l),o.errSchemaPath=m+"/"+e.util.escapeFragment(l),n+="  "+e.validate(o)+" ",o.baseId=B,n+=" }  ",f&&(n+=" if ("+I+") { ",C+="}"))}return f&&(n+="   "+C+" if ("+t+" == errors) {"),n}},9317:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,a=!e.opts.allErrors,d="data"+(r||""),l="valid"+n,c=e.opts.$data&&o&&o.$data,o=(c&&(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; "),"i"+n),r="schema"+n,r=(c||(i+=" var "+r+" = validate.schema"+s+";"),i+="var "+l+";",c&&(i+=" if (schema"+n+" === undefined) "+l+" = true; else if (!Array.isArray(schema"+n+")) "+l+" = false; else {"),i+=l+" = false;for (var "+o+"=0; "+o+"<"+r+".length; "+o+"++) if (equal("+d+", "+r+"["+o+"])) { "+l+" = true; break; }",c&&(i+="  }  "),[]),o=(r.push(i+=" if (!"+l+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { allowedValues: schema"+n+" } ",!1!==e.opts.messages&&(i+=" , message: 'should be equal to one of the allowed values' "),e.opts.verbose&&(i+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),i+=" } "):i+=" {} ",i),i=r.pop();return!e.compositeRule&&a?e.async?i+=" throw new ValidationError(["+o+"]); ":i+=" validate.errors = ["+o+"]; return false; ":i+=" var err = "+o+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" }",a&&(i+=" else { "),i}},8327:function(e){"use strict";e.exports=function(e,h,d){var t=" ",i=e.level,n=e.dataLevel,r=e.schema[h],u=e.schemaPath+e.util.getProperty(h),h=e.errSchemaPath+"/"+h,o=!e.opts.allErrors,s="data"+(n||"");if(!1===e.opts.format)return o&&(t+=" if (true) { "),t;var a,l=e.opts.$data&&r&&r.$data,n=l?(t+=" var schema"+i+" = "+e.util.getData(r.$data,n,e.dataPathArr)+"; ","schema"+i):r,g=e.opts.unknownFormats,c=Array.isArray(g);if(l)t+=" var "+(a="format"+i)+" = formats["+n+"]; var "+(p="isObject"+i)+" = typeof "+a+" == 'object' && !("+a+" instanceof RegExp) && "+a+".validate; var "+(f="formatType"+i)+" = "+p+" && "+a+".type || 'string'; if ("+p+") { ",e.async&&(t+=" var async"+i+" = "+a+".async; "),t+=" "+a+" = "+a+".validate; } if (  ",l&&(t+=" ("+n+" !== undefined && typeof "+n+" != 'string') || "),t+=" (","ignore"!=g&&(t+=" ("+n+" && !"+a+" ",c&&(t+=" && self._opts.unknownFormats.indexOf("+n+") == -1 "),t+=") || "),t+=" ("+a+" && "+f+" == '"+d+"' && !(typeof "+a+" == 'function' ? ",e.async?t+=" (async"+i+" ? await "+a+"("+s+") : "+a+"("+s+")) ":t+=" "+a+"("+s+") ",t+=" : "+a+".test("+s+"))))) {";else{if(!(a=e.formats[r])){if("ignore"==g)return e.logger.warn('unknown format "'+r+'" ignored in schema at path "'+e.errSchemaPath+'"'),o&&(t+=" if (true) { "),t;if(c&&0<=g.indexOf(r))return o&&(t+=" if (true) { "),t;throw new Error('unknown format "'+r+'" is used in schema at path "'+e.errSchemaPath+'"')}var p,m,f=(p="object"==typeof a&&!(a instanceof RegExp)&&a.validate)&&a.type||"string";if(p&&(m=!0===a.async,a=a.validate),f!=d)return o&&(t+=" if (true) { "),t;if(m){if(!e.async)throw new Error("async format in sync schema");t+=" if (!(await "+(C="formats"+e.util.getProperty(r)+".validate")+"("+s+"))) { "}else{t+=" if (! ";var C="formats"+e.util.getProperty(r);p&&(C+=".validate"),t=t+("function"==typeof a?" "+C+"("+s+") ":" "+C+".test("+s+") ")+") { "}}i=[],i.push(t),t="",!1!==e.createErrors?(t=(t+=" { keyword: 'format' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { format:  ")+(l?""+n:""+e.util.toQuotedString(r))+"  } ",!1!==e.opts.messages&&(t=(t+=" , message: 'should match format \"")+(l?"' + "+n+" + '":""+e.util.escapeQuotes(r))+"\"' "),e.opts.verbose&&(t=(t=(t+=" , schema:  ")+(l?"validate.schema"+u:""+e.util.toQuotedString(r)))+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+s+" "),t+=" } "):t+=" {} ",c=t,t=i.pop();return!e.compositeRule&&o?e.async?t+=" throw new ValidationError(["+c+"]); ":t+=" validate.errors = ["+c+"]; return false; ":t+=" var err = "+c+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } ",o&&(t+=" else { "),t}},5926:function(e){"use strict";e.exports=function(e,t,h){var i,n=" ",r=e.level,d=e.dataLevel,u=e.schema[t],g=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,d="data"+(d||""),o="valid"+r,s="errs__"+r,a=e.util.copy(e),m=(a.level++,"valid"+a.level),l=e.schema.then,c=e.schema.else,l=void 0!==l&&(e.opts.strictKeywords?"object"==typeof l&&0<Object.keys(l).length||!1===l:e.util.schemaHasRules(l,e.RULES.all)),c=void 0!==c&&(e.opts.strictKeywords?"object"==typeof c&&0<Object.keys(c).length||!1===c:e.util.schemaHasRules(c,e.RULES.all)),f=a.baseId;return l||c?(a.createErrors=!1,a.schema=u,a.schemaPath=g,a.errSchemaPath=t,n+=" var "+s+" = errors; var "+o+" = true;  ",u=e.compositeRule,e.compositeRule=a.compositeRule=!0,n+="  "+e.validate(a)+" ",a.baseId=f,a.createErrors=!0,n+="  errors = "+s+"; if (vErrors !== null) { if ("+s+") vErrors.length = "+s+"; else vErrors = null; }  ",e.compositeRule=a.compositeRule=u,l?(n+=" if ("+m+") {  ",a.schema=e.schema.then,a.schemaPath=e.schemaPath+".then",a.errSchemaPath=e.errSchemaPath+"/then",n+="  "+e.validate(a)+" ",a.baseId=f,n+=" "+o+" = "+m+"; ",l&&c?n+=" var "+(i="ifClause"+r)+" = 'then'; ":i="'then'",n+=" } ",c&&(n+=" else { ")):n+=" if (!"+m+") { ",c&&(a.schema=e.schema.else,a.schemaPath=e.schemaPath+".else",a.errSchemaPath=e.errSchemaPath+"/else",n+="  "+e.validate(a)+" ",a.baseId=f,n+=" "+o+" = "+m+"; ",l&&c?n+=" var "+(i="ifClause"+r)+" = 'else'; ":i="'else'",n+=" } "),n+=" if (!"+o+") {   var err =   ",!1!==e.createErrors?(n+=" { keyword: 'if' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { failingKeyword: "+i+" } ",!1!==e.opts.messages&&(n+=" , message: 'should match \"' + "+i+" + '\" schema' "),e.opts.verbose&&(n+=" , schema: validate.schema"+g+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&p&&(e.async?n+=" throw new ValidationError(vErrors); ":n+=" validate.errors = vErrors; return false; "),n+=" }   ",p&&(n+=" else { ")):p&&(n+=" if (true) { "),n}},9646:function(e,t,i){"use strict";e.exports={$ref:i(2331),allOf:i(9486),anyOf:i(5347),$comment:i(923),const:i(2617),contains:i(2119),dependencies:i(9115),enum:i(9317),format:i(8327),if:i(5926),items:i(392),maximum:i(1796),minimum:i(1796),maxItems:i(2407),minItems:i(2407),maxLength:i(1250),minLength:i(1250),maxProperties:i(2596),minProperties:i(2596),multipleOf:i(6039),not:i(7946),oneOf:i(9344),pattern:i(9737),properties:i(2537),propertyNames:i(2127),required:i(1204),uniqueItems:i(1985),validate:i(1869)}},392:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,d=e.dataLevel,r=e.schema[t],u=e.schemaPath+e.util.getProperty(t),g=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,o="data"+(d||""),t="valid"+n,d="errs__"+n,s=e.util.copy(e),m="",f=(s.level++,"valid"+s.level),n="i"+n,C=s.dataLevel=e.dataLevel+1,a="data"+C,I=e.baseId;if(i+="var "+d+" = errors;var "+t+";",Array.isArray(r)){var v,A,b=e.schema.additionalItems,y=(!1===b&&(i+=" "+t+" = "+o+".length <= "+r.length+"; ",v=g,g=e.errSchemaPath+"/additionalItems",(A=A||[]).push(i+="  if (!"+t+") {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { limit: "+r.length+" } ",!1!==e.opts.messages&&(i+=" , message: 'should NOT have more than "+r.length+" items' "),e.opts.verbose&&(i+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+o+" "),i+=" } "):i+=" {} ",t=i,i=A.pop(),!e.compositeRule&&p?e.async?i+=" throw new ValidationError(["+t+"]); ":i+=" validate.errors = ["+t+"]; return false; ":i+=" var err = "+t+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } ",g=v,p&&(m+="}",i+=" else { ")),r);if(y)for(var w=-1,S=y.length-1;w<S;){var l,c,x=y[w+=1];(e.opts.strictKeywords?"object"==typeof x&&0<Object.keys(x).length||!1===x:e.util.schemaHasRules(x,e.RULES.all))&&(i+=" "+f+" = true; if ("+o+".length > "+w+") { ",l=o+"["+w+"]",s.schema=x,s.schemaPath=u+"["+w+"]",s.errSchemaPath=g+"/"+w,s.errorPath=e.util.getPathExpr(e.errorPath,w,e.opts.jsonPointers,!0),s.dataPathArr[C]=w,c=e.validate(s),s.baseId=I,e.util.varOccurences(c,a)<2?i+=" "+e.util.varReplace(c,a,l)+" ":i+=" var "+a+" = "+l+"; "+c+" ",i+=" }  ",p&&(i+=" if ("+f+") { ",m+="}"))}"object"==typeof b&&(e.opts.strictKeywords?"object"==typeof b&&0<Object.keys(b).length||!1===b:e.util.schemaHasRules(b,e.RULES.all))&&(s.schema=b,s.schemaPath=e.schemaPath+".additionalItems",s.errSchemaPath=e.errSchemaPath+"/additionalItems",i+=" "+f+" = true; if ("+o+".length > "+r.length+") {  for (var "+n+" = "+r.length+"; "+n+" < "+o+".length; "+n+"++) { ",s.errorPath=e.util.getPathExpr(e.errorPath,n,e.opts.jsonPointers,!0),l=o+"["+n+"]",s.dataPathArr[C]=n,c=e.validate(s),s.baseId=I,e.util.varOccurences(c,a)<2?i+=" "+e.util.varReplace(c,a,l)+" ":i+=" var "+a+" = "+l+"; "+c+" ",p&&(i+=" if (!"+f+") break; "),i+=" } }  ",p&&(i+=" if ("+f+") { ",m+="}"))}else(e.opts.strictKeywords?"object"==typeof r&&0<Object.keys(r).length||!1===r:e.util.schemaHasRules(r,e.RULES.all))&&(s.schema=r,s.schemaPath=u,s.errSchemaPath=g,i+="  for (var "+n+" = 0; "+n+" < "+o+".length; "+n+"++) { ",s.errorPath=e.util.getPathExpr(e.errorPath,n,e.opts.jsonPointers,!0),l=o+"["+n+"]",s.dataPathArr[C]=n,c=e.validate(s),s.baseId=I,e.util.varOccurences(c,a)<2?i+=" "+e.util.varReplace(c,a,l)+" ":i+=" var "+a+" = "+l+"; "+c+" ",p&&(i+=" if (!"+f+") break; "),i+=" }");return p&&(i+=" "+m+" if ("+d+" == errors) {"),i}},6039:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],s=e.schemaPath+e.util.getProperty(t),d=e.errSchemaPath+"/"+t,a=!e.opts.allErrors,l="data"+(r||""),c=e.opts.$data&&o&&o.$data,r=c?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o;if(!c&&"number"!=typeof o)throw new Error(t+" must be number");i+="var division"+n+";if (",c&&(i+=" "+r+" !== undefined && ( typeof "+r+" != 'number' || "),i+=" (division"+n+" = "+l+" / "+r+", ",e.opts.multipleOfPrecision?i+=" Math.abs(Math.round(division"+n+") - division"+n+") > 1e-"+e.opts.multipleOfPrecision+" ":i+=" division"+n+" !== parseInt(division"+n+") ",i+=" ) ",c&&(i+="  )  ");t=[],t.push(i+=" ) {   "),i="",!1!==e.createErrors?(i+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(d)+" , params: { multipleOf: "+r+" } ",!1!==e.opts.messages&&(i=i+" , message: 'should be multiple of "+(c?"' + "+r:r+"'")),e.opts.verbose&&(i=(i+=" , schema:  ")+(c?"validate.schema"+s:""+o)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+l+" "),i+=" } "):i+=" {} ",n=i,i=t.pop();return!e.compositeRule&&a?e.async?i+=" throw new ValidationError(["+n+"]); ":i+=" validate.errors = ["+n+"]; return false; ":i+=" var err = "+n+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",a&&(i+=" else { "),i}},7946:function(e){"use strict";e.exports=function(e,t,h){var i,n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,d=!e.opts.allErrors,s="data"+(s||""),o="errs__"+o,c=e.util.copy(e),u=(c.level++,"valid"+c.level);return(e.opts.strictKeywords?"object"==typeof a&&0<Object.keys(a).length||!1===a:e.util.schemaHasRules(a,e.RULES.all))?(c.schema=a,c.schemaPath=l,c.errSchemaPath=t,r+=" var "+o+" = errors;  ",a=e.compositeRule,e.compositeRule=c.compositeRule=!0,c.createErrors=!1,c.opts.allErrors&&(n=c.opts.allErrors,c.opts.allErrors=!1),r+=" "+e.validate(c)+" ",c.createErrors=!0,n&&(c.opts.allErrors=n),e.compositeRule=c.compositeRule=a,(i=i||[]).push(r+=" if ("+u+") {   "),r="",!1!==e.createErrors?(r+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: {} ",!1!==e.opts.messages&&(r+=" , message: 'should NOT be valid' "),e.opts.verbose&&(r+=" , schema: validate.schema"+l+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+s+" "),r+=" } "):r+=" {} ",n=r,r=i.pop(),!e.compositeRule&&d?e.async?r+=" throw new ValidationError(["+n+"]); ":r+=" validate.errors = ["+n+"]; return false; ":r+=" var err = "+n+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+=" } else {  errors = "+o+"; if (vErrors !== null) { if ("+o+") vErrors.length = "+o+"; else vErrors = null; } ",e.opts.allErrors&&(r+=" } ")):(r+="  var err =   ",!1!==e.createErrors?(r+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: {} ",!1!==e.opts.messages&&(r+=" , message: 'should NOT be valid' "),e.opts.verbose&&(r+=" , schema: validate.schema"+l+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+s+" "),r+=" } "):r+=" {} ",r+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",d&&(r+=" if (false) { ")),r}},9344:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,d=e.dataLevel,u=e.schema[t],g=e.schemaPath+e.util.getProperty(t),p=e.errSchemaPath+"/"+t,t=!e.opts.allErrors,d="data"+(d||""),r="valid"+n,o="errs__"+n,s=e.util.copy(e),m="",f=(s.level++,"valid"+s.level),C=s.baseId,I="prevValid"+n,a="passingSchemas"+n,n=(i+="var "+o+" = errors , "+I+" = false , "+r+" = false , "+a+" = null; ",e.compositeRule),v=(e.compositeRule=s.compositeRule=!0,u);if(v)for(var l,c=-1,A=v.length-1;c<A;)l=v[c+=1],(e.opts.strictKeywords?"object"==typeof l&&0<Object.keys(l).length||!1===l:e.util.schemaHasRules(l,e.RULES.all))?(s.schema=l,s.schemaPath=g+"["+c+"]",s.errSchemaPath=p+"/"+c,i+="  "+e.validate(s)+" ",s.baseId=C):i+=" var "+f+" = true; ",c&&(i+=" if ("+f+" && "+I+") { "+r+" = false; "+a+" = ["+a+", "+c+"]; } else { ",m+="}"),i+=" if ("+f+") { "+r+" = "+I+" = true; "+a+" = "+c+"; }";return e.compositeRule=s.compositeRule=n,i+=m+"if (!"+r+") {   var err =   ",!1!==e.createErrors?(i+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(p)+" , params: { passingSchemas: "+a+" } ",!1!==e.opts.messages&&(i+=" , message: 'should match exactly one schema in oneOf' "),e.opts.verbose&&(i+=" , schema: validate.schema"+g+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&t&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; "),i+="} else {  errors = "+o+"; if (vErrors !== null) { if ("+o+") vErrors.length = "+o+"; else vErrors = null; }",e.opts.allErrors&&(i+=" } "),i}},9737:function(e){"use strict";e.exports=function(e,t,h){var i=" ",n=e.level,r=e.dataLevel,o=e.schema[t],d=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,s=!e.opts.allErrors,a="data"+(r||""),l=e.opts.$data&&o&&o.$data,r=l?(i+=" var schema"+n+" = "+e.util.getData(o.$data,r,e.dataPathArr)+"; ","schema"+n):o,n=l?"(new RegExp("+r+"))":e.usePattern(o),c=(i+="if ( ",l&&(i+=" ("+r+" !== undefined && typeof "+r+" != 'string') || "),[]),n=(c.push(i+=" !"+n+".test("+a+") ) {   "),i="",!1!==e.createErrors?(i=(i+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { pattern:  ")+(l?""+r:""+e.util.toQuotedString(o))+"  } ",!1!==e.opts.messages&&(i=(i+=" , message: 'should match pattern \"")+(l?"' + "+r+" + '":""+e.util.escapeQuotes(o))+"\"' "),e.opts.verbose&&(i=(i=(i+=" , schema:  ")+(l?"validate.schema"+d:""+e.util.toQuotedString(o)))+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),i+=" } "):i+=" {} ",i),i=c.pop();return!e.compositeRule&&s?e.async?i+=" throw new ValidationError(["+n+"]); ":i+=" validate.errors = ["+n+"]; return false; ":i+=" var err = "+n+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+="} ",s&&(i+=" else { "),i}},2537:function(e){"use strict";e.exports=function(e
,h,d){var u,t=" ",g=e.level,p=e.dataLevel,m=e.schema[h],f=e.schemaPath+e.util.getProperty(h),C=e.errSchemaPath+"/"+h,i=!e.opts.allErrors,n="data"+(p||""),h="errs__"+g,r=e.util.copy(e),I="",v=(r.level++,"valid"+r.level),o="key"+g,A="idx"+g,b=r.dataLevel=e.dataLevel+1,s="data"+b,y="dataProperties"+g,p=Object.keys(m||{}).filter(W),w=e.schema.patternProperties||{},S=Object.keys(w).filter(W),x=e.schema.additionalProperties,k=p.length||S.length,E=!1===x,R="object"==typeof x&&Object.keys(x).length,T=e.opts.removeAdditional,_=E||R||T,$=e.opts.ownProperties,L=e.baseId,B=e.schema.required;function W(e){return"__proto__"!==e}if(B&&(!e.opts.$data||!B.$data)&&B.length<e.opts.loopRequired&&(u=e.util.toHash(B)),t+="var "+h+" = errors;var "+v+" = true;",$&&(t+=" var "+y+" = undefined;"),_){if(t+=$?" "+y+" = "+y+" || Object.keys("+n+"); for (var "+A+"=0; "+A+"<"+y+".length; "+A+"++) { var "+o+" = "+y+"["+A+"]; ":" for (var "+o+" in "+n+") { ",k){if(t+=" var isAdditional"+g+" = !(false ",p.length)if(8<p.length)t+=" || validate.schema"+f+".hasOwnProperty("+o+") ";else{var N=p;if(N)for(var G=-1,P=N.length-1;G<P;)a=N[G+=1],t+=" || "+o+" == "+e.util.toQuotedString(a)+" "}if(S.length){var F=S;if(F)for(var H=-1,V=F.length-1;H<V;)ee=F[H+=1],t+=" || "+e.usePattern(ee)+".test("+o+") "}t+=" ); if (isAdditional"+g+") { "}"all"==T?t+=" delete "+n+"["+o+"]; ":(z=e.errorPath,B="' + "+o+" + '",e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(e.errorPath,o,e.opts.jsonPointers)),E?T?t+=" delete "+n+"["+o+"]; ":(X=C,C=e.errSchemaPath+"/additionalProperties",(Y=Y||[]).push(t+=" "+v+" = false; "),t="",!1!==e.createErrors?(t+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(C)+" , params: { additionalProperty: '"+B+"' } ",!1!==e.opts.messages&&(t+=" , message: '",e.opts._errorDataPathProperty?t+="is an invalid additional property":t+="should NOT have additional properties",t+="' "),e.opts.verbose&&(t+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+n+" "),t+=" } "):t+=" {} ",U=t,t=Y.pop(),!e.compositeRule&&i?e.async?t+=" throw new ValidationError(["+U+"]); ":t+=" validate.errors = ["+U+"]; return false; ":t+=" var err = "+U+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",C=X,i&&(t+=" break; ")):R&&("failing"==T?(t+=" var "+h+" = errors;  ",_=e.compositeRule,e.compositeRule=r.compositeRule=!0,r.schema=x,r.schemaPath=e.schemaPath+".additionalProperties",r.errSchemaPath=e.errSchemaPath+"/additionalProperties",r.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,o,e.opts.jsonPointers),l=n+"["+o+"]",r.dataPathArr[b]=o,c=e.validate(r),r.baseId=L,e.util.varOccurences(c,s)<2?t+=" "+e.util.varReplace(c,s,l)+" ":t+=" var "+s+" = "+l+"; "+c+" ",t+=" if (!"+v+") { errors = "+h+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+n+"["+o+"]; }  ",e.compositeRule=r.compositeRule=_):(r.schema=x,r.schemaPath=e.schemaPath+".additionalProperties",r.errSchemaPath=e.errSchemaPath+"/additionalProperties",r.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,o,e.opts.jsonPointers),l=n+"["+o+"]",r.dataPathArr[b]=o,c=e.validate(r),r.baseId=L,e.util.varOccurences(c,s)<2?t+=" "+e.util.varReplace(c,s,l)+" ":t+=" var "+s+" = "+l+"; "+c+" ",i&&(t+=" if (!"+v+") break; "))),e.errorPath=z),k&&(t+=" } "),t+=" }  ",i&&(t+=" if ("+v+") { ",I+="}")}var Z=e.opts.useDefaults&&!e.compositeRule;if(p.length){var M=p;if(M)for(var a,O=-1,D=M.length-1;O<D;){var K,j,z,X,J,Y,U,Q=m[a=M[O+=1]];(e.opts.strictKeywords?"object"==typeof Q&&0<Object.keys(Q).length||!1===Q:e.util.schemaHasRules(Q,e.RULES.all))&&(l=n+(J=e.util.getProperty(a)),K=Z&&void 0!==Q.default,r.schema=Q,r.schemaPath=f+J,r.errSchemaPath=C+"/"+e.util.escapeFragment(a),r.errorPath=e.util.getPath(e.errorPath,a,e.opts.jsonPointers),r.dataPathArr[b]=e.util.toQuotedString(a),c=e.validate(r),r.baseId=L,e.util.varOccurences(c,s)<2?(c=e.util.varReplace(c,s,l),j=l):t+=" var "+(j=s)+" = "+l+"; ",K?t+=" "+c+" ":(u&&u[a]?(t+=" if ( "+j+" === undefined ",$&&(t+=" || ! Object.prototype.hasOwnProperty.call("+n+", '"+e.util.escapeQuotes(a)+"') "),t+=") { "+v+" = false; ",z=e.errorPath,X=C,J=e.util.escapeQuotes(a),e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(z,a,e.opts.jsonPointers)),C=e.errSchemaPath+"/required",(Y=Y||[]).push(t),t="",!1!==e.createErrors?(t+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(C)+" , params: { missingProperty: '"+J+"' } ",!1!==e.opts.messages&&(t+=" , message: '",e.opts._errorDataPathProperty?t+="is a required property":t+="should have required property \\'"+J+"\\'",t+="' "),e.opts.verbose&&(t+=" , schema: validate.schema"+f+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+n+" "),t+=" } "):t+=" {} ",U=t,t=Y.pop(),!e.compositeRule&&i?e.async?t+=" throw new ValidationError(["+U+"]); ":t+=" validate.errors = ["+U+"]; return false; ":t+=" var err = "+U+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",C=X,e.errorPath=z,t+=" } else { "):i?(t+=" if ( "+j+" === undefined ",$&&(t+=" || ! Object.prototype.hasOwnProperty.call("+n+", '"+e.util.escapeQuotes(a)+"') "),t+=") { "+v+" = true; } else { "):(t+=" if ("+j+" !== undefined ",$&&(t+=" &&   Object.prototype.hasOwnProperty.call("+n+", '"+e.util.escapeQuotes(a)+"') "),t+=" ) { "),t+=" "+c+" } ")),i&&(t+=" if ("+v+") { ",I+="}")}}if(S.length){var q=S;if(q)for(var ee,te=-1,ie=q.length-1;te<ie;){var l,c,Q=w[ee=q[te+=1]];(e.opts.strictKeywords?"object"==typeof Q&&0<Object.keys(Q).length||!1===Q:e.util.schemaHasRules(Q,e.RULES.all))&&(r.schema=Q,r.schemaPath=e.schemaPath+".patternProperties"+e.util.getProperty(ee),r.errSchemaPath=e.errSchemaPath+"/patternProperties/"+e.util.escapeFragment(ee),t=(t+=$?" "+y+" = "+y+" || Object.keys("+n+"); for (var "+A+"=0; "+A+"<"+y+".length; "+A+"++) { var "+o+" = "+y+"["+A+"]; ":" for (var "+o+" in "+n+") { ")+" if ("+e.usePattern(ee)+".test("+o+")) { ",r.errorPath=e.util.getPathExpr(e.errorPath,o,e.opts.jsonPointers),l=n+"["+o+"]",r.dataPathArr[b]=o,c=e.validate(r),r.baseId=L,e.util.varOccurences(c,s)<2?t+=" "+e.util.varReplace(c,s,l)+" ":t+=" var "+s+" = "+l+"; "+c+" ",i&&(t+=" if (!"+v+") break; "),t+=" } ",i&&(t+=" else "+v+" = true; "),t+=" }  ",i&&(t+=" if ("+v+") { ",I+="}"))}}return i&&(t+=" "+I+" if ("+h+" == errors) {"),t}},2127:function(e){"use strict";e.exports=function(e,t,h){var i,n,d,u,g,r,o,s=" ",a=e.level,p=e.dataLevel,l=e.schema[t],m=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,f=!e.opts.allErrors,p="data"+(p||""),C="errs__"+a,c=e.util.copy(e),I=(c.level++,"valid"+c.level);return s+="var "+C+" = errors;",(e.opts.strictKeywords?"object"==typeof l&&0<Object.keys(l).length||!1===l:e.util.schemaHasRules(l,e.RULES.all))&&(c.schema=l,c.schemaPath=m,c.errSchemaPath=t,l="idx"+a,n="i"+a,d="' + "+(i="key"+a)+" + '",u="data"+(c.dataLevel=e.dataLevel+1),o="dataProperties"+a,r=e.opts.ownProperties,g=e.baseId,r&&(s+=" var "+o+" = undefined; "),s=s+(r?" "+o+" = "+o+" || Object.keys("+p+"); for (var "+l+"=0; "+l+"<"+o+".length; "+l+"++) { var "+i+" = "+o+"["+l+"]; ":" for (var "+i+" in "+p+") { ")+" var startErrs"+a+" = errors; ",r=i,o=e.compositeRule,e.compositeRule=c.compositeRule=!0,l=e.validate(c),c.baseId=g,e.util.varOccurences(l,u)<2?s+=" "+e.util.varReplace(l,u,r)+" ":s+=" var "+u+" = "+r+"; "+l+" ",e.compositeRule=c.compositeRule=o,s+=" if (!"+I+") { for (var "+n+"=startErrs"+a+"; "+n+"<errors; "+n+"++) { vErrors["+n+"].propertyName = "+i+"; }   var err =   ",!1!==e.createErrors?(s+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { propertyName: '"+d+"' } ",!1!==e.opts.messages&&(s+=" , message: 'property name \\'"+d+"\\' is invalid' "),e.opts.verbose&&(s+=" , schema: validate.schema"+m+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+p+" "),s+=" } "):s+=" {} ",s+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&f&&(e.async?s+=" throw new ValidationError(vErrors); ":s+=" validate.errors = vErrors; return false; "),f&&(s+=" break; "),s+=" } }"),f&&(s+="  if ("+C+" == errors) {"),s}},2331:function(e){"use strict";e.exports=function(e,t,h){var d,i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],t=e.errSchemaPath+"/"+t,a=!e.opts.allErrors,u="data"+(o||""),r="valid"+r;if("#"==s||"#/"==s)i=e.isRoot?(d=e.async,"validate"):(d=!0===e.root.schema.$async,"root.refVal[0]");else{var l=e.resolveRef(e.baseId,s,e.isRoot);if(void 0===l){var g=e.MissingRefError.message(e.baseId,s);if("fail"==e.opts.missingRefs){e.logger.error(g);(c=c||[]).push(n),n="",!1!==e.createErrors?(n+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { ref: '"+e.util.escapeQuotes(s)+"' } ",!1!==e.opts.messages&&(n+=" , message: 'can\\'t resolve reference "+e.util.escapeQuotes(s)+"' "),e.opts.verbose&&(n+=" , schema: "+e.util.toQuotedString(s)+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),n+=" } "):n+=" {} ";t=n,n=c.pop();!e.compositeRule&&a?e.async?n+=" throw new ValidationError(["+t+"]); ":n+=" validate.errors = ["+t+"]; return false; ":n+=" var err = "+t+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",a&&(n+=" if (false) { ")}else{if("ignore"!=e.opts.missingRefs)throw new e.MissingRefError(e.baseId,s,g);e.logger.warn(g),a&&(n+=" if (true) { ")}}else l.inline?((t=e.util.copy(e)).level++,g="valid"+t.level,t.schema=l.schema,t.schemaPath="",t.errSchemaPath=s,n+=" "+e.validate(t).replace(/validate\.schema/g,l.code)+" ",a&&(n+=" if ("+g+") { ")):(d=!0===l.$async||e.async&&!1!==l.$async,i=l.code)}if(i){(c=c||[]).push(n),n="",e.opts.passContext?n+=" "+i+".call(this, ":n+=" "+i+"( ",n+=" "+u+", (dataPath || '')",'""'!=e.errorPath&&(n+=" + "+e.errorPath);var c,s=o?"data"+(o-1||""):"parentData",t=n+=" , "+s+" , "+(o?e.dataPathArr[o]:"parentDataProperty")+", rootData)  ";if(n=c.pop(),d){if(!e.async)throw new Error("async schema referenced by sync schema");a&&(n+=" var "+r+"; "),n+=" try { await "+t+"; ",a&&(n+=" "+r+" = true; "),n+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",a&&(n+=" "+r+" = false; "),n+=" } ",a&&(n+=" if ("+r+") { ")}else n+=" if (!"+t+") { if (vErrors === null) vErrors = "+i+".errors; else vErrors = vErrors.concat("+i+".errors); errors = vErrors.length; } ",a&&(n+=" else { ")}return n}},1204:function(e){"use strict";e.exports=function(e,h,d){var t=" ",i=e.level,n=e.dataLevel,r=e.schema[h],u=e.schemaPath+e.util.getProperty(h),g=e.errSchemaPath+"/"+h,h=!e.opts.allErrors,o="data"+(n||""),p="valid"+i,s=e.opts.$data&&r&&r.$data,n=(s&&(t+=" var schema"+i+" = "+e.util.getData(r.$data,n,e.dataPathArr)+"; "),"schema"+i);if(!s)if(r.length<e.opts.loopRequired&&e.schema.properties&&Object.keys(e.schema.properties).length){var m=[],f=r;if(f)for(var C=-1,I=f.length-1;C<I;){var v=f[C+=1],A=e.schema.properties[v];A&&(e.opts.strictKeywords?"object"==typeof A&&0<Object.keys(A).length||!1===A:e.util.schemaHasRules(A,e.RULES.all))||(m[m.length]=v)}}else m=r;if(s||m.length){var b=e.errorPath,r=s||m.length>=e.opts.loopRequired,y=e.opts.ownProperties;if(h)if(t+=" var missing"+i+"; ",r){s||(t+=" var "+n+" = validate.schema"+u+"; ");var a="' + "+(E="schema"+i+"["+(l="i"+i)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(b,E,e.opts.jsonPointers)),t+=" var "+p+" = true; ",s&&(t+=" if (schema"+i+" === undefined) "+p+" = true; else if (!Array.isArray(schema"+i+")) "+p+" = false; else {"),t+=" for (var "+l+" = 0; "+l+" < "+n+".length; "+l+"++) { "+p+" = "+o+"["+n+"["+l+"]] !== undefined ",y&&(t+=" &&   Object.prototype.hasOwnProperty.call("+o+", "+n+"["+l+"]) "),t+="; if (!"+p+") break; } ",s&&(t+="  }  ");(k=k||[]).push(t+="  if (!"+p+") {   "),t="",!1!==e.createErrors?(t+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { missingProperty: '"+a+"' } ",!1!==e.opts.messages&&(t+=" , message: '",e.opts._errorDataPathProperty?t+="is a required property":t+="should have required property \\'"+a+"\\'",t+="' "),e.opts.verbose&&(t+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+o+" "),t+=" } "):t+=" {} ";var w=t,t=k.pop();!e.compositeRule&&h?e.async?t+=" throw new ValidationError(["+w+"]); ":t+=" validate.errors = ["+w+"]; return false; ":t+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } else { "}else{t+=" if ( ";var S=m;if(S)for(var l=-1,x=S.length-1;l<x;)c=S[l+=1],l&&(t+=" || "),t+=" ( ( "+(L=o+($=e.util.getProperty(c)))+" === undefined ",y&&(t+=" || ! Object.prototype.hasOwnProperty.call("+o+", '"+e.util.escapeQuotes(c)+"') "),t+=") && (missing"+i+" = "+e.util.toQuotedString(e.opts.jsonPointers?c:$)+") ) ";t+=") {  ";a="' + "+(E="missing"+i)+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(b,E,!0):b+" + "+E);(k=k||[]).push(t),t="",!1!==e.createErrors?(t+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { missingProperty: '"+a+"' } ",!1!==e.opts.messages&&(t+=" , message: '",e.opts._errorDataPathProperty?t+="is a required property":t+="should have required property \\'"+a+"\\'",t+="' "),e.opts.verbose&&(t+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+o+" "),t+=" } "):t+=" {} ";var k,w=t;t=k.pop(),!e.compositeRule&&h?e.async?t+=" throw new ValidationError(["+w+"]); ":t+=" validate.errors = ["+w+"]; return false; ":t+=" var err = "+w+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",t+=" } else { "}else if(r){s||(t+=" var "+n+" = validate.schema"+u+"; ");var E,a="' + "+(E="schema"+i+"["+(l="i"+i)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(b,E,e.opts.jsonPointers)),s&&(t+=" if ("+n+" && !Array.isArray("+n+")) {  var err =   ",!1!==e.createErrors?(t+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { missingProperty: '"+a+"' } ",!1!==e.opts.messages&&(t+=" , message: '",e.opts._errorDataPathProperty?t+="is a required property":t+="should have required property \\'"+a+"\\'",t+="' "),e.opts.verbose&&(t+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+o+" "),t+=" } "):t+=" {} ",t+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+n+" !== undefined) { "),t+=" for (var "+l+" = 0; "+l+" < "+n+".length; "+l+"++) { if ("+o+"["+n+"["+l+"]] === undefined ",y&&(t+=" || ! Object.prototype.hasOwnProperty.call("+o+", "+n+"["+l+"]) "),t+=") {  var err =   ",!1!==e.createErrors?(t+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { missingProperty: '"+a+"' } ",!1!==e.opts.messages&&(t+=" , message: '",e.opts._errorDataPathProperty?t+="is a required property":t+="should have required property \\'"+a+"\\'",t+="' "),e.opts.verbose&&(t+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+o+" "),t+=" } "):t+=" {} ",t+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",s&&(t+="  }  ")}else{var R=m;if(R)for(var c,T=-1,_=R.length-1;T<_;){c=R[T+=1];var $=e.util.getProperty(c),a=e.util.escapeQuotes(c),L=o+$;e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(b,c,e.opts.jsonPointers)),t+=" if ( "+L+" === undefined ",y&&(t+=" || ! Object.prototype.hasOwnProperty.call("+o+", '"+e.util.escapeQuotes(c)+"') "),t+=") {  var err =   ",!1!==e.createErrors?(t+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(g)+" , params: { missingProperty: '"+a+"' } ",!1!==e.opts.messages&&(t+=" , message: '",e.opts._errorDataPathProperty?t+="is a required property":t+="should have required property \\'"+a+"\\'",t+="' "),e.opts.verbose&&(t+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+o+" "),t+=" } "):t+=" {} ",t+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}e.errorPath=b}else h&&(t+=" if (true) {");return t}},1985:function(e){"use strict";e.exports=function(e,t,h){var i,n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],d=e.schemaPath+e.util.getProperty(t),t=e.errSchemaPath+"/"+t,u=!e.opts.allErrors,a="data"+(o||""),l="valid"+r,c=e.opts.$data&&s&&s.$data,o=c?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s;return(s||c)&&!1!==e.opts.uniqueItems?(c&&(n+=" var "+l+"; if ("+o+" === false || "+o+" === undefined) "+l+" = true; else if (typeof "+o+" != 'boolean') "+l+" = false; else { "),n+=" var i = "+a+".length , "+l+" = true , j; if (i > 1) { ",r=e.schema.items&&e.schema.items.type,o=Array.isArray(r),!r||"object"==r||"array"==r||o&&(0<=r.indexOf("object")||0<=r.indexOf("array"))?n+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+a+"[i], "+a+"[j])) { "+l+" = false; break outer; } } } ":(n=(n+=" var itemIndices = {}, item; for (;i--;) { var item = "+a+"[i]; ")+" if ("+e.util["checkDataType"+(o?"s":"")](r,"item",e.opts.strictNumbers,!0)+") continue; ",o&&(n+=" if (typeof item == 'string') item = '\"' + item; "),n+=" if (typeof itemIndices[item] == 'number') { "+l+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "),n+=" } ",c&&(n+="  }  "),(i=i||[]).push(n+=" if (!"+l+") {   "),n="",!1!==e.createErrors?(n+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(t)+" , params: { i: i, j: j } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),e.opts.verbose&&(n=(n+=" , schema:  ")+(c?"validate.schema"+d:""+s)+"         , parentSchema: validate.schema"+e.schemaPath+" , data: "+a+" "),n+=" } "):n+=" {} ",r=n,n=i.pop(),!e.compositeRule&&u?e.async?n+=" throw new ValidationError(["+r+"]); ":n+=" validate.errors = ["+r+"]; return false; ":n+=" var err = "+r+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",u&&(n+=" else { ")):u&&(n+=" if (true) { "),n}},1869:function(e){"use strict";e.exports=function(n,h,d){var e="",u=!0===n.schema.$async,g=n.util.schemaHasRulesExcept(n.schema,n.RULES.all,"$ref"),p=n.self._getId(n.schema);if(n.opts.strictKeywords){var m=n.util.schemaUnknownRules(n.schema,n.RULES.keywords);if(m){m="unknown keyword: "+m;if("log"!==n.opts.strictKeywords)throw new Error(m);n.logger.warn(m)}}if(n.isTop&&(e+=" var validate = ",u&&(n.async=!0,e+="async "),e+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",p&&(n.opts.sourceCode||n.opts.processCode)&&(e+=" /*# sourceURL="+p+" */ ")),"boolean"==typeof n.schema||!g&&!n.schema.$ref)return C=n.level,I=n.dataLevel,W=n.schema[h="false schema"],S=n.schemaPath+n.util.getProperty(h),x=n.errSchemaPath+"/"+h,i=!n.opts.allErrors,t="data"+(I||""),A="valid"+C,!1===n.schema?(n.isTop?i=!0:e+=" var "+A+" = false; ",(c=c||[]).push(e),e="",!1!==n.createErrors?(e+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(x)+" , params: {} ",!1!==n.opts.messages&&(e+=" , message: 'boolean schema is false' "),n.opts.verbose&&(e+=" , schema: false , parentSchema: validate.schema"+n.schemaPath+" , data: "+t+" "),e+=" } "):e+=" {} ",l=e,e=c.pop(),!n.compositeRule&&i?n.async?e+=" throw new ValidationError(["+l+"]); ":e+=" validate.errors = ["+l+"]; return false; ":e+=" var err = "+l+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "):n.isTop?e+=u?" return data; ":" validate.errors = null; return true; ":e+=" var "+A+" = true; ",n.isTop&&(e+=" }; return validate; "),e;if(n.isTop){var f=n.isTop,C=n.level=0,I=n.dataLevel=0,t="data";if(n.rootId=n.resolve.fullPath(n.self._getId(n.root.schema)),n.baseId=n.baseId||n.rootId,delete n.isTop,n.dataPathArr=[""],void 0!==n.schema.default&&n.opts.useDefaults&&n.opts.strictDefaults){var v="default is ignored in the schema root";if("log"!==n.opts.strictDefaults)throw new Error(v);n.logger.warn(v)}e=(e+=" var vErrors = null; ")+" var errors = 0;     "+" if (rootData === undefined) rootData = data; "}else{C=n.level,t="data"+((I=n.dataLevel)||"");if(p&&(n.baseId=n.resolve.url(n.baseId,p)),u&&!n.async)throw new Error("async schema in sync schema");e+=" var errs_"+C+" = errors;"}var A="valid"+C,i=!n.opts.allErrors,b="",y="",r=n.schema.type,o=Array.isArray(r);if(r&&n.opts.nullable&&!0===n.schema.nullable&&(o?-1==r.indexOf("null")&&(r=r.concat("null")):"null"!=r&&(r=[r,"null"],o=!0)),o&&1==r.length&&(r=r[0],o=!1),n.schema.$ref&&g){if("fail"==n.opts.extendRefs)throw new Error('$ref: validation keywords used in schema at path "'+n.errSchemaPath+'" (see option extendRefs)');!0!==n.opts.extendRefs&&(g=!1,n.logger.warn('$ref: keywords ignored in schema at path "'+n.errSchemaPath+'"'))}if(n.schema.$comment&&n.opts.$comment&&(e+=" "+n.RULES.all.$comment.code(n,"$comment")),r){n.opts.coerceTypes&&(w=n.util.coerceToTypes(n.opts.coerceTypes,r));var w,s=n.RULES.types[r];if(w||o||!0===s||s&&!z(s)){var S=n.schemaPath+".type",x=n.errSchemaPath+"/type",S=n.schemaPath+".type",x=n.errSchemaPath+"/type";if(e+=" if ("+n.util[o?"checkDataTypes":"checkDataType"](r,t,n.opts.strictNumbers,!0)+") { ",w){var k="dataType"+C,a="coerced"+C,E=(e+=" var "+k+" = typeof "+t+"; var "+a+" = undefined; ","array"==n.opts.coerceTypes&&(e+=" if ("+k+" == 'object' && Array.isArray("+t+") && "+t+".length == 1) { "+t+" = "+t+"[0]; "+k+" = typeof "+t+"; if ("+n.util.checkDataType(n.schema.type,t,n.opts.strictNumbers)+") "+a+" = "+t+"; } "),e+=" if ("+a+" !== undefined) ; ",w);if(E)for(var R,T=-1,_=E.length-1;T<_;)"string"==(R=E[T+=1])?e+=" else if ("+k+" == 'number' || "+k+" == 'boolean') "+a+" = '' + "+t+"; else if ("+t+" === null) "+a+" = ''; ":"number"==R||"integer"==R?(e+=" else if ("+k+" == 'boolean' || "+t+" === null || ("+k+" == 'string' && "+t+" && "+t+" == +"+t+" ","integer"==R&&(e+=" && !("+t+" % 1)"),e+=")) "+a+" = +"+t+"; "):"boolean"==R?e+=" else if ("+t+" === 'false' || "+t+" === 0 || "+t+" === null) "+a+" = false; else if ("+t+" === 'true' || "+t+" === 1) "+a+" = true; ":"null"==R?e+=" else if ("+t+" === '' || "+t+" === 0 || "+t+" === false) "+a+" = null; ":"array"==n.opts.coerceTypes&&"array"==R&&(e+=" else if ("+k+" == 'string' || "+k+" == 'number' || "+k+" == 'boolean' || "+t+" == null) "+a+" = ["+t+"]; ");(c=c||[]).push(e+=" else {   "),e="",!1!==n.createErrors?(e=(e+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(x)+" , params: { type: '")+(o?""+r.join(","):""+r)+"' } ",!1!==n.opts.messages&&(e=(e+=" , message: 'should be ")+(o?""+r.join(","):""+r)+"' "),n.opts.verbose&&(e+=" , schema: validate.schema"+S+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+t+" "),e+=" } "):e+=" {} ";var l=e,m=(e=c.pop(),!n.compositeRule&&i?n.async?e+=" throw new ValidationError(["+l+"]); ":e+=" validate.errors = ["+l+"]; return false; ":e+=" var err = "+l+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",I?"data"+(I-1||""):"parentData");e=e+(" } if ("+a+" !== undefined) {  ")+(" "+t+" = "+a+"; "),I||(e+="if ("+m+" !== undefined)"),e+=" "+m+"["+(I?n.dataPathArr[I]:"parentDataProperty")+"] = "+a+"; } "}else{l=((c=c||[]).push(e),e="",!1!==n.createErrors?(e=(e+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(x)+" , params: { type: '")+(o?""+r.join(","):""+r)+"' } ",!1!==n.opts.messages&&(e=(e+=" , message: 'should be ")+(o?""+r.join(","):""+r)+"' "),n.opts.verbose&&(e+=" , schema: validate.schema"+S+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+t+" "),e+=" } "):e+=" {} ",e);e=c.pop(),!n.compositeRule&&i?n.async?e+=" throw new ValidationError(["+l+"]); ":e+=" validate.errors = ["+l+"]; return false; ":e+=" var err = "+l+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}e+=" } "}}if(n.schema.$ref&&!g)e+=" "+n.RULES.all.$ref.code(n,"$ref")+" ",i&&(e=(e+=" } if (errors === ")+(f?"0":"errs_"+C)+") { ",y+="}");else{var $=n.RULES;if($)for(var L=-1,B=$.length-1;L<B;)if(z(s=$[L+=1])){if(s.type&&(e+=" if ("+n.util.checkDataType(s.type,t,n.opts.strictNumbers)+") { "),n.opts.useDefaults)if("object"==s.type&&n.schema.properties){var W=n.schema.properties,N=Object.keys(W);if(N)for(var G,P=-1,F=N.length-1;P<F;)if(void 0!==(Z=W[G=N[P+=1]]).default){var H=t+n.util.getProperty(G);if(n.compositeRule){if(n.opts.strictDefaults){v="default is ignored for: "+H;if("log"!==n.opts.strictDefaults)throw new Error(v);n.logger.warn(v)}}else e+=" if ("+H+" === undefined ","empty"==n.opts.useDefaults&&(e+=" || "+H+" === null || "+H+" === '' "),e+=" ) "+H+" = ","shared"==n.opts.useDefaults?e+=" "+n.useDefault(Z.default)+" ":e+=" "+JSON.stringify(Z.default)+" ",e+="; "}}else if("array"==s.type&&Array.isArray(n.schema.items)){var V=n.schema.items;if(V)for(var Z,T=-1,M=V.length-1;T<M;)if(void 0!==(Z=V[T+=1]).default){H=t+"["+T+"]";if(n.compositeRule){if(n.opts.strictDefaults){v="default is ignored for: "+H;if("log"!==n.opts.strictDefaults)throw new Error(v);n.logger.warn(v)}}else e+=" if ("+H+" === undefined ","empty"==n.opts.useDefaults&&(e+=" || "+H+" === null || "+H+" === '' "),e+=" ) "+H+" = ","shared"==n.opts.useDefaults?e+=" "+n.useDefault(Z.default)+" ":e+=" "+JSON.stringify(Z.default)+" ",e+="; "}}var c,O=s.rules;if(O)for(var D,K=-1,j=O.length-1;K<j;)!X(D=O[K+=1])||(D=D.code(n,D.keyword,s.type))&&(e+=" "+D+" ",i&&(b+="}"));i&&(e+=" "+b+" ",b=""),s.type&&(e+=" } ",r&&r===s.type&&!w&&(e+=" else { ",S=n.schemaPath+".type",x=n.errSchemaPath+"/type",(c=c||[]).push(e),e="",!1!==n.createErrors?(e=(e+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(x)+" , params: { type: '")+(o?""+r.join(","):""+r)+"' } ",!1!==n.opts.messages&&(e=(e+=" , message: 'should be ")+(o?""+r.join(","):""+r)+"' "),n.opts.verbose&&(e+=" , schema: validate.schema"+S+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+t+" "),e+=" } "):e+=" {} ",l=e,e=c.pop(),!n.compositeRule&&i?n.async?e+=" throw new ValidationError(["+l+"]); ":e+=" validate.errors = ["+l+"]; return false; ":e+=" var err = "+l+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",e+=" } ")),i&&(e=(e+=" if (errors === ")+(f?"0":"errs_"+C)+") { ",y+="}")}}function z(e){for(var t=e.rules,i=0;i<t.length;i++)if(X(t[i]))return 1}function X(e){return void 0!==n.schema[e.keyword]||e.implements&&function(e){for(var t=e.implements,i=0;i<t.length;i++)if(void 0!==n.schema[t[i]])return 1}(e)}return i&&(e+=" "+y+" "),f?e=e+(u?" if (errors === 0) return data;            else throw new ValidationError(vErrors); ":" validate.errors = vErrors;  return errors === 0;       ")+" }; return validate;":e+=" var "+A+" = errors === errs_"+C+";",e}},7931:function(e,t,i){"use strict";var a=/^[a-z_$][a-z0-9_$-]*$/i,l=i(1793),n=i(5868);function r(e,t){r.errors=null;var i=this._validateKeyword=this._validateKeyword||this.compile(n,!0);if(i(e))return!0;if(r.errors=i.errors,t)throw new Error("custom keyword definition is invalid: "+this.errorsText(i.errors));return!1}e.exports={add:function(e,t){var s=this.RULES;if(s.keywords[e])throw new Error("Keyword "+e+" is already defined");if(!a.test(e))throw new Error("Keyword "+e+" is not a valid identifier");if(t){this.validateKeyword(t,!0);var i=t.type;if(Array.isArray(i))for(var n=0;n<i.length;n++)o(e,i[n],t);else o(e,i,t);var r=t.metaSchema;r&&(t.$data&&this._opts.$data&&(r={anyOf:[r,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]}),t.validateSchema=this.compile(r,!0))}function o(e,t,i){for(var n,r=0;r<s.length;r++){var o=s[r];if(o.type==t){n=o;break}}n||s.push(n={type:t,rules:[]});i={keyword:e,definition:i,custom:!0,code:l,implements:i.implements};n.rules.push(i),s.custom[e]=i}return s.keywords[e]=s.all[e]=!0,this},get:function(e){var t=this.RULES.custom[e];return t?t.definition:this.RULES.keywords[e]||!1},remove:function(e){var t=this.RULES;delete t.keywords[e],delete t.all[e],delete t.custom[e];for(var i=0;i<t.length;i++)for(var n=t[i].rules,r=0;r<n.length;r++)if(n[r].keyword==e){n.splice(r,1);break}return this},validate:r}},2303:function(e){"use strict";e.exports=function e(t,i){if(t===i)return!0;if(t&&i&&"object"==typeof t&&"object"==typeof i){if(t.constructor!==i.constructor)return!1;var n,r,o;if(Array.isArray(t)){if((n=t.length)!=i.length)return!1;for(r=n;0!=r--;)if(!e(t[r],i[r]))return!1;return!0}if(t.constructor===RegExp)return t.source===i.source&&t.flags===i.flags;if(t.valueOf!==Object.prototype.valueOf)return t.valueOf()===i.valueOf();if(t.toString!==Object.prototype.toString)return t.toString()===i.toString();if((n=(o=Object.keys(t)).length)!==Object.keys(i).length)return!1;for(r=n;0!=r--;)if(!Object.prototype.hasOwnProperty.call(i,o[r]))return!1;for(r=n;0!=r--;){var s=o[r];if(!e(t[s],i[s]))return!1}return!0}return t!=t&&i!=i}},3508:function(e){"use strict";e.exports=function(e,t){var n,l="boolean"==typeof(t="function"==typeof(t=t||{})?{cmp:t}:t).cycles&&t.cycles,c=t.cmp&&(n=t.cmp,function(i){return function(e,t){e={key:e,value:i[e]},t={key:t,value:i[t]};return n(e,t)}}),h=[];return function e(t){if(void 0!==(t=t&&t.toJSON&&"function"==typeof t.toJSON?t.toJSON():t)){if("number"==typeof t)return isFinite(t)?""+t:"null";if("object"!=typeof t)return JSON.stringify(t);if(Array.isArray(t)){for(r="[",o=0;o<t.length;o++)o&&(r+=","),r+=e(t[o])||"null";return r+"]"}if(null===t)return"null";if(-1!==h.indexOf(t)){if(l)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}for(var i=h.push(t)-1,n=Object.keys(t).sort(c&&c(t)),r="",o=0;o<n.length;o++){var s=n[o],a=e(t[s]);a&&(r&&(r+=","),r+=JSON.stringify(s)+":"+a)}return h.splice(i,1),"{"+r+"}"}}(e)}},233:function(e){e.exports=function h(e,t){"use strict";function i(e){return h.insensitive&&(""+e).toLowerCase()||""+e}var n,r,o=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,s=/(^[ ]*|[ ]*$)/g,d=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,u=/^0x[0-9a-f]+$/i,g=/^0/,e=i(e).replace(s,"")||"",t=i(t).replace(s,"")||"",a=e.replace(o,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),l=t.replace(o,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),s=parseInt(e.match(u),16)||1!==a.length&&e.match(d)&&Date.parse(e),o=parseInt(t.match(u),16)||s&&t.match(d)&&Date.parse(t)||null;if(o){if(s<o)return-1;if(o<s)return 1}for(var c=0,p=Math.max(a.length,l.length);c<p;c++){if(n=!(a[c]||"").match(g)&&parseFloat(a[c])||a[c]||0,r=!(l[c]||"").match(g)&&parseFloat(l[c])||l[c]||0,isNaN(n)!==isNaN(r))return isNaN(n)?1:-1;if(typeof n!=typeof r&&(n+="",r+=""),n<r)return-1;if(r<n)return 1}return 0}},5156:function(e,t){!function(e){"use strict";function w(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function k(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function E(e,t){if(e===t)return!0;if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(t))return!1;if(!0===w(e)){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!1===E(e[i],t[i]))return!1;return!0}if(!0!==k(e))return!1;var n,r,o={};for(n in e)if(hasOwnProperty.call(e,n)){if(!1===E(e[n],t[n]))return!1;o[n]=!0}for(r in t)if(hasOwnProperty.call(t,r)&&!0!==o[r])return!1;return!0}function R(e){if(""===e||!1===e||null===e)return!0;if(w(e)&&0===e.length)return!0;if(k(e)){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0}return!1}var r="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]},g={0:"number",1:"any",2:"string",3:"array",4:"object",5:"boolean",6:"expression",7:"null",8:"Array<number>",9:"Array<string>"},p="UnquotedIdentifier",m="QuotedIdentifier",s="Rbracket",a="Rparen",l="Comma",c="Colon",o="Rbrace",f="Number",S="Current",T="Expref",_="Pipe",x="Flatten",h="Star",C="Filter",I="Lbrace",d="Lbracket",v="Lparen",A="Literal",b={".":"Dot","*":h,",":l,":":c,"{":I,"}":o,"]":s,"(":v,")":a,"@":S},y={"<":!0,">":!0,"=":!0,"!":!0},$={" ":!0,"\t":!0,"\n":!0};function L(e){return"0"<=e&&e<="9"||"-"===e}function i(){}i.prototype={tokenize:function(e){var t,i,n=[];for(this._current=0;this._current<e.length;)if("a"<=(o=e[this._current])&&o<="z"||"A"<=o&&o<="Z"||"_"===o)r=this._current,t=this._consumeUnquotedIdentifier(e),n.push({type:p,value:t,start:r});else if(void 0!==b[e[this._current]])n.push({type:b[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(L(e[this._current]))i=this._consumeNumber(e),n.push(i);else if("["===e[this._current])i=this._consumeLBracket(e),n.push(i);else if('"'===e[this._current])r=this._current,t=this._consumeQuotedIdentifier(e),n.push({type:m,value:t,start:r});else if("'"===e[this._current])r=this._current,t=this._consumeRawStringLiteral(e),n.push({type:A,value:t,start:r});else if("`"===e[this._current]){var r=this._current,o=this._consumeLiteral(e);n.push({type:A,value:o,start:r})}else if(void 0!==y[e[this._current]])n.push(this._consumeOperator(e));else if(void 0!==$[e[this._current]])this._current++;else if("&"===e[this._current])r=this._current,this._current++,"&"===e[this._current]?(this._current++,n.push({type:"And",value:"&&",start:r})):n.push({type:T,value:"&",start:r});else{if("|"!==e[this._current])throw(o=new Error("Unknown character:"+e[this._current])).name="LexerError",o;r=this._current,this._current++,"|"===e[this._current]?(this._current++,n.push({type:"Or",value:"||",start:r})):n.push({type:_,value:"|",start:r})}return n},_consumeUnquotedIdentifier:function(e){var t,i=this._current;for(this._current++;this._current<e.length&&("a"<=(t=e[this._current])&&t<="z"||"A"<=t&&t<="Z"||"0"<=t&&t<="9"||"_"===t);)this._current++;return e.slice(i,this._current)},_consumeQuotedIdentifier:function(e){for(var t=this._current,i=(this._current++,e.length);'"'!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&'"'!==e[n+1]?n++:n+=2,this._current=n}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){for(var t=this._current,i=(this._current++,e.length);"'"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"'"!==e[n+1]?n++:n+=2,this._current=n}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){for(var t=this._current,i=(this._current++,e.length);L(e[this._current])&&this._current<i;)this._current++;var n=parseInt(e.slice(t,this._current));return{type:f,value:n,start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:C,value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:x,value:"[]",start:t}):{type:d,value:"[",start:t}},_consumeOperator:function(e){var t=this._current,i=e[t];return this._current++,"!"===i?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===i?"="===e[this._current]?(this._current++,{type:"LTE",value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===i?"="===e[this._current]?(this._current++,{type:"GTE",value:">=",start:t}):{type:"GT",value:">",start:t}:"="===i&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t=this._current,i=e.length;"`"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"`"!==e[n+1]?n++:n+=2,this._current=n}t=(t=r(e.slice(t,this._current))).replace("\\`","`"),t=this._looksLikeJSON(t)?JSON.parse(t):JSON.parse('"'+t+'"');return this._current++,t},_looksLikeJSON:function(e){if(""===e)return!1;if(0<='[{"'.indexOf(e[0]))return!0;if(0<=["true","false","null"].indexOf(e))return!0;if(!(0<="-0123456789".indexOf(e[0])))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var u={};function B(){}function W(e){this.runtime=e}function N(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[0]}]},avg:{_func:this._functionAvg,_signature:[{types:[8]}]},ceil:{_func:this._functionCeil,_signature:[{types:[0]}]},contains:{_func:this._functionContains,_signature:[{types:[2,3]},{types:[1]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[2]},{types:[2]}]},floor:{_func:this._functionFloor,_signature:[{types:[0]}]},length:{_func:this._functionLength,_signature:[{types:[2,3,4]}]},map:{_func:this._functionMap,_signature:[{types:[6]},{types:[3]}]},max:{_func:this._functionMax,_signature:[{types:[8,9]}]},merge:{_func:this._functionMerge,_signature:[{types:[4],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[3]},{types:[6]}]},sum:{_func:this._functionSum,_signature:[{types:[8]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[2]},{types:[2]}]},min:{_func:this._functionMin,_signature:[{types:[8,9]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[3]},{types:[6]}]},type:{_func:this._functionType,_signature:[{types:[1]}]},keys:{_func:this._functionKeys,_signature:[{types:[4]}]},values:{_func:this._functionValues,_signature:[{types:[4]}]},sort:{_func:this._functionSort,_signature:[{types:[9,8]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[3]},{types:[6]}]},join:{_func:this._functionJoin,_signature:[{types:[2]},{types:[9]}]},reverse:{_func:this._functionReverse,_signature:[{types:[2,3]}]},to_array:{_func:this._functionToArray,_signature:[{types:[1]}]},to_string:{_func:this._functionToString,_signature:[{types:[1]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[1]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[1],variadic:!0}]}}}u.EOF=0,u[p]=0,u[m]=0,u[s]=0,u[a]=0,u[l]=0,u[o]=0,u[f]=0,u[S]=0,u[T]=0,u.Pipe=1,u.Or=2,u.And=3,u.EQ=5,u.GT=5,u.LT=5,u.GTE=5,u.LTE=5,u.NE=5,u[x]=9,u.Star=20,u[C]=21,u.Dot=40,u.Not=45,u[I]=50,u[d]=55,u[v]=60,B.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t,e=this.expression(0);if("EOF"!==this._lookahead(0))throw t=this._lookaheadToken(0),(t=new Error("Unexpected token type: "+t.type+", value: "+t.value)).name="ParserError",t;return e},_loadTokens:function(e){var t=(new i).tokenize(e);t.push({type:"EOF",value:"",start:e.length}),this.tokens=t},expression:function(e){for(var t=this._lookaheadToken(0),i=(this._advance(),this.nud(t)),n=this._lookahead(0);e<u[n];)this._advance(),i=this.led(n,i),n=this._lookahead(0);return i},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,i;switch(e.type){case A:return{type:"Literal",value:e.value};case p:return{type:"Field",name:e.value};case m:var n={type:"Field",name:e.value};if(this._lookahead(0)===v)throw new Error("Quoted identifier not allowed for function names.");return n;case"Not":return{type:"NotExpression",children:[t=this.expression(u.Not)]};case h:return t=null,{type:"ValueProjection",children:[{type:"Identity"},t=this._lookahead(0)===s?{type:"Identity"}:this._parseProjectionRHS(u.Star)]};case C:return this.led(e.type,{type:"Identity"});case I:return this._parseMultiselectHash();case x:return{type:"Projection",children:[{type:x,children:[{type:"Identity"}]},t=this._parseProjectionRHS(u.Flatten)]};case d:return this._lookahead(0)===f||this._lookahead(0)===c?(t=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},t)):this._lookahead(0)===h&&this._lookahead(1)===s?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},t=this._parseProjectionRHS(u.Star)]}):this._parseMultiselectList();case S:return{type:S};case T:return{type:"ExpressionReference",children:[i=this.expression(u.Expref)]};case v:for(var r=[];this._lookahead(0)!==a;)this._lookahead(0)===S?(i={type:S},this._advance()):i=this.expression(0),r.push(i);return this._match(a),r[0];default:this._errorToken(e)}},led:function(e,t){var i;switch(e){case"Dot":var n=u.Dot;return this._lookahead(0)!==h?{type:"Subexpression",children:[t,i=this._parseDotRHS(n)]}:(this._advance(),{type:"ValueProjection",children:[t,i=this._parseProjectionRHS(n)]});case _:return i=this.expression(u.Pipe),{type:_,children:[t,i]};case"Or":return{type:"OrExpression",children:[t,i=this.expression(u.Or)]};case"And":return{type:"AndExpression",children:[t,i=this.expression(u.And)]};case v:for(var r,n=t.name,o=[];this._lookahead(0)!==a;)this._lookahead(0)===S?(r={type:S},this._advance()):r=this.expression(0),this._lookahead(0)===l&&this._match(l),o.push(r);return this._match(a),{type:"Function",name:n,children:o};case C:n=this.expression(0);return this._match(s),{type:"FilterProjection",children:[t,i=this._lookahead(0)===x?{type:"Identity"}:this._parseProjectionRHS(u.Filter),n]};case x:return{type:"Projection",children:[{type:x,children:[t]},this._parseProjectionRHS(u.Flatten)]};case"EQ":case"NE":case"GT":case"GTE":case"LT":case"LTE":return this._parseComparator(t,e);case d:n=this._lookaheadToken(0);return n.type===f||n.type===c?(i=this._parseIndexExpression(),this._projectIfSlice(t,i)):(this._match(h),this._match(s),{type:"Projection",children:[t,i=this._parseProjectionRHS(u.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){var t;if(this._lookahead(0)!==e)throw t=this._lookaheadToken(0),(e=new Error("Expected "+e+", got: "+t.type)).name="ParserError",e;this._advance()},_errorToken:function(e){e=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw e.name="ParserError",e},_parseIndexExpression:function(){var e;return this._lookahead(0)===c||this._lookahead(1)===c?this._parseSliceExpression():(e={type:"Index",value:this._lookaheadToken(0).value},this._advance(),this._match(s),e)},_projectIfSlice:function(e,t){e={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[e,this._parseProjectionRHS(u.Star)]}:e},_parseSliceExpression:function(){for(var e,t=[null,null,null],i=0,n=this._lookahead(0);n!==s&&i<3;){if(n===c)i++,this._advance();else{if(n!==f)throw e=this._lookahead(0),(e=new Error("Syntax error, unexpected token: "+e.value+"("+e.type+")")).name="Parsererror",e;t[i]=this._lookaheadToken(0).value,this._advance()}n=this._lookahead(0)}return this._match(s),{type:"Slice",children:t}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(u[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return 0<=[p,m,h].indexOf(t)?this.expression(e):t===d?(this._match(d),this._parseMultiselectList()):t===I?(this._match(I),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t,i;if(u[this._lookahead(0)]<10)t={type:"Identity"};else if(this._lookahead(0)===d)t=this.expression(e);else if(this._lookahead(0)===C)t=this.expression(e);else{if("Dot"!==this._lookahead(0))throw i=this._lookaheadToken(0),(i=new Error("Sytanx error, unexpected token: "+i.value+"("+i.type+")")).name="ParserError",i;this._match("Dot"),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];this._lookahead(0)!==s;){var t=this.expression(0);if(e.push(t),this._lookahead(0)===l&&(this._match(l),this._lookahead(0)===s))throw new Error("Unexpected token Rbracket")}return this._match(s),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,i=[],n=[p,m];;){if(e=this._lookaheadToken(0),n.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(e=e.value,this._advance(),this._match(c),t=this.expression(0),i.push({type:"KeyValuePair",name:e,value:t}),this._lookahead(0)===l)this._match(l);else if(this._lookahead(0)===o){this._match(o);break}}return{type:"MultiSelectHash",children:i}}},W.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,t){var h,i,n,r,d,u;switch(e.type){case"Field":return null!==t&&k(t)?void 0===(o=t[e.name])?null:o:null;case"Subexpression":for(s=this.visit(e.children[0],t),c=1;c<e.children.length;c++)if(null===(s=this.visit(e.children[1],s)))return null;return s;case"IndexExpression":return d=this.visit(e.children[0],t),this.visit(e.children[1],d);case"Index":if(!w(t))return null;var o=e.value;return s=void 0===(s=t[o=o<0?t.length+o:o])?null:s;case"Slice":if(!w(t))return null;var o=e.children.slice(0),o=this.computeSliceParams(t.length,o),g=o[0],p=o[1],m=o[2],s=[];if(0<m)for(c=g;c<p;c+=m)s.push(t[c]);else for(c=g;p<c;c+=m)s.push(t[c]);return s;case"Projection":var a=this.visit(e.children[0],t);if(!w(a))return null;for(l=[],c=0;c<a.length;c++)null!==(i=this.visit(e.children[1],a[c]))&&l.push(i);return l;case"ValueProjection":if(!k(a=this.visit(e.children[0],t)))return null;for(var l=[],f=function(e){for(var t=Object.keys(e),i=[],n=0;n<t.length;n++)i.push(e[t[n]]);return i}(a),c=0;c<f.length;c++)null!==(i=this.visit(e.children[1],f[c]))&&l.push(i);return l;case"FilterProjection":if(!w(a=this.visit(e.children[0],t)))return null;var C=[],I=[];for(c=0;c<a.length;c++)R(h=this.visit(e.children[2],a[c]))||C.push(a[c]);for(var v=0;v<C.length;v++)null!==(i=this.visit(e.children[1],C[v]))&&I.push(i);return I;case"Comparator":switch(n=this.visit(e.children[0],t),r=this.visit(e.children[1],t),e.name){case"EQ":s=E(n,r);break;case"NE":s=!E(n,r);break;case"GT":s=r<n;break;case"GTE":s=r<=n;break;case"LT":s=n<r;break;case"LTE":s=n<=r;break;default:throw new Error("Unknown comparator: "+e.name)}return s;case x:var A=this.visit(e.children[0],t);if(!w(A))return null;var b=[];for(c=0;c<A.length;c++)w(i=A[c])?b.push.apply(b,i):b.push(i);return b;case"Identity":return t;case"MultiSelectList":if(null===t)return null;for(l=[],c=0;c<e.children.length;c++)l.push(this.visit(e.children[c],t));return l;case"MultiSelectHash":if(null===t)return null;for(l={},c=0;c<e.children.length;c++)l[(u=e.children[c]).name]=this.visit(u.value,t);return l;case"OrExpression":return h=R(h=this.visit(e.children[0],t))?this.visit(e.children[1],t):h;case"AndExpression":return!0===R(n=this.visit(e.children[0],t))?n:this.visit(e.children[1],t);case"NotExpression":return R(n=this.visit(e.children[0],t));case"Literal":return e.value;case _:return d=this.visit(e.children[0],t),this.visit(e.children[1],d);case S:return t;case"Function":var y=[];for(c=0;c<e.children.length;c++)y.push(this.visit(e.children[c],t));return this.runtime.callFunction(e.name,y);case"ExpressionReference":o=e.children[0];return o.jmespathType=T,o;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var i=t[0],n=t[1],t=t[2],r=[null,null,null];if(null===t)t=1;else if(0===t)throw(o=new Error("Invalid slice, step cannot be 0")).name="RuntimeError",o;var o=t<0,i=null===i?o?e-1:0:this.capSliceRange(e,i,t),n=null===n?o?-1:e:this.capSliceRange(e,n,t);return r[0]=i,r[1]=n,r[2]=t,r},capSliceRange:function(e,t,i){return t<0?(t+=e)<0&&(t=i<0?-1:0):e<=t&&(t=i<0?e-1:e),t}},N.prototype={callFunction:function(e,t){var i=this.functionTable[e];if(void 0===i)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,i._signature),i._func.call(this,t)},_validateArgs:function(e,t,i){var n;if(i[i.length-1].variadic){if(t.length<i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+i.length+n+" but received "+t.length)}else if(t.length!==i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+i.length+n+" but received "+t.length);for(var r=0;r<i.length;r++){for(var o,s=!1,a=i[r].types,l=this._getTypeName(t[r]),c=0;c<a.length;c++)if(this._typeMatches(l,a[c],t[r])){s=!0;break}if(!s)throw o=a.map(function(e){return g[e]}).join(","),new Error("TypeError: "+e+"() expected argument "+(r+1)+" to be type "+o+" but received type "+g[l]+" instead.")}},_typeMatches:function(e,t,i){if(1===t)return!0;if(9!==t&&8!==t&&3!==t)return e===t;if(3===t)return 3===e;if(3===e){var n;8===t?n=0:9===t&&(n=2);for(var r=0;r<i.length;r++)if(!this._typeMatches(this._getTypeName(i[r]),n,i[r]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return 2;case"[object Number]":return 0;case"[object Array]":return 3;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return e.jmespathType===T?6:4}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],e=e[1];return-1!==t.indexOf(e,t.length-e.length)},_functionReverse:function(e){var t;if(2!==this._getTypeName(e[0]))return(t=e[0].slice(0)).reverse(),t;for(var i=e[0],n="",r=i.length-1;0<=r;r--)n+=i[r];return n},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t/i.length},_functionContains:function(e){return 0<=e[0].indexOf(e[1])},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return(k(e[0])?Object.keys(e[0]):e[0]).length},_functionMap:function(e){for(var t=[],i=this._interpreter,n=e[0],r=e[1],o=0;o<r.length;o++)t.push(i.visit(n,r[o]));return t},_functionMerge:function(e){for(var t={},i=0;i<e.length;i++){var n,r=e[i];for(n in r)t[n]=r[n]}return t},_functionMax:function(e){if(0<e[0].length){if(0===this._getTypeName(e[0][0]))return Math.max.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)i.localeCompare(t[n])<0&&(i=t[n]);return i}return null},_functionMin:function(e){if(0<e[0].length){if(0===this._getTypeName(e[0][0]))return Math.min.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)t[n].localeCompare(i)<0&&(i=t[n]);return i}return null},_functionSum:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case 0:return"number";case 2:return"string";case 3:return"array";case 4:return"object";case 5:return"boolean";case 6:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],i=Object.keys(t),n=[],r=0;r<i.length;r++)n.push(t[i[r]]);return n},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return 3===this._getTypeName(e[0])?e[0]:[e[0]]},_functionToString:function(e){return 2===this._getTypeName(e[0])?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t,i=this._getTypeName(e[0]);return 0===i?e[0]:2!==i||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){e=e[0].slice(0);return e.sort(),e},_functionSortBy:function(e){var t=e[0].slice(0);if(0===t.length)return t;var r=this._interpreter,o=e[1],s=this._getTypeName(r.visit(o,t[0]));if([0,2].indexOf(s)<0)throw new Error("TypeError");for(var a=this,i=[],n=0;n<t.length;n++)i.push([n,t[n]]);i.sort(function(e,t){var i=r.visit(o,e[1]),n=r.visit(o,t[1]);if(a._getTypeName(i)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(i));if(a._getTypeName(n)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(n));return n<i?1:i<n?-1:e[0]-t[0]});for(var l=0;l<i.length;l++)t[l]=i[l][1];return t},_functionMaxBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[0,2]),s=-1/0,a=0;a<r.length;a++)s<(i=o(r[a]))&&(s=i,t=r[a]);return t},_functionMinBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[0,2]),s=1/0,a=0;a<r.length;a++)(i=o(r[a]))<s&&(s=i,t=r[a]);return t},createKeyFunction:function(i,n){var r=this,o=this._interpreter;return function(e){var t,e=o.visit(i,e);if(n.indexOf(r._getTypeName(e))<0)throw t="TypeError: expected one of "+n+", received "+r._getTypeName(e),new Error(t);return e}}},e.tokenize=function(e){return(new i).tokenize(e)},e.compile=function(e){return(new B).parse(e)},e.search=function(e,t){var i=new B,n=new W(r=new N),r=(r._interpreter=n,i.parse(t));return n.search(r,e)},e.strictDeepEqual=E}(t)},500:function(e){"use strict";var m=e.exports=function(e,t,i){"function"==typeof t&&(i=t,t={}),function e(t,i,n,r,o,s,h,d,u,g){if(r&&"object"==typeof r&&!Array.isArray(r)){for(var a in i(r,o,s,h,d,u,g),r){var l=r[a];if(Array.isArray(l)){if(a in m.arrayKeywords)for(var c=0;c<l.length;c++)e(t,i,n,l[c],o+"/"+a+"/"+c,s,o,a,r,c)}else if(a in m.propsKeywords){if(l&&"object"==typeof l)for(var p in l)e(t,i,n,l[p],o+"/"+a+"/"+f(p),s,o,a,r,p)}else(a in m.keywords||t.allKeys&&!(a in m.skipKeywords))&&e(t,i,n,l,o+"/"+a,s,o,a,r)}n(r,o,s,h,d,u,g)}}(t,"function"==typeof(i=t.cb||i)?i:i.pre||function(){},i.post||function(){},e,"",e)};function f(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}m.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},m.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},m.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},m.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},7026:function(o,e){"use strict";var b={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},y="a".charCodeAt(),t=(e.parse=function(r,e,i){var n={},u=0,t=0,o=0,g=i&&i.bigint&&"undefined"!=typeof BigInt;return{data:s("",!0),pointers:n};function s(e,t){a(),C(e,"value");var i,n=l();switch(n){case"t":m("rue"),i=!0;break;case"f":m("alse"),i=!1;break;case"n":m("ull"),i=null;break;case'"':i=p();break;case"[":i=function(e){a();var t=[],i=0;if("]"==l())return t;c();for(;;){var n=e+"/"+i,n=(t.push(s(n)),a(),l());if("]"==n)break;","!=n&&d(),a(),i++}return t}(e);break;case"{":i=function(e){a();var t={};if("}"==l())return t;c();for(;;){var i=v(),n=('"'!=l()&&d(),p()),r=e+"/"+w(n),i=(I(r,"key",i),C(r,"keyEnd"),a(),":"!=l()&&d(),a(),t[n]=s(r),a(),l());if("}"==i)break;","!=i&&d(),a()}return t}(e);break;default:c(),0<="-0123456789".indexOf(n)?i=function(){var e="",t=!0;"-"==r[o]&&(e+=l());e+=("0"==r[o]?l:f)(),"."==r[o]&&(e+=l()+f(),t=!1);"e"!=r[o]&&"E"!=r[o]||(e+=l(),"+"!=r[o]&&"-"!=r[o]||(e+=l()),e+=f(),t=!1);var i=+e;return g&&t&&(i>Number.MAX_SAFE_INTEGER||i<Number.MIN_SAFE_INTEGER)?BigInt(e):i}():h()}return C(e,"valueEnd"),a(),t&&o<r.length&&h(),i}function a(){e:for(;o<r.length;){switch(r[o]){case" ":t++;break;case"\t":t+=4;break;case"\r":t=0;break;case"\n":t=0,u++;break;default:break e}o++}}function p(){for(var e,t="";'"'!=(e=l());)"\\"==e?(e=l())in b?t+=b[e]:"u"==e?t+=function(){var e=4,t=0;for(;e--;){t<<=4;var i=l().toLowerCase();"a"<=i&&i<="f"?t+=i.charCodeAt()-y+10:"0"<=i&&i<="9"?t+=+i:d()}return String.fromCharCode(t)}():d():t+=e;return t}function m(e){for(var t=0;t<e.length;t++)l()!==e[t]&&d()}function l(){A();var e=r[o];return o++,t++,e}function c(){o--,t--}function f(){for(var e="";"0"<=r[o]&&r[o]<="9";)e+=l();if(e.length)return e;A(),h()}function C(e,t){I(e,t,v())}function I(e,t,i){n[e]=n[e]||{},n[e][t]=i}function v(){return{line:u,column:t,pos:o}}function h(){throw new SyntaxError("Unexpected token "+r[o]+" in JSON at position "+o)}function d(){c(),h()}function A(){if(o>=r.length)throw new SyntaxError("Unexpected end of JSON input")}},e.stringify=function(s,a,e){if(v(s)){var l=0;switch(typeof(u="object"==typeof e?e.space:e)){case"number":var t=10<u?10:u<0?0:Math.floor(u),u=t&&I(t," "),c=t,i=t;break;case"string":u=u.slice(0,10);for(var h=i=c=0;h<u.length;h++){switch(u[h]){case" ":i++;break;case"\t":i+=4;break;case"\r":i=0;break;case"\n":i=0,l++;break;default:throw new Error("whitespace characters not allowed in JSON")}c++}break;default:u=void 0}var d="",n={},f=0,r=0,o=0,C=e&&e.es6&&"function"==typeof Map;return function l(c,h,d){m(d,"value");switch(typeof c){case"number":case"bigint":case"boolean":g(""+c);break;case"string":g(A(c));break;case"object":null===c?g("null"):"function"==typeof c.toJSON?g(A(c.toJSON())):Array.isArray(c)?e():C?c.constructor.BYTES_PER_ELEMENT?e():c instanceof Map?i():c instanceof Set?i(!0):t():t()}m(d,"valueEnd");function e(){if(c.length){g("[");for(var e=h+1,t=0;t<c.length;t++){t&&g(","),p(e);var i=v(c[t])?c[t]:null,n=d+"/"+t;l(i,e,n)}p(h),g("]")}else g("[]")}function t(){var e=Object.keys(c);if(e.length){g("{");for(var t=h+1,i=0;i<e.length;i++){var n,r=e[i],o=c[r];v(o)&&(i&&g(","),n=d+"/"+w(r),p(t),m(n,"key"),g(A(r)),m(n,"keyEnd"),g(":"),u&&g(" "),l(o,t,n))}p(h),g("}")}else g("{}")}function i(e){if(c.size){g("{");for(var t=h+1,i=!0,n=c.entries(),r=n.next();!r.done;){var o,s=r.value,a=s[0],s=!!e||s[1];v(s)&&(i||g(","),i=!1,o=d+"/"+w(a),p(t),m(o,"key"),g(A(a)),m(o,"keyEnd"),g(":"),u&&g(" "),l(s,t,o)),r=n.next()}p(h),g("}")}else g("{}")}}(s,0,""),{json:d,pointers:n}}function g(e){r+=e.length,o+=e.length,d+=e}function p(e){if(u){for(d+="\n"+I(e,u),f++,r=0;e--;)l?(f+=l,r=i):r+=i,o+=c;o+=1}}function m(e,t){n[e]=n[e]||{},n[e][t]={line:f,column:r,pos:o}}function I(e,t){return Array(e+1).join(t)}},["number","bigint","boolean","string","object"]);function v(e){return 0<=t.indexOf(typeof e)}var i=/"|\\/g,n=/[\b]/g,r=/\f/g,s=/\n/g,a=/\r/g,l=/\t/g;function A(e){return'"'+(e=e.replace(i,"\\$&").replace(r,"\\f").replace(n,"\\b").replace(s,"\\n").replace(a,"\\r").replace(l,"\\t"))+'"'}var c=/~/g,h=/\//g;function w(e){return e.replace(c,"~0").replace(h,"~1")}},483:function(e,t){var i,n;!function(){"use strict";n=[],void 0===(n="function"==typeof(i=function(){"use strict";function C(e){if(typeof Node==="object")return e instanceof Node;else return e&&typeof e==="object"&&typeof e.nodeType==="number"}function I(e){return typeof e==="string"}function v(){var o=[];return{watch:o.push.bind(o),trigger:function(e,t){var i=true;var n={detail:t,preventDefault:function e(){i=false}};for(var r=0;r<o.length;r++)o[r](e,n);return i}}}function r(e){return window.getComputedStyle(e).display==="none"}function o(e){this.elem=e}function A(e,t){return o.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){if(e("overlayClose",true))t()})}o.make=function(e,t){if(typeof e==="string")e=document.querySelector(e);var i=document.createElement(t||"div");(e||document.body).appendChild(i);return new o(i)},o.prototype={child:function(e){return o.make(this.elem,e)},stylize:function(e){e=e||{};if(typeof e.opacity!=="undefined")e.filter="alpha(opacity="+e.opacity*100+")";for(var t in e)if(e.hasOwnProperty(t))this.elem.style[t]=e[t];return this},clazz:function(e){this.elem.className+=" "+e;return this},html:function(e){if(C(e))this.elem.appendChild(e);else this.elem.innerHTML=e;return this},onClick:function(e){this.elem.addEventListener("click",e);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){if(t!==undefined)this.elem.setAttribute(e,t);return this},anyAncestor:function(e){var t=this.elem;while(t)if(e(new o(t)))return true;else t=t.parentNode;return false},isVisible:function(){return!r(this.elem)}};var s=1;function w(e,i){var t=e("width","auto");if(typeof t==="number")t=""+t+"px";var n=e("modalId","pico-"+s++);var r=o.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:t,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){var t=new o(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)});if(t)i()});return r}function S(e,t){if(t("closeButton",true))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function b(e){return function(){return e().elem}}var y=v(),c=v();function x(o,s){function t(e,t){var i=e.msMatchesSelector||e.webkitMatchesSelector||e.matches;return i.call(e,t)}function n(e){if(r(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))return false;else return e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe")}function a(e){var t=e.getElementsByTagName("*");for(var i=0;i<t.length;i++)if(n(t[i]))return t[i]}function l(e){var t=e.getElementsByTagName("*");for(var i=t.length;i--;)if(n(t[i]))return t[i]}var i;o.beforeShow(function e(){i=document.activeElement});o.afterShow(function e(){if(s()){var t=a(o.modalElem());if(t)t.focus()}});o.afterClose(function e(){if(s()&&i)i.focus();i=null});c.watch(function e(t){if(s()&&o.isVisible()){var i=a(o.modalElem());var n=l(o.modalElem());var r=t.shiftKey?i:n;if(r===document.activeElement){(t.shiftKey?n:i).focus();t.preventDefault()}}})}function k(e,t){var i;var n=new o(document.body);e.beforeShow(function(){i=n.elem.style.overflow;if(t())n.stylize({overflow:"hidden"})});e.afterClose(function(){n.stylize({overflow:i})})}return document.documentElement.addEventListener("keydown",function e(t){var i=t.which||t.keyCode;if(i===27)y.trigger();else if(i===9)c.trigger(t)}),function h(n){if(I(n)||C(n))n={content:n};var d=v();var u=v();var g=v();var p=v();var m=v();function r(e,t){var i=n[e];if(typeof i==="function")i=i(t);return i===undefined?t:i}var t=c.bind(window,"modal");var i=c.bind(window,"overlay");var o=c.bind(window,"close");var s;function f(e){i().hide();t().hide();m.trigger(s,e)}function a(e){if(p.trigger(s,e))f(e)}function e(e){return function(){e.apply(this,arguments);return s}}var l;function c(e,t){if(!l){var i=w(r,a);l={modal:i,overlay:A(r,a),close:S(i,r)};d.trigger(s,t)}return l[e]}s={modalElem:b(t),closeElem:b(o),overlayElem:b(i),buildDom:e(c.bind(null,null)),isVisible:function(){return!!(l&&t&&t().isVisible())},show:function(e){if(u.trigger(s,e)){i().show();o();t().show();g.trigger(s,e)}return this},close:e(a),forceClose:e(f),destroy:function(){t().destroy();i().destroy();i=t=o=undefined},options:function(t){Object.keys(t).map(function(e){n[e]=t[e]})},afterCreate:e(d.watch),beforeShow:e(u.watch),afterShow:e(g.watch),beforeClose:e(p.watch),afterClose:e(m.watch)};x(s,r.bind(null,"focus",true));k(s,r.bind(null,"bodyOverflow",true));y.watch(function e(){if(r("escCloses",true)&&s.isVisible())s.close()});return s}})?i.apply(t,n):i)||(e.exports=n)}()},7533:function(e,t){
/** @license URI.js v4.4.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */
!function(e){"use strict";function he(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++)t[i]=arguments[i];if(t.length>1){t[0]=t[0].slice(0,-1);var n=t.length-1;for(var r=1;r<n;++r)t[r]=t[r].slice(1,-1);t[n]=t[n].slice(1);return t.join("")}else return t[0]}function de(e){return"(?:"+e+")"}function n(e){return e===undefined?"undefined":e===null?"null":Object.prototype.toString.call(e).split(" ").pop().split("]").shift().toLowerCase()}function m(e){return e.toUpperCase()}function f(e){return e!==undefined&&e!==null?e instanceof Array?e:typeof e.length!=="number"||e.split||e.setInterval||e.call?[e]:Array.prototype.slice.call(e):[]}function r(e,t){var i=e;if(t)for(var n in t)i[n]=t[n];return i}function i(h){var d="[A-Za-z]",u="[\\x0D]",e="[0-9]",g="[\\x22]",t=he(e,"[A-Fa-f]"),p="[\\x0A]",m="[\\x20]",i=de(de("%[EFef]"+t+"%"+t+t+"%"+t+t)+"|"+de("%[89A-Fa-f]"+t+"%"+t+t)+"|"+de("%"+t+t)),f="[\\:\\/\\?\\#\\[\\]\\@]",n="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",C=he(f,n),I=h?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]",v=h?"[\\uE000-\\uF8FF]":"[]",r=he(d,e,"[\\-\\.\\_\\~]",I),A=de(d+he(d,e,"[\\+\\-\\.]")+"*"),b=de(de(i+"|"+he(r,n,"[\\:]"))+"*"),y=de(de("25[0-5]")+"|"+de("2[0-4]"+e)+"|"+de("1"+e+e)+"|"+de("[1-9]"+e)+"|"+e),w=de(de("25[0-5]")+"|"+de("2[0-4]"+e)+"|"+de("1"+e+e)+"|"+de("0?[1-9]"+e)+"|0?0?"+e),S=de(w+"\\."+w+"\\."+w+"\\."+w),o=de(t+"{1,4}"),s=de(de(o+"\\:"+o)+"|"+S),x=de(de(o+"\\:")+"{6}"+s),k=de("\\:\\:"+de(o+"\\:")+"{5}"+s),E=de(de(o)+"?\\:\\:"+de(o+"\\:")+"{4}"+s),R=de(de(de(o+"\\:")+"{0,1}"+o)+"?\\:\\:"+de(o+"\\:")+"{3}"+s),T=de(de(de(o+"\\:")+"{0,2}"+o)+"?\\:\\:"+de(o+"\\:")+"{2}"+s),_=de(de(de(o+"\\:")+"{0,3}"+o)+"?\\:\\:"+o+"\\:"+s),$=de(de(de(o+"\\:")+"{0,4}"+o)+"?\\:\\:"+s),L=de(de(de(o+"\\:")+"{0,5}"+o)+"?\\:\\:"+o),B=de(de(de(o+"\\:")+"{0,6}"+o)+"?\\:\\:"),W=de([x,k,E,R,T,_,$,L,B].join("|")),N=de(de(r+"|"+i)+"+"),G=de(W+"\\%25"+N),P=de(W+de("\\%25|\\%(?!"+t+"{2})")+N),F=de("[vV]"+t+"+\\."+he(r,n,"[\\:]")+"+"),H=de("\\["+de(P+"|"+W+"|"+F)+"\\]"),V=de(de(i+"|"+he(r,n))+"*"),Z=de(H+"|"+S+"(?!"+V+")"+"|"+V),M=de(e+"*"),O=de(de(b+"@")+"?"+Z+de("\\:"+M)+"?"),D=de(i+"|"+he(r,n,"[\\:\\@]")),K=de(D+"*"),j=de(D+"+"),z=de(de(i+"|"+he(r,n,"[\\@]"))+"+"),a=de(de("\\/"+K)+"*"),l=de("\\/"+de(j+a)+"?"),X=de(z+a),J=de(j+a),c="(?!"+D+")",Y=de(a+"|"+l+"|"+X+"|"+J+"|"+c),U=de(de(D+"|"+he("[\\/\\?]",v))+"*"),Q=de(de(D+"|[\\/\\?]")+"*"),q=de(de("\\/\\/"+O+a)+"|"+l+"|"+J+"|"+c),ee=de(A+"\\:"+q+de("\\?"+U)+"?"+de("\\#"+Q)+"?"),te=de(de("\\/\\/"+O+a)+"|"+l+"|"+X+"|"+c),ie=de(te+de("\\?"+U)+"?"+de("\\#"+Q)+"?"),ne=de(ee+"|"+ie),re=de(A+"\\:"+q+de("\\?"+U)+"?"),oe="^("+A+")\\:"+de(de("\\/\\/("+de("("+b+")@")+"?("+Z+")"+de("\\:("+M+")")+"?)")+"?("+a+"|"+l+"|"+J+"|"+c+")")+de("\\?("+U+")")+"?"+de("\\#("+Q+")")+"?$",se="^(){0}"+de(de("\\/\\/("+de("("+b+")@")+"?("+Z+")"+de("\\:("+M+")")+"?)")+"?("+a+"|"+l+"|"+X+"|"+c+")")+de("\\?("+U+")")+"?"+de("\\#("+Q+")")+"?$",ae="^("+A+")\\:"+de(de("\\/\\/("+de("("+b+")@")+"?("+Z+")"+de("\\:("+M+")")+"?)")+"?("+a+"|"+l+"|"+J+"|"+c+")")+de("\\?("+U+")")+"?$",le="^"+de("\\#("+Q+")")+"?$",ce="^"+de("("+b+")@")+"?("+Z+")"+de("\\:("+M+")")+"?$";return{NOT_SCHEME:new RegExp(he("[^]",d,e,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(he("[^\\%\\:]",r,n),"g"),NOT_HOST:new RegExp(he("[^\\%\\[\\]\\:]",r,n),"g"),NOT_PATH:new RegExp(he("[^\\%\\/\\:\\@]",r,n),"g"),NOT_PATH_NOSCHEME:new RegExp(he("[^\\%\\/\\@]",r,n),"g"),NOT_QUERY:new RegExp(he("[^\\%]",r,n,"[\\:\\@\\/\\?]",v),"g"),NOT_FRAGMENT:new RegExp(he("[^\\%]",r,n,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(he("[^]",r,n),"g"),UNRESERVED:new RegExp(r,"g"),OTHER_CHARS:new RegExp(he("[^\\%]",r,C),"g"),PCT_ENCODED:new RegExp(i,"g"),IPV4ADDRESS:new RegExp("^("+S+")$"),IPV6ADDRESS:new RegExp("^\\[?("+W+")"+de(de("\\%25|\\%(?!"+t+"{2})")+"("+N+")")+"?\\]?$")}}var a=i(false),l=i(true),y=function(){function i(e,t){var i=[];var n=true;var r=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){i.push(a.value);if(t&&i.length===t)break}}catch(e){r=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(r)throw o}}return i}return function(e,t){if(Array.isArray(e))return e;else if(Symbol.iterator in Object(e))return i(e,t);else throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),c=function(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}else return Array.from(e)},G=2147483647,W=36,P=1,F=26,d=38,u=700,H=72,V=128,Z="-",g=/^xn--/,C=/[^\0-\x7E]/,I=/[\x2E\u3002\uFF0E\uFF61]/g,v={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},A=W-P,N=Math.floor,M=String.fromCharCode;function O(e){throw new RangeError(v[e])}function b(e,t){var i=[];var n=e.length;while(n--)i[n]=t(e[n]);return i}function w(e,t){var i=e.split("@");var n="";if(i.length>1){n=i[0]+"@";e=i[1]}e=e.replace(I,".");var r=e.split(".");var o=b(r,t).join(".");return n+o}function D(e){var t=[];var i=0;var n=e.length;while(i<n){var r=e.charCodeAt(i++);if(r>=55296&&r<=56319&&i<n){var o=e.charCodeAt(i++);if((o&64512)==56320)t.push(((r&1023)<<10)+(o&1023)+65536);else{t.push(r);i--}}else t.push(r)}return t}var S,x=function e(t){if(t-48<10)return t-22;if(t-65<26)return t-65;if(t-97<26)return t-97;return W},K=function e(t,i){return t+22+75*(t<26)-((i!=0)<<5)},j=function e(t,i,n){var r=0;t=n?N(t/u):t>>1;t+=N(t/i);for(;t>A*F>>1;r+=W)t=N(t/A);return N(r+(A+1)*t/(t+d))},k=function h(e){var t=[];var d=e.length;var i=0;var u=V;var n=H;var r=e.lastIndexOf(Z);if(r<0)r=0;for(var o=0;o<r;++o){if(e.charCodeAt(o)>=128)O("not-basic");t.push(e.charCodeAt(o))}for(var g=r>0?r+1:0;g<d;){var p=i;for(var s=1,a=W;;a+=W){if(g>=d)O("invalid-input");var l=x(e.charCodeAt(g++));if(l>=W||l>N((G-i)/s))O("overflow");i+=l*s;var m=a<=n?P:a>=n+F?F:a-n;if(l<m)break;var f=W-m;if(s>N(G/f))O("overflow");s*=f}var c=t.length+1;n=j(i-p,c,p==0);if(N(i/c)>G-u)O("overflow");u+=N(i/c);i%=c;t.splice(i++,0,u)}return String.fromCodePoint.apply(String,t)},E=function h(e){var t=[];e=D(e);var d=e.length;var i=V;var n=0;var r=H;var u=true;var g=false;var p=undefined;try{for(var m=e[Symbol.iterator](),f;!(u=(f=m.next()).done);u=true){var C=f.value;if(C<128)t.push(M(C))}}catch(e){g=true;p=e}finally{try{if(!u&&m.return)m.return()}finally{if(g)throw p}}var I=t.length;var o=I;if(I)t.push(Z);while(o<d){var s=G;var v=true;var A=false;var b=undefined;try{for(var y=e[Symbol.iterator](),w;!(v=(w=y.next()).done);v=true){var S=w.value;if(S>=i&&S<s)s=S}}catch(e){A=true;b=e}finally{try{if(!v&&y.return)y.return()}finally{if(A)throw b}}var x=o+1;if(s-i>N((G-n)/x))O("overflow");n+=(s-i)*x;i=s;var k=true;var E=false;var R=undefined;try{for(var T=e[Symbol.iterator](),_;!(k=(_=T.next()).done);k=true){var $=_.value;if($<i&&++n>G)O("overflow");if($==i){var a=n;for(var l=W;;l+=W){var c=l<=r?P:l>=r+F?F:l-r;if(a<c)break;var L=a-c;var B=W-c;t.push(M(K(c+L%B,0)));a=N(L/B)}t.push(M(K(a,0)));r=j(n,x,o==I);n=0;++o}}}catch(e){E=true;R=e}finally{try{if(!k&&T.return)T.return()}finally{if(E)throw R}}++n;++i}return t.join("")},R,T,_={version:"2.1.0",ucs2:{decode:D,encode:function e(t){return String.fromCodePoint.apply(String,c(t))}},decode:k,encode:E,toASCII:function e(t){return w(t,function(e){return C.test(e)?"xn--"+E(e):e})},toUnicode:function e(t){return w(t,function(e){return g.test(e)?k(e.slice(4).toLowerCase()):e})}},h={};function p(e){var t=e.charCodeAt(0);var i=void 0;if(t<16)i="%0"+t.toString(16).toUpperCase();else if(t<128)i="%"+t.toString(16).toUpperCase();else if(t<2048)i="%"+(t>>6|192).toString(16).toUpperCase()+"%"+(t&63|128).toString(16).toUpperCase();else i="%"+(t>>12|224).toString(16).toUpperCase()+"%"+(t>>6&63|128).toString(16).toUpperCase()+"%"+(t&63|128).toString(16).toUpperCase();return i}function $(e){var t="";var i=0;var n=e.length;while(i<n){var r=parseInt(e.substr(i+1,2),16);if(r<128){t+=String.fromCharCode(r);i+=3}else if(r>=194&&r<224){if(n-i>=6){var o=parseInt(e.substr(i+4,2),16);t+=String.fromCharCode((r&31)<<6|o&63)}else t+=e.substr(i,6);i+=6}else if(r>=224){if(n-i>=9){var s=parseInt(e.substr(i+4,2),16);var a=parseInt(e.substr(i+7,2),16);t+=String.fromCharCode((r&15)<<12|(s&63)<<6|a&63)}else t+=e.substr(i,9);i+=9}else{t+=e.substr(i,3);i+=3}}return t}function L(e,i){function t(e){var t=$(e);return!t.match(i.UNRESERVED)?e:t}if(e.scheme)e.scheme=String(e.scheme).replace(i.PCT_ENCODED,t).toLowerCase().replace(i.NOT_SCHEME,"");if(e.userinfo!==undefined)e.userinfo=String(e.userinfo).replace(i.PCT_ENCODED,t).replace(i.NOT_USERINFO,p).replace(i.PCT_ENCODED,m);if(e.host!==undefined)e.host=String(e.host).replace(i.PCT_ENCODED,t).toLowerCase().replace(i.NOT_HOST,p).replace(i.PCT_ENCODED,m);if(e.path!==undefined)e.path=String(e.path).replace(i.PCT_ENCODED,t).replace(e.scheme?i.NOT_PATH:i.NOT_PATH_NOSCHEME,p).replace(i.PCT_ENCODED,m);if(e.query!==undefined)e.query=String(e.query).replace(i.PCT_ENCODED,t).replace(i.NOT_QUERY,p).replace(i.PCT_ENCODED,m);if(e.fragment!==undefined)e.fragment=String(e.fragment).replace(i.PCT_ENCODED,t).replace(i.NOT_FRAGMENT,p).replace(i.PCT_ENCODED,m);return e}function B(e){return e.replace(/^0*(.*)/,"$1")||"0"}function z(e,t){var i=e.match(t.IPV4ADDRESS)||[];var n=y(i,2),r=n[1];if(r)return r.split(".").map(B).join(".");else return e}function X(e,t){var h=e.match(t.IPV6ADDRESS)||[];var i=y(h,3),n=i[1],d=i[2];if(n){var u=n.toLowerCase().split("::").reverse(),g=y(u,2),p=g[0],m=g[1];var f=m?m.split(":").map(B):[];var r=p.split(":").map(B);var C=t.IPV4ADDRESS.test(r[r.length-1]);var o=C?7:8;var I=r.length-o;var s=Array(o);for(var a=0;a<o;++a)s[a]=f[a]||r[I+a]||"";if(C)s[o-1]=z(s[o-1],t);var v=s.reduce(function(e,t,i){if(!t||t==="0"){var n=e[e.length-1];if(n&&n.index+n.length===i)n.length++;else e.push({index:i,length:1})}return e},[]);var l=v.sort(function(e,t){return t.length-e.length})[0];var c=void 0;if(l&&l.length>1){var A=s.slice(0,l.index);var b=s.slice(l.index+l.length);c=A.join(":")+"::"+b.join(":")}else c=s.join(":");if(d)c+="%"+d;return c}else return e}var J=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,Y="".match(/(){0}/)[1]===undefined;function o(e){var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var i={};var n=t.iri!==false?l:a;if(t.reference==="suffix")e=(t.scheme?t.scheme+":":"")+"//"+e;var r=e.match(J);if(r){if(Y){i.scheme=r[1];i.userinfo=r[3];i.host=r[4];i.port=parseInt(r[5],10);i.path=r[6]||"";i.query=r[7];i.fragment=r[8];if(isNaN(i.port))i.port=r[5]}else{i.scheme=r[1]||undefined;i.userinfo=e.indexOf("@")!==-1?r[3]:undefined;i.host=e.indexOf("//")!==-1?r[4]:undefined;i.port=parseInt(r[5],10);i.path=r[6]||"";i.query=e.indexOf("?")!==-1?r[7]:undefined;i.fragment=e.indexOf("#")!==-1?r[8]:undefined;if(isNaN(i.port))i.port=e.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?r[4]:undefined}if(i.host)i.host=X(z(i.host,n),n);if(i.scheme===undefined&&i.userinfo===undefined&&i.host===undefined&&i.port===undefined&&!i.path&&i.query===undefined)i.reference="same-document";else if(i.scheme===undefined)i.reference="relative";else if(i.fragment===undefined)i.reference="absolute";else i.reference="uri";if(t.reference&&t.reference!=="suffix"&&t.reference!==i.reference)i.error=i.error||"URI is not a "+t.reference+" reference.";var o=h[(t.scheme||i.scheme||"").toLowerCase()];if(!t.unicodeSupport&&(!o||!o.unicodeSupport)){if(i.host&&(t.domainHost||o&&o.domainHost))try{i.host=_.toASCII(i.host.replace(n.PCT_ENCODED,$).toLowerCase())}catch(e){i.error=i.error||"Host's domain name can not be converted to ASCII via punycode: "+e}L(i,a)}else L(i,n);if(o&&o.parse)o.parse(i,t)}else i.error=i.error||"URI can not be parsed.";return i}function U(e,t){var i=t.iri!==false?l:a;var n=[];if(e.userinfo!==undefined){n.push(e.userinfo);n.push("@")}if(e.host!==undefined)n.push(X(z(String(e.host),i),i).replace(i.IPV6ADDRESS,function(e,t,i){return"["+t+(i?"%25"+i:"")+"]"}));if(typeof e.port==="number"||typeof e.port==="string"){n.push(":");n.push(String(e.port))}return n.length?n.join(""):undefined}var Q=/^\.\.?\//,q=/^\/\.(\/|$)/,ee=/^\/\.\.(\/|$)/,te=/^\/?(?:.|\n)*?(?=\/|$)/;function ie(e){var t=[];while(e.length)if(e.match(Q))e=e.replace(Q,"");else if(e.match(q))e=e.replace(q,"/");else if(e.match(ee)){e=e.replace(ee,"/");t.pop()}else if(e==="."||e==="..")e="";else{var i=e.match(te);if(i){var n=i[0];e=e.slice(n.length);t.push(n)}else throw new Error("Unexpected dot segment condition")}return t.join("")}function s(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var e=i.iri?l:a;var n=[];var r=h[(i.scheme||t.scheme||"").toLowerCase()];if(r&&r.serialize)r.serialize(t,i);if(t.host)if(e.IPV6ADDRESS.test(t.host));else if(i.domainHost||r&&r.domainHost)try{t.host=!i.iri?_.toASCII(t.host.replace(e.PCT_ENCODED,$).toLowerCase()):_.toUnicode(t.host)}catch(e){t.error=t.error||"Host's domain name can not be converted to "+(!i.iri?"ASCII":"Unicode")+" via punycode: "+e}L(t,e);if(i.reference!=="suffix"&&t.scheme){n.push(t.scheme);n.push(":")}var o=U(t,i);if(o!==undefined){if(i.reference!=="suffix")n.push("//");n.push(o);if(t.path&&t.path.charAt(0)!=="/")n.push("/")}if(t.path!==undefined){var s=t.path;if(!i.absolutePath&&(!r||!r.absolutePath))s=ie(s);if(o===undefined)s=s.replace(/^\/\//,"/%2F");n.push(s)}if(t.query!==undefined){n.push("?");n.push(t.query)}if(t.fragment!==undefined){n.push("#");n.push(t.fragment)}return n.join("")}function ne(e,t){var i=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var n=arguments[3];var r={};if(!n){e=o(s(e,i),i);t=o(s(t,i),i)}i=i||{};if(!i.tolerant&&t.scheme){r.scheme=t.scheme;r.userinfo=t.userinfo;r.host=t.host;r.port=t.port;r.path=ie(t.path||"");r.query=t.query}else{if(t.userinfo!==undefined||t.host!==undefined||t.port!==undefined){r.userinfo=t.userinfo;r.host=t.host;r.port=t.port;r.path=ie(t.path||"");r.query=t.query}else{if(!t.path){r.path=e.path;if(t.query!==undefined)r.query=t.query;else r.query=e.query}else{if(t.path.charAt(0)==="/")r.path=ie(t.path);else{if((e.userinfo!==undefined||e.host!==undefined||e.port!==undefined)&&!e.path)r.path="/"+t.path;else if(!e.path)r.path=t.path;else r.path=e.path.slice(0,e.path.lastIndexOf("/")+1)+t.path;r.path=ie(r.path)}r.query=t.query}r.userinfo=e.userinfo;r.host=e.host;r.port=e.port}r.scheme=e.scheme}r.fragment=t.fragment;return r}function re(e,t,i){var n=r({scheme:"null"},i);return s(ne(o(e,n),o(t,n),n,true),n)}function oe(e,t){if(typeof e==="string")e=s(o(e,t),t);else if(n(e)==="object")e=o(s(e,t),t);return e}function se(e,t,i){if(typeof e==="string")e=s(o(e,i),i);else if(n(e)==="object")e=s(e,i);if(typeof t==="string")t=s(o(t,i),i);else if(n(t)==="object")t=s(t,i);return e===t}function ae(e,t){return e&&e.toString().replace(!t||!t.iri?a.ESCAPE:l.ESCAPE,p)}function le(e,t){return e&&e.toString().replace(!t||!t.iri?a.PCT_ENCODED:l.PCT_ENCODED,$)}var ce={scheme:"http",domainHost:true,parse:function e(t,i){if(!t.host)t.error=t.error||"HTTP URIs must have a host.";return t},serialize:function e(t,i){var n=String(t.scheme).toLowerCase()==="https";if(t.port===(n?443:80)||t.port==="")t.port=undefined;if(!t.path)t.path="/";return t}},ue={scheme:"https",domainHost:ce.domainHost,parse:ce.parse,serialize:ce.serialize};function ge(e){return typeof e.secure==="boolean"?e.secure:String(e.scheme).toLowerCase()==="wss"}var pe={scheme:"ws",domainHost:true,parse:function e(t,i){var n=t;n.secure=ge(n);n.resourceName=(n.path||"/")+(n.query?"?"+n.query:"");n.path=undefined;n.query=undefined;return n},serialize:function e(t,i){if(t.port===(ge(t)?443:80)||t.port==="")t.port=undefined;if(typeof t.secure==="boolean"){t.scheme=t.secure?"wss":"ws";t.secure=undefined}if(t.resourceName){var n=t.resourceName.split("?"),r=y(n,2),o=r[0],s=r[1];t.path=o&&o!=="/"?o:undefined;t.query=s;t.resourceName=undefined}t.fragment=undefined;return t}},me={scheme:"wss",domainHost:pe.domainHost,parse:pe.parse,serialize:pe.serialize},fe={},Ce,Ie="[A-Za-z0-9\\-\\.\\_\\~"+(true?"\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF":"")+"]",t="[0-9A-Fa-f]",ve=de(de("%[EFef]"+t+"%"+t+t+"%"+t+t)+"|"+de("%[89A-Fa-f]"+t+"%"+t+t)+"|"+de("%"+t+t)),Ae="[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]",be,ye=he("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),we="[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]",Se=new RegExp(Ie,"g"),xe=new RegExp(ve,"g"),ke=new RegExp(he("[^]",Ae,"[\\.]",'[\\"]',ye),"g"),Ee=new RegExp(he("[^]",Ie,we),"g"),Re=Ee;function Te(e){var t=$(e);return!t.match(Se)?e:t}var _e={scheme:"mailto",parse:function h(d,e){var t=d;var i=t.to=t.path?t.path.split(","):[];t.path=undefined;if(t.query){var n=false;var r={};var u=t.query.split("&");for(var o=0,g=u.length;o<g;++o){var s=u[o].split("=");switch(s[0]){case"to":var p=s[1].split(",");for(var a=0,m=p.length;a<m;++a)i.push(p[a]);break;case"subject":t.subject=le(s[1],e);break;case"body":t.body=le(s[1],e);break;default:n=true;r[le(s[0],e)]=le(s[1],e);break}}if(n)t.headers=r}t.query=undefined;for(var l=0,f=i.length;l<f;++l){var c=i[l].split("@");c[0]=le(c[0]);if(!e.unicodeSupport)try{c[1]=_.toASCII(le(c[1],e).toLowerCase())}catch(e){t.error=t.error||"Email address's domain name can not be converted to ASCII via punycode: "+e}else c[1]=le(c[1],e).toLowerCase();i[l]=c.join("@")}return t},serialize:function h(e,t){var i=e;var n=f(e.to);if(n){for(var r=0,d=n.length;r<d;++r){var o=String(n[r]);var u=o.lastIndexOf("@");var g=o.slice(0,u).replace(xe,Te).replace(xe,m).replace(ke,p);var s=o.slice(u+1);try{s=!t.iri?_.toASCII(le(s,t).toLowerCase()):_.toUnicode(s)}catch(e){i.error=i.error||"Email address's domain name can not be converted to "+(!t.iri?"ASCII":"Unicode")+" via punycode: "+e}n[r]=g+"@"+s}i.path=n.join(",")}var a=e.headers=e.headers||{};if(e.subject)a["subject"]=e.subject;if(e.body)a["body"]=e.body;var l=[];for(var c in a)if(a[c]!==fe[c])l.push(c.replace(xe,Te).replace(xe,m).replace(Ee,p)+"="+a[c].replace(xe,Te).replace(xe,m).replace(Re,p));if(l.length)i.query=l.join("&");return i}},$e=/^([^\:]+)\:(.*)/,Le={scheme:"urn",parse:function c(e,t){var i=e.path&&e.path.match($e);var n=e;if(i){var r=t.scheme||n.scheme||"urn";var o=i[1].toLowerCase();var s=i[2];var a=r+":"+(t.nid||o);var l=h[a];n.nid=o;n.nss=s;n.path=undefined;if(l)n=l.parse(n,t)}else n.error=n.error||"URN can not be parsed.";return n},serialize:function e(t,i){var n=i.scheme||t.scheme||"urn";var r=t.nid;var o=n+":"+(i.nid||r);var s=h[o];if(s)t=s.serialize(t,i);var a=t;var l=t.nss;a.path=(r||i.nid)+":"+l;return a}},Be=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,We={scheme:"urn:uuid",parse:function e(t,i){var n=t;n.uuid=n.nss;n.nss=undefined;if(!i.tolerant&&(!n.uuid||!n.uuid.match(Be)))n.error=n.error||"UUID is not valid.";return n},serialize:function e(t,i){var n=t;n.nss=(t.uuid||"").toLowerCase();return n}};h[ce.scheme]=ce,h[ue.scheme]=ue,h[pe.scheme]=pe,h[me.scheme]=me,h[_e.scheme]=_e,h[Le.scheme]=Le,h[We.scheme]=We,e.SCHEMES=h,e.pctEncChar=p,e.pctDecChars=$,e.parse=o,e.removeDotSegments=ie,e.serialize=s,e.resolveComponents=ne,e.resolve=re,e.normalize=oe,e.equal=se,e.escapeComponent=ae,e.unescapeComponent=le,Object.defineProperty(e,"__esModule",{value:true})}(t)},4049:function(e){e.exports=function(){"use strict";var s=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},e=function(){function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||false;n.configurable=true;if("value"in n)n.writable=true;Object.defineProperty(e,n.key,n)}}return function(e,t,i){if(t)n(e.prototype,t);if(i)n(e,i);return e}}(),m=function(){function i(e,t){var i=[];var n=true;var r=false;var o=undefined;try{for(var s=e[Symbol.iterator](),a;!(n=(a=s.next()).done);n=true){i.push(a.value);if(t&&i.length===t)break}}catch(e){r=true;o=e}finally{try{if(!n&&s["return"])s["return"]()}finally{if(r)throw o}}return i}return function(e,t){if(Array.isArray(e))return e;else if(Symbol.iterator in Object(e))return i(e,t);else throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),r=(String.prototype.startsWith=String.prototype.startsWith||function(e){return this.indexOf(e)===0},String.prototype.padStart=String.prototype.padStart||function(e,t){var i=this;while(i.length<e)i=t+i;return i},{cb:"0f8ff",tqw:"aebd7",q:"-ffff",qmrn:"7fffd4",zr:"0ffff",bg:"5f5dc",bsq:"e4c4",bck:"---",nch:"ebcd",b:"--ff",bvt:"8a2be2",brwn:"a52a2a",brw:"deb887",ctb:"5f9ea0",hrt:"7fff-",chcT:"d2691e",cr:"7f50",rnw:"6495ed",crns:"8dc",crms:"dc143c",cn:"-ffff",Db:"--8b",Dcn:"-8b8b",Dgnr:"b8860b",Dgr:"a9a9a9",Dgrn:"-64-",Dkhk:"bdb76b",Dmgn:"8b-8b",Dvgr:"556b2f",Drng:"8c-",Drch:"9932cc",Dr:"8b--",Dsmn:"e9967a",Dsgr:"8fbc8f",DsTb:"483d8b",DsTg:"2f4f4f",Dtrq:"-ced1",Dvt:"94-d3",ppnk:"1493",pskb:"-bfff",mgr:"696969",grb:"1e90ff",rbrc:"b22222",rwht:"af0",stg:"228b22",chs:"-ff",gnsb:"dcdcdc",st:"8f8ff",g:"d7-",gnr:"daa520",gr:"808080",grn:"-8-0",grnw:"adff2f",hnw:"0fff0",htpn:"69b4",nnr:"cd5c5c",ng:"4b-82",vr:"0",khk:"0e68c",vnr:"e6e6fa",nrb:"0f5",wngr:"7cfc-",mnch:"acd",Lb:"add8e6",Lcr:"08080",Lcn:"e0ffff",Lgnr:"afad2",Lgr:"d3d3d3",Lgrn:"90ee90",Lpnk:"b6c1",Lsmn:"a07a",Lsgr:"20b2aa",Lskb:"87cefa",LsTg:"778899",Lstb:"b0c4de",Lw:"e0",m:"-ff-",mgrn:"32cd32",nn:"af0e6",mgnt:"-ff",mrn:"8--0",mqm:"66cdaa",mmb:"--cd",mmrc:"ba55d3",mmpr:"9370db",msg:"3cb371",mmsT:"7b68ee","":"-fa9a",mtr:"48d1cc",mmvt:"c71585",mnLb:"191970",ntc:"5fffa",mstr:"e4e1",mccs:"e4b5",vjw:"dead",nv:"--80",c:"df5e6",v:"808-0",vrb:"6b8e23",rng:"a5-",rngr:"45-",rch:"da70d6",pgnr:"eee8aa",pgrn:"98fb98",ptrq:"afeeee",pvtr:"db7093",ppwh:"efd5",pchp:"dab9",pr:"cd853f",pnk:"c0cb",pm:"dda0dd",pwrb:"b0e0e6",prp:"8-080",cc:"663399",r:"--",sbr:"bc8f8f",rb:"4169e1",sbrw:"8b4513",smn:"a8072",nbr:"4a460",sgrn:"2e8b57",ssh:"5ee",snn:"a0522d",svr:"c0c0c0",skb:"87ceeb",sTb:"6a5acd",sTgr:"708090",snw:"afa",n:"-ff7f",stb:"4682b4",tn:"d2b48c",t:"-8080",thst:"d8bfd8",tmT:"6347",trqs:"40e0d0",vt:"ee82ee",whT:"5deb3",wht:"",hts:"5f5f5",w:"-",wgrn:"9acd32"});function a(e){var t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1;var i=t>0?e.toFixed(t).replace(/0+$/,"").replace(/\.$/,""):e.toString();return i||"0"}var o=function(){function p(e,t,i,n){s(this,p);var g=this;function r(e){if(e.startsWith("hsl")){var t=e.match(/([\-\d\.e]+)/g).map(Number),i=m(t,4),n=i[0],r=i[1],o=i[2],s=i[3];if(s===undefined)s=1;n/=360;r/=100;o/=100;g.hsla=[n,r,o,s]}else if(e.startsWith("rgb")){var a=e.match(/([\-\d\.e]+)/g).map(Number),l=m(a,4),h=l[0],d=l[1],u=l[2],c=l[3];if(c===undefined)c=1;g.rgba=[h,d,u,c]}else if(e.startsWith("#"))g.rgba=p.hexToRgb(e);else g.rgba=p.nameToRgb(e)||p.hexToRgb(e)}if(e===undefined);else if(Array.isArray(e))this.rgba=e;else if(i===undefined){var o=e&&""+e;if(o)r(o.toLowerCase())}else this.rgba=[e,t,i,n===undefined?1:n]}e(p,[{key:"printRGB",value:function e(t){var i=t?this.rgba:this.rgba.slice(0,3),n=i.map(function(e,t){return a(e,t===3?3:0)});return t?"rgba("+n+")":"rgb("+n+")"}},{key:"printHSL",value:function e(t){var i=[360,100,100,1],n=["","%","%",""];var r=t?this.hsla:this.hsla.slice(0,3),o=r.map(function(e,t){return a(e*i[t],t===3?3:1)+n[t]});return t?"hsla("+o+")":"hsl("+o+")"}},{key:"printHex",value:function e(t){var i=this.hex;return t?i:i.substring(0,7)}},{key:"rgba",get:function e(){if(this._rgba)return this._rgba;if(!this._hsla)throw new Error("No color is set");return this._rgba=p.hslToRgb(this._hsla)},set:function e(t){if(t.length===3)t[3]=1;this._rgba=t;this._hsla=null}},{key:"rgbString",get:function e(){return this.printRGB()}},{key:"rgbaString",get:function e(){return this.printRGB(true)}},{key:"hsla",get:function e(){if(this._hsla)return this._hsla;if(!this._rgba)throw new Error("No color is set");return this._hsla=p.rgbToHsl(this._rgba)},set:function e(t){if(t.length===3)t[3]=1;this._hsla=t;this._rgba=null}},{key:"hslString",get:function e(){return this.printHSL()}},{key:"hslaString",get:function e(){return this.printHSL(true)}},{key:"hex",get:function e(){var t=this.rgba,i=t.map(function(e,t){return t<3?e.toString(16):Math.round(e*255).toString(16)});return"#"+i.map(function(e){return e.padStart(2,"0")}).join("")},set:function e(t){this.rgba=p.hexToRgb(t)}}],[{key:"hexToRgb",value:function e(t){var i=(t.startsWith("#")?t.slice(1):t).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!i.match(/^([0-9a-fA-F]{8})$/))throw new Error("Unknown hex color; "+t);var n=i.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(e){return parseInt(e,16)});n[3]=n[3]/255;return n}},{key:"nameToRgb",value:function e(t){var i=t.toLowerCase().replace("at","T").replace(/[aeiouyldf]/g,"").replace("ght","L").replace("rk","D").slice(-5,4),n=r[i];return n===undefined?n:p.hexToRgb(n.replace(/\-/g,"00").padStart(6,"f"))}},{key:"rgbToHsl",value:function h(d){var e=m(d,4),t=e[0],i=e[1],n=e[2],u=e[3];t/=255;i/=255;n/=255;var r=Math.max(t,i,n),o=Math.min(t,i,n);var s=void 0,a=void 0,l=(r+o)/2;if(r===o)s=a=0;else{var c=r-o;a=l>.5?c/(2-r-o):c/(r+o);switch(r){case t:s=(i-n)/c+(i<n?6:0);break;case i:s=(n-t)/c+2;break;case n:s=(t-i)/c+4;break}s/=6}return[s,a,l,u]}},{key:"hslToRgb",value:function h(d){var e=m(d,4),t=e[0],i=e[1],n=e[2],u=e[3];var r=void 0,o=void 0,s=void 0;if(i===0)r=o=s=n;else{var a=function e(t,i,n){if(n<0)n+=1;if(n>1)n-=1;if(n<1/6)return t+(i-t)*6*n;if(n<1/2)return i;if(n<2/3)return t+(i-t)*(2/3-n)*6;return t};var l=n<.5?n*(1+i):n+i-n*i,c=2*n-l;r=a(c,l,t+1/3);o=a(c,l,t);s=a(c,l,t-1/3)}var g=[r*255,o*255,s*255].map(Math.round);g[3]=u;return g}}]);return p}(),i=function(){function o(){s(this,o);this._events=[]}e(o,[{key:"add",value:function e(t,i,n){t.addEventListener(i,n,false);this._events.push({target:t,type:i,handler:n})}},{key:"remove",value:function e(i,n,r){this._events=this._events.filter(function(e){var t=true;if(i&&i!==e.target)t=false;if(n&&n!==e.type)t=false;if(r&&r!==e.handler)t=false;if(t)o._doRemove(e.target,e.type,e.handler);return!t})}},{key:"destroy",value:function e(){this._events.forEach(function(e){return o._doRemove(e.target,e.type,e.handler)});this._events=[]}}],[{key:"_doRemove",value:function e(t,i,n){t.removeEventListener(i,n,false)}}]);return o}();function u(e){var t=document.createElement("div");t.innerHTML=e;return t.firstElementChild}function l(e,h,d){var u=false;function g(e,t,i){return Math.max(t,Math.min(e,i))}function n(e,t,i){if(i)u=true;if(!u)return;e.preventDefault();var n=h.getBoundingClientRect(),r=n.width,o=n.height,s=t.clientX,a=t.clientY;var l=g(s-n.left,0,r),c=g(a-n.top,0,o);d(l/r,c/o)}function t(e,t){var i=e.buttons===undefined?e.which:e.buttons;if(i===1)n(e,e,t);else u=false}function i(e,t){if(e.touches.length===1)n(e,e.touches[0],t);else u=false}e.add(h,"mousedown",function(e){t(e,true)});e.add(h,"touchstart",function(e){i(e,true)});e.add(window,"mousemove",t);e.add(h,"touchmove",i);e.add(window,"mouseup",function(e){u=false});e.add(h,"touchend",function(e){u=false});e.add(h,"touchcancel",function(e){u=false})}var y="linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0 / 2em 2em,\n                   linear-gradient(45deg, lightgrey 25%,       white 25%,       white 75%, lightgrey 75%) 1em 1em / 2em 2em",w=360,g="keydown",c="mousedown",h="focusin";function b(e,t){return(t||document).querySelector(e)}function p(e){e.preventDefault();e.stopPropagation()}function d(e,t,i,n,r){e.add(t,g,function(e){if(i.indexOf(e.key)>=0){if(r)p(e);n(e)}})}var n=function(){function t(e){s(this,t);this.settings={popup:"right",layout:"default",alpha:true,editor:true,editorFormat:"hex",cancelButton:false,defaultColor:"#0cf"};this._events=new i;this.onChange=null;this.onDone=null;this.onOpen=null;this.onClose=null;this.setOptions(e)}e(t,[{key:"setOptions",value:function e(t){var i=this;if(!t)return;var n=this.settings;function r(e,t,i){for(var n in e){if(i&&i.indexOf(n)>=0)continue;t[n]=e[n]}}if(t instanceof HTMLElement)n.parent=t;else{if(n.parent&&t.parent&&n.parent!==t.parent){this._events.remove(n.parent);this._popupInited=false}r(t,n);if(t.onChange)this.onChange=t.onChange;if(t.onDone)this.onDone=t.onDone;if(t.onOpen)this.onOpen=t.onOpen;if(t.onClose)this.onClose=t.onClose;var o=t.color||t.colour;if(o)this._setColor(o)}var s=n.parent;if(s&&n.popup&&!this._popupInited){var a=function e(t){return i.openHandler(t)};this._events.add(s,"click",a);d(this._events,s,[" ","Spacebar","Enter"],a);this._popupInited=true}else if(t.parent&&!n.popup)this.show()}},{key:"openHandler",value:function e(t){if(this.show()){t&&t.preventDefault();this.settings.parent.style.pointerEvents="none";var i=t&&t.type===g?this._domEdit:this.domElement;setTimeout(function(){return i.focus()},100);if(this.onOpen)this.onOpen(this.colour)}}},{key:"closeHandler",value:function e(t){var i=t&&t.type;var n=false;if(!t)n=true;else if(i===c||i===h){var r=(this.__containedEvent||0)+100;if(t.timeStamp>r)n=true}else{p(t);n=true}if(n&&this.hide()){this.settings.parent.style.pointerEvents="";if(i!==c)this.settings.parent.focus();if(this.onClose)this.onClose(this.colour)}}},{key:"movePopup",value:function e(t,i){this.closeHandler();this.setOptions(t);if(i)this.openHandler()}},{key:"setColor",value:function e(t,i){this._setColor(t,{silent:i})}},{key:"_setColor",value:function e(t,i){if(typeof t==="string")t=t.trim();if(!t)return;i=i||{};var n=void 0;try{n=new o(t)}catch(e){if(i.failSilently)return;throw e}if(!this.settings.alpha){var r=n.hsla;r[3]=1;n.hsla=r}this.colour=this.color=n;this._setHSLA(null,null,null,null,i)}},{key:"setColour",value:function e(t,i){this.setColor(t,i)}},{key:"show",value:function e(){var t=this.settings.parent;if(!t)return false;if(this.domElement){var i=this._toggleDOM(true);this._setPosition();return i}var n=this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>';var r=u(n);this.domElement=r;this._domH=b(".picker_hue",r);this._domSL=b(".picker_sl",r);this._domA=b(".picker_alpha",r);this._domEdit=b(".picker_editor input",r);this._domSample=b(".picker_sample",r);this._domOkay=b(".picker_done button",r);this._domCancel=b(".picker_cancel button",r);r.classList.add("layout_"+this.settings.layout);if(!this.settings.alpha)r.classList.add("no_alpha");if(!this.settings.editor)r.classList.add("no_editor");if(!this.settings.cancelButton)r.classList.add("no_cancel");this._ifPopup(function(){return r.classList.add("popup")});this._setPosition();if(this.colour)this._updateUI();else this._setColor(this.settings.defaultColor);this._bindEvents();return true}},{key:"hide",value:function e(){return this._toggleDOM(false)}},{key:"destroy",value:function e(){this._events.destroy();if(this.domElement)this.settings.parent.removeChild(this.domElement)}},{key:"_bindEvents",value:function e(){var i=this;var n=this,r=this.domElement,o=this._events;function s(e,t,i){o.add(e,t,i)}s(r,"click",function(e){return e.preventDefault()});l(o,this._domH,function(e,t){return n._setHSLA(e)});l(o,this._domSL,function(e,t){return n._setHSLA(null,e,1-t)});if(this.settings.alpha)l(o,this._domA,function(e,t){return n._setHSLA(null,null,null,1-t)});var t=this._domEdit;{s(t,"input",function(e){n._setColor(this.value,{fromEditor:true,failSilently:true})});s(t,"focus",function(e){var t=this;if(t.selectionStart===t.selectionEnd)t.select()})}this._ifPopup(function(){var e=function e(t){return i.closeHandler(t)};s(window,c,e);s(window,h,e);d(o,r,["Esc","Escape"],e);var t=function e(t){i.__containedEvent=t.timeStamp};s(r,c,t);s(r,h,t);s(i._domCancel,"click",e)});var a=function e(t){i._ifPopup(function(){return i.closeHandler(t)});if(i.onDone)i.onDone(i.colour)};s(this._domOkay,"click",a);d(o,r,["Enter"],a)}},{key:"_setPosition",value:function e(){var i=this.settings.parent,n=this.domElement;if(i!==n.parentNode)i.appendChild(n);this._ifPopup(function(e){if(getComputedStyle(i).position==="static")i.style.position="relative";var t=e===true?"popup_right":"popup_"+e;["popup_top","popup_bottom","popup_left","popup_right"].forEach(function(e){if(e===t)n.classList.add(e);else n.classList.remove(e)});n.classList.add(t)})}},{key:"_setHSLA",value:function e(t,i,n,r,o){o=o||{};var s=this.colour,a=s.hsla;[t,i,n,r].forEach(function(e,t){if(e||e===0)a[t]=e});s.hsla=a;this._updateUI(o);if(this.onChange&&!o.silent)this.onChange(s)}},{key:"_updateUI",value:function h(e){if(!this.domElement)return;e=e||{};var t=this.colour,i=t.hsla,d="hsl("+i[0]*w+", 100%, 50%)",n=t.hslString,u=t.hslaString;var r=this._domH,o=this._domSL,s=this._domA,g=b(".picker_selector",r),a=b(".picker_selector",o),p=b(".picker_selector",s);function m(e,t,i){t.style.left=i*100+"%"}function f(e,t,i){t.style.top=i*100+"%"}m(r,g,i[0]);this._domSL.style.backgroundColor=this._domH.style.color=d;m(o,a,i[1]);f(o,a,1-i[2]);o.style.color=n;f(s,p,1-i[3]);var C=n,I=C.replace("hsl","hsla").replace(")",", 0)"),v="linear-gradient("+[C,I]+")";this._domA.style.background=v+", "+y;if(!e.fromEditor){var A=this.settings.editorFormat,l=this.settings.alpha;var c=void 0;switch(A){case"rgb":c=t.printRGB(l);break;case"hsl":c=t.printHSL(l);break;default:c=t.printHex(l)}this._domEdit.value=c}this._domSample.style.color=u}},{key:"_ifPopup",value:function e(t,i){if(this.settings.parent&&this.settings.popup)t&&t(this.settings.popup);else i&&i()}},{key:"_toggleDOM",value:function e(t){var i=this.domElement;if(!i)return false;var n=t?"":"none",r=i.style.display!==n;if(r)i.style.display=n;return r}}]);return t}(),t=document.createElement("style");return t.textContent='.picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:flex;flex-flow:row wrap;justify-content:space-between;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:"";display:block;width:100%;height:0;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{flex:1 1 auto}.layout_default .picker_sl::before{content:"";display:block;padding-bottom:100%}.layout_default .picker_editor{order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{order:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px #1e90ff}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:#f5f5f5;background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:#fff}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid #fff;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:linear-gradient(180deg, white, rgba(255, 255, 255, 0) 50%),linear-gradient(0deg, black, rgba(0, 0, 0, 0) 50%),linear-gradient(90deg, #808080, rgba(128, 128, 128, 0))}.picker_alpha,.picker_sample{position:relative;background:linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0/2em 2em,linear-gradient(45deg, lightgrey 25%, white 25%, white 75%, lightgrey 75%) 1em 1em/2em 2em;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:"";position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:"";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}',document.documentElement.firstElementChild.appendChild(t),n.StyleElement=t,n}()},402:function(e,t){"use strict";function i(e,t){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.message=e+" (char "+t+")",this.char=t,this.stack=(new Error).stack}Object.defineProperty(t,"__esModule",{value:!0}),((t.default=i).prototype=new Error).constructor=Error},3860:function(e,t,i){e.exports=i(7490).default},7490:function(e,t,i){"use strict";t.default=function(e){s="",a=0,l=(S=e).charAt(0),c="",h=I,u();var t=h;if(T(),E(),""===c)return s;if(t===h&&k()){for(var i="";t===h&&k();)s=(0,o.insertBeforeLastWhitespace)(s,","),i+=s,s="",T(),E();return"[\n".concat(i).concat(s,"\n]")}throw new r.default("Unexpected characters",a-c.length)};var r=(t=i(402))&&t.__esModule?t:{default:t},o=i(9422);var n=0,g=1,p=2,m=3,f=4,C=5,I=6,v={"":!0,"{":!0,"}":!0,"[":!0,"]":!0,":":!0,",":!0,"(":!0,")":!0,";":!0,"+":!0},A={'"':'"',"\\":"\\","/":"/",b:"\b",f:"\f",n:"\n",r:"\r",t:"\t"},b={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"},y={null:"null",true:"true",false:"false"},w={None:"null",True:"true",False:"false"},S="",s="",a=0,l="",c="",h=I;function d(){a++,l=S.charAt(a)}function x(){d(),"\\"===l&&d()}function k(){return h===n&&("["===c||"{"===c)||h===p||h===g||h===m}function u(){if(s+=c,h=I,c="",v[l])h=n,c=l,d();else if((0,o.isDigit)(l)||"-"===l){if(h=g,"-"===l){if(c+=l,d(),!(0,o.isDigit)(l))throw new r.default("Invalid number, digit expected",a)}else"0"===l&&(c+=l,d());for(;(0,o.isDigit)(l);)c+=l,d();if("."===l){if(c+=l,d(),!(0,o.isDigit)(l))throw new r.default("Invalid number, digit expected",a);for(;(0,o.isDigit)(l);)c+=l,d()}if("e"===l||"E"===l){if(c+=l,d(),"+"!==l&&"-"!==l||(c+=l,d()),!(0,o.isDigit)(l))throw new r.default("Invalid number, digit expected",a);for(;(0,o.isDigit)(l);)c+=l,d()}}else"\\"===l&&'"'===S.charAt(a+1)?(d(),R(x)):R(d);h===f&&(c=(0,o.normalizeWhitespace)(c),u()),h===C&&(h=I,c="",u())}function E(){","===c&&(c="",h=I,u())}function R(e){if((0,o.isQuote)(l)){var t=(0,o.normalizeQuote)(l),i=(0,o.isSingleQuote)(l)?o.isSingleQuote:o.isDoubleQuote;for(c+='"',h=p,e();""!==l&&!i(l);)if("\\"===l)if(e(),void 0!==A[l])c+="\\"+l,e();else if("u"===l){c+="\\u",e();for(var n=0;n<4;n++){if(!(0,o.isHex)(l))throw new r.default("Invalid unicode character",a-c.length);c+=l,e()}}else{if("'"!==l)throw new r.default('Invalid escape character "\\'+l+'"',a);c+="'",e()}else b[l]?c+=b[l]:c+='"'===l?'\\"':l,e();if((0,o.normalizeQuote)(l)!==t)throw new r.default("End of string expected",a-c.length);return c+='"',void e()}if((0,o.isAlpha)(l))for(h=m;(0,o.isAlpha)(l)||(0,o.isDigit)(l)||"$"===l;)c+=l,d();else if((0,o.isWhitespace)(l)||(0,o.isSpecialWhitespace)(l))for(h=f;(0,o.isWhitespace)(l)||(0,o.isSpecialWhitespace)(l);)c+=l,d();else if("/"!==l||"*"!==S[a+1])if("/"!==l||"/"!==S[a+1]){h=I;for(;""!==l;)c+=l,d();throw new r.default('Syntax error in part "'+c+'"',a-c.length)}else for(h=C;""!==l&&"\n"!==l;)c+=l,d();else{for(h=C;""!==l&&("*"!==l||"*"===l&&"/"!==S[a+1]);)c+=l,d();"*"===l&&"/"===S[a+1]&&(c+=l,d(),c+=l,d())}}function T(){if(h!==n||"{"!==c)if(h===n&&"["===c)if(u(),h!==n||"]"!==c){for(;;)if(T(),h===n&&","===c){if(u(),h===n&&"]"===c){s=(0,o.stripLastOccurrence)(s,",");break}if(""===c){s=(0,o.stripLastOccurrence)(s,",");break}}else{if(!k())break;s=(0,o.insertBeforeLastWhitespace)(s,",")}h===n&&"]"===c?u():s=(0,o.insertBeforeLastWhitespace)(s,"]")}else u();else if(h===p)for(u();h===n&&"+"===c;){var e;c="",u(),h===p&&(e=s.lastIndexOf('"'),s=s.substring(0,e)+c.substring(1),c="",u())}else if(h===g)u();else{if(h!==m)throw""===c?new r.default("Unexpected end of json string",a-c.length):new r.default("Value expected",a-c.length);if(y[c])u();else{if(w[c])return void(c=w[c],u());var t=c,i=s.length;if(c="",u(),h===n&&"("===c)return void(c="",u(),T(),h===n&&")"===c&&(c="",u(),h===n&&";"===c&&(c="",u())));for(s=(0,o.insertAtIndex)(s,'"'.concat(t),i);h===m||h===g;)u();s+='"'}}else if(u(),h!==n||"}"!==c){for(;;){if(h!==m&&h!==g||(h=p,c='"'.concat(c,'"')),h!==p)throw new r.default("Object key expected",a-c.length);if(u(),h===n&&":"===c)u();else{if(!k())throw new r.default("Colon expected",a-c.length);s=(0,o.insertBeforeLastWhitespace)(s,":")}if(T(),h===n&&","===c){if(u(),h===n&&"}"===c){s=(0,o.stripLastOccurrence)(s,",");break}if(""===c){s=(0,o.stripLastOccurrence)(s,",");break}}else{if(h!==p&&h!==g&&h!==m)break;s=(0,o.insertBeforeLastWhitespace)(s,",")}}h===n&&"}"===c?u():s=(0,o.insertBeforeLastWhitespace)(s,"}")}else u()}},9422:function(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.isAlpha=function(e){return r.test(e)},t.isHex=function(e){return o.test(e)},t.isDigit=function(e){return s.test(e)},t.isWhitespace=a,t.isSpecialWhitespace=l,t.normalizeWhitespace=function(e){for(var t="",i=0;i<e.length;i++){var n=e[i];t+=l(n)?" ":n}return t},t.isQuote=function(e){return!0===i[e]||!0===n[e]},t.isSingleQuote=function(e){return!0===i[e]},t.isDoubleQuote=function(e){return!0===n[e]},t.normalizeQuote=function(e){return!0!==i[e]?!0!==n[e]?e:'"':"'"},t.stripLastOccurrence=function(e,t){t=e.lastIndexOf(t);return-1!==t?e.substring(0,t)+e.substring(t+1):e},t.insertBeforeLastWhitespace=function(e,t){var i=e.length;if(!a(e[i-1]))return e+t;for(;a(e[i-1]);)i--;return e.substring(0,i)+t+e.substring(i)},t.insertAtIndex=function(e,t,i){return e.substring(0,i)+t+e.substring(i)};var i={"'":!0,"‘":!0,"’":!0,"`":!0,"´":!0},n={'"':!0,"“":!0,"”":!0};var r=/^[a-zA-Z_]$/;var o=/^[0-9a-fA-F]$/;var s=/^[0-9]$/;function a(e){return" "===e||"\t"===e||"\n"===e||"\r"===e}function l(e){return" "===e||" "<=e&&e<=" "||" "===e||" "===e||"　"===e}},894:function(e){"use strict";e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#","description":"Meta-schema for $data reference (JSON Schema extension proposal)","type":"object","required":["$data"],"properties":{"$data":{"type":"string","anyOf":[{"format":"relative-json-pointer"},{"format":"json-pointer"}]}},"additionalProperties":false}')},7171:function(e){"use strict";e.exports=JSON.parse('{"id":"http://json-schema.org/draft-04/schema#","$schema":"http://json-schema.org/draft-04/schema#","description":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"positiveInteger":{"type":"integer","minimum":0},"positiveIntegerDefault0":{"allOf":[{"$ref":"#/definitions/positiveInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"minItems":1,"uniqueItems":true}},"type":"object","properties":{"id":{"type":"string"},"$schema":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"multipleOf":{"type":"number","minimum":0,"exclusiveMinimum":true},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"boolean","default":false},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"boolean","default":false},"maxLength":{"$ref":"#/definitions/positiveInteger"},"minLength":{"$ref":"#/definitions/positiveIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/positiveInteger"},"minItems":{"$ref":"#/definitions/positiveIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"maxProperties":{"$ref":"#/definitions/positiveInteger"},"minProperties":{"$ref":"#/definitions/positiveIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"dependencies":{"exclusiveMaximum":["maximum"],"exclusiveMinimum":["minimum"]},"default":{}}')},6273:function(e){"use strict";e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-06/schema#","$id":"http://json-schema.org/draft-06/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"examples":{"type":"array","items":{}},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":{},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":{}}')},6680:function(e){"use strict";e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"http://json-schema.org/draft-07/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"$comment":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":true,"readOnly":{"type":"boolean","default":false},"examples":{"type":"array","items":true},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":true},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"propertyNames":{"format":"regex"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":true,"enum":{"type":"array","items":true,"minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"contentMediaType":{"type":"string"},"contentEncoding":{"type":"string"},"if":{"$ref":"#"},"then":{"$ref":"#"},"else":{"$ref":"#"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":true}')}},r={},n.amdD=function(){throw new Error("define cannot be used indirect")},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,{a:t}),t},n.d=function(e,t){for(var i in t)n.o(t,i)&&!n.o(e,i)&&Object.defineProperty(e,i,{enumerable:!0,get:t[i]})},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.nmd=function(e){return e.paths=[],e.children||(e.children=[]),e},n(3161);function n(e){var t=r[e];if(void 0!==t)return t.exports;t=r[e]={id:e,loaded:!1,exports:{}};return i[e].call(t.exports,t,t.exports,n),t.loaded=!0,t.exports}var i,r});
//# sourceMappingURL=jsoneditor.map