"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.undefinedIfEmpty = exports.lazy = void 0;
const constructs_1 = require("constructs");
function lazy(producer) {
    return constructs_1.Lazy.anyValue({ produce: () => producer() });
}
exports.lazy = lazy;
function undefinedIfEmpty(obj) {
    if (typeof (obj) === 'string' && obj === '') {
        return undefined;
    }
    if (Array.isArray(obj) && obj.length === 0) {
        return undefined;
    }
    if (typeof (obj) === 'object' && Object.keys(obj).length === 0) {
        return undefined;
    }
    return obj;
}
exports.undefinedIfEmpty = undefinedIfEmpty;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsMkNBQWtDO0FBRWxDLFNBQWdCLElBQUksQ0FBSSxRQUFpQjtJQUN2QyxPQUFPLGlCQUFJLENBQUMsUUFBUSxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLFFBQVEsRUFBRSxFQUFFLENBQWlCLENBQUM7QUFDdEUsQ0FBQztBQUZELG9CQUVDO0FBR0QsU0FBZ0IsZ0JBQWdCLENBQUksR0FBTTtJQUN4QyxJQUFJLE9BQU0sQ0FBQyxHQUFHLENBQUMsS0FBSyxRQUFRLElBQUksR0FBRyxLQUFLLEVBQUUsRUFBRTtRQUFFLE9BQU8sU0FBUyxDQUFDO0tBQUU7SUFDakUsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUNqRSxJQUFJLE9BQU0sQ0FBQyxHQUFHLENBQUMsS0FBSyxRQUFRLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUNwRixPQUFPLEdBQUcsQ0FBQztBQUNiLENBQUM7QUFMRCw0Q0FLQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IExhenkgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGxhenk8VD4ocHJvZHVjZXI6ICgpID0+IFQpOiBUIHtcbiAgcmV0dXJuIExhenkuYW55VmFsdWUoeyBwcm9kdWNlOiAoKSA9PiBwcm9kdWNlcigpIH0pIGFzIHVua25vd24gYXMgVDtcbn1cblxuXG5leHBvcnQgZnVuY3Rpb24gdW5kZWZpbmVkSWZFbXB0eTxUPihvYmo6IFQpOiBUIHwgdW5kZWZpbmVkIHtcbiAgaWYgKHR5cGVvZihvYmopID09PSAnc3RyaW5nJyAmJiBvYmogPT09ICcnKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgaWYgKEFycmF5LmlzQXJyYXkob2JqKSAmJiBvYmoubGVuZ3RoID09PSAwKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgaWYgKHR5cGVvZihvYmopID09PSAnb2JqZWN0JyAmJiBPYmplY3Qua2V5cyhvYmopLmxlbmd0aCA9PT0gMCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIHJldHVybiBvYmo7XG59Il19