import { Resource, ResourceProps, IResource } from './base';
import { Construct } from 'constructs';
import { ApiObject } from 'cdk8s';
import { ISecret } from './secret';
/**
 * Properties for initialization of `ServiceAccount`.
 */
export interface ServiceAccountProps extends ResourceProps {
}
export interface IServiceAccount extends IResource {
}
/**
 * Properties for initialization of `ServiceAccount`.
 */
export interface ServiceAccountProps {
    /**
     * List of secrets allowed to be used by pods running using this
     * ServiceAccount.
     *
     * @see https://kubernetes.io/docs/concepts/configuration/secret
     */
    readonly secrets?: ISecret[];
}
/**
 * A service account provides an identity for processes that run in a Pod.
 *
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 *
 * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
 */
export declare class ServiceAccount extends Resource implements IServiceAccount {
    /**
     * Imports a service account from the cluster as a reference.
     * @param name The name of the service account resource.
     */
    static fromServiceAccountName(name: string): IServiceAccount;
    protected readonly apiObject: ApiObject;
    private readonly _secrets;
    constructor(scope: Construct, id: string, props?: ServiceAccountProps);
    /**
     * Allow a secret to be accessed by pods using this service account.
     * @param secret The secret
     */
    addSecret(secret: ISecret): void;
    /**
     * List of secrets allowed to be used by pods running using this service
     * account.
     *
     * Returns a copy. To add a secret, use `addSecret()`.
     */
    get secrets(): ISecret[];
}
