(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["node_modules_monaco-editor_esm_vs_basic-languages_markdown_markdown_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/markdown/markdown.js":
/*!********************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/markdown/markdown.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/markdown/markdown.ts
var conf = {
  comments: {
    blockComment: ["<!--", "-->"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  autoClosingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: "<", close: ">", notIn: ["string"] }
  ],
  surroundingPairs: [
    { open: "(", close: ")" },
    { open: "[", close: "]" },
    { open: "`", close: "`" }
  ],
  folding: {
    markers: {
      start: new RegExp("^\\s*<!--\\s*#?region\\b.*-->"),
      end: new RegExp("^\\s*<!--\\s*#?endregion\\b.*-->")
    }
  }
};
var language = {
  defaultToken: "",
  tokenPostfix: ".md",
  control: /[\\`*_\[\]{}()#+\-\.!]/,
  noncontrol: /[^\\`*_\[\]{}()#+\-\.!]/,
  escapes: /\\(?:@control)/,
  jsescapes: /\\(?:[btnfr\\"']|[0-7][0-7]?|[0-3][0-7]{2})/,
  empty: [
    "area",
    "base",
    "basefont",
    "br",
    "col",
    "frame",
    "hr",
    "img",
    "input",
    "isindex",
    "link",
    "meta",
    "param"
  ],
  tokenizer: {
    root: [
      [/^\s*\|/, "@rematch", "@table_header"],
      [/^(\s{0,3})(#+)((?:[^\\#]|@escapes)+)((?:#+)?)/, ["white", "keyword", "keyword", "keyword"]],
      [/^\s*(=+|\-+)\s*$/, "keyword"],
      [/^\s*((\*[ ]?)+)\s*$/, "meta.separator"],
      [/^\s*>+/, "comment"],
      [/^\s*([\*\-+:]|\d+\.)\s/, "keyword"],
      [/^(\t|[ ]{4})[^ ].*$/, "string"],
      [/^\s*~~~\s*((?:\w|[\/\-#])+)?\s*$/, { token: "string", next: "@codeblock" }],
      [
        /^\s*```\s*((?:\w|[\/\-#])+).*$/,
        { token: "string", next: "@codeblockgh", nextEmbedded: "$1" }
      ],
      [/^\s*```\s*$/, { token: "string", next: "@codeblock" }],
      { include: "@linecontent" }
    ],
    table_header: [
      { include: "@table_common" },
      [/[^\|]+/, "keyword.table.header"]
    ],
    table_body: [{ include: "@table_common" }, { include: "@linecontent" }],
    table_common: [
      [/\s*[\-:]+\s*/, { token: "keyword", switchTo: "table_body" }],
      [/^\s*\|/, "keyword.table.left"],
      [/^\s*[^\|]/, "@rematch", "@pop"],
      [/^\s*$/, "@rematch", "@pop"],
      [
        /\|/,
        {
          cases: {
            "@eos": "keyword.table.right",
            "@default": "keyword.table.middle"
          }
        }
      ]
    ],
    codeblock: [
      [/^\s*~~~\s*$/, { token: "string", next: "@pop" }],
      [/^\s*```\s*$/, { token: "string", next: "@pop" }],
      [/.*$/, "variable.source"]
    ],
    codeblockgh: [
      [/```\s*$/, { token: "string", next: "@pop", nextEmbedded: "@pop" }],
      [/[^`]+/, "variable.source"]
    ],
    linecontent: [
      [/&\w+;/, "string.escape"],
      [/@escapes/, "escape"],
      [/\b__([^\\_]|@escapes|_(?!_))+__\b/, "strong"],
      [/\*\*([^\\*]|@escapes|\*(?!\*))+\*\*/, "strong"],
      [/\b_[^_]+_\b/, "emphasis"],
      [/\*([^\\*]|@escapes)+\*/, "emphasis"],
      [/`([^\\`]|@escapes)+`/, "variable"],
      [/\{+[^}]+\}+/, "string.target"],
      [/(!?\[)((?:[^\]\\]|@escapes)*)(\]\([^\)]+\))/, ["string.link", "", "string.link"]],
      [/(!?\[)((?:[^\]\\]|@escapes)*)(\])/, "string.link"],
      { include: "html" }
    ],
    html: [
      [/<(\w+)\/>/, "tag"],
      [
        /<(\w+)(\-|\w)*/,
        {
          cases: {
            "@empty": { token: "tag", next: "@tag.$1" },
            "@default": { token: "tag", next: "@tag.$1" }
          }
        }
      ],
      [/<\/(\w+)(\-|\w)*\s*>/, { token: "tag" }],
      [/<!--/, "comment", "@comment"]
    ],
    comment: [
      [/[^<\-]+/, "comment.content"],
      [/-->/, "comment", "@pop"],
      [/<!--/, "comment.content.invalid"],
      [/[<\-]/, "comment.content"]
    ],
    tag: [
      [/[ \t\r\n]+/, "white"],
      [
        /(type)(\s*=\s*)(")([^"]+)(")/,
        [
          "attribute.name.html",
          "delimiter.html",
          "string.html",
          { token: "string.html", switchTo: "@tag.$S2.$4" },
          "string.html"
        ]
      ],
      [
        /(type)(\s*=\s*)(')([^']+)(')/,
        [
          "attribute.name.html",
          "delimiter.html",
          "string.html",
          { token: "string.html", switchTo: "@tag.$S2.$4" },
          "string.html"
        ]
      ],
      [/(\w+)(\s*=\s*)("[^"]*"|'[^']*')/, ["attribute.name.html", "delimiter.html", "string.html"]],
      [/\w+/, "attribute.name.html"],
      [/\/>/, "tag", "@pop"],
      [
        />/,
        {
          cases: {
            "$S2==style": {
              token: "tag",
              switchTo: "embeddedStyle",
              nextEmbedded: "text/css"
            },
            "$S2==script": {
              cases: {
                $S3: {
                  token: "tag",
                  switchTo: "embeddedScript",
                  nextEmbedded: "$S3"
                },
                "@default": {
                  token: "tag",
                  switchTo: "embeddedScript",
                  nextEmbedded: "text/javascript"
                }
              }
            },
            "@default": { token: "tag", next: "@pop" }
          }
        }
      ]
    ],
    embeddedStyle: [
      [/[^<]+/, ""],
      [/<\/style\s*>/, { token: "@rematch", next: "@pop", nextEmbedded: "@pop" }],
      [/</, ""]
    ],
    embeddedScript: [
      [/[^<]+/, ""],
      [/<\/script\s*>/, { token: "@rematch", next: "@pop", nextEmbedded: "@pop" }],
      [/</, ""]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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