"""
The script to plot the magnon band structure.
"""

import argparse
from TB2J.versioninfo import print_license
from TB2J.plot import plot_magnon_band


def plot_magnon():
    print_license()
    parser = argparse.ArgumentParser(
        description=
        "TB2J_magnon: Plot magnon band structure from the TB2J magnetic interaction parameters"
    )
    parser.add_argument("--fname",
                        default='exchange.xml',
                        type=str,
                        help='exchange xml file name. default: exchange.xml')

    parser.add_argument(
        "--qpath",
        default=None,
        type=str,
        help=
        'The names of special q-points. If not given, the path will be automatically choosen. See https://wiki.fysik.dtu.dk/ase/ase/dft/kpoints.html for the table of special kpoints and the default path.'
    )


    parser.add_argument(
        "--figfname",
        default=None,
        type=str,
        help=
        'The file name of the figure. It should be e.g. png, pdf or other types of files which could be generated by matplotlib.'
    )
 
    parser.add_argument("--Jq",
                        action="store_true",
                        help="To plot the eigenvalues of -J(q) instead of the magnon band",
                        default=False)
 
    parser.add_argument("--show",
                        action="store_true",
                        help="whether to show magnon band structure.",
                        default=False)

    args = parser.parse_args()
    if args.Jq:
        print("Plotting the eigenvalues of -J(q). The figure is written to %s"%(args.figfname) )
        if args.figfname is None:
            args.figfname = 'Eigen_Jq.pdf'
    else:
        print("Plotting the magnon band structure. The figure is written to %s"%(args.figfname))
        if args.figfname is None:
            args.figfname = 'magnon_band.pdf'

    plot_magnon_band(fname=args.fname,
                     knames=args.qpath,
                     npoints=300,
                     Jq=args.Jq,
                     show=args.show)


plot_magnon()
