# Generated by Django 3.0.4 on 2020-07-01 13:55

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Member',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': 'Mitglied',
                'verbose_name_plural': 'Mitglieder',
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('discordid', models.CharField(max_length=20, primary_key=True, serialize=False, verbose_name='Discord ID')),
                ('name', models.CharField(blank=True, default='', max_length=100, verbose_name='Name')),
            ],
            options={
                'verbose_name': 'Benutzer',
                'verbose_name_plural': 'Benutzer',
            },
        ),
        migrations.CreateModel(
            name='Server',
            fields=[
                ('discordid', models.CharField(max_length=20, primary_key=True, serialize=False, verbose_name='Discord ID')),
                ('name', models.CharField(blank=True, default='', max_length=100, verbose_name='Name')),
                ('members', models.ManyToManyField(through='discordbot.Member', to='discordbot.User')),
            ],
            options={
                'verbose_name': 'Server',
                'verbose_name_plural': 'Server',
            },
        ),
        migrations.CreateModel(
            name='Report',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reason', models.CharField(blank=True, default='', max_length=250, verbose_name='Grund')),
                ('timestamp', models.DateTimeField(auto_now_add=True, verbose_name='Zeitpunkt')),
                ('reported_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_reports', to='discordbot.User', verbose_name='Gemeldet von')),
                ('server', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reports', to='discordbot.Server')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reports', to='discordbot.User')),
            ],
            options={
                'verbose_name': 'Report',
                'verbose_name_plural': 'Reports',
            },
        ),
        migrations.AddField(
            model_name='member',
            name='server',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='discordbot.Server'),
        ),
        migrations.AddField(
            model_name='member',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='servers', to='discordbot.User'),
        ),
    ]
