"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * (experimental) The policy for the receipt filter.
 *
 * @experimental
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * (experimental) A receipt filter.
 *
 * When instantiated without props, it creates a
 * block all receipt filter.
 *
 * @experimental
 */
class ReceiptFilter extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
_a = JSII_RTTI_SYMBOL_1;
ReceiptFilter[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptFilter", version: "1.95.0" };
/**
 * (experimental) A white list receipt filter.
 *
 * @experimental
 */
class WhiteListReceiptFilter extends core_2.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
_b = JSII_RTTI_SYMBOL_1;
WhiteListReceiptFilter[_b] = { fqn: "@aws-cdk/aws-ses.WhiteListReceiptFilter", version: "1.95.0" };
//# sourceMappingURL=data:application/json;base64,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