import pandas as pd
import numpy as np
import feather
import matplotlib.pyplot as plt
import DBDIpy as dbdi
import os

##macOS
intensities_raw = feather.read_dataframe("/Users/lw/Nextcloud/Project212/src/data/example_dataset.feather")
annotation_metadata = feather.read_dataframe("/Users/lw/Nextcloud/Project212/src/data/example_metadata.feather")

##windows
intensities_raw = feather.read_dataframe("C:/Users/weidner.leopold/Nextcloud/Project212/src/data/example_dataset.feather")
##intensities_raw = feather.read_dataframe("C:/Users/weidner.leopold/Nextcloud/Project212/src/data/example_all_dataset.feather")

annotation_metadata = feather.read_dataframe("C:/Users/weidner.leopold/Nextcloud/Project212/src/data/example_metadata.feather")
##annotation_metadata = feather.read_dataframe("C:/Users/weidner.leopold/Nextcloud/Project212/src/data/example_all_metadata.feather")

#%%setup imp module
IDs = annotation_metadata["ID"]
intensities_raw = intensities_raw.drop("ID", axis = 1)

df = intensities_raw.copy()

#%%test imputation module

raw_imp = dbdi.impute_intensities(intensities_raw, method = "linear")

raw_imp_lin = dbdi.impute_intensities(intensities_raw, method = "linear")
raw_imp_quad = dbdi.impute_intensities(intensities_raw, method = "quadratic")
raw_imp_ind = dbdi.impute_intensities(intensities_raw, method = "previous")

test = raw_imp_lin.subtract(raw_imp_pol)

## indices of oxygen series from C15H17O2N 55 -> 66 ->> 83 ->>> 99
#%%setup corr mudule
method = "spearman"

custom_adducts = None

mass_error = 0.1

masses = annotation_metadata.iloc[:,3]

threshold = 0.95

adducts095 =  dbdi.identify_adducts(raw_imp, annotation_metadata["ThMass.Ion"], 
                         custom_adducts = pd.DataFrame({'deltamz': [47.984744], 'motive': ["O3"]}),
                         method = "spearman", threshold = 0.90, mass_error = 5)
   



#%%setup import from mgf
import time
from matchms.importing import load_from_mgf


path_data = "/Users/lw/Nextcloud/Project212/src/data"  
file_mgf = os.path.join(path_data, "example_dataset.mgf")
spectrums = list(load_from_mgf(file_mgf))


starttime = time.process_time()
testXX = dbdi.align_spectra(spectrums)
elapsed = time.process_time() - starttime
print(elapsed)   ##7.24 sec

#%% import-export-cylce

from matchms import exporting

ftints = intensities_raw.copy()
ftints["mean"] = annotation_metadata["ThMass.Ion"]

testX =  export_to_spectra(ftints, 88)

exporting.save_as_mgf(testX, filename = "example_dataset.mgf")


os.getcwd()



O1 = reslist["O"]
O2 = reslist["O2"]
O3 = reslist["O3"]
H2O = reslist["H2O"]

x = np.intersect1d(O3["base_index"], np.intersect1d(O1["base_index"],O2["base_index"]))
a = np.intersect1d(x , H2O["base_index"])



#%% plotting module 

IDs = [55,66,83,99]
df = raw_imp.copy()
transform = True

test = dbdi.plot_adducts([55,66,83,99], df = raw_imp)
test = dbdi.plot_adducts(IDs, df, metadata = annotation_metadata, transform = False)

plot_adducts(2,2)

test.gca().get_title()




specs_aligned = specs_aligned.apply(lambda col:pd.to_numeric(col, errors='coerce'))

#%% 
path = r'D:\Users\.....'
path = path.replace('\\' , '/')



feather.write_dataframe(raw_imp, "demo_filled.feather")

os.getcwd()
