# Generated by Django 3.0.3 on 2020-02-27 21:36

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import isc_common.fields.related


class Migration(migrations.Migration):

    dependencies = [
        ('ckk', '0212_auto_20200225_1013'),
        ('production', '0218_auto_20200227_1632'),
    ]

    operations = [
        migrations.CreateModel(
            name='Operations_template_material',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('qty', models.DecimalField(decimal_places=4, default=0.0, max_digits=10)),
            ],
            options={
                'verbose_name': 'Кросс таблица',
            },
        ),
        migrations.CreateModel(
            name='Operations_template_resource',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('batch_size', models.PositiveIntegerField(default=1)),
            ],
            options={
                'verbose_name': 'Кросс таблица',
            },
        ),
        migrations.AddField(
            model_name='operations_template_resource',
            name='location',
            field=isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='ckk.Locations'),
        ),
        migrations.AddField(
            model_name='operations_template_resource',
            name='resource',
            field=isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='production.Resource'),
        ),
        migrations.AddField(
            model_name='operations_template_resource',
            name='template',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='production.Operations_template_detail'),
        ),
        migrations.AddField(
            model_name='operations_template_material',
            name='edizm',
            field=isc_common.fields.related.ForeignKeyProtect(default=None, on_delete=django.db.models.deletion.PROTECT, to='ckk.Ed_izm'),
        ),
        migrations.AddField(
            model_name='operations_template_material',
            name='material',
            field=isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='ckk.Materials'),
        ),
        migrations.AddField(
            model_name='operations_template_material',
            name='material_askon',
            field=isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='ckk.Material_askon'),
        ),
        migrations.AddField(
            model_name='operations_template_material',
            name='parent',
            field=isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='production.Operations_template_material'),
        ),
        migrations.AddField(
            model_name='operations_template_material',
            name='template',
            field=isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='production.Operations_template_detail'),
        ),
        migrations.AddConstraint(
            model_name='operations_template_resource',
            constraint=models.UniqueConstraint(condition=models.Q(('location', None), ('resource', None)), fields=('template',), name='Operations_template_resource_unique_constraint_0'),
        ),
        migrations.AddConstraint(
            model_name='operations_template_resource',
            constraint=models.UniqueConstraint(condition=models.Q(location=None), fields=('template', 'resource'), name='Operations_template_resource_unique_constraint_1'),
        ),
        migrations.AddConstraint(
            model_name='operations_template_resource',
            constraint=models.UniqueConstraint(condition=models.Q(resource=None), fields=('location', 'template'), name='Operations_template_resource_unique_constraint_2'),
        ),
        migrations.AddConstraint(
            model_name='operations_template_resource',
            constraint=models.UniqueConstraint(fields=('location', 'template', 'resource'), name='Operations_template_resource_unique_constraint_3'),
        ),
        migrations.AddConstraint(
            model_name='operations_template_material',
            constraint=models.UniqueConstraint(condition=models.Q(('material', None), ('material_askon', None)), fields=('template',), name='Operations_template_material_unique_constraint_0'),
        ),
        migrations.AddConstraint(
            model_name='operations_template_material',
            constraint=models.UniqueConstraint(condition=models.Q(material_askon=None), fields=('material', 'template'), name='Operations_template_material_unique_constraint_1'),
        ),
        migrations.AddConstraint(
            model_name='operations_template_material',
            constraint=models.UniqueConstraint(condition=models.Q(material=None), fields=('material_askon', 'template'), name='Operations_template_material_unique_constraint_2'),
        ),
        migrations.AddConstraint(
            model_name='operations_template_material',
            constraint=models.UniqueConstraint(fields=('material', 'material_askon', 'template'), name='Operations_template_material_unique_constraint_3'),
        ),
    ]
