# _*_ coding: utf-8 _*_
"""Copied from
`peewee <https://github.com/coleifer/peewee/blob/3.9.4/peewee.py>`_
with little customization"""


class Proxy(object):
    """
    Create a proxy or placeholder for another object.
    """

    __slots__ = ("obj", "_callbacks")

    def __init__(self):
        self._callbacks = []
        self.initialize(None)

    def initialize(self, obj):
        self.obj = obj
        for callback in self._callbacks:
            callback(obj)

    def attach_callback(self, callback):
        self._callbacks.append(callback)
        return callback

    def passthrough(method):
        def inner(self, *args, **kwargs):
            if self.obj is None:
                raise AttributeError("Cannot use uninitialized Proxy.")
            return getattr(self.obj, method)(*args, **kwargs)

        return inner

    # Allow proxy to be used as a context-manager.
    __enter__ = passthrough("__enter__")
    __exit__ = passthrough("__exit__")

    def __getattr__(self, attr):
        if self.obj is None:
            raise AttributeError("Cannot use uninitialized Proxy.")
        return getattr(self.obj, attr)

    def __setattr__(self, attr, value):
        if attr not in self.__slots__:
            raise AttributeError("Cannot set attribute on proxy.")
        return super(Proxy, self).__setattr__(attr, value)


class attrdict(dict):
    def __getattr__(self, attr):
        try:
            return self[attr]
        except KeyError:
            raise AttributeError(attr)

    def __setattr__(self, attr, value):
        self[attr] = value

    def __iadd__(self, rhs):
        self.update(rhs)
        return self

    def __add__(self, rhs):
        d = attrdict(self)
        d.update(rhs)
        return d
