from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

stm32 = SchLib(tool=SKIDL).add_parts(*[
        Part(name='STM32F030C6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 32KB Ram: 4KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='SPI1_NSS/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI1_NSS/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI1_SCK/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI1_MISO/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI1_MOSI/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F030C8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/TIM15_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM15_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='SPI1_NSS/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/TIM15_CH1/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F030CCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/TIM15_CH1N/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/TIM15_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM15_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/SPI1_SCK/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='I2C2_SCL/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SDA/TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='SPI1_NSS/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='5',name='PF0/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/TIM17_BKIN/TIM3_CH1/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C2_SCL/SPI2_SCK/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/SPI2_SCK/TIM1_CH1N/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F030F4Px',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: TSSOP20 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 15',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='1',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F030K6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP32 Flash: 32KB Ram: 4KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 25',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SPI1_NSS/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/SPI1_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F030R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 55',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/TIM15_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/TIM15_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='SPI1_NSS/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/TIM16_CH1/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='I2C1_SDA/IR_OUT/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SPI2_NSS/TIM1_BKIN/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/TIM1_CH1N/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='18',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF6/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF7/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F030RCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/TIM15_CH1N/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/TIM15_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/TIM15_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/SPI1_SCK/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='I2C2_SCL/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='I2C2_SDA/TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='SPI1_NSS/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/TIM17_BKIN/TIM3_CH1/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/TIM16_CH1/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='I2C1_SDA/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/SPI2_SCK/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SPI2_NSS/TIM15_BKIN/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2C2_SCL/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='I2C2_SDA/SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='5',name='PF0/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK/USART4_CK/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F031C4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F031C6Tx'],pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C1_SCL/TIM2_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C1_SDA/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI1_NSS/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI1_SCK/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI1_MISO/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI1_MOSI/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F031F4Px',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: TSSOP20 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 15',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F031F6Px'],pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='1',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F031G4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN28 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 23',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F031G6Ux'],pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='1',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F031K4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN32 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 27',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F031K6Ux'],pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F031K6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP32 Flash: 32KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 25',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F038C6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 32KB Ram: 4KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 38',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C1_SCL/TIM2_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C1_SDA/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI1_NSS/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI1_SCK/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI1_MISO/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI1_MOSI/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F038F6Px',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: TSSOP20 Flash: 32KB Ram: 4KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 14',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='1',name='BOOT0',do_erc=True),
            Pin(num='14',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F038G6Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFQFPN28 Flash: 32KB Ram: 4KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 22',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='1',name='BOOT0',do_erc=True),
            Pin(num='15',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F038K6Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFQFPN32 Flash: 32KB Ram: 4KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 26',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_DE/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TIM1_ETR/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='16',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F042C4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 16KB Ram: 6KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 38',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F042C6Tx'],pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CAN_RX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/I2C1_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='44',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/I2C1_SDA/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C1_SCL/SPI2_SCK/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C1_SDA/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C1_SCL/SPI2_SCK/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C1_SDA/SPI2_MISO/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F042C6Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 32KB Ram: 6KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 38',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CAN_RX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/I2C1_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='44',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/I2C1_SDA/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C1_SCL/SPI2_SCK/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C1_SDA/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C1_SCL/SPI2_SCK/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C1_SDA/SPI2_MISO/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F042F4Px',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: TSSOP20 Flash: 16KB Ram: 6KB Frequency: 48MHz Voltage: 2..--V IO-pins: 16',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/CAN_RX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USB_DM/PA11/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/CAN_TX/TIM1_ETR/TSC_G4_IO4/USB_DP/PA12/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='2',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F042F6Px',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: TSSOP20 Flash: 32KB Ram: 6KB Voltage: 2..--V IO-pins: 16',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/CAN_RX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USB_DM/PA11/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/CAN_TX/TIM1_ETR/TSC_G4_IO4/USB_DP/PA12/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='2',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F042G4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: UFQFPN28 Flash: 16KB Ram: 6KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 23',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F042G6Ux'],pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/CAN_RX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/CAN_TX/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='2',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F042K4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: UFQFPN32 Flash: 16KB Ram: 6KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 28',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F042K6Ux'],pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CAN_RX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='CAN_TX/I2C1_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='2',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='31',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F042K6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: LQFP32 Flash: 32KB Ram: 6KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 26',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CAN_RX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='CAN_TX/I2C1_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='2',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F042T6Yx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: WLCSP36 Flash: 32KB Ram: 6KB Frequency: 48MHz Voltage: 2..--V IO-pins: 30',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='F6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='CAN_RX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='CAN_TX/I2C1_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='NRST',do_erc=True),
            Pin(num='B5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='C5',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='A6',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='E1',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F048C6Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 32KB Ram: 6KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C1_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='44',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C1_SCL/SPI2_SCK/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C1_SDA/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C1_SCL/SPI2_SCK/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C1_SDA/SPI2_MISO/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F048G6Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFQFPN28 Flash: 32KB Ram: 6KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 22',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='15',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F048T6Yx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: WLCSP36 Flash: 32KB Ram: 6KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 29',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='F6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='ADC_IN1/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='ADC_IN2/SYS_WKUP4/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN3/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='ADC_IN5/CEC/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='I2C1_SCL/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='I2C1_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='I2C1_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USB_OE/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='NRST',do_erc=True),
            Pin(num='D2',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='C5',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='A6',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='E1',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F050C4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 38',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F050C6Tx'],pins=[
            Pin(num='10',name='ADC_IN0/SYS_RTC_TAMP2/SYS_WKUP1/TIM2_CH1_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/TIM2_CH2/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='SYS_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IRTIM_OUT/SYS_SWDAT/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/SYS_OSC_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PF1/SYS_OSC_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PF6/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/SYS_RTC_OUT/SYS_RTC_TAMP1/SYS_RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/SYS_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/SYS_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IRTIM_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C1_SCL/TIM2_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C1_SDA/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI1_NSS/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI1_SCK/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI1_MISO/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/SPI1_MOSI/SYS_RTC_REFIN/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F050G4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN28 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 23',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F050G6Ux'],pins=[
            Pin(num='6',name='ADC_IN0/SYS_RTC_TAMP2/SYS_WKUP1/TIM2_CH1_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SYS_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IRTIM_OUT/SYS_SWDAT/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I2S1_WS/SPI1_NSS/TIM2_CH1_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='1',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/SYS_OSC_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PF1/SYS_OSC_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F050K4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN32 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 26',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F050K6Ux'],pins=[
            Pin(num='6',name='ADC_IN0/SYS_RTC_TAMP2/SYS_WKUP1/TIM2_CH1_ETR/USART1_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/TIM2_CH2/USART1_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/TIM2_CH3/USART1_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/TIM2_CH4/USART1_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/I2S1_WS/SPI1_NSS/TIM14_CH1/USART1_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/I2S1_CK/SPI1_SCK/TIM2_CH1_ETR/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SYS_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IRTIM_OUT/SYS_SWDAT/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART1_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1_ETR/USART1_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/SYS_OSC_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PF1/SYS_OSC_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051C4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 16KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/TIM2_CH4/TSC_G6_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/TIM1_BKIN/TSC_G6_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/TIM1_CH1N/TSC_G6_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051C4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 16KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/TIM2_CH4/TSC_G6_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/TIM1_BKIN/TSC_G6_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/TIM1_CH1N/TSC_G6_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051C6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 32KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/TIM2_CH4/TSC_G6_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/TIM1_BKIN/TSC_G6_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/TIM1_CH1N/TSC_G6_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051C6Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 32KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/TIM2_CH4/TSC_G6_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/TIM1_BKIN/TSC_G6_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/TIM1_CH1N/TSC_G6_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051C8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM1_BKIN/TSC_G6_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051C8Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 39',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM1_BKIN/TSC_G6_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051K4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP32 Flash: 16KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 25',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051K4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN32 Flash: 16KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 27',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051K6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP32 Flash: 32KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 25',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051K6Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN32 Flash: 32KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 27',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051K8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP32 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 25',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051K8Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN32 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 27',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='31',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051R4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 16KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 55',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/TIM2_CH3/TSC_SYNC/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TIM2_CH4/TSC_G6_IO1/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_BKIN/TSC_G6_IO2/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TIM1_CH1N/TSC_G6_IO3/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RTC_REFIN/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='18',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/TSC_G3_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC1_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051R6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 32KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 55',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/TIM2_CH3/TSC_SYNC/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TIM2_CH4/TSC_G6_IO1/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_BKIN/TSC_G6_IO2/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TIM1_CH1N/TSC_G6_IO3/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RTC_REFIN/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='18',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/TSC_G3_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC1_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F051R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 55',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/TIM2_CH3/TSC_SYNC/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SPI2_NSS/TIM1_BKIN/TSC_G6_IO2/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='18',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF6/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF7/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/TSC_G3_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC1_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F058C8Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 38',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='35',name='PF6/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PF7/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/TIM2_CH3/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM1_BKIN/TSC_G6_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F058R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 64KB Ram: 8KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 54',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC1_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC1_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC1_EXTI9/I2C1_SDA/IR_OUT/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/TIM2_CH3/TSC_SYNC/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SPI2_NSS/TIM1_BKIN/TSC_G6_IO2/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RTC_REFIN/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='18',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PF6/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PF7/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/TSC_G3_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC1_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F070C6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 32KB Ram: 6KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/SYS_WKUP4/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C1_SCL/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='SPI1_NSS/USART2_RX/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='5',name='PF0/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/TIM17_BKIN/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IR_OUT/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SYS_WKUP7/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F070CBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/TIM15_CH1N/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/SYS_WKUP4/TIM15_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/TIM15_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='SPI1_NSS/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/TIM17_BKIN/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C2_SCL/SPI2_SCK/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/SPI2_SCK/TIM1_CH1N/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F070F6Px',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: TSSOP20 Flash: 32KB Ram: 6KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 15',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ADC_IN1/USART2_DE/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC_IN2/SYS_WKUP4/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC_IN3/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART2_CK/USB_OE/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='I2C1_SCL/TIM1_CH2/USART1_TX/I2C1_SCL/TIM1_CH4/USART1_CTS/USB_DM/PA11/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/USART1_RX/TIM1_ETR/USART1_DE/USART1_RTS/USB_DP/PA12/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='1',name='BOOT0',do_erc=True),
            Pin(num='2',name='PF0/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='14',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F070RBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x0 Value Line',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2.4..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/RTC_TAMP2/SYS_WKUP1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/TIM15_CH1N/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/SYS_WKUP4/TIM15_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/TIM15_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/SPI1_NSS/TIM14_CH1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TIM1_ETR/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='SPI1_NSS/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/TIM17_BKIN/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/TIM16_CH1/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='I2C1_SDA/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/SPI2_SCK/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SPI2_NSS/TIM15_BKIN/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2C2_SCL/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='I2C2_SDA/SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='5',name='PF0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/SYS_WKUP5/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK/USART4_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F071CBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F071CBUx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F071CBYx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: WLCSP49 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='F6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='NRST',do_erc=True),
            Pin(num='A5',name='BOOT0',do_erc=True),
            Pin(num='B6',name='NC',func=Pin.PWRIN,do_erc=True),
            Pin(num='B7',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='D6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='D5',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PB9/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='A6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F071RBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK/USART4_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F071V8Hx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFBGA100 Flash: 64KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 87',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F071VBHx'],pins=[
            Pin(num='L2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC_IN12/I2S2_MCK/SPI2_MISO/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC_IN13/I2S2_SD/SPI2_MOSI/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='USART3_CK/USART4_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='NRST',do_erc=True),
            Pin(num='A4',name='BOOT0',do_erc=True),
            Pin(num='E2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='E3',name='NC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='G1',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='J1',name='PF2/SYS_WKUP8',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='PF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C11',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PF9/DAC_EXTI9/TIM15_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PF10/TIM15_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='PE11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='PD0/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='PD1/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H12',name='PD13/TSC_G8_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='PD14/TSC_G8_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD15/CRS_SYNC/TSC_G8_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='G11',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F071V8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP100 Flash: 64KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 87',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F071VBTx'],pins=[
            Pin(num='23',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN12/I2S2_MCK/SPI2_MISO/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC_IN13/I2S2_SD/SPI2_MOSI/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='USART3_CK/USART4_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='19',name='PF2/SYS_WKUP8',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF9/DAC_EXTI9/TIM15_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF10/TIM15_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TSC_G8_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TSC_G8_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/CRS_SYNC/TSC_G8_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F072C8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 64KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F072CBTx'],pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CAN_RX/COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F072C8Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 64KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F072CBUx'],pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CAN_RX/COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F072CBYx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: WLCSP49 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='F6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='CAN_RX/COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='CAN_TX/COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='NRST',do_erc=True),
            Pin(num='A5',name='BOOT0',do_erc=True),
            Pin(num='B6',name='NC',func=Pin.PWRIN,do_erc=True),
            Pin(num='B7',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='D6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='D5',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PB9/CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='A6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F072R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 64KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F072RBTx'],pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='CAN_RX/COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN_TX/COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK/USART4_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F072RBHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: UFBGA64 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='G2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='CAN_RX/COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='CAN_TX/COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B4',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12/USART3_CK/USART4_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F072RBIx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: UFBGA64 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='G2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='CAN_RX/COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='CAN_TX/COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B4',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12/USART3_CK/USART4_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F072V8Hx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: UFBGA100 Flash: 64KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 87',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F072VBHx'],pins=[
            Pin(num='L2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='CAN_RX/COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='CAN_TX/COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC_IN12/I2S2_MCK/SPI2_MISO/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC_IN13/I2S2_SD/SPI2_MOSI/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='USART3_CK/USART4_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='NRST',do_erc=True),
            Pin(num='A4',name='BOOT0',do_erc=True),
            Pin(num='E2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='E3',name='NC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='G1',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='J1',name='PF2/SYS_WKUP8',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='PF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C11',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PF9/DAC_EXTI9/TIM15_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PF10/TIM15_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='PE11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='PD0/CAN_RX/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='PD1/CAN_TX/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H12',name='PD13/TSC_G8_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='PD14/TSC_G8_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD15/CRS_SYNC/TSC_G8_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='G11',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F072V8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x2',description='Core: ARM Cortex-M0 Package: LQFP100 Flash: 64KB Ram: 16KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 87',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F072VBTx'],pins=[
            Pin(num='23',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='CAN_RX/COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN_TX/COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN12/I2S2_MCK/SPI2_MISO/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC_IN13/I2S2_SD/SPI2_MOSI/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='USART3_CK/USART4_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='19',name='PF2/SYS_WKUP8',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF9/DAC_EXTI9/TIM15_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF10/TIM15_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN_RX/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN_TX/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TSC_G8_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TSC_G8_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/CRS_SYNC/TSC_G8_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F078CBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 36',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F078CBUx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 36',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F078CBYx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: WLCSP49 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 36',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='F6',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='NRST',do_erc=True),
            Pin(num='A5',name='BOOT0',do_erc=True),
            Pin(num='B6',name='NC',func=Pin.PWRIN,do_erc=True),
            Pin(num='B7',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='G3',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='D6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='D5',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PB9/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='A6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F078RBHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFBGA64 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 50',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='G2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B4',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12/USART3_CK/USART4_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F078RBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 50',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK/USART4_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F078VBHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFBGA100 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 86',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='L2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC_IN12/I2S2_MCK/SPI2_MISO/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC_IN13/I2S2_SD/SPI2_MOSI/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='USART3_CK/USART4_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='NRST',do_erc=True),
            Pin(num='A4',name='BOOT0',do_erc=True),
            Pin(num='E2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='E3',name='NC',func=Pin.PWRIN,do_erc=True),
            Pin(num='L6',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='G1',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='J1',name='PF2/SYS_WKUP8',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='PF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C11',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PF9/DAC_EXTI9/TIM15_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PF10/TIM15_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='PE11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='PD0/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='PD1/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H12',name='PD13/TSC_G8_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='PD14/TSC_G8_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD15/CRS_SYNC/TSC_G8_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='G11',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F078VBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: LQFP100 Flash: 128KB Ram: 16KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 86',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='23',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='COMP1_OUT/TIM1_CH4/TSC_G4_IO3/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='COMP2_OUT/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IR_OUT/SYS_SWDIO/USB_OE/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN12/I2S2_MCK/SPI2_MISO/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC_IN13/I2S2_SD/SPI2_MOSI/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='USART3_CK/USART4_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PF0/CRS_SYNC/RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='PF1/RCC_OSC_OUT',do_erc=True),
            Pin(num='19',name='PF2/SYS_WKUP8',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF9/DAC_EXTI9/TIM15_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF10/TIM15_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TSC_G8_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TSC_G8_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/CRS_SYNC/TSC_G8_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F091CBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 128KB Ram: 32KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 38',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F091CCTx'],pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='44',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F091CBUx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 128KB Ram: 32KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 38',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F091CCUx'],pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='44',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/TSC_G3_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F091RBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 128KB Ram: 32KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 52',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F091RCTx'],pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='60',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10/USART6_TX/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11/USART6_RX/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK/USART4_CK/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F091RCHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFBGA64 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 52',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='G2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='B4',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC_IN10/USART6_TX/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC_IN11/USART6_RX/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/DAC_EXTI9/TIM3_CH4/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12/USART3_CK/USART4_CK/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F091RCYx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: WLCSP64 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 52',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='F7',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='NRST',do_erc=True),
            Pin(num='B8',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='D8',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='E8',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='C6',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC0/ADC_IN10/USART6_TX/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='PC1/ADC_IN11/USART6_RX/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='PC6/TIM3_CH1/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='PC7/TIM3_CH2/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC8/TIM3_CH3/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC9/DAC_EXTI9/TIM3_CH4/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PC12/USART3_CK/USART4_CK/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='A1',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F091VBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: LQFP100 Flash: 128KB Ram: 32KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 88',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F091VCTx'],pins=[
            Pin(num='23',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN10/USART6_TX/USART7_TX/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN11/USART6_RX/USART7_RX/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN12/I2S2_MCK/SPI2_MISO/USART8_TX/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC_IN13/I2S2_SD/SPI2_MOSI/USART8_RX/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/USART7_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/USART7_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/USART8_TX/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/USART8_RX/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='USART3_CK/USART4_CK/USART5_TX/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='19',name='PF2/SYS_WKUP8/USART7_CK/USART7_DE/USART7_RTS/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF3/USART6_CK/USART6_DE/USART6_RTS/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF9/DAC_EXTI9/TIM15_CH1/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF10/TIM15_CH2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR/USART5_CK/USART5_DE/USART5_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/TIM1_CH1/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/TIM1_CH2/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN_RX/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN_TX/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS/USART8_CK/USART8_DE/USART8_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TSC_G8_IO2/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TSC_G8_IO3/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/CRS_SYNC/TSC_G8_IO4/USART7_CK/USART7_DE/USART7_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F091VCHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x1',description='Core: ARM Cortex-M0 Package: UFBGA100 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 88',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='L2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TSC_G3_IO4/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC_IN10/USART6_TX/USART7_TX/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC_IN11/USART6_RX/USART7_RX/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC_IN12/I2S2_MCK/SPI2_MISO/USART8_TX/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC_IN13/I2S2_SD/SPI2_MOSI/USART8_RX/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='TIM3_CH1/USART7_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='TIM3_CH2/USART7_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='TIM3_CH3/USART8_TX/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='DAC_EXTI9/TIM3_CH4/USART8_RX/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='USART3_CK/USART4_CK/USART5_TX/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='NC',do_erc=True),
            Pin(num='H2',name='NRST',do_erc=True),
            Pin(num='E2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='G1',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='J1',name='PF2/SYS_WKUP8/USART7_CK/USART7_DE/USART7_RTS/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='PF3/USART6_CK/USART6_DE/USART6_RTS/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C11',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PF9/DAC_EXTI9/TIM15_CH1/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PF10/TIM15_CH2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PE7/TIM1_ETR/USART5_CK/USART5_DE/USART5_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='PE8/TIM1_CH1N/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='PE9/DAC_EXTI9/TIM1_CH1/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='PE10/TIM1_CH2N/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='PE11/TIM1_CH2/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='PD0/CAN_RX/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='PD1/CAN_TX/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS/USART8_CK/USART8_DE/USART8_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H12',name='PD13/TSC_G8_IO2/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='PD14/TSC_G8_IO3/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD15/CRS_SYNC/TSC_G8_IO4/USART7_CK/USART7_DE/USART7_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='G11',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F098CCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: LQFP48 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='44',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F098CCUx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFQFPN48 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='44',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F098RCHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: UFBGA64 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='G2',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='B4',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC_IN10/USART6_TX/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC_IN11/USART6_RX/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/DAC_EXTI9/TIM3_CH4/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12/USART3_CK/USART4_CK/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F098RCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: LQFP64 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='60',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC_IN10/USART6_TX/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC_IN11/USART6_RX/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK/USART4_CK/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F098RCYx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: WLCSP64 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='F7',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='NRST',do_erc=True),
            Pin(num='B8',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='H4',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='D8',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='E8',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='C6',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC0/ADC_IN10/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='PC1/ADC_IN11/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='PC2/ADC_IN12/I2S2_MCK/SPI2_MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='PC3/ADC_IN13/I2S2_SD/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC_IN14/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='PC5/ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PC10/USART3_TX/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PC11/USART3_RX/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PC12/USART3_CK/USART4_CK/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC13/RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PC15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='A1',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F098VCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M0 STM32F0 STM32F0x8',description='Core: ARM Cortex-M0 Package: LQFP100 Flash: 256KB Ram: 32KB Frequency: 48MHz Voltage: 1.65..1.95V IO-pins: 87',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='23',name='ADC_IN0/COMP1_INM/COMP1_OUT/RTC_TAMP2/SYS_WKUP1/TIM2_CH1/TIM2_ETR/TSC_G1_IO1/USART2_CTS/USART4_TX/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC_IN1/COMP1_INP/TIM15_CH1N/TIM2_CH2/TSC_G1_IO2/USART2_DE/USART2_RTS/USART4_RX/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC_IN2/COMP2_INM/COMP2_OUT/SYS_WKUP4/TIM15_CH1/TIM2_CH3/TSC_G1_IO3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC_IN3/COMP2_INP/TIM15_CH2/TIM2_CH4/TSC_G1_IO4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC_IN4/COMP1_INM/COMP2_INM/DAC_OUT1/I2S1_WS/SPI1_NSS/TIM14_CH1/TSC_G2_IO1/USART2_CK/USART6_TX/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC_IN5/CEC/COMP1_INM/COMP2_INM/DAC_OUT2/I2S1_CK/SPI1_SCK/TIM2_CH1/TIM2_ETR/TSC_G2_IO2/USART6_RX/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC_IN6/COMP1_OUT/I2S1_MCK/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/TSC_G2_IO3/USART3_CTS/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC_IN7/COMP2_OUT/I2S1_SD/SPI1_MOSI/TIM14_CH1/TIM17_CH1/TIM1_CH1N/TIM3_CH2/TSC_G2_IO4/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='CRS_SYNC/RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/I2C1_SCL/RCC_MCO/TIM15_BKIN/TIM1_CH2/TSC_G4_IO1/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='I2C1_SDA/TIM17_BKIN/TIM1_CH3/TSC_G4_IO2/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='CAN_RX/COMP1_OUT/I2C2_SCL/TIM1_CH4/TSC_G4_IO3/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN_TX/COMP2_OUT/I2C2_SDA/TIM1_ETR/TSC_G4_IO4/USART1_DE/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IR_OUT/SYS_SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_SWCLK/USART2_TX/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='I2S1_WS/SPI1_NSS/TIM2_CH1/TIM2_ETR/USART2_RX/USART4_DE/USART4_RTS/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC_IN8/TIM1_CH2N/TIM3_CH3/TSC_G3_IO2/USART3_CK/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/TSC_G3_IO3/USART3_DE/USART3_RTS/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S1_CK/SPI1_SCK/TIM2_CH2/TSC_G5_IO1/USART5_TX/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='I2S1_MCK/SPI1_MISO/TIM17_BKIN/TIM3_CH1/TSC_G5_IO2/USART5_RX/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/I2S1_SD/SPI1_MOSI/SYS_WKUP6/TIM16_BKIN/TIM3_CH2/USART5_CK/USART5_DE/USART5_RTS/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM16_CH1N/TSC_G5_IO3/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM17_CH1N/TSC_G5_IO4/USART1_RX/USART4_CTS/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN_RX/CEC/I2C1_SCL/TIM16_CH1/TSC_SYNC/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/IR_OUT/SPI2_NSS/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='CEC/I2C2_SCL/I2S2_CK/SPI2_SCK/TIM2_CH3/TSC_SYNC/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='I2C2_SDA/TIM2_CH4/TSC_G6_IO1/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2S2_WS/SPI2_NSS/TIM15_BKIN/TIM1_BKIN/TSC_G6_IO2/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='I2C2_SCL/I2S2_CK/SPI2_SCK/TIM1_CH1N/TSC_G6_IO3/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='I2C2_SDA/I2S2_MCK/SPI2_MISO/TIM15_CH1/TIM1_CH2N/TSC_G6_IO4/USART3_DE/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='I2S2_SD/RTC_REFIN/SPI2_MOSI/SYS_WKUP7/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC_IN10/USART6_TX/USART7_TX/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC_IN11/USART6_RX/USART7_RX/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC_IN12/I2S2_MCK/SPI2_MISO/USART8_TX/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC_IN13/I2S2_SD/SPI2_MOSI/USART8_RX/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC_IN14/USART3_TX/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC_IN15/SYS_WKUP5/TSC_G3_IO1/USART3_RX/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/USART7_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/USART7_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/USART8_TX/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/USART8_RX/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='USART3_TX/USART4_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='USART3_RX/USART4_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='USART3_CK/USART4_CK/USART5_TX/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT_ALARM/RTC_OUT_CALIB/RTC_TAMP1/RTC_TS/SYS_WKUP2/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='NPOR',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PF0/CRS_SYNC/I2C1_SDA/RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='PF1/I2C1_SCL/RCC_OSC_OUT',do_erc=True),
            Pin(num='19',name='PF2/SYS_WKUP8/USART7_CK/USART7_DE/USART7_RTS/USART7_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF3/USART6_CK/USART6_DE/USART6_RTS/USART7_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF9/DAC_EXTI9/TIM15_CH1/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF10/TIM15_CH2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='PF11',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='PE0/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/TIM3_ETR/TSC_G7_IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/TIM3_CH1/TSC_G7_IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/TIM3_CH2/TSC_G7_IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/TIM3_CH3/TSC_G7_IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/RTC_TAMP3/SYS_WKUP3/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR/USART5_CK/USART5_DE/USART5_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N/USART4_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/TIM1_CH1/USART4_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N/USART5_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/TIM1_CH2/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/I2S1_WS/SPI1_NSS/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/I2S1_CK/SPI1_SCK/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/I2S1_MCK/SPI1_MISO/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/I2S1_SD/SPI1_MOSI/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN_RX/I2S2_WS/SPI2_NSS',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN_TX/I2S2_CK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/USART3_DE/USART3_RTS/USART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/I2S2_MCK/SPI2_MISO/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/I2S2_SD/SPI2_MOSI/USART2_DE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TSC_G8_IO1/USART3_DE/USART3_RTS/USART8_CK/USART8_DE/USART8_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TSC_G8_IO2/USART8_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TSC_G8_IO3/USART8_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/CRS_SYNC/TSC_G8_IO4/USART7_CK/USART7_DE/USART7_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDDIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100C4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: LQFP48 Flash: 16KB Ram: 4KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100C6Tx'],pins=[
            Pin(num='10',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC_EXTI9/I2C1_SDA/TIM17_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/TIM2_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/TIM15_CH1/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100C8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: LQFP48 Flash: 64KB Ram: 8KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100CBTx'],pins=[
            Pin(num='10',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM16_CH1N/TIM4_CH1/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM17_CH1N/TIM4_CH2/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CEC/I2C1_SCL/TIM16_CH1/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/DAC_EXTI9/I2C1_SDA/TIM17_CH1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/CEC/I2C2_SCL/TIM2_CH3/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/TIM1_CH1N/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100R4Hx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: TFBGA64 Flash: 16KB Ram: 4KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 50',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100R6Hx'],pins=[
            Pin(num='G2',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC1_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC1_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM16_CH1N/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM17_CH1N/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CEC/I2C1_SCL/TIM16_CH1/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='DAC_EXTI9/I2C1_SDA/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='CEC/TIM2_CH3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='ADC1_EXTI11/TIM2_CH4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='TIM1_BKIN/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='TIM1_CH1N/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='TIM15_CH1/TIM1_CH2N/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='ADC1_EXTI15/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B4',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/ADC1_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100R4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 16KB Ram: 4KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100R6Tx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC_EXTI9/I2C1_SDA/TIM17_CH1/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/TIM2_CH3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/TIM2_CH4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_BKIN/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TIM1_CH1N/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TIM15_CH1/TIM1_CH2N/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100R8Hx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: TFBGA64 Flash: 64KB Ram: 8KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 50',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100RBHx'],pins=[
            Pin(num='G2',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC1_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC1_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM16_CH1N/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM17_CH1N/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CEC/I2C1_SCL/TIM16_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='DAC_EXTI9/I2C1_SDA/TIM17_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='CEC/I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='ADC1_EXTI15/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B4',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/ADC1_EXTI11/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 64KB Ram: 8KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100RBTx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC_EXTI9/I2C1_SDA/TIM17_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100RCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 256KB Ram: 24KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100RDTx', 'STM32F100RETx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM13_CH1/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM16_CH1N/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM17_CH1N/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CEC/I2C1_SCL/TIM16_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC_EXTI9/I2C1_SDA/TIM17_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='CEC/I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/SPI2_NSS/TIM12_CH1/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/TIM12_CH2/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/TIM12_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/TIM12_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM13_CH1/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM14_CH1/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100V8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 64KB Ram: 8KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100VBTx'],pins=[
            Pin(num='23',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/SPI1_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM16_CH1N/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM17_CH1N/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CEC/I2C1_SCL/TIM16_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='DAC_EXTI9/I2C1_SDA/TIM17_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='CEC/I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100VCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 256KB Ram: 24KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100VDTx', 'STM32F100VETx'],pins=[
            Pin(num='23',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/TIM13_CH1/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM16_CH1N/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='FSMC_NL/I2C1_SDA/TIM17_CH1N/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CEC/I2C1_SCL/TIM16_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='DAC_EXTI9/I2C1_SDA/TIM17_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='CEC/I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2C2_SMBA/SPI2_NSS/TIM12_CH1/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='SPI2_SCK/TIM12_CH2/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/TIM12_CH1/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/TIM12_CH2/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM13_CH1/TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM14_CH1/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/FSMC_A16/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/FSMC_A17/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F100ZCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F100 Value Line',description='Core: ARM Cortex-M3 Package: LQFP144 Flash: 256KB Ram: 24KB Frequency: 24MHz Voltage: 2..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F100ZDTx', 'STM32F100ZETx'],pins=[
            Pin(num='34',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN2/TIM15_CH1/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ADC1_IN3/TIM15_CH2/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN6/SPI1_MISO/TIM16_CH1/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ADC1_IN7/SPI1_MOSI/TIM17_CH1/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='DAC_EXTI9/TIM15_BKIN/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TIM17_BKIN/TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='ADC1_EXTI11/TIM1_CH4/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='TIM1_ETR/USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='ADC1_IN8/TIM13_CH1/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN9/TIM14_CH1/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM16_BKIN/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='I2C1_SCL/TIM16_CH1N/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='FSMC_NL/I2C1_SDA/TIM17_CH1N/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='CEC/I2C1_SCL/TIM16_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='DAC_EXTI9/I2C1_SDA/TIM17_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='CEC/I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='I2C2_SMBA/SPI2_NSS/TIM12_CH1/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='SPI2_SCK/TIM12_CH2/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='SPI2_MISO/TIM15_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='ADC1_EXTI15/SPI2_MOSI/TIM15_CH1N/TIM15_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ADC1_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_IN14/TIM12_CH1/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='ADC1_IN15/TIM12_CH2/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='TIM13_CH1/TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='DAC_EXTI9/TIM14_CH1/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='ADC1_EXTI11/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/FSMC_A16/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='FSMC_A17/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='ADC1_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='NRST',do_erc=True),
            Pin(num='138',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='RCC_OSC_IN',do_erc=True),
            Pin(num='24',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='106',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='56',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PG6',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PG7',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PG8',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='PG9/DAC_EXTI9/FSMC_NE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='PG10/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='PG11/ADC1_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='PG12/FSMC_NE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PG13/FSMC_A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PG14/FSMC_A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PG15/ADC1_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF0/FSMC_A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF1/FSMC_A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PF2/FSMC_A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PF3/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PF4/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PF5/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF8',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF9/DAC_EXTI9',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF10',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF11/ADC1_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF15/ADC1_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE11/ADC1_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE15/ADC1_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='144',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101C8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP48 Flash: 64KB Ram: 10KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101CBTx'],pins=[
            Pin(num='10',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM4_CH1/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM4_CH2/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C2_SCL/TIM2_CH3/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2C2_SMBA/SPI2_NSS/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101C6Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP48 Flash: 32KB Ram: 6KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/TIM2_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101CBUx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: UFQFPN48 Flash: 128KB Ram: 16KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM4_CH1/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM4_CH2/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C2_SCL/TIM2_CH3/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2C2_SMBA/SPI2_NSS/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101R4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 16KB Ram: 4KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101R6Tx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='I2C1_SDA/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TIM2_CH3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/TIM2_CH4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 64KB Ram: 10KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101RBTx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/SPI2_MOSI/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101RCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 256KB Ram: 32KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101RDTx', 'STM32F101RETx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/SPI2_MOSI/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101RFTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 768KB Ram: 80KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101RGTx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM13_CH1/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM14_CH1/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='DAC_EXTI9/I2C1_SDA/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM12_CH1/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/SPI2_MOSI/TIM12_CH2/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101RBHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: TFBGA64 Flash: 128KB Ram: 16KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 50',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='G2',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='SPI2_MISO/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='ADC1_EXTI15/SPI2_MOSI/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B4',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/ADC1_EXTI11/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101T4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: VFQFPN36 Flash: 16KB Ram: 4KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 26',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101T6Ux'],pins=[
            Pin(num='7',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='35',name='BOOT0',do_erc=True),
            Pin(num='2',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='15',name='PB0/ADC1_IN8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB1/ADC1_IN9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PB6/I2C1_SCL/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PB7/I2C1_SDA/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101T8Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: VFQFPN36 Flash: 64KB Ram: 10KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 26',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101TBUx'],pins=[
            Pin(num='7',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='35',name='BOOT0',do_erc=True),
            Pin(num='2',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='15',name='PB0/ADC1_IN8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB1/ADC1_IN9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PB6/I2C1_SCL/TIM4_CH1/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PB7/I2C1_SDA/TIM4_CH2/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101V8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 64KB Ram: 10KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101VBTx'],pins=[
            Pin(num='23',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/SPI2_MOSI/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101VCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 256KB Ram: 32KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101VDTx', 'STM32F101VETx'],pins=[
            Pin(num='23',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/SPI2_MOSI/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/FSMC_D4/FSMC_DA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/FSMC_D5/FSMC_DA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/FSMC_D7/FSMC_DA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/FSMC_D8/FSMC_DA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/FSMC_D9/FSMC_DA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/FSMC_D10/FSMC_DA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/FSMC_D11/FSMC_DA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/FSMC_D12/FSMC_DA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/FSMC_NCE2/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101VFTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 768KB Ram: 80KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101VGTx'],pins=[
            Pin(num='23',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/SPI1_MISO/TIM13_CH1/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/SPI1_MOSI/TIM14_CH1/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='I2C1_SCL/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='DAC_EXTI9/I2C1_SDA/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM12_CH1/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/SPI2_MOSI/TIM12_CH2/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/FSMC_D4/FSMC_DA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/FSMC_D5/FSMC_DA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/FSMC_D7/FSMC_DA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/FSMC_D8/FSMC_DA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/FSMC_D9/FSMC_DA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/FSMC_D10/FSMC_DA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/FSMC_D11/FSMC_DA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/FSMC_D12/FSMC_DA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/FSMC_NCE2/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101ZCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP144 Flash: 256KB Ram: 32KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101ZDTx', 'STM32F101ZETx'],pins=[
            Pin(num='34',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ADC1_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='DAC_EXTI9/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='SPI2_MISO/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='ADC1_EXTI15/SPI2_MOSI/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ADC1_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='ADC1_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='ADC1_EXTI11/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='ADC1_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='NRST',do_erc=True),
            Pin(num='138',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='RCC_OSC_IN',do_erc=True),
            Pin(num='24',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='106',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='56',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PG7/FSMC_INT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PG8',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='PG11/ADC1_EXTI11/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='PG12/FSMC_NE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PG13/FSMC_A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PG14/FSMC_A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PG15/ADC1_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF0/FSMC_A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF1/FSMC_A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PF2/FSMC_A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PF3/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PF4/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PF5/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF6/FSMC_NIORD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF7/FSMC_NREG',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF8/FSMC_NIOWR',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF9/DAC_EXTI9/FSMC_CD',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF10/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF11/ADC1_EXTI11/FSMC_NIOS16',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF15/ADC1_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PE7/FSMC_D4/FSMC_DA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE8/FSMC_D5/FSMC_DA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE10/FSMC_D7/FSMC_DA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE11/ADC1_EXTI11/FSMC_D8/FSMC_DA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE12/FSMC_D9/FSMC_DA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE13/FSMC_D10/FSMC_DA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE14/FSMC_D11/FSMC_DA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE15/ADC1_EXTI15/FSMC_D12/FSMC_DA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='144',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F101ZFTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F101',description='Core: ARM Cortex-M3 Package: LQFP144 Flash: 768KB Ram: 80KB Frequency: 36MHz Voltage: 2..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F101ZGTx'],pins=[
            Pin(num='34',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ADC1_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ADC1_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN6/SPI1_MISO/TIM13_CH1/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ADC1_IN7/SPI1_MOSI/TIM14_CH1/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='DAC_EXTI9/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='ADC1_EXTI11/USART1_CTS/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='USART1_RTS/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='ADC1_EXTI15/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='I2C1_SMBA/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='I2C1_SCL/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='DAC_EXTI9/I2C1_SDA/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='SPI2_MISO/TIM12_CH1/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='ADC1_EXTI15/SPI2_MOSI/TIM12_CH2/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ADC1_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='ADC1_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='ADC1_EXTI11/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='ADC1_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='NRST',do_erc=True),
            Pin(num='138',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='RCC_OSC_IN',do_erc=True),
            Pin(num='24',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='106',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='56',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PG7/FSMC_INT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PG8',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='PG11/ADC1_EXTI11/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='PG12/FSMC_NE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PG13/FSMC_A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PG14/FSMC_A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PG15/ADC1_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF0/FSMC_A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF1/FSMC_A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PF2/FSMC_A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PF3/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PF4/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PF5/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF6/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF7/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF8/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF9/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF10/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF11/ADC1_EXTI11/FSMC_NIOS16',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF15/ADC1_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PE7/FSMC_D4/FSMC_DA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE8/FSMC_D5/FSMC_DA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE10/FSMC_D7/FSMC_DA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE11/ADC1_EXTI11/FSMC_D8/FSMC_DA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE12/FSMC_D9/FSMC_DA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE13/FSMC_D10/FSMC_DA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE14/FSMC_D11/FSMC_DA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE15/ADC1_EXTI15/FSMC_D12/FSMC_DA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='144',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F102C4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F102',description='Core: ARM Cortex-M3 Package: LQFP48 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F102C6Tx'],pins=[
            Pin(num='10',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/TIM2_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F102C8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F102',description='Core: ARM Cortex-M3 Package: LQFP48 Flash: 64KB Ram: 10KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F102CBTx'],pins=[
            Pin(num='10',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM4_CH1/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM4_CH2/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/I2C1_SCL/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/I2C1_SDA/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C2_SCL/TIM2_CH3/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2C2_SMBA/SPI2_NSS/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/SPI2_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F102R4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F102',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 16KB Ram: 4KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F102R6Tx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='I2C1_SDA/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TIM2_CH3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/TIM2_CH4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F102R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F102',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 64KB Ram: 10KB Frequency: 48MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F102RBTx'],pins=[
            Pin(num='14',name='ADC1_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/SPI1_MISO/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/SPI1_MOSI/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/SPI2_NSS/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/SPI2_MOSI/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103C4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP48 Flash: 16KB Ram: 6KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103C6Tx'],pins=[
            Pin(num='10',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/TIM2_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/ADC2_EXTI11/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/ADC2_EXTI15/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103C8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP48 Flash: 64KB Ram: 20KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103CBTx'],pins=[
            Pin(num='10',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM4_CH1/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM4_CH2/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/I2C1_SCL/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/I2C1_SDA/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C2_SCL/TIM2_CH3/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/TIM1_CH1N/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/TIM1_CH2N/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/ADC2_EXTI15/SPI2_MOSI/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103C6Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: UFQFPN48 Flash: 32KB Ram: 10KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/I2C1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/I2C1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/TIM2_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/ADC2_EXTI11/TIM2_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/ADC2_EXTI15/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103CBUx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: UFQFPN48 Flash: 128KB Ram: 20KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 37',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='10',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='44',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PB0/ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PB1/ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PB6/I2C1_SCL/TIM4_CH1/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PB7/I2C1_SDA/TIM4_CH2/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB8/CAN_RX/I2C1_SCL/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB9/CAN_TX/I2C1_SDA/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB10/I2C2_SCL/TIM2_CH3/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB11/ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB12/I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PB13/SPI2_SCK/TIM1_CH1N/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PB14/SPI2_MISO/TIM1_CH2N/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PB15/ADC1_EXTI15/ADC2_EXTI15/SPI2_MOSI/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103R4Hx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: TFBGA64 Flash: 16KB Ram: 6KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 50',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103R6Hx'],pins=[
            Pin(num='G2',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_RX/I2C1_SCL/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_TX/I2C1_SDA/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='TIM2_CH3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='ADC1_EXTI11/ADC2_EXTI11/TIM2_CH4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='TIM1_BKIN/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='TIM1_CH1N/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='TIM1_CH2N/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='ADC1_EXTI15/ADC2_EXTI15/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B4',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC1_IN10/ADC2_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC1_IN11/ADC2_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC1_IN12/ADC2_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/ADC1_EXTI11/ADC2_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103R4Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 16KB Ram: 6KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103R6Tx'],pins=[
            Pin(num='14',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN_RX/I2C1_SCL/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN_TX/I2C1_SDA/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TIM2_CH3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/ADC2_EXTI11/TIM2_CH4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TIM1_BKIN/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TIM1_CH1N/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TIM1_CH2N/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/ADC2_EXTI15/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10/ADC2_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11/ADC2_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12/ADC2_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13/ADC2_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/ADC2_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103R8Hx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: TFBGA64 Flash: 64KB Ram: 20KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 50',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103RBHx'],pins=[
            Pin(num='G2',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_RX/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_TX/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='ADC1_EXTI15/ADC2_EXTI15/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='B4',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='B5',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC0/ADC1_IN10/ADC2_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC1/ADC1_IN11/ADC2_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC2/ADC1_IN12/ADC2_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC10/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PC11/ADC1_EXTI11/ADC2_EXTI11/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PC12/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 64KB Ram: 20KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103RBTx'],pins=[
            Pin(num='14',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN_RX/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN_TX/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/ADC2_EXTI15/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10/ADC2_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11/ADC2_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12/ADC2_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13/ADC2_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/ADC2_EXTI11/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103RCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 256KB Ram: 48KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103RDTx', 'STM32F103RETx'],pins=[
            Pin(num='14',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10/ADC2_IN10/ADC3_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11/ADC2_IN11/ADC3_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12/ADC2_IN12/ADC3_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13/ADC2_IN13/ADC3_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/SDIO_D0/TIM3_CH3/TIM8_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/SDIO_D2/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/SDIO_CK/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103RDYx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: WLCSP64 Flash: 384KB Ram: 64KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 50',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103REYx'],pins=[
            Pin(num='F6',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='NRST',do_erc=True),
            Pin(num='A6',name='BOOT0',do_erc=True),
            Pin(num='C6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='D8',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='D7',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='A3',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PC0/ADC1_IN10/ADC2_IN10/ADC3_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='PC1/ADC1_IN11/ADC2_IN11/ADC3_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='PC2/ADC1_IN12/ADC2_IN12/ADC3_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='PC6/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PC7/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PC8/SDIO_D0/TIM3_CH3/TIM8_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='PC9/DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PC10/SDIO_D2/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PC11/ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PC12/SDIO_CK/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='A8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103RFTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 768KB Ram: 96KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103RGTx'],pins=[
            Pin(num='14',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10/ADC2_IN10/ADC3_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11/ADC2_IN11/ADC3_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12/ADC2_IN12/ADC3_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13/ADC2_IN13/ADC3_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/SDIO_D0/TIM3_CH3/TIM8_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/SDIO_D2/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/SDIO_CK/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103T4Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: VFQFPN36 Flash: 16KB Ram: 6KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 26',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103T6Ux'],pins=[
            Pin(num='7',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='35',name='BOOT0',do_erc=True),
            Pin(num='2',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='15',name='PB0/ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB1/ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PB6/I2C1_SCL/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PB7/I2C1_SDA/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103T8Ux',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: VFQFPN36 Flash: 64KB Ram: 20KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 26',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103TBUx'],pins=[
            Pin(num='7',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='NRST',do_erc=True),
            Pin(num='35',name='BOOT0',do_erc=True),
            Pin(num='2',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='3',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='15',name='PB0/ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PB1/ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PB2/BOOT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PB3/SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PB4/SPI1_MISO/SYS_NJTRST/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PB5/I2C1_SMBA/SPI1_MOSI/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PB6/I2C1_SCL/TIM4_CH1/USART1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PB7/I2C1_SDA/TIM4_CH2/USART1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103V8Hx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LFBGA100 Flash: 64KB Ram: 20KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103VBHx'],pins=[
            Pin(num='G2',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='CAN_RX/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='CAN_TX/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='K7',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='ADC1_EXTI15/ADC2_EXTI15/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='ADC1_IN10/ADC2_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='ADC1_IN11/ADC2_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='ADC1_IN12/ADC2_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN13/ADC2_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F10',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='ADC1_EXTI11/ADC2_EXTI11/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='D5',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='J1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='F8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='D4',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='PE9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PE11/ADC1_EXTI11/ADC2_EXTI11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='PE12/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K6',name='PE13/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='PE14/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='PE15/ADC1_EXTI15/ADC2_EXTI15/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PD0/CAN_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PD1/CAN_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J9',name='PD9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='PD11/ADC1_EXTI11/ADC2_EXTI11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='PD12/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G10',name='PD15/ADC1_EXTI15/ADC2_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103V8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 64KB Ram: 20KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103VBTx'],pins=[
            Pin(num='23',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN_RX/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN_TX/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/ADC2_EXTI15/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/ADC2_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/ADC2_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/ADC2_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/ADC2_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/ADC2_EXTI11/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/ADC2_EXTI11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/ADC2_EXTI15/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/ADC2_EXTI11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/ADC2_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103VCHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LFBGA100 Flash: 256KB Ram: 48KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103VDHx', 'STM32F103VEHx'],pins=[
            Pin(num='G2',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='K7',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F10',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='SDIO_D0/TIM3_CH3/TIM8_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='SDIO_D2/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='SDIO_CK/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='D5',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='J1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='F8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='D4',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='PE5/FSMC_A21/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PE6/FSMC_A22/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PE11/ADC1_EXTI11/ADC2_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K6',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='PE15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PD0/CAN_RX/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PD1/CAN_TX/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='PD7/FSMC_NCE2/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J9',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='PD11/ADC1_EXTI11/ADC2_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='PD12/FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G10',name='PD15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103VCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 256KB Ram: 48KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103VDTx', 'STM32F103VETx'],pins=[
            Pin(num='23',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='SDIO_D0/TIM3_CH3/TIM8_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='SDIO_D2/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='SDIO_CK/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/ADC2_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN_RX/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN_TX/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/FSMC_NCE2/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/ADC2_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103VFTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 768KB Ram: 96KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103VGTx'],pins=[
            Pin(num='23',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='SDIO_D0/TIM3_CH3/TIM8_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='SDIO_D2/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='SDIO_CK/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/ADC2_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN_RX/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN_TX/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/FSMC_NCE2/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/ADC2_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103VBIx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: UFBGA100 Flash: 128KB Ram: 20KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='L2',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC1_IN4/ADC2_IN4/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC1_IN5/ADC2_IN5/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='ADC1_EXTI15/ADC2_EXTI15/SPI1_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='SPI1_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='SPI1_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='I2C1_SMBA/SPI1_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='CAN_RX/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='CAN_TX/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='I2C2_SMBA/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='ADC1_EXTI15/ADC2_EXTI15/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC1_IN10/ADC2_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC1_IN11/ADC2_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC1_IN12/ADC2_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC1_IN13/ADC2_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='ADC1_EXTI11/ADC2_EXTI11/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='NRST',do_erc=True),
            Pin(num='A4',name='BOOT0',do_erc=True),
            Pin(num='E2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='L1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='RCC_OSC_IN',do_erc=True),
            Pin(num='G1',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='C11',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='C3',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='PE9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='PE11/ADC1_EXTI11/ADC2_EXTI11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='PE12/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='PE13/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='PE14/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='PE15/ADC1_EXTI15/ADC2_EXTI15/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='PD0/CAN_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='PD1/CAN_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PD2/TIM3_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='PD9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='PD11/ADC1_EXTI11/ADC2_EXTI11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD12/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H12',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD15/ADC1_EXTI15/ADC2_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103ZCHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LFBGA144 Flash: 256KB Ram: 48KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103ZDHx', 'STM32F103ZEHx'],pins=[
            Pin(num='J2',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G12',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='SDIO_D0/TIM3_CH3/TIM8_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='SDIO_D2/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='SDIO_CK/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='CAN_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='CAN_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='J9',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='ADC1_EXTI11/ADC2_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='ADC1_EXTI15/ADC2_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='NRST',do_erc=True),
            Pin(num='D5',name='BOOT0',do_erc=True),
            Pin(num='C2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='L1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='D1',name='RCC_OSC_IN',do_erc=True),
            Pin(num='E1',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='C11',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='K6',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H12',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PG7/FSMC_INT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='PG8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PG11/ADC1_EXTI11/ADC2_EXTI11/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PG12/FSMC_NE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='PG13/FSMC_A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PG14/FSMC_A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PG15/ADC1_EXTI15/ADC2_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PF0/FSMC_A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PF1/FSMC_A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PF2/FSMC_A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PF3/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PF4/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='PF5/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='PF6/ADC3_IN4/FSMC_NIORD',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PF7/ADC3_IN5/FSMC_NREG',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='PF8/ADC3_IN6/FSMC_NIOWR',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='PF11/ADC1_EXTI11/ADC2_EXTI11/FSMC_NIOS16',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='PF15/ADC1_EXTI15/ADC2_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PE5/FSMC_A21/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PE6/FSMC_A22/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K7',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='PE11/ADC1_EXTI11/ADC2_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='PE15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F9',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F10',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='D2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103ZCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP144 Flash: 256KB Ram: 48KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103ZDTx', 'STM32F103ZETx'],pins=[
            Pin(num='34',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='SDIO_D0/TIM3_CH3/TIM8_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='SDIO_D2/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='SDIO_CK/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='CAN_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='CAN_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/ADC2_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='ADC1_EXTI15/ADC2_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='NRST',do_erc=True),
            Pin(num='138',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='RCC_OSC_IN',do_erc=True),
            Pin(num='24',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='106',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='56',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PG7/FSMC_INT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PG8',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='PG11/ADC1_EXTI11/ADC2_EXTI11/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='PG12/FSMC_NE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PG13/FSMC_A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PG14/FSMC_A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PG15/ADC1_EXTI15/ADC2_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF0/FSMC_A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF1/FSMC_A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PF2/FSMC_A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PF3/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PF4/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PF5/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF6/ADC3_IN4/FSMC_NIORD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF7/ADC3_IN5/FSMC_NREG',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF8/ADC3_IN6/FSMC_NIOWR',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF11/ADC1_EXTI11/ADC2_EXTI11/FSMC_NIOS16',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF15/ADC1_EXTI15/ADC2_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE11/ADC1_EXTI11/ADC2_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='144',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103ZFHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LFBGA144 Flash: 768KB Ram: 96KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103ZGHx'],pins=[
            Pin(num='J2',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G12',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='SDIO_D0/TIM3_CH3/TIM8_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='SDIO_D2/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='SDIO_CK/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='CAN_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='CAN_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='J9',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='ADC1_EXTI11/ADC2_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='ADC1_EXTI15/ADC2_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='NRST',do_erc=True),
            Pin(num='D5',name='BOOT0',do_erc=True),
            Pin(num='C2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='L1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='D1',name='RCC_OSC_IN',do_erc=True),
            Pin(num='E1',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='C11',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='K6',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H12',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PG7/FSMC_INT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='PG8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='PG11/ADC1_EXTI11/ADC2_EXTI11/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PG12/FSMC_NE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='PG13/FSMC_A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PG14/FSMC_A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PG15/ADC1_EXTI15/ADC2_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PF0/FSMC_A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PF1/FSMC_A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PF2/FSMC_A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PF3/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PF4/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='PF5/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='PF6/ADC3_IN4/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PF7/ADC3_IN5/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='PF8/ADC3_IN6/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='PF11/ADC1_EXTI11/ADC2_EXTI11/FSMC_NIOS16',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='PF15/ADC1_EXTI15/ADC2_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K7',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='PE11/ADC1_EXTI11/ADC2_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='PE15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F9',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F10',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='D2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F103ZFTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F103',description='Core: ARM Cortex-M3 Package: LQFP144 Flash: 768KB Ram: 96KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F103ZGTx'],pins=[
            Pin(num='34',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/SPI1_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RCC_MCO/TIM1_CH1/USART1_CK/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='DAC_EXTI9/TIM1_CH2/USART1_TX/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TIM1_CH3/USART1_RX/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='ADC1_EXTI11/ADC2_EXTI11/CAN_RX/TIM1_CH4/USART1_CTS/USB_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='CAN_TX/TIM1_ETR/USART1_RTS/USB_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO-TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='CAN_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='CAN_TX/DAC_EXTI9/I2C1_SDA/SDIO_D5/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='SDIO_D0/TIM3_CH3/TIM8_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='DAC_EXTI9/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='SDIO_D2/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='ADC1_EXTI11/ADC2_EXTI11/SDIO_D3/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='SDIO_CK/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='CAN_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='CAN_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/ADC2_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='ADC1_EXTI15/ADC2_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='NRST',do_erc=True),
            Pin(num='138',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='RCC_OSC_IN',do_erc=True),
            Pin(num='24',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='106',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='56',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PG7/FSMC_INT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PG8',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='PG11/ADC1_EXTI11/ADC2_EXTI11/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='PG12/FSMC_NE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PG13/FSMC_A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PG14/FSMC_A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PG15/ADC1_EXTI15/ADC2_EXTI15',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF0/FSMC_A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF1/FSMC_A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PF2/FSMC_A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PF3/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PF4/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PF5/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF6/ADC3_IN4/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF7/ADC3_IN5/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF8/ADC3_IN6/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF11/ADC1_EXTI11/ADC2_EXTI11/FSMC_NIOS16',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF15/ADC1_EXTI15/ADC2_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE11/ADC1_EXTI11/ADC2_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE15/ADC1_EXTI15/ADC2_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='144',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F105R8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F105/107',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 64KB Ram: 64KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F105RBTx', 'STM32F105RCTx'],pins=[
            Pin(num='14',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/ADC2_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO/SYS_TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN1_RX/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='CAN2_TX/I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10/ADC2_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11/ADC2_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12/ADC2_IN12',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13/ADC2_IN13',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/I2S2_MCK/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/I2S3_MCK/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/I2S3_CK/SPI3_SCK/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/ADC2_EXTI11/SPI3_MISO/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/I2S3_SD/SPI3_MOSI/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F105V8Tx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F105/107',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 64KB Ram: 64KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F105VBTx', 'STM32F105VCTx'],pins=[
            Pin(num='23',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO/SYS_TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN1_RX/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='CAN2_TX/I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/ADC2_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/ADC2_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/ADC2_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/ADC2_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='I2S2_MCK/TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='I2S3_MCK/TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='I2S3_CK/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/ADC2_EXTI11/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='I2S3_SD/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/ADC2_EXTI11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/ADC2_EXTI15/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/ADC2_EXTI11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/ADC2_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F105VBHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F105/107',description='Core: ARM Cortex-M3 Package: LFBGA100 Flash: 128KB Ram: 64KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='G2',name='ADC1_IN0/ADC2_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/ADC2_IN1/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC1_IN2/ADC2_IN2/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC1_IN3/ADC2_IN3/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='RCC_MCO/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='DAC_EXTI9/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='ADC1_EXTI11/ADC2_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO/SYS_TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='CAN1_RX/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='I2C2_SCL/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='K7',name='ADC1_EXTI11/ADC2_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='CAN2_TX/I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='ADC1_IN10/ADC2_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='ADC1_IN11/ADC2_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='ADC1_IN12/ADC2_IN12/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN13/ADC2_IN13/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F10',name='I2S2_MCK/TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='I2S3_MCK/TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='I2S3_CK/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='ADC1_EXTI11/ADC2_EXTI11/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='I2S3_SD/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='D5',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='J1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='F8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='D4',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PE11/ADC1_EXTI11/ADC2_EXTI11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='PE12/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K6',name='PE13/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='PE14/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='PE15/ADC1_EXTI15/ADC2_EXTI15/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PD0/CAN1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PD1/CAN1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J9',name='PD9/DAC_EXTI9/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='PD10/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='PD11/ADC1_EXTI11/ADC2_EXTI11/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='PD12/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G10',name='PD15/ADC1_EXTI15/ADC2_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F107RBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F105/107',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 128KB Ram: 64KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F107RCTx'],pins=[
            Pin(num='14',name='ADC1_IN0/ADC2_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/ADC2_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/ADC2_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/ADC2_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='RCC_MCO/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/ADC2_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/ADC2_IN8/ETH_RXD2/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/ADC2_IN9/ETH_RXD3/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO/SYS_TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='CAN2_RX/ETH_PPS_OUT/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN1_RX/ETH_TXD3/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ETH_RX_ER/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/ADC2_EXTI11/ETH_TX_EN/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN2_RX/ETH_TXD0/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='CAN2_TX/ETH_TXD1/I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PD0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PD1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10/ADC2_IN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11/ADC2_IN11/ETH_MDC',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12/ADC2_IN12/ETH_TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13/ADC2_IN13/ETH_TX_CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/ADC2_IN14/ETH_RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/ADC2_IN15/ETH_RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/I2S2_MCK/TIM3_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/I2S3_MCK/TIM3_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/TIM3_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/TIM3_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/I2S3_CK/SPI3_SCK/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/ADC2_EXTI11/SPI3_MISO/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/I2S3_SD/SPI3_MOSI/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_OUT/RTC_TAMPER',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F107VBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F105/107',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 128KB Ram: 64KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F107VCTx'],pins=[
            Pin(num='23',name='ADC1_IN0/ADC2_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/ADC2_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/ADC2_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/ADC2_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='RCC_MCO/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/ADC2_IN8/ETH_RXD2/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/ADC2_IN9/ETH_RXD3/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO/SYS_TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='CAN2_RX/ETH_PPS_OUT/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN1_RX/ETH_TXD3/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ETH_RX_ER/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/ADC2_EXTI11/ETH_TX_EN/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='CAN2_RX/ETH_TXD0/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='CAN2_TX/ETH_TXD1/I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/ADC2_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/ADC2_IN11/ETH_MDC/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/ADC2_IN12/ETH_TXD2/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/ADC2_IN13/ETH_TX_CLK/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/ADC2_IN14/ETH_RXD0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/ADC2_IN15/ETH_RXD1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='I2S2_MCK/TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='I2S3_MCK/TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='I2S3_CK/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/ADC2_EXTI11/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='I2S3_SD/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='97',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/ADC2_EXTI11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/ADC2_EXTI15/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/ETH_CRS_DV/ETH_RX_DV/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/ETH_RXD0/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/ETH_RXD1/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/ADC2_EXTI11/ETH_RXD2/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/ETH_RXD3/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/ADC2_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F107VCHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F1 STM32F105/107',description='Core: ARM Cortex-M3 Package: LFBGA100 Flash: 256KB Ram: 64KB Frequency: 72MHz Voltage: 2..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='G2',name='ADC1_IN0/ADC2_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='ADC1_IN1/ADC2_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC1_IN2/ADC2_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='ADC1_IN3/ADC2_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/USART2_RX/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM1_BKIN/TIM3_CH1/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM1_CH1N/TIM3_CH2/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='RCC_MCO/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='DAC_EXTI9/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='ADC1_EXTI11/ADC2_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='ADC1_EXTI15/ADC2_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='ADC1_IN8/ADC2_IN8/ETH_RXD2/TIM1_CH2N/TIM3_CH3/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='ADC1_IN9/ADC2_IN9/ETH_RXD3/TIM1_CH3N/TIM3_CH4/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='I2S3_CK/SPI1_SCK/SPI3_SCK/SYS_JTDO/SYS_TRACESWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='SPI1_MISO/SPI3_MISO/SYS_NJTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='CAN2_RX/ETH_PPS_OUT/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='CAN1_RX/ETH_TXD3/I2C1_SCL/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='ETH_RX_ER/TIM2_CH3/USART3_TX/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='K7',name='ADC1_EXTI11/ADC2_EXTI11/ETH_TX_EN/TIM2_CH4/USART3_RX/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='CAN2_RX/ETH_TXD0/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='CAN2_TX/ETH_TXD1/I2S2_CK/SPI2_SCK/TIM1_CH1N/USART3_CTS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='SPI2_MISO/TIM1_CH2N/USART3_RTS/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='ADC1_EXTI15/ADC2_EXTI15/I2S2_SD/SPI2_MOSI/TIM1_CH3N/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='ADC1_IN10/ADC2_IN10/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='ADC1_IN11/ADC2_IN11/ETH_MDC/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='ADC1_IN12/ADC2_IN12/ETH_TXD2/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='ADC1_IN13/ADC2_IN13/ETH_TX_CLK/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='ADC1_IN14/ADC2_IN14/ETH_RXD0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='ADC1_IN15/ADC2_IN15/ETH_RXD1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F10',name='I2S2_MCK/TIM3_CH1/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='I2S3_MCK/TIM3_CH2/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='TIM3_CH3/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='DAC_EXTI9/TIM3_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='I2S3_CK/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='ADC1_EXTI11/ADC2_EXTI11/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='I2S3_SD/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='RTC_OUT/RTC_TAMPER/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='ADC1_EXTI15/ADC2_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='NRST',do_erc=True),
            Pin(num='D5',name='BOOT0',do_erc=True),
            Pin(num='B2',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='H1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='J1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='RCC_OSC_IN',do_erc=True),
            Pin(num='D1',name='RCC_OSC_OUT',do_erc=True),
            Pin(num='F8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='D4',name='PE0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PE2/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PE3/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PE4/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='PE5/SYS_TRACED2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PE6/SYS_TRACED3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='PE7/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='PE8/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='PE9/DAC_EXTI9/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='PE10/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='PE11/ADC1_EXTI11/ADC2_EXTI11/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='PE12/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='K6',name='PE13/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='PE14/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='PE15/ADC1_EXTI15/ADC2_EXTI15/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PD0/CAN1_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PD1/CAN1_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PD2/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='PD3/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='PD4/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='PD5/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='PD6/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='PD7/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='PD8/ETH_CRS_DV/ETH_RX_DV/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='J9',name='PD9/DAC_EXTI9/ETH_RXD0/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='PD10/ETH_RXD1/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='PD11/ADC1_EXTI11/ADC2_EXTI11/ETH_RXD2/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='PD12/ETH_RXD3/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='PD13/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='PD14/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G10',name='PD15/ADC1_EXTI15/ADC2_EXTI15/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F205RBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x5',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 128KB Ram: 64KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F205RCTx', 'STM32F205RETx', 'STM32F205RFTx', 'STM32F205RGTx'],pins=[
            Pin(num='14',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN1_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='CAN2_TX/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11/ADC2_IN11/ADC3_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12/ADC2_IN12/ADC3_IN12/SPI2_MISO/USB_OTG_HS_ULPI_DIR',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13/ADC2_IN13/ADC3_IN13/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_AF1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F205REYx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x5',description='Core: ARM Cortex-M3 Package: WLCSP66 Flash: 512KB Ram: 128KB Frequency: 120MHz Voltage: 1.7..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F205RGYx'],pins=[
            Pin(num='E7',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J9',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='DAC_EXTI9/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='CAN1_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='CAN2_TX/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='NRST',do_erc=True),
            Pin(num='B6',name='BOOT0',do_erc=True),
            Pin(num='A9',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='C8',name='IRROFF',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='H7',name='REGOFF',func=Pin.PWRIN,do_erc=True),
            Pin(num='J3',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='E9',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='F9',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='C7',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='PC0/ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='PC1/ADC1_IN11/ADC2_IN11/ADC3_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='PC2/ADC1_IN12/ADC2_IN12/ADC3_IN12/SPI2_MISO/USB_OTG_HS_ULPI_DIR',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='PC3/ADC1_IN13/ADC2_IN13/ADC3_IN13/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='PC6/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='PC7/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='PC8/SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='PC9/DAC_EXTI9/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PC10/I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PC11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PC12/I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PC13/RTC_AF1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='PC15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D9',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H9',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F205VBTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x5',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 128KB Ram: 64KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F205VCTx', 'STM32F205VETx', 'STM32F205VFTx', 'STM32F205VGTx'],pins=[
            Pin(num='23',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN1_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='CAN2_TX/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='97',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN1_RX/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN1_TX/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/FSMC_NCE2/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F205ZCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x5',description='Core: ARM Cortex-M3 Package: LQFP144 Flash: 256KB Ram: 96KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F205ZETx', 'STM32F205ZFTx', 'STM32F205ZGTx'],pins=[
            Pin(num='34',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='DAC_EXTI9/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='CAN1_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='CAN2_TX/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='DAC_EXTI9/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='CAN1_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='CAN1_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='NRST',do_erc=True),
            Pin(num='138',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='24',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='56',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PG7/FSMC_INT3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PG8/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='PG11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='PG12/FSMC_NE4/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PG13/FSMC_A24/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PG14/FSMC_A25/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PG15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF0/FSMC_A0/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF1/FSMC_A1/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PF2/FSMC_A2/I2C2_SMBA',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PF3/ADC3_IN9/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PF4/ADC3_IN14/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PF5/ADC3_IN15/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF6/ADC3_IN4/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF7/ADC3_IN5/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF8/ADC3_IN6/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='144',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F207ICHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x7',description='Core: ARM Cortex-M3 Package: UFBGA176 Flash: 256KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 140',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F207IEHx', 'STM32F207IFHx', 'STM32F207IGHx'],pins=[
            Pin(num='N3',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='N2',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P2',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='R2',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N4',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/DCMI_HSYNC/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='P4',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='P3',name='ADC1_IN6/ADC2_IN6/DCMI_PIXCK/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='R3',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F15',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E15',name='DAC_EXTI9/DCMI_D0/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D15',name='DCMI_D1/TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C15',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B15',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A15',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A14',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A13',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='R5',name='ADC1_IN8/ADC2_IN8/ETH_RXD2/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='R4',name='ADC1_IN9/ADC2_IN9/ETH_RXD3/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='CAN2_RX/DCMI_D10/ETH_PPS_OUT/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='CAN2_TX/DCMI_D5/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='DCMI_VSYNC/FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='CAN1_RX/DCMI_D6/ETH_TXD3/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='CAN1_TX/DAC_EXTI9/DCMI_D7/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='R12',name='ETH_RX_ER/I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='R13',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='P12',name='CAN2_RX/ETH_TXD0/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='P13',name='CAN2_TX/ETH_TXD1/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='R14',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='R15',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/ETH_MDC/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/ETH_TXD2/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/ETH_TX_CLK/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N5',name='ADC1_IN14/ADC2_IN14/ETH_RXD0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='P5',name='ADC1_IN15/ADC2_IN15/ETH_RXD1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='H15',name='DCMI_D0/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='G15',name='DCMI_D1/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='G14',name='DCMI_D2/SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='F14',name='DAC_EXTI9/DCMI_D3/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B14',name='DCMI_D8/I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B13',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D4/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='DCMI_D9/I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='CAN1_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='CAN1_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='DCMI_D11/SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C11',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='P15',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='P14',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='N15',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='N14',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='N13',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='M15',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='M14',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='L14',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='DCMI_D2/FSMC_NBL0/TIM4_ETR/PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='DCMI_D3/FSMC_NBL1/PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='ETH_TXD3/FSMC_A23/SYS_TRACECLK/PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='FSMC_A19/SYS_TRACED0/PE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='DCMI_D4/FSMC_A20/SYS_TRACED1/PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='DCMI_D6/FSMC_A21/SYS_TRACED2/TIM9_CH1/PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='DCMI_D7/FSMC_A22/SYS_TRACED3/TIM9_CH2/PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='R8',name='FSMC_D4/FSMC_DA4/TIM1_ETR/PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='P8',name='FSMC_D5/FSMC_DA5/TIM1_CH1N/PE8',func=Pin.BIDIR,do_erc=True),
            Pin(num='P9',name='DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1/PE9',func=Pin.BIDIR,do_erc=True),
            Pin(num='R9',name='FSMC_D7/FSMC_DA7/TIM1_CH2N/PE10',func=Pin.BIDIR,do_erc=True),
            Pin(num='P10',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2/PE11',func=Pin.BIDIR,do_erc=True),
            Pin(num='R10',name='FSMC_D9/FSMC_DA9/TIM1_CH3N/PE12',func=Pin.BIDIR,do_erc=True),
            Pin(num='N11',name='FSMC_D10/FSMC_DA10/TIM1_CH3/PE13',func=Pin.BIDIR,do_erc=True),
            Pin(num='P11',name='FSMC_D11/FSMC_DA11/TIM1_CH4/PE14',func=Pin.BIDIR,do_erc=True),
            Pin(num='R11',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN/PE15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='NRST',do_erc=True),
            Pin(num='D6',name='BOOT0',do_erc=True),
            Pin(num='C1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='C6',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='F13',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='L4',name='REGOFF',func=Pin.PWRIN,do_erc=True),
            Pin(num='M10',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='N1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='P1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='E14',name='PI0/DCMI_D13/I2S2_WS/SPI2_NSS/TIM5_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D14',name='PI1/DCMI_D8/I2S2_SCK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='C14',name='PI2/DCMI_D9/SPI2_MISO/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C13',name='PI3/DCMI_D10/I2S2_SD/SPI2_MOSI/TIM8_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PI4/DCMI_D5/TIM8_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PI5/DCMI_VSYNC/TIM8_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PI6/DCMI_D6/TIM8_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='PI7/DCMI_D7/TIM8_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PI8/RTC_AF2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='PI9/CAN1_RX/DAC_EXTI9',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PI10/ETH_RX_ER',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='PI11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/USB_OTG_HS_ULPI_DIR',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='H1',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='F4',name='PH2/ETH_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='PH3/ETH_COL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='PH4/I2C2_SCL/USB_OTG_HS_ULPI_NXT',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='PH5/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='PH6/ETH_RXD2/I2C2_SMBA/TIM12_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N12',name='PH7/ETH_RXD3/I2C3_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='PH8/DCMI_HSYNC/I2C3_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='M13',name='PH9/DAC_EXTI9/DCMI_D0/I2C3_SMBA/TIM12_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L13',name='PH10/DCMI_D1/TIM5_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='PH11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D2/TIM5_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='PH12/DCMI_D3/TIM5_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='PH13/CAN1_TX/TIM8_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='E13',name='PH14/DCMI_D4/TIM8_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='D13',name='PH15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/DCMI_D11/TIM8_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='N7',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L15',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K15',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K14',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K13',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J15',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J14',name='PG7/FSMC_INT3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='H14',name='PG8/ETH_PPS_OUT/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='PG11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PG12/FSMC_NE4/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='PG13/ETH_TXD0/FSMC_A24/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='PG14/ETH_TXD1/FSMC_A25/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PG15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/DCMI_D13/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PF0/FSMC_A0/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='PF1/FSMC_A1/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='PF2/FSMC_A2/I2C2_SMBA',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='PF3/ADC3_IN9/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='PF4/ADC3_IN14/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='PF5/ADC3_IN15/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='PF6/ADC3_IN4/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='PF7/ADC3_IN5/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='PF8/ADC3_IN6/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='R6',name='PF11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='P6',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='N6',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='R7',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='P7',name='PF15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C9',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N9',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N10',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='M8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='M9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F207ICTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x7',description='Core: ARM Cortex-M3 Package: LQFP176 Flash: 256KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 140',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F207IETx', 'STM32F207IFTx', 'STM32F207IGTx'],pins=[
            Pin(num='40',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/DCMI_HSYNC/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='ADC1_IN6/ADC2_IN6/DCMI_PIXCK/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='120',name='DAC_EXTI9/DCMI_D0/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='DCMI_D1/TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='ADC1_IN8/ADC2_IN8/ETH_RXD2/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='ADC1_IN9/ADC2_IN9/ETH_RXD3/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='CAN2_RX/DCMI_D10/ETH_PPS_OUT/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='164',name='CAN2_TX/DCMI_D5/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='165',name='DCMI_VSYNC/FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='167',name='CAN1_RX/DCMI_D6/ETH_TXD3/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='168',name='CAN1_TX/DAC_EXTI9/DCMI_D7/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ETH_RX_ER/I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='CAN2_RX/ETH_TXD0/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='CAN2_TX/ETH_TXD1/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/ETH_MDC/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/ETH_TXD2/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/ETH_TX_CLK/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_IN14/ADC2_IN14/ETH_RXD0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='ADC1_IN15/ADC2_IN15/ETH_RXD1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='DCMI_D0/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='DCMI_D1/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='DCMI_D2/SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='DAC_EXTI9/DCMI_D3/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='DCMI_D8/I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D4/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='DCMI_D9/I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='CAN1_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='CAN1_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='DCMI_D11/SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='147',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='150',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='151',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='DCMI_D2/FSMC_NBL0/TIM4_ETR/PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='DCMI_D3/FSMC_NBL1/PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='ETH_TXD3/FSMC_A23/SYS_TRACECLK/PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='FSMC_A19/SYS_TRACED0/PE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='DCMI_D4/FSMC_A20/SYS_TRACED1/PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DCMI_D6/FSMC_A21/SYS_TRACED2/TIM9_CH1/PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DCMI_D7/FSMC_A22/SYS_TRACED3/TIM9_CH2/PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='FSMC_D4/FSMC_DA4/TIM1_ETR/PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='FSMC_D5/FSMC_DA5/TIM1_CH1N/PE8',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1/PE9',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='FSMC_D7/FSMC_DA7/TIM1_CH2N/PE10',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2/PE11',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='FSMC_D9/FSMC_DA9/TIM1_CH3N/PE12',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='FSMC_D10/FSMC_DA10/TIM1_CH3/PE13',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D11/FSMC_DA11/TIM1_CH4/PE14',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN/PE15',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='NRST',do_erc=True),
            Pin(num='166',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='125',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='171',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='PI0/DCMI_D13/I2S2_WS/SPI2_NSS/TIM5_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PI1/DCMI_D8/I2S2_SCK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='PI2/DCMI_D9/SPI2_MISO/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='PI3/DCMI_D10/I2S2_SD/SPI2_MOSI/TIM8_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='PI4/DCMI_D5/TIM8_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='PI5/DCMI_VSYNC/TIM8_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='PI6/DCMI_D6/TIM8_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='PI7/DCMI_D7/TIM8_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PI8/RTC_AF2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PI9/CAN1_RX/DAC_EXTI9',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PI10/ETH_RX_ER',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PI11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/USB_OTG_HS_ULPI_DIR',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='30',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='43',name='PH2/ETH_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PH3/ETH_COL',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PH4/I2C2_SCL/USB_OTG_HS_ULPI_NXT',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PH5/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PH6/ETH_RXD2/I2C2_SMBA/TIM12_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PH7/ETH_RXD3/I2C3_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PH8/DCMI_HSYNC/I2C3_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PH9/DAC_EXTI9/DCMI_D0/I2C3_SMBA/TIM12_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PH10/DCMI_D1/TIM5_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PH11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D2/TIM5_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PH12/DCMI_D3/TIM5_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PH13/CAN1_TX/TIM8_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PH14/DCMI_D4/TIM8_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='PH15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/DCMI_D11/TIM8_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='106',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='PG7/FSMC_INT3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='PG8/ETH_PPS_OUT/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='152',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='153',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='154',name='PG11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='155',name='PG12/FSMC_NE4/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='PG13/ETH_TXD0/FSMC_A24/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='157',name='PG14/ETH_TXD1/FSMC_A25/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='PG15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/DCMI_D13/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PF0/FSMC_A0/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PF1/FSMC_A1/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF2/FSMC_A2/I2C2_SMBA',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF3/ADC3_IN9/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF4/ADC3_IN14/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF5/ADC3_IN15/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PF6/ADC3_IN4/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PF7/ADC3_IN5/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PF8/ADC3_IN6/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PF11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PF15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='103',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='114',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='127',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='136',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='149',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='159',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='172',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='90',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='102',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='113',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='126',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='135',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='148',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='158',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F207VCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x7',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 256KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F207VETx', 'STM32F207VFTx', 'STM32F207VGTx'],pins=[
            Pin(num='23',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/DCMI_HSYNC/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/ADC2_IN6/DCMI_PIXCK/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/DCMI_D0/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='DCMI_D1/TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/ADC2_IN8/ETH_RXD2/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/ADC2_IN9/ETH_RXD3/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='CAN2_RX/DCMI_D10/ETH_PPS_OUT/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='CAN2_TX/DCMI_D5/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='DCMI_VSYNC/FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN1_RX/DCMI_D6/ETH_TXD3/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN1_TX/DAC_EXTI9/DCMI_D7/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ETH_RX_ER/I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='CAN2_RX/ETH_TXD0/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='CAN2_TX/ETH_TXD1/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/ETH_MDC/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/ETH_TXD2/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/ETH_TX_CLK/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/ADC2_IN14/ETH_RXD0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/ADC2_IN15/ETH_RXD1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='DCMI_D0/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='DCMI_D1/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='DCMI_D2/SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/DCMI_D3/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DCMI_D8/I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D4/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='DCMI_D9/I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='97',name='PE0/DCMI_D2/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/DCMI_D3/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/ETH_TXD3/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/DCMI_D4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/DCMI_D6/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/DCMI_D7/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN1_RX/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN1_TX/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/DCMI_D11/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/FSMC_NCE2/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F207ZCTx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x7',description='Core: ARM Cortex-M3 Package: LQFP144 Flash: 256KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F207ZETx', 'STM32F207ZFTx', 'STM32F207ZGTx'],pins=[
            Pin(num='34',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/DCMI_HSYNC/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN6/ADC2_IN6/DCMI_PIXCK/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='DAC_EXTI9/DCMI_D0/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='DCMI_D1/TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='ADC1_IN8/ADC2_IN8/ETH_RXD2/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN9/ADC2_IN9/ETH_RXD3/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='CAN2_RX/DCMI_D10/ETH_PPS_OUT/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='CAN2_TX/DCMI_D5/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='DCMI_VSYNC/FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='CAN1_RX/DCMI_D6/ETH_TXD3/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='CAN1_TX/DAC_EXTI9/DCMI_D7/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='ETH_RX_ER/I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='CAN2_RX/ETH_TXD0/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='CAN2_TX/ETH_TXD1/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/ETH_MDC/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/ETH_TXD2/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/ETH_TX_CLK/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_IN14/ADC2_IN14/ETH_RXD0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='ADC1_IN15/ADC2_IN15/ETH_RXD1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='DCMI_D0/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='DCMI_D1/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='DCMI_D2/SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='DAC_EXTI9/DCMI_D3/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='DCMI_D8/I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D4/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='DCMI_D9/I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='CAN1_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='CAN1_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='DCMI_D11/SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='NRST',do_erc=True),
            Pin(num='138',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='24',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='56',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PG7/FSMC_INT3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PG8/ETH_PPS_OUT/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='PG11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='PG12/FSMC_NE4/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PG13/ETH_TXD0/FSMC_A24/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PG14/ETH_TXD1/FSMC_A25/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PG15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/DCMI_D13/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF0/FSMC_A0/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF1/FSMC_A1/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PF2/FSMC_A2/I2C2_SMBA',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PF3/ADC3_IN9/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PF4/ADC3_IN14/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PF5/ADC3_IN15/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF6/ADC3_IN4/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF7/ADC3_IN5/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF8/ADC3_IN6/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='PE0/DCMI_D2/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='PE1/DCMI_D3/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/ETH_TXD3/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/DCMI_D4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/DCMI_D6/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/DCMI_D7/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='144',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F215RETx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x5',description='Core: ARM Cortex-M3 Package: LQFP64 Flash: 512KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 51',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F215RGTx'],pins=[
            Pin(num='14',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DAC_EXTI9/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='CAN1_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='CAN2_TX/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NRST',do_erc=True),
            Pin(num='60',name='BOOT0',do_erc=True),
            Pin(num='1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='6',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='54',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PC0/ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PC1/ADC1_IN11/ADC2_IN11/ADC3_IN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC2/ADC1_IN12/ADC2_IN12/ADC3_IN12/SPI2_MISO/USB_OTG_HS_ULPI_DIR',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PC3/ADC1_IN13/ADC2_IN13/ADC3_IN13/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC4/ADC1_IN14/ADC2_IN14',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC5/ADC1_IN15/ADC2_IN15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PC6/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PC7/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PC8/SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PC9/DAC_EXTI9/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PC10/I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PC11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PC12/I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PC13/RTC_AF1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PC14/RCC_OSC32_IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PC15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F215VETx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x5',description='Core: ARM Cortex-M3 Package: LQFP100 Flash: 512KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 82',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F215VGTx'],pins=[
            Pin(num='23',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='DAC_EXTI9/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='CAN1_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='CAN2_TX/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='DAC_EXTI9/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='NRST',do_erc=True),
            Pin(num='94',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='13',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='97',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PE11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PE15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PD0/CAN1_RX/FSMC_D2/FSMC_DA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PD1/CAN1_TX/FSMC_D3/FSMC_DA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PD2/SDIO_CMD/TIM3_ETR/UART5_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PD3/FSMC_CLK/USART2_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PD4/FSMC_NOE/USART2_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='PD5/FSMC_NWE/USART2_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PD6/FSMC_NWAIT/USART2_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PD7/FSMC_NCE2/FSMC_NE1/USART2_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PD8/FSMC_D13/FSMC_DA13/USART3_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PD9/DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PD10/FSMC_D15/FSMC_DA15/USART3_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PD11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PD12/FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PD13/FSMC_A18/TIM4_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PD14/FSMC_D0/FSMC_DA0/TIM4_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PD15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F215ZETx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x5',description='Core: ARM Cortex-M3 Package: LQFP144 Flash: 512KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 114',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F215ZGTx'],pins=[
            Pin(num='34',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN6/ADC2_IN6/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ADC1_IN7/ADC2_IN7/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='DAC_EXTI9/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='ADC1_IN8/ADC2_IN8/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN9/ADC2_IN9/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='CAN2_RX/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='CAN2_TX/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='CAN1_RX/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='CAN1_TX/DAC_EXTI9/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='CAN2_RX/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='CAN2_TX/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='ADC1_IN14/ADC2_IN14/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='ADC1_IN15/ADC2_IN15/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='DAC_EXTI9/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='CAN1_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='CAN1_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='NRST',do_erc=True),
            Pin(num='138',name='BOOT0',do_erc=True),
            Pin(num='6',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='24',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='56',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PG7/FSMC_INT3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PG8/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='PG11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='PG12/FSMC_NE4/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='PG13/FSMC_A24/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='PG14/FSMC_A25/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='PG15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PF0/FSMC_A0/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='PF1/FSMC_A1/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PF2/FSMC_A2/I2C2_SMBA',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PF3/ADC3_IN9/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PF4/ADC3_IN14/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PF5/ADC3_IN15/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PF6/ADC3_IN4/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PF7/ADC3_IN5/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PF8/ADC3_IN6/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PF11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PF15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='PE0/FSMC_NBL0/TIM4_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='PE1/FSMC_NBL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='PE2/FSMC_A23/SYS_TRACECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PE3/FSMC_A19/SYS_TRACED0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PE4/FSMC_A20/SYS_TRACED1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PE5/FSMC_A21/SYS_TRACED2/TIM9_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PE6/FSMC_A22/SYS_TRACED3/TIM9_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PE7/FSMC_D4/FSMC_DA4/TIM1_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PE8/FSMC_D5/FSMC_DA5/TIM1_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PE9/DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE10/FSMC_D7/FSMC_DA7/TIM1_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE12/FSMC_D9/FSMC_DA9/TIM1_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE13/FSMC_D10/FSMC_DA10/TIM1_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE14/FSMC_D11/FSMC_DA11/TIM1_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='144',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F217IEHx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x7',description='Core: ARM Cortex-M3 Package: UFBGA176 Flash: 512KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 140',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F217IGHx'],pins=[
            Pin(num='N3',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='N2',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P2',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='R2',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N4',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/DCMI_HSYNC/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='P4',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='P3',name='ADC1_IN6/ADC2_IN6/DCMI_PIXCK/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='R3',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F15',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF/PA8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E15',name='DAC_EXTI9/DCMI_D0/I2C3_SMBA/TIM1_CH2/USART1_TX/USB_OTG_FS_VBUS/PA9',func=Pin.BIDIR,do_erc=True),
            Pin(num='D15',name='DCMI_D1/TIM1_CH3/USART1_RX/USB_OTG_FS_ID/PA10',func=Pin.BIDIR,do_erc=True),
            Pin(num='C15',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/CAN1_RX/TIM1_CH4/USART1_CTS/USB_OTG_FS_DM/PA11',func=Pin.BIDIR,do_erc=True),
            Pin(num='B15',name='CAN1_TX/TIM1_ETR/USART1_RTS/USB_OTG_FS_DP/PA12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A15',name='SYS_JTMS-SWDIO/PA13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A14',name='SYS_JTCK-SWCLK/PA14',func=Pin.BIDIR,do_erc=True),
            Pin(num='A13',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S3_WS/SPI1_NSS/SPI3_NSS/SYS_JTDI/TIM2_CH1/TIM2_ETR/PA15',func=Pin.BIDIR,do_erc=True),
            Pin(num='R5',name='ADC1_IN8/ADC2_IN8/ETH_RXD2/TIM1_CH2N/TIM3_CH3/TIM8_CH2N/USB_OTG_HS_ULPI_D1/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='R4',name='ADC1_IN9/ADC2_IN9/ETH_RXD3/TIM1_CH3N/TIM3_CH4/TIM8_CH3N/USB_OTG_HS_ULPI_D2/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='BOOT1/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='I2S3_SCK/SPI1_SCK/SPI3_SCK/SYS_JTDO-SWO/TIM2_CH2/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='SPI1_MISO/SPI3_MISO/SYS_JTRST/TIM3_CH1/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='CAN2_RX/DCMI_D10/ETH_PPS_OUT/I2C1_SMBA/I2S3_SD/SPI1_MOSI/SPI3_MOSI/TIM3_CH2/USB_OTG_HS_ULPI_D7/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='CAN2_TX/DCMI_D5/I2C1_SCL/TIM4_CH1/USART1_TX/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='DCMI_VSYNC/FSMC_NL/I2C1_SDA/TIM4_CH2/USART1_RX/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='CAN1_RX/DCMI_D6/ETH_TXD3/I2C1_SCL/SDIO_D4/TIM10_CH1/TIM4_CH3/PB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='CAN1_TX/DAC_EXTI9/DCMI_D7/I2C1_SDA/I2S2_WS/SDIO_D5/SPI2_NSS/TIM11_CH1/TIM4_CH4/PB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='R12',name='ETH_RX_ER/I2C2_SCL/I2S2_SCK/SPI2_SCK/TIM2_CH3/USART3_TX/USB_OTG_HS_ULPI_D3/PB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='R13',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/I2C2_SDA/TIM2_CH4/USART3_RX/USB_OTG_HS_ULPI_D4/PB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='P12',name='CAN2_RX/ETH_TXD0/I2C2_SMBA/I2S2_WS/SPI2_NSS/TIM1_BKIN/USART3_CK/USB_OTG_HS_ID/USB_OTG_HS_ULPI_D5/PB12',func=Pin.BIDIR,do_erc=True),
            Pin(num='P13',name='CAN2_TX/ETH_TXD1/I2S2_SCK/SPI2_SCK/TIM1_CH1N/USART3_CTS/USB_OTG_HS_ULPI_D6/USB_OTG_HS_VBUS/PB13',func=Pin.BIDIR,do_erc=True),
            Pin(num='R14',name='SPI2_MISO/TIM12_CH1/TIM1_CH2N/TIM8_CH2N/USART3_RTS/USB_OTG_HS_DM/PB14',func=Pin.BIDIR,do_erc=True),
            Pin(num='R15',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/I2S2_SD/RTC_REFIN/SPI2_MOSI/TIM12_CH2/TIM1_CH3N/TIM8_CH3N/USB_OTG_HS_DP/PB15',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='ADC1_IN10/ADC2_IN10/ADC3_IN10/USB_OTG_HS_ULPI_STP/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='ADC1_IN11/ADC2_IN11/ADC3_IN11/ETH_MDC/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='ADC1_IN12/ADC2_IN12/ADC3_IN12/ETH_TXD2/SPI2_MISO/USB_OTG_HS_ULPI_DIR/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='ADC1_IN13/ADC2_IN13/ADC3_IN13/ETH_TX_CLK/I2S2_SD/SPI2_MOSI/USB_OTG_HS_ULPI_NXT/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N5',name='ADC1_IN14/ADC2_IN14/ETH_RXD0/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='P5',name='ADC1_IN15/ADC2_IN15/ETH_RXD1/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='H15',name='DCMI_D0/I2S2_MCK/SDIO_D6/TIM3_CH1/TIM8_CH1/USART6_TX/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='G15',name='DCMI_D1/I2S3_MCK/SDIO_D7/TIM3_CH2/TIM8_CH2/USART6_RX/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='G14',name='DCMI_D2/SDIO_D0/TIM3_CH3/TIM8_CH3/USART6_CK/PC8',func=Pin.BIDIR,do_erc=True),
            Pin(num='F14',name='DAC_EXTI9/DCMI_D3/I2C3_SDA/I2S_CKIN/RCC_MCO_2/SDIO_D1/TIM3_CH4/TIM8_CH4/PC9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B14',name='DCMI_D8/I2S3_SCK/SDIO_D2/SPI3_SCK/UART4_TX/USART3_TX/PC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B13',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D4/SDIO_D3/SPI3_MISO/UART4_RX/USART3_RX/PC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='DCMI_D9/I2S3_SD/SDIO_CK/SPI3_MOSI/UART5_TX/USART3_CK/PC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='RTC_AF1/PC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='RCC_OSC32_IN/PC14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/RCC_OSC32_OUT/PC15',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='CAN1_RX/FSMC_D2/FSMC_DA2/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='CAN1_TX/FSMC_D3/FSMC_DA3/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='DCMI_D11/SDIO_CMD/TIM3_ETR/UART5_RX/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='FSMC_CLK/USART2_CTS/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='FSMC_NOE/USART2_RTS/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C11',name='FSMC_NWE/USART2_TX/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='FSMC_NWAIT/USART2_RX/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='FSMC_NCE2/FSMC_NE1/USART2_CK/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='P15',name='FSMC_D13/FSMC_DA13/USART3_TX/PD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='P14',name='DAC_EXTI9/FSMC_D14/FSMC_DA14/USART3_RX/PD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='N15',name='FSMC_D15/FSMC_DA15/USART3_CK/PD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='N14',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_A16/FSMC_CLE/USART3_CTS/PD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='N13',name='FSMC_A17/FSMC_ALE/TIM4_CH1/USART3_RTS/PD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='M15',name='FSMC_A18/TIM4_CH2/PD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='M14',name='FSMC_D0/FSMC_DA0/TIM4_CH3/PD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='L14',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D1/FSMC_DA1/TIM4_CH4/PD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='DCMI_D2/FSMC_NBL0/TIM4_ETR/PE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='DCMI_D3/FSMC_NBL1/PE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='ETH_TXD3/FSMC_A23/SYS_TRACECLK/PE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='FSMC_A19/SYS_TRACED0/PE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='DCMI_D4/FSMC_A20/SYS_TRACED1/PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='DCMI_D6/FSMC_A21/SYS_TRACED2/TIM9_CH1/PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='DCMI_D7/FSMC_A22/SYS_TRACED3/TIM9_CH2/PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='R8',name='FSMC_D4/FSMC_DA4/TIM1_ETR/PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='P8',name='FSMC_D5/FSMC_DA5/TIM1_CH1N/PE8',func=Pin.BIDIR,do_erc=True),
            Pin(num='P9',name='DAC_EXTI9/FSMC_D6/FSMC_DA6/TIM1_CH1/PE9',func=Pin.BIDIR,do_erc=True),
            Pin(num='R9',name='FSMC_D7/FSMC_DA7/TIM1_CH2N/PE10',func=Pin.BIDIR,do_erc=True),
            Pin(num='P10',name='ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/FSMC_D8/FSMC_DA8/TIM1_CH2/PE11',func=Pin.BIDIR,do_erc=True),
            Pin(num='R10',name='FSMC_D9/FSMC_DA9/TIM1_CH3N/PE12',func=Pin.BIDIR,do_erc=True),
            Pin(num='N11',name='FSMC_D10/FSMC_DA10/TIM1_CH3/PE13',func=Pin.BIDIR,do_erc=True),
            Pin(num='P11',name='FSMC_D11/FSMC_DA11/TIM1_CH4/PE14',func=Pin.BIDIR,do_erc=True),
            Pin(num='R11',name='ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_D12/FSMC_DA12/TIM1_BKIN/PE15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='NRST',do_erc=True),
            Pin(num='D6',name='BOOT0',do_erc=True),
            Pin(num='C1',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='C6',name='RFU',func=Pin.PWRIN,do_erc=True),
            Pin(num='F13',name='VCAP_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='L4',name='REGOFF',func=Pin.PWRIN,do_erc=True),
            Pin(num='M10',name='VCAP_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='N1',name='VREF-',func=Pin.PWRIN,do_erc=True),
            Pin(num='P1',name='VREF+',func=Pin.PWRIN,do_erc=True),
            Pin(num='E14',name='PI0/DCMI_D13/I2S2_WS/SPI2_NSS/TIM5_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D14',name='PI1/DCMI_D8/I2S2_SCK/SPI2_SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='C14',name='PI2/DCMI_D9/SPI2_MISO/TIM8_CH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C13',name='PI3/DCMI_D10/I2S2_SD/SPI2_MOSI/TIM8_ETR',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PI4/DCMI_D5/TIM8_BKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PI5/DCMI_VSYNC/TIM8_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='PI6/DCMI_D6/TIM8_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='PI7/DCMI_D7/TIM8_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PI8/RTC_AF2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='PI9/CAN1_RX/DAC_EXTI9',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='PI10/ETH_RX_ER',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='PI11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/USB_OTG_HS_ULPI_DIR',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='PH0/RCC_OSC_IN',do_erc=True),
            Pin(num='H1',name='PH1/RCC_OSC_OUT',do_erc=True),
            Pin(num='F4',name='PH2/ETH_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='PH3/ETH_COL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='PH4/I2C2_SCL/USB_OTG_HS_ULPI_NXT',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='PH5/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='PH6/ETH_RXD2/I2C2_SMBA/TIM12_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N12',name='PH7/ETH_RXD3/I2C3_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='PH8/DCMI_HSYNC/I2C3_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='M13',name='PH9/DAC_EXTI9/DCMI_D0/I2C3_SMBA/TIM12_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L13',name='PH10/DCMI_D1/TIM5_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='PH11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D2/TIM5_CH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='PH12/DCMI_D3/TIM5_CH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='PH13/CAN1_TX/TIM8_CH1N',func=Pin.BIDIR,do_erc=True),
            Pin(num='E13',name='PH14/DCMI_D4/TIM8_CH2N',func=Pin.BIDIR,do_erc=True),
            Pin(num='D13',name='PH15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/DCMI_D11/TIM8_CH3N',func=Pin.BIDIR,do_erc=True),
            Pin(num='N7',name='PG0/FSMC_A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='PG1/FSMC_A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='L15',name='PG2/FSMC_A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K15',name='PG3/FSMC_A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K14',name='PG4/FSMC_A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='K13',name='PG5/FSMC_A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='J15',name='PG6/FSMC_INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J14',name='PG7/FSMC_INT3/USART6_CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='H14',name='PG8/ETH_PPS_OUT/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='PG9/DAC_EXTI9/FSMC_NCE3/FSMC_NE2/USART6_RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='PG10/FSMC_NCE4_1/FSMC_NE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='PG11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/ETH_TX_EN/FSMC_NCE4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='PG12/FSMC_NE4/USART6_RTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='PG13/ETH_TXD0/FSMC_A24/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='PG14/ETH_TXD1/FSMC_A25/USART6_TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='PG15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/DCMI_D13/USART6_CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='PF0/FSMC_A0/I2C2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='PF1/FSMC_A1/I2C2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='PF2/FSMC_A2/I2C2_SMBA',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='PF3/ADC3_IN9/FSMC_A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='PF4/ADC3_IN14/FSMC_A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='PF5/ADC3_IN15/FSMC_A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='PF6/ADC3_IN4/FSMC_NIORD/TIM10_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='PF7/ADC3_IN5/FSMC_NREG/TIM11_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='PF8/ADC3_IN6/FSMC_NIOWR/TIM13_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='PF9/ADC3_IN7/DAC_EXTI9/FSMC_CD/TIM14_CH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='PF10/ADC3_IN8/FSMC_INTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='R6',name='PF11/ADC1_EXTI11/ADC2_EXTI11/ADC3_EXTI11/DCMI_D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='P6',name='PF12/FSMC_A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='N6',name='PF13/FSMC_A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='R7',name='PF14/FSMC_A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='P7',name='PF15/ADC1_EXTI15/ADC2_EXTI15/ADC3_EXTI15/FSMC_A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C9',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N9',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N10',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R1',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='K10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='M8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='M9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='VSSA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STM32F217IETx',dest=TEMPLATE,tool=SKIDL,keywords='ARM Cortex-M3 STM32F2 STM32F2x7',description='Core: ARM Cortex-M3 Package: LQFP176 Flash: 512KB Ram: 128KB Frequency: 120MHz Voltage: 1.8..3.6V IO-pins: 140',ref_prefix='U',num_units=1,do_erc=True,aliases=['STM32F217IGTx'],pins=[
            Pin(num='40',name='ADC1_IN0/ADC2_IN0/ADC3_IN0/ETH_CRS/SYS_WKUP/TIM2_CH1/TIM2_ETR/TIM5_CH1/TIM8_ETR/UART4_TX/USART2_CTS/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ADC1_IN1/ADC2_IN1/ADC3_IN1/ETH_REF_CLK/ETH_RX_CLK/TIM2_CH2/TIM5_CH2/UART4_RX/USART2_RTS/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='ADC1_IN2/ADC2_IN2/ADC3_IN2/ETH_MDIO/TIM2_CH3/TIM5_CH3/TIM9_CH1/USART2_TX/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='ADC1_IN3/ADC2_IN3/ADC3_IN3/ETH_COL/TIM2_CH4/TIM5_CH4/TIM9_CH2/USART2_RX/USB_OTG_HS_ULPI_D0/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='ADC1_IN4/ADC2_IN4/DAC_OUT1/DCMI_HSYNC/I2S3_WS/SPI1_NSS/SPI3_NSS/USART2_CK/USB_OTG_HS_SOF/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='ADC1_IN5/ADC2_IN5/DAC_OUT2/SPI1_SCK/TIM2_CH1/TIM2_ETR/TIM8_CH1N/USB_OTG_HS_ULPI_CK/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='ADC1_IN6/ADC2_IN6/DCMI_PIXCK/SPI1_MISO/TIM13_CH1/TIM1_BKIN/TIM3_CH1/TIM8_BKIN/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='ADC1_IN7/ADC2_IN7/ETH_CRS_DV/ETH_RX_DV/SPI1_MOSI/TIM14_CH1/TIM1_CH1N/TIM3_CH2/TIM8_CH1N/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='I2C3_SCL/RCC_MCO_1/TIM1_CH1/USART1_CK/USB_OTG_FS_SOF