from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

digital_audio = SchLib(tool=SKIDL).add_parts(*[
        Part(name='AK5392VS',dest=TEMPLATE,tool=SKIDL,keywords='24bit Sigma Delta Audio ADC 2ch',description='AK5392-VS, Enhanced Audio ADC, 2 channels Sigma Delta, 24bit, SO28',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='VREFL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GNDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCOML',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='AINL+',do_erc=True),
            Pin(num='5',name='AINL-',do_erc=True),
            Pin(num='6',name='ZCAL',do_erc=True),
            Pin(num='7',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='CAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~RST~',do_erc=True),
            Pin(num='20',name='TEST',do_erc=True),
            Pin(num='11',name='SMODE2',do_erc=True),
            Pin(num='21',name='BGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='SMODE1',do_erc=True),
            Pin(num='22',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='LRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AINR-',do_erc=True),
            Pin(num='15',name='SDATA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='AINR+',do_erc=True),
            Pin(num='16',name='FSYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCOMR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='CLK',do_erc=True),
            Pin(num='27',name='GNDR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='CMODE',do_erc=True),
            Pin(num='28',name='VREFR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='HPFE',do_erc=True)]),
        Part(name='AK5393VS',dest=TEMPLATE,tool=SKIDL,keywords='96kHz 24bit Sigma Delta Audio ADC 2ch',description='Enhanced Audio ADC, 2 channels Sigma Delta, 24bit 96kHz, SO28',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='VREFL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GNDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCOML',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='AINL+',do_erc=True),
            Pin(num='5',name='AINL-',do_erc=True),
            Pin(num='6',name='ZCAL',do_erc=True),
            Pin(num='7',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='CAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~RST~',do_erc=True),
            Pin(num='20',name='TEST',do_erc=True),
            Pin(num='11',name='SMODE2',do_erc=True),
            Pin(num='21',name='BGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='SMODE1',do_erc=True),
            Pin(num='22',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='LRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AINR-',do_erc=True),
            Pin(num='15',name='SDATA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='AINR+',do_erc=True),
            Pin(num='16',name='FSYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCOMR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='MCLK',do_erc=True),
            Pin(num='27',name='GNDR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='DFS',do_erc=True),
            Pin(num='28',name='VREFR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='HPFE',do_erc=True)]),
        Part(name='AK5394AVS',dest=TEMPLATE,tool=SKIDL,keywords='192kHz 24bit Sigma Delta Audio ADC 2ch',description='Super High Performance Audio ADC, 2 channels Sigma Delta, 24bit 192kHz, SO28',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='VREFL+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VREFL-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VCOML',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='AINL+',do_erc=True),
            Pin(num='5',name='AINL-',do_erc=True),
            Pin(num='6',name='ZCAL',do_erc=True),
            Pin(num='7',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='CAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~RST~',do_erc=True),
            Pin(num='20',name='DFS1',do_erc=True),
            Pin(num='11',name='SMODE2',do_erc=True),
            Pin(num='21',name='BGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='SMODE1',do_erc=True),
            Pin(num='22',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='LRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AINR-',do_erc=True),
            Pin(num='15',name='SDATA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='AINR+',do_erc=True),
            Pin(num='16',name='FSYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCOMR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='MCLK',do_erc=True),
            Pin(num='27',name='VREFR-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='DFS0',do_erc=True),
            Pin(num='28',name='VREFR+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='HPFE',do_erc=True)]),
        Part(name='CS4245',dest=TEMPLATE,tool=SKIDL,keywords='CS4245 stereo audio codec',description='Stereo Audio CODEC, 104 dB, 24-Bit, 192 kHz',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA/CDOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SCL/CCLK',do_erc=True),
            Pin(num='3',name='AD0/~CS',do_erc=True),
            Pin(num='4',name='AD1/CDIN',do_erc=True),
            Pin(num='5',name='VLC',do_erc=True),
            Pin(num='6',name='~RESET',do_erc=True),
            Pin(num='7',name='AIN3A',do_erc=True),
            Pin(num='8',name='AIN3B',do_erc=True),
            Pin(num='9',name='AIN2A',do_erc=True),
            Pin(num='10',name='AIN2B',do_erc=True),
            Pin(num='20',name='FILT2+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='MCLK2',do_erc=True),
            Pin(num='11',name='AIN1A',do_erc=True),
            Pin(num='21',name='AIN4A/MICIN1',do_erc=True),
            Pin(num='31',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='SDOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='AIN1B',do_erc=True),
            Pin(num='22',name='AIN4B/MICIN2',do_erc=True),
            Pin(num='32',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='SCLK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='AIN5A',do_erc=True),
            Pin(num='33',name='AOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='LRCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='AIN5B',do_erc=True),
            Pin(num='34',name='AOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='MCLK1',do_erc=True),
            Pin(num='15',name='AFILTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='MICBIAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='~MUTEC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='AFILTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='AIN6A',do_erc=True),
            Pin(num='36',name='VLS',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VQ1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='AIN6B',do_erc=True),
            Pin(num='37',name='SDIN',do_erc=True),
            Pin(num='47',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='VQ2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='AUXOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='SCLK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='OVFL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='FILT1+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='AUXOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='LRCK2',func=Pin.BIDIR,do_erc=True)]),
        Part(name='CS43L21',dest=TEMPLATE,tool=SKIDL,keywords='stereo audio dac',description='Stereo Audio DAC, 24-bit, 96 kHz, 98 dB',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='LRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SDA/MCLKDIV2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SCL/CCLK/I2S/~LJ',do_erc=True),
            Pin(num='4',name='AD0/~CS~/DEM',do_erc=True),
            Pin(num='5',name='VA_HP',do_erc=True),
            Pin(num='6',name='FLYP',do_erc=True),
            Pin(num='7',name='GND_HP',do_erc=True),
            Pin(num='8',name='FLYN',do_erc=True),
            Pin(num='9',name='VSS_HP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='AOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='MCLK',do_erc=True),
            Pin(num='11',name='AOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='31',name='SCLK',do_erc=True),
            Pin(num='12',name='VA',do_erc=True),
            Pin(num='32',name='SDIN',do_erc=True),
            Pin(num='13',name='AGND',do_erc=True),
            Pin(num='14',name='FILT+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='VQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='~RESET',do_erc=True),
            Pin(num='26',name='VL',do_erc=True),
            Pin(num='27',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='TESTO/M/~S',do_erc=True)]),
        Part(name='CS5361',dest=TEMPLATE,tool=SKIDL,keywords='stereo audio adc',description='Stereo Audio ADC, 24 bits, 192 kHz, 114 dB',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='RST',do_erc=True),
            Pin(num='2',name='M/~S',do_erc=True),
            Pin(num='3',name='LRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='MCLK',do_erc=True),
            Pin(num='6',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VL',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='SDOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='MDIV',do_erc=True),
            Pin(num='20',name='AINR-',do_erc=True),
            Pin(num='11',name='~HPF',do_erc=True),
            Pin(num='21',name='AINR+',do_erc=True),
            Pin(num='12',name='I2S/~LJ',do_erc=True),
            Pin(num='22',name='VQ',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='M0',do_erc=True),
            Pin(num='23',name='REFGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='M1',do_erc=True),
            Pin(num='24',name='FILT+',func=Pin.PWROUT,do_erc=True),
            Pin(num='15',name='~OVFL',do_erc=True),
            Pin(num='16',name='AINL+',do_erc=True),
            Pin(num='17',name='AINL-',do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='CS8406',dest=TEMPLATE,tool=SKIDL,keywords='digital audio interface transmitter spdif',description='192 kHz Digital Audio Interface Transmitter (SOIC-28)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~RST',do_erc=True),
            Pin(num='21',name='OMCK',do_erc=True),
            Pin(num='12',name='ILRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='ISCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VL',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='SDIN',do_erc=True),
            Pin(num='24',name='H/~S',do_erc=True),
            Pin(num='25',name='TXN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='TXP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='1',name='COPY/C',do_erc=True),
            Pin(num='3',name='~EMPH',do_erc=True),
            Pin(num='4',name='SFMT0',do_erc=True),
            Pin(num='5',name='SFMT1',do_erc=True),
            Pin(num='10',name='APMS',do_erc=True),
            Pin(num='20',name='HWCK0',do_erc=True),
            Pin(num='11',name='TCBLD',do_erc=True),
            Pin(num='15',name='TCBL',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='CEN',do_erc=True),
            Pin(num='17',name='U',do_erc=True),
            Pin(num='27',name='HWCK1',do_erc=True),
            Pin(num='18',name='V',do_erc=True),
            Pin(num='28',name='ORIG',do_erc=True),
            Pin(num='19',name='~AUDIO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='1',name='SDA/CDOUT',do_erc=True),
            Pin(num='2',name='AD0/CS',do_erc=True),
            Pin(num='3',name='AD2',do_erc=True),
            Pin(num='4',name='RXP',do_erc=True),
            Pin(num='5',name='TEST',do_erc=True),
            Pin(num='10',name='TEST',do_erc=True),
            Pin(num='20',name='Bit_User',do_erc=True),
            Pin(num='11',name='TEST',do_erc=True),
            Pin(num='15',name='TCBL',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TEST',do_erc=True),
            Pin(num='17',name='TEST',do_erc=True),
            Pin(num='27',name='AD1/CDIN',do_erc=True),
            Pin(num='18',name='TEST',do_erc=True),
            Pin(num='28',name='SCL/CCLK',do_erc=True),
            Pin(num='19',name='INT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='CS8414',dest=TEMPLATE,tool=SKIDL,keywords='digital audio interface receiver spdif',description='96KHz Digital Audio Receiver',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='C',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='CD/F1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='CC/F0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='CB/E2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='CA/E1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='C0/E0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RXP',do_erc=True),
            Pin(num='10',name='RXN',do_erc=True),
            Pin(num='20',name='FILT',do_erc=True),
            Pin(num='11',name='FSYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='CS12/FCK',do_erc=True),
            Pin(num='23',name='M0',do_erc=True),
            Pin(num='14',name='U',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='M1',do_erc=True),
            Pin(num='15',name='CBL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='ERF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='SEL',do_erc=True),
            Pin(num='26',name='SDATA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='M3',do_erc=True),
            Pin(num='27',name='CE/F2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='M2',do_erc=True),
            Pin(num='28',name='VERF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='MCK',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='CS8416-N',dest=TEMPLATE,tool=SKIDL,keywords='digital audio interface receiver spdif',description='192 kHz Digital Audio Interface Receiver (QFN-28)',ref_prefix='U',num_units=1,fplist=['QFN*28*'],do_erc=True,pins=[
            Pin(num='1',name='RXP0',do_erc=True),
            Pin(num='2',name='RXN',do_erc=True),
            Pin(num='3',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FILT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~RESET',do_erc=True),
            Pin(num='7',name='RXP4/RXSEL1',do_erc=True),
            Pin(num='8',name='RXP5/RXSEL0',do_erc=True),
            Pin(num='9',name='RXP6/TXSEL1',do_erc=True),
            Pin(num='10',name='RXP7/TXSEL0',do_erc=True),
            Pin(num='20',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AD0/~CS~/NV/RERR',do_erc=True),
            Pin(num='21',name='RMCK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='AD1/CDIN/~AUDIO',do_erc=True),
            Pin(num='22',name='OMCK',do_erc=True),
            Pin(num='13',name='SCL/CCLK/96KHZ',do_erc=True),
            Pin(num='23',name='SDOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='SDA/CDOUT/RCBL',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='OSCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='U/AD2/GPO2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='OLRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='C/GPO1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='RXP3',do_erc=True),
            Pin(num='17',name='TX/GPO0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='RXP2',do_erc=True),
            Pin(num='18',name='VL',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='RXP1',do_erc=True),
            Pin(num='19',name='DGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='CS8416-Z',dest=TEMPLATE,tool=SKIDL,keywords='digital audio interface receiver spdif',description='192 kHz Digital Audio Interface Receiver (TSSOP-28)',ref_prefix='U',num_units=1,fplist=['SOIC*28*', '*SSOP*28*'],do_erc=True,aliases=['CS8416-S', 'CS8416'],pins=[
            Pin(num='1',name='RXP3',do_erc=True),
            Pin(num='2',name='RXP2',do_erc=True),
            Pin(num='3',name='RXP1',do_erc=True),
            Pin(num='4',name='RXP0',do_erc=True),
            Pin(num='5',name='RXN',do_erc=True),
            Pin(num='6',name='VA',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='FILT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='RXP4/RXSEL1',do_erc=True),
            Pin(num='20',name='TX/GPO0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='RXP5/RXSEL0',do_erc=True),
            Pin(num='21',name='VL',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='RXP6/TXSEL1',do_erc=True),
            Pin(num='22',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='RXP7/TXSEL0',do_erc=True),
            Pin(num='23',name='VD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='AD0/~CS~/NV/RERR',do_erc=True),
            Pin(num='24',name='RMCK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='AD1/CDIN/~AUDIO',do_erc=True),
            Pin(num='25',name='OMCK',do_erc=True),
            Pin(num='16',name='SCL/CCLK/96KHZ',do_erc=True),
            Pin(num='26',name='SDOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='SDA/CDOUT/RCBL',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='OSCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='U/AD2/GPO2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='OLRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C/GPO1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='CS8420_SOFT',dest=TEMPLATE,tool=SKIDL,keywords='digital audio sample rate converter transceiver',description='Digital Audio Sample Rate Converter and Transceiver',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SDA/CDOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AD0/CS-',do_erc=True),
            Pin(num='3',name='EMPH-/AD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='RXP',do_erc=True),
            Pin(num='5',name='RXN',do_erc=True),
            Pin(num='6',name='VA',do_erc=True),
            Pin(num='7',name='AGND',do_erc=True),
            Pin(num='8',name='FILT',do_erc=True),
            Pin(num='9',name='RST',do_erc=True),
            Pin(num='10',name='RMCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='U',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RERR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='OMCK',do_erc=True),
            Pin(num='12',name='ILRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='DGND',do_erc=True),
            Pin(num='13',name='ISCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VD',do_erc=True),
            Pin(num='14',name='SDIN',do_erc=True),
            Pin(num='24',name='H/S-',do_erc=True),
            Pin(num='15',name='TCBL',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TXN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TXP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='OLRCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AD1/CDIN',do_erc=True),
            Pin(num='18',name='SDOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='SCL/CCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='INT',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='LM4811',dest=TEMPLATE,tool=SKIDL,keywords='headphone amplifier digital volume',description='Dual105mW Headphone Amplifier, Digital Volume Control, Shutdown Mode',ref_prefix='U',num_units=1,fplist=['VSSOP*', 'WSON*', 'SON*'],do_erc=True,pins=[
            Pin(num='1',name='VOUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VIN1',do_erc=True),
            Pin(num='3',name='BYPASS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='CLOCK',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='UP/DN',do_erc=True),
            Pin(num='7',name='SHDN',do_erc=True),
            Pin(num='8',name='VIN2',do_erc=True),
            Pin(num='9',name='VOUT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TLV320AIC23BPW',dest=TEMPLATE,tool=SKIDL,keywords='Stero Audio CODEC 96kHz Headphone',description='8-96kHz Stero Audio CODEC w/ Headphone Amp, TSSOP28',ref_prefix='U',num_units=1,fplist=['TSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='BCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DIN',do_erc=True),
            Pin(num='5',name='LRCIN',do_erc=True),
            Pin(num='6',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='LRCOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='HPVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='LHPOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='RHPOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='LLINEIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='HPGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='~CS~',do_erc=True),
            Pin(num='12',name='LOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='MODE',do_erc=True),
            Pin(num='13',name='ROUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='SDIN',do_erc=True),
            Pin(num='14',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='SCLK',do_erc=True),
            Pin(num='15',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='XTI/MCK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='VMID',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='XTO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='MICBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='MICIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='RLINEIN',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLV320AIC23BRHD',dest=TEMPLATE,tool=SKIDL,keywords='Stero Audio CODEC 96kHz Headphone',description='8-96kHz Stero Audio CODEC w/ Headphone Amp, QFN28',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='DIN',do_erc=True),
            Pin(num='2',name='LRCIN',do_erc=True),
            Pin(num='3',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='LRCOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='HPVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='LHPOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='RHPOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='HPGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='LOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='ROUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='SDIN',do_erc=True),
            Pin(num='11',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='SCLK',do_erc=True),
            Pin(num='12',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='XTI/MCK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='VMID',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='XTO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='MICBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='MICIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='RLINEIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='LLINEIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='~CS~',do_erc=True),
            Pin(num='28',name='BCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='MODE',do_erc=True)]),
        Part(name='TPA5050',dest=TEMPLATE,tool=SKIDL,keywords='AUDIO',description='Stereo Digital Audio Delay Processor With I2C Control',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='LRCLK',do_erc=True),
            Pin(num='2',name='DATA',do_erc=True),
            Pin(num='3',name='SCL',do_erc=True),
            Pin(num='4',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='ADD0',do_erc=True),
            Pin(num='11',name='ADD1',do_erc=True),
            Pin(num='12',name='ADD2',do_erc=True),
            Pin(num='13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='DATA_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='BCLK',do_erc=True)])])