from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

adc_dac = SchLib(tool=SKIDL).add_parts(*[
        Part(name='AD390JD',dest=TEMPLATE,tool=SKIDL,keywords='4ch DAC 12bit',description='Quad 12bit DAC, 2LSB Gain Error, DH-28',ref_prefix='U',num_units=1,do_erc=True,aliases=['AD390KD'],pins=[
            Pin(num='1',name='D0',do_erc=True),
            Pin(num='2',name='D1',do_erc=True),
            Pin(num='3',name='D2',do_erc=True),
            Pin(num='4',name='D3',do_erc=True),
            Pin(num='5',name='D4',do_erc=True),
            Pin(num='6',name='D5',do_erc=True),
            Pin(num='7',name='D6',do_erc=True),
            Pin(num='8',name='D7',do_erc=True),
            Pin(num='9',name='D8',do_erc=True),
            Pin(num='10',name='D9',do_erc=True),
            Pin(num='20',name='VOUT3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='D10',do_erc=True),
            Pin(num='21',name='VOUT4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='D11',do_erc=True),
            Pin(num='22',name='+VS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='~A1',do_erc=True),
            Pin(num='14',name='-VS',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='~A0',do_erc=True),
            Pin(num='15',name='AGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='~CS1',do_erc=True),
            Pin(num='16',name='REFOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='~CS2',do_erc=True),
            Pin(num='17',name='REFIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='~CS3',do_erc=True),
            Pin(num='18',name='VOUT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='~CS4',do_erc=True),
            Pin(num='19',name='VOUT2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD558JN',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC Reference Single Supply',description='Single 8-bit DAC, Internal Reference, Output Amp, Single Supply, DIP-16',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['AD558KN'],pins=[
            Pin(num='1',name='DB0',do_erc=True),
            Pin(num='2',name='DB1',do_erc=True),
            Pin(num='3',name='DB2',do_erc=True),
            Pin(num='4',name='DB3',do_erc=True),
            Pin(num='5',name='DB4',do_erc=True),
            Pin(num='6',name='DB5',do_erc=True),
            Pin(num='7',name='DB6',do_erc=True),
            Pin(num='8',name='DB7',do_erc=True),
            Pin(num='9',name='~CE',do_erc=True),
            Pin(num='10',name='~CS',do_erc=True),
            Pin(num='11',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VSEL',do_erc=True),
            Pin(num='15',name='VSEN',do_erc=True),
            Pin(num='16',name='VOUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD558JP',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC Reference Single Supply',description='Single 8-bit DAC, Internal Reference, Output Amp, Single Supply, PLCC-20',ref_prefix='U',num_units=1,do_erc=True,aliases=['AD558KP'],pins=[
            Pin(num='2',name='DB0',do_erc=True),
            Pin(num='3',name='DB1',do_erc=True),
            Pin(num='4',name='DB2',do_erc=True),
            Pin(num='5',name='DB3',do_erc=True),
            Pin(num='7',name='DB4',do_erc=True),
            Pin(num='8',name='DB5',do_erc=True),
            Pin(num='9',name='DB6',do_erc=True),
            Pin(num='10',name='DB7',do_erc=True),
            Pin(num='20',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~CE',do_erc=True),
            Pin(num='13',name='~CS',do_erc=True),
            Pin(num='14',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VSEL',do_erc=True),
            Pin(num='19',name='VSEN',do_erc=True)]),
        Part(name='AD5593R',dest=TEMPLATE,tool=SKIDL,keywords='8channel 12bit ADC DAC GPIO I2C Temperature',description='8-channel 12bits configurable ADC/DAC/GPIO Internal Reference, I2C interface Integrated temperature sensor,Single Supply, TSSOP-16',ref_prefix='U',num_units=1,fplist=['TSSOP-16*'],do_erc=True,pins=[
            Pin(num='1',name='~RESET',do_erc=True),
            Pin(num='2',name='A0',do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VRef',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='VLogic',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='IO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SCL',do_erc=True)]),
        Part(name='AD7171',dest=TEMPLATE,tool=SKIDL,keywords='sigma delta adc spi 1ch',description='Single channel Analog to Digial Converter, 16-bit, differential input, 125Hz, SPI interface',ref_prefix='U',num_units=1,fplist=['DFN-*'],do_erc=True,pins=[
            Pin(num='1',name='SCK',do_erc=True),
            Pin(num='2',name='DOUT/~RDY~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='AIN+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='AIN-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='REFIN+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='REFIN-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~PDRST',do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AD7224KN',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC Dual Single Supply',description='8bit DAC, Dual or Single Supply, DIP-18',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['AD7224LN'],pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DB7(MSB)',do_erc=True),
            Pin(num='7',name='DB6',do_erc=True),
            Pin(num='8',name='DB5',do_erc=True),
            Pin(num='9',name='DB4',do_erc=True),
            Pin(num='10',name='DB3',do_erc=True),
            Pin(num='11',name='DB2',do_erc=True),
            Pin(num='12',name='DB1',do_erc=True),
            Pin(num='13',name='DB0(LSB)',do_erc=True),
            Pin(num='14',name='~CS',do_erc=True),
            Pin(num='15',name='~WR',do_erc=True),
            Pin(num='16',name='~LDAC',do_erc=True),
            Pin(num='17',name='~RST',do_erc=True),
            Pin(num='18',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AD7224KP',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC Dual Single Supply',description='8bit DAC, Dual or Single Supply, PLCC-20',ref_prefix='U',num_units=1,fplist=['PLCC*'],do_erc=True,aliases=['AD7224LP'],pins=[
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='AGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DB7(MSB)',do_erc=True),
            Pin(num='8',name='DB6',do_erc=True),
            Pin(num='9',name='DB5',do_erc=True),
            Pin(num='10',name='DB4',do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DB3',do_erc=True),
            Pin(num='13',name='DB2',do_erc=True),
            Pin(num='14',name='DB1',do_erc=True),
            Pin(num='15',name='DB0(LSB)',do_erc=True),
            Pin(num='16',name='~CS',do_erc=True),
            Pin(num='17',name='~WR',do_erc=True),
            Pin(num='18',name='~LDAC',do_erc=True),
            Pin(num='19',name='~RST',do_erc=True)]),
        Part(name='AD7224KR-1',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC Dual Single Supply',description='8bit DAC, Dual or Single Supply, SOIC-20',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['AD7224LR-1'],pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DB7(MSB)',do_erc=True),
            Pin(num='7',name='DB6',do_erc=True),
            Pin(num='8',name='DB5',do_erc=True),
            Pin(num='9',name='DB4',do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DB3',do_erc=True),
            Pin(num='13',name='DB2',do_erc=True),
            Pin(num='14',name='DB1',do_erc=True),
            Pin(num='15',name='DB0(LSB)',do_erc=True),
            Pin(num='16',name='~CS',do_erc=True),
            Pin(num='17',name='~WR',do_erc=True),
            Pin(num='18',name='~LDAC',do_erc=True),
            Pin(num='19',name='~RST',do_erc=True)]),
        Part(name='AD7224KR-18',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC Dual Single Supply',description='8bit DAC, Dual or Single Supply, SOIC-18',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['AD7224LR-18'],pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DB7(MSB)',do_erc=True),
            Pin(num='7',name='DB6',do_erc=True),
            Pin(num='8',name='DB5',do_erc=True),
            Pin(num='9',name='DB4',do_erc=True),
            Pin(num='10',name='DB3',do_erc=True),
            Pin(num='11',name='DB2',do_erc=True),
            Pin(num='12',name='DB1',do_erc=True),
            Pin(num='13',name='DB0(LSB)',do_erc=True),
            Pin(num='14',name='~CS',do_erc=True),
            Pin(num='15',name='~WR',do_erc=True),
            Pin(num='16',name='~LDAC',do_erc=True),
            Pin(num='17',name='~RST',do_erc=True),
            Pin(num='18',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AD7225BRS',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC 4CH',description='Quad 8bit DAC, Separate Reference Voltage, SSOP-24',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,aliases=['AD7225CRS'],pins=[
            Pin(num='1',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VREFB',do_erc=True),
            Pin(num='5',name='VREFA',do_erc=True),
            Pin(num='6',name='AGND',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~LDAC',do_erc=True),
            Pin(num='9',name='DB7',do_erc=True),
            Pin(num='10',name='DB6',do_erc=True),
            Pin(num='20',name='VREFD',do_erc=True),
            Pin(num='11',name='DB5',do_erc=True),
            Pin(num='21',name='VREFC',do_erc=True),
            Pin(num='12',name='DB4',do_erc=True),
            Pin(num='22',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DB3',do_erc=True),
            Pin(num='23',name='VOUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='DB2',do_erc=True),
            Pin(num='24',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DB1',do_erc=True),
            Pin(num='16',name='DB0',do_erc=True),
            Pin(num='17',name='~WR',do_erc=True),
            Pin(num='18',name='A1',do_erc=True),
            Pin(num='19',name='A0',do_erc=True)]),
        Part(name='AD7225KN',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC 4CH',description='Quad 8bit DAC, Separate Reference Voltage, PDIP-24',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['AD7225LN'],pins=[
            Pin(num='1',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VREFB',do_erc=True),
            Pin(num='5',name='VREFA',do_erc=True),
            Pin(num='6',name='AGND',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~LDAC',do_erc=True),
            Pin(num='9',name='DB7',do_erc=True),
            Pin(num='10',name='DB6',do_erc=True),
            Pin(num='20',name='VREFD',do_erc=True),
            Pin(num='11',name='DB5',do_erc=True),
            Pin(num='21',name='VREFC',do_erc=True),
            Pin(num='12',name='DB4',do_erc=True),
            Pin(num='22',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DB3',do_erc=True),
            Pin(num='23',name='VOUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='DB2',do_erc=True),
            Pin(num='24',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DB1',do_erc=True),
            Pin(num='16',name='DB0',do_erc=True),
            Pin(num='17',name='~WR',do_erc=True),
            Pin(num='18',name='A1',do_erc=True),
            Pin(num='19',name='A0',do_erc=True)]),
        Part(name='AD7225KP',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC 4CH',description='Quad 8bit DAC, Separate Reference Voltage, PLCC-28',ref_prefix='U',num_units=1,fplist=['PLCC*'],do_erc=True,aliases=['AD7225LP'],pins=[
            Pin(num='2',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VREFB',do_erc=True),
            Pin(num='6',name='VREFA',do_erc=True),
            Pin(num='7',name='AGND',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='~LDAC',do_erc=True),
            Pin(num='20',name='~WR',do_erc=True),
            Pin(num='11',name='DB7',do_erc=True),
            Pin(num='21',name='A0',do_erc=True),
            Pin(num='12',name='DB6',do_erc=True),
            Pin(num='13',name='DB5',do_erc=True),
            Pin(num='23',name='A1',do_erc=True),
            Pin(num='14',name='DB4',do_erc=True),
            Pin(num='24',name='VREFD',do_erc=True),
            Pin(num='25',name='VREFC',do_erc=True),
            Pin(num='16',name='DB3',do_erc=True),
            Pin(num='26',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='DB2',do_erc=True),
            Pin(num='27',name='VOUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='DB1',do_erc=True),
            Pin(num='28',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='DB0',do_erc=True)]),
        Part(name='AD7225KR',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC 4CH',description='Quad 8bit DAC, Separate Reference Voltage, SO-24',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['AD7225LR'],pins=[
            Pin(num='1',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VREFB',do_erc=True),
            Pin(num='5',name='VREFA',do_erc=True),
            Pin(num='6',name='AGND',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~LDAC',do_erc=True),
            Pin(num='9',name='DB7',do_erc=True),
            Pin(num='10',name='DB6',do_erc=True),
            Pin(num='20',name='VREFD',do_erc=True),
            Pin(num='11',name='DB5',do_erc=True),
            Pin(num='21',name='VREFC',do_erc=True),
            Pin(num='12',name='DB4',do_erc=True),
            Pin(num='22',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DB3',do_erc=True),
            Pin(num='23',name='VOUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='DB2',do_erc=True),
            Pin(num='24',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DB1',do_erc=True),
            Pin(num='16',name='DB0',do_erc=True),
            Pin(num='17',name='~WR',do_erc=True),
            Pin(num='18',name='A1',do_erc=True),
            Pin(num='19',name='A0',do_erc=True)]),
        Part(name='AD7226BRSZ',dest=TEMPLATE,tool=SKIDL,keywords='4CH DAC 8bit',description='Quad 8bit DAC, 4 Channel, Single Reference Voltage, SSOP-20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VREF',do_erc=True),
            Pin(num='5',name='AGND',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DB7',do_erc=True),
            Pin(num='8',name='DB6',do_erc=True),
            Pin(num='9',name='DB5',do_erc=True),
            Pin(num='10',name='DB4',do_erc=True),
            Pin(num='20',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DB3',do_erc=True),
            Pin(num='12',name='DB2',do_erc=True),
            Pin(num='13',name='DB1',do_erc=True),
            Pin(num='14',name='DB0',do_erc=True),
            Pin(num='15',name='~WR',do_erc=True),
            Pin(num='16',name='A1',do_erc=True),
            Pin(num='17',name='A0',do_erc=True),
            Pin(num='18',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VOUTD',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD7226KN',dest=TEMPLATE,tool=SKIDL,keywords='4CH DAC 8bit',description='Quad 8bit DAC, 4 Channel, Single Reference Voltage, DIP-20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VREF',do_erc=True),
            Pin(num='5',name='AGND',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DB7',do_erc=True),
            Pin(num='8',name='DB6',do_erc=True),
            Pin(num='9',name='DB5',do_erc=True),
            Pin(num='10',name='DB4',do_erc=True),
            Pin(num='20',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DB3',do_erc=True),
            Pin(num='12',name='DB2',do_erc=True),
            Pin(num='13',name='DB1',do_erc=True),
            Pin(num='14',name='DB0',do_erc=True),
            Pin(num='15',name='~WR',do_erc=True),
            Pin(num='16',name='A1',do_erc=True),
            Pin(num='17',name='A0',do_erc=True),
            Pin(num='18',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VOUTD',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD7226KP',dest=TEMPLATE,tool=SKIDL,keywords='4CH DAC 8bit',description='Quad 8bit DAC, 4 Channel, Single Reference Voltage, PLCC-20',ref_prefix='U',num_units=1,fplist=['PLCC*'],do_erc=True,pins=[
            Pin(num='1',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VREF',do_erc=True),
            Pin(num='5',name='AGND',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DB7',do_erc=True),
            Pin(num='8',name='DB6',do_erc=True),
            Pin(num='9',name='DB5',do_erc=True),
            Pin(num='10',name='DB4',do_erc=True),
            Pin(num='20',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DB3',do_erc=True),
            Pin(num='12',name='DB2',do_erc=True),
            Pin(num='13',name='DB1',do_erc=True),
            Pin(num='14',name='DB0',do_erc=True),
            Pin(num='15',name='~WR',do_erc=True),
            Pin(num='16',name='A1',do_erc=True),
            Pin(num='17',name='A0',do_erc=True),
            Pin(num='18',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VOUTD',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD7226KR',dest=TEMPLATE,tool=SKIDL,keywords='4CH DAC 8bit',description='Quad 8bit DAC, 4 Channel, Single Reference Voltage, SOIC-20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VREF',do_erc=True),
            Pin(num='5',name='AGND',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DB7',do_erc=True),
            Pin(num='8',name='DB6',do_erc=True),
            Pin(num='9',name='DB5',do_erc=True),
            Pin(num='10',name='DB4',do_erc=True),
            Pin(num='20',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DB3',do_erc=True),
            Pin(num='12',name='DB2',do_erc=True),
            Pin(num='13',name='DB1',do_erc=True),
            Pin(num='14',name='DB0',do_erc=True),
            Pin(num='15',name='~WR',do_erc=True),
            Pin(num='16',name='A1',do_erc=True),
            Pin(num='17',name='A0',do_erc=True),
            Pin(num='18',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VOUTD',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD7228ABN',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC 8CH',description='8bit DAC 8 Channel, Single Reference, DIP-24',ref_prefix='U',num_units=1,fplist=['PDIP*', 'DIP*'],do_erc=True,aliases=['AD7228ACN'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VOUT7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VOUT6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VOUT5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VOUT4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VOUT3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VOUT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='VOUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='DB0',do_erc=True),
            Pin(num='11',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='~WR',do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='A2',do_erc=True),
            Pin(num='13',name='DB7',do_erc=True),
            Pin(num='23',name='A1',do_erc=True),
            Pin(num='14',name='DB6',do_erc=True),
            Pin(num='24',name='A0',do_erc=True),
            Pin(num='15',name='DB5',do_erc=True),
            Pin(num='16',name='DB4',do_erc=True),
            Pin(num='17',name='DB3',do_erc=True),
            Pin(num='18',name='DB2',do_erc=True),
            Pin(num='19',name='DB1',do_erc=True)]),
        Part(name='AD7228ABP',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC 8CH',description='8bit DAC 8 Channel, Single Reference, PLCC-28',ref_prefix='U',num_units=1,fplist=['PLCC*'],do_erc=True,aliases=['AD7228ACP'],pins=[
            Pin(num='2',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VOUT8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VOUT7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VOUT6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VOUT5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VOUT4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='VOUT3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VOUT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='DB3',do_erc=True),
            Pin(num='11',name='VOUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='DB2',do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='DB1',do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='DB0',do_erc=True),
            Pin(num='25',name='~WR',do_erc=True),
            Pin(num='16',name='DB7',do_erc=True),
            Pin(num='26',name='A2',do_erc=True),
            Pin(num='17',name='DB6',do_erc=True),
            Pin(num='27',name='A1',do_erc=True),
            Pin(num='18',name='DB5',do_erc=True),
            Pin(num='28',name='A0',do_erc=True),
            Pin(num='19',name='DB4',do_erc=True)]),
        Part(name='AD7228ABR',dest=TEMPLATE,tool=SKIDL,keywords='8bit DAC 8CH',description='8bit DAC 8 Channel, Single Reference, SOIC-24',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['AD7228ACR'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VOUT7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VOUT6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VOUT5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VOUT4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VOUT3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VOUT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='VOUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='DB0',do_erc=True),
            Pin(num='11',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='~WR',do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='A2',do_erc=True),
            Pin(num='13',name='DB7',do_erc=True),
            Pin(num='23',name='A1',do_erc=True),
            Pin(num='14',name='DB6',do_erc=True),
            Pin(num='24',name='A0',do_erc=True),
            Pin(num='15',name='DB5',do_erc=True),
            Pin(num='16',name='DB4',do_erc=True),
            Pin(num='17',name='DB3',do_erc=True),
            Pin(num='18',name='DB2',do_erc=True),
            Pin(num='19',name='DB1',do_erc=True)]),
        Part(name='AD7533JN',dest=TEMPLATE,tool=SKIDL,keywords='10bit DAC 1CH',description='10bit Multiplying DAC, 1 Channel, DIP-16',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['AD7533KN', 'AD7533LN'],pins=[
            Pin(num='1',name='I_OUT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='I_OUT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='D9(MSB)',do_erc=True),
            Pin(num='5',name='D8',do_erc=True),
            Pin(num='6',name='D7',do_erc=True),
            Pin(num='7',name='D6',do_erc=True),
            Pin(num='8',name='D5',do_erc=True),
            Pin(num='9',name='D4',do_erc=True),
            Pin(num='10',name='D3',do_erc=True),
            Pin(num='11',name='D2',do_erc=True),
            Pin(num='12',name='D1',do_erc=True),
            Pin(num='13',name='D0(LSB)',do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='RFBACK',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD7533JP',dest=TEMPLATE,tool=SKIDL,keywords='10bit DAC 1CH',description='10bit Multiplying DAC, 1 Channel, PLCC-20',ref_prefix='U',num_units=1,fplist=['PLCC*'],do_erc=True,aliases=['AD7533KP'],pins=[
            Pin(num='2',name='I_OUT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='I_OUT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='D9(MSB)',do_erc=True),
            Pin(num='7',name='D8',do_erc=True),
            Pin(num='8',name='D7',do_erc=True),
            Pin(num='9',name='D6',do_erc=True),
            Pin(num='10',name='D5',do_erc=True),
            Pin(num='20',name='RFBACK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='D4',do_erc=True),
            Pin(num='13',name='D3',do_erc=True),
            Pin(num='14',name='D2',do_erc=True),
            Pin(num='15',name='D1',do_erc=True),
            Pin(num='17',name='D0(LSB)',do_erc=True),
            Pin(num='18',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VREF',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD7533KR',dest=TEMPLATE,tool=SKIDL,keywords='10bit DAC 1CH',description='10bit Multiplying DAC, 1 Channel, SOIC-16',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='I_OUT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='I_OUT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='D9(MSB)',do_erc=True),
            Pin(num='5',name='D8',do_erc=True),
            Pin(num='6',name='D7',do_erc=True),
            Pin(num='7',name='D6',do_erc=True),
            Pin(num='8',name='D5',do_erc=True),
            Pin(num='9',name='D4',do_erc=True),
            Pin(num='10',name='D3',do_erc=True),
            Pin(num='11',name='D2',do_erc=True),
            Pin(num='12',name='D1',do_erc=True),
            Pin(num='13',name='D0(LSB)',do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='RFBACK',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD775',dest=TEMPLATE,tool=SKIDL,keywords='DAC CNA',description='DA Converter 8 bits - 20MHz, PDIP/SOIC-24',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~OE',do_erc=True),
            Pin(num='2',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='CLK',do_erc=True),
            Pin(num='22',name='VRBS',do_erc=True),
            Pin(num='13',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VRB',do_erc=True),
            Pin(num='14',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VRTS',do_erc=True),
            Pin(num='17',name='VRT',do_erc=True),
            Pin(num='18',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VIN',do_erc=True)]),
        Part(name='AD7819',dest=TEMPLATE,tool=SKIDL,keywords='CAD',description='Analog to Digital 8 bits converter, PDIP/SOIC/TSSOP-16',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VREF',do_erc=True),
            Pin(num='2',name='Vin',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='START',do_erc=True),
            Pin(num='5',name='CS',do_erc=True),
            Pin(num='6',name='OE',do_erc=True),
            Pin(num='7',name='EOC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='DB0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='DB1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='DB2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='DB3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='DB4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='DB5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='DB6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='DB7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AD9280ARS',dest=TEMPLATE,tool=SKIDL,keywords='ADC CAN VIDEO',description='Video ADC (32 Mhz), SSOP-28',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DRVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='D0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='D1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='D2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='D3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='D4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='D5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='CLAMPIN',do_erc=True),
            Pin(num='11',name='D6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='REFTS',do_erc=True),
            Pin(num='12',name='D7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='REFTF',do_erc=True),
            Pin(num='13',name='OTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='MODE',do_erc=True),
            Pin(num='14',name='DRVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='REFBF',do_erc=True),
            Pin(num='15',name='CLK',do_erc=True),
            Pin(num='25',name='REFBS',do_erc=True),
            Pin(num='16',name='THREE-STATE',do_erc=True),
            Pin(num='26',name='VREF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='STBY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='AIN',do_erc=True),
            Pin(num='18',name='REFSENSE',do_erc=True),
            Pin(num='28',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='CLAMP',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='AD9283',dest=TEMPLATE,tool=SKIDL,keywords='ADC',description='ADC 50MHz 8 bits, SSOP-20',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PWRDWN',do_erc=True),
            Pin(num='2',name='VREFout',do_erc=True),
            Pin(num='3',name='VREFin',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VaD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='Ain-',do_erc=True),
            Pin(num='7',name='Ain+',do_erc=True),
            Pin(num='8',name='VaD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='CLK',do_erc=True),
            Pin(num='20',name='DO0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DO7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='DO6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='DO5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='DO4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='DO3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='DO2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='DO1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='AD9708AR',dest=TEMPLATE,tool=SKIDL,keywords='DAC CNA VIDEO',description='Video DAC (32 MHz), SOIC/TSSOP-28',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='DB7',do_erc=True),
            Pin(num='2',name='DB6',do_erc=True),
            Pin(num='3',name='DB5',do_erc=True),
            Pin(num='4',name='DB4',do_erc=True),
            Pin(num='5',name='DB3',do_erc=True),
            Pin(num='6',name='DB2',do_erc=True),
            Pin(num='7',name='DB1',do_erc=True),
            Pin(num='8',name='DB0',do_erc=True),
            Pin(num='20',name='ACOM',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='IOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='IOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='COMP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='SLEEP',do_erc=True),
            Pin(num='16',name='REFLO',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='DCOM',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='REFIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='FS_ADJ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='Clock',do_erc=True),
            Pin(num='19',name='COMP1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ADC0800',dest=TEMPLATE,tool=SKIDL,keywords='CAD',description='Analog to Digital 8 bits converter, DIP-18 (Hermetic)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='QE',func=Pin.TRISTATE,do_erc=True),
            Pin(num='2',name='QF',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='QG',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='QH',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='Rbot',do_erc=True),
            Pin(num='6',name='Start',do_erc=True),
            Pin(num='7',name='OE',do_erc=True),
            Pin(num='8',name='-Vgg',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='EOC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='Clk',do_erc=True),
            Pin(num='12',name='Vin',do_erc=True),
            Pin(num='13',name='QA',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='QB',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Rtop',do_erc=True),
            Pin(num='16',name='QC',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='QD',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='DGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADC08060',dest=TEMPLATE,tool=SKIDL,keywords='ADC CAN VIDEO',description='Fast ADC (20 .. 60 Mhz), TSSOP-24',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VRT',do_erc=True),
            Pin(num='4',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AIN',do_erc=True),
            Pin(num='7',name='VIN_GND',do_erc=True),
            Pin(num='8',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VRB',do_erc=True),
            Pin(num='10',name='VRB',do_erc=True),
            Pin(num='20',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='PWR_DWN',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='CLK',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='D4',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='ADC0832',dest=TEMPLATE,tool=SKIDL,keywords='ADC CAN',description='2 inputs AD Converter (serial output),',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CS',do_erc=True),
            Pin(num='2',name='ANALOG0',do_erc=True),
            Pin(num='3',name='ANALOG1',do_erc=True),
            Pin(num='4',name='GND',do_erc=True),
            Pin(num='5',name='DIN',do_erc=True),
            Pin(num='6',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CLK',do_erc=True),
            Pin(num='8',name='VCC',do_erc=True)]),
        Part(name='ADC1173',dest=TEMPLATE,tool=SKIDL,keywords='ADC CAN VIDEO',description='Fast ADC (15 Mhz), TSSOP-24',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='OE',do_erc=True),
            Pin(num='2',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='CLK',do_erc=True),
            Pin(num='22',name='VRBS',do_erc=True),
            Pin(num='13',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VRB',do_erc=True),
            Pin(num='14',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VRTS',do_erc=True),
            Pin(num='17',name='VRT',do_erc=True),
            Pin(num='27',name='AIN',do_erc=True),
            Pin(num='18',name='AVDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ADS1110',dest=TEMPLATE,tool=SKIDL,keywords='16 Bit Analog to digital converter ADC',description='16 Bit Analog to Digital converter with on board reference',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='VIN+',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SCL',do_erc=True),
            Pin(num='4',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VIN-',do_erc=True)]),
        Part(name='ADS1118I',dest=TEMPLATE,tool=SKIDL,keywords='adc spi quad double',description='16-bit analog to digital converter, 2 or 4 inputs, integrated temperature sensor, SPI interface',ref_prefix='U',num_units=1,fplist=['SOP*3x3mm*Pitch0.5mm*', '*QFN*2x1.5mm*Pitch0.5mm'],do_erc=True,pins=[
            Pin(num='1',name='SCLK',do_erc=True),
            Pin(num='2',name='~CS',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AIN0',do_erc=True),
            Pin(num='5',name='AIN1',do_erc=True),
            Pin(num='6',name='AIN2',do_erc=True),
            Pin(num='7',name='AIN3',do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='DOUT/~DRDY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='DIN',do_erc=True)]),
        Part(name='ADS1120-PW',dest=TEMPLATE,tool=SKIDL,keywords='adc spi',description='Low-power, quad-input, 16-bit analog to digital converter, integrated temperature sensor, SPI interface, TSSOP-16 package',ref_prefix='U',num_units=1,fplist=['*TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='SCLK',do_erc=True),
            Pin(num='2',name='~CS',do_erc=True),
            Pin(num='3',name='CLK',do_erc=True),
            Pin(num='4',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AIN3/REFN1',do_erc=True),
            Pin(num='7',name='AIN2',do_erc=True),
            Pin(num='8',name='REFN0',do_erc=True),
            Pin(num='9',name='REFP0',do_erc=True),
            Pin(num='10',name='AIN1',do_erc=True),
            Pin(num='11',name='AIN0/REFP1',do_erc=True),
            Pin(num='12',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='~DRDY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DOUT/~DRDY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='DIN',do_erc=True)]),
        Part(name='ADS1120-RVA',dest=TEMPLATE,tool=SKIDL,keywords='adc spi',description='Low-power, quad-input, 16-bit analog to digital converter, integrated temperature sensor, SPI interface, QFN-16 package',ref_prefix='U',num_units=1,fplist=['QFN*3.5x3.5mm*Pitch0.50mm*'],do_erc=True,pins=[
            Pin(num='1',name='CLK',do_erc=True),
            Pin(num='2',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AIN3/REFN1',do_erc=True),
            Pin(num='5',name='AIN2',do_erc=True),
            Pin(num='6',name='REFN0',do_erc=True),
            Pin(num='7',name='REFP0',do_erc=True),
            Pin(num='8',name='AIN1',do_erc=True),
            Pin(num='9',name='AIN0/REFP1',do_erc=True),
            Pin(num='10',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='~DRDY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='DOUT/~DRDY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='DIN',do_erc=True),
            Pin(num='15',name='SCLK',do_erc=True),
            Pin(num='16',name='~CS',do_erc=True),
            Pin(num='17',name='PAD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='ADS1232IPW',dest=TEMPLATE,tool=SKIDL,keywords='ADC 24bit Sensors Dual Channel',description='Single Bridge 24bit ADC for Sensors, TSSOP-24',ref_prefix='U',num_units=1,fplist=['TSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CLKIN/XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='TEMP',do_erc=True),
            Pin(num='8',name='A0',do_erc=True),
            Pin(num='9',name='CAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='CAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='GAIN1',do_erc=True),
            Pin(num='11',name='AINP1',do_erc=True),
            Pin(num='21',name='SPEED',do_erc=True),
            Pin(num='12',name='AINN1',do_erc=True),
            Pin(num='22',name='~PWDN~',do_erc=True),
            Pin(num='13',name='AINN2',do_erc=True),
            Pin(num='23',name='SCLK',do_erc=True),
            Pin(num='14',name='AINP2',do_erc=True),
            Pin(num='24',name='~DRDY~/DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='REFN',do_erc=True),
            Pin(num='16',name='REFP',do_erc=True),
            Pin(num='17',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='GAIN0',do_erc=True)]),
        Part(name='ADS1234IPW',dest=TEMPLATE,tool=SKIDL,keywords='ADC 24bit Sensors Quad Channel',description='Dual Bridge 24bit ADC for Sensors, TSSOP-28',ref_prefix='U',num_units=1,fplist=['TSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CLKIN/XTAL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='A1',do_erc=True),
            Pin(num='8',name='A0',do_erc=True),
            Pin(num='9',name='CAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='CAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='REFP',do_erc=True),
            Pin(num='11',name='AINP1',do_erc=True),
            Pin(num='21',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='AINN1',do_erc=True),
            Pin(num='22',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='AINP3',do_erc=True),
            Pin(num='23',name='GAIN0',do_erc=True),
            Pin(num='14',name='AINN3',do_erc=True),
            Pin(num='24',name='GAIN1',do_erc=True),
            Pin(num='15',name='AINN4',do_erc=True),
            Pin(num='25',name='SPEED',do_erc=True),
            Pin(num='16',name='AINP4',do_erc=True),
            Pin(num='26',name='~PWDN~',do_erc=True),
            Pin(num='17',name='AINN2',do_erc=True),
            Pin(num='27',name='SCLK',do_erc=True),
            Pin(num='18',name='AINP2',do_erc=True),
            Pin(num='28',name='~DRDY~/DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='REFN',do_erc=True)]),
        Part(name='ADS1243',dest=TEMPLATE,tool=SKIDL,keywords='24bit ADC 8 Channels PGA SPI',description='24-bit ADC, 8 Channels, SPI compatible, PGA 1 to 128, TSSOP-20',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x6.5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XIN',do_erc=True),
            Pin(num='3',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~PDWN~',do_erc=True),
            Pin(num='5',name='VREF+',do_erc=True),
            Pin(num='6',name='VREF-',do_erc=True),
            Pin(num='7',name='Ain0/D0',do_erc=True),
            Pin(num='8',name='Ain1/D1',do_erc=True),
            Pin(num='9',name='Ain4/D4',do_erc=True),
            Pin(num='10',name='Ain5/D5',do_erc=True),
            Pin(num='20',name='~DRDY~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='Ain6/D6',do_erc=True),
            Pin(num='12',name='Ain7/D7',do_erc=True),
            Pin(num='13',name='Ain2/D2',do_erc=True),
            Pin(num='14',name='Ain3/D3',do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='~CS~',do_erc=True),
            Pin(num='17',name='DIN',do_erc=True),
            Pin(num='18',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='SCLK',do_erc=True)]),
        Part(name='ADS1251',dest=TEMPLATE,tool=SKIDL,keywords='delta-sigma adc low-power',description='Single channel 24-bit Analog to Digital Converter, 5V supply, differential input, 20kHz, 2-wire serial interface, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='IN+',do_erc=True),
            Pin(num='2',name='IN-',do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='CLK',do_erc=True),
            Pin(num='5',name='DOUT/nDRDY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='SCLK',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VREF',do_erc=True)]),
        Part(name='ADS128D818',dest=TEMPLATE,tool=SKIDL,keywords='16bit ADC 8 Channels TSSOP I2C',description='16-bit ADC, 8 Channels, I2C compatible, PGA 1 to 128, TSSOP-16',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='VREF+',do_erc=True),
            Pin(num='2',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~INT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='A0',do_erc=True),
            Pin(num='8',name='A1',do_erc=True),
            Pin(num='9',name='Ain7',do_erc=True),
            Pin(num='10',name='Ain6',do_erc=True),
            Pin(num='11',name='Ain5',do_erc=True),
            Pin(num='12',name='Ain4',do_erc=True),
            Pin(num='13',name='Ain3',do_erc=True),
            Pin(num='14',name='Ain2',do_erc=True),
            Pin(num='15',name='Ain1',do_erc=True),
            Pin(num='16',name='Ain0',do_erc=True)]),
        Part(name='ADS7828',dest=TEMPLATE,tool=SKIDL,keywords='I2C ADC 12Bits',description='12-Bits, 8-Channels, ADC, I2C, TSSOP-16',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='CH0',do_erc=True),
            Pin(num='2',name='CH1',do_erc=True),
            Pin(num='3',name='CH2',do_erc=True),
            Pin(num='4',name='CH3',do_erc=True),
            Pin(num='5',name='CH4',do_erc=True),
            Pin(num='6',name='CH5',do_erc=True),
            Pin(num='7',name='CH6',do_erc=True),
            Pin(num='8',name='CH7',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='REF',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='COM',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='13',name='A1',do_erc=True),
            Pin(num='14',name='SCL',do_erc=True),
            Pin(num='15',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='CA3300',dest=TEMPLATE,tool=SKIDL,keywords='ADC CAN',description='Convertisseur A->D 6 bits rapide',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='2',name='OVF',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='ZEN',do_erc=True),
            Pin(num='5',name='CE2',do_erc=True),
            Pin(num='6',name='CE1',do_erc=True),
            Pin(num='7',name='CLK',do_erc=True),
            Pin(num='8',name='PHAS',do_erc=True),
            Pin(num='9',name='+REF',do_erc=True),
            Pin(num='10',name='-REF',do_erc=True),
            Pin(num='11',name='VIN',do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='CREF',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='DAC08',dest=TEMPLATE,tool=SKIDL,keywords='DAC CNA',description='DA Converter 8 bits',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VLC',do_erc=True),
            Pin(num='2',name='I+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='I-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='B0',do_erc=True),
            Pin(num='6',name='B1',do_erc=True),
            Pin(num='7',name='B2',do_erc=True),
            Pin(num='8',name='B3',do_erc=True),
            Pin(num='9',name='B4',do_erc=True),
            Pin(num='10',name='B5',do_erc=True),
            Pin(num='11',name='B6',do_erc=True),
            Pin(num='12',name='B7',do_erc=True),
            Pin(num='13',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='R+',do_erc=True),
            Pin(num='15',name='R-',do_erc=True),
            Pin(num='16',name='CMP',do_erc=True)]),
        Part(name='DAC7513_DCN',dest=TEMPLATE,tool=SKIDL,keywords='TI DAC 12 bit',description='Low-Power, Rail-to-Rail Output, 12-Bit Serial Input DAC',ref_prefix='U',num_units=1,fplist=['SOT-23-*'],do_erc=True,pins=[
            Pin(num='1',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VFB',do_erc=True),
            Pin(num='3',name='VREF',do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='DIN',do_erc=True),
            Pin(num='7',name='SCLK',do_erc=True),
            Pin(num='8',name='~SYNC',do_erc=True)]),
        Part(name='LTC1257',dest=TEMPLATE,tool=SKIDL,keywords='DAC 12-bit',description='Single Supply 12-bit DAC with Internal Reference Voltage, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='CKL',do_erc=True),
            Pin(num='2',name='DIN',do_erc=True),
            Pin(num='3',name='~LOAD~',do_erc=True),
            Pin(num='4',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC1406CGN',dest=TEMPLATE,tool=SKIDL,keywords='Low Power ADC 8bit 20Msps',description='ADC 8bit Low Power 20Msps, SSOP-24',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,aliases=['LTC1406IGN'],pins=[
            Pin(num='1',name='OGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~SHDN~',do_erc=True),
            Pin(num='4',name='VBIAS',do_erc=True),
            Pin(num='5',name='VREF',do_erc=True),
            Pin(num='6',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='AIN+',do_erc=True),
            Pin(num='8',name='AIN-',do_erc=True),
            Pin(num='9',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='D5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='D6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='D7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='23',name='OF/UF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='24',name='CLK',do_erc=True),
            Pin(num='15',name='D0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='D1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='D2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='D3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='D4',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC1446',dest=TEMPLATE,tool=SKIDL,keywords='12-Bit DAC SPI 2ch',description='2-Channel 12-Bit Rail-To-Rail D/A Converters with SPI Interface and Internal Reference (2.500V)',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['LTC1446L'],pins=[
            Pin(num='1',name='SCK',do_erc=True),
            Pin(num='2',name='SDI',do_erc=True),
            Pin(num='3',name='~CS~/LD',do_erc=True),
            Pin(num='4',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VB',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC1594CS',dest=TEMPLATE,tool=SKIDL,keywords='12bit ADC 4 Channel',description='Micropower 12-bit 4 Channel ADC, Serial IO, SO-16',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['LTC1594IS'],pins=[
            Pin(num='1',name='CH0',do_erc=True),
            Pin(num='2',name='CH1',do_erc=True),
            Pin(num='3',name='CH2',do_erc=True),
            Pin(num='4',name='CH3',do_erc=True),
            Pin(num='5',name='ADCIN',do_erc=True),
            Pin(num='6',name='VREF',do_erc=True),
            Pin(num='7',name='COM',do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~CSADC~',do_erc=True),
            Pin(num='10',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='CLK',do_erc=True),
            Pin(num='13',name='~CSMUX~',do_erc=True),
            Pin(num='14',name='DIN',do_erc=True),
            Pin(num='15',name='MUXOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC1598CG',dest=TEMPLATE,tool=SKIDL,keywords='12bit ADC 4 Channel',description='Micropower 12-bit 8 Channel ADC, Serial IO, SSOP-24',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,aliases=['LTC1598IG'],pins=[
            Pin(num='1',name='CH5',do_erc=True),
            Pin(num='2',name='CH6',do_erc=True),
            Pin(num='3',name='CH7',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CLK',do_erc=True),
            Pin(num='6',name='~CSMUX~',do_erc=True),
            Pin(num='7',name='DIN',do_erc=True),
            Pin(num='8',name='COM',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='~CSADC~',do_erc=True),
            Pin(num='20',name='CH0',do_erc=True),
            Pin(num='11',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='CH1',do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='22',name='CH2',do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='23',name='CH3',do_erc=True),
            Pin(num='14',name='CLK',do_erc=True),
            Pin(num='24',name='CH4',do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VREF',do_erc=True),
            Pin(num='17',name='ADCIN',do_erc=True),
            Pin(num='18',name='MUXOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC1664CGN',dest=TEMPLATE,tool=SKIDL,keywords='Quad DAC Micropower 10bit 4ch',description='Quad Micropower 10-bit DAC, Industrial, DIP-16',ref_prefix='U',num_units=1,fplist=['*SSOP*'],do_erc=True,aliases=['LTC1664IGN', 'LTC1664CN', 'LTC1664IN'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='OUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='OUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='OUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='REF',do_erc=True),
            Pin(num='7',name='~CS~/LD',do_erc=True),
            Pin(num='8',name='SCK',do_erc=True),
            Pin(num='9',name='DIN',do_erc=True),
            Pin(num='10',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~CLR',do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='14',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='15',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC1864L',dest=TEMPLATE,tool=SKIDL,keywords='sigma-delta adc spi 1ch',description='Single channel 16-bit Analog to Digial Converter, 3V supply, differential input, 150ksps, SPI interface',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['LTC1864'],pins=[
            Pin(num='1',name='VREF',do_erc=True),
            Pin(num='2',name='IN+',do_erc=True),
            Pin(num='3',name='IN-',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CONV',do_erc=True),
            Pin(num='6',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='SCK',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC1865L-MS',dest=TEMPLATE,tool=SKIDL,keywords='sigma-delta adc 2ch',description='Dual channel 16-bit Analog to Digital Converter, 3V supply, 150ksps, SPI interface',ref_prefix='U',num_units=1,fplist=['MSOP-10*'],do_erc=True,aliases=['LTC1865-MS'],pins=[
            Pin(num='1',name='CONV',do_erc=True),
            Pin(num='2',name='CH0',do_erc=True),
            Pin(num='3',name='CH1',do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SDI',do_erc=True),
            Pin(num='7',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='SCK',do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VREF',do_erc=True)]),
        Part(name='LTC1865L-S8',dest=TEMPLATE,tool=SKIDL,keywords='sigma-delta adc 2ch',description='Dual channel 16-bit Analog to Digital Converter, 3V supply, 150ksps, SPI interface',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['LTC1865-S8'],pins=[
            Pin(num='1',name='CONV',do_erc=True),
            Pin(num='2',name='CH0',do_erc=True),
            Pin(num='3',name='CH1',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDI',do_erc=True),
            Pin(num='6',name='SDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='SCK',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC2309_QFN',dest=TEMPLATE,tool=SKIDL,keywords='LT ADC 12bit I2C SAR QFN',description='8 Channels, 12-Bit SAR ADC, I2C interface, QFN-24 package',ref_prefix='U',num_units=1,fplist=['QFN-*1EP*4x4mm*0.5mm*'],do_erc=True,pins=[
            Pin(num='3',name='CH5',do_erc=True),
            Pin(num='1',name='CH3',do_erc=True),
            Pin(num='2',name='CH4',do_erc=True),
            Pin(num='4',name='CH6',do_erc=True),
            Pin(num='5',name='CH7',do_erc=True),
            Pin(num='6',name='COM',do_erc=True),
            Pin(num='7',name='VREF',do_erc=True),
            Pin(num='8',name='REFCOMP',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='CH0',do_erc=True),
            Pin(num='13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='CH1',do_erc=True),
            Pin(num='14',name='AD0',do_erc=True),
            Pin(num='24',name='CH2',do_erc=True),
            Pin(num='15',name='AD1',do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='SCL',do_erc=True),
            Pin(num='17',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC2309_TSSOP',dest=TEMPLATE,tool=SKIDL,keywords='LT ADC 12bit I2C SAR TSSOP',description='8 Channels, 12-Bit SAR ADC, I2C interface, TSSOP-20 package',ref_prefix='U',num_units=1,fplist=['TSSOP-*'],do_erc=True,pins=[
            Pin(num='16',name='CH5',do_erc=True),
            Pin(num='1',name='REFCOMP',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AD0',do_erc=True),
            Pin(num='5',name='AD1',do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VREF',do_erc=True),
            Pin(num='11',name='CH0',do_erc=True),
            Pin(num='12',name='CH1',do_erc=True),
            Pin(num='13',name='CH2',do_erc=True),
            Pin(num='14',name='CH3',do_erc=True),
            Pin(num='15',name='CH4',do_erc=True),
            Pin(num='17',name='CH6',do_erc=True),
            Pin(num='18',name='CH7',do_erc=True),
            Pin(num='19',name='COM',do_erc=True)]),
        Part(name='LTC2508CDKD-32',dest=TEMPLATE,tool=SKIDL,keywords='LT ADC 32bit',description='32-Bit Oversampling ADC with Configurable Digital Filter, -40°C to 85°C, DFN-24 package',ref_prefix='U',num_units=1,do_erc=True,aliases=['LTC2508IDKD-32'],pins=[
            Pin(num='1',name='RDLA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='RDLB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='IN+',do_erc=True),
            Pin(num='6',name='IN-',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='REF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='REF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='REF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='SDOB',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='SEL0',do_erc=True),
            Pin(num='21',name='BUSY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='SEL1',do_erc=True),
            Pin(num='22',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='MCLK',do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='SYNC',do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='DRL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='EPAD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='SDOA',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='SCKA',do_erc=True),
            Pin(num='19',name='SCKB',do_erc=True)]),
        Part(name='MAX11614',dest=TEMPLATE,tool=SKIDL,keywords='adc i2c 8ch',description='8-channel single-ended or 4-channel, differential, 12-bit ADC, I2C, 2.048V internal reference, 16-QSOP package',ref_prefix='U',num_units=1,fplist=['QSOP*3.9x4.9mm*Pitch0.635mm*'],do_erc=True,aliases=['MAX11615'],pins=[
            Pin(num='1',name='REF',do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='AIN0',do_erc=True),
            Pin(num='6',name='AIN1',do_erc=True),
            Pin(num='7',name='AIN2',do_erc=True),
            Pin(num='8',name='AIN3',do_erc=True),
            Pin(num='9',name='AIN4',do_erc=True),
            Pin(num='10',name='AIN5',do_erc=True),
            Pin(num='11',name='AIN6',do_erc=True),
            Pin(num='12',name='AIN7',do_erc=True),
            Pin(num='13',name='SCL',do_erc=True),
            Pin(num='14',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX11616',dest=TEMPLATE,tool=SKIDL,keywords='adc i2c 12ch',description='12-channel single-ended or 6-channel, differential, 12-bit ADC, I2C, 2.048V internal reference, 16-QSOP package',ref_prefix='U',num_units=1,fplist=['QSOP*3.9x4.9mm*Pitch0.635mm*'],do_erc=True,aliases=['MAX11617'],pins=[
            Pin(num='1',name='AIN11',do_erc=True),
            Pin(num='2',name='AIN10',do_erc=True),
            Pin(num='3',name='AIN9',do_erc=True),
            Pin(num='4',name='AIN8',do_erc=True),
            Pin(num='5',name='AIN0',do_erc=True),
            Pin(num='6',name='AIN1',do_erc=True),
            Pin(num='7',name='AIN2',do_erc=True),
            Pin(num='8',name='AIN3',do_erc=True),
            Pin(num='9',name='AIN4',do_erc=True),
            Pin(num='10',name='AIN5',do_erc=True),
            Pin(num='11',name='AIN6',do_erc=True),
            Pin(num='12',name='AIN7',do_erc=True),
            Pin(num='13',name='SCL',do_erc=True),
            Pin(num='14',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX1274',dest=TEMPLATE,tool=SKIDL,keywords='12bit ADC 1CH diff differential',description='1.8Msps, Single-Supply, Low-Power, True-Differential, 12-Bit ADCs, unipolar input',ref_prefix='U',num_units=1,fplist=['*QFN*4x4mm*Pitch0.8mm*'],do_erc=True,aliases=['MAX1275'],pins=[
            Pin(num='1',name='AIN-',do_erc=True),
            Pin(num='2',name='REF',do_erc=True),
            Pin(num='3',name='RGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VL',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='CNVST',do_erc=True),
            Pin(num='10',name='SCLK',do_erc=True),
            Pin(num='11',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='12',name='AIN+',do_erc=True),
            Pin(num='13',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX5139',dest=TEMPLATE,tool=SKIDL,keywords='12-bit DAC 1CH',description='Low-Power, Single, 12-Bit, Buffered Voltage-Output DAC',ref_prefix='U',num_units=1,fplist=['*QFN*3x3mm*Pitch0.5mm*'],do_erc=True,aliases=['MAX5138'],pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='M/~Z',do_erc=True),
            Pin(num='3',name='~LDAC',do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='SCLK',do_erc=True),
            Pin(num='6',name='~CS',do_erc=True),
            Pin(num='7',name='DIN',do_erc=True),
            Pin(num='8',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='~READY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='REFI',do_erc=True),
            Pin(num='15',name='REFO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='AGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP3002',dest=TEMPLATE,tool=SKIDL,keywords='Dual Channel 10-Bit ADC SPI 2CH',description='Dual Channel 10-Bit A/D Converter with SPI Serial Interface',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm**', 'SOIC*3.9x4.9mm*Pitch1.27mm*', 'TSSOP*3x3mm*Pitch0.65mm*', 'MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='~CS~/SHDN',do_erc=True),
            Pin(num='2',name='CH0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='CH1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='DIN',do_erc=True),
            Pin(num='6',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CLK',do_erc=True),
            Pin(num='8',name='VDD/VREF',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP3004',dest=TEMPLATE,tool=SKIDL,keywords='10-Bit ADC SPI 4CH',description='4-Channel 10-Bit A/D Converters with SPI Interface',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x8.7mm*Pitch1.27mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='CH0',do_erc=True),
            Pin(num='2',name='CH1',do_erc=True),
            Pin(num='3',name='CH2',do_erc=True),
            Pin(num='4',name='CH3',do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~CS~/SHDN',do_erc=True),
            Pin(num='9',name='Din',do_erc=True),
            Pin(num='10',name='Dout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='CLK',do_erc=True),
            Pin(num='12',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='Vref',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP3204',dest=TEMPLATE,tool=SKIDL,keywords='12bit ADC Reference Single Supply SPI 4ch',description='A/D Converter, 12-Bit, 4-Channel, SPI Interface, 2.7V-5.5V',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x8.7mm*Pitch1.27mm*', 'DIP*W7.62mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='CH0',do_erc=True),
            Pin(num='2',name='CH1',do_erc=True),
            Pin(num='3',name='CH2',do_erc=True),
            Pin(num='4',name='CH3',do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='~CS~/SHDN',do_erc=True),
            Pin(num='9',name='Din',do_erc=True),
            Pin(num='10',name='Dout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='CLK',do_erc=True),
            Pin(num='12',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='Vref',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP3208',dest=TEMPLATE,tool=SKIDL,keywords='12bit ADC Reference Single Supply SPI 8ch',description='A/D Converter, 12-Bit, 8-Channel, SPI Interface , 2.7V-5.5V',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x9.9mm*Pitch1.27mm*'],do_erc=True,aliases=['MCP3008'],pins=[
            Pin(num='1',name='CH0',do_erc=True),
            Pin(num='2',name='CH1',do_erc=True),
            Pin(num='3',name='CH2',do_erc=True),
            Pin(num='4',name='CH3',do_erc=True),
            Pin(num='5',name='CH4',do_erc=True),
            Pin(num='6',name='CH5',do_erc=True),
            Pin(num='7',name='CH6',do_erc=True),
            Pin(num='8',name='CH7',do_erc=True),
            Pin(num='9',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='~CS~/SHDN',do_erc=True),
            Pin(num='11',name='Din',do_erc=True),
            Pin(num='12',name='Dout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='CLK',do_erc=True),
            Pin(num='14',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='Vref',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP3301',dest=TEMPLATE,tool=SKIDL,keywords='13-Bit Differential ADC SPI 1ch',description='13-Bit Differential Input, Low Power A/D Converter with SPI Interface',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='Vref',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN+',do_erc=True),
            Pin(num='3',name='IN-',do_erc=True),
            Pin(num='4',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~CS~/SHDN',do_erc=True),
            Pin(num='6',name='Dout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CLK',do_erc=True),
            Pin(num='8',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP3422',dest=TEMPLATE,tool=SKIDL,keywords='18-Bit ADC I2C IIC I²C Delta-Sigma-ADC Delta-Sigma-ADC Reference 2ch',description='2-Channel, 18-Bit, Delta-Sigma AD-Converter, I²C Interface, Reference',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='CH1+',do_erc=True),
            Pin(num='2',name='CH1-',do_erc=True),
            Pin(num='3',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SCL',do_erc=True),
            Pin(num='6',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='CH2+',do_erc=True),
            Pin(num='8',name='CH2-',do_erc=True)]),
        Part(name='MCP3423',dest=TEMPLATE,tool=SKIDL,keywords='18-Bit ADC I2C IIC I²C Delta-Sigma-ADC Delta-Sigma-ADC Reference 2ch',description='2-Channel, 18-Bit, Delta-Sigma AD-Converter, I²C Interface, Reference, MSOP',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='CH1+',do_erc=True),
            Pin(num='2',name='CH1-',do_erc=True),
            Pin(num='3',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='CH2+',do_erc=True),
            Pin(num='5',name='CH2-',do_erc=True),
            Pin(num='6',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SCL',do_erc=True),
            Pin(num='9',name='A0',do_erc=True),
            Pin(num='10',name='A1',do_erc=True)]),
        Part(name='MCP3424',dest=TEMPLATE,tool=SKIDL,keywords='18-Bit ADC I2C IIC I²C Delta-Sigma-ADC Delta-Sigma-ADC Reference 4ch',description='4-Channel, 18-Bit, Delta-Sigma AD-Converter, I²C Interface, Reference',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x8.7mm*Pitch1.27mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='CH1+',do_erc=True),
            Pin(num='2',name='CH1-',do_erc=True),
            Pin(num='3',name='CH2+',do_erc=True),
            Pin(num='4',name='CH2-',do_erc=True),
            Pin(num='5',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SCL',do_erc=True),
            Pin(num='9',name='A0',do_erc=True),
            Pin(num='10',name='A1',do_erc=True),
            Pin(num='11',name='CH3+',do_erc=True),
            Pin(num='12',name='CH3-',do_erc=True),
            Pin(num='13',name='CH4+',do_erc=True),
            Pin(num='14',name='CH4-',do_erc=True)]),
        Part(name='MCP3425A0T-E/CH',dest=TEMPLATE,tool=SKIDL,keywords='Sigma-Delta ADC Converter 16bit I2C 1ch',description='Single Delta-Sigma 16bit Analog to Digital Converter, I2C Interface, SOT-23-6',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOT-23*'],do_erc=True,aliases=['MCP3425A1T-E/CH', 'MCP3425A2T-E/CH', 'MCP3425A3T-E/CH', 'MCP3421A0T-E/CH'],pins=[
            Pin(num='1',name='Vin+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SCL',do_erc=True),
            Pin(num='4',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='Vin-',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MCP3550-50-E/MS',dest=TEMPLATE,tool=SKIDL,keywords='Sigma-Delta ADC Converter 22bit SPI 1ch',description='Single Delta-Sigma 22bit Analog to Digital Converter, SPI Interface, MSOP-8',ref_prefix='U',num_units=1,fplist=['MSOP*'],do_erc=True,aliases=['MCP3551-E/MS'],pins=[
            Pin(num='1',name='Vref',do_erc=True),
            Pin(num='2',name='Vin+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Vin-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SCK',do_erc=True),
            Pin(num='6',name='SDO/~RDY~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~CS~',do_erc=True),
            Pin(num='8',name='Vdd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP3550-60-E/SN',dest=TEMPLATE,tool=SKIDL,keywords='Sigma-Delta ADC Converter 22bit SPI 1ch',description='Single Delta-Sigma 22bit Analog to Digital Converter, SPI Interface, MSOP-8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['MCP3553-E/SN'],pins=[
            Pin(num='1',name='Vref',do_erc=True),
            Pin(num='2',name='Vin+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Vin-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SCK',do_erc=True),
            Pin(num='6',name='SDO/~RDY~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~CS~',do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP4728',dest=TEMPLATE,tool=SKIDL,keywords='dac i2c',description='12-bit digital to analog converter, quad output, 2.048V internal reference, integrated EEPROM, I2C interface',ref_prefix='U',num_units=1,fplist=['*SOP*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SCL',do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~LDAC',do_erc=True),
            Pin(num='5',name='RDY/~BSY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VOUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='VOUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VOUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='VOUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP4801',dest=TEMPLATE,tool=SKIDL,keywords='12-Bit DAC SPI Reference 1ch',description='12-Bit D/A Converters with SPI Interface, internal Reference (2.048V)',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'MSOP*3x3mm*Pitch0.65mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['MCP4811', 'MCP4821'],pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~CS',do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='SDI',do_erc=True),
            Pin(num='5',name='~LDAC',do_erc=True),
            Pin(num='6',name='~SHDN',do_erc=True),
            Pin(num='7',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Vout',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP4801-E/MC',dest=TEMPLATE,tool=SKIDL,keywords='12-Bit DAC SPI Reference 1ch',description='12-Bit D/A Converters with SPI Interface, internal Reference (2.048V)',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x2mm*Pitch0.5mm*'],do_erc=True,aliases=['MCP4811-E/MC', 'MCP4821-E/MC'],pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~CS',do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='SDI',do_erc=True),
            Pin(num='5',name='~LDAC',do_erc=True),
            Pin(num='6',name='~SHDN',do_erc=True),
            Pin(num='7',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='PAD/Vss',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP4802',dest=TEMPLATE,tool=SKIDL,keywords='12-Bit DAC SPI Reference 2ch',description='2-Channel 12-Bit D/A Converters with SPI Interface and Internal Reference (2.048V)',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*', 'MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,aliases=['MCP4812', 'MCP4822'],pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~CS',do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='SDI',do_erc=True),
            Pin(num='5',name='~LDAC',do_erc=True),
            Pin(num='6',name='VB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VA',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP4901',dest=TEMPLATE,tool=SKIDL,keywords='12-Bit DAC SPI 1ch',description='12-Bit D/A Converters with SPI Interface',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'MSOP*3x3mm*Pitch0.65mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['MCP4911', 'MCP4921'],pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~CS',do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='SDI',do_erc=True),
            Pin(num='5',name='~LDAC',do_erc=True),
            Pin(num='6',name='Vref',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Vout',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP4901-E/MC',dest=TEMPLATE,tool=SKIDL,keywords='12-Bit DAC SPI 1ch',description='12-Bit D/A Converters with SPI Interface',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x2mm*Pitch0.5mm*'],do_erc=True,aliases=['MCP4911-E/MC', 'MCP4921-E/MC'],pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~CS',do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='SDI',do_erc=True),
            Pin(num='5',name='~LDAC',do_erc=True),
            Pin(num='6',name='Vref',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Vout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='PAD/Vss',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP4902',dest=TEMPLATE,tool=SKIDL,keywords='12-Bit DAC SPI 2CH',description='2-Channel 12-Bit D/A Converters with SPI Interface',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x8.7mm*Pitch1.27mm*', 'TSSOP*4.4x5mm*Pitch0.65mm*'],do_erc=True,aliases=['MCP4912', 'MCP4922'],pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~CS',do_erc=True),
            Pin(num='4',name='SCK',do_erc=True),
            Pin(num='5',name='SDI',do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='~LDAC',do_erc=True),
            Pin(num='9',name='~SHDN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='VrefB',do_erc=True),
            Pin(num='12',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VrefA',do_erc=True),
            Pin(num='14',name='VA',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP4921-E/MS',dest=TEMPLATE,tool=SKIDL,keywords='Single DAC 1ch 12bit SPI',description='Single 12-bit Digital to Analog Converter, SPI Interface, SOIC-8',ref_prefix='U',num_units=1,fplist=['MSOP*', 'SOIC*', 'DIP*', 'PDIP*'],do_erc=True,aliases=['MCP4921-E/SN', 'MCP4921-E/P'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~CS~',do_erc=True),
            Pin(num='3',name='SCK',do_erc=True),
            Pin(num='4',name='SDI',do_erc=True),
            Pin(num='5',name='~LDAC~',do_erc=True),
            Pin(num='6',name='VrefA',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VoutA',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MCP4922-E/P',dest=TEMPLATE,tool=SKIDL,keywords='Dual DAC 1ch 12bit SPI',description='Dual 12-bit Digital to Analog Converter, SPI Interface, TSSOP-14',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SO*', 'SOIC*', 'TSSOP*'],do_erc=True,aliases=['MCP4922-E/SL', 'MCP4922-E/ST'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~CS~',do_erc=True),
            Pin(num='4',name='SCK',do_erc=True),
            Pin(num='5',name='SDI',do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='~LDAC~',do_erc=True),
            Pin(num='9',name='~SHDN~',do_erc=True),
            Pin(num='10',name='VoutB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='VrefB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VrefA',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='VoutA',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PT2399',dest=TEMPLATE,tool=SKIDL,keywords='CMOS ADC DAC 44K Digital processing VCO',description='Echo Processor IC',ref_prefix='U',num_units=1,fplist=['DIP-16*'],do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='REF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CLK_O',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='VCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='CC1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='CC0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='OP1-OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='OP1-IN',do_erc=True),
            Pin(num='11',name='OP2-IN',do_erc=True),
            Pin(num='12',name='OP2-OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='LPF2-IN',do_erc=True),
            Pin(num='14',name='LPF2-OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='LPF1-OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='LPF1-IN',do_erc=True)]),
        Part(name='TDA8702',dest=TEMPLATE,tool=SKIDL,keywords='DAC CNA VIDEO',description='8bit Video DAC (32 MHz), SOIC-16',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SO*', 'SOIC*'],do_erc=True,aliases=['TDA8702T'],pins=[
            Pin(num='1',name='VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='DB2',do_erc=True),
            Pin(num='4',name='DB3',do_erc=True),
            Pin(num='5',name='CLK',do_erc=True),
            Pin(num='6',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DB7',do_erc=True),
            Pin(num='8',name='DB6',do_erc=True),
            Pin(num='9',name='DB5',do_erc=True),
            Pin(num='10',name='DB4',do_erc=True),
            Pin(num='11',name='DB1',do_erc=True),
            Pin(num='12',name='DB0',do_erc=True),
            Pin(num='13',name='VCCD',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='~VOUT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='VCCA',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TDC1408',dest=TEMPLATE,tool=SKIDL,description='TDC1408',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='MSB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='D2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='D3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='D4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VEE',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VEE',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VEE',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='VIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='D5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='VIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='D6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='VIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='D7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='RT',do_erc=True),
            Pin(num='16',name='LSB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='RB',do_erc=True),
            Pin(num='17',name='CONV',do_erc=True),
            Pin(num='19',name='AGND',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLV5627CD',dest=TEMPLATE,tool=SKIDL,keywords='DAC 4CH 8bit',description='4-Channel DAC, 8bit, w/ Power Down, TSSOP-16',ref_prefix='U',num_units=1,do_erc=True,aliases=['TLV5627CPW'],pins=[
            Pin(num='1',name='DVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~PD',do_erc=True),
            Pin(num='3',name='~LDAC',do_erc=True),
            Pin(num='4',name='DIN',do_erc=True),
            Pin(num='5',name='SCLK',do_erc=True),
            Pin(num='6',name='~CS',do_erc=True),
            Pin(num='7',name='FS',do_erc=True),
            Pin(num='8',name='DGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='REFINCD',do_erc=True),
            Pin(num='11',name='OUTD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='OUTC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='OUTB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='OUTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='REFINAB',do_erc=True),
            Pin(num='16',name='AVDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='UVC3100',dest=TEMPLATE,tool=SKIDL,keywords='8bit ADC 10bit DAC CCD',description='High Speed 30MHz Flash 8-bit ADC 10MHz 10-bit DAC, For CCD Digitizers',ref_prefix='U',num_units=1,do_erc=True,aliases=['UVC3101'],pins=[
            Pin(num='2',name='VOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='-5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='DI9',do_erc=True),
            Pin(num='5',name='DI8',do_erc=True),
            Pin(num='6',name='DI7',do_erc=True),
            Pin(num='7',name='DI6',do_erc=True),
            Pin(num='8',name='DI5',do_erc=True),
            Pin(num='9',name='DI4',do_erc=True),
            Pin(num='10',name='DI3',do_erc=True),
            Pin(num='20',name='PCLE',do_erc=True),
            Pin(num='30',name='DO4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='DI2',do_erc=True),
            Pin(num='21',name='VIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='DO3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='DI1',do_erc=True),
            Pin(num='22',name='CLEV',do_erc=True),
            Pin(num='32',name='DO2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='DI0',do_erc=True),
            Pin(num='23',name='KEYP',do_erc=True),
            Pin(num='33',name='DO1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VCC',do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='DO0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='CKDA',do_erc=True),
            Pin(num='25',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='-5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='DO7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='CKAD',do_erc=True),
            Pin(num='28',name='DO6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='EAIN',do_erc=True),
            Pin(num='19',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='DO5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='SWI',do_erc=True)])])