"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudscapeReactTsWebsiteProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const web_1 = require("projen/lib/web");
/**
 * Synthesizes a Cloudscape React Typescript Website Project.
 *
 * @pjid cloudscape-react-ts-website
 */
class CloudscapeReactTsWebsiteProject extends web_1.ReactTypeScriptProject {
    constructor(options) {
        super({
            ...options,
            defaultReleaseBranch: options.defaultReleaseBranch,
            name: options.name,
            sampleCode: false,
            readme: {
                contents: fs
                    .readFileSync(path.resolve(__dirname, "../README.md"))
                    .toString(),
            },
            gitignore: ["runtime-config.json"],
        });
        this.addDevDeps("@babel/plugin-proposal-private-property-in-object");
        this.addDeps("@cloudscape-design/global-styles", "@cloudscape-design/components", "@cloudscape-design/collection-hooks", "react-router-dom", "aws-amplify", "@aws-amplify/ui-react");
        this.applicationName = options.applicationName ?? "Sample App";
        this.publicDir = options.publicDir ?? "public";
        const srcDir = path.resolve(__dirname, "../samples/src");
        new projen_1.SampleDir(this, this.srcdir, {
            files: {
                ...Object.fromEntries(fs
                    .readdirSync(srcDir)
                    .filter((f) => f !== "config.json")
                    .map((name) => [
                    name,
                    fs.readFileSync(`${srcDir}/${name}`).toString(),
                ])),
                "config.json": JSON.stringify({
                    applicationName: this.applicationName,
                }, undefined, 2),
            },
        });
        const publicDir = path.resolve(__dirname, "../samples/public");
        new projen_1.SampleDir(this, this.publicDir, {
            sourceDir: publicDir,
            files: {
                // override index.html to pass through applicationName
                "index.html": fs
                    .readFileSync(`${publicDir}/index.html`)
                    .toString()
                    .replace("<title></title>", `<title>${this.applicationName}</title>`),
            },
        });
    }
}
exports.CloudscapeReactTsWebsiteProject = CloudscapeReactTsWebsiteProject;
_a = JSII_RTTI_SYMBOL_1;
CloudscapeReactTsWebsiteProject[_a] = { fqn: "@aws-prototyping-sdk/cloudscape-react-ts-website.CloudscapeReactTsWebsiteProject", version: "0.5.0" };
//# sourceMappingURL=data:application/json;base64,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