# generated by fastapi-codegen:
#   filename:  fossy.yaml
#   timestamp: 2021-10-11T17:54:57+00:00

from __future__ import annotations

from datetime import date
from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Field, SecretStr, constr


class LicenseDecider(BaseModel):
    nomos_monk: Optional[bool] = Field(
        None,
        description='Scanners matches if all Nomos findings are within the Monk findings.',
    )
    bulk_reused: Optional[bool] = Field(
        None, description='Bulk phrases from reused packages.'
    )
    new_scanner: Optional[bool] = Field(
        None,
        description='New scanner results, i.e., decisions were marked as work in progress if new scanner finds additional licenses.',
    )
    ojo_decider: Optional[bool] = Field(
        None,
        description='Scanners matches if Ojo or REUSE.Software findings are no contradiction with other findings.',
    )


class ClearingStatus(Enum):
    Open = 'Open'
    InProgress = 'InProgress'
    Closed = 'Closed'
    Rejected = 'Rejected'


class UploadSummary(BaseModel):
    id: Optional[int] = Field(None, description='Upload id of the upload.')
    uploadName: Optional[str] = Field(
        None, description='Display name of the upload.')
    assignee: Optional[int] = Field(
        None, description='assignee id of the upload.')
    mainLicense: Optional[str] = Field(
        None, description='Main license selected on the upload.'
    )
    uniqueLicenses: Optional[int] = Field(
        None, description='No. of unique licenses found.'
    )
    totalLicenses: Optional[int] = Field(
        None, description='Total no. of licenses found.'
    )
    uniqueConcludedLicenses: Optional[int] = Field(
        None, description='Unique licenses concluded.'
    )
    totalConcludedLicenses: Optional[int] = Field(
        None, description='Total concluded licenses.'
    )
    filesToBeCleared: Optional[int] = Field(
        None, description='Files without clearing decisions.'
    )
    filesCleared: Optional[int] = Field(
        None, description='Files with clearing decisions.'
    )
    clearingStatus: Optional[ClearingStatus] = Field(
        None, description='Upload is clearing status.'
    )
    copyrightCount: Optional[int] = Field(
        None, description='No. of copyrights found in the upload.'
    )


class Status(Enum):
    Completed = 'Completed'
    Failed = 'Failed'
    Queued = 'Queued'
    Processing = 'Processing'


class Job(BaseModel):
    id: Optional[int] = Field(None, description='ID of the job')
    name: Optional[str] = Field(None, description='Name of the job')
    queueDate: Optional[str] = Field(
        None, description='When the job was queued')
    uploadId: Optional[int] = Field(
        None, description='Upload for which the job was scheduled'
    )
    userId: Optional[int] = Field(
        None, description='User who scheduled the job')
    groupId: Optional[int] = Field(
        None, description='Group under which the job was scheduled'
    )
    eta: Optional[int] = Field(
        None, description='ETA of job to finish in seconds')
    status: Optional[Status] = Field(
        None, description='Denotes the current status of the job in the queue'
    )


class Type(Enum):
    INFO = 'INFO'
    ERROR = 'ERROR'


class Info(BaseModel):
    code: Optional[int] = Field(
        None, description='HTTP status code', example=200)
    message: Optional[str] = Field(None, description='Message in the info')
    type: Optional[Type] = Field(
        None, description='Denotes if info was created on error'
    )


class AccessLevel(Enum):
    none = 'none'
    read_only = 'read_only'
    read_write = 'read_write'
    admin = 'admin'


class Analysis(BaseModel):
    bucket: Optional[bool] = Field(
        None, description='Should bucket analysis be run on this upload'
    )
    copyright_email_author: Optional[bool] = Field(
        None,
        description='Should Copyright/Email/URL/Author Analysis be run on this upload.',
    )
    ecc: Optional[bool] = Field(
        None, description='Should ECC Analysis be run on this upload.'
    )
    keyword: Optional[bool] = Field(
        None, description='Should keyword Analysis be run on this upload.'
    )
    mime: Optional[bool] = Field(
        None, description='Should MIME Analysis be run on this upload.'
    )
    monk: Optional[bool] = Field(
        None, description='Should Monk Analysis be run on this upload.'
    )
    nomos: Optional[bool] = Field(
        None, description='Should Nomos Analysis be run on this upload.'
    )
    ojo: Optional[bool] = Field(
        None, description='Should OJO Analysis be run on this upload.'
    )
    package: Optional[bool] = Field(
        None, description='Should Package Analysis be run on this upload.'
    )
    reso: Optional[bool] = Field(
        None, description='Should REUSE.Software Analysis be run on this upload.'
    )


class Reuser(BaseModel):
    reuse_upload: Optional[int] = Field(
        None, description='The UploadID to reuse.')
    reuse_group: str = Field(..., description='The group of the reused upload')
    reuse_main: Optional[bool] = Field(
        None, description='Copy the main license from reused package?'
    )
    reuse_enhanced: Optional[bool] = Field(
        None, description='Run enhanced reuser with diff tool (slow)'
    )
    reuse_report: Optional[bool] = Field(
        None, description='Copy all report configuration from conf page.'
    )
    reuse_copyright: Optional[bool] = Field(
        None, description='Copy the copyright deactivation and edits.'
    )


class Folder(BaseModel):
    id: Optional[int] = Field(None, description='Id of the folder.')
    name: Optional[str] = Field(None, description='Name of the folder.')
    description: Optional[str] = Field(
        None, description='Description of the folder.')
    parent: Optional[int] = Field(
        None, description='Id of the parent folder (if any, null otherwise).'
    )


class TokenScope(Enum):
    read = 'read'
    write = 'write'


class TokenRequest(BaseModel):
    username: str = Field(..., description='Username of the login user.')
    password: SecretStr = Field(
        ..., description='Password of the user trying to login.'
    )
    token_name: constr(max_length=40) = Field(
        ..., description='Friendly name of the token'
    )
    token_scope: TokenScope = Field(..., description='The scope of the token.')
    token_expire: date = Field(
        ..., description='Date when the token must expire (default max 30 days).'
    )


class VcsType(Enum):
    svn = 'svn'
    git = 'git'


class VcsUpload(BaseModel):
    vcsType: VcsType = Field(..., description='VCS type')
    vcsUrl: str = Field(..., description='URL of the repository')
    vcsBranch: Optional[str] = Field(
        None, description='Branch to checkout for analysis (for Git only)'
    )
    vcsName: Optional[str] = Field(
        None, description='Display name of the upload')
    vcsUsername: Optional[str] = Field(
        None, description='Username for the VCS')
    vcsPassword: Optional[str] = Field(
        None, description='Password for the VCS')


class UrlUpload(BaseModel):
    url: str = Field(..., description='URL for file/folder to be uploaded')
    name: Optional[str] = Field(
        None, description='Viewable name for this file or directory'
    )
    accept: Optional[str] = Field(
        None,
        description='Comma-separated lists of file name suffixes or patterns to accpet\n',
    )
    reject: Optional[str] = Field(
        None,
        description='Comma-separated lists of file name suffixes or patterns to reject\n',
    )
    maxRecursionDepth: Optional[int] = Field(
        None, description='Maximum recursion depth for folders (0 for infinite)'
    )


class ServerUpload(BaseModel):
    path: str = Field(
        ..., description='File path to be uploaded (reccursive, support *)'
    )
    name: Optional[str] = Field(
        None, description='Viewable name for this file or directory'
    )


class Hash(BaseModel):
    sha1: Optional[str] = Field(
        None,
        description='SHA1 checksum of the file',
        example='81fe8bfe87576c3ecb22426f8e57847382917acf',
    )
    md5: Optional[str] = Field(
        None,
        description='MD5 checksum of the file',
        example='e2fc714c4727ee9395f324cd2e7f331f',
    )
    sha256: Optional[str] = Field(
        None,
        description='SHA256 checksum of the file',
        example='88d4266fd4e6338d13b845fcf289579d209c897823b9217da3e161936f031589',
    )
    size: Optional[int] = Field(None, description='Size of the file in bytes')


class Message(Enum):
    Not_found = 'Not found'
    Invalid_keys = 'Invalid keys'


class Findings(BaseModel):
    scanner: Optional[List[str]] = Field(
        None, description='Licenses finding by scanner', example=['MIT', 'BSD-3-Clause']
    )
    conclusion: Optional[List[str]] = Field(
        None,
        description='Licenses concluded by user or main license in case of package\n',
        example=['MIT', 'GPL-2.0'],
    )
    copyright: Optional[List[str]] = Field(
        None,
        description='Copyright findings for the file\n',
        example=[
            'Copyright (C) 2017-2020 Free Software Foundation, Inc.',
            'Copyright (C) 1991-2020 Free Software Foundation, Inc.',
        ],
    )


class License(BaseModel):
    shortName: Optional[str] = Field(
        None, description='Short name', example='MIT')
    fullName: Optional[str] = Field(
        None, description='Full name', example='MIT License'
    )
    text: Optional[str] = Field(
        None,
        description='License text',
        example='MIT License Copyright (c) <year> <copyright holders> ...',
    )
    url: Optional[str] = Field(
        None,
        description='URL of the license text',
        example='https://opensource.org/licenses/MIT',
    )
    risk: Optional[int] = Field(None, description='Risk level', example=3)
    isCandidate: Optional[bool] = Field(
        None, description='Is the license a candidate?')


class Group(BaseModel):
    id: Optional[int] = Field(None, description='Id key', example=126)
    name: Optional[str] = Field(
        None, description='Name of a group', example='Main group'
    )


class Classification(Enum):
    green = 'green'
    white = 'white'
    yellow = 'yellow'
    red = 'red'


class Obligation(BaseModel):
    id: Optional[int] = Field(None, description='Id key', example=126)
    topic: Optional[str] = Field(
        None, description='Obligation topic', example='Should preserve notice'
    )
    type: Optional[str] = Field(
        None, description='Type of obligation', example='Obligation'
    )
    text: Optional[str] = Field(
        None,
        description='Obligation text',
        example='All notices from the package should be preserved.',
    )
    classification: Optional[Classification] = Field(
        None,
        description='Level of attention this obligation should raise in the clearing process\n',
    )
    comment: Optional[str] = Field(
        None,
        description='Comments for the obligation',
        example='Please respect the obligation',
    )


class License1(BaseModel):
    name: Optional[str] = Field(None, description='Name of license')
    url: Optional[str] = Field(None, description='Link to license')


class ApiInfo(BaseModel):
    name: Optional[str] = Field(None, description='Name of the API service')
    description: Optional[str] = Field(
        None, description='Additional information')
    version: Optional[str] = Field(
        None, description='Current API version as per documentation'
    )
    security: Optional[List[str]] = Field(
        None, description='Security methods allowed')
    contact: Optional[str] = Field(
        None, description='Contact email from API docs')
    license: Optional[License1] = Field(None, description='Licensing of API')


class Status1(Enum):
    OK = 'OK'
    WARN = 'WARN'
    ERROR = 'ERROR'


class Status2(Enum):
    OK = 'OK'
    ERROR = 'ERROR'


class Scheduler(BaseModel):
    status: Optional[Status2] = Field(
        None, description='Health status of scheduler')


class Status3(Enum):
    OK = 'OK'
    ERROR = 'ERROR'


class Db(BaseModel):
    status: Optional[Status3] = Field(
        None, description='Health status of DB connection'
    )


class HeathInfo(BaseModel):
    status: Optional[Status1] = Field(None, description='Status of service')
    scheduler: Optional[Scheduler] = Field(
        None, description='Scheduler information')
    db: Optional[Db] = Field(None, description='DB connection status')


class TokensPostResponse(BaseModel):
    header: Optional[str] = None


class Status4(Enum):
    Open = 'Open'
    InProgress = 'InProgress'
    Closed = 'Closed'
    Rejected = 'Rejected'


class Status5(Enum):
    Open = 'Open'
    InProgress = 'InProgress'
    Closed = 'Closed'
    Rejected = 'Rejected'


class UploadType(Enum):
    vcs = 'vcs'
    url = 'url'
    server = 'server'


class UploadsPostRequest(BaseModel):
    __root__: Union[VcsUpload, UrlUpload, ServerUpload]


class UploadsPostRequest1(BaseModel):
    fileInput: Optional[bytes] = None


class Public(Enum):
    private = 'private'
    protected = 'protected'
    public = 'public'


class UploadType1(Enum):
    vcs = 'vcs'
    url = 'url'
    server = 'server'


class UploadType2(Enum):
    vcs = 'vcs'
    url = 'url'
    server = 'server'


class AgentEnum(Enum):
    nomos = 'nomos'
    monk = 'monk'
    ninka = 'ninka'
    ojo = 'ojo'
    reportImport = 'reportImport'
    reso = 'reso'


class Agent(Enum):
    nomos = 'nomos'
    monk = 'monk'
    ninka = 'ninka'
    ojo = 'ojo'
    reportImport = 'reportImport'
    reso = 'reso'


class SearchType(Enum):
    directory = 'directory'
    containers = 'containers'
    allfiles = 'allfiles'


class SearchType1(Enum):
    directory = 'directory'
    containers = 'containers'
    allfiles = 'allfiles'


class SearchType2(Enum):
    directory = 'directory'
    containers = 'containers'
    allfiles = 'allfiles'


class Action(Enum):
    copy = 'copy'
    move = 'move'


class Action1(Enum):
    copy = 'copy'
    move = 'move'


class ReportFormat(Enum):
    dep5 = 'dep5'
    spdx2 = 'spdx2'
    spdx2tv = 'spdx2tv'
    readmeoss = 'readmeoss'
    unifiedreport = 'unifiedreport'


class ReportFormat1(Enum):
    dep5 = 'dep5'
    spdx2 = 'spdx2'
    spdx2tv = 'spdx2tv'
    readmeoss = 'readmeoss'
    unifiedreport = 'unifiedreport'


class ReportFormat2(Enum):
    dep5 = 'dep5'
    spdx2 = 'spdx2'
    spdx2tv = 'spdx2tv'
    readmeoss = 'readmeoss'
    unifiedreport = 'unifiedreport'


class Kind(Enum):
    candidate = 'candidate'
    main = 'main'
    all = 'all'


class LicenseGetResponse(License):
    id: Optional[int] = Field(None, description='Id key', example=125)


class Kind1(Enum):
    candidate = 'candidate'
    main = 'main'
    all = 'all'


class LicensePostRequest(License):
    mergeRequest: Optional[bool] = Field(
        False, description='Open a merge request for candidate license?'
    )


class LicenseShortnameGetResponse(License):
    id: Optional[int] = Field(None, description='Id key', example=125)
    obligations: Optional[List[Obligation]] = Field(
        None, description='Obligations associated with the license'
    )


class LicenseShortnamePatchRequest(BaseModel):
    fullName: Optional[str] = Field(
        None, description='New fullname', example='Updated license name'
    )
    text: Optional[str] = Field(
        None,
        description='New license text',
        example='Updated and corrected license text',
    )
    url: Optional[str] = Field(
        None,
        description='New URL for license',
        example='https://opensource.org/licenses/MIT',
    )
    risk: Optional[int] = Field(None, description='New risk value', example=2)


class ScanOptions(BaseModel):
    analysis: Optional[Analysis] = None
    decider: Optional[LicenseDecider] = None
    reuse: Optional[Reuser] = None


class Upload(BaseModel):
    folderid: Optional[int] = Field(
        None, description='The folder id, where the upload is located'
    )
    foldername: Optional[str] = Field(
        None, description='The name of the folder where the upload is located'
    )
    id: Optional[int] = Field(None, description='Upload id of the upload.')
    description: Optional[str] = Field(
        None, description='Description of the upload.')
    uploadname: Optional[str] = Field(
        None, description='Display name of the upload.')
    uploaddate: Optional[str] = Field(
        None, description='Date, when the file was uploaded.'
    )
    assignee: Optional[int] = Field(
        None, description='assignee id of the upload.')
    hash: Optional[Hash] = None


class User(BaseModel):
    id: int = Field(..., description='ID of the user')
    name: str = Field(..., description='Unique username')
    description: str = Field(..., description='Description of the user')
    email: Optional[str] = Field(
        None, description='Email of the user, needs to be unique and is required'
    )
    accessLevel: Optional[AccessLevel] = None
    rootFolderId: Optional[float] = Field(
        None, description='root folder id of the user'
    )
    emailNotification: Optional[bool] = Field(
        None, description='enable email notification when upload scan completes'
    )
    agents: Optional[Analysis] = None


class UploadLicense(BaseModel):
    filePath: Optional[str] = Field(
        None, description='Relative file path', example='path/to/LICENSE'
    )
    findings: Optional[Findings] = None


class UploadLicenses(BaseModel):
    __root__: List[UploadLicense]


class File(BaseModel):
    hash: Hash
    findings: Optional[Findings] = None
    uploads: Optional[List[int]] = Field(
        None, description='Upload ID if the file was uploaded as a package'
    )
    message: Optional[Message] = Field(
        None,
        description='Message in case provided hash not found or error',
        example='Not found',
    )


class SearchResults(BaseModel):
    upload: Optional[Upload] = None
    uploadTreeId: Optional[int] = Field(None, description='Upload tree ID')
    filename: Optional[str] = Field(
        None, description='Filename of the treeItem')
