<p align="center">
   <img width = "800" src="https://github.com/discsim/frank/blob/master/docs/images/day_off.png?raw=true"/>		   
 </p>

<p align="center">
  <a href="https://github.com/discsim/frank/releases">
      <img src="https://img.shields.io/github/release/discsim/frank/all.svg">
  </a>

  <a href="https://pypi.python.org/pypi/frank">
      <img src="https://img.shields.io/pypi/v/frank.svg">
  </a>

  <a href="https://discsim.github.io/frank/blob/master/HISTORY.rst">
    <img src="https://img.shields.io/badge/Changelog-detailed-blue"/>

  <br/>
  <a href="https://discsim.github.io/frank/">
    <img src="https://img.shields.io/badge/docs-Read%20em!-blue.svg?style=flat"/>

  <br/>
  <a href="https://academic.oup.com/mnras/advance-article/doi/10.1093/mnras/staa1365/5838058?guestAccessKey=7f163a1f-c12f-4771-8e54-928636794a5b">
      <img src="https://img.shields.io/badge/paper-MNRAS-blue.svg">
  </a>

  <a href="https://doi.org/10.5281/zenodo.3832064">
      <img src="https://zenodo.org/badge/DOI/10.5281/zenodo.3832064.svg" alt="DOI">
  </a>

  <br/>
  <a href="https://circleci.com/gh/discsim/frank">
      <img src="https://circleci.com/gh/discsim/frank.svg?style=shield">
  </a>    

  <a href="https://discsim.github.io/frank/coverage/index.html">
      <img src="https://discsim.github.io/frank/coverage/badge.svg">
  </a>   

  <br/>
  <a href="https://www.gnu.org/licenses/lgpl-3.0">
      <img src="https://img.shields.io/badge/License-LGPL%20v3-blue.svg"
      [![License: LGPL v3](https://img.shields.io/badge/License-LGPL%20v3-blue.svg">
  </a>      
</p>

Frankenstein (**frank**) is a library that fits the 1D radial brightness profile of an interferometric source given a set of visibilities. It uses a Gaussian process that performs the fit in <1 minute for a typical protoplanetary disc continuum dataset.

Get the code
------------
**frank**'s on [PyPI](https://pypi.org/project/frank), so you can just use pip,
```
pip install frank
```

Documentation
-------------
The [docs](https://discsim.github.io/frank/) have it all.

Attribution
-----------
If you use **frank** for your research please cite Jennings, Booth, Tazzari et al. 2020 MNRAS 495(3) 3209
[[MNRAS]](https://academic.oup.com/mnras/article/495/3/3209/5838058?guestAccessKey=7f163a1f-c12f-4771-8e54-928636794a5b)
[[ADS]](https://ui.adsabs.harvard.edu/abs/2020MNRAS.495.3209J/abstract)
[[arXiv]](https://arxiv.org/abs/2005.07709)
[[Zenodo]](https://doi.org/10.5281/zenodo.3832064):
```
@ARTICLE{2020MNRAS.495.3209J,
       author = {{Jennings}, Jeff and {Booth}, Richard A. and {Tazzari}, Marco and {Rosotti}, Giovanni P. and {Clarke}, Cathie J.},
        title = "{frankenstein: protoplanetary disc brightness profile reconstruction at sub-beam resolution with a rapid Gaussian process}",
      journal = {\mnras},
     keywords = {methods: data analysis, protoplanetary discs, techniques: interferometric, planets and satellites: detection, submillimetre: general, submillimetre: planetary systems, Astrophysics - Earth and Planetary Astrophysics, Astrophysics - Instrumentation and Methods for Astrophysics},
         year = 2020,
        month = jul,
       volume = {495},
       number = {3},
        pages = {3209-3232},
          doi = {10.1093/mnras/staa1365},
archivePrefix = {arXiv},
       eprint = {2005.07709},
 primaryClass = {astro-ph.EP},
       adsurl = {https://ui.adsabs.harvard.edu/abs/2020MNRAS.495.3209J},
      adsnote = {Provided by the SAO/NASA Astrophysics Data System}
}
```

**[These papers](https://ui.adsabs.harvard.edu/search/q=citations(doi%3A10.1093%2Fmnras%2Fstaa1365)%20&sort=date%20desc%2C%20bibcode%20desc&p_=0)** cite **frank**.

Authors
-------
- [Richard 'Dr. Frankenstein' Booth (University of Cambridge)](https://github.com/rbooth200)

- [Jeff 'The Monster' Jennings (University of Cambridge)](https://github.com/jeffjennings)

- [Marco 'It's Alive!!!' Tazzari (University of Cambridge)](https://github.com/mtazzari)

### Contact ###
Interested in collaborating to improve, extend or apply **frank**?
Or just have questions about the code that don't require submitting an issue?
[Email Jeff!](mailto:jmj51@ast.cam.ac.uk)

License
-------
**frank** is free software licensed under the LGPLv3 License. For more details see the [LICENSE](https://github.com/discsim/frank/blob/master/LICENSE.txt).

© Copyright 2019-2020 Richard Booth, Jeff Jennings, Marco Tazzari.

Image: Universal Studios, NBCUniversal [Public domain]
