# AUTOGENERATED! DO NOT EDIT! File to edit: viz.ipynb (unless otherwise specified).

__all__ = ['triangle3d_plotly', 'TrianglePlotBokeh', 'VizPreds']

# Cell
import plotly.graph_objects as go
from fastai.vision.all import *

def triangle3d_plotly(pred, targ=None, labels=['x','y','z'], show_axes=True, show_bounds=True, cmap='jet'):
    "plot a 3d triangle plot using plot.ly."

    colors = pred if (targ is None) else [ ['red','green','blue'][i] for i in targ]

    fig = go.Figure(data=[go.Scatter3d(x=pred[:,0], y=pred[:,1], z=pred[:,2],
        mode='markers', marker=dict(size=5, opacity=0.6, color=colors))])
    fig.update_layout(scene = dict(
                        xaxis_title=f'{labels[0]} - ness', yaxis_title=f'{labels[1]} - ness', zaxis_title=f'{labels[2]} - ness',
                        annotations=[
                        dict(text=labels[0], xanchor='center', x=1, y=0, z=0),
                        dict(text=labels[1], xanchor='center', x=0, y=1, z=0),
                        dict(text=labels[2], xanchor='center', x=0, y=0, z=1)]),
                        width=700, margin=dict(r=20, b=10, l=10, t=10), showlegend=False
                        )
    if show_bounds:
        fig.add_trace( go.Scatter3d(mode='lines', x=[0.333,0.5], y=[0.333,0.5], z=[0.333,0],
            line=dict(color='black', width=5) ))
        fig.add_trace( go.Scatter3d(mode='lines', x=[0.333,0], y=[0.333,0.5], z=[0.333,0.5],
            line=dict(color='black', width=5) ))
        fig.add_trace( go.Scatter3d(mode='lines', x=[0.333,0.5], y=[0.333,0], z=[0.333,0.5],
            line=dict(color='black', width=5) ))
    return fig.show()

# Cell
from kora.bokeh import figure
from bokeh.plotting import ColumnDataSource, output_file, show, output_notebook
from bokeh.models import Label
import numpy as np

class TrianglePlotBokeh():
    """Plot categority predictions for 3 categories - using bokeh
        pred: (n,3): probability values of n data points in each of 3 classes
        targ: (n):   target value (0,1,2) for each data point
        One issue/feature is that kora must be calling output_file, so bokeh opens a new tab
    """

    def __init__(self, pred, targ, labels=['0','1','2'], show_bounds=False):
        store_attr()
        output_notebook # output_file("toolbar.html")
        self.colors = ["blue","red","green"]
        self.TOOLTIPS_HTML = """
            <div>
                <div>
                    <img
                        src="@imgs" height="50" alt="@imgs"
                        style="float: left; margin: 0px 15px 15px 0px;"
                        border="2"
                    ></img>
                </div>
                <div>
                    <span style="font-size: 17px; font-weight: bold;">@desc</span>
                    <span style="font-size: 15px; color: #966;">[$index]</span>
                </div>
                <!---commenting-out coordinate values <div>
                    <span style="font-size: 10px; color: #696;">($x, $y)</span>
                </div> -->
            </div>
        """
        self.clear()

    def clear(self):
        self.p = figure(350,400, tooltips=self.TOOLTIPS_HTML, title="Mouse over the dots") # note xsize & ysize are reversed

    def do_plot(self):
        xs, ys = self.pred.T[1] - self.pred.T[0], self.pred.T[2]

        #bears: tmp_urls = [ 'https://static.wikia.nocookie.net/disney-animals/images/a/aa/North-america-grizzly-bear-625x450.jpg',\
        #        'https://upload.wikimedia.org/wikipedia/commons/0/08/01_Schwarzb%C3%A4r.jpg',\
        #        'https://images-na.ssl-images-amazon.com/images/I/81J4TvhJx1L.__AC_SX300_SY300_QL70_FMwebp_.jpg']
        tmp_urls = ['https://upload.wikimedia.org/wikipedia/commons/thumb/4/4f/Felis_silvestris_catus_lying_on_rice_straw.jpg/220px-Felis_silvestris_catus_lying_on_rice_straw.jpg',
                'https://upload.wikimedia.org/wikipedia/commons/6/60/YellowLabradorLooking.jpg',
                'https://upload.wikimedia.org/wikipedia/commons/thumb/e/ea/SilverMorgan.jpg/250px-SilverMorgan.jpg']
        for i in range(3):  # for each category
            jind = np.where(self.targ == i)
            x, y = xs[jind], ys[jind]
            n = len(y)
            urls = [tmp_urls[i]]*n
            source = ColumnDataSource( data=dict(x=x, y=y, desc=[self.labels[i]]*n, imgs=urls ) )
            self.p.circle('x', 'y', size=6, line_color=self.colors[i], fill_color=self.colors[i], source=source)

        self.p.add_layout( Label(x=-1, y=0, text=labels[0], text_align='right'))
        self.p.add_layout( Label(x=1, y=0, text=labels[1]))
        self.p.add_layout( Label(x=0, y=1, text=labels[2], text_align='center'))

        if self.show_bounds: pass   # TODO: add this

        show(self.p)
        return self.p

    def update(self, pred, targ):
        self.pred, self.targ = pred, targ
        self.clear()
        return self.do_plot()

# Cell
from fastai.vision.all import *

class VizPreds(Callback):
    "This callback is designed to call the bokeh triangle plot with each batch of training, using validation data."
    order = ProgressCallback.order+1
    def before_fit(self, **kwargs): self.plot = TrianglePlotBokeh(labels=self.dls.vocab)
    def after_batch(self, **kwargs):
        if not self.learn.training:
            with torch.no_grad():
                preds, targs = F.softmax(self.learn.pred, dim=1), self.learn.y
                preds, targs = [x.detach().cpu().numpy().copy() for x in [preds,targs]]
                self.plot.do_plot(preds, targs)