# AUTOGENERATED! DO NOT EDIT! File to edit: utils.ipynb (unless otherwise specified).

__all__ = ['softmax', 'calc_prob']

# Cell
import numpy as np

def softmax(x):
    e_x = np.exp(x - np.max(x, axis=-1, keepdims=True))
    return e_x / e_x.sum(axis=-1, keepdims=True)

def calc_prob(n=1000, s=2.5):
    "s = 'scale': how strongly to 'push' the points towards the ends"
    logits = (np.random.rand(n,3)*2-1)*s
    prob = softmax(logits)
    targ = np.argmax(prob, axis=1)  # target values
    return prob, targ