# AUTOGENERATED! DO NOT EDIT! File to edit: scrape.ipynb (unless otherwise specified).

__all__ = ['fetch_image_urls', 'download_and_save', 'search_and_download', 'Category', 'img_scrape', 'browse_images',
           'get_pca_xy', 'plot_hover', 'plot_triangle']

# Cell
from kora.selenium import wd

def fetch_image_urls(query:str, max_links_to_fetch:int, wd:wd, sleep_between_interactions:int=1):
    def scroll_to_end(wd_old):
        wd.execute_script("window.scrollTo(0, document.body.scrollHeight);")
        time.sleep(sleep_between_interactions)

    # build the google query
    search_url = "https://www.google.com/search?safe=off&site=&tbm=isch&source=hp&q={q}&oq={q}&gs_l=img"

    # load the page
    wd.get(search_url.format(q=query))

    image_urls = set()
    image_count = 0
    results_start = 0
    while image_count < max_links_to_fetch:
        scroll_to_end(wd)

        # get all image thumbnail results
        thumbnail_results = wd.find_elements_by_css_selector("img.Q4LuWd")
        number_results = len(thumbnail_results)

        print(f"\n{query}: Found: {number_results} search results. Extracting links from {results_start}:{number_results}")

        for img in thumbnail_results[results_start:number_results]:
            # try to click every thumbnail such that we can get the real image behind it
            try:
                img.click()
                time.sleep(sleep_between_interactions)
            except Exception:
                continue

            # extract image urls
            actual_images = wd.find_elements_by_css_selector('img.n3VNCb')
            for actual_image in actual_images:
                if actual_image.get_attribute('src') and 'http' in actual_image.get_attribute('src'):
                    image_urls.add(actual_image.get_attribute('src'))

            image_count = len(image_urls)

            if len(image_urls) >= max_links_to_fetch:
                print(f"{query}: Found: {len(image_urls)} image links, done!")
                break
        else:
            print(f"{query}: Found:", len(image_urls), "image links, looking for more ...")
            time.sleep(30)
            return
            load_more_button = wd.find_element_by_css_selector(".mye4qd")
            if load_more_button:
                wd.execute_script("document.querySelector('.mye4qd').click();")

        # move the result startpoint further down
        results_start = len(thumbnail_results)

    return image_urls


def download_and_save(folder_path:str, url:str, verbose:bool=True):
    success = False
    try:
        image_content = requests.get(url).content

    except Exception as e:
        print(f"ERROR - Could not download {url} - {e}")

    try:
        image_file = io.BytesIO(image_content)
        image = Image.open(image_file).convert('RGB')
        file_path = os.path.join(folder_path,hashlib.sha1(image_content).hexdigest()[:10] + '.jpg')
        with open(file_path, 'wb') as f:
            image.save(f, "JPEG", quality=85)
        if verbose:  print(f"SUCCESS - saved {url} - as {file_path}")
        success = True
    except Exception as e:
        print(f"ERROR - Could not save {url} - {e}")
    return success


def search_and_download(search_term:str, target_path:str='./images', number_images:int=10, verbose:bool=True):

    target_folder = os.path.join(target_path,'_'.join(search_term.lower().split(' ')))

    if not os.path.exists(target_folder):
        os.makedirs(target_folder)

    try_urls = fetch_image_urls(search_term, number_images, wd=wd, sleep_between_interactions=0.5)

    count, urls = 0, []      # save count of success and urls whose images were successfully saved
    for url in try_urls:
        rc = download_and_save(target_folder, url, verbose=verbose)
        if rc:
            count += 1
            urls.append(url)

    print(f"{search_term}: Expected {number_images}, succeeded at saving {count}.")
    return count, urls


# work inprogress
class Category():
    def __init__(self):
        self.images = []
        self.urls = []

    def __len__(self):
        ni, nu = len(self.images), len(self.urls)
        assert ni==nu
        return ni

# Cell
import os
import time
import requests
import io
from PIL import Image, ImageOps
import hashlib
import shutil
import glob


def img_scrape(search_terms:list, target_path:str='./.images', number_images:int=10, verbose:bool=True):

     # clear out directory before use
    for category_path in glob.glob(os.path.join(target_path, "*")):
        shutil.rmtree(category_path)

    dataset = {key: Category() for key in search_terms}

    for term in search_terms:
        count, urls = search_and_download(search_term = term, target_path=target_path, number_images=number_images)
        dataset[term].urls = urls   # save urls in case we want them later

    return dataset

# Cell
import matplotlib.pyplot as plt
from ipywidgets import interact
def browse_images(dataset):
    print("Select the class from the drop-down, and the image by moving the slider with the mouse or the arrow keys.")
    @interact(term=search_terms)
    def _browse_images(term):
        n = len(dataset[term])
        def view_image(i):
            plt.imshow(dataset[term].images[i], cmap=plt.cm.gray_r, interpolation='nearest')
            plt.show()
        interact(view_image, i=(0,n-1))

# Cell
from kora.bokeh import figure
from bokeh.plotting import ColumnDataSource, output_file, show
from numpy import linalg as LA

# We'll use PCA to get x & y coordinates at which to plot data points
#  For that, we need to crop/resize the images to make a uniform array shape
#  Note, for now we're not cropping, so the resize skews the images!
def get_pca_xy():

    def sorted_eig(A):  # returns sorted eigenvalues (& their corresponding eignevectors) of A
        lambdas, vecs = LA.eig(A)
        # Next line just sorts values & vectors together in order of decreasing eigenvalues
        lambdas, vecs = zip(*sorted(zip(list(lambdas), list(vecs.T)),key=lambda x: x[0], reverse=True))
        return lambdas, np.array(vecs).T  # un-doing the list-casting from the previous line

    # In the next line, try putting "ImageOps.grayscale( )" around the "img" in front of the ".resize" ;-)
    imlist = [np.asarray( img.resize((18, 18), Image.ANTIALIAS)).flatten() # resize to tiny, then flatten to 1D
        for term in search_terms for img in dataset[term].images]
    images_array = np.array(imlist)
    print("images_array.shape = ",images_array.shape)

    im_cov = np.cov(images_array.T)   # get covariance matrix
    lambdas, vecs = sorted_eig(np.array(im_cov))  # get the eigenvectors
    W = vecs[:,0:2]                      # Grab the 2 most significant dimensions
    proj_img = np.array(images_array @ W, dtype=np.float32)  # Last step of PCA: projection

    xs=proj_img[:,0]  # this is for both classes together as one long array
    ys=proj_img[:,1]
    return xs, ys


def plot_hover(dataset):
    xs, ys = get_pca_xy()

    output_file("toolbar.html")

    colors = ["blue","red","green"]

    TOOLTIPS = """
        <div>
            <div>
                <img
                    src="@imgs" height="50" alt="@imgs"
                    style="float: left; margin: 0px 15px 15px 0px;"
                    border="2"
                ></img>
            </div>
            <div>
                <span style="font-size: 17px; font-weight: bold;">@desc</span>
                <span style="font-size: 15px; color: #966;">[$index]</span>
            </div>
            <!---commenting-out coordinate values <div>
                <span style="font-size: 10px; color: #696;">($x, $y)</span>
            </div> -->
        </div>
    """

    p = figure(400,400,  tooltips=TOOLTIPS, title="Mouse over the dots")

    start = 0    # where to read from x & y arrays
    for i, term in enumerate(search_terms):

        n = len(dataset[term].urls)  # TODO: stop using full image urls, better to use thumbnails

        #x, y = np.random.rand(n)+i/2, np.random.rand(n) # just random points for now
        x, y  = xs[start:start+n], ys[start:start+n]

        source = ColumnDataSource( data=dict(x=x, y=y, desc=[term]*n,
            imgs=dataset[term].urls) )

        p.circle('x', 'y', size=12, line_color=colors[i], fill_color=colors[i], source=source)
        start += n

    #show(p)
    return p



# Cell
from mpl_toolkits.mplot3d import axes3d

def plot_triangle():
    fig = plt.figure()
    ax = fig.add_subplot(111, projection = '3d')

    n = 1000
    logits = (np.random.rand(3,n)*2-1)*1
    maxl = np.max(logits, axis=0)
    probits = np.exp(logits-maxl)   # "subtract the max" trick for num. accuracy
    denom = np.sum(probits,axis=0)
    p = probits/denom

    # set colors by rgb depending on values of p
    colors = p.T
    print("colors.shape  = ",colors.shape)
    ax.scatter(p[0], p[1], p[2], facecolors=colors, marker='o', label='data')

    ax.set_xlabel('Cat-ness')
    ax.set_ylabel('Dog-ness')
    ax.set_zlabel('Horse-ness')
    plt.title("Sofmax Maps To:")
    plt.legend()
    plt.tight_layout()
    return plt
