# AUTOGENERATED! DO NOT EDIT! File to edit: nimport.ipynb (unless otherwise specified).

__all__ = ['nimport']

# Cell
import importlib, sys, subprocess, re

def nimport(import_str:str, consent:str='yes', verbosity:int=1, versions:str=''):
    """Nice Import: Gracefully import, i.e. if import fails, install via pip & retry

    args:
       import_str: A string form of the import statement you would otherwise execute

    kwargs:
        consent:    TODO: Let people say if they want to allow the install  ['yes','no','ask']
        verbosity:  How much logging to print: 0=silent+errors, 1=installs, 2=everything
        versions:   TODO: this would allow specific package versions to be specified

    This supports these possible syntaxes for import_str:

        from:   'from kora.selenium import wd'
        from-star:   'from fastai.vision.all import *'
           TODO:  from-list and/or sub-sub-modules: 'from x.y.z import a, b, c' - unsupported for now
        as:     'import numpy as np'
        list:   'import bokeh, mrspuff as msp, torch'    (include a 1-element list)

    ISSUES:
    * Some pip package names don't match their 'import' name. nimport won't handle that
       Example: BeautifulSoup: package is beautifulsoup4, import is bs4

    * This only pip-installs the named package, not any dependencies.
    """
    package, module, method, as_name = None, None, None, None

    # from-style import
    if 'from' in import_str:

        m = re.search('from (.+?) import', import_str)  # from package.module import method
        if m:
            module = m.group(1)                # The module we're importing from
            package = module.split('.')[0]     # The package we may need to install
            method = import_str.split('import ')[1]
            as_name = method
            if ' as ' in import_str:
                as_name = import_str.split('as ')[1]

            if verbosity > 1:
                    print(f"Package: {package}\nModule: {module}\nMethod: {method}\nas_name: {as_name}")

            try:
                if verbosity>1: print(f"Importing {module} as {as_name}")
                globals()[as_name] = importlib.import_module(module)
            except:
                if verbosity>0: print(f"  Import {module} failed. Trying to install {package} via pip")
                rc = subprocess.check_call([sys.executable, "-m", "pip", "install", package])
                if 0==rc:
                    if verbosity>0: print(f"     pip succeeded. Re-importing {module} as {as_name}")

                    if '*' != method:               # typical, non-star import
                        globals()[as_name] = importlib.import_module(module)
                    else:
                        # loop to add *'d items to global namespace
                        # following 10 lines from https://stackoverflow.com/a/43059528
                        mdl = importlib.import_module(module)

                        if "__all__" in mdl.__dict__:   # is there an __all__? if so use it
                            names = mdl.__dict__["__all__"]
                        else:
                            # otherwise import all names that don't begin with _
                            names = [x for x in mdl.__dict__ if not x.startswith("_")]

                        # add them to the global namespace
                        globals().update({k: getattr(mdl, k) for k in names})
                else:
                    assert False, f"ImportError: Unable to import {module}"

    # no 'from'
    else:       # generic imports, including in list form. supports "as" syntax
        package_list = import_str.replace(', ' , ',')       # strip spaces
        package_list = package_list.split('import ')[1].split(',')  # grab the list of packages
        if verbosity>1: print(f"package_list = {package_list}")
        for package in package_list:
            as_name = package
            if ' as ' in package:
                package, as_name = package.split(' as ')
            try:
                if verbosity>1: print(f"Importing {package} as {as_name}")
                globals()[as_name] = importlib.import_module(package)  # try to import
            except:
                if verbosity>0: print(f"   Import {package} failed. Trying to install via pip")
                rc = subprocess.check_call([sys.executable, "-m", "pip", "install", package])
                if 0==rc:
                    if verbosity>0: print(f"     pip succeeded. Re-importing {package} as {as_name}")
                    globals()[as_name] = importlib.import_module(package)
