"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstance`
 */
class DBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstance = new rds_generated_1.RosDBInstance(this, id, {
            periodType: props.periodType === undefined || props.periodType === null ? 'Month' : props.periodType,
            resourceGroupId: props.resourceGroupId,
            archiveBackupRetentionPeriod: props.archiveBackupRetentionPeriod,
            dbTimeZone: props.dbTimeZone,
            port: props.port,
            archiveBackupKeepCount: props.archiveBackupKeepCount,
            logBackupRetentionPeriod: props.logBackupRetentionPeriod,
            dbInstanceStorage: props.dbInstanceStorage,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz === undefined || props.multiAz === null ? false : props.multiAz,
            engine: props.engine,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            dbInstanceClass: props.dbInstanceClass,
            archiveBackupKeepPolicy: props.archiveBackupKeepPolicy,
            vSwitchId: props.vSwitchId,
            backupPolicyMode: props.backupPolicyMode,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            localLogRetentionHours: props.localLogRetentionHours,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            highSpaceUsageProtection: props.highSpaceUsageProtection,
            roleArn: props.roleArn,
            masterUserPassword: props.masterUserPassword,
            vpcId: props.vpcId,
            sslSetting: props.sslSetting === undefined || props.sslSetting === null ? 'Disabled' : props.sslSetting,
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            localLogRetentionSpace: props.localLogRetentionSpace,
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType === undefined || props.dbInstanceNetType === null ? 'Intranet' : props.dbInstanceNetType,
            releasedKeepPolicy: props.releasedKeepPolicy,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            logBackupLocalRetentionNumber: props.logBackupLocalRetentionNumber,
            slaveZoneIds: props.slaveZoneIds,
            securityIpList: props.securityIpList,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            maintainTime: props.maintainTime,
            dbParamGroupId: props.dbParamGroupId,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            securityGroupId: props.securityGroupId,
            dbInstanceStorageType: props.dbInstanceStorageType,
            backUpCategory: props.backUpCategory,
            compressType: props.compressType,
            logBackupFrequency: props.logBackupFrequency,
            connectionStringType: props.connectionStringType === undefined || props.connectionStringType === null ? 'Inner' : props.connectionStringType,
            masterUserType: props.masterUserType === undefined || props.masterUserType === null ? 'Normal' : props.masterUserType,
            serverlessConfig: props.serverlessConfig,
            enableBackupLog: props.enableBackupLog,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod === undefined || props.backupRetentionPeriod === null ? 7 : props.backupRetentionPeriod,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
        this.attrDbInstanceId = rosDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosDBInstance.attrInnerPort;
        this.attrPublicConnectionString = rosDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosDBInstance.attrPublicPort;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,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