"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Account = exports.AccountProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "AccountProperty", { enumerable: true, get: function () { return rds_generated_1.RosAccount; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::Account`
 */
class Account extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::Account`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccount = new rds_generated_1.RosAccount(this, id, {
            accountDescription: props.accountDescription,
            dbInstanceId: props.dbInstanceId,
            accountType: props.accountType === undefined || props.accountType === null ? 'Normal' : props.accountType,
            accountPassword: props.accountPassword,
            accountName: props.accountName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccount;
        this.attrAccountName = rosAccount.attrAccountName;
    }
}
exports.Account = Account;
//# sourceMappingURL=data:application/json;base64,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