# (C) Copyright 2005-2022 Enthought, Inc., Austin, TX
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in LICENSE.txt and may be redistributed only under
# the conditions described in the aforementioned license. The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
#
# Thanks for using Enthought open source!
import sys
import unittest

try:
    from pyface.qt import is_qt5, QtGui
except ImportError:
    is_qt5 = False

from kiva.tests.drawing_tester import DrawingImageTester

is_linux = sys.platform.startswith("linux")


@unittest.skipIf(not is_qt5, "Qt5 is required")
class TestQPainterDrawing(DrawingImageTester, unittest.TestCase):
    def setUp(self):
        application = QtGui.QApplication.instance()
        if application is None:
            self.application = QtGui.QApplication([])
        else:
            self.application = application

        DrawingImageTester.setUp(self)

    def create_graphics_context(self, width=600, height=600, pixel_scale=2.0):
        from kiva.qpainter import GraphicsContext

        return GraphicsContext((width, height), base_pixel_scale=pixel_scale)

    @unittest.skipIf(is_qt5 and is_linux, "Currently segfaulting")
    def test_text(self):
        super().test_text()

    @unittest.skipIf(is_qt5 and is_linux, "Currently segfaulting")
    def test_text_clip(self):
        super().test_text_clip()
