# This code is part of Qiskit.
#
# (C) Copyright IBM 2021.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

"""
=======================================================================================
Quantum Volume Experiment (:mod:`qiskit_experiments.library.quantum_volume`)
=======================================================================================

.. currentmodule:: qiskit_experiments.library.quantum_volume


Experiments
===========
.. autosummary::
    :toctree: ../stubs/
    :template: autosummary/experiment.rst

    QuantumVolume


Analysis
========

.. autosummary::
    :toctree: ../stubs/
    :template: autosummary/analysis.rst

    QuantumVolumeAnalysis
"""

from .qv_experiment import QuantumVolume
from .qv_analysis import QuantumVolumeAnalysis
