"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const backup = require("@aws-cdk/aws-backup");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 * @description creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery
 * enabled by default.
 */
class CompliantDynamoDb extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d;
        super(scope, id);
        this.dynamodbTable = new dynamodb.Table(this, 'DynamoDBTable', {
            tableName: props.tableName,
            billingMode: (_b = props.billingMode) !== null && _b !== void 0 ? _b : dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: (_c = props.partitionKey) !== null && _c !== void 0 ? _c : {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            pointInTimeRecovery: true,
        });
        const backupPlan = backup.BackupPlan.daily35DayRetention(this, 'BackupPlan', new backup.BackupVault(this, 'BackupVault', {
            backupVaultName: (_d = props.backupVaultName) !== null && _d !== void 0 ? _d : `${props.tableName}-backup-vault`,
            blockRecoveryPointDeletion: true,
        }));
        backupPlan.addSelection('DynamoDB', {
            resources: [backup.BackupResource.fromDynamoDbTable(this.dynamodbTable)],
        });
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "compliantdynamodb.CompliantDynamoDb", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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