"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withNamedNodeNamed = void 0;
const graphql_1 = require("graphql");
function withNamedNodeNamed(t, n) {
    switch (t.kind) {
        case graphql_1.Kind.NON_NULL_TYPE:
            return {
                ...t,
                type: withNamedNodeNamed(t.type, n),
            };
        case graphql_1.Kind.LIST_TYPE:
            return {
                ...t,
                type: withNamedNodeNamed(t.type, n),
            };
        case graphql_1.Kind.NAMED_TYPE:
            return {
                ...t,
                name: {
                    kind: graphql_1.Kind.NAME,
                    value: n,
                },
            };
    }
}
exports.withNamedNodeNamed = withNamedNodeNamed;
//# sourceMappingURL=nodeUtils.js.map