"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuroraServerlessMySQLDatabaseReader = void 0;
const RelationalDBSchemaTransformer_1 = require("./RelationalDBSchemaTransformer");
const RelationalDBSchemaTransformerUtils_1 = require("./RelationalDBSchemaTransformerUtils");
const AuroraDataAPIClient_1 = require("./AuroraDataAPIClient");
const graphql_transformer_common_1 = require("graphql-transformer-common");
class AuroraServerlessMySQLDatabaseReader {
    constructor(dbRegion, awsSecretStoreArn, dbClusterOrInstanceArn, database, aws) {
        this.hydrateTemplateContext = async (contextShell) => {
            contextShell.secretStoreArn = this.awsSecretStoreArn;
            contextShell.rdsClusterIdentifier = this.dbClusterOrInstanceArn;
            contextShell.databaseSchema = 'mysql';
            contextShell.databaseName = this.database;
            contextShell.region = this.dbRegion;
            return contextShell;
        };
        this.listTables = async () => {
            const results = await this.auroraClient.listTables();
            return results;
        };
        this.getTableForeignKeyReferences = async (tableName) => {
            const results = await this.auroraClient.getTableForeignKeyReferences(tableName);
            return results;
        };
        this.describeTable = async (tableName) => {
            const columnDescriptions = await this.auroraClient.describeTable(tableName);
            const fields = new Array();
            const updateFields = new Array();
            const createFields = new Array();
            let primaryKey = '';
            let primaryKeyType = '';
            const intFieldList = new Array();
            const stringFieldList = new Array();
            const formattedTableName = graphql_transformer_common_1.toUpper(tableName);
            for (const columnDescription of columnDescriptions) {
                if (columnDescription.Key == 'PRI') {
                    primaryKey = columnDescription.Field;
                    primaryKeyType = RelationalDBSchemaTransformerUtils_1.getGraphQLTypeFromMySQLType(columnDescription.Type);
                }
                else {
                    const type = RelationalDBSchemaTransformerUtils_1.getGraphQLTypeFromMySQLType(columnDescription.Type);
                    if (type === 'Int') {
                        intFieldList.push(columnDescription.Field);
                    }
                    else if (type === 'String') {
                        stringFieldList.push(columnDescription.Field);
                    }
                }
                const baseType = RelationalDBSchemaTransformerUtils_1.getNamedType(RelationalDBSchemaTransformerUtils_1.getGraphQLTypeFromMySQLType(columnDescription.Type));
                const isPrimaryKey = columnDescription.Key == 'PRI';
                const isNullable = columnDescription.Null == 'YES';
                const type = !isPrimaryKey && isNullable ? baseType : RelationalDBSchemaTransformerUtils_1.getNonNullType(baseType);
                fields.push(RelationalDBSchemaTransformerUtils_1.getFieldDefinition(columnDescription.Field, type));
                createFields.push(RelationalDBSchemaTransformerUtils_1.getInputValueDefinition(type, columnDescription.Field));
                const updateType = !isPrimaryKey ? baseType : RelationalDBSchemaTransformerUtils_1.getNonNullType(baseType);
                updateFields.push(RelationalDBSchemaTransformerUtils_1.getInputValueDefinition(updateType, columnDescription.Field));
            }
            return new RelationalDBSchemaTransformer_1.TableContext(RelationalDBSchemaTransformerUtils_1.getTypeDefinition(fields, tableName), RelationalDBSchemaTransformerUtils_1.getInputTypeDefinition(createFields, `Create${formattedTableName}Input`), RelationalDBSchemaTransformerUtils_1.getInputTypeDefinition(updateFields, `Update${formattedTableName}Input`), primaryKey, primaryKeyType, stringFieldList, intFieldList);
        };
        this.auroraClient = new AuroraDataAPIClient_1.AuroraDataAPIClient(dbRegion, awsSecretStoreArn, dbClusterOrInstanceArn, database, aws);
        this.dbRegion = dbRegion;
        this.awsSecretStoreArn = awsSecretStoreArn;
        this.dbClusterOrInstanceArn = dbClusterOrInstanceArn;
        this.database = database;
    }
    setAuroraClient(auroraClient) {
        this.auroraClient = auroraClient;
    }
}
exports.AuroraServerlessMySQLDatabaseReader = AuroraServerlessMySQLDatabaseReader;
//# sourceMappingURL=AuroraServerlessMySQLDatabaseReader.js.map