#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['scirpy',
 'scirpy._plotting',
 'scirpy._preprocessing',
 'scirpy._tools',
 'scirpy.datasets',
 'scirpy.io',
 'scirpy.io._tracerlib',
 'scirpy.ir_dist',
 'scirpy.tests',
 'scirpy.util',
 'scirpy.util.graph']

package_data = \
{'': ['*'],
 'scirpy.datasets': ['_processing_scripts/*'],
 'scirpy.tests': ['data/*',
                  'data/10x/*',
                  'data/airr/*',
                  'data/bracer/*',
                  'data/test_workflow/*',
                  'data/tracer/*',
                  'data/tracer/SRR10782570/*',
                  'data/tracer/SRR10782570/filtered_TCR_seqs/*',
                  'data/tracer/cell1/*',
                  'data/tracer/cell1/filtered_TCR_seqs/*',
                  'data/tracer/cell2/*',
                  'data/tracer/cell2/filtered_TCR_seqs/*']}

install_requires = \
['anndata>=0.7.6',
 'scanpy>=1.6.0',
 'pandas>=1.0',
 'numpy>=1.17.0',
 'scipy',
 'parasail != 1.2.1',
 'scikit-learn',
 'python-levenshtein',
 'python-igraph',
 'networkx',
 'squarify',
 'airr>=1.2',
 'tqdm>=4.42.0',
 'setuptools_scm',
 'pytoml']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=0.7'],
 ':sys_platform == "win32"': ['pycairo>=1.20'],
 'dandelion': ['sc-dandelion', 'adjusttext'],
 'doc': ['sphinx>=3.0.1,<3.1',
         'sphinx_autodoc_typehints>=1.8.0',
         'scanpydoc>=0.6',
         'sphinx_rtd_theme>=0.4,<0.5',
         'leidenalg',
         'nbsphinx>=0.6.0',
         'jupytext',
         'sphinxcontrib-bibtex>=1.0.0',
         'pycairo',
         'jupyter_client',
         'ipykernel',
         'sc-dandelion',
         'adjusttext'],
 'doc:python_version < "3.8"': ['typing_extensions'],
 'rpack': ['rectangle-packer'],
 'test': ['pytest', 'black']}

setup(name='scirpy',
      version='0.7.0',
      description='Python library for single-cell adaptive immune receptor repertoire (AIRR) analysis',
      author='Gregor Sturm, Tamas Szabo',
      author_email='gregor.sturm@i-med.ac.at',
      url='https://github.com/grst/scirpy',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>= 3.7',
     )
