# Welcome to Golem Garden 🌱

Golem Garden is a Python project designed to manage a menagerie of GPT-enabled chatbots called "Golems" and a swarm of
simple Python scripts enacting "Beetles". It provides a powerful and flexible framework for creating and interacting
with these chatbots while addressing the novel opportunities and challenges associated with API calls to large language
models like OpenAI's GPT.

## Features

- Golem Factory: Easily create Golems based on TOML config files.
- Context Database: Save interactions between users and Golems in a JSON format.
- Command-line Interface: Interact with different Golems through a basic command-line interface.
- Specialist Golems: Pre-built Golems with unique personalities and activities.
- Extensibility: Implement the Beetle class for Python-based modules with a Beetle brain script.

## Getting Started

- [Installation](user_guide/installation.md): Learn how to install Golem Garden.
- [Usage](user_guide/usage.md): Understand how to use Golem Garden to create and interact with Golems.

## API Reference

- [API Reference](api_reference.md): Dive into the detailed documentation of Golem Garden's components.

## Contributing

- [Contributing](development/contributing.md): Get involved with the project and help us improve Golem Garden.
