/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.IndentingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class TwoColumnOutput {
    private final Writer out;
    private final int leftWidth;
    private final StringBuffer leftBuf;
    private final StringBuffer rightBuf;
    private final IndentingWriter leftColumn;
    private final IndentingWriter rightColumn;

    public static String toString(String string, int n, String string2, String string3, int n2) {
        int n3 = string.length();
        int n4 = string3.length();
        StringWriter stringWriter = new StringWriter((n3 + n4) * 3);
        TwoColumnOutput twoColumnOutput = new TwoColumnOutput(stringWriter, n, n2, string2);
        try {
            twoColumnOutput.getLeft().write(string);
            twoColumnOutput.getRight().write(string3);
        }
        catch (IOException iOException) {
            throw new RuntimeException("shouldn't happen", iOException);
        }
        twoColumnOutput.flush();
        return stringWriter.toString();
    }

    public TwoColumnOutput(Writer writer, int n, int n2, String string) {
        if (writer == null) {
            throw new NullPointerException("out == null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("leftWidth < 1");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("rightWidth < 1");
        }
        if (string == null) {
            throw new NullPointerException("spacer == null");
        }
        StringWriter stringWriter = new StringWriter(1000);
        StringWriter stringWriter2 = new StringWriter(1000);
        this.out = writer;
        this.leftWidth = n;
        this.leftBuf = stringWriter.getBuffer();
        this.rightBuf = stringWriter2.getBuffer();
        this.leftColumn = new IndentingWriter(stringWriter, n);
        this.rightColumn = new IndentingWriter(stringWriter2, n2, string);
    }

    public TwoColumnOutput(OutputStream outputStream, int n, int n2, String string) {
        this(new OutputStreamWriter(outputStream), n, n2, string);
    }

    public Writer getLeft() {
        return this.leftColumn;
    }

    public Writer getRight() {
        return this.rightColumn;
    }

    public void flush() {
        try {
            TwoColumnOutput.appendNewlineIfNecessary(this.leftBuf, this.leftColumn);
            TwoColumnOutput.appendNewlineIfNecessary(this.rightBuf, this.rightColumn);
            this.outputFullLines();
            this.flushLeft();
            this.flushRight();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void outputFullLines() throws IOException {
        int n;
        while ((n = this.leftBuf.indexOf("\n")) >= 0) {
            int n2 = this.rightBuf.indexOf("\n");
            if (n2 < 0) {
                return;
            }
            if (n != 0) {
                this.out.write(this.leftBuf.substring(0, n));
            }
            if (n2 != 0) {
                TwoColumnOutput.writeSpaces(this.out, this.leftWidth - n);
                this.out.write(this.rightBuf.substring(0, n2));
            }
            this.out.write(10);
            this.leftBuf.delete(0, n + 1);
            this.rightBuf.delete(0, n2 + 1);
        }
        return;
    }

    private void flushLeft() throws IOException {
        TwoColumnOutput.appendNewlineIfNecessary(this.leftBuf, this.leftColumn);
        while (this.leftBuf.length() != 0) {
            this.rightColumn.write(10);
            this.outputFullLines();
        }
    }

    private void flushRight() throws IOException {
        TwoColumnOutput.appendNewlineIfNecessary(this.rightBuf, this.rightColumn);
        while (this.rightBuf.length() != 0) {
            this.leftColumn.write(10);
            this.outputFullLines();
        }
    }

    private static void appendNewlineIfNecessary(StringBuffer stringBuffer, Writer writer) throws IOException {
        int n = stringBuffer.length();
        if (n != 0 && stringBuffer.charAt(n - 1) != '\n') {
            writer.write(10);
        }
    }

    private static void writeSpaces(Writer writer, int n) throws IOException {
        while (n > 0) {
            writer.write(32);
            --n;
        }
    }
}

