/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;
import java.util.BitSet;

public class SCCP {
    private static final int TOP = 0;
    private static final int CONSTANT = 1;
    private static final int VARYING = 2;
    private SsaMethod ssaMeth;
    private int regCount;
    private int[] latticeValues;
    private Constant[] latticeConstants;
    private ArrayList<SsaBasicBlock> cfgWorklist;
    private ArrayList<SsaBasicBlock> cfgPhiWorklist;
    private BitSet executableBlocks;
    private ArrayList<SsaInsn> ssaWorklist;
    private ArrayList<SsaInsn> varyingWorklist;
    private ArrayList<SsaInsn> branchWorklist;

    private SCCP(SsaMethod ssaMethod) {
        this.ssaMeth = ssaMethod;
        this.regCount = ssaMethod.getRegCount();
        this.latticeValues = new int[this.regCount];
        this.latticeConstants = new Constant[this.regCount];
        this.cfgWorklist = new ArrayList();
        this.cfgPhiWorklist = new ArrayList();
        this.executableBlocks = new BitSet(ssaMethod.getBlocks().size());
        this.ssaWorklist = new ArrayList();
        this.varyingWorklist = new ArrayList();
        this.branchWorklist = new ArrayList();
        for (int i = 0; i < this.regCount; ++i) {
            this.latticeValues[i] = 0;
            this.latticeConstants[i] = null;
        }
    }

    public static void process(SsaMethod ssaMethod) {
        new SCCP(ssaMethod).run();
    }

    private void addBlockToWorklist(SsaBasicBlock ssaBasicBlock) {
        if (!this.executableBlocks.get(ssaBasicBlock.getIndex())) {
            this.cfgWorklist.add(ssaBasicBlock);
            this.executableBlocks.set(ssaBasicBlock.getIndex());
        } else {
            this.cfgPhiWorklist.add(ssaBasicBlock);
        }
    }

    private void addUsersToWorklist(int n, int n2) {
        if (n2 == 2) {
            for (SsaInsn ssaInsn : this.ssaMeth.getUseListForRegister(n)) {
                this.varyingWorklist.add(ssaInsn);
            }
        } else {
            for (SsaInsn ssaInsn : this.ssaMeth.getUseListForRegister(n)) {
                this.ssaWorklist.add(ssaInsn);
            }
        }
    }

    private boolean setLatticeValueTo(int n, int n2, Constant constant) {
        if (n2 != 1) {
            if (this.latticeValues[n] != n2) {
                this.latticeValues[n] = n2;
                return true;
            }
            return false;
        }
        if (this.latticeValues[n] != n2 || !this.latticeConstants[n].equals(constant)) {
            this.latticeValues[n] = n2;
            this.latticeConstants[n] = constant;
            return true;
        }
        return false;
    }

    private void simulatePhi(PhiInsn phiInsn) {
        int n = phiInsn.getResult().getReg();
        if (this.latticeValues[n] == 2) {
            return;
        }
        RegisterSpecList registerSpecList = phiInsn.getSources();
        int n2 = 0;
        Constant constant = null;
        int n3 = registerSpecList.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = phiInsn.predBlockIndexForSourcesIndex(i);
            int n5 = registerSpecList.get(i).getReg();
            int n6 = this.latticeValues[n5];
            if (!this.executableBlocks.get(n4)) continue;
            if (n6 == 1) {
                if (constant == null) {
                    constant = this.latticeConstants[n5];
                    n2 = 1;
                    continue;
                }
                if (this.latticeConstants[n5].equals(constant)) continue;
                n2 = 2;
                break;
            }
            n2 = n6;
            break;
        }
        if (this.setLatticeValueTo(n, n2, constant)) {
            this.addUsersToWorklist(n, n2);
        }
    }

    private void simulateBlock(SsaBasicBlock ssaBasicBlock) {
        for (SsaInsn ssaInsn : ssaBasicBlock.getInsns()) {
            if (ssaInsn instanceof PhiInsn) {
                this.simulatePhi((PhiInsn)ssaInsn);
                continue;
            }
            this.simulateStmt(ssaInsn);
        }
    }

    private void simulatePhiBlock(SsaBasicBlock ssaBasicBlock) {
        for (SsaInsn ssaInsn : ssaBasicBlock.getInsns()) {
            if (ssaInsn instanceof PhiInsn) {
                this.simulatePhi((PhiInsn)ssaInsn);
                continue;
            }
            return;
        }
    }

    private static String latticeValName(int n) {
        switch (n) {
            case 0: {
                return "TOP";
            }
            case 1: {
                return "CONSTANT";
            }
            case 2: {
                return "VARYING";
            }
        }
        return "UNKNOWN";
    }

    private void simulateBranch(SsaInsn ssaInsn) {
        Object object;
        Rop rop = ssaInsn.getOpcode();
        RegisterSpecList registerSpecList = ssaInsn.getSources();
        boolean bl = false;
        boolean bl2 = false;
        if (rop.getBranchingness() == 4) {
            int n;
            object = null;
            Constant constant = null;
            RegisterSpec registerSpec = registerSpecList.get(0);
            int n2 = registerSpec.getReg();
            if (!this.ssaMeth.isRegALocal(registerSpec) && this.latticeValues[n2] == 1) {
                object = this.latticeConstants[n2];
            }
            if (registerSpecList.size() == 2) {
                RegisterSpec registerSpec2 = registerSpecList.get(1);
                n = registerSpec2.getReg();
                if (!this.ssaMeth.isRegALocal(registerSpec2) && this.latticeValues[n] == 1) {
                    constant = this.latticeConstants[n];
                }
            }
            if (object != null && registerSpecList.size() == 1) {
                block0 : switch (((TypedConstant)object).getBasicType()) {
                    case 6: {
                        bl = true;
                        int n3 = ((CstInteger)object).getValue();
                        switch (rop.getOpcode()) {
                            case 7: {
                                bl2 = n3 == 0;
                                break block0;
                            }
                            case 8: {
                                bl2 = n3 != 0;
                                break block0;
                            }
                            case 9: {
                                bl2 = n3 < 0;
                                break block0;
                            }
                            case 10: {
                                bl2 = n3 >= 0;
                                break block0;
                            }
                            case 11: {
                                bl2 = n3 <= 0;
                                break block0;
                            }
                            case 12: {
                                bl2 = n3 > 0;
                                break block0;
                            }
                        }
                        throw new RuntimeException("Unexpected op");
                    }
                }
            } else if (object != null && constant != null) {
                block11 : switch (((TypedConstant)object).getBasicType()) {
                    case 6: {
                        bl = true;
                        int n4 = ((CstInteger)object).getValue();
                        n = ((CstInteger)constant).getValue();
                        switch (rop.getOpcode()) {
                            case 7: {
                                bl2 = n4 == n;
                                break block11;
                            }
                            case 8: {
                                bl2 = n4 != n;
                                break block11;
                            }
                            case 9: {
                                bl2 = n4 < n;
                                break block11;
                            }
                            case 10: {
                                bl2 = n4 >= n;
                                break block11;
                            }
                            case 11: {
                                bl2 = n4 <= n;
                                break block11;
                            }
                            case 12: {
                                bl2 = n4 > n;
                                break block11;
                            }
                        }
                        throw new RuntimeException("Unexpected op");
                    }
                }
            }
        }
        object = ssaInsn.getBlock();
        if (bl) {
            int n = bl2 ? ((SsaBasicBlock)object).getSuccessorList().get(1) : ((SsaBasicBlock)object).getSuccessorList().get(0);
            this.addBlockToWorklist(this.ssaMeth.getBlocks().get(n));
            this.branchWorklist.add(ssaInsn);
        } else {
            for (int i = 0; i < ((SsaBasicBlock)object).getSuccessorList().size(); ++i) {
                int n = ((SsaBasicBlock)object).getSuccessorList().get(i);
                this.addBlockToWorklist(this.ssaMeth.getBlocks().get(n));
            }
        }
    }

    private Constant simulateMath(SsaInsn ssaInsn, int n) {
        Constant constant;
        Insn insn = ssaInsn.getOriginalRopInsn();
        int n2 = ssaInsn.getOpcode().getOpcode();
        RegisterSpecList registerSpecList = ssaInsn.getSources();
        int n3 = registerSpecList.get(0).getReg();
        Constant constant2 = this.latticeValues[n3] != 1 ? null : this.latticeConstants[n3];
        if (registerSpecList.size() == 1) {
            CstInsn cstInsn = (CstInsn)insn;
            constant = cstInsn.getConstant();
        } else {
            int n4 = registerSpecList.get(1).getReg();
            constant = this.latticeValues[n4] != 1 ? null : this.latticeConstants[n4];
        }
        if (constant2 == null || constant == null) {
            return null;
        }
        switch (n) {
            case 6: {
                int n5;
                boolean bl = false;
                int n6 = ((CstInteger)constant2).getValue();
                int n7 = ((CstInteger)constant).getValue();
                switch (n2) {
                    case 14: {
                        n5 = n6 + n7;
                        break;
                    }
                    case 15: {
                        if (registerSpecList.size() == 1) {
                            n5 = n7 - n6;
                            break;
                        }
                        n5 = n6 - n7;
                        break;
                    }
                    case 16: {
                        n5 = n6 * n7;
                        break;
                    }
                    case 17: {
                        if (n7 == 0) {
                            bl = true;
                            n5 = 0;
                            break;
                        }
                        n5 = n6 / n7;
                        break;
                    }
                    case 20: {
                        n5 = n6 & n7;
                        break;
                    }
                    case 21: {
                        n5 = n6 | n7;
                        break;
                    }
                    case 22: {
                        n5 = n6 ^ n7;
                        break;
                    }
                    case 23: {
                        n5 = n6 << n7;
                        break;
                    }
                    case 24: {
                        n5 = n6 >> n7;
                        break;
                    }
                    case 25: {
                        n5 = n6 >>> n7;
                        break;
                    }
                    case 18: {
                        if (n7 == 0) {
                            bl = true;
                            n5 = 0;
                            break;
                        }
                        n5 = n6 % n7;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected op");
                    }
                }
                return bl ? null : CstInteger.make(n5);
            }
        }
        return null;
    }

    private void simulateStmt(SsaInsn ssaInsn) {
        Insn insn = ssaInsn.getOriginalRopInsn();
        if (insn.getOpcode().getBranchingness() != 1 || insn.getOpcode().isCallLike()) {
            this.simulateBranch(ssaInsn);
        }
        int n = ssaInsn.getOpcode().getOpcode();
        RegisterSpec registerSpec = ssaInsn.getResult();
        if (registerSpec == null) {
            if (n == 17 || n == 18) {
                SsaBasicBlock ssaBasicBlock = ssaInsn.getBlock().getPrimarySuccessor();
                registerSpec = ssaBasicBlock.getInsns().get(0).getResult();
            } else {
                return;
            }
        }
        int n2 = registerSpec.getReg();
        int n3 = 2;
        Constant constant = null;
        switch (n) {
            case 5: {
                CstInsn cstInsn = (CstInsn)insn;
                n3 = 1;
                constant = cstInsn.getConstant();
                break;
            }
            case 2: {
                if (ssaInsn.getSources().size() != 1) break;
                int n4 = ssaInsn.getSources().get(0).getReg();
                n3 = this.latticeValues[n4];
                constant = this.latticeConstants[n4];
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                constant = this.simulateMath(ssaInsn, registerSpec.getBasicType());
                if (constant == null) break;
                n3 = 1;
                break;
            }
            case 56: {
                if (this.latticeValues[n2] != 1) break;
                n3 = this.latticeValues[n2];
                constant = this.latticeConstants[n2];
                break;
            }
        }
        if (this.setLatticeValueTo(n2, n3, constant)) {
            this.addUsersToWorklist(n2, n3);
        }
    }

    private void run() {
        SsaBasicBlock ssaBasicBlock = this.ssaMeth.getEntryBlock();
        this.addBlockToWorklist(ssaBasicBlock);
        while (!(this.cfgWorklist.isEmpty() && this.cfgPhiWorklist.isEmpty() && this.ssaWorklist.isEmpty() && this.varyingWorklist.isEmpty())) {
            Object object;
            int n;
            while (!this.cfgWorklist.isEmpty()) {
                n = this.cfgWorklist.size() - 1;
                object = this.cfgWorklist.remove(n);
                this.simulateBlock((SsaBasicBlock)object);
            }
            while (!this.cfgPhiWorklist.isEmpty()) {
                n = this.cfgPhiWorklist.size() - 1;
                object = this.cfgPhiWorklist.remove(n);
                this.simulatePhiBlock((SsaBasicBlock)object);
            }
            while (!this.varyingWorklist.isEmpty()) {
                n = this.varyingWorklist.size() - 1;
                object = this.varyingWorklist.remove(n);
                if (!this.executableBlocks.get(((SsaInsn)object).getBlock().getIndex())) continue;
                if (object instanceof PhiInsn) {
                    this.simulatePhi((PhiInsn)object);
                    continue;
                }
                this.simulateStmt((SsaInsn)object);
            }
            while (!this.ssaWorklist.isEmpty()) {
                n = this.ssaWorklist.size() - 1;
                object = this.ssaWorklist.remove(n);
                if (!this.executableBlocks.get(((SsaInsn)object).getBlock().getIndex())) continue;
                if (object instanceof PhiInsn) {
                    this.simulatePhi((PhiInsn)object);
                    continue;
                }
                this.simulateStmt((SsaInsn)object);
            }
        }
        this.replaceConstants();
        this.replaceBranches();
    }

    private void replaceConstants() {
        for (int i = 0; i < this.regCount; ++i) {
            SsaInsn ssaInsn;
            TypeBearer typeBearer;
            if (this.latticeValues[i] != 1 || !(this.latticeConstants[i] instanceof TypedConstant) || (typeBearer = (ssaInsn = this.ssaMeth.getDefinitionForRegister(i)).getResult().getTypeBearer()).isConstant()) continue;
            RegisterSpec registerSpec = ssaInsn.getResult();
            RegisterSpec registerSpec2 = registerSpec.withType((TypedConstant)this.latticeConstants[i]);
            ssaInsn.setResult(registerSpec2);
            for (SsaInsn ssaInsn2 : this.ssaMeth.getUseListForRegister(i)) {
                if (ssaInsn2.isPhiOrMove()) continue;
                NormalSsaInsn normalSsaInsn = (NormalSsaInsn)ssaInsn2;
                RegisterSpecList registerSpecList = ssaInsn2.getSources();
                int n = registerSpecList.indexOfRegister(i);
                RegisterSpec registerSpec3 = registerSpecList.get(n);
                RegisterSpec registerSpec4 = registerSpec3.withType((TypedConstant)this.latticeConstants[i]);
                normalSsaInsn.changeOneSource(n, registerSpec4);
            }
        }
    }

    private void replaceBranches() {
        for (SsaInsn ssaInsn : this.branchWorklist) {
            int n = -1;
            SsaBasicBlock ssaBasicBlock = ssaInsn.getBlock();
            int n2 = ssaBasicBlock.getSuccessorList().size();
            for (int i = 0; i < n2; ++i) {
                int n3 = ssaBasicBlock.getSuccessorList().get(i);
                if (this.executableBlocks.get(n3)) continue;
                n = n3;
            }
            if (n2 != 2 || n == -1) continue;
            Insn insn = ssaInsn.getOriginalRopInsn();
            ssaBasicBlock.replaceLastInsn(new PlainInsn(Rops.GOTO, insn.getPosition(), null, RegisterSpecList.EMPTY));
            ssaBasicBlock.removeSuccessor(n);
        }
    }
}

