/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.type;

import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import java.util.HashMap;

public final class Prototype
implements Comparable<Prototype> {
    private static final HashMap<String, Prototype> internTable = new HashMap(500);
    private final String descriptor;
    private final Type returnType;
    private final StdTypeList parameterTypes;
    private StdTypeList parameterFrameTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prototype intern(String string) {
        if (string == null) {
            throw new NullPointerException("descriptor == null");
        }
        Type[] typeArray = internTable;
        synchronized (internTable) {
            int n;
            Prototype prototype = internTable.get(string);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (prototype != null) {
                return prototype;
            }
            typeArray = Prototype.makeParameterArray(string);
            int n2 = 0;
            int n3 = 1;
            while (true) {
                int n4 = n3;
                char c = string.charAt(n3);
                if (c == ')') break;
                while (c == '[') {
                    c = string.charAt(++n3);
                }
                if (c == 'L') {
                    n = string.indexOf(59, n3);
                    if (n == -1) {
                        throw new IllegalArgumentException("bad descriptor");
                    }
                    n3 = n + 1;
                } else {
                    ++n3;
                }
                typeArray[n2] = Type.intern(string.substring(n4, n3));
                ++n2;
            }
            Type type = Type.internReturnType(string.substring(++n3));
            StdTypeList stdTypeList = new StdTypeList(n2);
            for (n = 0; n < n2; ++n) {
                stdTypeList.set(n, typeArray[n]);
            }
            prototype = new Prototype(string, type, stdTypeList);
            return Prototype.putIntern(prototype);
        }
    }

    private static Type[] makeParameterArray(String string) {
        int n = string.length();
        if (string.charAt(0) != '(') {
            throw new IllegalArgumentException("bad descriptor");
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ')') {
                n2 = i;
                break;
            }
            if (c < 'A' || c > 'Z') continue;
            ++n3;
        }
        if (n2 == 0 || n2 == n - 1) {
            throw new IllegalArgumentException("bad descriptor");
        }
        if (string.indexOf(41, n2 + 1) != -1) {
            throw new IllegalArgumentException("bad descriptor");
        }
        return new Type[n3];
    }

    public static Prototype intern(String string, Type type, boolean bl, boolean bl2) {
        Prototype prototype = Prototype.intern(string);
        if (bl) {
            return prototype;
        }
        if (bl2) {
            type = type.asUninitialized(Integer.MAX_VALUE);
        }
        return prototype.withFirstParameter(type);
    }

    public static Prototype internInts(Type type, int n) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('I');
        }
        stringBuffer.append(')');
        stringBuffer.append(type.getDescriptor());
        return Prototype.intern(stringBuffer.toString());
    }

    private Prototype(String string, Type type, StdTypeList stdTypeList) {
        if (string == null) {
            throw new NullPointerException("descriptor == null");
        }
        if (type == null) {
            throw new NullPointerException("returnType == null");
        }
        if (stdTypeList == null) {
            throw new NullPointerException("parameterTypes == null");
        }
        this.descriptor = string;
        this.returnType = type;
        this.parameterTypes = stdTypeList;
        this.parameterFrameTypes = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Prototype)) {
            return false;
        }
        return this.descriptor.equals(((Prototype)object).descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public int compareTo(Prototype prototype) {
        if (this == prototype) {
            return 0;
        }
        int n = this.returnType.compareTo(prototype.returnType);
        if (n != 0) {
            return n;
        }
        int n2 = this.parameterTypes.size();
        int n3 = prototype.parameterTypes.size();
        int n4 = Math.min(n2, n3);
        for (int i = 0; i < n4; ++i) {
            Type type;
            Type type2 = this.parameterTypes.get(i);
            n = type2.compareTo(type = prototype.parameterTypes.get(i));
            if (n == 0) continue;
            return n;
        }
        if (n2 < n3) {
            return -1;
        }
        if (n2 > n3) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.descriptor;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public StdTypeList getParameterTypes() {
        return this.parameterTypes;
    }

    public StdTypeList getParameterFrameTypes() {
        if (this.parameterFrameTypes == null) {
            int n = this.parameterTypes.size();
            StdTypeList stdTypeList = new StdTypeList(n);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                Type type = this.parameterTypes.get(i);
                if (type.isIntlike()) {
                    bl = true;
                    type = Type.INT;
                }
                stdTypeList.set(i, type);
            }
            this.parameterFrameTypes = bl ? stdTypeList : this.parameterTypes;
        }
        return this.parameterFrameTypes;
    }

    public Prototype withFirstParameter(Type type) {
        String string = "(" + type.getDescriptor() + this.descriptor.substring(1);
        StdTypeList stdTypeList = this.parameterTypes.withFirst(type);
        stdTypeList.setImmutable();
        Prototype prototype = new Prototype(string, this.returnType, stdTypeList);
        return Prototype.putIntern(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Prototype putIntern(Prototype prototype) {
        HashMap<String, Prototype> hashMap = internTable;
        synchronized (hashMap) {
            String string = prototype.getDescriptor();
            Prototype prototype2 = internTable.get(string);
            if (prototype2 != null) {
                return prototype2;
            }
            internTable.put(string, prototype);
            return prototype;
        }
    }
}

