/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.CstLiteral32;
import com.android.dx.rop.type.Type;
import com.android.dx.util.Hex;

public final class CstByte
extends CstLiteral32 {
    public static final CstByte VALUE_0 = CstByte.make((byte)0);

    public static CstByte make(byte by) {
        return new CstByte(by);
    }

    public static CstByte make(int n) {
        byte by = (byte)n;
        if (by != n) {
            throw new IllegalArgumentException("bogus byte value: " + n);
        }
        return CstByte.make(by);
    }

    private CstByte(byte by) {
        super(by);
    }

    public String toString() {
        int n = this.getIntBits();
        return "byte{0x" + Hex.u1(n) + " / " + n + '}';
    }

    @Override
    public Type getType() {
        return Type.BYTE;
    }

    @Override
    public String typeName() {
        return "byte";
    }

    @Override
    public String toHuman() {
        return Integer.toString(this.getIntBits());
    }

    public byte getValue() {
        return (byte)this.getIntBits();
    }
}

